package androidx.fragment.app;

import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.os.e;
import androidx.core.view.r0;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public abstract class c0 {

    /* renamed from: a  reason: collision with root package name */
    private final ViewGroup f2987a;

    /* renamed from: b  reason: collision with root package name */
    final ArrayList f2988b = new ArrayList();

    /* renamed from: c  reason: collision with root package name */
    final ArrayList f2989c = new ArrayList();

    /* renamed from: d  reason: collision with root package name */
    boolean f2990d = false;

    /* renamed from: e  reason: collision with root package name */
    boolean f2991e = false;

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class a implements Runnable {

        /* renamed from: g  reason: collision with root package name */
        final /* synthetic */ d f2992g;

        a(d dVar) {
            this.f2992g = dVar;
        }

        @Override // java.lang.Runnable
        public void run() {
            if (c0.this.f2988b.contains(this.f2992g)) {
                this.f2992g.e().b(this.f2992g.f().mView);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class b implements Runnable {

        /* renamed from: g  reason: collision with root package name */
        final /* synthetic */ d f2994g;

        b(d dVar) {
            this.f2994g = dVar;
        }

        @Override // java.lang.Runnable
        public void run() {
            c0.this.f2988b.remove(this.f2994g);
            c0.this.f2989c.remove(this.f2994g);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static /* synthetic */ class c {

        /* renamed from: a  reason: collision with root package name */
        static final /* synthetic */ int[] f2996a;

        /* renamed from: b  reason: collision with root package name */
        static final /* synthetic */ int[] f2997b;

        static {
            int[] iArr = new int[e.b.values().length];
            f2997b = iArr;
            try {
                iArr[e.b.ADDING.ordinal()] = 1;
            } catch (NoSuchFieldError unused) {
            }
            try {
                f2997b[e.b.REMOVING.ordinal()] = 2;
            } catch (NoSuchFieldError unused2) {
            }
            try {
                f2997b[e.b.NONE.ordinal()] = 3;
            } catch (NoSuchFieldError unused3) {
            }
            int[] iArr2 = new int[e.c.values().length];
            f2996a = iArr2;
            try {
                iArr2[e.c.REMOVED.ordinal()] = 1;
            } catch (NoSuchFieldError unused4) {
            }
            try {
                f2996a[e.c.VISIBLE.ordinal()] = 2;
            } catch (NoSuchFieldError unused5) {
            }
            try {
                f2996a[e.c.GONE.ordinal()] = 3;
            } catch (NoSuchFieldError unused6) {
            }
            try {
                f2996a[e.c.INVISIBLE.ordinal()] = 4;
            } catch (NoSuchFieldError unused7) {
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class d extends e {

        /* renamed from: h  reason: collision with root package name */
        private final u f2998h;

        d(e.c cVar, e.b bVar, u uVar, androidx.core.os.e eVar) {
            super(cVar, bVar, uVar.k(), eVar);
            this.f2998h = uVar;
        }

        @Override // androidx.fragment.app.c0.e
        public void c() {
            super.c();
            this.f2998h.m();
        }

        @Override // androidx.fragment.app.c0.e
        void l() {
            if (g() == e.b.ADDING) {
                Fragment k10 = this.f2998h.k();
                View findFocus = k10.mView.findFocus();
                if (findFocus != null) {
                    k10.setFocusedView(findFocus);
                    if (n.F0(2)) {
                        Log.v("FragmentManager", "requestFocus: Saved focused view " + findFocus + " for Fragment " + k10);
                    }
                }
                View requireView = f().requireView();
                if (requireView.getParent() == null) {
                    this.f2998h.b();
                    requireView.setAlpha(0.0f);
                }
                if (requireView.getAlpha() == 0.0f && requireView.getVisibility() == 0) {
                    requireView.setVisibility(4);
                }
                requireView.setAlpha(k10.getPostOnViewCreatedAlpha());
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class e {

        /* renamed from: a  reason: collision with root package name */
        private c f2999a;

        /* renamed from: b  reason: collision with root package name */
        private b f3000b;

        /* renamed from: c  reason: collision with root package name */
        private final Fragment f3001c;

        /* renamed from: d  reason: collision with root package name */
        private final List f3002d = new ArrayList();

        /* renamed from: e  reason: collision with root package name */
        private final HashSet f3003e = new HashSet();

        /* renamed from: f  reason: collision with root package name */
        private boolean f3004f = false;

        /* renamed from: g  reason: collision with root package name */
        private boolean f3005g = false;

        /* loaded from: classes.dex */
        class a implements e.a {
            a() {
            }

            @Override // androidx.core.os.e.a
            public void onCancel() {
                e.this.b();
            }
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        /* loaded from: classes.dex */
        public enum b {
            NONE,
            ADDING,
            REMOVING
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        /* loaded from: classes.dex */
        public enum c {
            REMOVED,
            VISIBLE,
            GONE,
            INVISIBLE;

            /* JADX INFO: Access modifiers changed from: package-private */
            public static c g(int i10) {
                if (i10 != 0) {
                    if (i10 != 4) {
                        if (i10 == 8) {
                            return GONE;
                        }
                        throw new IllegalArgumentException("Unknown visibility " + i10);
                    }
                    return INVISIBLE;
                }
                return VISIBLE;
            }

            /* JADX INFO: Access modifiers changed from: package-private */
            public static c h(View view) {
                return (view.getAlpha() == 0.0f && view.getVisibility() == 0) ? INVISIBLE : g(view.getVisibility());
            }

            /* JADX INFO: Access modifiers changed from: package-private */
            public void b(View view) {
                int i10;
                int i11 = c.f2996a[ordinal()];
                if (i11 == 1) {
                    ViewGroup viewGroup = (ViewGroup) view.getParent();
                    if (viewGroup != null) {
                        if (n.F0(2)) {
                            Log.v("FragmentManager", "SpecialEffectsController: Removing view " + view + " from container " + viewGroup);
                        }
                        viewGroup.removeView(view);
                        return;
                    }
                    return;
                }
                if (i11 == 2) {
                    if (n.F0(2)) {
                        Log.v("FragmentManager", "SpecialEffectsController: Setting view " + view + " to VISIBLE");
                    }
                    i10 = 0;
                } else if (i11 != 3) {
                    if (i11 != 4) {
                        return;
                    }
                    if (n.F0(2)) {
                        Log.v("FragmentManager", "SpecialEffectsController: Setting view " + view + " to INVISIBLE");
                    }
                    view.setVisibility(4);
                    return;
                } else {
                    if (n.F0(2)) {
                        Log.v("FragmentManager", "SpecialEffectsController: Setting view " + view + " to GONE");
                    }
                    i10 = 8;
                }
                view.setVisibility(i10);
            }
        }

        e(c cVar, b bVar, Fragment fragment, androidx.core.os.e eVar) {
            this.f2999a = cVar;
            this.f3000b = bVar;
            this.f3001c = fragment;
            eVar.c(new a());
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        public final void a(Runnable runnable) {
            this.f3002d.add(runnable);
        }

        final void b() {
            if (h()) {
                return;
            }
            this.f3004f = true;
            if (this.f3003e.isEmpty()) {
                c();
                return;
            }
            Iterator it = new ArrayList(this.f3003e).iterator();
            while (it.hasNext()) {
                ((androidx.core.os.e) it.next()).a();
            }
        }

        public void c() {
            if (this.f3005g) {
                return;
            }
            if (n.F0(2)) {
                Log.v("FragmentManager", "SpecialEffectsController: " + this + " has called complete.");
            }
            this.f3005g = true;
            for (Runnable runnable : this.f3002d) {
                runnable.run();
            }
        }

        public final void d(androidx.core.os.e eVar) {
            if (this.f3003e.remove(eVar) && this.f3003e.isEmpty()) {
                c();
            }
        }

        public c e() {
            return this.f2999a;
        }

        public final Fragment f() {
            return this.f3001c;
        }

        b g() {
            return this.f3000b;
        }

        final boolean h() {
            return this.f3004f;
        }

        final boolean i() {
            return this.f3005g;
        }

        public final void j(androidx.core.os.e eVar) {
            l();
            this.f3003e.add(eVar);
        }

        final void k(c cVar, b bVar) {
            b bVar2;
            int i10 = c.f2997b[bVar.ordinal()];
            if (i10 != 1) {
                if (i10 != 2) {
                    if (i10 == 3 && this.f2999a != c.REMOVED) {
                        if (n.F0(2)) {
                            Log.v("FragmentManager", "SpecialEffectsController: For fragment " + this.f3001c + " mFinalState = " + this.f2999a + " -> " + cVar + ". ");
                        }
                        this.f2999a = cVar;
                        return;
                    }
                    return;
                }
                if (n.F0(2)) {
                    Log.v("FragmentManager", "SpecialEffectsController: For fragment " + this.f3001c + " mFinalState = " + this.f2999a + " -> REMOVED. mLifecycleImpact  = " + this.f3000b + " to REMOVING.");
                }
                this.f2999a = c.REMOVED;
                bVar2 = b.REMOVING;
            } else if (this.f2999a != c.REMOVED) {
                return;
            } else {
                if (n.F0(2)) {
                    Log.v("FragmentManager", "SpecialEffectsController: For fragment " + this.f3001c + " mFinalState = REMOVED -> VISIBLE. mLifecycleImpact = " + this.f3000b + " to ADDING.");
                }
                this.f2999a = c.VISIBLE;
                bVar2 = b.ADDING;
            }
            this.f3000b = bVar2;
        }

        abstract void l();

        public String toString() {
            return "Operation {" + Integer.toHexString(System.identityHashCode(this)) + "} {mFinalState = " + this.f2999a + "} {mLifecycleImpact = " + this.f3000b + "} {mFragment = " + this.f3001c + "}";
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public c0(ViewGroup viewGroup) {
        this.f2987a = viewGroup;
    }

    private void a(e.c cVar, e.b bVar, u uVar) {
        synchronized (this.f2988b) {
            androidx.core.os.e eVar = new androidx.core.os.e();
            e h10 = h(uVar.k());
            if (h10 != null) {
                h10.k(cVar, bVar);
                return;
            }
            d dVar = new d(cVar, bVar, uVar, eVar);
            this.f2988b.add(dVar);
            dVar.a(new a(dVar));
            dVar.a(new b(dVar));
        }
    }

    private e h(Fragment fragment) {
        Iterator it = this.f2988b.iterator();
        while (it.hasNext()) {
            e eVar = (e) it.next();
            if (eVar.f().equals(fragment) && !eVar.h()) {
                return eVar;
            }
        }
        return null;
    }

    private e i(Fragment fragment) {
        Iterator it = this.f2989c.iterator();
        while (it.hasNext()) {
            e eVar = (e) it.next();
            if (eVar.f().equals(fragment) && !eVar.h()) {
                return eVar;
            }
        }
        return null;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static c0 n(ViewGroup viewGroup, n nVar) {
        return o(viewGroup, nVar.y0());
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static c0 o(ViewGroup viewGroup, d0 d0Var) {
        int i10 = k0.b.special_effects_controller_view_tag;
        Object tag = viewGroup.getTag(i10);
        if (tag instanceof c0) {
            return (c0) tag;
        }
        c0 a10 = d0Var.a(viewGroup);
        viewGroup.setTag(i10, a10);
        return a10;
    }

    private void q() {
        Iterator it = this.f2988b.iterator();
        while (it.hasNext()) {
            e eVar = (e) it.next();
            if (eVar.g() == e.b.ADDING) {
                eVar.k(e.c.g(eVar.f().requireView().getVisibility()), e.b.NONE);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void b(e.c cVar, u uVar) {
        if (n.F0(2)) {
            Log.v("FragmentManager", "SpecialEffectsController: Enqueuing add operation for fragment " + uVar.k());
        }
        a(cVar, e.b.ADDING, uVar);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void c(u uVar) {
        if (n.F0(2)) {
            Log.v("FragmentManager", "SpecialEffectsController: Enqueuing hide operation for fragment " + uVar.k());
        }
        a(e.c.GONE, e.b.NONE, uVar);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void d(u uVar) {
        if (n.F0(2)) {
            Log.v("FragmentManager", "SpecialEffectsController: Enqueuing remove operation for fragment " + uVar.k());
        }
        a(e.c.REMOVED, e.b.REMOVING, uVar);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void e(u uVar) {
        if (n.F0(2)) {
            Log.v("FragmentManager", "SpecialEffectsController: Enqueuing show operation for fragment " + uVar.k());
        }
        a(e.c.VISIBLE, e.b.NONE, uVar);
    }

    abstract void f(List list, boolean z9);

    /* JADX INFO: Access modifiers changed from: package-private */
    public void g() {
        if (this.f2991e) {
            return;
        }
        if (!r0.Q(this.f2987a)) {
            j();
            this.f2990d = false;
            return;
        }
        synchronized (this.f2988b) {
            if (!this.f2988b.isEmpty()) {
                ArrayList arrayList = new ArrayList(this.f2989c);
                this.f2989c.clear();
                Iterator it = arrayList.iterator();
                while (it.hasNext()) {
                    e eVar = (e) it.next();
                    if (n.F0(2)) {
                        Log.v("FragmentManager", "SpecialEffectsController: Cancelling operation " + eVar);
                    }
                    eVar.b();
                    if (!eVar.i()) {
                        this.f2989c.add(eVar);
                    }
                }
                q();
                ArrayList arrayList2 = new ArrayList(this.f2988b);
                this.f2988b.clear();
                this.f2989c.addAll(arrayList2);
                Iterator it2 = arrayList2.iterator();
                while (it2.hasNext()) {
                    ((e) it2.next()).l();
                }
                f(arrayList2, this.f2990d);
                this.f2990d = false;
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void j() {
        String str;
        String str2;
        boolean Q = r0.Q(this.f2987a);
        synchronized (this.f2988b) {
            q();
            Iterator it = this.f2988b.iterator();
            while (it.hasNext()) {
                ((e) it.next()).l();
            }
            Iterator it2 = new ArrayList(this.f2989c).iterator();
            while (it2.hasNext()) {
                e eVar = (e) it2.next();
                if (n.F0(2)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("SpecialEffectsController: ");
                    if (Q) {
                        str2 = "";
                    } else {
                        str2 = "Container " + this.f2987a + " is not attached to window. ";
                    }
                    sb.append(str2);
                    sb.append("Cancelling running operation ");
                    sb.append(eVar);
                    Log.v("FragmentManager", sb.toString());
                }
                eVar.b();
            }
            Iterator it3 = new ArrayList(this.f2988b).iterator();
            while (it3.hasNext()) {
                e eVar2 = (e) it3.next();
                if (n.F0(2)) {
                    StringBuilder sb2 = new StringBuilder();
                    sb2.append("SpecialEffectsController: ");
                    if (Q) {
                        str = "";
                    } else {
                        str = "Container " + this.f2987a + " is not attached to window. ";
                    }
                    sb2.append(str);
                    sb2.append("Cancelling pending operation ");
                    sb2.append(eVar2);
                    Log.v("FragmentManager", sb2.toString());
                }
                eVar2.b();
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void k() {
        if (this.f2991e) {
            this.f2991e = false;
            g();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public e.b l(u uVar) {
        e h10 = h(uVar.k());
        e.b g10 = h10 != null ? h10.g() : null;
        e i10 = i(uVar.k());
        return (i10 == null || !(g10 == null || g10 == e.b.NONE)) ? g10 : i10.g();
    }

    public ViewGroup m() {
        return this.f2987a;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void p() {
        synchronized (this.f2988b) {
            q();
            this.f2991e = false;
            int size = this.f2988b.size() - 1;
            while (true) {
                if (size < 0) {
                    break;
                }
                e eVar = (e) this.f2988b.get(size);
                e.c h10 = e.c.h(eVar.f().mView);
                e.c e10 = eVar.e();
                e.c cVar = e.c.VISIBLE;
                if (e10 == cVar && h10 != cVar) {
                    this.f2991e = eVar.f().isPostponed();
                    break;
                }
                size--;
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void r(boolean z9) {
        this.f2990d = z9;
    }
}
