package androidx.exifinterface.media;

import android.content.res.AssetManager;
import android.media.MediaDataSource;
import android.media.MediaMetadataRetriever;
import android.os.Build;
import android.system.OsConstants;
import android.util.Log;
import android.util.Pair;
import androidx.exifinterface.media.b;
import io.flutter.embedding.android.KeyboardMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
/* loaded from: classes.dex */
public class a {
    private static SimpleDateFormat U;
    private static SimpleDateFormat V;
    private static final e[] Z;

    /* renamed from: a0  reason: collision with root package name */
    private static final e[] f2809a0;

    /* renamed from: b0  reason: collision with root package name */
    private static final e[] f2810b0;

    /* renamed from: c0  reason: collision with root package name */
    private static final e[] f2811c0;

    /* renamed from: d0  reason: collision with root package name */
    private static final e[] f2812d0;

    /* renamed from: e0  reason: collision with root package name */
    private static final e f2813e0;

    /* renamed from: f0  reason: collision with root package name */
    private static final e[] f2814f0;

    /* renamed from: g0  reason: collision with root package name */
    private static final e[] f2815g0;

    /* renamed from: h0  reason: collision with root package name */
    private static final e[] f2816h0;

    /* renamed from: i0  reason: collision with root package name */
    private static final e[] f2817i0;

    /* renamed from: j0  reason: collision with root package name */
    static final e[][] f2818j0;

    /* renamed from: k0  reason: collision with root package name */
    private static final e[] f2819k0;

    /* renamed from: l0  reason: collision with root package name */
    private static final HashMap[] f2820l0;

    /* renamed from: m0  reason: collision with root package name */
    private static final HashMap[] f2821m0;

    /* renamed from: n0  reason: collision with root package name */
    private static final HashSet f2822n0;

    /* renamed from: o0  reason: collision with root package name */
    private static final HashMap f2823o0;

    /* renamed from: p0  reason: collision with root package name */
    static final Charset f2824p0;

    /* renamed from: q0  reason: collision with root package name */
    static final byte[] f2825q0;

    /* renamed from: r0  reason: collision with root package name */
    private static final byte[] f2826r0;

    /* renamed from: s0  reason: collision with root package name */
    private static final Pattern f2827s0;

    /* renamed from: t0  reason: collision with root package name */
    private static final Pattern f2828t0;

    /* renamed from: u0  reason: collision with root package name */
    private static final Pattern f2829u0;

    /* renamed from: v0  reason: collision with root package name */
    private static final Pattern f2831v0;

    /* renamed from: a  reason: collision with root package name */
    private String f2836a;

    /* renamed from: b  reason: collision with root package name */
    private FileDescriptor f2837b;

    /* renamed from: c  reason: collision with root package name */
    private AssetManager.AssetInputStream f2838c;

    /* renamed from: d  reason: collision with root package name */
    private int f2839d;

    /* renamed from: e  reason: collision with root package name */
    private boolean f2840e;

    /* renamed from: f  reason: collision with root package name */
    private final HashMap[] f2841f;

    /* renamed from: g  reason: collision with root package name */
    private Set f2842g;

    /* renamed from: h  reason: collision with root package name */
    private ByteOrder f2843h;

    /* renamed from: i  reason: collision with root package name */
    private boolean f2844i;

    /* renamed from: j  reason: collision with root package name */
    private boolean f2845j;

    /* renamed from: k  reason: collision with root package name */
    private boolean f2846k;

    /* renamed from: l  reason: collision with root package name */
    private int f2847l;

    /* renamed from: m  reason: collision with root package name */
    private int f2848m;

    /* renamed from: n  reason: collision with root package name */
    private byte[] f2849n;

    /* renamed from: o  reason: collision with root package name */
    private int f2850o;

    /* renamed from: p  reason: collision with root package name */
    private int f2851p;

    /* renamed from: q  reason: collision with root package name */
    private int f2852q;

    /* renamed from: r  reason: collision with root package name */
    private int f2853r;

    /* renamed from: s  reason: collision with root package name */
    private int f2854s;

    /* renamed from: t  reason: collision with root package name */
    private boolean f2855t;

    /* renamed from: u  reason: collision with root package name */
    private boolean f2856u;

    /* renamed from: v  reason: collision with root package name */
    private static final boolean f2830v = Log.isLoggable("ExifInterface", 3);

    /* renamed from: w  reason: collision with root package name */
    private static final List f2832w = Arrays.asList(1, 6, 3, 8);

    /* renamed from: x  reason: collision with root package name */
    private static final List f2833x = Arrays.asList(2, 7, 4, 5);

    /* renamed from: y  reason: collision with root package name */
    public static final int[] f2834y = {8, 8, 8};

    /* renamed from: z  reason: collision with root package name */
    public static final int[] f2835z = {4};
    public static final int[] A = {8};
    static final byte[] B = {-1, -40, -1};
    private static final byte[] C = {102, 116, 121, 112};
    private static final byte[] D = {109, 105, 102, 49};
    private static final byte[] E = {104, 101, 105, 99};
    private static final byte[] F = {79, 76, 89, 77, 80, 0};
    private static final byte[] G = {79, 76, 89, 77, 80, 85, 83, 0, 73, 73};
    private static final byte[] H = {-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] I = {101, 88, 73, 102};
    private static final byte[] J = {73, 72, 68, 82};
    private static final byte[] K = {73, 69, 78, 68};
    private static final byte[] L = {82, 73, 70, 70};
    private static final byte[] M = {87, 69, 66, 80};
    private static final byte[] N = {69, 88, 73, 70};
    private static final byte[] O = {-99, 1, 42};
    private static final byte[] P = "VP8X".getBytes(Charset.defaultCharset());
    private static final byte[] Q = "VP8L".getBytes(Charset.defaultCharset());
    private static final byte[] R = "VP8 ".getBytes(Charset.defaultCharset());
    private static final byte[] S = "ANIM".getBytes(Charset.defaultCharset());
    private static final byte[] T = "ANMF".getBytes(Charset.defaultCharset());
    static final String[] W = {"", "BYTE", "STRING", "USHORT", "ULONG", "URATIONAL", "SBYTE", "UNDEFINED", "SSHORT", "SLONG", "SRATIONAL", "SINGLE", "DOUBLE", "IFD"};
    static final int[] X = {0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8, 1};
    static final byte[] Y = {65, 83, 67, 73, 73, 0, 0, 0};

    /* JADX INFO: Access modifiers changed from: package-private */
    /* renamed from: androidx.exifinterface.media.a$a  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public class C0030a extends MediaDataSource {

        /* renamed from: g  reason: collision with root package name */
        long f2857g;

        /* renamed from: h  reason: collision with root package name */
        final /* synthetic */ g f2858h;

        C0030a(g gVar) {
            this.f2858h = gVar;
        }

        @Override // java.io.Closeable, java.lang.AutoCloseable
        public void close() {
        }

        public long getSize() {
            return -1L;
        }

        public int readAt(long j10, byte[] bArr, int i10, int i11) {
            if (i11 == 0) {
                return 0;
            }
            if (j10 < 0) {
                return -1;
            }
            try {
                long j11 = this.f2857g;
                if (j11 != j10) {
                    if (j11 >= 0 && j10 >= j11 + this.f2858h.available()) {
                        return -1;
                    }
                    this.f2858h.m(j10);
                    this.f2857g = j10;
                }
                if (i11 > this.f2858h.available()) {
                    i11 = this.f2858h.available();
                }
                int read = this.f2858h.read(bArr, i10, i11);
                if (read >= 0) {
                    this.f2857g += read;
                    return read;
                }
            } catch (IOException unused) {
            }
            this.f2857g = -1L;
            return -1;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class b extends InputStream implements DataInput {

        /* renamed from: g  reason: collision with root package name */
        protected final DataInputStream f2860g;

        /* renamed from: h  reason: collision with root package name */
        protected int f2861h;

        /* renamed from: i  reason: collision with root package name */
        private ByteOrder f2862i;

        /* renamed from: j  reason: collision with root package name */
        private byte[] f2863j;

        /* renamed from: k  reason: collision with root package name */
        private int f2864k;

        b(InputStream inputStream) {
            this(inputStream, ByteOrder.BIG_ENDIAN);
        }

        b(InputStream inputStream, ByteOrder byteOrder) {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.f2860g = dataInputStream;
            dataInputStream.mark(0);
            this.f2861h = 0;
            this.f2862i = byteOrder;
            this.f2864k = inputStream instanceof b ? ((b) inputStream).a() : -1;
        }

        b(byte[] bArr) {
            this(new ByteArrayInputStream(bArr), ByteOrder.BIG_ENDIAN);
            this.f2864k = bArr.length;
        }

        public int a() {
            return this.f2864k;
        }

        @Override // java.io.InputStream
        public int available() {
            return this.f2860g.available();
        }

        public int b() {
            return this.f2861h;
        }

        public long c() {
            return readInt() & KeyboardMap.kValueMask;
        }

        public void g(ByteOrder byteOrder) {
            this.f2862i = byteOrder;
        }

        public void k(int i10) {
            int i11 = 0;
            while (i11 < i10) {
                int i12 = i10 - i11;
                int skip = (int) this.f2860g.skip(i12);
                if (skip <= 0) {
                    if (this.f2863j == null) {
                        this.f2863j = new byte[8192];
                    }
                    skip = this.f2860g.read(this.f2863j, 0, Math.min(8192, i12));
                    if (skip == -1) {
                        throw new EOFException("Reached EOF while skipping " + i10 + " bytes.");
                    }
                }
                i11 += skip;
            }
            this.f2861h += i11;
        }

        @Override // java.io.InputStream
        public void mark(int i10) {
            throw new UnsupportedOperationException("Mark is currently unsupported");
        }

        @Override // java.io.InputStream
        public int read() {
            this.f2861h++;
            return this.f2860g.read();
        }

        @Override // java.io.InputStream
        public int read(byte[] bArr, int i10, int i11) {
            int read = this.f2860g.read(bArr, i10, i11);
            this.f2861h += read;
            return read;
        }

        @Override // java.io.DataInput
        public boolean readBoolean() {
            this.f2861h++;
            return this.f2860g.readBoolean();
        }

        @Override // java.io.DataInput
        public byte readByte() {
            this.f2861h++;
            int read = this.f2860g.read();
            if (read >= 0) {
                return (byte) read;
            }
            throw new EOFException();
        }

        @Override // java.io.DataInput
        public char readChar() {
            this.f2861h += 2;
            return this.f2860g.readChar();
        }

        @Override // java.io.DataInput
        public double readDouble() {
            return Double.longBitsToDouble(readLong());
        }

        @Override // java.io.DataInput
        public float readFloat() {
            return Float.intBitsToFloat(readInt());
        }

        @Override // java.io.DataInput
        public void readFully(byte[] bArr) {
            this.f2861h += bArr.length;
            this.f2860g.readFully(bArr);
        }

        @Override // java.io.DataInput
        public void readFully(byte[] bArr, int i10, int i11) {
            this.f2861h += i11;
            this.f2860g.readFully(bArr, i10, i11);
        }

        @Override // java.io.DataInput
        public int readInt() {
            this.f2861h += 4;
            int read = this.f2860g.read();
            int read2 = this.f2860g.read();
            int read3 = this.f2860g.read();
            int read4 = this.f2860g.read();
            if ((read | read2 | read3 | read4) >= 0) {
                ByteOrder byteOrder = this.f2862i;
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return (read4 << 24) + (read3 << 16) + (read2 << 8) + read;
                }
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    return (read << 24) + (read2 << 16) + (read3 << 8) + read4;
                }
                throw new IOException("Invalid byte order: " + this.f2862i);
            }
            throw new EOFException();
        }

        @Override // java.io.DataInput
        public String readLine() {
            Log.d("ExifInterface", "Currently unsupported");
            return null;
        }

        @Override // java.io.DataInput
        public long readLong() {
            this.f2861h += 8;
            int read = this.f2860g.read();
            int read2 = this.f2860g.read();
            int read3 = this.f2860g.read();
            int read4 = this.f2860g.read();
            int read5 = this.f2860g.read();
            int read6 = this.f2860g.read();
            int read7 = this.f2860g.read();
            int read8 = this.f2860g.read();
            if ((read | read2 | read3 | read4 | read5 | read6 | read7 | read8) >= 0) {
                ByteOrder byteOrder = this.f2862i;
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return (read8 << 56) + (read7 << 48) + (read6 << 40) + (read5 << 32) + (read4 << 24) + (read3 << 16) + (read2 << 8) + read;
                }
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    return (read << 56) + (read2 << 48) + (read3 << 40) + (read4 << 32) + (read5 << 24) + (read6 << 16) + (read7 << 8) + read8;
                }
                throw new IOException("Invalid byte order: " + this.f2862i);
            }
            throw new EOFException();
        }

        @Override // java.io.DataInput
        public short readShort() {
            this.f2861h += 2;
            int read = this.f2860g.read();
            int read2 = this.f2860g.read();
            if ((read | read2) >= 0) {
                ByteOrder byteOrder = this.f2862i;
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return (short) ((read2 << 8) + read);
                }
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    return (short) ((read << 8) + read2);
                }
                throw new IOException("Invalid byte order: " + this.f2862i);
            }
            throw new EOFException();
        }

        @Override // java.io.DataInput
        public String readUTF() {
            this.f2861h += 2;
            return this.f2860g.readUTF();
        }

        @Override // java.io.DataInput
        public int readUnsignedByte() {
            this.f2861h++;
            return this.f2860g.readUnsignedByte();
        }

        @Override // java.io.DataInput
        public int readUnsignedShort() {
            this.f2861h += 2;
            int read = this.f2860g.read();
            int read2 = this.f2860g.read();
            if ((read | read2) >= 0) {
                ByteOrder byteOrder = this.f2862i;
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return (read2 << 8) + read;
                }
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    return (read << 8) + read2;
                }
                throw new IOException("Invalid byte order: " + this.f2862i);
            }
            throw new EOFException();
        }

        @Override // java.io.InputStream
        public void reset() {
            throw new UnsupportedOperationException("Reset is currently unsupported");
        }

        @Override // java.io.DataInput
        public int skipBytes(int i10) {
            throw new UnsupportedOperationException("skipBytes is currently unsupported");
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class c extends FilterOutputStream {

        /* renamed from: g  reason: collision with root package name */
        final OutputStream f2865g;

        /* renamed from: h  reason: collision with root package name */
        private ByteOrder f2866h;

        public c(OutputStream outputStream, ByteOrder byteOrder) {
            super(outputStream);
            this.f2865g = outputStream;
            this.f2866h = byteOrder;
        }

        public void a(ByteOrder byteOrder) {
            this.f2866h = byteOrder;
        }

        public void b(int i10) {
            this.f2865g.write(i10);
        }

        public void c(int i10) {
            OutputStream outputStream;
            int i11;
            ByteOrder byteOrder = this.f2866h;
            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                this.f2865g.write((i10 >>> 0) & 255);
                this.f2865g.write((i10 >>> 8) & 255);
                this.f2865g.write((i10 >>> 16) & 255);
                outputStream = this.f2865g;
                i11 = i10 >>> 24;
            } else if (byteOrder != ByteOrder.BIG_ENDIAN) {
                return;
            } else {
                this.f2865g.write((i10 >>> 24) & 255);
                this.f2865g.write((i10 >>> 16) & 255);
                this.f2865g.write((i10 >>> 8) & 255);
                outputStream = this.f2865g;
                i11 = i10 >>> 0;
            }
            outputStream.write(i11 & 255);
        }

        public void g(short s9) {
            OutputStream outputStream;
            int i10;
            ByteOrder byteOrder = this.f2866h;
            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                this.f2865g.write((s9 >>> 0) & 255);
                outputStream = this.f2865g;
                i10 = s9 >>> 8;
            } else if (byteOrder != ByteOrder.BIG_ENDIAN) {
                return;
            } else {
                this.f2865g.write((s9 >>> 8) & 255);
                outputStream = this.f2865g;
                i10 = s9 >>> 0;
            }
            outputStream.write(i10 & 255);
        }

        public void k(long j10) {
            if (j10 > KeyboardMap.kValueMask) {
                throw new IllegalArgumentException("val is larger than the maximum value of a 32-bit unsigned integer");
            }
            c((int) j10);
        }

        public void m(int i10) {
            if (i10 > 65535) {
                throw new IllegalArgumentException("val is larger than the maximum value of a 16-bit unsigned integer");
            }
            g((short) i10);
        }

        @Override // java.io.FilterOutputStream, java.io.OutputStream
        public void write(byte[] bArr) {
            this.f2865g.write(bArr);
        }

        @Override // java.io.FilterOutputStream, java.io.OutputStream
        public void write(byte[] bArr, int i10, int i11) {
            this.f2865g.write(bArr, i10, i11);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class d {

        /* renamed from: a  reason: collision with root package name */
        public final int f2867a;

        /* renamed from: b  reason: collision with root package name */
        public final int f2868b;

        /* renamed from: c  reason: collision with root package name */
        public final long f2869c;

        /* renamed from: d  reason: collision with root package name */
        public final byte[] f2870d;

        d(int i10, int i11, long j10, byte[] bArr) {
            this.f2867a = i10;
            this.f2868b = i11;
            this.f2869c = j10;
            this.f2870d = bArr;
        }

        d(int i10, int i11, byte[] bArr) {
            this(i10, i11, -1L, bArr);
        }

        public static d a(String str) {
            if (str.length() != 1 || str.charAt(0) < '0' || str.charAt(0) > '1') {
                byte[] bytes = str.getBytes(a.f2824p0);
                return new d(1, bytes.length, bytes);
            }
            return new d(1, 1, new byte[]{(byte) (str.charAt(0) - '0')});
        }

        public static d b(double[] dArr, ByteOrder byteOrder) {
            ByteBuffer wrap = ByteBuffer.wrap(new byte[a.X[12] * dArr.length]);
            wrap.order(byteOrder);
            for (double d10 : dArr) {
                wrap.putDouble(d10);
            }
            return new d(12, dArr.length, wrap.array());
        }

        public static d c(int[] iArr, ByteOrder byteOrder) {
            ByteBuffer wrap = ByteBuffer.wrap(new byte[a.X[9] * iArr.length]);
            wrap.order(byteOrder);
            for (int i10 : iArr) {
                wrap.putInt(i10);
            }
            return new d(9, iArr.length, wrap.array());
        }

        public static d d(f[] fVarArr, ByteOrder byteOrder) {
            ByteBuffer wrap = ByteBuffer.wrap(new byte[a.X[10] * fVarArr.length]);
            wrap.order(byteOrder);
            for (f fVar : fVarArr) {
                wrap.putInt((int) fVar.f2875a);
                wrap.putInt((int) fVar.f2876b);
            }
            return new d(10, fVarArr.length, wrap.array());
        }

        public static d e(String str) {
            byte[] bytes = (str + (char) 0).getBytes(a.f2824p0);
            return new d(2, bytes.length, bytes);
        }

        public static d f(long j10, ByteOrder byteOrder) {
            return g(new long[]{j10}, byteOrder);
        }

        public static d g(long[] jArr, ByteOrder byteOrder) {
            ByteBuffer wrap = ByteBuffer.wrap(new byte[a.X[4] * jArr.length]);
            wrap.order(byteOrder);
            for (long j10 : jArr) {
                wrap.putInt((int) j10);
            }
            return new d(4, jArr.length, wrap.array());
        }

        public static d h(f fVar, ByteOrder byteOrder) {
            return i(new f[]{fVar}, byteOrder);
        }

        public static d i(f[] fVarArr, ByteOrder byteOrder) {
            ByteBuffer wrap = ByteBuffer.wrap(new byte[a.X[5] * fVarArr.length]);
            wrap.order(byteOrder);
            for (f fVar : fVarArr) {
                wrap.putInt((int) fVar.f2875a);
                wrap.putInt((int) fVar.f2876b);
            }
            return new d(5, fVarArr.length, wrap.array());
        }

        public static d j(int i10, ByteOrder byteOrder) {
            return k(new int[]{i10}, byteOrder);
        }

        public static d k(int[] iArr, ByteOrder byteOrder) {
            ByteBuffer wrap = ByteBuffer.wrap(new byte[a.X[3] * iArr.length]);
            wrap.order(byteOrder);
            for (int i10 : iArr) {
                wrap.putShort((short) i10);
            }
            return new d(3, iArr.length, wrap.array());
        }

        public double l(ByteOrder byteOrder) {
            Object o10 = o(byteOrder);
            if (o10 != null) {
                if (o10 instanceof String) {
                    return Double.parseDouble((String) o10);
                }
                if (o10 instanceof long[]) {
                    long[] jArr = (long[]) o10;
                    if (jArr.length == 1) {
                        return jArr[0];
                    }
                    throw new NumberFormatException("There are more than one component");
                } else if (o10 instanceof int[]) {
                    int[] iArr = (int[]) o10;
                    if (iArr.length == 1) {
                        return iArr[0];
                    }
                    throw new NumberFormatException("There are more than one component");
                } else if (o10 instanceof double[]) {
                    double[] dArr = (double[]) o10;
                    if (dArr.length == 1) {
                        return dArr[0];
                    }
                    throw new NumberFormatException("There are more than one component");
                } else if (o10 instanceof f[]) {
                    f[] fVarArr = (f[]) o10;
                    if (fVarArr.length == 1) {
                        return fVarArr[0].a();
                    }
                    throw new NumberFormatException("There are more than one component");
                } else {
                    throw new NumberFormatException("Couldn't find a double value");
                }
            }
            throw new NumberFormatException("NULL can't be converted to a double value");
        }

        public int m(ByteOrder byteOrder) {
            Object o10 = o(byteOrder);
            if (o10 != null) {
                if (o10 instanceof String) {
                    return Integer.parseInt((String) o10);
                }
                if (o10 instanceof long[]) {
                    long[] jArr = (long[]) o10;
                    if (jArr.length == 1) {
                        return (int) jArr[0];
                    }
                    throw new NumberFormatException("There are more than one component");
                } else if (o10 instanceof int[]) {
                    int[] iArr = (int[]) o10;
                    if (iArr.length == 1) {
                        return iArr[0];
                    }
                    throw new NumberFormatException("There are more than one component");
                } else {
                    throw new NumberFormatException("Couldn't find a integer value");
                }
            }
            throw new NumberFormatException("NULL can't be converted to a integer value");
        }

        public String n(ByteOrder byteOrder) {
            Object o10 = o(byteOrder);
            if (o10 == null) {
                return null;
            }
            if (o10 instanceof String) {
                return (String) o10;
            }
            StringBuilder sb = new StringBuilder();
            int i10 = 0;
            if (o10 instanceof long[]) {
                long[] jArr = (long[]) o10;
                while (i10 < jArr.length) {
                    sb.append(jArr[i10]);
                    i10++;
                    if (i10 != jArr.length) {
                        sb.append(",");
                    }
                }
                return sb.toString();
            } else if (o10 instanceof int[]) {
                int[] iArr = (int[]) o10;
                while (i10 < iArr.length) {
                    sb.append(iArr[i10]);
                    i10++;
                    if (i10 != iArr.length) {
                        sb.append(",");
                    }
                }
                return sb.toString();
            } else if (o10 instanceof double[]) {
                double[] dArr = (double[]) o10;
                while (i10 < dArr.length) {
                    sb.append(dArr[i10]);
                    i10++;
                    if (i10 != dArr.length) {
                        sb.append(",");
                    }
                }
                return sb.toString();
            } else if (o10 instanceof f[]) {
                f[] fVarArr = (f[]) o10;
                while (i10 < fVarArr.length) {
                    sb.append(fVarArr[i10].f2875a);
                    sb.append('/');
                    sb.append(fVarArr[i10].f2876b);
                    i10++;
                    if (i10 != fVarArr.length) {
                        sb.append(",");
                    }
                }
                return sb.toString();
            } else {
                return null;
            }
        }

        /* JADX WARN: Not initialized variable reg: 3, insn: 0x0198: MOVE  (r2 I:??[OBJECT, ARRAY]) = (r3 I:??[OBJECT, ARRAY]), block:B:151:0x0198 */
        /* JADX WARN: Removed duplicated region for block: B:182:0x019b A[EXC_TOP_SPLITTER, SYNTHETIC] */
        /*
            Code decompiled incorrectly, please refer to instructions dump.
        */
        Object o(ByteOrder byteOrder) {
            b bVar;
            InputStream inputStream;
            byte b10;
            byte b11;
            byte[] bArr;
            InputStream inputStream2 = null;
            try {
                try {
                    bVar = new b(this.f2870d);
                    try {
                        bVar.g(byteOrder);
                        int i10 = 0;
                        boolean z9 = true;
                        switch (this.f2867a) {
                            case 1:
                            case 6:
                                byte[] bArr2 = this.f2870d;
                                if (bArr2.length != 1 || (b10 = bArr2[0]) < 0 || b10 > 1) {
                                    String str = new String(bArr2, a.f2824p0);
                                    try {
                                        bVar.close();
                                    } catch (IOException e10) {
                                        Log.e("ExifInterface", "IOException occurred while closing InputStream", e10);
                                    }
                                    return str;
                                }
                                String str2 = new String(new char[]{(char) (b10 + 48)});
                                try {
                                    bVar.close();
                                } catch (IOException e11) {
                                    Log.e("ExifInterface", "IOException occurred while closing InputStream", e11);
                                }
                                return str2;
                            case 2:
                            case 7:
                                if (this.f2868b >= a.Y.length) {
                                    int i11 = 0;
                                    while (true) {
                                        bArr = a.Y;
                                        if (i11 < bArr.length) {
                                            if (this.f2870d[i11] != bArr[i11]) {
                                                z9 = false;
                                            } else {
                                                i11++;
                                            }
                                        }
                                    }
                                    if (z9) {
                                        i10 = bArr.length;
                                    }
                                }
                                StringBuilder sb = new StringBuilder();
                                while (i10 < this.f2868b && (b11 = this.f2870d[i10]) != 0) {
                                    if (b11 >= 32) {
                                        sb.append((char) b11);
                                    } else {
                                        sb.append('?');
                                    }
                                    i10++;
                                }
                                String sb2 = sb.toString();
                                try {
                                    bVar.close();
                                } catch (IOException e12) {
                                    Log.e("ExifInterface", "IOException occurred while closing InputStream", e12);
                                }
                                return sb2;
                            case 3:
                                int[] iArr = new int[this.f2868b];
                                while (i10 < this.f2868b) {
                                    iArr[i10] = bVar.readUnsignedShort();
                                    i10++;
                                }
                                try {
                                    bVar.close();
                                } catch (IOException e13) {
                                    Log.e("ExifInterface", "IOException occurred while closing InputStream", e13);
                                }
                                return iArr;
                            case 4:
                                long[] jArr = new long[this.f2868b];
                                while (i10 < this.f2868b) {
                                    jArr[i10] = bVar.c();
                                    i10++;
                                }
                                try {
                                    bVar.close();
                                } catch (IOException e14) {
                                    Log.e("ExifInterface", "IOException occurred while closing InputStream", e14);
                                }
                                return jArr;
                            case 5:
                                f[] fVarArr = new f[this.f2868b];
                                while (i10 < this.f2868b) {
                                    fVarArr[i10] = new f(bVar.c(), bVar.c());
                                    i10++;
                                }
                                try {
                                    bVar.close();
                                } catch (IOException e15) {
                                    Log.e("ExifInterface", "IOException occurred while closing InputStream", e15);
                                }
                                return fVarArr;
                            case 8:
                                int[] iArr2 = new int[this.f2868b];
                                while (i10 < this.f2868b) {
                                    iArr2[i10] = bVar.readShort();
                                    i10++;
                                }
                                try {
                                    bVar.close();
                                } catch (IOException e16) {
                                    Log.e("ExifInterface", "IOException occurred while closing InputStream", e16);
                                }
                                return iArr2;
                            case 9:
                                int[] iArr3 = new int[this.f2868b];
                                while (i10 < this.f2868b) {
                                    iArr3[i10] = bVar.readInt();
                                    i10++;
                                }
                                try {
                                    bVar.close();
                                } catch (IOException e17) {
                                    Log.e("ExifInterface", "IOException occurred while closing InputStream", e17);
                                }
                                return iArr3;
                            case 10:
                                f[] fVarArr2 = new f[this.f2868b];
                                while (i10 < this.f2868b) {
                                    fVarArr2[i10] = new f(bVar.readInt(), bVar.readInt());
                                    i10++;
                                }
                                try {
                                    bVar.close();
                                } catch (IOException e18) {
                                    Log.e("ExifInterface", "IOException occurred while closing InputStream", e18);
                                }
                                return fVarArr2;
                            case 11:
                                double[] dArr = new double[this.f2868b];
                                while (i10 < this.f2868b) {
                                    dArr[i10] = bVar.readFloat();
                                    i10++;
                                }
                                try {
                                    bVar.close();
                                } catch (IOException e19) {
                                    Log.e("ExifInterface", "IOException occurred while closing InputStream", e19);
                                }
                                return dArr;
                            case 12:
                                double[] dArr2 = new double[this.f2868b];
                                while (i10 < this.f2868b) {
                                    dArr2[i10] = bVar.readDouble();
                                    i10++;
                                }
                                try {
                                    bVar.close();
                                } catch (IOException e20) {
                                    Log.e("ExifInterface", "IOException occurred while closing InputStream", e20);
                                }
                                return dArr2;
                            default:
                                try {
                                    bVar.close();
                                } catch (IOException e21) {
                                    Log.e("ExifInterface", "IOException occurred while closing InputStream", e21);
                                }
                                return null;
                        }
                    } catch (IOException e22) {
                        e = e22;
                        Log.w("ExifInterface", "IOException occurred during reading a value", e);
                        if (bVar != null) {
                            try {
                                bVar.close();
                            } catch (IOException e23) {
                                Log.e("ExifInterface", "IOException occurred while closing InputStream", e23);
                            }
                        }
                        return null;
                    }
                } catch (Throwable th) {
                    th = th;
                    inputStream2 = inputStream;
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        } catch (IOException e24) {
                            Log.e("ExifInterface", "IOException occurred while closing InputStream", e24);
                        }
                    }
                    throw th;
                }
            } catch (IOException e25) {
                e = e25;
                bVar = null;
            } catch (Throwable th2) {
                th = th2;
                if (inputStream2 != null) {
                }
                throw th;
            }
        }

        public int p() {
            return a.X[this.f2867a] * this.f2868b;
        }

        public String toString() {
            return "(" + a.W[this.f2867a] + ", data length:" + this.f2870d.length + ")";
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class e {

        /* renamed from: a  reason: collision with root package name */
        public final int f2871a;

        /* renamed from: b  reason: collision with root package name */
        public final String f2872b;

        /* renamed from: c  reason: collision with root package name */
        public final int f2873c;

        /* renamed from: d  reason: collision with root package name */
        public final int f2874d;

        e(String str, int i10, int i11) {
            this.f2872b = str;
            this.f2871a = i10;
            this.f2873c = i11;
            this.f2874d = -1;
        }

        e(String str, int i10, int i11, int i12) {
            this.f2872b = str;
            this.f2871a = i10;
            this.f2873c = i11;
            this.f2874d = i12;
        }

        boolean a(int i10) {
            int i11;
            int i12 = this.f2873c;
            if (i12 == 7 || i10 == 7 || i12 == i10 || (i11 = this.f2874d) == i10) {
                return true;
            }
            if ((i12 == 4 || i11 == 4) && i10 == 3) {
                return true;
            }
            if ((i12 == 9 || i11 == 9) && i10 == 8) {
                return true;
            }
            return (i12 == 12 || i11 == 12) && i10 == 11;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class f {

        /* renamed from: a  reason: collision with root package name */
        public final long f2875a;

        /* renamed from: b  reason: collision with root package name */
        public final long f2876b;

        f(double d10) {
            this((long) (d10 * 10000.0d), 10000L);
        }

        f(long j10, long j11) {
            if (j11 == 0) {
                this.f2875a = 0L;
                this.f2876b = 1L;
                return;
            }
            this.f2875a = j10;
            this.f2876b = j11;
        }

        public double a() {
            return this.f2875a / this.f2876b;
        }

        public String toString() {
            return this.f2875a + "/" + this.f2876b;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class g extends b {
        g(InputStream inputStream) {
            super(inputStream);
            if (!inputStream.markSupported()) {
                throw new IllegalArgumentException("Cannot create SeekableByteOrderedDataInputStream with stream that does not support mark/reset");
            }
            this.f2860g.mark(Integer.MAX_VALUE);
        }

        g(byte[] bArr) {
            super(bArr);
            this.f2860g.mark(Integer.MAX_VALUE);
        }

        public void m(long j10) {
            int i10 = this.f2861h;
            if (i10 > j10) {
                this.f2861h = 0;
                this.f2860g.reset();
            } else {
                j10 -= i10;
            }
            k((int) j10);
        }
    }

    static {
        e[] eVarArr;
        e[] eVarArr2 = {new e("NewSubfileType", 254, 4), new e("SubfileType", 255, 4), new e("ImageWidth", 256, 3, 4), new e("ImageLength", 257, 3, 4), new e("BitsPerSample", 258, 3), new e("Compression", 259, 3), new e("PhotometricInterpretation", 262, 3), new e("ImageDescription", 270, 2), new e("Make", 271, 2), new e("Model", 272, 2), new e("StripOffsets", 273, 3, 4), new e("Orientation", 274, 3), new e("SamplesPerPixel", 277, 3), new e("RowsPerStrip", 278, 3, 4), new e("StripByteCounts", 279, 3, 4), new e("XResolution", 282, 5), new e("YResolution", 283, 5), new e("PlanarConfiguration", 284, 3), new e("ResolutionUnit", 296, 3), new e("TransferFunction", 301, 3), new e("Software", 305, 2), new e("DateTime", 306, 2), new e("Artist", 315, 2), new e("WhitePoint", 318, 5), new e("PrimaryChromaticities", 319, 5), new e("SubIFDPointer", 330, 4), new e("JPEGInterchangeFormat", 513, 4), new e("JPEGInterchangeFormatLength", 514, 4), new e("YCbCrCoefficients", 529, 5), new e("YCbCrSubSampling", 530, 3), new e("YCbCrPositioning", 531, 3), new e("ReferenceBlackWhite", 532, 5), new e("Copyright", 33432, 2), new e("ExifIFDPointer", 34665, 4), new e("GPSInfoIFDPointer", 34853, 4), new e("SensorTopBorder", 4, 4), new e("SensorLeftBorder", 5, 4), new e("SensorBottomBorder", 6, 4), new e("SensorRightBorder", 7, 4), new e("ISO", 23, 3), new e("JpgFromRaw", 46, 7), new e("Xmp", 700, 1)};
        Z = eVarArr2;
        e[] eVarArr3 = {new e("ExposureTime", 33434, 5), new e("FNumber", 33437, 5), new e("ExposureProgram", 34850, 3), new e("SpectralSensitivity", 34852, 2), new e("PhotographicSensitivity", 34855, 3), new e("OECF", 34856, 7), new e("SensitivityType", 34864, 3), new e("StandardOutputSensitivity", 34865, 4), new e("RecommendedExposureIndex", 34866, 4), new e("ISOSpeed", 34867, 4), new e("ISOSpeedLatitudeyyy", 34868, 4), new e("ISOSpeedLatitudezzz", 34869, 4), new e("ExifVersion", 36864, 2), new e("DateTimeOriginal", 36867, 2), new e("DateTimeDigitized", 36868, 2), new e("OffsetTime", 36880, 2), new e("OffsetTimeOriginal", 36881, 2), new e("OffsetTimeDigitized", 36882, 2), new e("ComponentsConfiguration", 37121, 7), new e("CompressedBitsPerPixel", 37122, 5), new e("ShutterSpeedValue", 37377, 10), new e("ApertureValue", 37378, 5), new e("BrightnessValue", 37379, 10), new e("ExposureBiasValue", 37380, 10), new e("MaxApertureValue", 37381, 5), new e("SubjectDistance", 37382, 5), new e("MeteringMode", 37383, 3), new e("LightSource", 37384, 3), new e("Flash", 37385, 3), new e("FocalLength", 37386, 5), new e("SubjectArea", 37396, 3), new e("MakerNote", 37500, 7), new e("UserComment", 37510, 7), new e("SubSecTime", 37520, 2), new e("SubSecTimeOriginal", 37521, 2), new e("SubSecTimeDigitized", 37522, 2), new e("FlashpixVersion", 40960, 7), new e("ColorSpace", 40961, 3), new e("PixelXDimension", 40962, 3, 4), new e("PixelYDimension", 40963, 3, 4), new e("RelatedSoundFile", 40964, 2), new e("InteroperabilityIFDPointer", 40965, 4), new e("FlashEnergy", 41483, 5), new e("SpatialFrequencyResponse", 41484, 7), new e("FocalPlaneXResolution", 41486, 5), new e("FocalPlaneYResolution", 41487, 5), new e("FocalPlaneResolutionUnit", 41488, 3), new e("SubjectLocation", 41492, 3), new e("ExposureIndex", 41493, 5), new e("SensingMethod", 41495, 3), new e("FileSource", 41728, 7), new e("SceneType", 41729, 7), new e("CFAPattern", 41730, 7), new e("CustomRendered", 41985, 3), new e("ExposureMode", 41986, 3), new e("WhiteBalance", 41987, 3), new e("DigitalZoomRatio", 41988, 5), new e("FocalLengthIn35mmFilm", 41989, 3), new e("SceneCaptureType", 41990, 3), new e("GainControl", 41991, 3), new e("Contrast", 41992, 3), new e("Saturation", 41993, 3), new e("Sharpness", 41994, 3), new e("DeviceSettingDescription", 41995, 7), new e("SubjectDistanceRange", 41996, 3), new e("ImageUniqueID", 42016, 2), new e("CameraOwnerName", 42032, 2), new e("BodySerialNumber", 42033, 2), new e("LensSpecification", 42034, 5), new e("LensMake", 42035, 2), new e("LensModel", 42036, 2), new e("Gamma", 42240, 5), new e("DNGVersion", 50706, 1), new e("DefaultCropSize", 50720, 3, 4)};
        f2809a0 = eVarArr3;
        e[] eVarArr4 = {new e("GPSVersionID", 0, 1), new e("GPSLatitudeRef", 1, 2), new e("GPSLatitude", 2, 5, 10), new e("GPSLongitudeRef", 3, 2), new e("GPSLongitude", 4, 5, 10), new e("GPSAltitudeRef", 5, 1), new e("GPSAltitude", 6, 5), new e("GPSTimeStamp", 7, 5), new e("GPSSatellites", 8, 2), new e("GPSStatus", 9, 2), new e("GPSMeasureMode", 10, 2), new e("GPSDOP", 11, 5), new e("GPSSpeedRef", 12, 2), new e("GPSSpeed", 13, 5), new e("GPSTrackRef", 14, 2), new e("GPSTrack", 15, 5), new e("GPSImgDirectionRef", 16, 2), new e("GPSImgDirection", 17, 5), new e("GPSMapDatum", 18, 2), new e("GPSDestLatitudeRef", 19, 2), new e("GPSDestLatitude", 20, 5), new e("GPSDestLongitudeRef", 21, 2), new e("GPSDestLongitude", 22, 5), new e("GPSDestBearingRef", 23, 2), new e("GPSDestBearing", 24, 5), new e("GPSDestDistanceRef", 25, 2), new e("GPSDestDistance", 26, 5), new e("GPSProcessingMethod", 27, 7), new e("GPSAreaInformation", 28, 7), new e("GPSDateStamp", 29, 2), new e("GPSDifferential", 30, 3), new e("GPSHPositioningError", 31, 5)};
        f2810b0 = eVarArr4;
        e[] eVarArr5 = {new e("InteroperabilityIndex", 1, 2)};
        f2811c0 = eVarArr5;
        e[] eVarArr6 = {new e("NewSubfileType", 254, 4), new e("SubfileType", 255, 4), new e("ThumbnailImageWidth", 256, 3, 4), new e("ThumbnailImageLength", 257, 3, 4), new e("BitsPerSample", 258, 3), new e("Compression", 259, 3), new e("PhotometricInterpretation", 262, 3), new e("ImageDescription", 270, 2), new e("Make", 271, 2), new e("Model", 272, 2), new e("StripOffsets", 273, 3, 4), new e("ThumbnailOrientation", 274, 3), new e("SamplesPerPixel", 277, 3), new e("RowsPerStrip", 278, 3, 4), new e("StripByteCounts", 279, 3, 4), new e("XResolution", 282, 5), new e("YResolution", 283, 5), new e("PlanarConfiguration", 284, 3), new e("ResolutionUnit", 296, 3), new e("TransferFunction", 301, 3), new e("Software", 305, 2), new e("DateTime", 306, 2), new e("Artist", 315, 2), new e("WhitePoint", 318, 5), new e("PrimaryChromaticities", 319, 5), new e("SubIFDPointer", 330, 4), new e("JPEGInterchangeFormat", 513, 4), new e("JPEGInterchangeFormatLength", 514, 4), new e("YCbCrCoefficients", 529, 5), new e("YCbCrSubSampling", 530, 3), new e("YCbCrPositioning", 531, 3), new e("ReferenceBlackWhite", 532, 5), new e("Copyright", 33432, 2), new e("ExifIFDPointer", 34665, 4), new e("GPSInfoIFDPointer", 34853, 4), new e("DNGVersion", 50706, 1), new e("DefaultCropSize", 50720, 3, 4)};
        f2812d0 = eVarArr6;
        f2813e0 = new e("StripOffsets", 273, 3);
        e[] eVarArr7 = {new e("ThumbnailImage", 256, 7), new e("CameraSettingsIFDPointer", 8224, 4), new e("ImageProcessingIFDPointer", 8256, 4)};
        f2814f0 = eVarArr7;
        e[] eVarArr8 = {new e("PreviewImageStart", 257, 4), new e("PreviewImageLength", 258, 4)};
        f2815g0 = eVarArr8;
        e[] eVarArr9 = {new e("AspectFrame", 4371, 3)};
        f2816h0 = eVarArr9;
        e[] eVarArr10 = {new e("ColorSpace", 55, 3)};
        f2817i0 = eVarArr10;
        e[][] eVarArr11 = {eVarArr2, eVarArr3, eVarArr4, eVarArr5, eVarArr6, eVarArr2, eVarArr7, eVarArr8, eVarArr9, eVarArr10};
        f2818j0 = eVarArr11;
        f2819k0 = new e[]{new e("SubIFDPointer", 330, 4), new e("ExifIFDPointer", 34665, 4), new e("GPSInfoIFDPointer", 34853, 4), new e("InteroperabilityIFDPointer", 40965, 4), new e("CameraSettingsIFDPointer", 8224, 1), new e("ImageProcessingIFDPointer", 8256, 1)};
        f2820l0 = new HashMap[eVarArr11.length];
        f2821m0 = new HashMap[eVarArr11.length];
        f2822n0 = new HashSet(Arrays.asList("FNumber", "DigitalZoomRatio", "ExposureTime", "SubjectDistance", "GPSTimeStamp"));
        f2823o0 = new HashMap();
        Charset forName = Charset.forName("US-ASCII");
        f2824p0 = forName;
        f2825q0 = "Exif\u0000\u0000".getBytes(forName);
        f2826r0 = "http://ns.adobe.com/xap/1.0/\u0000".getBytes(forName);
        Locale locale = Locale.US;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss", locale);
        U = simpleDateFormat;
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", locale);
        V = simpleDateFormat2;
        simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
        int i10 = 0;
        while (true) {
            e[][] eVarArr12 = f2818j0;
            if (i10 >= eVarArr12.length) {
                HashMap hashMap = f2823o0;
                e[] eVarArr13 = f2819k0;
                hashMap.put(Integer.valueOf(eVarArr13[0].f2871a), 5);
                hashMap.put(Integer.valueOf(eVarArr13[1].f2871a), 1);
                hashMap.put(Integer.valueOf(eVarArr13[2].f2871a), 2);
                hashMap.put(Integer.valueOf(eVarArr13[3].f2871a), 3);
                hashMap.put(Integer.valueOf(eVarArr13[4].f2871a), 7);
                hashMap.put(Integer.valueOf(eVarArr13[5].f2871a), 8);
                f2827s0 = Pattern.compile(".*[1-9].*");
                f2828t0 = Pattern.compile("^(\\d{2}):(\\d{2}):(\\d{2})$");
                f2829u0 = Pattern.compile("^(\\d{4}):(\\d{2}):(\\d{2})\\s(\\d{2}):(\\d{2}):(\\d{2})$");
                f2831v0 = Pattern.compile("^(\\d{4})-(\\d{2})-(\\d{2})\\s(\\d{2}):(\\d{2}):(\\d{2})$");
                return;
            }
            f2820l0[i10] = new HashMap();
            f2821m0[i10] = new HashMap();
            for (e eVar : eVarArr12[i10]) {
                f2820l0[i10].put(Integer.valueOf(eVar.f2871a), eVar);
                f2821m0[i10].put(eVar.f2872b, eVar);
            }
            i10++;
        }
    }

    public a(InputStream inputStream) {
        this(inputStream, 0);
    }

    public a(InputStream inputStream, int i10) {
        e[][] eVarArr = f2818j0;
        this.f2841f = new HashMap[eVarArr.length];
        this.f2842g = new HashSet(eVarArr.length);
        this.f2843h = ByteOrder.BIG_ENDIAN;
        if (inputStream == null) {
            throw new NullPointerException("inputStream cannot be null");
        }
        this.f2836a = null;
        if (i10 == 1) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, f2825q0.length);
            if (!z(bufferedInputStream)) {
                Log.w("ExifInterface", "Given data does not follow the structure of an Exif-only data.");
                return;
            }
            this.f2840e = true;
            this.f2838c = null;
            this.f2837b = null;
            inputStream = bufferedInputStream;
        } else {
            if (inputStream instanceof AssetManager.AssetInputStream) {
                this.f2838c = (AssetManager.AssetInputStream) inputStream;
            } else {
                if (inputStream instanceof FileInputStream) {
                    FileInputStream fileInputStream = (FileInputStream) inputStream;
                    if (G(fileInputStream.getFD())) {
                        this.f2838c = null;
                        this.f2837b = fileInputStream.getFD();
                    }
                }
                this.f2838c = null;
            }
            this.f2837b = null;
        }
        L(inputStream);
    }

    public a(String str) {
        e[][] eVarArr = f2818j0;
        this.f2841f = new HashMap[eVarArr.length];
        this.f2842g = new HashSet(eVarArr.length);
        this.f2843h = ByteOrder.BIG_ENDIAN;
        if (str == null) {
            throw new NullPointerException("filename cannot be null");
        }
        y(str);
    }

    private boolean A(byte[] bArr) {
        b bVar;
        long readInt;
        byte[] bArr2;
        b bVar2 = null;
        try {
            try {
                bVar = new b(bArr);
            } catch (Exception e10) {
                e = e10;
            }
        } catch (Throwable th) {
            th = th;
        }
        try {
            readInt = bVar.readInt();
            bArr2 = new byte[4];
            bVar.readFully(bArr2);
        } catch (Exception e11) {
            e = e11;
            bVar2 = bVar;
            if (f2830v) {
                Log.d("ExifInterface", "Exception parsing HEIF file type box.", e);
            }
            if (bVar2 != null) {
                bVar2.close();
            }
            return false;
        } catch (Throwable th2) {
            th = th2;
            bVar2 = bVar;
            if (bVar2 != null) {
                bVar2.close();
            }
            throw th;
        }
        if (!Arrays.equals(bArr2, C)) {
            bVar.close();
            return false;
        }
        long j10 = 16;
        if (readInt == 1) {
            readInt = bVar.readLong();
            if (readInt < 16) {
                bVar.close();
                return false;
            }
        } else {
            j10 = 8;
        }
        if (readInt > bArr.length) {
            readInt = bArr.length;
        }
        long j11 = readInt - j10;
        if (j11 < 8) {
            bVar.close();
            return false;
        }
        byte[] bArr3 = new byte[4];
        boolean z9 = false;
        boolean z10 = false;
        for (long j12 = 0; j12 < j11 / 4; j12++) {
            try {
                bVar.readFully(bArr3);
                if (j12 != 1) {
                    if (Arrays.equals(bArr3, D)) {
                        z9 = true;
                    } else if (Arrays.equals(bArr3, E)) {
                        z10 = true;
                    }
                    if (z9 && z10) {
                        bVar.close();
                        return true;
                    }
                }
            } catch (EOFException unused) {
                bVar.close();
                return false;
            }
        }
        bVar.close();
        return false;
    }

    private static boolean B(byte[] bArr) {
        int i10 = 0;
        while (true) {
            byte[] bArr2 = B;
            if (i10 >= bArr2.length) {
                return true;
            }
            if (bArr[i10] != bArr2[i10]) {
                return false;
            }
            i10++;
        }
    }

    private boolean C(byte[] bArr) {
        boolean z9 = false;
        b bVar = null;
        try {
            b bVar2 = new b(bArr);
            try {
                ByteOrder O2 = O(bVar2);
                this.f2843h = O2;
                bVar2.g(O2);
                short readShort = bVar2.readShort();
                z9 = (readShort == 20306 || readShort == 21330) ? true : true;
                bVar2.close();
                return z9;
            } catch (Exception unused) {
                bVar = bVar2;
                if (bVar != null) {
                    bVar.close();
                }
                return false;
            } catch (Throwable th) {
                th = th;
                bVar = bVar2;
                if (bVar != null) {
                    bVar.close();
                }
                throw th;
            }
        } catch (Exception unused2) {
        } catch (Throwable th2) {
            th = th2;
        }
    }

    private boolean D(byte[] bArr) {
        int i10 = 0;
        while (true) {
            byte[] bArr2 = H;
            if (i10 >= bArr2.length) {
                return true;
            }
            if (bArr[i10] != bArr2[i10]) {
                return false;
            }
            i10++;
        }
    }

    private boolean E(byte[] bArr) {
        byte[] bytes = "FUJIFILMCCD-RAW".getBytes(Charset.defaultCharset());
        for (int i10 = 0; i10 < bytes.length; i10++) {
            if (bArr[i10] != bytes[i10]) {
                return false;
            }
        }
        return true;
    }

    private boolean F(byte[] bArr) {
        b bVar = null;
        try {
            b bVar2 = new b(bArr);
            try {
                ByteOrder O2 = O(bVar2);
                this.f2843h = O2;
                bVar2.g(O2);
                boolean z9 = bVar2.readShort() == 85;
                bVar2.close();
                return z9;
            } catch (Exception unused) {
                bVar = bVar2;
                if (bVar != null) {
                    bVar.close();
                }
                return false;
            } catch (Throwable th) {
                th = th;
                bVar = bVar2;
                if (bVar != null) {
                    bVar.close();
                }
                throw th;
            }
        } catch (Exception unused2) {
        } catch (Throwable th2) {
            th = th2;
        }
    }

    private static boolean G(FileDescriptor fileDescriptor) {
        try {
            b.a.c(fileDescriptor, 0L, OsConstants.SEEK_CUR);
            return true;
        } catch (Exception unused) {
            if (f2830v) {
                Log.d("ExifInterface", "The file descriptor for the given input is not seekable");
                return false;
            }
            return false;
        }
    }

    private boolean H(HashMap hashMap) {
        d dVar;
        int m10;
        d dVar2 = (d) hashMap.get("BitsPerSample");
        if (dVar2 != null) {
            int[] iArr = (int[]) dVar2.o(this.f2843h);
            int[] iArr2 = f2834y;
            if (Arrays.equals(iArr2, iArr)) {
                return true;
            }
            if (this.f2839d == 3 && (dVar = (d) hashMap.get("PhotometricInterpretation")) != null && (((m10 = dVar.m(this.f2843h)) == 1 && Arrays.equals(iArr, A)) || (m10 == 6 && Arrays.equals(iArr, iArr2)))) {
                return true;
            }
        }
        if (f2830v) {
            Log.d("ExifInterface", "Unsupported data type value");
            return false;
        }
        return false;
    }

    private static boolean I(int i10) {
        return i10 == 4 || i10 == 13 || i10 == 14;
    }

    private boolean J(HashMap hashMap) {
        d dVar = (d) hashMap.get("ImageLength");
        d dVar2 = (d) hashMap.get("ImageWidth");
        if (dVar == null || dVar2 == null) {
            return false;
        }
        return dVar.m(this.f2843h) <= 512 && dVar2.m(this.f2843h) <= 512;
    }

    private boolean K(byte[] bArr) {
        int i10 = 0;
        while (true) {
            byte[] bArr2 = L;
            if (i10 >= bArr2.length) {
                int i11 = 0;
                while (true) {
                    byte[] bArr3 = M;
                    if (i11 >= bArr3.length) {
                        return true;
                    }
                    if (bArr[L.length + i11 + 4] != bArr3[i11]) {
                        return false;
                    }
                    i11++;
                }
            } else if (bArr[i10] != bArr2[i10]) {
                return false;
            } else {
                i10++;
            }
        }
    }

    private void L(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputstream shouldn't be null");
        }
        for (int i10 = 0; i10 < f2818j0.length; i10++) {
            try {
                try {
                    this.f2841f[i10] = new HashMap();
                } finally {
                    a();
                    if (f2830v) {
                        N();
                    }
                }
            } catch (IOException | UnsupportedOperationException e10) {
                boolean z9 = f2830v;
                if (z9) {
                    Log.w("ExifInterface", "Invalid image: ExifInterface got an unsupported image format file(ExifInterface supports JPEG and some RAW image formats only) or a corrupted JPEG file to ExifInterface.", e10);
                }
                a();
                if (!z9) {
                    return;
                }
            }
        }
        if (!this.f2840e) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 5000);
            this.f2839d = k(bufferedInputStream);
            inputStream = bufferedInputStream;
        }
        if (a0(this.f2839d)) {
            g gVar = new g(inputStream);
            if (this.f2840e) {
                r(gVar);
            } else {
                int i11 = this.f2839d;
                if (i11 == 12) {
                    h(gVar);
                } else if (i11 == 7) {
                    l(gVar);
                } else if (i11 == 10) {
                    q(gVar);
                } else {
                    o(gVar);
                }
            }
            gVar.m(this.f2851p);
            Z(gVar);
        } else {
            b bVar = new b(inputStream);
            int i12 = this.f2839d;
            if (i12 == 4) {
                i(bVar, 0, 0);
            } else if (i12 == 13) {
                m(bVar);
            } else if (i12 == 9) {
                n(bVar);
            } else if (i12 == 14) {
                u(bVar);
            }
        }
    }

    private void M(b bVar) {
        ByteOrder O2 = O(bVar);
        this.f2843h = O2;
        bVar.g(O2);
        int readUnsignedShort = bVar.readUnsignedShort();
        int i10 = this.f2839d;
        if (i10 != 7 && i10 != 10 && readUnsignedShort != 42) {
            throw new IOException("Invalid start code: " + Integer.toHexString(readUnsignedShort));
        }
        int readInt = bVar.readInt();
        if (readInt < 8) {
            throw new IOException("Invalid first Ifd offset: " + readInt);
        }
        int i11 = readInt - 8;
        if (i11 > 0) {
            bVar.k(i11);
        }
    }

    private void N() {
        for (int i10 = 0; i10 < this.f2841f.length; i10++) {
            Log.d("ExifInterface", "The size of tag group[" + i10 + "]: " + this.f2841f[i10].size());
            for (Map.Entry entry : this.f2841f[i10].entrySet()) {
                d dVar = (d) entry.getValue();
                Log.d("ExifInterface", "tagName: " + ((String) entry.getKey()) + ", tagType: " + dVar.toString() + ", tagValue: '" + dVar.n(this.f2843h) + "'");
            }
        }
    }

    private ByteOrder O(b bVar) {
        short readShort = bVar.readShort();
        if (readShort == 18761) {
            if (f2830v) {
                Log.d("ExifInterface", "readExifSegment: Byte Align II");
            }
            return ByteOrder.LITTLE_ENDIAN;
        } else if (readShort == 19789) {
            if (f2830v) {
                Log.d("ExifInterface", "readExifSegment: Byte Align MM");
            }
            return ByteOrder.BIG_ENDIAN;
        } else {
            throw new IOException("Invalid byte order: " + Integer.toHexString(readShort));
        }
    }

    private void P(byte[] bArr, int i10) {
        g gVar = new g(bArr);
        M(gVar);
        Q(gVar, i10);
    }

    /* JADX WARN: Removed duplicated region for block: B:102:0x028d  */
    /* JADX WARN: Removed duplicated region for block: B:47:0x012e  */
    /* JADX WARN: Removed duplicated region for block: B:48:0x0136  */
    /* JADX WARN: Removed duplicated region for block: B:89:0x0224  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    private void Q(g gVar, int i10) {
        StringBuilder sb;
        String str;
        String str2;
        short s9;
        int[] iArr;
        long j10;
        boolean z9;
        StringBuilder sb2;
        short s10;
        long j11;
        String str3;
        int i11;
        String str4;
        long j12;
        int readUnsignedShort;
        String str5;
        this.f2842g.add(Integer.valueOf(gVar.b()));
        short readShort = gVar.readShort();
        String str6 = "ExifInterface";
        if (f2830v) {
            Log.d("ExifInterface", "numberOfDirectoryEntry: " + ((int) readShort));
        }
        if (readShort <= 0) {
            return;
        }
        char c10 = 0;
        short s11 = 0;
        while (s11 < readShort) {
            int readUnsignedShort2 = gVar.readUnsignedShort();
            int readUnsignedShort3 = gVar.readUnsignedShort();
            int readInt = gVar.readInt();
            long b10 = gVar.b() + 4;
            e eVar = (e) f2820l0[i10].get(Integer.valueOf(readUnsignedShort2));
            boolean z10 = f2830v;
            if (z10) {
                Object[] objArr = new Object[5];
                objArr[c10] = Integer.valueOf(i10);
                objArr[1] = Integer.valueOf(readUnsignedShort2);
                objArr[2] = eVar != null ? eVar.f2872b : null;
                objArr[3] = Integer.valueOf(readUnsignedShort3);
                objArr[4] = Integer.valueOf(readInt);
                Log.d(str6, String.format("ifdType: %d, tagNumber: %d, tagName: %s, dataFormat: %d, numberOfComponents: %d", objArr));
            }
            if (eVar == null) {
                if (z10) {
                    sb2 = new StringBuilder();
                    sb2.append("Skip the tag entry since tag number is not defined: ");
                    sb2.append(readUnsignedShort2);
                    Log.d(str6, sb2.toString());
                }
                str2 = str6;
                s9 = s11;
            } else {
                if (readUnsignedShort3 > 0) {
                    if (readUnsignedShort3 < X.length) {
                        if (eVar.a(readUnsignedShort3)) {
                            if (readUnsignedShort3 == 7) {
                                readUnsignedShort3 = eVar.f2873c;
                            }
                            str2 = str6;
                            s9 = s11;
                            j10 = readInt * iArr[readUnsignedShort3];
                            if (j10 < 0 || j10 > 2147483647L) {
                                if (z10) {
                                    Log.d(str2, "Skip the tag entry since the number of components is invalid: " + readInt);
                                }
                                z9 = false;
                                if (z9) {
                                    if (j10 > 4) {
                                        int readInt2 = gVar.readInt();
                                        s10 = readShort;
                                        if (z10) {
                                            StringBuilder sb3 = new StringBuilder();
                                            j11 = b10;
                                            sb3.append("seek to data offset: ");
                                            sb3.append(readInt2);
                                            Log.d(str2, sb3.toString());
                                        } else {
                                            j11 = b10;
                                        }
                                        if (this.f2839d == 7) {
                                            if ("MakerNote".equals(eVar.f2872b)) {
                                                this.f2852q = readInt2;
                                            } else if (i10 == 6 && "ThumbnailImage".equals(eVar.f2872b)) {
                                                this.f2853r = readInt2;
                                                this.f2854s = readInt;
                                                d j13 = d.j(6, this.f2843h);
                                                i11 = readInt;
                                                d f10 = d.f(this.f2853r, this.f2843h);
                                                str3 = str2;
                                                d f11 = d.f(this.f2854s, this.f2843h);
                                                this.f2841f[4].put("Compression", j13);
                                                this.f2841f[4].put("JPEGInterchangeFormat", f10);
                                                this.f2841f[4].put("JPEGInterchangeFormatLength", f11);
                                                gVar.m(readInt2);
                                            }
                                        }
                                        str3 = str2;
                                        i11 = readInt;
                                        gVar.m(readInt2);
                                    } else {
                                        s10 = readShort;
                                        j11 = b10;
                                        str3 = str2;
                                        i11 = readInt;
                                    }
                                    Integer num = (Integer) f2823o0.get(Integer.valueOf(readUnsignedShort2));
                                    if (z10) {
                                        str4 = str3;
                                        Log.d(str4, "nextIfdType: " + num + " byteCount: " + j10);
                                    } else {
                                        str4 = str3;
                                    }
                                    if (num != null) {
                                        long j14 = -1;
                                        if (readUnsignedShort3 != 3) {
                                            if (readUnsignedShort3 == 4) {
                                                j14 = gVar.c();
                                            } else if (readUnsignedShort3 == 8) {
                                                readUnsignedShort = gVar.readShort();
                                            } else if (readUnsignedShort3 == 9 || readUnsignedShort3 == 13) {
                                                readUnsignedShort = gVar.readInt();
                                            }
                                            if (z10) {
                                                Log.d(str4, String.format("Offset: %d, tagName: %s", Long.valueOf(j14), eVar.f2872b));
                                            }
                                            if (j14 > 0 || (gVar.a() != -1 && j14 >= gVar.a())) {
                                                if (z10) {
                                                    str5 = "Skip jump into the IFD since its offset is invalid: " + j14;
                                                    if (gVar.a() != -1) {
                                                        str5 = str5 + " (total length: " + gVar.a() + ")";
                                                    }
                                                    Log.d(str4, str5);
                                                }
                                                j12 = j11;
                                            } else {
                                                if (!this.f2842g.contains(Integer.valueOf((int) j14))) {
                                                    gVar.m(j14);
                                                    Q(gVar, num.intValue());
                                                } else if (z10) {
                                                    str5 = "Skip jump into the IFD since it has already been read: IfdType " + num + " (at " + j14 + ")";
                                                    Log.d(str4, str5);
                                                }
                                                j12 = j11;
                                            }
                                        } else {
                                            readUnsignedShort = gVar.readUnsignedShort();
                                        }
                                        j14 = readUnsignedShort;
                                        if (z10) {
                                        }
                                        if (j14 > 0) {
                                        }
                                        if (z10) {
                                        }
                                        j12 = j11;
                                    } else {
                                        j12 = j11;
                                        byte[] bArr = new byte[(int) j10];
                                        gVar.readFully(bArr);
                                        d dVar = new d(readUnsignedShort3, i11, gVar.b() + this.f2851p, bArr);
                                        this.f2841f[i10].put(eVar.f2872b, dVar);
                                        if ("DNGVersion".equals(eVar.f2872b)) {
                                            this.f2839d = 3;
                                        }
                                        if ((("Make".equals(eVar.f2872b) || "Model".equals(eVar.f2872b)) && dVar.n(this.f2843h).contains("PENTAX")) || ("Compression".equals(eVar.f2872b) && dVar.m(this.f2843h) == 65535)) {
                                            this.f2839d = 8;
                                        }
                                        if (gVar.b() == j12) {
                                        }
                                    }
                                    gVar.m(j12);
                                } else {
                                    gVar.m(b10);
                                    s10 = readShort;
                                    str4 = str2;
                                }
                                s11 = (short) (s9 + 1);
                                str6 = str4;
                                readShort = s10;
                                c10 = 0;
                            } else {
                                z9 = true;
                                if (z9) {
                                }
                                s11 = (short) (s9 + 1);
                                str6 = str4;
                                readShort = s10;
                                c10 = 0;
                            }
                        } else {
                            if (z10) {
                                sb2 = new StringBuilder();
                                sb2.append("Skip the tag entry since data format (");
                                sb2.append(W[readUnsignedShort3]);
                                sb2.append(") is unexpected for tag: ");
                                sb2.append(eVar.f2872b);
                                Log.d(str6, sb2.toString());
                            }
                            str2 = str6;
                            s9 = s11;
                        }
                    }
                }
                str2 = str6;
                s9 = s11;
                if (z10) {
                    Log.d(str2, "Skip the tag entry since data format is invalid: " + readUnsignedShort3);
                }
            }
            j10 = 0;
            z9 = false;
            if (z9) {
            }
            s11 = (short) (s9 + 1);
            str6 = str4;
            readShort = s10;
            c10 = 0;
        }
        String str7 = str6;
        int readInt3 = gVar.readInt();
        boolean z11 = f2830v;
        if (z11) {
            Log.d(str7, String.format("nextIfdOffset: %d", Integer.valueOf(readInt3)));
        }
        long j15 = readInt3;
        if (j15 > 0) {
            if (!this.f2842g.contains(Integer.valueOf(readInt3))) {
                gVar.m(j15);
                if (this.f2841f[4].isEmpty()) {
                    Q(gVar, 4);
                    return;
                } else if (this.f2841f[5].isEmpty()) {
                    Q(gVar, 5);
                    return;
                } else {
                    return;
                }
            } else if (!z11) {
                return;
            } else {
                sb = new StringBuilder();
                str = "Stop reading file since re-reading an IFD may cause an infinite loop: ";
            }
        } else if (!z11) {
            return;
        } else {
            sb = new StringBuilder();
            str = "Stop reading file since a wrong offset may cause an infinite loop: ";
        }
        sb.append(str);
        sb.append(readInt3);
        Log.d(str7, sb.toString());
    }

    private void R(String str) {
        for (int i10 = 0; i10 < f2818j0.length; i10++) {
            this.f2841f[i10].remove(str);
        }
    }

    private void S(int i10, String str, String str2) {
        if (this.f2841f[i10].isEmpty() || this.f2841f[i10].get(str) == null) {
            return;
        }
        HashMap hashMap = this.f2841f[i10];
        hashMap.put(str2, hashMap.get(str));
        this.f2841f[i10].remove(str);
    }

    private void T(g gVar, int i10) {
        d dVar = (d) this.f2841f[i10].get("ImageLength");
        d dVar2 = (d) this.f2841f[i10].get("ImageWidth");
        if (dVar == null || dVar2 == null) {
            d dVar3 = (d) this.f2841f[i10].get("JPEGInterchangeFormat");
            d dVar4 = (d) this.f2841f[i10].get("JPEGInterchangeFormatLength");
            if (dVar3 == null || dVar4 == null) {
                return;
            }
            int m10 = dVar3.m(this.f2843h);
            int m11 = dVar3.m(this.f2843h);
            gVar.m(m10);
            byte[] bArr = new byte[m11];
            gVar.readFully(bArr);
            i(new b(bArr), m10, i10);
        }
    }

    private void V(InputStream inputStream, OutputStream outputStream) {
        if (f2830v) {
            Log.d("ExifInterface", "saveJpegAttributes starting with (inputStream: " + inputStream + ", outputStream: " + outputStream + ")");
        }
        b bVar = new b(inputStream);
        c cVar = new c(outputStream, ByteOrder.BIG_ENDIAN);
        if (bVar.readByte() != -1) {
            throw new IOException("Invalid marker");
        }
        cVar.b(-1);
        if (bVar.readByte() != -40) {
            throw new IOException("Invalid marker");
        }
        cVar.b(-40);
        d dVar = null;
        if (e("Xmp") != null && this.f2856u) {
            dVar = (d) this.f2841f[0].remove("Xmp");
        }
        cVar.b(-1);
        cVar.b(-31);
        e0(cVar);
        if (dVar != null) {
            this.f2841f[0].put("Xmp", dVar);
        }
        byte[] bArr = new byte[4096];
        while (bVar.readByte() == -1) {
            byte readByte = bVar.readByte();
            if (readByte == -39 || readByte == -38) {
                cVar.b(-1);
                cVar.b(readByte);
                androidx.exifinterface.media.b.d(bVar, cVar);
                return;
            } else if (readByte != -31) {
                cVar.b(-1);
                cVar.b(readByte);
                int readUnsignedShort = bVar.readUnsignedShort();
                cVar.m(readUnsignedShort);
                int i10 = readUnsignedShort - 2;
                if (i10 < 0) {
                    throw new IOException("Invalid length");
                }
                while (i10 > 0) {
                    int read = bVar.read(bArr, 0, Math.min(i10, 4096));
                    if (read >= 0) {
                        cVar.write(bArr, 0, read);
                        i10 -= read;
                    }
                }
            } else {
                int readUnsignedShort2 = bVar.readUnsignedShort() - 2;
                if (readUnsignedShort2 < 0) {
                    throw new IOException("Invalid length");
                }
                byte[] bArr2 = new byte[6];
                if (readUnsignedShort2 >= 6) {
                    bVar.readFully(bArr2);
                    if (Arrays.equals(bArr2, f2825q0)) {
                        bVar.k(readUnsignedShort2 - 6);
                    }
                }
                cVar.b(-1);
                cVar.b(readByte);
                cVar.m(readUnsignedShort2 + 2);
                if (readUnsignedShort2 >= 6) {
                    readUnsignedShort2 -= 6;
                    cVar.write(bArr2);
                }
                while (readUnsignedShort2 > 0) {
                    int read2 = bVar.read(bArr, 0, Math.min(readUnsignedShort2, 4096));
                    if (read2 >= 0) {
                        cVar.write(bArr, 0, read2);
                        readUnsignedShort2 -= read2;
                    }
                }
            }
        }
        throw new IOException("Invalid marker");
    }

    private void W(InputStream inputStream, OutputStream outputStream) {
        ByteArrayOutputStream byteArrayOutputStream;
        if (f2830v) {
            Log.d("ExifInterface", "savePngAttributes starting with (inputStream: " + inputStream + ", outputStream: " + outputStream + ")");
        }
        b bVar = new b(inputStream);
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        c cVar = new c(outputStream, byteOrder);
        byte[] bArr = H;
        androidx.exifinterface.media.b.e(bVar, cVar, bArr.length);
        int i10 = this.f2851p;
        if (i10 == 0) {
            int readInt = bVar.readInt();
            cVar.c(readInt);
            androidx.exifinterface.media.b.e(bVar, cVar, readInt + 4 + 4);
        } else {
            androidx.exifinterface.media.b.e(bVar, cVar, ((i10 - bArr.length) - 4) - 4);
            bVar.k(bVar.readInt() + 4 + 4);
        }
        ByteArrayOutputStream byteArrayOutputStream2 = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
        } catch (Throwable th) {
            th = th;
        }
        try {
            c cVar2 = new c(byteArrayOutputStream, byteOrder);
            e0(cVar2);
            byte[] byteArray = ((ByteArrayOutputStream) cVar2.f2865g).toByteArray();
            cVar.write(byteArray);
            CRC32 crc32 = new CRC32();
            crc32.update(byteArray, 4, byteArray.length - 4);
            cVar.c((int) crc32.getValue());
            androidx.exifinterface.media.b.b(byteArrayOutputStream);
            androidx.exifinterface.media.b.d(bVar, cVar);
        } catch (Throwable th2) {
            th = th2;
            byteArrayOutputStream2 = byteArrayOutputStream;
            androidx.exifinterface.media.b.b(byteArrayOutputStream2);
            throw th;
        }
    }

    private void X(InputStream inputStream, OutputStream outputStream) {
        ByteArrayOutputStream byteArrayOutputStream;
        int i10;
        int i11;
        int i12;
        boolean z9;
        if (f2830v) {
            Log.d("ExifInterface", "saveWebpAttributes starting with (inputStream: " + inputStream + ", outputStream: " + outputStream + ")");
        }
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        b bVar = new b(inputStream, byteOrder);
        c cVar = new c(outputStream, byteOrder);
        byte[] bArr = L;
        androidx.exifinterface.media.b.e(bVar, cVar, bArr.length);
        byte[] bArr2 = M;
        bVar.k(bArr2.length + 4);
        ByteArrayOutputStream byteArrayOutputStream2 = null;
        try {
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
            } catch (Throwable th) {
                th = th;
            }
        } catch (Exception e10) {
            e = e10;
        }
        try {
            c cVar2 = new c(byteArrayOutputStream, byteOrder);
            int i13 = this.f2851p;
            if (i13 != 0) {
                androidx.exifinterface.media.b.e(bVar, cVar2, ((i13 - ((bArr.length + 4) + bArr2.length)) - 4) - 4);
                bVar.k(4);
                int readInt = bVar.readInt();
                if (readInt % 2 != 0) {
                    readInt++;
                }
                bVar.k(readInt);
            } else {
                byte[] bArr3 = new byte[4];
                bVar.readFully(bArr3);
                byte[] bArr4 = P;
                boolean z10 = true;
                if (!Arrays.equals(bArr3, bArr4)) {
                    byte[] bArr5 = R;
                    if (Arrays.equals(bArr3, bArr5) || Arrays.equals(bArr3, Q)) {
                        int readInt2 = bVar.readInt();
                        int i14 = readInt2 % 2 == 1 ? readInt2 + 1 : readInt2;
                        byte[] bArr6 = new byte[3];
                        if (Arrays.equals(bArr3, bArr5)) {
                            bVar.readFully(bArr6);
                            byte[] bArr7 = new byte[3];
                            bVar.readFully(bArr7);
                            if (!Arrays.equals(O, bArr7)) {
                                throw new IOException("Error checking VP8 signature");
                            }
                            int readInt3 = bVar.readInt();
                            i12 = (readInt3 << 2) >> 18;
                            i14 -= 10;
                            i10 = (readInt3 << 18) >> 18;
                            i11 = readInt3;
                            z10 = false;
                        } else if (!Arrays.equals(bArr3, Q)) {
                            i10 = 0;
                            z10 = false;
                            i11 = 0;
                            i12 = 0;
                        } else if (bVar.readByte() != 47) {
                            throw new IOException("Error checking VP8L signature");
                        } else {
                            i11 = bVar.readInt();
                            i10 = (i11 & 16383) + 1;
                            i12 = ((i11 & 268419072) >>> 14) + 1;
                            if ((i11 & 268435456) == 0) {
                                z10 = false;
                            }
                            i14 -= 5;
                        }
                        cVar2.write(bArr4);
                        cVar2.c(10);
                        byte[] bArr8 = new byte[10];
                        if (z10) {
                            bArr8[0] = (byte) (bArr8[0] | 16);
                        }
                        bArr8[0] = (byte) (bArr8[0] | 8);
                        int i15 = i10 - 1;
                        int i16 = i12 - 1;
                        bArr8[4] = (byte) i15;
                        bArr8[5] = (byte) (i15 >> 8);
                        bArr8[6] = (byte) (i15 >> 16);
                        bArr8[7] = (byte) i16;
                        bArr8[8] = (byte) (i16 >> 8);
                        bArr8[9] = (byte) (i16 >> 16);
                        cVar2.write(bArr8);
                        cVar2.write(bArr3);
                        cVar2.c(readInt2);
                        if (Arrays.equals(bArr3, bArr5)) {
                            cVar2.write(bArr6);
                            cVar2.write(O);
                        } else {
                            if (Arrays.equals(bArr3, Q)) {
                                cVar2.write(47);
                            }
                            androidx.exifinterface.media.b.e(bVar, cVar2, i14);
                        }
                        cVar2.c(i11);
                        androidx.exifinterface.media.b.e(bVar, cVar2, i14);
                    }
                    androidx.exifinterface.media.b.d(bVar, cVar2);
                    int size = byteArrayOutputStream.size();
                    byte[] bArr9 = M;
                    cVar.c(size + bArr9.length);
                    cVar.write(bArr9);
                    byteArrayOutputStream.writeTo(cVar);
                    androidx.exifinterface.media.b.b(byteArrayOutputStream);
                }
                int readInt4 = bVar.readInt();
                byte[] bArr10 = new byte[readInt4 % 2 == 1 ? readInt4 + 1 : readInt4];
                bVar.readFully(bArr10);
                byte b10 = (byte) (8 | bArr10[0]);
                bArr10[0] = b10;
                boolean z11 = ((b10 >> 1) & 1) == 1;
                cVar2.write(bArr4);
                cVar2.c(readInt4);
                cVar2.write(bArr10);
                if (z11) {
                    c(bVar, cVar2, S, null);
                    while (true) {
                        byte[] bArr11 = new byte[4];
                        try {
                            bVar.readFully(bArr11);
                            z9 = !Arrays.equals(bArr11, T);
                        } catch (EOFException unused) {
                            z9 = true;
                        }
                        if (z9) {
                            break;
                        }
                        d(bVar, cVar2, bArr11);
                    }
                } else {
                    c(bVar, cVar2, R, Q);
                }
            }
            e0(cVar2);
            androidx.exifinterface.media.b.d(bVar, cVar2);
            int size2 = byteArrayOutputStream.size();
            byte[] bArr92 = M;
            cVar.c(size2 + bArr92.length);
            cVar.write(bArr92);
            byteArrayOutputStream.writeTo(cVar);
            androidx.exifinterface.media.b.b(byteArrayOutputStream);
        } catch (Exception e11) {
            e = e11;
            throw new IOException("Failed to save WebP file", e);
        } catch (Throwable th2) {
            th = th2;
            byteArrayOutputStream2 = byteArrayOutputStream;
            androidx.exifinterface.media.b.b(byteArrayOutputStream2);
            throw th;
        }
    }

    private void Z(b bVar) {
        HashMap hashMap = this.f2841f[4];
        d dVar = (d) hashMap.get("Compression");
        if (dVar != null) {
            int m10 = dVar.m(this.f2843h);
            this.f2850o = m10;
            if (m10 != 1) {
                if (m10 != 6) {
                    if (m10 != 7) {
                        return;
                    }
                }
            }
            if (H(hashMap)) {
                x(bVar, hashMap);
                return;
            }
            return;
        }
        this.f2850o = 6;
        w(bVar, hashMap);
    }

    private void a() {
        String e10 = e("DateTimeOriginal");
        if (e10 != null && e("DateTime") == null) {
            this.f2841f[0].put("DateTime", d.e(e10));
        }
        if (e("ImageWidth") == null) {
            this.f2841f[0].put("ImageWidth", d.f(0L, this.f2843h));
        }
        if (e("ImageLength") == null) {
            this.f2841f[0].put("ImageLength", d.f(0L, this.f2843h));
        }
        if (e("Orientation") == null) {
            this.f2841f[0].put("Orientation", d.f(0L, this.f2843h));
        }
        if (e("LightSource") == null) {
            this.f2841f[1].put("LightSource", d.f(0L, this.f2843h));
        }
    }

    private static boolean a0(int i10) {
        return (i10 == 4 || i10 == 9 || i10 == 13 || i10 == 14) ? false : true;
    }

    private static double b(String str, String str2) {
        try {
            String[] split = str.split(",", -1);
            String[] split2 = split[0].split("/", -1);
            String[] split3 = split[1].split("/", -1);
            String[] split4 = split[2].split("/", -1);
            double parseDouble = (Double.parseDouble(split2[0].trim()) / Double.parseDouble(split2[1].trim())) + ((Double.parseDouble(split3[0].trim()) / Double.parseDouble(split3[1].trim())) / 60.0d) + ((Double.parseDouble(split4[0].trim()) / Double.parseDouble(split4[1].trim())) / 3600.0d);
            if (!str2.equals("S") && !str2.equals("W")) {
                if (!str2.equals("N") && !str2.equals("E")) {
                    throw new IllegalArgumentException();
                }
                return parseDouble;
            }
            return -parseDouble;
        } catch (ArrayIndexOutOfBoundsException | NumberFormatException unused) {
            throw new IllegalArgumentException();
        }
    }

    private void b0(int i10, int i11) {
        String str;
        if (this.f2841f[i10].isEmpty() || this.f2841f[i11].isEmpty()) {
            if (f2830v) {
                Log.d("ExifInterface", "Cannot perform swap since only one image data exists");
                return;
            }
            return;
        }
        d dVar = (d) this.f2841f[i10].get("ImageLength");
        d dVar2 = (d) this.f2841f[i10].get("ImageWidth");
        d dVar3 = (d) this.f2841f[i11].get("ImageLength");
        d dVar4 = (d) this.f2841f[i11].get("ImageWidth");
        if (dVar == null || dVar2 == null) {
            if (!f2830v) {
                return;
            }
            str = "First image does not contain valid size information";
        } else if (dVar3 != null && dVar4 != null) {
            int m10 = dVar.m(this.f2843h);
            int m11 = dVar2.m(this.f2843h);
            int m12 = dVar3.m(this.f2843h);
            int m13 = dVar4.m(this.f2843h);
            if (m10 >= m12 || m11 >= m13) {
                return;
            }
            HashMap[] hashMapArr = this.f2841f;
            HashMap hashMap = hashMapArr[i10];
            hashMapArr[i10] = hashMapArr[i11];
            hashMapArr[i11] = hashMap;
            return;
        } else if (!f2830v) {
            return;
        } else {
            str = "Second image does not contain valid size information";
        }
        Log.d("ExifInterface", str);
    }

    private void c(b bVar, c cVar, byte[] bArr, byte[] bArr2) {
        while (true) {
            byte[] bArr3 = new byte[4];
            bVar.readFully(bArr3);
            d(bVar, cVar, bArr3);
            if (Arrays.equals(bArr3, bArr)) {
                return;
            }
            if (bArr2 != null && Arrays.equals(bArr3, bArr2)) {
                return;
            }
        }
    }

    private void c0(g gVar, int i10) {
        StringBuilder sb;
        String arrays;
        d j10;
        d j11;
        d dVar = (d) this.f2841f[i10].get("DefaultCropSize");
        d dVar2 = (d) this.f2841f[i10].get("SensorTopBorder");
        d dVar3 = (d) this.f2841f[i10].get("SensorLeftBorder");
        d dVar4 = (d) this.f2841f[i10].get("SensorBottomBorder");
        d dVar5 = (d) this.f2841f[i10].get("SensorRightBorder");
        if (dVar == null) {
            if (dVar2 == null || dVar3 == null || dVar4 == null || dVar5 == null) {
                T(gVar, i10);
                return;
            }
            int m10 = dVar2.m(this.f2843h);
            int m11 = dVar4.m(this.f2843h);
            int m12 = dVar5.m(this.f2843h);
            int m13 = dVar3.m(this.f2843h);
            if (m11 <= m10 || m12 <= m13) {
                return;
            }
            d j12 = d.j(m11 - m10, this.f2843h);
            d j13 = d.j(m12 - m13, this.f2843h);
            this.f2841f[i10].put("ImageLength", j12);
            this.f2841f[i10].put("ImageWidth", j13);
        } else if (dVar.f2867a == 5) {
            f[] fVarArr = (f[]) dVar.o(this.f2843h);
            if (fVarArr != null && fVarArr.length == 2) {
                j10 = d.h(fVarArr[0], this.f2843h);
                j11 = d.h(fVarArr[1], this.f2843h);
                this.f2841f[i10].put("ImageWidth", j10);
                this.f2841f[i10].put("ImageLength", j11);
                return;
            }
            sb = new StringBuilder();
            sb.append("Invalid crop size values. cropSize=");
            arrays = Arrays.toString(fVarArr);
            sb.append(arrays);
            Log.w("ExifInterface", sb.toString());
        } else {
            int[] iArr = (int[]) dVar.o(this.f2843h);
            if (iArr != null && iArr.length == 2) {
                j10 = d.j(iArr[0], this.f2843h);
                j11 = d.j(iArr[1], this.f2843h);
                this.f2841f[i10].put("ImageWidth", j10);
                this.f2841f[i10].put("ImageLength", j11);
                return;
            }
            sb = new StringBuilder();
            sb.append("Invalid crop size values. cropSize=");
            arrays = Arrays.toString(iArr);
            sb.append(arrays);
            Log.w("ExifInterface", sb.toString());
        }
    }

    private void d(b bVar, c cVar, byte[] bArr) {
        int readInt = bVar.readInt();
        cVar.write(bArr);
        cVar.c(readInt);
        if (readInt % 2 == 1) {
            readInt++;
        }
        androidx.exifinterface.media.b.e(bVar, cVar, readInt);
    }

    private void d0() {
        b0(0, 5);
        b0(0, 4);
        b0(5, 4);
        d dVar = (d) this.f2841f[1].get("PixelXDimension");
        d dVar2 = (d) this.f2841f[1].get("PixelYDimension");
        if (dVar != null && dVar2 != null) {
            this.f2841f[0].put("ImageWidth", dVar);
            this.f2841f[0].put("ImageLength", dVar2);
        }
        if (this.f2841f[4].isEmpty() && J(this.f2841f[5])) {
            HashMap[] hashMapArr = this.f2841f;
            hashMapArr[4] = hashMapArr[5];
            hashMapArr[5] = new HashMap();
        }
        if (!J(this.f2841f[4])) {
            Log.d("ExifInterface", "No image meets the size requirements of a thumbnail image.");
        }
        S(0, "ThumbnailOrientation", "Orientation");
        S(0, "ThumbnailImageLength", "ImageLength");
        S(0, "ThumbnailImageWidth", "ImageWidth");
        S(5, "ThumbnailOrientation", "Orientation");
        S(5, "ThumbnailImageLength", "ImageLength");
        S(5, "ThumbnailImageWidth", "ImageWidth");
        S(4, "Orientation", "ThumbnailOrientation");
        S(4, "ImageLength", "ThumbnailImageLength");
        S(4, "ImageWidth", "ThumbnailImageWidth");
    }

    private int e0(c cVar) {
        e[][] eVarArr = f2818j0;
        int[] iArr = new int[eVarArr.length];
        int[] iArr2 = new int[eVarArr.length];
        for (e eVar : f2819k0) {
            R(eVar.f2872b);
        }
        if (this.f2844i) {
            if (this.f2845j) {
                R("StripOffsets");
                R("StripByteCounts");
            } else {
                R("JPEGInterchangeFormat");
                R("JPEGInterchangeFormatLength");
            }
        }
        for (int i10 = 0; i10 < f2818j0.length; i10++) {
            for (Object obj : this.f2841f[i10].entrySet().toArray()) {
                Map.Entry entry = (Map.Entry) obj;
                if (entry.getValue() == null) {
                    this.f2841f[i10].remove(entry.getKey());
                }
            }
        }
        if (!this.f2841f[1].isEmpty()) {
            this.f2841f[0].put(f2819k0[1].f2872b, d.f(0L, this.f2843h));
        }
        if (!this.f2841f[2].isEmpty()) {
            this.f2841f[0].put(f2819k0[2].f2872b, d.f(0L, this.f2843h));
        }
        if (!this.f2841f[3].isEmpty()) {
            this.f2841f[1].put(f2819k0[3].f2872b, d.f(0L, this.f2843h));
        }
        if (this.f2844i) {
            if (this.f2845j) {
                this.f2841f[4].put("StripOffsets", d.j(0, this.f2843h));
                this.f2841f[4].put("StripByteCounts", d.j(this.f2848m, this.f2843h));
            } else {
                this.f2841f[4].put("JPEGInterchangeFormat", d.f(0L, this.f2843h));
                this.f2841f[4].put("JPEGInterchangeFormatLength", d.f(this.f2848m, this.f2843h));
            }
        }
        for (int i11 = 0; i11 < f2818j0.length; i11++) {
            int i12 = 0;
            for (Map.Entry entry2 : this.f2841f[i11].entrySet()) {
                int p10 = ((d) entry2.getValue()).p();
                if (p10 > 4) {
                    i12 += p10;
                }
            }
            iArr2[i11] = iArr2[i11] + i12;
        }
        int i13 = 8;
        for (int i14 = 0; i14 < f2818j0.length; i14++) {
            if (!this.f2841f[i14].isEmpty()) {
                iArr[i14] = i13;
                i13 += (this.f2841f[i14].size() * 12) + 2 + 4 + iArr2[i14];
            }
        }
        if (this.f2844i) {
            if (this.f2845j) {
                this.f2841f[4].put("StripOffsets", d.j(i13, this.f2843h));
            } else {
                this.f2841f[4].put("JPEGInterchangeFormat", d.f(i13, this.f2843h));
            }
            this.f2847l = i13;
            i13 += this.f2848m;
        }
        if (this.f2839d == 4) {
            i13 += 8;
        }
        if (f2830v) {
            for (int i15 = 0; i15 < f2818j0.length; i15++) {
                Log.d("ExifInterface", String.format("index: %d, offsets: %d, tag count: %d, data sizes: %d, total size: %d", Integer.valueOf(i15), Integer.valueOf(iArr[i15]), Integer.valueOf(this.f2841f[i15].size()), Integer.valueOf(iArr2[i15]), Integer.valueOf(i13)));
            }
        }
        if (!this.f2841f[1].isEmpty()) {
            this.f2841f[0].put(f2819k0[1].f2872b, d.f(iArr[1], this.f2843h));
        }
        if (!this.f2841f[2].isEmpty()) {
            this.f2841f[0].put(f2819k0[2].f2872b, d.f(iArr[2], this.f2843h));
        }
        if (!this.f2841f[3].isEmpty()) {
            this.f2841f[1].put(f2819k0[3].f2872b, d.f(iArr[3], this.f2843h));
        }
        int i16 = this.f2839d;
        if (i16 != 4) {
            if (i16 == 13) {
                cVar.c(i13);
                cVar.write(I);
            } else if (i16 == 14) {
                cVar.write(N);
                cVar.c(i13);
            }
        } else if (i13 > 65535) {
            throw new IllegalStateException("Size of exif data (" + i13 + " bytes) exceeds the max size of a JPEG APP1 segment (65536 bytes)");
        } else {
            cVar.m(i13);
            cVar.write(f2825q0);
        }
        cVar.g(this.f2843h == ByteOrder.BIG_ENDIAN ? (short) 19789 : (short) 18761);
        cVar.a(this.f2843h);
        cVar.m(42);
        cVar.k(8L);
        for (int i17 = 0; i17 < f2818j0.length; i17++) {
            if (!this.f2841f[i17].isEmpty()) {
                cVar.m(this.f2841f[i17].size());
                int size = iArr[i17] + 2 + (this.f2841f[i17].size() * 12) + 4;
                for (Map.Entry entry3 : this.f2841f[i17].entrySet()) {
                    int i18 = ((e) f2821m0[i17].get(entry3.getKey())).f2871a;
                    d dVar = (d) entry3.getValue();
                    int p11 = dVar.p();
                    cVar.m(i18);
                    cVar.m(dVar.f2867a);
                    cVar.c(dVar.f2868b);
                    if (p11 > 4) {
                        cVar.k(size);
                        size += p11;
                    } else {
                        cVar.write(dVar.f2870d);
                        if (p11 < 4) {
                            while (p11 < 4) {
                                cVar.b(0);
                                p11++;
                            }
                        }
                    }
                }
                if (i17 != 0 || this.f2841f[4].isEmpty()) {
                    cVar.k(0L);
                } else {
                    cVar.k(iArr[4]);
                }
                for (Map.Entry entry4 : this.f2841f[i17].entrySet()) {
                    byte[] bArr = ((d) entry4.getValue()).f2870d;
                    if (bArr.length > 4) {
                        cVar.write(bArr, 0, bArr.length);
                    }
                }
            }
        }
        if (this.f2844i) {
            cVar.write(t());
        }
        if (this.f2839d == 14 && i13 % 2 == 1) {
            cVar.b(0);
        }
        cVar.a(ByteOrder.BIG_ENDIAN);
        return i13;
    }

    private d g(String str) {
        if (str != null) {
            if ("ISOSpeedRatings".equals(str)) {
                if (f2830v) {
                    Log.d("ExifInterface", "getExifAttribute: Replacing TAG_ISO_SPEED_RATINGS with TAG_PHOTOGRAPHIC_SENSITIVITY.");
                }
                str = "PhotographicSensitivity";
            }
            for (int i10 = 0; i10 < f2818j0.length; i10++) {
                d dVar = (d) this.f2841f[i10].get(str);
                if (dVar != null) {
                    return dVar;
                }
            }
            return null;
        }
        throw new NullPointerException("tag shouldn't be null");
    }

    private void h(g gVar) {
        String str;
        String str2;
        if (Build.VERSION.SDK_INT < 28) {
            throw new UnsupportedOperationException("Reading EXIF from HEIF files is supported from SDK 28 and above");
        }
        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
        try {
            try {
                b.C0031b.a(mediaMetadataRetriever, new C0030a(gVar));
                String extractMetadata = mediaMetadataRetriever.extractMetadata(33);
                String extractMetadata2 = mediaMetadataRetriever.extractMetadata(34);
                String extractMetadata3 = mediaMetadataRetriever.extractMetadata(26);
                String extractMetadata4 = mediaMetadataRetriever.extractMetadata(17);
                String str3 = null;
                if ("yes".equals(extractMetadata3)) {
                    str3 = mediaMetadataRetriever.extractMetadata(29);
                    str = mediaMetadataRetriever.extractMetadata(30);
                    str2 = mediaMetadataRetriever.extractMetadata(31);
                } else if ("yes".equals(extractMetadata4)) {
                    str3 = mediaMetadataRetriever.extractMetadata(18);
                    str = mediaMetadataRetriever.extractMetadata(19);
                    str2 = mediaMetadataRetriever.extractMetadata(24);
                } else {
                    str = null;
                    str2 = null;
                }
                if (str3 != null) {
                    this.f2841f[0].put("ImageWidth", d.j(Integer.parseInt(str3), this.f2843h));
                }
                if (str != null) {
                    this.f2841f[0].put("ImageLength", d.j(Integer.parseInt(str), this.f2843h));
                }
                if (str2 != null) {
                    int i10 = 1;
                    int parseInt = Integer.parseInt(str2);
                    if (parseInt == 90) {
                        i10 = 6;
                    } else if (parseInt == 180) {
                        i10 = 3;
                    } else if (parseInt == 270) {
                        i10 = 8;
                    }
                    this.f2841f[0].put("Orientation", d.j(i10, this.f2843h));
                }
                if (extractMetadata != null && extractMetadata2 != null) {
                    int parseInt2 = Integer.parseInt(extractMetadata);
                    int parseInt3 = Integer.parseInt(extractMetadata2);
                    if (parseInt3 <= 6) {
                        throw new IOException("Invalid exif length");
                    }
                    gVar.m(parseInt2);
                    byte[] bArr = new byte[6];
                    gVar.readFully(bArr);
                    int i11 = parseInt2 + 6;
                    int i12 = parseInt3 - 6;
                    if (!Arrays.equals(bArr, f2825q0)) {
                        throw new IOException("Invalid identifier");
                    }
                    byte[] bArr2 = new byte[i12];
                    gVar.readFully(bArr2);
                    this.f2851p = i11;
                    P(bArr2, 0);
                }
                if (f2830v) {
                    Log.d("ExifInterface", "Heif meta: " + str3 + "x" + str + ", rotation " + str2);
                }
            } catch (RuntimeException unused) {
                throw new UnsupportedOperationException("Failed to read EXIF from HEIF file. Given stream is either malformed or unsupported.");
            }
        } finally {
            mediaMetadataRetriever.release();
        }
    }

    /* JADX WARN: Code restructure failed: missing block: B:64:0x018f, code lost:
        r22.g(r21.f2843h);
     */
    /* JADX WARN: Code restructure failed: missing block: B:65:0x0194, code lost:
        return;
     */
    /* JADX WARN: Removed duplicated region for block: B:34:0x00ba A[FALL_THROUGH] */
    /* JADX WARN: Removed duplicated region for block: B:59:0x0179 A[LOOP:0: B:10:0x0038->B:59:0x0179, LOOP_END] */
    /* JADX WARN: Removed duplicated region for block: B:76:0x0183 A[SYNTHETIC] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    private void i(b bVar, int i10, int i11) {
        byte readByte;
        byte readByte2;
        String str;
        String str2 = "ExifInterface";
        if (f2830v) {
            Log.d("ExifInterface", "getJpegAttributes starting with: " + bVar);
        }
        bVar.g(ByteOrder.BIG_ENDIAN);
        byte b10 = -1;
        if (bVar.readByte() != -1) {
            throw new IOException("Invalid marker: " + Integer.toHexString(readByte & 255));
        } else if (bVar.readByte() != -40) {
            throw new IOException("Invalid marker: " + Integer.toHexString(readByte & 255));
        } else {
            int i12 = 2;
            int i13 = 2;
            while (true) {
                if (bVar.readByte() != b10) {
                    throw new IOException("Invalid marker:" + Integer.toHexString(readByte2 & 255));
                }
                int i14 = i13 + 1;
                byte readByte3 = bVar.readByte();
                boolean z9 = f2830v;
                if (z9) {
                    Log.d(str2, "Found JPEG segment indicator: " + Integer.toHexString(readByte3 & 255));
                }
                int i15 = i14 + 1;
                if (readByte3 != -39 && readByte3 != -38) {
                    int readUnsignedShort = bVar.readUnsignedShort() - i12;
                    int i16 = i15 + i12;
                    if (z9) {
                        Log.d(str2, "JPEG segment: " + Integer.toHexString(readByte3 & 255) + " (length: " + (readUnsignedShort + 2) + ")");
                    }
                    if (readUnsignedShort < 0) {
                        throw new IOException("Invalid length");
                    }
                    if (readByte3 == -31) {
                        byte[] bArr = new byte[readUnsignedShort];
                        bVar.readFully(bArr);
                        int i17 = i16 + readUnsignedShort;
                        byte[] bArr2 = f2825q0;
                        if (androidx.exifinterface.media.b.f(bArr, bArr2)) {
                            byte[] copyOfRange = Arrays.copyOfRange(bArr, bArr2.length, readUnsignedShort);
                            this.f2851p = i10 + i16 + bArr2.length;
                            P(copyOfRange, i11);
                            Z(new b(copyOfRange));
                        } else {
                            byte[] bArr3 = f2826r0;
                            if (androidx.exifinterface.media.b.f(bArr, bArr3)) {
                                int length = i16 + bArr3.length;
                                byte[] copyOfRange2 = Arrays.copyOfRange(bArr, bArr3.length, readUnsignedShort);
                                if (e("Xmp") == null) {
                                    str = str2;
                                    this.f2841f[0].put("Xmp", new d(1, copyOfRange2.length, length, copyOfRange2));
                                    this.f2856u = true;
                                    i16 = i17;
                                }
                            }
                        }
                        str = str2;
                        i16 = i17;
                    } else if (readByte3 != -2) {
                        switch (readByte3) {
                            default:
                                switch (readByte3) {
                                    default:
                                        switch (readByte3) {
                                            default:
                                                switch (readByte3) {
                                                }
                                            case -55:
                                            case -54:
                                            case -53:
                                                bVar.k(1);
                                                this.f2841f[i11].put(i11 != 4 ? "ImageLength" : "ThumbnailImageLength", d.f(bVar.readUnsignedShort(), this.f2843h));
                                                this.f2841f[i11].put(i11 != 4 ? "ImageWidth" : "ThumbnailImageWidth", d.f(bVar.readUnsignedShort(), this.f2843h));
                                                readUnsignedShort -= 5;
                                                break;
                                        }
                                    case -59:
                                    case -58:
                                    case -57:
                                        break;
                                }
                            case -64:
                            case -63:
                            case -62:
                            case -61:
                                break;
                        }
                        str = str2;
                        if (readUnsignedShort >= 0) {
                            throw new IOException("Invalid length");
                        }
                        bVar.k(readUnsignedShort);
                        i13 = i16 + readUnsignedShort;
                        str2 = str;
                        i12 = 2;
                        b10 = -1;
                    } else {
                        byte[] bArr4 = new byte[readUnsignedShort];
                        bVar.readFully(bArr4);
                        if (e("UserComment") == null) {
                            this.f2841f[1].put("UserComment", d.e(new String(bArr4, f2824p0)));
                        }
                        str = str2;
                    }
                    readUnsignedShort = 0;
                    if (readUnsignedShort >= 0) {
                    }
                }
            }
        }
    }

    private int k(BufferedInputStream bufferedInputStream) {
        bufferedInputStream.mark(5000);
        byte[] bArr = new byte[5000];
        bufferedInputStream.read(bArr);
        bufferedInputStream.reset();
        if (B(bArr)) {
            return 4;
        }
        if (E(bArr)) {
            return 9;
        }
        if (A(bArr)) {
            return 12;
        }
        if (C(bArr)) {
            return 7;
        }
        if (F(bArr)) {
            return 10;
        }
        if (D(bArr)) {
            return 13;
        }
        return K(bArr) ? 14 : 0;
    }

    /* JADX WARN: Removed duplicated region for block: B:17:0x008c  */
    /* JADX WARN: Removed duplicated region for block: B:33:? A[RETURN, SYNTHETIC] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    private void l(g gVar) {
        d dVar;
        d dVar2;
        d dVar3;
        int i10;
        int i11;
        long j10;
        o(gVar);
        d dVar4 = (d) this.f2841f[1].get("MakerNote");
        if (dVar4 == null) {
            return;
        }
        g gVar2 = new g(dVar4.f2870d);
        gVar2.g(this.f2843h);
        byte[] bArr = F;
        byte[] bArr2 = new byte[bArr.length];
        gVar2.readFully(bArr2);
        gVar2.m(0L);
        byte[] bArr3 = G;
        byte[] bArr4 = new byte[bArr3.length];
        gVar2.readFully(bArr4);
        if (!Arrays.equals(bArr2, bArr)) {
            j10 = Arrays.equals(bArr4, bArr3) ? 12L : 12L;
            Q(gVar2, 6);
            dVar = (d) this.f2841f[7].get("PreviewImageStart");
            dVar2 = (d) this.f2841f[7].get("PreviewImageLength");
            if (dVar != null && dVar2 != null) {
                this.f2841f[5].put("JPEGInterchangeFormat", dVar);
                this.f2841f[5].put("JPEGInterchangeFormatLength", dVar2);
            }
            dVar3 = (d) this.f2841f[8].get("AspectFrame");
            if (dVar3 == null) {
                int[] iArr = (int[]) dVar3.o(this.f2843h);
                if (iArr == null || iArr.length != 4) {
                    Log.w("ExifInterface", "Invalid aspect frame values. frame=" + Arrays.toString(iArr));
                    return;
                }
                int i12 = iArr[2];
                int i13 = iArr[0];
                if (i12 <= i13 || (i10 = iArr[3]) <= (i11 = iArr[1])) {
                    return;
                }
                int i14 = (i12 - i13) + 1;
                int i15 = (i10 - i11) + 1;
                if (i14 < i15) {
                    int i16 = i14 + i15;
                    i15 = i16 - i15;
                    i14 = i16 - i15;
                }
                d j11 = d.j(i14, this.f2843h);
                d j12 = d.j(i15, this.f2843h);
                this.f2841f[0].put("ImageWidth", j11);
                this.f2841f[0].put("ImageLength", j12);
                return;
            }
            return;
        }
        j10 = 8;
        gVar2.m(j10);
        Q(gVar2, 6);
        dVar = (d) this.f2841f[7].get("PreviewImageStart");
        dVar2 = (d) this.f2841f[7].get("PreviewImageLength");
        if (dVar != null) {
            this.f2841f[5].put("JPEGInterchangeFormat", dVar);
            this.f2841f[5].put("JPEGInterchangeFormatLength", dVar2);
        }
        dVar3 = (d) this.f2841f[8].get("AspectFrame");
        if (dVar3 == null) {
        }
    }

    private void m(b bVar) {
        if (f2830v) {
            Log.d("ExifInterface", "getPngAttributes starting with: " + bVar);
        }
        bVar.g(ByteOrder.BIG_ENDIAN);
        byte[] bArr = H;
        bVar.k(bArr.length);
        int length = bArr.length + 0;
        while (true) {
            try {
                int readInt = bVar.readInt();
                byte[] bArr2 = new byte[4];
                bVar.readFully(bArr2);
                int i10 = length + 4 + 4;
                if (i10 == 16 && !Arrays.equals(bArr2, J)) {
                    throw new IOException("Encountered invalid PNG file--IHDR chunk should appearas the first chunk");
                }
                if (Arrays.equals(bArr2, K)) {
                    return;
                }
                if (Arrays.equals(bArr2, I)) {
                    byte[] bArr3 = new byte[readInt];
                    bVar.readFully(bArr3);
                    int readInt2 = bVar.readInt();
                    CRC32 crc32 = new CRC32();
                    crc32.update(bArr2);
                    crc32.update(bArr3);
                    if (((int) crc32.getValue()) == readInt2) {
                        this.f2851p = i10;
                        P(bArr3, 0);
                        d0();
                        Z(new b(bArr3));
                        return;
                    }
                    throw new IOException("Encountered invalid CRC value for PNG-EXIF chunk.\n recorded CRC value: " + readInt2 + ", calculated CRC value: " + crc32.getValue());
                }
                int i11 = readInt + 4;
                bVar.k(i11);
                length = i10 + i11;
            } catch (EOFException unused) {
                throw new IOException("Encountered corrupt PNG file.");
            }
        }
    }

    private void n(b bVar) {
        boolean z9 = f2830v;
        if (z9) {
            Log.d("ExifInterface", "getRafAttributes starting with: " + bVar);
        }
        bVar.k(84);
        byte[] bArr = new byte[4];
        byte[] bArr2 = new byte[4];
        byte[] bArr3 = new byte[4];
        bVar.readFully(bArr);
        bVar.readFully(bArr2);
        bVar.readFully(bArr3);
        int i10 = ByteBuffer.wrap(bArr).getInt();
        int i11 = ByteBuffer.wrap(bArr2).getInt();
        int i12 = ByteBuffer.wrap(bArr3).getInt();
        byte[] bArr4 = new byte[i11];
        bVar.k(i10 - bVar.b());
        bVar.readFully(bArr4);
        i(new b(bArr4), i10, 5);
        bVar.k(i12 - bVar.b());
        bVar.g(ByteOrder.BIG_ENDIAN);
        int readInt = bVar.readInt();
        if (z9) {
            Log.d("ExifInterface", "numberOfDirectoryEntry: " + readInt);
        }
        for (int i13 = 0; i13 < readInt; i13++) {
            int readUnsignedShort = bVar.readUnsignedShort();
            int readUnsignedShort2 = bVar.readUnsignedShort();
            if (readUnsignedShort == f2813e0.f2871a) {
                short readShort = bVar.readShort();
                short readShort2 = bVar.readShort();
                d j10 = d.j(readShort, this.f2843h);
                d j11 = d.j(readShort2, this.f2843h);
                this.f2841f[0].put("ImageLength", j10);
                this.f2841f[0].put("ImageWidth", j11);
                if (f2830v) {
                    Log.d("ExifInterface", "Updated to length: " + ((int) readShort) + ", width: " + ((int) readShort2));
                    return;
                }
                return;
            }
            bVar.k(readUnsignedShort2);
        }
    }

    private void o(g gVar) {
        d dVar;
        M(gVar);
        Q(gVar, 0);
        c0(gVar, 0);
        c0(gVar, 5);
        c0(gVar, 4);
        d0();
        if (this.f2839d != 8 || (dVar = (d) this.f2841f[1].get("MakerNote")) == null) {
            return;
        }
        g gVar2 = new g(dVar.f2870d);
        gVar2.g(this.f2843h);
        gVar2.k(6);
        Q(gVar2, 9);
        d dVar2 = (d) this.f2841f[9].get("ColorSpace");
        if (dVar2 != null) {
            this.f2841f[1].put("ColorSpace", dVar2);
        }
    }

    private void q(g gVar) {
        if (f2830v) {
            Log.d("ExifInterface", "getRw2Attributes starting with: " + gVar);
        }
        o(gVar);
        d dVar = (d) this.f2841f[0].get("JpgFromRaw");
        if (dVar != null) {
            i(new b(dVar.f2870d), (int) dVar.f2869c, 5);
        }
        d dVar2 = (d) this.f2841f[0].get("ISO");
        d dVar3 = (d) this.f2841f[1].get("PhotographicSensitivity");
        if (dVar2 == null || dVar3 != null) {
            return;
        }
        this.f2841f[1].put("PhotographicSensitivity", dVar2);
    }

    private void r(g gVar) {
        byte[] bArr = f2825q0;
        gVar.k(bArr.length);
        byte[] bArr2 = new byte[gVar.available()];
        gVar.readFully(bArr2);
        this.f2851p = bArr.length;
        P(bArr2, 0);
    }

    private void u(b bVar) {
        if (f2830v) {
            Log.d("ExifInterface", "getWebpAttributes starting with: " + bVar);
        }
        bVar.g(ByteOrder.LITTLE_ENDIAN);
        bVar.k(L.length);
        int readInt = bVar.readInt() + 8;
        byte[] bArr = M;
        bVar.k(bArr.length);
        int length = bArr.length + 8;
        while (true) {
            try {
                byte[] bArr2 = new byte[4];
                bVar.readFully(bArr2);
                int readInt2 = bVar.readInt();
                int i10 = length + 4 + 4;
                if (Arrays.equals(N, bArr2)) {
                    byte[] bArr3 = new byte[readInt2];
                    bVar.readFully(bArr3);
                    this.f2851p = i10;
                    P(bArr3, 0);
                    Z(new b(bArr3));
                    return;
                }
                if (readInt2 % 2 == 1) {
                    readInt2++;
                }
                length = i10 + readInt2;
                if (length == readInt) {
                    return;
                }
                if (length > readInt) {
                    throw new IOException("Encountered WebP file with invalid chunk size");
                }
                bVar.k(readInt2);
            } catch (EOFException unused) {
                throw new IOException("Encountered corrupt WebP file.");
            }
        }
    }

    private static Pair v(String str) {
        if (str.contains(",")) {
            String[] split = str.split(",", -1);
            Pair v9 = v(split[0]);
            if (((Integer) v9.first).intValue() == 2) {
                return v9;
            }
            for (int i10 = 1; i10 < split.length; i10++) {
                Pair v10 = v(split[i10]);
                int intValue = (((Integer) v10.first).equals(v9.first) || ((Integer) v10.second).equals(v9.first)) ? ((Integer) v9.first).intValue() : -1;
                int intValue2 = (((Integer) v9.second).intValue() == -1 || !(((Integer) v10.first).equals(v9.second) || ((Integer) v10.second).equals(v9.second))) ? -1 : ((Integer) v9.second).intValue();
                if (intValue == -1 && intValue2 == -1) {
                    return new Pair(2, -1);
                }
                if (intValue == -1) {
                    v9 = new Pair(Integer.valueOf(intValue2), -1);
                } else if (intValue2 == -1) {
                    v9 = new Pair(Integer.valueOf(intValue), -1);
                }
            }
            return v9;
        } else if (!str.contains("/")) {
            try {
                try {
                    Long valueOf = Long.valueOf(Long.parseLong(str));
                    return (valueOf.longValue() < 0 || valueOf.longValue() > 65535) ? valueOf.longValue() < 0 ? new Pair(9, -1) : new Pair(4, -1) : new Pair(3, 4);
                } catch (NumberFormatException unused) {
                    return new Pair(2, -1);
                }
            } catch (NumberFormatException unused2) {
                Double.parseDouble(str);
                return new Pair(12, -1);
            }
        } else {
            String[] split2 = str.split("/", -1);
            if (split2.length == 2) {
                try {
                    long parseDouble = (long) Double.parseDouble(split2[0]);
                    long parseDouble2 = (long) Double.parseDouble(split2[1]);
                    if (parseDouble >= 0 && parseDouble2 >= 0) {
                        if (parseDouble <= 2147483647L && parseDouble2 <= 2147483647L) {
                            return new Pair(10, 5);
                        }
                        return new Pair(5, -1);
                    }
                    return new Pair(10, -1);
                } catch (NumberFormatException unused3) {
                }
            }
            return new Pair(2, -1);
        }
    }

    private void w(b bVar, HashMap hashMap) {
        d dVar = (d) hashMap.get("JPEGInterchangeFormat");
        d dVar2 = (d) hashMap.get("JPEGInterchangeFormatLength");
        if (dVar == null || dVar2 == null) {
            return;
        }
        int m10 = dVar.m(this.f2843h);
        int m11 = dVar2.m(this.f2843h);
        if (this.f2839d == 7) {
            m10 += this.f2852q;
        }
        if (m10 > 0 && m11 > 0) {
            this.f2844i = true;
            if (this.f2836a == null && this.f2838c == null && this.f2837b == null) {
                byte[] bArr = new byte[m11];
                bVar.k(m10);
                bVar.readFully(bArr);
                this.f2849n = bArr;
            }
            this.f2847l = m10;
            this.f2848m = m11;
        }
        if (f2830v) {
            Log.d("ExifInterface", "Setting thumbnail attributes with offset: " + m10 + ", length: " + m11);
        }
    }

    private void x(b bVar, HashMap hashMap) {
        int i10;
        d dVar = (d) hashMap.get("StripOffsets");
        d dVar2 = (d) hashMap.get("StripByteCounts");
        if (dVar == null || dVar2 == null) {
            return;
        }
        long[] c10 = androidx.exifinterface.media.b.c(dVar.o(this.f2843h));
        long[] c11 = androidx.exifinterface.media.b.c(dVar2.o(this.f2843h));
        if (c10 == null || c10.length == 0) {
            Log.w("ExifInterface", "stripOffsets should not be null or have zero length.");
        } else if (c11 == null || c11.length == 0) {
            Log.w("ExifInterface", "stripByteCounts should not be null or have zero length.");
        } else if (c10.length != c11.length) {
            Log.w("ExifInterface", "stripOffsets and stripByteCounts should have same length.");
        } else {
            long j10 = 0;
            for (long j11 : c11) {
                j10 += j11;
            }
            int i11 = (int) j10;
            byte[] bArr = new byte[i11];
            this.f2846k = true;
            this.f2845j = true;
            this.f2844i = true;
            int i12 = 0;
            int i13 = 0;
            for (int i14 = 0; i14 < c10.length; i14++) {
                int i15 = (int) c10[i14];
                int i16 = (int) c11[i14];
                if (i14 < c10.length - 1) {
                    i10 = i15;
                    if (i15 + i16 != c10[i14 + 1]) {
                        this.f2846k = false;
                    }
                } else {
                    i10 = i15;
                }
                int i17 = i10 - i12;
                if (i17 < 0) {
                    Log.d("ExifInterface", "Invalid strip offset value");
                    return;
                }
                try {
                    bVar.k(i17);
                    int i18 = i12 + i17;
                    byte[] bArr2 = new byte[i16];
                    try {
                        bVar.readFully(bArr2);
                        i12 = i18 + i16;
                        System.arraycopy(bArr2, 0, bArr, i13, i16);
                        i13 += i16;
                    } catch (EOFException unused) {
                        Log.d("ExifInterface", "Failed to read " + i16 + " bytes.");
                        return;
                    }
                } catch (EOFException unused2) {
                    Log.d("ExifInterface", "Failed to skip " + i17 + " bytes.");
                    return;
                }
            }
            this.f2849n = bArr;
            if (this.f2846k) {
                this.f2847l = (int) c10[0];
                this.f2848m = i11;
            }
        }
    }

    private void y(String str) {
        if (str == null) {
            throw new NullPointerException("filename cannot be null");
        }
        FileInputStream fileInputStream = null;
        this.f2838c = null;
        this.f2836a = str;
        try {
            FileInputStream fileInputStream2 = new FileInputStream(str);
            try {
                if (G(fileInputStream2.getFD())) {
                    this.f2837b = fileInputStream2.getFD();
                } else {
                    this.f2837b = null;
                }
                L(fileInputStream2);
                androidx.exifinterface.media.b.b(fileInputStream2);
            } catch (Throwable th) {
                th = th;
                fileInputStream = fileInputStream2;
                androidx.exifinterface.media.b.b(fileInputStream);
                throw th;
            }
        } catch (Throwable th2) {
            th = th2;
        }
    }

    private static boolean z(BufferedInputStream bufferedInputStream) {
        byte[] bArr = f2825q0;
        bufferedInputStream.mark(bArr.length);
        byte[] bArr2 = new byte[bArr.length];
        bufferedInputStream.read(bArr2);
        bufferedInputStream.reset();
        int i10 = 0;
        while (true) {
            byte[] bArr3 = f2825q0;
            if (i10 >= bArr3.length) {
                return true;
            }
            if (bArr2[i10] != bArr3[i10]) {
                return false;
            }
            i10++;
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:64:0x00e4 A[Catch: all -> 0x010c, Exception -> 0x010f, TryCatch #20 {Exception -> 0x010f, all -> 0x010c, blocks: (B:62:0x00e0, B:64:0x00e4, B:66:0x00fa, B:65:0x00f3), top: B:121:0x00e0 }] */
    /* JADX WARN: Removed duplicated region for block: B:65:0x00f3 A[Catch: all -> 0x010c, Exception -> 0x010f, TryCatch #20 {Exception -> 0x010f, all -> 0x010c, blocks: (B:62:0x00e0, B:64:0x00e4, B:66:0x00fa, B:65:0x00f3), top: B:121:0x00e0 }] */
    /* JADX WARN: Removed duplicated region for block: B:87:0x0146  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public void U() {
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        Closeable closeable;
        FileOutputStream fileOutputStream2;
        Exception exc;
        FileOutputStream fileOutputStream3;
        FileInputStream fileInputStream2;
        Exception e10;
        FileOutputStream fileOutputStream4;
        FileInputStream fileInputStream3;
        BufferedInputStream bufferedInputStream;
        if (!I(this.f2839d)) {
            throw new IOException("ExifInterface only supports saving attributes for JPEG, PNG, and WebP formats.");
        }
        if (this.f2837b == null && this.f2836a == null) {
            throw new IOException("ExifInterface does not support saving attributes for the current input.");
        }
        if (this.f2844i && this.f2845j && !this.f2846k) {
            throw new IOException("ExifInterface does not support saving attributes when the image file has non-consecutive thumbnail strips");
        }
        this.f2855t = true;
        this.f2849n = s();
        BufferedInputStream bufferedInputStream2 = null;
        try {
            File createTempFile = File.createTempFile("temp", "tmp");
            if (this.f2836a != null) {
                fileInputStream = new FileInputStream(this.f2836a);
            } else {
                b.a.c(this.f2837b, 0L, OsConstants.SEEK_SET);
                fileInputStream = new FileInputStream(this.f2837b);
            }
            try {
                fileOutputStream = new FileOutputStream(createTempFile);
                try {
                    androidx.exifinterface.media.b.d(fileInputStream, fileOutputStream);
                    androidx.exifinterface.media.b.b(fileInputStream);
                    androidx.exifinterface.media.b.b(fileOutputStream);
                    try {
                        try {
                            try {
                                fileInputStream3 = new FileInputStream(createTempFile);
                                try {
                                    if (this.f2836a != null) {
                                        fileOutputStream3 = new FileOutputStream(this.f2836a);
                                    } else {
                                        b.a.c(this.f2837b, 0L, OsConstants.SEEK_SET);
                                        fileOutputStream3 = new FileOutputStream(this.f2837b);
                                    }
                                    try {
                                        bufferedInputStream = new BufferedInputStream(fileInputStream3);
                                    } catch (Exception e11) {
                                        bufferedInputStream2 = fileInputStream3;
                                        exc = e11;
                                    }
                                } catch (Exception e12) {
                                    e = e12;
                                    fileOutputStream2 = null;
                                    bufferedInputStream2 = fileInputStream3;
                                    exc = e;
                                    fileOutputStream3 = fileOutputStream2;
                                    try {
                                        fileInputStream2 = new FileInputStream(createTempFile);
                                        try {
                                            if (this.f2836a != null) {
                                                b.a.c(this.f2837b, 0L, OsConstants.SEEK_SET);
                                                fileOutputStream4 = new FileOutputStream(this.f2837b);
                                            } else {
                                                fileOutputStream4 = new FileOutputStream(this.f2836a);
                                            }
                                            fileOutputStream3 = fileOutputStream4;
                                            androidx.exifinterface.media.b.d(fileInputStream2, fileOutputStream3);
                                            androidx.exifinterface.media.b.b(fileInputStream2);
                                            androidx.exifinterface.media.b.b(fileOutputStream3);
                                            throw new IOException("Failed to save new file", exc);
                                        } catch (Exception e13) {
                                            e10 = e13;
                                            try {
                                                throw new IOException("Failed to save new file. Original file is stored in " + createTempFile.getAbsolutePath(), e10);
                                            } catch (Throwable th) {
                                                th = th;
                                                bufferedInputStream2 = fileInputStream2;
                                                androidx.exifinterface.media.b.b(bufferedInputStream2);
                                                androidx.exifinterface.media.b.b(fileOutputStream3);
                                                throw th;
                                            }
                                        } catch (Throwable th2) {
                                            th = th2;
                                            bufferedInputStream2 = fileInputStream2;
                                            androidx.exifinterface.media.b.b(bufferedInputStream2);
                                            androidx.exifinterface.media.b.b(fileOutputStream3);
                                            throw th;
                                        }
                                    } catch (Exception e14) {
                                        fileInputStream2 = bufferedInputStream2;
                                        e10 = e14;
                                    } catch (Throwable th3) {
                                        th = th3;
                                    }
                                }
                            } catch (Exception e15) {
                                e = e15;
                                fileOutputStream2 = null;
                            }
                        } catch (Throwable th4) {
                            th = th4;
                            closeable = null;
                            androidx.exifinterface.media.b.b(bufferedInputStream2);
                            androidx.exifinterface.media.b.b(closeable);
                            if (0 == 0) {
                                createTempFile.delete();
                            }
                            throw th;
                        }
                    } catch (Throwable th5) {
                        th = th5;
                    }
                    try {
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream3);
                        try {
                            int i10 = this.f2839d;
                            if (i10 == 4) {
                                V(bufferedInputStream, bufferedOutputStream);
                            } else if (i10 == 13) {
                                W(bufferedInputStream, bufferedOutputStream);
                            } else if (i10 == 14) {
                                X(bufferedInputStream, bufferedOutputStream);
                            }
                            androidx.exifinterface.media.b.b(bufferedInputStream);
                            androidx.exifinterface.media.b.b(bufferedOutputStream);
                            createTempFile.delete();
                            this.f2849n = null;
                        } catch (Exception e16) {
                            exc = e16;
                            bufferedInputStream2 = fileInputStream3;
                            fileInputStream2 = new FileInputStream(createTempFile);
                            if (this.f2836a != null) {
                            }
                            fileOutputStream3 = fileOutputStream4;
                            androidx.exifinterface.media.b.d(fileInputStream2, fileOutputStream3);
                            androidx.exifinterface.media.b.b(fileInputStream2);
                            androidx.exifinterface.media.b.b(fileOutputStream3);
                            throw new IOException("Failed to save new file", exc);
                        }
                    } catch (Exception e17) {
                        bufferedInputStream2 = fileInputStream3;
                        exc = e17;
                    } catch (Throwable th6) {
                        th = th6;
                        closeable = null;
                        bufferedInputStream2 = bufferedInputStream;
                        androidx.exifinterface.media.b.b(bufferedInputStream2);
                        androidx.exifinterface.media.b.b(closeable);
                        if (0 == 0) {
                        }
                        throw th;
                    }
                } catch (Exception e18) {
                    e = e18;
                    bufferedInputStream2 = fileInputStream;
                    try {
                        throw new IOException("Failed to copy original file to temp file", e);
                    } catch (Throwable th7) {
                        th = th7;
                        androidx.exifinterface.media.b.b(bufferedInputStream2);
                        androidx.exifinterface.media.b.b(fileOutputStream);
                        throw th;
                    }
                } catch (Throwable th8) {
                    th = th8;
                    bufferedInputStream2 = fileInputStream;
                    androidx.exifinterface.media.b.b(bufferedInputStream2);
                    androidx.exifinterface.media.b.b(fileOutputStream);
                    throw th;
                }
            } catch (Exception e19) {
                e = e19;
                fileOutputStream = null;
            } catch (Throwable th9) {
                th = th9;
                fileOutputStream = null;
            }
        } catch (Exception e20) {
            e = e20;
            fileOutputStream = null;
        } catch (Throwable th10) {
            th = th10;
            fileOutputStream = null;
        }
    }

    public void Y(String str, String str2) {
        StringBuilder sb;
        e eVar;
        int i10;
        HashMap hashMap;
        d a10;
        HashMap hashMap2;
        d c10;
        Matcher matcher;
        String str3 = str;
        String str4 = str2;
        if (str3 == null) {
            throw new NullPointerException("tag shouldn't be null");
        }
        if (("DateTime".equals(str3) || "DateTimeOriginal".equals(str3) || "DateTimeDigitized".equals(str3)) && str4 != null) {
            boolean find = f2829u0.matcher(str4).find();
            boolean find2 = f2831v0.matcher(str4).find();
            if (str2.length() != 19 || (!find && !find2)) {
                sb = new StringBuilder();
                sb.append("Invalid value for ");
                sb.append(str3);
                sb.append(" : ");
                sb.append(str4);
                Log.w("ExifInterface", sb.toString());
                return;
            } else if (find2) {
                str4 = str4.replaceAll("-", ":");
            }
        }
        if ("ISOSpeedRatings".equals(str3)) {
            if (f2830v) {
                Log.d("ExifInterface", "setAttribute: Replacing TAG_ISO_SPEED_RATINGS with TAG_PHOTOGRAPHIC_SENSITIVITY.");
            }
            str3 = "PhotographicSensitivity";
        }
        int i11 = 2;
        int i12 = 1;
        if (str4 != null && f2822n0.contains(str3)) {
            if (str3.equals("GPSTimeStamp")) {
                if (!f2828t0.matcher(str4).find()) {
                    sb = new StringBuilder();
                    sb.append("Invalid value for ");
                    sb.append(str3);
                    sb.append(" : ");
                    sb.append(str4);
                    Log.w("ExifInterface", sb.toString());
                    return;
                }
                str4 = Integer.parseInt(matcher.group(1)) + "/1," + Integer.parseInt(matcher.group(2)) + "/1," + Integer.parseInt(matcher.group(3)) + "/1";
            } else {
                try {
                    str4 = new f(Double.parseDouble(str4)).toString();
                } catch (NumberFormatException unused) {
                    sb = new StringBuilder();
                }
            }
        }
        char c11 = 0;
        int i13 = 0;
        while (i13 < f2818j0.length) {
            if ((i13 != 4 || this.f2844i) && (eVar = (e) f2821m0[i13].get(str3)) != null) {
                if (str4 == null) {
                    this.f2841f[i13].remove(str3);
                } else {
                    Pair v9 = v(str4);
                    int i14 = -1;
                    if (eVar.f2873c == ((Integer) v9.first).intValue() || eVar.f2873c == ((Integer) v9.second).intValue()) {
                        i10 = eVar.f2873c;
                    } else {
                        int i15 = eVar.f2874d;
                        if (i15 == -1 || !(i15 == ((Integer) v9.first).intValue() || eVar.f2874d == ((Integer) v9.second).intValue())) {
                            int i16 = eVar.f2873c;
                            if (i16 == i12 || i16 == 7 || i16 == i11) {
                                i10 = i16;
                            } else if (f2830v) {
                                StringBuilder sb2 = new StringBuilder();
                                sb2.append("Given tag (");
                                sb2.append(str3);
                                sb2.append(") value didn't match with one of expected formats: ");
                                String[] strArr = W;
                                sb2.append(strArr[eVar.f2873c]);
                                sb2.append(eVar.f2874d == -1 ? "" : ", " + strArr[eVar.f2874d]);
                                sb2.append(" (guess: ");
                                sb2.append(strArr[((Integer) v9.first).intValue()]);
                                sb2.append(((Integer) v9.second).intValue() != -1 ? ", " + strArr[((Integer) v9.second).intValue()] : "");
                                sb2.append(")");
                                Log.d("ExifInterface", sb2.toString());
                            }
                        } else {
                            i10 = eVar.f2874d;
                        }
                    }
                    switch (i10) {
                        case 1:
                            hashMap = this.f2841f[i13];
                            a10 = d.a(str4);
                            hashMap.put(str3, a10);
                            break;
                        case 2:
                        case 7:
                            hashMap = this.f2841f[i13];
                            a10 = d.e(str4);
                            hashMap.put(str3, a10);
                            break;
                        case 3:
                            String[] split = str4.split(",", -1);
                            int[] iArr = new int[split.length];
                            for (int i17 = 0; i17 < split.length; i17++) {
                                iArr[i17] = Integer.parseInt(split[i17]);
                            }
                            hashMap = this.f2841f[i13];
                            a10 = d.k(iArr, this.f2843h);
                            hashMap.put(str3, a10);
                            break;
                        case 4:
                            String[] split2 = str4.split(",", -1);
                            long[] jArr = new long[split2.length];
                            for (int i18 = 0; i18 < split2.length; i18++) {
                                jArr[i18] = Long.parseLong(split2[i18]);
                            }
                            hashMap = this.f2841f[i13];
                            a10 = d.g(jArr, this.f2843h);
                            hashMap.put(str3, a10);
                            break;
                        case 5:
                            String[] split3 = str4.split(",", -1);
                            f[] fVarArr = new f[split3.length];
                            int i19 = 0;
                            while (i19 < split3.length) {
                                String[] split4 = split3[i19].split("/", i14);
                                fVarArr[i19] = new f((long) Double.parseDouble(split4[0]), (long) Double.parseDouble(split4[1]));
                                i19++;
                                i14 = -1;
                            }
                            hashMap = this.f2841f[i13];
                            a10 = d.i(fVarArr, this.f2843h);
                            hashMap.put(str3, a10);
                            break;
                        case 6:
                        case 8:
                        case 11:
                        default:
                            if (f2830v) {
                                Log.d("ExifInterface", "Data format isn't one of expected formats: " + i10);
                                break;
                            } else {
                                break;
                            }
                        case 9:
                            String[] split5 = str4.split(",", -1);
                            int[] iArr2 = new int[split5.length];
                            for (int i20 = 0; i20 < split5.length; i20++) {
                                iArr2[i20] = Integer.parseInt(split5[i20]);
                            }
                            hashMap2 = this.f2841f[i13];
                            c10 = d.c(iArr2, this.f2843h);
                            hashMap2.put(str3, c10);
                            break;
                        case 10:
                            String[] split6 = str4.split(",", -1);
                            f[] fVarArr2 = new f[split6.length];
                            int i21 = 0;
                            while (i21 < split6.length) {
                                String[] split7 = split6[i21].split("/", -1);
                                fVarArr2[i21] = new f((long) Double.parseDouble(split7[c11]), (long) Double.parseDouble(split7[i12]));
                                i21++;
                                split6 = split6;
                                c11 = 0;
                                i12 = 1;
                            }
                            hashMap2 = this.f2841f[i13];
                            c10 = d.d(fVarArr2, this.f2843h);
                            hashMap2.put(str3, c10);
                            break;
                        case 12:
                            String[] split8 = str4.split(",", -1);
                            double[] dArr = new double[split8.length];
                            for (int i22 = 0; i22 < split8.length; i22++) {
                                dArr[i22] = Double.parseDouble(split8[i22]);
                            }
                            this.f2841f[i13].put(str3, d.b(dArr, this.f2843h));
                            break;
                    }
                    i13++;
                    i11 = 2;
                    c11 = 0;
                    i12 = 1;
                }
            }
            i13++;
            i11 = 2;
            c11 = 0;
            i12 = 1;
        }
    }

    public String e(String str) {
        String str2;
        if (str != null) {
            d g10 = g(str);
            if (g10 != null) {
                if (!f2822n0.contains(str)) {
                    return g10.n(this.f2843h);
                }
                if (str.equals("GPSTimeStamp")) {
                    int i10 = g10.f2867a;
                    if (i10 == 5 || i10 == 10) {
                        f[] fVarArr = (f[]) g10.o(this.f2843h);
                        if (fVarArr != null && fVarArr.length == 3) {
                            f fVar = fVarArr[0];
                            f fVar2 = fVarArr[1];
                            f fVar3 = fVarArr[2];
                            return String.format("%02d:%02d:%02d", Integer.valueOf((int) (((float) fVar.f2875a) / ((float) fVar.f2876b))), Integer.valueOf((int) (((float) fVar2.f2875a) / ((float) fVar2.f2876b))), Integer.valueOf((int) (((float) fVar3.f2875a) / ((float) fVar3.f2876b))));
                        }
                        str2 = "Invalid GPS Timestamp array. array=" + Arrays.toString(fVarArr);
                    } else {
                        str2 = "GPS Timestamp format is not rational. format=" + g10.f2867a;
                    }
                    Log.w("ExifInterface", str2);
                    return null;
                }
                try {
                    return Double.toString(g10.l(this.f2843h));
                } catch (NumberFormatException unused) {
                }
            }
            return null;
        }
        throw new NullPointerException("tag shouldn't be null");
    }

    public int f(String str, int i10) {
        if (str != null) {
            d g10 = g(str);
            if (g10 == null) {
                return i10;
            }
            try {
                return g10.m(this.f2843h);
            } catch (NumberFormatException unused) {
                return i10;
            }
        }
        throw new NullPointerException("tag shouldn't be null");
    }

    public double[] j() {
        String e10 = e("GPSLatitude");
        String e11 = e("GPSLatitudeRef");
        String e12 = e("GPSLongitude");
        String e13 = e("GPSLongitudeRef");
        if (e10 == null || e11 == null || e12 == null || e13 == null) {
            return null;
        }
        try {
            return new double[]{b(e10, e11), b(e12, e13)};
        } catch (IllegalArgumentException unused) {
            Log.w("ExifInterface", "Latitude/longitude values are not parsable. " + String.format("latValue=%s, latRef=%s, lngValue=%s, lngRef=%s", e10, e11, e12, e13));
            return null;
        }
    }

    public int p() {
        switch (f("Orientation", 1)) {
            case 3:
            case 4:
                return 180;
            case 5:
            case 8:
                return 270;
            case 6:
            case 7:
                return 90;
            default:
                return 0;
        }
    }

    public byte[] s() {
        int i10 = this.f2850o;
        if (i10 == 6 || i10 == 7) {
            return t();
        }
        return null;
    }

    /* JADX WARN: Removed duplicated region for block: B:31:0x0069  */
    /* JADX WARN: Removed duplicated region for block: B:46:0x0088  */
    /* JADX WARN: Removed duplicated region for block: B:52:0x0093  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public byte[] t() {
        FileDescriptor fileDescriptor;
        InputStream inputStream;
        Exception e10;
        InputStream inputStream2 = null;
        if (!this.f2844i) {
            return null;
        }
        byte[] bArr = this.f2849n;
        if (bArr != null) {
            return bArr;
        }
        try {
            inputStream = this.f2838c;
            try {
                try {
                    if (inputStream != null) {
                        try {
                            if (!inputStream.markSupported()) {
                                Log.d("ExifInterface", "Cannot read thumbnail from inputstream without mark/reset support");
                                androidx.exifinterface.media.b.b(inputStream);
                                return null;
                            }
                            inputStream.reset();
                        } catch (Exception e11) {
                            e10 = e11;
                            fileDescriptor = null;
                            Log.d("ExifInterface", "Encountered exception while getting thumbnail", e10);
                            androidx.exifinterface.media.b.b(inputStream);
                            if (fileDescriptor != null) {
                            }
                            return null;
                        } catch (Throwable th) {
                            th = th;
                            fileDescriptor = null;
                            inputStream2 = inputStream;
                            androidx.exifinterface.media.b.b(inputStream2);
                            if (fileDescriptor != null) {
                            }
                            throw th;
                        }
                    } else if (this.f2836a == null) {
                        FileDescriptor b10 = b.a.b(this.f2837b);
                        try {
                            b.a.c(b10, 0L, OsConstants.SEEK_SET);
                            fileDescriptor = b10;
                            inputStream = new FileInputStream(b10);
                            b bVar = new b(inputStream);
                            bVar.k(this.f2847l + this.f2851p);
                            byte[] bArr2 = new byte[this.f2848m];
                            bVar.readFully(bArr2);
                            this.f2849n = bArr2;
                            androidx.exifinterface.media.b.b(inputStream);
                            if (fileDescriptor != null) {
                                androidx.exifinterface.media.b.a(fileDescriptor);
                            }
                            return bArr2;
                        } catch (Exception e12) {
                            e10 = e12;
                            fileDescriptor = b10;
                            inputStream = null;
                            Log.d("ExifInterface", "Encountered exception while getting thumbnail", e10);
                            androidx.exifinterface.media.b.b(inputStream);
                            if (fileDescriptor != null) {
                            }
                            return null;
                        } catch (Throwable th2) {
                            th = th2;
                            fileDescriptor = b10;
                            androidx.exifinterface.media.b.b(inputStream2);
                            if (fileDescriptor != null) {
                            }
                            throw th;
                        }
                    } else {
                        inputStream = new FileInputStream(this.f2836a);
                    }
                    b bVar2 = new b(inputStream);
                    bVar2.k(this.f2847l + this.f2851p);
                    byte[] bArr22 = new byte[this.f2848m];
                    bVar2.readFully(bArr22);
                    this.f2849n = bArr22;
                    androidx.exifinterface.media.b.b(inputStream);
                    if (fileDescriptor != null) {
                    }
                    return bArr22;
                } catch (Exception e13) {
                    e10 = e13;
                    Log.d("ExifInterface", "Encountered exception while getting thumbnail", e10);
                    androidx.exifinterface.media.b.b(inputStream);
                    if (fileDescriptor != null) {
                        androidx.exifinterface.media.b.a(fileDescriptor);
                    }
                    return null;
                }
            } catch (Throwable th3) {
                th = th3;
                inputStream2 = inputStream;
                androidx.exifinterface.media.b.b(inputStream2);
                if (fileDescriptor != null) {
                    androidx.exifinterface.media.b.a(fileDescriptor);
                }
                throw th;
            }
            fileDescriptor = null;
        } catch (Exception e14) {
            inputStream = null;
            e10 = e14;
            fileDescriptor = null;
        } catch (Throwable th4) {
            th = th4;
            fileDescriptor = null;
        }
    }
}
