package androidx.emoji2.text;

import android.content.Context;
import android.content.pm.PackageManager;
import android.database.ContentObserver;
import android.graphics.Typeface;
import android.os.Handler;
import androidx.emoji2.text.e;
import androidx.emoji2.text.j;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import u.i;
/* loaded from: classes.dex */
public class j extends e.c {

    /* renamed from: j  reason: collision with root package name */
    private static final a f2781j = new a();

    /* loaded from: classes.dex */
    public static class a {
        public Typeface a(Context context, i.b bVar) {
            return u.i.a(context, null, new i.b[]{bVar});
        }

        public i.a b(Context context, u.g gVar) {
            return u.i.b(context, null, gVar);
        }

        public void c(Context context, ContentObserver contentObserver) {
            context.getContentResolver().unregisterContentObserver(contentObserver);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class b implements e.g {

        /* renamed from: a  reason: collision with root package name */
        private final Context f2782a;

        /* renamed from: b  reason: collision with root package name */
        private final u.g f2783b;

        /* renamed from: c  reason: collision with root package name */
        private final a f2784c;

        /* renamed from: d  reason: collision with root package name */
        private final Object f2785d = new Object();

        /* renamed from: e  reason: collision with root package name */
        private Handler f2786e;

        /* renamed from: f  reason: collision with root package name */
        private Executor f2787f;

        /* renamed from: g  reason: collision with root package name */
        private ThreadPoolExecutor f2788g;

        /* renamed from: h  reason: collision with root package name */
        e.h f2789h;

        /* renamed from: i  reason: collision with root package name */
        private ContentObserver f2790i;

        /* renamed from: j  reason: collision with root package name */
        private Runnable f2791j;

        b(Context context, u.g gVar, a aVar) {
            v.h.h(context, "Context cannot be null");
            v.h.h(gVar, "FontRequest cannot be null");
            this.f2782a = context.getApplicationContext();
            this.f2783b = gVar;
            this.f2784c = aVar;
        }

        private void b() {
            synchronized (this.f2785d) {
                this.f2789h = null;
                ContentObserver contentObserver = this.f2790i;
                if (contentObserver != null) {
                    this.f2784c.c(this.f2782a, contentObserver);
                    this.f2790i = null;
                }
                Handler handler = this.f2786e;
                if (handler != null) {
                    handler.removeCallbacks(this.f2791j);
                }
                this.f2786e = null;
                ThreadPoolExecutor threadPoolExecutor = this.f2788g;
                if (threadPoolExecutor != null) {
                    threadPoolExecutor.shutdown();
                }
                this.f2787f = null;
                this.f2788g = null;
            }
        }

        private i.b e() {
            try {
                i.a b10 = this.f2784c.b(this.f2782a, this.f2783b);
                if (b10.c() == 0) {
                    i.b[] b11 = b10.b();
                    if (b11 == null || b11.length == 0) {
                        throw new RuntimeException("fetchFonts failed (empty result)");
                    }
                    return b11[0];
                }
                throw new RuntimeException("fetchFonts failed (" + b10.c() + ")");
            } catch (PackageManager.NameNotFoundException e10) {
                throw new RuntimeException("provider not found", e10);
            }
        }

        @Override // androidx.emoji2.text.e.g
        public void a(e.h hVar) {
            v.h.h(hVar, "LoaderCallback cannot be null");
            synchronized (this.f2785d) {
                this.f2789h = hVar;
            }
            d();
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        public void c() {
            synchronized (this.f2785d) {
                if (this.f2789h == null) {
                    return;
                }
                try {
                    i.b e10 = e();
                    int b10 = e10.b();
                    if (b10 == 2) {
                        synchronized (this.f2785d) {
                        }
                    }
                    if (b10 != 0) {
                        throw new RuntimeException("fetchFonts result is not OK. (" + b10 + ")");
                    }
                    androidx.core.os.l.a("EmojiCompat.FontRequestEmojiCompatConfig.buildTypeface");
                    Typeface a10 = this.f2784c.a(this.f2782a, e10);
                    ByteBuffer f10 = androidx.core.graphics.m.f(this.f2782a, null, e10.d());
                    if (f10 == null || a10 == null) {
                        throw new RuntimeException("Unable to open file.");
                    }
                    m b11 = m.b(a10, f10);
                    androidx.core.os.l.b();
                    synchronized (this.f2785d) {
                        e.h hVar = this.f2789h;
                        if (hVar != null) {
                            hVar.b(b11);
                        }
                    }
                    b();
                } catch (Throwable th) {
                    synchronized (this.f2785d) {
                        e.h hVar2 = this.f2789h;
                        if (hVar2 != null) {
                            hVar2.a(th);
                        }
                        b();
                    }
                }
            }
        }

        void d() {
            synchronized (this.f2785d) {
                if (this.f2789h == null) {
                    return;
                }
                if (this.f2787f == null) {
                    ThreadPoolExecutor b10 = androidx.emoji2.text.b.b("emojiCompat");
                    this.f2788g = b10;
                    this.f2787f = b10;
                }
                this.f2787f.execute(new Runnable() { // from class: androidx.emoji2.text.k
                    @Override // java.lang.Runnable
                    public final void run() {
                        j.b.this.c();
                    }
                });
            }
        }

        public void f(Executor executor) {
            synchronized (this.f2785d) {
                this.f2787f = executor;
            }
        }
    }

    public j(Context context, u.g gVar) {
        super(new b(context, gVar, f2781j));
    }

    public j c(Executor executor) {
        ((b) a()).f(executor);
        return this;
    }
}
