package androidx.emoji2.text;

import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.method.MetaKeyKeyListener;
import android.view.KeyEvent;
import android.view.inputmethod.InputConnection;
import androidx.emoji2.text.e;
import androidx.emoji2.text.m;
import java.util.Arrays;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public final class h {

    /* renamed from: a  reason: collision with root package name */
    private final e.i f2763a;

    /* renamed from: b  reason: collision with root package name */
    private final m f2764b;

    /* renamed from: c  reason: collision with root package name */
    private e.d f2765c;

    /* renamed from: d  reason: collision with root package name */
    private final boolean f2766d;

    /* renamed from: e  reason: collision with root package name */
    private final int[] f2767e;

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static final class a {
        static int a(CharSequence charSequence, int i10, int i11) {
            int length = charSequence.length();
            if (i10 < 0 || length < i10 || i11 < 0) {
                return -1;
            }
            while (true) {
                boolean z9 = false;
                while (i11 != 0) {
                    i10--;
                    if (i10 < 0) {
                        return z9 ? -1 : 0;
                    }
                    char charAt = charSequence.charAt(i10);
                    if (z9) {
                        if (!Character.isHighSurrogate(charAt)) {
                            return -1;
                        }
                        i11--;
                    } else if (!Character.isSurrogate(charAt)) {
                        i11--;
                    } else if (Character.isHighSurrogate(charAt)) {
                        return -1;
                    } else {
                        z9 = true;
                    }
                }
                return i10;
            }
        }

        static int b(CharSequence charSequence, int i10, int i11) {
            int length = charSequence.length();
            if (i10 < 0 || length < i10 || i11 < 0) {
                return -1;
            }
            while (true) {
                boolean z9 = false;
                while (i11 != 0) {
                    if (i10 >= length) {
                        if (z9) {
                            return -1;
                        }
                        return length;
                    }
                    char charAt = charSequence.charAt(i10);
                    if (z9) {
                        if (!Character.isLowSurrogate(charAt)) {
                            return -1;
                        }
                        i11--;
                        i10++;
                    } else if (!Character.isSurrogate(charAt)) {
                        i11--;
                        i10++;
                    } else if (Character.isLowSurrogate(charAt)) {
                        return -1;
                    } else {
                        i10++;
                        z9 = true;
                    }
                }
                return i10;
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static final class b {

        /* renamed from: a  reason: collision with root package name */
        private int f2768a = 1;

        /* renamed from: b  reason: collision with root package name */
        private final m.a f2769b;

        /* renamed from: c  reason: collision with root package name */
        private m.a f2770c;

        /* renamed from: d  reason: collision with root package name */
        private m.a f2771d;

        /* renamed from: e  reason: collision with root package name */
        private int f2772e;

        /* renamed from: f  reason: collision with root package name */
        private int f2773f;

        /* renamed from: g  reason: collision with root package name */
        private final boolean f2774g;

        /* renamed from: h  reason: collision with root package name */
        private final int[] f2775h;

        b(m.a aVar, boolean z9, int[] iArr) {
            this.f2769b = aVar;
            this.f2770c = aVar;
            this.f2774g = z9;
            this.f2775h = iArr;
        }

        private static boolean d(int i10) {
            return i10 == 65039;
        }

        private static boolean f(int i10) {
            return i10 == 65038;
        }

        private int g() {
            this.f2768a = 1;
            this.f2770c = this.f2769b;
            this.f2773f = 0;
            return 1;
        }

        private boolean h() {
            if (this.f2770c.b().j() || d(this.f2772e)) {
                return true;
            }
            if (this.f2774g) {
                if (this.f2775h == null) {
                    return true;
                }
                if (Arrays.binarySearch(this.f2775h, this.f2770c.b().b(0)) < 0) {
                    return true;
                }
            }
            return false;
        }

        int a(int i10) {
            m.a a10 = this.f2770c.a(i10);
            int i11 = 3;
            if (this.f2768a != 2) {
                if (a10 != null) {
                    this.f2768a = 2;
                    this.f2770c = a10;
                    this.f2773f = 1;
                    i11 = 2;
                }
                i11 = g();
            } else {
                if (a10 != null) {
                    this.f2770c = a10;
                    this.f2773f++;
                } else {
                    if (!f(i10)) {
                        if (!d(i10)) {
                            if (this.f2770c.b() != null && (this.f2773f != 1 || h())) {
                                this.f2771d = this.f2770c;
                                g();
                            }
                        }
                    }
                    i11 = g();
                }
                i11 = 2;
            }
            this.f2772e = i10;
            return i11;
        }

        g b() {
            return this.f2770c.b();
        }

        g c() {
            return this.f2771d.b();
        }

        boolean e() {
            return this.f2768a == 2 && this.f2770c.b() != null && (this.f2773f > 1 || h());
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public h(m mVar, e.i iVar, e.d dVar, boolean z9, int[] iArr) {
        this.f2763a = iVar;
        this.f2764b = mVar;
        this.f2765c = dVar;
        this.f2766d = z9;
        this.f2767e = iArr;
    }

    private void a(Spannable spannable, g gVar, int i10, int i11) {
        spannable.setSpan(this.f2763a.a(gVar), i10, i11, 33);
    }

    private static boolean b(Editable editable, KeyEvent keyEvent, boolean z9) {
        i[] iVarArr;
        if (g(keyEvent)) {
            return false;
        }
        int selectionStart = Selection.getSelectionStart(editable);
        int selectionEnd = Selection.getSelectionEnd(editable);
        if (!f(selectionStart, selectionEnd) && (iVarArr = (i[]) editable.getSpans(selectionStart, selectionEnd, i.class)) != null && iVarArr.length > 0) {
            for (i iVar : iVarArr) {
                int spanStart = editable.getSpanStart(iVar);
                int spanEnd = editable.getSpanEnd(iVar);
                if ((z9 && spanStart == selectionStart) || ((!z9 && spanEnd == selectionStart) || (selectionStart > spanStart && selectionStart < spanEnd))) {
                    editable.delete(spanStart, spanEnd);
                    return true;
                }
            }
        }
        return false;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static boolean c(InputConnection inputConnection, Editable editable, int i10, int i11, boolean z9) {
        int max;
        int min;
        if (editable != null && inputConnection != null && i10 >= 0 && i11 >= 0) {
            int selectionStart = Selection.getSelectionStart(editable);
            int selectionEnd = Selection.getSelectionEnd(editable);
            if (f(selectionStart, selectionEnd)) {
                return false;
            }
            if (z9) {
                max = a.a(editable, selectionStart, Math.max(i10, 0));
                min = a.b(editable, selectionEnd, Math.max(i11, 0));
                if (max == -1 || min == -1) {
                    return false;
                }
            } else {
                max = Math.max(selectionStart - i10, 0);
                min = Math.min(selectionEnd + i11, editable.length());
            }
            i[] iVarArr = (i[]) editable.getSpans(max, min, i.class);
            if (iVarArr != null && iVarArr.length > 0) {
                for (i iVar : iVarArr) {
                    int spanStart = editable.getSpanStart(iVar);
                    int spanEnd = editable.getSpanEnd(iVar);
                    max = Math.min(spanStart, max);
                    min = Math.max(spanEnd, min);
                }
                int max2 = Math.max(max, 0);
                int min2 = Math.min(min, editable.length());
                inputConnection.beginBatchEdit();
                editable.delete(max2, min2);
                inputConnection.endBatchEdit();
                return true;
            }
        }
        return false;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static boolean d(Editable editable, int i10, KeyEvent keyEvent) {
        if (i10 != 67 ? i10 != 112 ? false : b(editable, keyEvent, true) : b(editable, keyEvent, false)) {
            MetaKeyKeyListener.adjustMetaAfterKeypress(editable);
            return true;
        }
        return false;
    }

    private boolean e(CharSequence charSequence, int i10, int i11, g gVar) {
        if (gVar.d() == 0) {
            gVar.k(this.f2765c.a(charSequence, i10, i11, gVar.h()));
        }
        return gVar.d() == 2;
    }

    private static boolean f(int i10, int i11) {
        return i10 == -1 || i11 == -1 || i10 != i11;
    }

    private static boolean g(KeyEvent keyEvent) {
        return !KeyEvent.metaStateHasNoModifiers(keyEvent.getMetaState());
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* JADX WARN: Code restructure failed: missing block: B:78:0x0125, code lost:
        ((androidx.emoji2.text.n) r10).d();
     */
    /* JADX WARN: Removed duplicated region for block: B:101:0x00a2 A[SYNTHETIC] */
    /* JADX WARN: Removed duplicated region for block: B:24:0x0047 A[Catch: all -> 0x012c, TryCatch #0 {all -> 0x012c, blocks: (B:7:0x000d, B:10:0x0012, B:12:0x0016, B:14:0x0025, B:18:0x0036, B:20:0x0040, B:22:0x0043, B:24:0x0047, B:26:0x0053, B:27:0x0056, B:29:0x0063, B:35:0x0072, B:36:0x0080, B:40:0x009b, B:48:0x00ab, B:51:0x00b7, B:52:0x00c1, B:53:0x00cb, B:55:0x00d2, B:56:0x00d7, B:58:0x00e2, B:60:0x00e9, B:64:0x00f3, B:67:0x00ff, B:68:0x0105, B:70:0x010e, B:15:0x002b), top: B:84:0x000d }] */
    /* JADX WARN: Removed duplicated region for block: B:67:0x00ff A[Catch: all -> 0x012c, TryCatch #0 {all -> 0x012c, blocks: (B:7:0x000d, B:10:0x0012, B:12:0x0016, B:14:0x0025, B:18:0x0036, B:20:0x0040, B:22:0x0043, B:24:0x0047, B:26:0x0053, B:27:0x0056, B:29:0x0063, B:35:0x0072, B:36:0x0080, B:40:0x009b, B:48:0x00ab, B:51:0x00b7, B:52:0x00c1, B:53:0x00cb, B:55:0x00d2, B:56:0x00d7, B:58:0x00e2, B:60:0x00e9, B:64:0x00f3, B:67:0x00ff, B:68:0x0105, B:70:0x010e, B:15:0x002b), top: B:84:0x000d }] */
    /* JADX WARN: Removed duplicated region for block: B:70:0x010e A[Catch: all -> 0x012c, TRY_LEAVE, TryCatch #0 {all -> 0x012c, blocks: (B:7:0x000d, B:10:0x0012, B:12:0x0016, B:14:0x0025, B:18:0x0036, B:20:0x0040, B:22:0x0043, B:24:0x0047, B:26:0x0053, B:27:0x0056, B:29:0x0063, B:35:0x0072, B:36:0x0080, B:40:0x009b, B:48:0x00ab, B:51:0x00b7, B:52:0x00c1, B:53:0x00cb, B:55:0x00d2, B:56:0x00d7, B:58:0x00e2, B:60:0x00e9, B:64:0x00f3, B:67:0x00ff, B:68:0x0105, B:70:0x010e, B:15:0x002b), top: B:84:0x000d }] */
    /* JADX WARN: Removed duplicated region for block: B:74:0x011a  */
    /* JADX WARN: Removed duplicated region for block: B:96:0x00d7 A[SYNTHETIC] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public CharSequence h(CharSequence charSequence, int i10, int i11, int i12, boolean z9) {
        b bVar;
        r rVar;
        int codePointAt;
        int i13;
        int a10;
        i[] iVarArr;
        boolean z10 = charSequence instanceof n;
        if (z10) {
            ((n) charSequence).a();
        }
        r rVar2 = null;
        if (!z10) {
            try {
                if (!(charSequence instanceof Spannable)) {
                    if ((charSequence instanceof Spanned) && ((Spanned) charSequence).nextSpanTransition(i10 - 1, i11 + 1, i.class) <= i11) {
                        rVar2 = new r(charSequence);
                    }
                    if (rVar2 != null && (iVarArr = (i[]) rVar2.getSpans(i10, i11, i.class)) != null && iVarArr.length > 0) {
                        for (i iVar : iVarArr) {
                            int spanStart = rVar2.getSpanStart(iVar);
                            int spanEnd = rVar2.getSpanEnd(iVar);
                            if (spanStart != i11) {
                                rVar2.removeSpan(iVar);
                            }
                            i10 = Math.min(spanStart, i10);
                            i11 = Math.max(spanEnd, i11);
                        }
                    }
                    if (i10 != i11 && i10 < charSequence.length()) {
                        if (i12 != Integer.MAX_VALUE && rVar2 != null) {
                            i12 -= ((i[]) rVar2.getSpans(0, rVar2.length(), i.class)).length;
                        }
                        bVar = new b(this.f2764b.f(), this.f2766d, this.f2767e);
                        rVar = rVar2;
                        codePointAt = Character.codePointAt(charSequence, i10);
                        int i14 = 0;
                        loop1: while (true) {
                            i13 = i10;
                            while (i10 < i11 && i14 < i12) {
                                a10 = bVar.a(codePointAt);
                                if (a10 != 1) {
                                    i13 += Character.charCount(Character.codePointAt(charSequence, i13));
                                    if (i13 < i11) {
                                        codePointAt = Character.codePointAt(charSequence, i13);
                                    }
                                    i10 = i13;
                                } else if (a10 == 2) {
                                    i10 += Character.charCount(codePointAt);
                                    if (i10 < i11) {
                                        codePointAt = Character.codePointAt(charSequence, i10);
                                    }
                                } else if (a10 == 3) {
                                    if (z9 || !e(charSequence, i13, i10, bVar.c())) {
                                        if (rVar == null) {
                                            rVar = new r((Spannable) new SpannableString(charSequence));
                                        }
                                        a(rVar, bVar.c(), i13, i10);
                                        i14++;
                                    }
                                }
                            }
                        }
                        if (bVar.e() && i14 < i12 && (z9 || !e(charSequence, i13, i10, bVar.b()))) {
                            if (rVar == null) {
                                rVar = new r(charSequence);
                            }
                            a(rVar, bVar.b(), i13, i10);
                        }
                        if (rVar == null) {
                            return rVar.b();
                        }
                        if (z10) {
                            ((n) charSequence).d();
                        }
                        return charSequence;
                    }
                    return charSequence;
                }
            } finally {
                if (z10) {
                    ((n) charSequence).d();
                }
            }
        }
        rVar2 = new r((Spannable) charSequence);
        if (rVar2 != null) {
            while (r5 < r4) {
            }
        }
        if (i10 != i11) {
            if (i12 != Integer.MAX_VALUE) {
                i12 -= ((i[]) rVar2.getSpans(0, rVar2.length(), i.class)).length;
            }
            bVar = new b(this.f2764b.f(), this.f2766d, this.f2767e);
            rVar = rVar2;
            codePointAt = Character.codePointAt(charSequence, i10);
            int i142 = 0;
            loop1: while (true) {
                i13 = i10;
                while (i10 < i11) {
                    a10 = bVar.a(codePointAt);
                    if (a10 != 1) {
                    }
                }
            }
            if (bVar.e()) {
                if (rVar == null) {
                }
                a(rVar, bVar.b(), i13, i10);
            }
            if (rVar == null) {
            }
        }
        return charSequence;
    }
}
