package androidx.emoji2.text;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.Editable;
import android.view.KeyEvent;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
/* loaded from: classes.dex */
public class e {

    /* renamed from: n  reason: collision with root package name */
    private static final Object f2724n = new Object();

    /* renamed from: o  reason: collision with root package name */
    private static final Object f2725o = new Object();

    /* renamed from: p  reason: collision with root package name */
    private static volatile e f2726p;

    /* renamed from: b  reason: collision with root package name */
    private final Set f2728b;

    /* renamed from: e  reason: collision with root package name */
    private final b f2731e;

    /* renamed from: f  reason: collision with root package name */
    final g f2732f;

    /* renamed from: g  reason: collision with root package name */
    final boolean f2733g;

    /* renamed from: h  reason: collision with root package name */
    final boolean f2734h;

    /* renamed from: i  reason: collision with root package name */
    final int[] f2735i;

    /* renamed from: j  reason: collision with root package name */
    private final boolean f2736j;

    /* renamed from: k  reason: collision with root package name */
    private final int f2737k;

    /* renamed from: l  reason: collision with root package name */
    private final int f2738l;

    /* renamed from: m  reason: collision with root package name */
    private final d f2739m;

    /* renamed from: a  reason: collision with root package name */
    private final ReadWriteLock f2727a = new ReentrantReadWriteLock();

    /* renamed from: c  reason: collision with root package name */
    private volatile int f2729c = 3;

    /* renamed from: d  reason: collision with root package name */
    private final Handler f2730d = new Handler(Looper.getMainLooper());

    /* loaded from: classes.dex */
    private static final class a extends b {

        /* renamed from: b  reason: collision with root package name */
        private volatile androidx.emoji2.text.h f2740b;

        /* renamed from: c  reason: collision with root package name */
        private volatile m f2741c;

        /* renamed from: androidx.emoji2.text.e$a$a  reason: collision with other inner class name */
        /* loaded from: classes.dex */
        class C0028a extends h {
            C0028a() {
            }

            @Override // androidx.emoji2.text.e.h
            public void a(Throwable th) {
                a.this.f2743a.m(th);
            }

            @Override // androidx.emoji2.text.e.h
            public void b(m mVar) {
                a.this.d(mVar);
            }
        }

        a(e eVar) {
            super(eVar);
        }

        @Override // androidx.emoji2.text.e.b
        void a() {
            try {
                this.f2743a.f2732f.a(new C0028a());
            } catch (Throwable th) {
                this.f2743a.m(th);
            }
        }

        @Override // androidx.emoji2.text.e.b
        CharSequence b(CharSequence charSequence, int i10, int i11, int i12, boolean z9) {
            return this.f2740b.h(charSequence, i10, i11, i12, z9);
        }

        @Override // androidx.emoji2.text.e.b
        void c(EditorInfo editorInfo) {
            editorInfo.extras.putInt("android.support.text.emoji.emojiCompat_metadataVersion", this.f2741c.e());
            editorInfo.extras.putBoolean("android.support.text.emoji.emojiCompat_replaceAll", this.f2743a.f2733g);
        }

        void d(m mVar) {
            if (mVar == null) {
                this.f2743a.m(new IllegalArgumentException("metadataRepo cannot be null"));
                return;
            }
            this.f2741c = mVar;
            m mVar2 = this.f2741c;
            i iVar = new i();
            d dVar = this.f2743a.f2739m;
            e eVar = this.f2743a;
            this.f2740b = new androidx.emoji2.text.h(mVar2, iVar, dVar, eVar.f2734h, eVar.f2735i);
            this.f2743a.n();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class b {

        /* renamed from: a  reason: collision with root package name */
        final e f2743a;

        b(e eVar) {
            this.f2743a = eVar;
        }

        abstract void a();

        abstract CharSequence b(CharSequence charSequence, int i10, int i11, int i12, boolean z9);

        abstract void c(EditorInfo editorInfo);
    }

    /* loaded from: classes.dex */
    public static abstract class c {

        /* renamed from: a  reason: collision with root package name */
        final g f2744a;

        /* renamed from: b  reason: collision with root package name */
        boolean f2745b;

        /* renamed from: c  reason: collision with root package name */
        boolean f2746c;

        /* renamed from: d  reason: collision with root package name */
        int[] f2747d;

        /* renamed from: e  reason: collision with root package name */
        Set f2748e;

        /* renamed from: f  reason: collision with root package name */
        boolean f2749f;

        /* renamed from: g  reason: collision with root package name */
        int f2750g = -16711936;

        /* renamed from: h  reason: collision with root package name */
        int f2751h = 0;

        /* renamed from: i  reason: collision with root package name */
        d f2752i = new androidx.emoji2.text.d();

        /* JADX INFO: Access modifiers changed from: protected */
        public c(g gVar) {
            v.h.h(gVar, "metadataLoader cannot be null.");
            this.f2744a = gVar;
        }

        /* JADX INFO: Access modifiers changed from: protected */
        public final g a() {
            return this.f2744a;
        }

        public c b(int i10) {
            this.f2751h = i10;
            return this;
        }
    }

    /* loaded from: classes.dex */
    public interface d {
        boolean a(CharSequence charSequence, int i10, int i11, int i12);
    }

    /* renamed from: androidx.emoji2.text.e$e  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public static abstract class AbstractC0029e {
        public void a(Throwable th) {
        }

        public void b() {
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class f implements Runnable {

        /* renamed from: g  reason: collision with root package name */
        private final List f2753g;

        /* renamed from: h  reason: collision with root package name */
        private final Throwable f2754h;

        /* renamed from: i  reason: collision with root package name */
        private final int f2755i;

        f(AbstractC0029e abstractC0029e, int i10) {
            this(Arrays.asList((AbstractC0029e) v.h.h(abstractC0029e, "initCallback cannot be null")), i10, null);
        }

        f(Collection collection, int i10) {
            this(collection, i10, null);
        }

        f(Collection collection, int i10, Throwable th) {
            v.h.h(collection, "initCallbacks cannot be null");
            this.f2753g = new ArrayList(collection);
            this.f2755i = i10;
            this.f2754h = th;
        }

        @Override // java.lang.Runnable
        public void run() {
            int size = this.f2753g.size();
            int i10 = 0;
            if (this.f2755i != 1) {
                while (i10 < size) {
                    ((AbstractC0029e) this.f2753g.get(i10)).a(this.f2754h);
                    i10++;
                }
                return;
            }
            while (i10 < size) {
                ((AbstractC0029e) this.f2753g.get(i10)).b();
                i10++;
            }
        }
    }

    /* loaded from: classes.dex */
    public interface g {
        void a(h hVar);
    }

    /* loaded from: classes.dex */
    public static abstract class h {
        public abstract void a(Throwable th);

        public abstract void b(m mVar);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class i {
        i() {
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        public androidx.emoji2.text.i a(androidx.emoji2.text.g gVar) {
            return new o(gVar);
        }
    }

    private e(c cVar) {
        this.f2733g = cVar.f2745b;
        this.f2734h = cVar.f2746c;
        this.f2735i = cVar.f2747d;
        this.f2736j = cVar.f2749f;
        this.f2737k = cVar.f2750g;
        this.f2732f = cVar.f2744a;
        this.f2738l = cVar.f2751h;
        this.f2739m = cVar.f2752i;
        o.b bVar = new o.b();
        this.f2728b = bVar;
        Set set = cVar.f2748e;
        if (set != null && !set.isEmpty()) {
            bVar.addAll(cVar.f2748e);
        }
        this.f2731e = new a(this);
        l();
    }

    public static e b() {
        e eVar;
        synchronized (f2724n) {
            eVar = f2726p;
            v.h.i(eVar != null, "EmojiCompat is not initialized.\n\nYou must initialize EmojiCompat prior to referencing the EmojiCompat instance.\n\nThe most likely cause of this error is disabling the EmojiCompatInitializer\neither explicitly in AndroidManifest.xml, or by including\nandroidx.emoji2:emoji2-bundled.\n\nAutomatic initialization is typically performed by EmojiCompatInitializer. If\nyou are not expecting to initialize EmojiCompat manually in your application,\nplease check to ensure it has not been removed from your APK's manifest. You can\ndo this in Android Studio using Build > Analyze APK.\n\nIn the APK Analyzer, ensure that the startup entry for\nEmojiCompatInitializer and InitializationProvider is present in\n AndroidManifest.xml. If it is missing or contains tools:node=\"remove\", and you\nintend to use automatic configuration, verify:\n\n  1. Your application does not include emoji2-bundled\n  2. All modules do not contain an exclusion manifest rule for\n     EmojiCompatInitializer or InitializationProvider. For more information\n     about manifest exclusions see the documentation for the androidx startup\n     library.\n\nIf you intend to use emoji2-bundled, please call EmojiCompat.init. You can\nlearn more in the documentation for BundledEmojiCompatConfig.\n\nIf you intended to perform manual configuration, it is recommended that you call\nEmojiCompat.init immediately on application startup.\n\nIf you still cannot resolve this issue, please open a bug with your specific\nconfiguration to help improve error message.");
        }
        return eVar;
    }

    public static boolean e(InputConnection inputConnection, Editable editable, int i10, int i11, boolean z9) {
        return androidx.emoji2.text.h.c(inputConnection, editable, i10, i11, z9);
    }

    public static boolean f(Editable editable, int i10, KeyEvent keyEvent) {
        return androidx.emoji2.text.h.d(editable, i10, keyEvent);
    }

    public static e g(c cVar) {
        e eVar = f2726p;
        if (eVar == null) {
            synchronized (f2724n) {
                eVar = f2726p;
                if (eVar == null) {
                    eVar = new e(cVar);
                    f2726p = eVar;
                }
            }
        }
        return eVar;
    }

    public static boolean h() {
        return f2726p != null;
    }

    private boolean j() {
        return d() == 1;
    }

    private void l() {
        this.f2727a.writeLock().lock();
        try {
            if (this.f2738l == 0) {
                this.f2729c = 0;
            }
            this.f2727a.writeLock().unlock();
            if (d() == 0) {
                this.f2731e.a();
            }
        } catch (Throwable th) {
            this.f2727a.writeLock().unlock();
            throw th;
        }
    }

    public int c() {
        return this.f2737k;
    }

    public int d() {
        this.f2727a.readLock().lock();
        try {
            return this.f2729c;
        } finally {
            this.f2727a.readLock().unlock();
        }
    }

    public boolean i() {
        return this.f2736j;
    }

    public void k() {
        v.h.i(this.f2738l == 1, "Set metadataLoadStrategy to LOAD_STRATEGY_MANUAL to execute manual loading");
        if (j()) {
            return;
        }
        this.f2727a.writeLock().lock();
        try {
            if (this.f2729c == 0) {
                return;
            }
            this.f2729c = 0;
            this.f2727a.writeLock().unlock();
            this.f2731e.a();
        } finally {
            this.f2727a.writeLock().unlock();
        }
    }

    void m(Throwable th) {
        ArrayList arrayList = new ArrayList();
        this.f2727a.writeLock().lock();
        try {
            this.f2729c = 2;
            arrayList.addAll(this.f2728b);
            this.f2728b.clear();
            this.f2727a.writeLock().unlock();
            this.f2730d.post(new f(arrayList, this.f2729c, th));
        } catch (Throwable th2) {
            this.f2727a.writeLock().unlock();
            throw th2;
        }
    }

    void n() {
        ArrayList arrayList = new ArrayList();
        this.f2727a.writeLock().lock();
        try {
            this.f2729c = 1;
            arrayList.addAll(this.f2728b);
            this.f2728b.clear();
            this.f2727a.writeLock().unlock();
            this.f2730d.post(new f(arrayList, this.f2729c));
        } catch (Throwable th) {
            this.f2727a.writeLock().unlock();
            throw th;
        }
    }

    public CharSequence o(CharSequence charSequence) {
        return p(charSequence, 0, charSequence == null ? 0 : charSequence.length());
    }

    public CharSequence p(CharSequence charSequence, int i10, int i11) {
        return q(charSequence, i10, i11, Integer.MAX_VALUE);
    }

    public CharSequence q(CharSequence charSequence, int i10, int i11, int i12) {
        return r(charSequence, i10, i11, i12, 0);
    }

    public CharSequence r(CharSequence charSequence, int i10, int i11, int i12, int i13) {
        v.h.i(j(), "Not initialized yet");
        v.h.e(i10, "start cannot be negative");
        v.h.e(i11, "end cannot be negative");
        v.h.e(i12, "maxEmojiCount cannot be negative");
        v.h.a(i10 <= i11, "start should be <= than end");
        if (charSequence == null) {
            return null;
        }
        v.h.a(i10 <= charSequence.length(), "start should be < than charSequence length");
        v.h.a(i11 <= charSequence.length(), "end should be < than charSequence length");
        if (charSequence.length() == 0 || i10 == i11) {
            return charSequence;
        }
        return this.f2731e.b(charSequence, i10, i11, i12, i13 != 1 ? i13 != 2 ? this.f2733g : false : true);
    }

    public void s(AbstractC0029e abstractC0029e) {
        v.h.h(abstractC0029e, "initCallback cannot be null");
        this.f2727a.writeLock().lock();
        try {
            if (this.f2729c != 1 && this.f2729c != 2) {
                this.f2728b.add(abstractC0029e);
            }
            this.f2730d.post(new f(abstractC0029e, this.f2729c));
        } finally {
            this.f2727a.writeLock().unlock();
        }
    }

    public void t(AbstractC0029e abstractC0029e) {
        v.h.h(abstractC0029e, "initCallback cannot be null");
        this.f2727a.writeLock().lock();
        try {
            this.f2728b.remove(abstractC0029e);
        } finally {
            this.f2727a.writeLock().unlock();
        }
    }

    public void u(EditorInfo editorInfo) {
        if (!j() || editorInfo == null) {
            return;
        }
        if (editorInfo.extras == null) {
            editorInfo.extras = new Bundle();
        }
        this.f2731e.c(editorInfo);
    }
}
