package androidx.datastore.preferences.protobuf;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
/* loaded from: classes.dex */
public abstract class f implements Iterable, Serializable {

    /* renamed from: h  reason: collision with root package name */
    public static final f f2449h = new j(u.f2682c);

    /* renamed from: i  reason: collision with root package name */
    private static final InterfaceC0025f f2450i;

    /* renamed from: j  reason: collision with root package name */
    private static final Comparator f2451j;

    /* renamed from: g  reason: collision with root package name */
    private int f2452g = 0;

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class a extends c {

        /* renamed from: g  reason: collision with root package name */
        private int f2453g = 0;

        /* renamed from: h  reason: collision with root package name */
        private final int f2454h;

        a() {
            this.f2454h = f.this.size();
        }

        @Override // androidx.datastore.preferences.protobuf.f.g
        public byte b() {
            int i10 = this.f2453g;
            if (i10 < this.f2454h) {
                this.f2453g = i10 + 1;
                return f.this.p(i10);
            }
            throw new NoSuchElementException();
        }

        @Override // java.util.Iterator
        public boolean hasNext() {
            return this.f2453g < this.f2454h;
        }
    }

    /* loaded from: classes.dex */
    static class b implements Comparator {
        b() {
        }

        @Override // java.util.Comparator
        /* renamed from: a */
        public int compare(f fVar, f fVar2) {
            g r10 = fVar.r();
            g r11 = fVar2.r();
            while (r10.hasNext() && r11.hasNext()) {
                int compare = Integer.compare(f.w(r10.b()), f.w(r11.b()));
                if (compare != 0) {
                    return compare;
                }
            }
            return Integer.compare(fVar.size(), fVar2.size());
        }
    }

    /* loaded from: classes.dex */
    static abstract class c implements g {
        c() {
        }

        @Override // java.util.Iterator
        /* renamed from: a */
        public final Byte next() {
            return Byte.valueOf(b());
        }

        @Override // java.util.Iterator
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /* loaded from: classes.dex */
    private static final class d implements InterfaceC0025f {
        private d() {
        }

        /* synthetic */ d(a aVar) {
            this();
        }

        @Override // androidx.datastore.preferences.protobuf.f.InterfaceC0025f
        public byte[] a(byte[] bArr, int i10, int i11) {
            return Arrays.copyOfRange(bArr, i10, i11 + i10);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static final class e extends j {

        /* renamed from: l  reason: collision with root package name */
        private final int f2456l;

        /* renamed from: m  reason: collision with root package name */
        private final int f2457m;

        e(byte[] bArr, int i10, int i11) {
            super(bArr);
            f.l(i10, i10 + i11, bArr.length);
            this.f2456l = i10;
            this.f2457m = i11;
        }

        @Override // androidx.datastore.preferences.protobuf.f.j
        protected int E() {
            return this.f2456l;
        }

        @Override // androidx.datastore.preferences.protobuf.f.j, androidx.datastore.preferences.protobuf.f
        public byte j(int i10) {
            f.k(i10, size());
            return this.f2460k[this.f2456l + i10];
        }

        @Override // androidx.datastore.preferences.protobuf.f.j, androidx.datastore.preferences.protobuf.f
        byte p(int i10) {
            return this.f2460k[this.f2456l + i10];
        }

        @Override // androidx.datastore.preferences.protobuf.f.j, androidx.datastore.preferences.protobuf.f
        public int size() {
            return this.f2457m;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* renamed from: androidx.datastore.preferences.protobuf.f$f  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public interface InterfaceC0025f {
        byte[] a(byte[] bArr, int i10, int i11);
    }

    /* loaded from: classes.dex */
    public interface g extends Iterator {
        byte b();
    }

    /* loaded from: classes.dex */
    static final class h {

        /* renamed from: a  reason: collision with root package name */
        private final androidx.datastore.preferences.protobuf.i f2458a;

        /* renamed from: b  reason: collision with root package name */
        private final byte[] f2459b;

        private h(int i10) {
            byte[] bArr = new byte[i10];
            this.f2459b = bArr;
            this.f2458a = androidx.datastore.preferences.protobuf.i.d0(bArr);
        }

        /* synthetic */ h(int i10, a aVar) {
            this(i10);
        }

        public f a() {
            this.f2458a.c();
            return new j(this.f2459b);
        }

        public androidx.datastore.preferences.protobuf.i b() {
            return this.f2458a;
        }
    }

    /* loaded from: classes.dex */
    static abstract class i extends f {
        i() {
        }

        @Override // java.lang.Iterable
        public /* bridge */ /* synthetic */ Iterator iterator() {
            return super.r();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class j extends i {

        /* renamed from: k  reason: collision with root package name */
        protected final byte[] f2460k;

        j(byte[] bArr) {
            bArr.getClass();
            this.f2460k = bArr;
        }

        @Override // androidx.datastore.preferences.protobuf.f
        final void C(androidx.datastore.preferences.protobuf.e eVar) {
            eVar.a(this.f2460k, E(), size());
        }

        final boolean D(f fVar, int i10, int i11) {
            if (i11 > fVar.size()) {
                throw new IllegalArgumentException("Length too large: " + i11 + size());
            }
            int i12 = i10 + i11;
            if (i12 > fVar.size()) {
                throw new IllegalArgumentException("Ran off end of other: " + i10 + ", " + i11 + ", " + fVar.size());
            } else if (fVar instanceof j) {
                j jVar = (j) fVar;
                byte[] bArr = this.f2460k;
                byte[] bArr2 = jVar.f2460k;
                int E = E() + i11;
                int E2 = E();
                int E3 = jVar.E() + i10;
                while (E2 < E) {
                    if (bArr[E2] != bArr2[E3]) {
                        return false;
                    }
                    E2++;
                    E3++;
                }
                return true;
            } else {
                return fVar.v(i10, i12).equals(v(0, i11));
            }
        }

        protected int E() {
            return 0;
        }

        @Override // androidx.datastore.preferences.protobuf.f
        public final boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if ((obj instanceof f) && size() == ((f) obj).size()) {
                if (size() == 0) {
                    return true;
                }
                if (obj instanceof j) {
                    j jVar = (j) obj;
                    int u9 = u();
                    int u10 = jVar.u();
                    if (u9 == 0 || u10 == 0 || u9 == u10) {
                        return D(jVar, 0, size());
                    }
                    return false;
                }
                return obj.equals(this);
            }
            return false;
        }

        @Override // androidx.datastore.preferences.protobuf.f
        public byte j(int i10) {
            return this.f2460k[i10];
        }

        @Override // androidx.datastore.preferences.protobuf.f
        byte p(int i10) {
            return this.f2460k[i10];
        }

        @Override // androidx.datastore.preferences.protobuf.f
        public final boolean q() {
            int E = E();
            return k1.n(this.f2460k, E, size() + E);
        }

        @Override // androidx.datastore.preferences.protobuf.f
        public int size() {
            return this.f2460k.length;
        }

        @Override // androidx.datastore.preferences.protobuf.f
        protected final int t(int i10, int i11, int i12) {
            return u.i(i10, this.f2460k, E() + i11, i12);
        }

        @Override // androidx.datastore.preferences.protobuf.f
        public final f v(int i10, int i11) {
            int l10 = f.l(i10, i11, size());
            return l10 == 0 ? f.f2449h : new e(this.f2460k, E() + i10, l10);
        }

        @Override // androidx.datastore.preferences.protobuf.f
        protected final String y(Charset charset) {
            return new String(this.f2460k, E(), size(), charset);
        }
    }

    /* loaded from: classes.dex */
    private static final class k implements InterfaceC0025f {
        private k() {
        }

        /* synthetic */ k(a aVar) {
            this();
        }

        @Override // androidx.datastore.preferences.protobuf.f.InterfaceC0025f
        public byte[] a(byte[] bArr, int i10, int i11) {
            byte[] bArr2 = new byte[i11];
            System.arraycopy(bArr, i10, bArr2, 0, i11);
            return bArr2;
        }
    }

    static {
        f2450i = androidx.datastore.preferences.protobuf.d.c() ? new k(null) : new d(null);
        f2451j = new b();
    }

    f() {
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static f A(byte[] bArr) {
        return new j(bArr);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static f B(byte[] bArr, int i10, int i11) {
        return new e(bArr, i10, i11);
    }

    static void k(int i10, int i11) {
        if (((i11 - (i10 + 1)) | i10) < 0) {
            if (i10 < 0) {
                throw new ArrayIndexOutOfBoundsException("Index < 0: " + i10);
            }
            throw new ArrayIndexOutOfBoundsException("Index > length: " + i10 + ", " + i11);
        }
    }

    static int l(int i10, int i11, int i12) {
        int i13 = i11 - i10;
        if ((i10 | i11 | i13 | (i12 - i11)) < 0) {
            if (i10 < 0) {
                throw new IndexOutOfBoundsException("Beginning index: " + i10 + " < 0");
            } else if (i11 < i10) {
                throw new IndexOutOfBoundsException("Beginning index larger than ending index: " + i10 + ", " + i11);
            } else {
                throw new IndexOutOfBoundsException("End index: " + i11 + " >= " + i12);
            }
        }
        return i13;
    }

    public static f m(byte[] bArr) {
        return n(bArr, 0, bArr.length);
    }

    public static f n(byte[] bArr, int i10, int i11) {
        l(i10, i10 + i11, bArr.length);
        return new j(f2450i.a(bArr, i10, i11));
    }

    public static f o(String str) {
        return new j(str.getBytes(u.f2680a));
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static h s(int i10) {
        return new h(i10, null);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static int w(byte b10) {
        return b10 & 255;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public abstract void C(androidx.datastore.preferences.protobuf.e eVar);

    public abstract boolean equals(Object obj);

    public final int hashCode() {
        int i10 = this.f2452g;
        if (i10 == 0) {
            int size = size();
            i10 = t(size, 0, size);
            if (i10 == 0) {
                i10 = 1;
            }
            this.f2452g = i10;
        }
        return i10;
    }

    public abstract byte j(int i10);

    abstract byte p(int i10);

    public abstract boolean q();

    public g r() {
        return new a();
    }

    public abstract int size();

    protected abstract int t(int i10, int i11, int i12);

    public final String toString() {
        return String.format("<ByteString@%s size=%d>", Integer.toHexString(System.identityHashCode(this)), Integer.valueOf(size()));
    }

    protected final int u() {
        return this.f2452g;
    }

    public abstract f v(int i10, int i11);

    public final String x(Charset charset) {
        return size() == 0 ? "" : y(charset);
    }

    protected abstract String y(Charset charset);

    public final String z() {
        return x(u.f2680a);
    }
}
