package androidx.datastore.preferences.protobuf;

import androidx.datastore.preferences.protobuf.q;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public abstract class b1 extends AbstractMap {

    /* renamed from: g  reason: collision with root package name */
    private final int f2411g;

    /* renamed from: h  reason: collision with root package name */
    private List f2412h;

    /* renamed from: i  reason: collision with root package name */
    private Map f2413i;

    /* renamed from: j  reason: collision with root package name */
    private boolean f2414j;

    /* renamed from: k  reason: collision with root package name */
    private volatile g f2415k;

    /* renamed from: l  reason: collision with root package name */
    private Map f2416l;

    /* renamed from: m  reason: collision with root package name */
    private volatile c f2417m;

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class a extends b1 {
        a(int i10) {
            super(i10, null);
        }

        @Override // androidx.datastore.preferences.protobuf.b1
        public void p() {
            if (!o()) {
                for (int i10 = 0; i10 < k(); i10++) {
                    Map.Entry j10 = j(i10);
                    if (((q.b) j10.getKey()).c()) {
                        j10.setValue(Collections.unmodifiableList((List) j10.getValue()));
                    }
                }
                for (Map.Entry entry : m()) {
                    if (((q.b) entry.getKey()).c()) {
                        entry.setValue(Collections.unmodifiableList((List) entry.getValue()));
                    }
                }
            }
            super.p();
        }

        @Override // java.util.AbstractMap, java.util.Map
        public /* bridge */ /* synthetic */ Object put(Object obj, Object obj2) {
            return super.r((q.b) obj, obj2);
        }
    }

    /* loaded from: classes.dex */
    private class b implements Iterator {

        /* renamed from: g  reason: collision with root package name */
        private int f2418g;

        /* renamed from: h  reason: collision with root package name */
        private Iterator f2419h;

        private b() {
            this.f2418g = b1.this.f2412h.size();
        }

        /* synthetic */ b(b1 b1Var, a aVar) {
            this();
        }

        private Iterator a() {
            if (this.f2419h == null) {
                this.f2419h = b1.this.f2416l.entrySet().iterator();
            }
            return this.f2419h;
        }

        @Override // java.util.Iterator
        /* renamed from: c */
        public Map.Entry next() {
            Object obj;
            if (a().hasNext()) {
                obj = a().next();
            } else {
                List list = b1.this.f2412h;
                int i10 = this.f2418g - 1;
                this.f2418g = i10;
                obj = list.get(i10);
            }
            return (Map.Entry) obj;
        }

        @Override // java.util.Iterator
        public boolean hasNext() {
            int i10 = this.f2418g;
            return (i10 > 0 && i10 <= b1.this.f2412h.size()) || a().hasNext();
        }

        @Override // java.util.Iterator
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class c extends g {
        private c() {
            super(b1.this, null);
        }

        /* synthetic */ c(b1 b1Var, a aVar) {
            this();
        }

        @Override // androidx.datastore.preferences.protobuf.b1.g, java.util.AbstractCollection, java.util.Collection, java.lang.Iterable, java.util.Set
        public Iterator iterator() {
            return new b(b1.this, null);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class d {

        /* renamed from: a  reason: collision with root package name */
        private static final Iterator f2422a = new a();

        /* renamed from: b  reason: collision with root package name */
        private static final Iterable f2423b = new b();

        /* loaded from: classes.dex */
        static class a implements Iterator {
            a() {
            }

            @Override // java.util.Iterator
            public boolean hasNext() {
                return false;
            }

            @Override // java.util.Iterator
            public Object next() {
                throw new NoSuchElementException();
            }

            @Override // java.util.Iterator
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        /* loaded from: classes.dex */
        static class b implements Iterable {
            b() {
            }

            @Override // java.lang.Iterable
            public Iterator iterator() {
                return d.f2422a;
            }
        }

        static Iterable b() {
            return f2423b;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class e implements Map.Entry, Comparable {

        /* renamed from: g  reason: collision with root package name */
        private final Comparable f2424g;

        /* renamed from: h  reason: collision with root package name */
        private Object f2425h;

        e(Comparable comparable, Object obj) {
            this.f2424g = comparable;
            this.f2425h = obj;
        }

        e(b1 b1Var, Map.Entry entry) {
            this((Comparable) entry.getKey(), entry.getValue());
        }

        private boolean g(Object obj, Object obj2) {
            return obj == null ? obj2 == null : obj.equals(obj2);
        }

        @Override // java.lang.Comparable
        /* renamed from: b */
        public int compareTo(e eVar) {
            return getKey().compareTo(eVar.getKey());
        }

        @Override // java.util.Map.Entry
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry) obj;
                return g(this.f2424g, entry.getKey()) && g(this.f2425h, entry.getValue());
            }
            return false;
        }

        @Override // java.util.Map.Entry
        public Object getValue() {
            return this.f2425h;
        }

        @Override // java.util.Map.Entry
        /* renamed from: h */
        public Comparable getKey() {
            return this.f2424g;
        }

        @Override // java.util.Map.Entry
        public int hashCode() {
            Comparable comparable = this.f2424g;
            int hashCode = comparable == null ? 0 : comparable.hashCode();
            Object obj = this.f2425h;
            return hashCode ^ (obj != null ? obj.hashCode() : 0);
        }

        @Override // java.util.Map.Entry
        public Object setValue(Object obj) {
            b1.this.g();
            Object obj2 = this.f2425h;
            this.f2425h = obj;
            return obj2;
        }

        public String toString() {
            return this.f2424g + "=" + this.f2425h;
        }
    }

    /* loaded from: classes.dex */
    private class f implements Iterator {

        /* renamed from: g  reason: collision with root package name */
        private int f2427g;

        /* renamed from: h  reason: collision with root package name */
        private boolean f2428h;

        /* renamed from: i  reason: collision with root package name */
        private Iterator f2429i;

        private f() {
            this.f2427g = -1;
        }

        /* synthetic */ f(b1 b1Var, a aVar) {
            this();
        }

        private Iterator a() {
            if (this.f2429i == null) {
                this.f2429i = b1.this.f2413i.entrySet().iterator();
            }
            return this.f2429i;
        }

        @Override // java.util.Iterator
        /* renamed from: c */
        public Map.Entry next() {
            this.f2428h = true;
            int i10 = this.f2427g + 1;
            this.f2427g = i10;
            return (Map.Entry) (i10 < b1.this.f2412h.size() ? b1.this.f2412h.get(this.f2427g) : a().next());
        }

        @Override // java.util.Iterator
        public boolean hasNext() {
            if (this.f2427g + 1 >= b1.this.f2412h.size()) {
                return !b1.this.f2413i.isEmpty() && a().hasNext();
            }
            return true;
        }

        @Override // java.util.Iterator
        public void remove() {
            if (!this.f2428h) {
                throw new IllegalStateException("remove() was called before next()");
            }
            this.f2428h = false;
            b1.this.g();
            if (this.f2427g >= b1.this.f2412h.size()) {
                a().remove();
                return;
            }
            b1 b1Var = b1.this;
            int i10 = this.f2427g;
            this.f2427g = i10 - 1;
            b1Var.s(i10);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class g extends AbstractSet {
        private g() {
        }

        /* synthetic */ g(b1 b1Var, a aVar) {
            this();
        }

        @Override // java.util.AbstractCollection, java.util.Collection, java.util.Set
        public void clear() {
            b1.this.clear();
        }

        @Override // java.util.AbstractCollection, java.util.Collection, java.util.Set
        public boolean contains(Object obj) {
            Map.Entry entry = (Map.Entry) obj;
            Object obj2 = b1.this.get(entry.getKey());
            Object value = entry.getValue();
            return obj2 == value || (obj2 != null && obj2.equals(value));
        }

        @Override // java.util.AbstractCollection, java.util.Collection, java.util.Set
        /* renamed from: i */
        public boolean add(Map.Entry entry) {
            if (contains(entry)) {
                return false;
            }
            b1.this.r((Comparable) entry.getKey(), entry.getValue());
            return true;
        }

        @Override // java.util.AbstractCollection, java.util.Collection, java.lang.Iterable, java.util.Set
        public Iterator iterator() {
            return new f(b1.this, null);
        }

        @Override // java.util.AbstractCollection, java.util.Collection, java.util.Set
        public boolean remove(Object obj) {
            Map.Entry entry = (Map.Entry) obj;
            if (contains(entry)) {
                b1.this.remove(entry.getKey());
                return true;
            }
            return false;
        }

        @Override // java.util.AbstractCollection, java.util.Collection, java.util.Set
        public int size() {
            return b1.this.size();
        }
    }

    private b1(int i10) {
        this.f2411g = i10;
        this.f2412h = Collections.emptyList();
        this.f2413i = Collections.emptyMap();
        this.f2416l = Collections.emptyMap();
    }

    /* synthetic */ b1(int i10, a aVar) {
        this(i10);
    }

    private int f(Comparable comparable) {
        int size = this.f2412h.size() - 1;
        if (size >= 0) {
            int compareTo = comparable.compareTo(((e) this.f2412h.get(size)).getKey());
            if (compareTo > 0) {
                return -(size + 2);
            }
            if (compareTo == 0) {
                return size;
            }
        }
        int i10 = 0;
        while (i10 <= size) {
            int i11 = (i10 + size) / 2;
            int compareTo2 = comparable.compareTo(((e) this.f2412h.get(i11)).getKey());
            if (compareTo2 < 0) {
                size = i11 - 1;
            } else if (compareTo2 <= 0) {
                return i11;
            } else {
                i10 = i11 + 1;
            }
        }
        return -(i10 + 1);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void g() {
        if (this.f2414j) {
            throw new UnsupportedOperationException();
        }
    }

    private void i() {
        g();
        if (!this.f2412h.isEmpty() || (this.f2412h instanceof ArrayList)) {
            return;
        }
        this.f2412h = new ArrayList(this.f2411g);
    }

    private SortedMap n() {
        g();
        if (this.f2413i.isEmpty() && !(this.f2413i instanceof TreeMap)) {
            TreeMap treeMap = new TreeMap();
            this.f2413i = treeMap;
            this.f2416l = treeMap.descendingMap();
        }
        return (SortedMap) this.f2413i;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static b1 q(int i10) {
        return new a(i10);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public Object s(int i10) {
        g();
        Object value = ((e) this.f2412h.remove(i10)).getValue();
        if (!this.f2413i.isEmpty()) {
            Iterator it = n().entrySet().iterator();
            this.f2412h.add(new e(this, (Map.Entry) it.next()));
            it.remove();
        }
        return value;
    }

    @Override // java.util.AbstractMap, java.util.Map
    public void clear() {
        g();
        if (!this.f2412h.isEmpty()) {
            this.f2412h.clear();
        }
        if (this.f2413i.isEmpty()) {
            return;
        }
        this.f2413i.clear();
    }

    @Override // java.util.AbstractMap, java.util.Map
    public boolean containsKey(Object obj) {
        Comparable comparable = (Comparable) obj;
        return f(comparable) >= 0 || this.f2413i.containsKey(comparable);
    }

    @Override // java.util.AbstractMap, java.util.Map
    public Set entrySet() {
        if (this.f2415k == null) {
            this.f2415k = new g(this, null);
        }
        return this.f2415k;
    }

    @Override // java.util.AbstractMap, java.util.Map
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof b1) {
            b1 b1Var = (b1) obj;
            int size = size();
            if (size != b1Var.size()) {
                return false;
            }
            int k10 = k();
            if (k10 != b1Var.k()) {
                return entrySet().equals(b1Var.entrySet());
            }
            for (int i10 = 0; i10 < k10; i10++) {
                if (!j(i10).equals(b1Var.j(i10))) {
                    return false;
                }
            }
            if (k10 != size) {
                return this.f2413i.equals(b1Var.f2413i);
            }
            return true;
        }
        return super.equals(obj);
    }

    @Override // java.util.AbstractMap, java.util.Map
    public Object get(Object obj) {
        Comparable comparable = (Comparable) obj;
        int f10 = f(comparable);
        return f10 >= 0 ? ((e) this.f2412h.get(f10)).getValue() : this.f2413i.get(comparable);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public Set h() {
        if (this.f2417m == null) {
            this.f2417m = new c(this, null);
        }
        return this.f2417m;
    }

    @Override // java.util.AbstractMap, java.util.Map
    public int hashCode() {
        int k10 = k();
        int i10 = 0;
        for (int i11 = 0; i11 < k10; i11++) {
            i10 += ((e) this.f2412h.get(i11)).hashCode();
        }
        return l() > 0 ? i10 + this.f2413i.hashCode() : i10;
    }

    public Map.Entry j(int i10) {
        return (Map.Entry) this.f2412h.get(i10);
    }

    public int k() {
        return this.f2412h.size();
    }

    public int l() {
        return this.f2413i.size();
    }

    public Iterable m() {
        return this.f2413i.isEmpty() ? d.b() : this.f2413i.entrySet();
    }

    public boolean o() {
        return this.f2414j;
    }

    public void p() {
        if (this.f2414j) {
            return;
        }
        this.f2413i = this.f2413i.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.f2413i);
        this.f2416l = this.f2416l.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.f2416l);
        this.f2414j = true;
    }

    public Object r(Comparable comparable, Object obj) {
        g();
        int f10 = f(comparable);
        if (f10 >= 0) {
            return ((e) this.f2412h.get(f10)).setValue(obj);
        }
        i();
        int i10 = -(f10 + 1);
        if (i10 >= this.f2411g) {
            return n().put(comparable, obj);
        }
        int size = this.f2412h.size();
        int i11 = this.f2411g;
        if (size == i11) {
            e eVar = (e) this.f2412h.remove(i11 - 1);
            n().put(eVar.getKey(), eVar.getValue());
        }
        this.f2412h.add(i10, new e(comparable, obj));
        return null;
    }

    @Override // java.util.AbstractMap, java.util.Map
    public Object remove(Object obj) {
        g();
        Comparable comparable = (Comparable) obj;
        int f10 = f(comparable);
        if (f10 >= 0) {
            return s(f10);
        }
        if (this.f2413i.isEmpty()) {
            return null;
        }
        return this.f2413i.remove(comparable);
    }

    @Override // java.util.AbstractMap, java.util.Map
    public int size() {
        return this.f2412h.size() + this.f2413i.size();
    }
}
