package androidx.core.widget;

import android.content.res.Resources;
import android.os.SystemClock;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import androidx.core.view.r0;
/* loaded from: classes.dex */
public abstract class a implements View.OnTouchListener {

    /* renamed from: x  reason: collision with root package name */
    private static final int f2360x = ViewConfiguration.getTapTimeout();

    /* renamed from: i  reason: collision with root package name */
    final View f2363i;

    /* renamed from: j  reason: collision with root package name */
    private Runnable f2364j;

    /* renamed from: m  reason: collision with root package name */
    private int f2367m;

    /* renamed from: n  reason: collision with root package name */
    private int f2368n;

    /* renamed from: r  reason: collision with root package name */
    private boolean f2372r;

    /* renamed from: s  reason: collision with root package name */
    boolean f2373s;

    /* renamed from: t  reason: collision with root package name */
    boolean f2374t;

    /* renamed from: u  reason: collision with root package name */
    boolean f2375u;

    /* renamed from: v  reason: collision with root package name */
    private boolean f2376v;

    /* renamed from: w  reason: collision with root package name */
    private boolean f2377w;

    /* renamed from: g  reason: collision with root package name */
    final C0023a f2361g = new C0023a();

    /* renamed from: h  reason: collision with root package name */
    private final Interpolator f2362h = new AccelerateInterpolator();

    /* renamed from: k  reason: collision with root package name */
    private float[] f2365k = {0.0f, 0.0f};

    /* renamed from: l  reason: collision with root package name */
    private float[] f2366l = {Float.MAX_VALUE, Float.MAX_VALUE};

    /* renamed from: o  reason: collision with root package name */
    private float[] f2369o = {0.0f, 0.0f};

    /* renamed from: p  reason: collision with root package name */
    private float[] f2370p = {0.0f, 0.0f};

    /* renamed from: q  reason: collision with root package name */
    private float[] f2371q = {Float.MAX_VALUE, Float.MAX_VALUE};

    /* JADX INFO: Access modifiers changed from: private */
    /* renamed from: androidx.core.widget.a$a  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public static class C0023a {

        /* renamed from: a  reason: collision with root package name */
        private int f2378a;

        /* renamed from: b  reason: collision with root package name */
        private int f2379b;

        /* renamed from: c  reason: collision with root package name */
        private float f2380c;

        /* renamed from: d  reason: collision with root package name */
        private float f2381d;

        /* renamed from: j  reason: collision with root package name */
        private float f2387j;

        /* renamed from: k  reason: collision with root package name */
        private int f2388k;

        /* renamed from: e  reason: collision with root package name */
        private long f2382e = Long.MIN_VALUE;

        /* renamed from: i  reason: collision with root package name */
        private long f2386i = -1;

        /* renamed from: f  reason: collision with root package name */
        private long f2383f = 0;

        /* renamed from: g  reason: collision with root package name */
        private int f2384g = 0;

        /* renamed from: h  reason: collision with root package name */
        private int f2385h = 0;

        C0023a() {
        }

        private float e(long j10) {
            long j11 = this.f2382e;
            if (j10 < j11) {
                return 0.0f;
            }
            long j12 = this.f2386i;
            if (j12 < 0 || j10 < j12) {
                return a.e(((float) (j10 - j11)) / this.f2378a, 0.0f, 1.0f) * 0.5f;
            }
            float f10 = this.f2387j;
            return (1.0f - f10) + (f10 * a.e(((float) (j10 - j12)) / this.f2388k, 0.0f, 1.0f));
        }

        private float g(float f10) {
            return ((-4.0f) * f10 * f10) + (f10 * 4.0f);
        }

        public void a() {
            if (this.f2383f == 0) {
                throw new RuntimeException("Cannot compute scroll delta before calling start()");
            }
            long currentAnimationTimeMillis = AnimationUtils.currentAnimationTimeMillis();
            float g10 = g(e(currentAnimationTimeMillis));
            this.f2383f = currentAnimationTimeMillis;
            float f10 = ((float) (currentAnimationTimeMillis - this.f2383f)) * g10;
            this.f2384g = (int) (this.f2380c * f10);
            this.f2385h = (int) (f10 * this.f2381d);
        }

        public int b() {
            return this.f2384g;
        }

        public int c() {
            return this.f2385h;
        }

        public int d() {
            float f10 = this.f2380c;
            return (int) (f10 / Math.abs(f10));
        }

        public int f() {
            float f10 = this.f2381d;
            return (int) (f10 / Math.abs(f10));
        }

        public boolean h() {
            return this.f2386i > 0 && AnimationUtils.currentAnimationTimeMillis() > this.f2386i + ((long) this.f2388k);
        }

        public void i() {
            long currentAnimationTimeMillis = AnimationUtils.currentAnimationTimeMillis();
            this.f2388k = a.f((int) (currentAnimationTimeMillis - this.f2382e), 0, this.f2379b);
            this.f2387j = e(currentAnimationTimeMillis);
            this.f2386i = currentAnimationTimeMillis;
        }

        public void j(int i10) {
            this.f2379b = i10;
        }

        public void k(int i10) {
            this.f2378a = i10;
        }

        public void l(float f10, float f11) {
            this.f2380c = f10;
            this.f2381d = f11;
        }

        public void m() {
            long currentAnimationTimeMillis = AnimationUtils.currentAnimationTimeMillis();
            this.f2382e = currentAnimationTimeMillis;
            this.f2386i = -1L;
            this.f2383f = currentAnimationTimeMillis;
            this.f2387j = 0.5f;
            this.f2384g = 0;
            this.f2385h = 0;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class b implements Runnable {
        b() {
        }

        @Override // java.lang.Runnable
        public void run() {
            a aVar = a.this;
            if (aVar.f2375u) {
                if (aVar.f2373s) {
                    aVar.f2373s = false;
                    aVar.f2361g.m();
                }
                C0023a c0023a = a.this.f2361g;
                if (c0023a.h() || !a.this.u()) {
                    a.this.f2375u = false;
                    return;
                }
                a aVar2 = a.this;
                if (aVar2.f2374t) {
                    aVar2.f2374t = false;
                    aVar2.c();
                }
                c0023a.a();
                a.this.j(c0023a.b(), c0023a.c());
                r0.f0(a.this.f2363i, this);
            }
        }
    }

    public a(View view) {
        this.f2363i = view;
        float f10 = Resources.getSystem().getDisplayMetrics().density;
        float f11 = (int) ((1575.0f * f10) + 0.5f);
        o(f11, f11);
        float f12 = (int) ((f10 * 315.0f) + 0.5f);
        p(f12, f12);
        l(1);
        n(Float.MAX_VALUE, Float.MAX_VALUE);
        s(0.2f, 0.2f);
        t(1.0f, 1.0f);
        k(f2360x);
        r(500);
        q(500);
    }

    private float d(int i10, float f10, float f11, float f12) {
        float h10 = h(this.f2365k[i10], f11, this.f2366l[i10], f10);
        int i11 = (h10 > 0.0f ? 1 : (h10 == 0.0f ? 0 : -1));
        if (i11 == 0) {
            return 0.0f;
        }
        float f13 = this.f2369o[i10];
        float f14 = this.f2370p[i10];
        float f15 = this.f2371q[i10];
        float f16 = f13 * f12;
        return i11 > 0 ? e(h10 * f16, f14, f15) : -e((-h10) * f16, f14, f15);
    }

    static float e(float f10, float f11, float f12) {
        return f10 > f12 ? f12 : f10 < f11 ? f11 : f10;
    }

    static int f(int i10, int i11, int i12) {
        return i10 > i12 ? i12 : i10 < i11 ? i11 : i10;
    }

    private float g(float f10, float f11) {
        if (f11 == 0.0f) {
            return 0.0f;
        }
        int i10 = this.f2367m;
        if (i10 == 0 || i10 == 1) {
            if (f10 < f11) {
                if (f10 >= 0.0f) {
                    return 1.0f - (f10 / f11);
                }
                if (this.f2375u && i10 == 1) {
                    return 1.0f;
                }
            }
        } else if (i10 == 2 && f10 < 0.0f) {
            return f10 / (-f11);
        }
        return 0.0f;
    }

    private float h(float f10, float f11, float f12, float f13) {
        float interpolation;
        float e10 = e(f10 * f11, 0.0f, f12);
        float g10 = g(f11 - f13, e10) - g(f13, e10);
        if (g10 < 0.0f) {
            interpolation = -this.f2362h.getInterpolation(-g10);
        } else if (g10 <= 0.0f) {
            return 0.0f;
        } else {
            interpolation = this.f2362h.getInterpolation(g10);
        }
        return e(interpolation, -1.0f, 1.0f);
    }

    private void i() {
        if (this.f2373s) {
            this.f2375u = false;
        } else {
            this.f2361g.i();
        }
    }

    private void v() {
        int i10;
        if (this.f2364j == null) {
            this.f2364j = new b();
        }
        this.f2375u = true;
        this.f2373s = true;
        if (this.f2372r || (i10 = this.f2368n) <= 0) {
            this.f2364j.run();
        } else {
            r0.g0(this.f2363i, this.f2364j, i10);
        }
        this.f2372r = true;
    }

    public abstract boolean a(int i10);

    public abstract boolean b(int i10);

    void c() {
        long uptimeMillis = SystemClock.uptimeMillis();
        MotionEvent obtain = MotionEvent.obtain(uptimeMillis, uptimeMillis, 3, 0.0f, 0.0f, 0);
        this.f2363i.onTouchEvent(obtain);
        obtain.recycle();
    }

    public abstract void j(int i10, int i11);

    public a k(int i10) {
        this.f2368n = i10;
        return this;
    }

    public a l(int i10) {
        this.f2367m = i10;
        return this;
    }

    public a m(boolean z9) {
        if (this.f2376v && !z9) {
            i();
        }
        this.f2376v = z9;
        return this;
    }

    public a n(float f10, float f11) {
        float[] fArr = this.f2366l;
        fArr[0] = f10;
        fArr[1] = f11;
        return this;
    }

    public a o(float f10, float f11) {
        float[] fArr = this.f2371q;
        fArr[0] = f10 / 1000.0f;
        fArr[1] = f11 / 1000.0f;
        return this;
    }

    /* JADX WARN: Code restructure failed: missing block: B:11:0x0013, code lost:
        if (r0 != 3) goto L12;
     */
    @Override // android.view.View.OnTouchListener
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public boolean onTouch(View view, MotionEvent motionEvent) {
        if (!this.f2376v) {
            return false;
        }
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked != 0) {
            if (actionMasked != 1) {
                if (actionMasked != 2) {
                }
            }
            i();
            return this.f2377w && this.f2375u;
        }
        this.f2374t = true;
        this.f2372r = false;
        this.f2361g.l(d(0, motionEvent.getX(), view.getWidth(), this.f2363i.getWidth()), d(1, motionEvent.getY(), view.getHeight(), this.f2363i.getHeight()));
        if (!this.f2375u && u()) {
            v();
        }
        if (this.f2377w) {
            return false;
        }
    }

    public a p(float f10, float f11) {
        float[] fArr = this.f2370p;
        fArr[0] = f10 / 1000.0f;
        fArr[1] = f11 / 1000.0f;
        return this;
    }

    public a q(int i10) {
        this.f2361g.j(i10);
        return this;
    }

    public a r(int i10) {
        this.f2361g.k(i10);
        return this;
    }

    public a s(float f10, float f11) {
        float[] fArr = this.f2365k;
        fArr[0] = f10;
        fArr[1] = f11;
        return this;
    }

    public a t(float f10, float f11) {
        float[] fArr = this.f2369o;
        fArr[0] = f10 / 1000.0f;
        fArr[1] = f11 / 1000.0f;
        return this;
    }

    boolean u() {
        C0023a c0023a = this.f2361g;
        int f10 = c0023a.f();
        int d10 = c0023a.d();
        return (f10 != 0 && b(f10)) || (d10 != 0 && a(d10));
    }
}
