package androidx.core.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.AnimationUtils;
import android.widget.EdgeEffect;
import android.widget.FrameLayout;
import android.widget.OverScroller;
import android.widget.ScrollView;
import androidx.core.view.e0;
import androidx.core.view.f0;
import androidx.core.view.h0;
import androidx.core.view.i0;
import androidx.core.view.r0;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import w.l;
/* loaded from: classes.dex */
public class NestedScrollView extends FrameLayout implements h0 {
    private static final float J = (float) (Math.log(0.78d) / Math.log(0.9d));
    private static final a K = new a();
    private static final int[] L = {16843130};
    private int A;
    private int B;
    private e C;
    private final i0 D;
    private final f0 E;
    private float F;
    private d G;
    final c H;
    androidx.core.view.f I;

    /* renamed from: g  reason: collision with root package name */
    private final float f2338g;

    /* renamed from: h  reason: collision with root package name */
    private long f2339h;

    /* renamed from: i  reason: collision with root package name */
    private final Rect f2340i;

    /* renamed from: j  reason: collision with root package name */
    private OverScroller f2341j;

    /* renamed from: k  reason: collision with root package name */
    public EdgeEffect f2342k;

    /* renamed from: l  reason: collision with root package name */
    public EdgeEffect f2343l;

    /* renamed from: m  reason: collision with root package name */
    private int f2344m;

    /* renamed from: n  reason: collision with root package name */
    private boolean f2345n;

    /* renamed from: o  reason: collision with root package name */
    private boolean f2346o;

    /* renamed from: p  reason: collision with root package name */
    private View f2347p;

    /* renamed from: q  reason: collision with root package name */
    private boolean f2348q;

    /* renamed from: r  reason: collision with root package name */
    private VelocityTracker f2349r;

    /* renamed from: s  reason: collision with root package name */
    private boolean f2350s;

    /* renamed from: t  reason: collision with root package name */
    private boolean f2351t;

    /* renamed from: u  reason: collision with root package name */
    private int f2352u;

    /* renamed from: v  reason: collision with root package name */
    private int f2353v;

    /* renamed from: w  reason: collision with root package name */
    private int f2354w;

    /* renamed from: x  reason: collision with root package name */
    private int f2355x;

    /* renamed from: y  reason: collision with root package name */
    private final int[] f2356y;

    /* renamed from: z  reason: collision with root package name */
    private final int[] f2357z;

    /* loaded from: classes.dex */
    static class a extends androidx.core.view.a {
        a() {
        }

        @Override // androidx.core.view.a
        public void f(View view, AccessibilityEvent accessibilityEvent) {
            super.f(view, accessibilityEvent);
            NestedScrollView nestedScrollView = (NestedScrollView) view;
            accessibilityEvent.setClassName(ScrollView.class.getName());
            accessibilityEvent.setScrollable(nestedScrollView.getScrollRange() > 0);
            accessibilityEvent.setScrollX(nestedScrollView.getScrollX());
            accessibilityEvent.setScrollY(nestedScrollView.getScrollY());
            w.q.a(accessibilityEvent, nestedScrollView.getScrollX());
            w.q.b(accessibilityEvent, nestedScrollView.getScrollRange());
        }

        @Override // androidx.core.view.a
        public void g(View view, w.l lVar) {
            int scrollRange;
            super.g(view, lVar);
            NestedScrollView nestedScrollView = (NestedScrollView) view;
            lVar.j0(ScrollView.class.getName());
            if (!nestedScrollView.isEnabled() || (scrollRange = nestedScrollView.getScrollRange()) <= 0) {
                return;
            }
            lVar.A0(true);
            if (nestedScrollView.getScrollY() > 0) {
                lVar.b(l.a.f14184r);
                lVar.b(l.a.C);
            }
            if (nestedScrollView.getScrollY() < scrollRange) {
                lVar.b(l.a.f14183q);
                lVar.b(l.a.E);
            }
        }

        @Override // androidx.core.view.a
        public boolean j(View view, int i10, Bundle bundle) {
            if (super.j(view, i10, bundle)) {
                return true;
            }
            NestedScrollView nestedScrollView = (NestedScrollView) view;
            if (nestedScrollView.isEnabled()) {
                int height = nestedScrollView.getHeight();
                Rect rect = new Rect();
                if (nestedScrollView.getMatrix().isIdentity() && nestedScrollView.getGlobalVisibleRect(rect)) {
                    height = rect.height();
                }
                if (i10 != 4096) {
                    if (i10 == 8192 || i10 == 16908344) {
                        int max = Math.max(nestedScrollView.getScrollY() - ((height - nestedScrollView.getPaddingBottom()) - nestedScrollView.getPaddingTop()), 0);
                        if (max != nestedScrollView.getScrollY()) {
                            nestedScrollView.W(0, max, true);
                            return true;
                        }
                        return false;
                    } else if (i10 != 16908346) {
                        return false;
                    }
                }
                int min = Math.min(nestedScrollView.getScrollY() + ((height - nestedScrollView.getPaddingBottom()) - nestedScrollView.getPaddingTop()), nestedScrollView.getScrollRange());
                if (min != nestedScrollView.getScrollY()) {
                    nestedScrollView.W(0, min, true);
                    return true;
                }
                return false;
            }
            return false;
        }
    }

    /* loaded from: classes.dex */
    static class b {
        static boolean a(ViewGroup viewGroup) {
            return viewGroup.getClipToPadding();
        }
    }

    /* loaded from: classes.dex */
    class c implements androidx.core.view.g {
        c() {
        }

        @Override // androidx.core.view.g
        public boolean a(float f10) {
            if (f10 == 0.0f) {
                return false;
            }
            c();
            NestedScrollView.this.v((int) f10);
            return true;
        }

        @Override // androidx.core.view.g
        public float b() {
            return -NestedScrollView.this.getVerticalScrollFactorCompat();
        }

        @Override // androidx.core.view.g
        public void c() {
            NestedScrollView.this.f2341j.abortAnimation();
        }
    }

    /* loaded from: classes.dex */
    public interface d {
        void a(NestedScrollView nestedScrollView, int i10, int i11, int i12, int i13);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class e extends View.BaseSavedState {
        public static final Parcelable.Creator<e> CREATOR = new a();

        /* renamed from: g  reason: collision with root package name */
        public int f2359g;

        /* loaded from: classes.dex */
        class a implements Parcelable.Creator {
            a() {
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: a */
            public e createFromParcel(Parcel parcel) {
                return new e(parcel);
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: b */
            public e[] newArray(int i10) {
                return new e[i10];
            }
        }

        e(Parcel parcel) {
            super(parcel);
            this.f2359g = parcel.readInt();
        }

        e(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            return "HorizontalScrollView.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " scrollPosition=" + this.f2359g + "}";
        }

        @Override // android.view.View.BaseSavedState, android.view.AbsSavedState, android.os.Parcelable
        public void writeToParcel(Parcel parcel, int i10) {
            super.writeToParcel(parcel, i10);
            parcel.writeInt(this.f2359g);
        }
    }

    public NestedScrollView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, q.a.f11962c);
    }

    public NestedScrollView(Context context, AttributeSet attributeSet, int i10) {
        super(context, attributeSet, i10);
        this.f2340i = new Rect();
        this.f2345n = true;
        this.f2346o = false;
        this.f2347p = null;
        this.f2348q = false;
        this.f2351t = true;
        this.f2355x = -1;
        this.f2356y = new int[2];
        this.f2357z = new int[2];
        c cVar = new c();
        this.H = cVar;
        this.I = new androidx.core.view.f(getContext(), cVar);
        this.f2342k = androidx.core.widget.e.a(context, attributeSet);
        this.f2343l = androidx.core.widget.e.a(context, attributeSet);
        this.f2338g = context.getResources().getDisplayMetrics().density * 160.0f * 386.0878f * 0.84f;
        B();
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, L, i10, 0);
        setFillViewport(obtainStyledAttributes.getBoolean(0, false));
        obtainStyledAttributes.recycle();
        this.D = new i0(this);
        this.E = new f0(this);
        setNestedScrollingEnabled(true);
        r0.n0(this, K);
    }

    private void A() {
        VelocityTracker velocityTracker = this.f2349r;
        if (velocityTracker == null) {
            this.f2349r = VelocityTracker.obtain();
        } else {
            velocityTracker.clear();
        }
    }

    private void B() {
        this.f2341j = new OverScroller(getContext());
        setFocusable(true);
        setDescendantFocusability(262144);
        setWillNotDraw(false);
        ViewConfiguration viewConfiguration = ViewConfiguration.get(getContext());
        this.f2352u = viewConfiguration.getScaledTouchSlop();
        this.f2353v = viewConfiguration.getScaledMinimumFlingVelocity();
        this.f2354w = viewConfiguration.getScaledMaximumFlingVelocity();
    }

    private void C() {
        if (this.f2349r == null) {
            this.f2349r = VelocityTracker.obtain();
        }
    }

    private void D(int i10, int i11) {
        this.f2344m = i10;
        this.f2355x = i11;
        X(2, 0);
    }

    private boolean E(View view) {
        return !G(view, 0, getHeight());
    }

    private static boolean F(View view, View view2) {
        if (view == view2) {
            return true;
        }
        ViewParent parent = view.getParent();
        return (parent instanceof ViewGroup) && F((View) parent, view2);
    }

    private boolean G(View view, int i10, int i11) {
        view.getDrawingRect(this.f2340i);
        offsetDescendantRectToMyCoords(view, this.f2340i);
        return this.f2340i.bottom + i10 >= getScrollY() && this.f2340i.top - i10 <= getScrollY() + i11;
    }

    private void H(int i10, int i11, int[] iArr) {
        int scrollY = getScrollY();
        scrollBy(0, i10);
        int scrollY2 = getScrollY() - scrollY;
        if (iArr != null) {
            iArr[1] = iArr[1] + scrollY2;
        }
        this.E.e(0, scrollY2, 0, i10 - scrollY2, null, i11, iArr);
    }

    private void I(MotionEvent motionEvent) {
        int actionIndex = motionEvent.getActionIndex();
        if (motionEvent.getPointerId(actionIndex) == this.f2355x) {
            int i10 = actionIndex == 0 ? 1 : 0;
            this.f2344m = (int) motionEvent.getY(i10);
            this.f2355x = motionEvent.getPointerId(i10);
            VelocityTracker velocityTracker = this.f2349r;
            if (velocityTracker != null) {
                velocityTracker.clear();
            }
        }
    }

    private void L() {
        VelocityTracker velocityTracker = this.f2349r;
        if (velocityTracker != null) {
            velocityTracker.recycle();
            this.f2349r = null;
        }
    }

    private int M(int i10, float f10) {
        float d10;
        EdgeEffect edgeEffect;
        float width = f10 / getWidth();
        float height = i10 / getHeight();
        float f11 = 0.0f;
        if (androidx.core.widget.e.b(this.f2342k) != 0.0f) {
            d10 = -androidx.core.widget.e.d(this.f2342k, -height, width);
            if (androidx.core.widget.e.b(this.f2342k) == 0.0f) {
                edgeEffect = this.f2342k;
                edgeEffect.onRelease();
            }
            f11 = d10;
        } else if (androidx.core.widget.e.b(this.f2343l) != 0.0f) {
            d10 = androidx.core.widget.e.d(this.f2343l, height, 1.0f - width);
            if (androidx.core.widget.e.b(this.f2343l) == 0.0f) {
                edgeEffect = this.f2343l;
                edgeEffect.onRelease();
            }
            f11 = d10;
        }
        int round = Math.round(f11 * getHeight());
        if (round != 0) {
            invalidate();
        }
        return round;
    }

    private void N(boolean z9) {
        if (z9) {
            X(2, 1);
        } else {
            Z(1);
        }
        this.B = getScrollY();
        postInvalidateOnAnimation();
    }

    private boolean O(int i10, int i11, int i12) {
        int height = getHeight();
        int scrollY = getScrollY();
        int i13 = height + scrollY;
        boolean z9 = false;
        boolean z10 = i10 == 33;
        View u9 = u(z10, i11, i12);
        if (u9 == null) {
            u9 = this;
        }
        if (i11 < scrollY || i12 > i13) {
            P(z10 ? i11 - scrollY : i12 - i13, 0, 1, true);
            z9 = true;
        }
        if (u9 != findFocus()) {
            u9.requestFocus(i10);
        }
        return z9;
    }

    private int P(int i10, int i11, int i12, boolean z9) {
        int i13;
        int i14;
        EdgeEffect edgeEffect;
        VelocityTracker velocityTracker;
        if (i12 == 1) {
            X(2, i12);
        }
        boolean z10 = false;
        if (i(0, i10, this.f2357z, this.f2356y, i12)) {
            i13 = i10 - this.f2357z[1];
            i14 = this.f2356y[1] + 0;
        } else {
            i13 = i10;
            i14 = 0;
        }
        int scrollY = getScrollY();
        int scrollRange = getScrollRange();
        boolean z11 = d() && !z9;
        boolean z12 = J(0, i13, 0, scrollY, 0, scrollRange, 0, 0, true) && !y(i12);
        int scrollY2 = getScrollY() - scrollY;
        int[] iArr = this.f2357z;
        iArr[1] = 0;
        p(0, scrollY2, 0, i13 - scrollY2, this.f2356y, i12, iArr);
        int i15 = i14 + this.f2356y[1];
        int i16 = i13 - this.f2357z[1];
        int i17 = scrollY + i16;
        if (i17 < 0) {
            if (z11) {
                androidx.core.widget.e.d(this.f2342k, (-i16) / getHeight(), i11 / getWidth());
                if (!this.f2343l.isFinished()) {
                    edgeEffect = this.f2343l;
                    edgeEffect.onRelease();
                }
            }
        } else if (i17 > scrollRange && z11) {
            androidx.core.widget.e.d(this.f2343l, i16 / getHeight(), 1.0f - (i11 / getWidth()));
            if (!this.f2342k.isFinished()) {
                edgeEffect = this.f2342k;
                edgeEffect.onRelease();
            }
        }
        if (this.f2342k.isFinished() && this.f2343l.isFinished()) {
            z10 = z12;
        } else {
            postInvalidateOnAnimation();
        }
        if (z10 && i12 == 0 && (velocityTracker = this.f2349r) != null) {
            velocityTracker.clear();
        }
        if (i12 == 1) {
            Z(i12);
            this.f2342k.onRelease();
            this.f2343l.onRelease();
        }
        return i15;
    }

    private void Q(View view) {
        view.getDrawingRect(this.f2340i);
        offsetDescendantRectToMyCoords(view, this.f2340i);
        int g10 = g(this.f2340i);
        if (g10 != 0) {
            scrollBy(0, g10);
        }
    }

    private boolean R(Rect rect, boolean z9) {
        int g10 = g(rect);
        boolean z10 = g10 != 0;
        if (z10) {
            if (z9) {
                scrollBy(0, g10);
            } else {
                T(0, g10);
            }
        }
        return z10;
    }

    private boolean S(EdgeEffect edgeEffect, int i10) {
        if (i10 > 0) {
            return true;
        }
        return x(-i10) < androidx.core.widget.e.b(edgeEffect) * ((float) getHeight());
    }

    private void U(int i10, int i11, int i12, boolean z9) {
        if (getChildCount() == 0) {
            return;
        }
        if (AnimationUtils.currentAnimationTimeMillis() - this.f2339h > 250) {
            View childAt = getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) childAt.getLayoutParams();
            int scrollY = getScrollY();
            OverScroller overScroller = this.f2341j;
            int scrollX = getScrollX();
            overScroller.startScroll(scrollX, scrollY, 0, Math.max(0, Math.min(i11 + scrollY, Math.max(0, ((childAt.getHeight() + layoutParams.topMargin) + layoutParams.bottomMargin) - ((getHeight() - getPaddingTop()) - getPaddingBottom())))) - scrollY, i12);
            N(z9);
        } else {
            if (!this.f2341j.isFinished()) {
                a();
            }
            scrollBy(i10, i11);
        }
        this.f2339h = AnimationUtils.currentAnimationTimeMillis();
    }

    private boolean Y(MotionEvent motionEvent) {
        boolean z9;
        if (androidx.core.widget.e.b(this.f2342k) != 0.0f) {
            androidx.core.widget.e.d(this.f2342k, 0.0f, motionEvent.getX() / getWidth());
            z9 = true;
        } else {
            z9 = false;
        }
        if (androidx.core.widget.e.b(this.f2343l) != 0.0f) {
            androidx.core.widget.e.d(this.f2343l, 0.0f, 1.0f - (motionEvent.getX() / getWidth()));
            return true;
        }
        return z9;
    }

    private void a() {
        this.f2341j.abortAnimation();
        Z(1);
    }

    private boolean d() {
        int overScrollMode = getOverScrollMode();
        if (overScrollMode != 0) {
            return overScrollMode == 1 && getScrollRange() > 0;
        }
        return true;
    }

    private boolean e() {
        if (getChildCount() > 0) {
            View childAt = getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) childAt.getLayoutParams();
            return (childAt.getHeight() + layoutParams.topMargin) + layoutParams.bottomMargin > (getHeight() - getPaddingTop()) - getPaddingBottom();
        }
        return false;
    }

    private static int f(int i10, int i11, int i12) {
        if (i11 >= i12 || i10 < 0) {
            return 0;
        }
        return i11 + i10 > i12 ? i12 - i11 : i10;
    }

    private void q(int i10) {
        if (i10 != 0) {
            if (this.f2351t) {
                T(0, i10);
            } else {
                scrollBy(0, i10);
            }
        }
    }

    private boolean r(int i10) {
        EdgeEffect edgeEffect;
        if (androidx.core.widget.e.b(this.f2342k) != 0.0f) {
            if (S(this.f2342k, i10)) {
                edgeEffect = this.f2342k;
                edgeEffect.onAbsorb(i10);
            } else {
                i10 = -i10;
                v(i10);
            }
        } else if (androidx.core.widget.e.b(this.f2343l) == 0.0f) {
            return false;
        } else {
            i10 = -i10;
            if (S(this.f2343l, i10)) {
                edgeEffect = this.f2343l;
                edgeEffect.onAbsorb(i10);
            }
            v(i10);
        }
        return true;
    }

    private void s() {
        this.f2355x = -1;
        this.f2348q = false;
        L();
        Z(0);
        this.f2342k.onRelease();
        this.f2343l.onRelease();
    }

    private View u(boolean z9, int i10, int i11) {
        ArrayList<View> focusables = getFocusables(2);
        int size = focusables.size();
        View view = null;
        boolean z10 = false;
        for (int i12 = 0; i12 < size; i12++) {
            View view2 = focusables.get(i12);
            int top = view2.getTop();
            int bottom = view2.getBottom();
            if (i10 < bottom && top < i11) {
                boolean z11 = i10 < top && bottom < i11;
                if (view == null) {
                    view = view2;
                    z10 = z11;
                } else {
                    boolean z12 = (z9 && top < view.getTop()) || (!z9 && bottom > view.getBottom());
                    if (z10) {
                        if (z11) {
                            if (!z12) {
                            }
                            view = view2;
                        }
                    } else if (z11) {
                        view = view2;
                        z10 = true;
                    } else {
                        if (!z12) {
                        }
                        view = view2;
                    }
                }
            }
        }
        return view;
    }

    private float x(int i10) {
        double log = Math.log((Math.abs(i10) * 0.35f) / (this.f2338g * 0.015f));
        float f10 = J;
        return (float) (this.f2338g * 0.015f * Math.exp((f10 / (f10 - 1.0d)) * log));
    }

    private boolean z(int i10, int i11) {
        if (getChildCount() > 0) {
            int scrollY = getScrollY();
            View childAt = getChildAt(0);
            return i11 >= childAt.getTop() - scrollY && i11 < childAt.getBottom() - scrollY && i10 >= childAt.getLeft() && i10 < childAt.getRight();
        }
        return false;
    }

    /* JADX WARN: Removed duplicated region for block: B:38:0x0057  */
    /* JADX WARN: Removed duplicated region for block: B:40:0x005a  */
    /* JADX WARN: Removed duplicated region for block: B:44:0x0061  */
    /* JADX WARN: Removed duplicated region for block: B:49:0x0083 A[ADDED_TO_REGION] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    boolean J(int i10, int i11, int i12, int i13, int i14, int i15, int i16, int i17, boolean z9) {
        boolean z10;
        boolean z11;
        int overScrollMode = getOverScrollMode();
        boolean z12 = computeHorizontalScrollRange() > computeHorizontalScrollExtent();
        boolean z13 = computeVerticalScrollRange() > computeVerticalScrollExtent();
        boolean z14 = overScrollMode == 0 || (overScrollMode == 1 && z12);
        boolean z15 = overScrollMode == 0 || (overScrollMode == 1 && z13);
        int i18 = i12 + i10;
        int i19 = !z14 ? 0 : i16;
        int i20 = i13 + i11;
        int i21 = !z15 ? 0 : i17;
        int i22 = -i19;
        int i23 = i19 + i14;
        int i24 = -i21;
        int i25 = i21 + i15;
        if (i18 > i23) {
            i18 = i23;
        } else if (i18 >= i22) {
            z10 = false;
            if (i20 <= i25) {
                i20 = i25;
            } else if (i20 >= i24) {
                z11 = false;
                if (z11 && !y(1)) {
                    this.f2341j.springBack(i18, i20, 0, 0, 0, getScrollRange());
                }
                onOverScrolled(i18, i20, z10, z11);
                return !z10 || z11;
            } else {
                i20 = i24;
            }
            z11 = true;
            if (z11) {
                this.f2341j.springBack(i18, i20, 0, 0, 0, getScrollRange());
            }
            onOverScrolled(i18, i20, z10, z11);
            if (z10) {
            }
        } else {
            i18 = i22;
        }
        z10 = true;
        if (i20 <= i25) {
        }
        z11 = true;
        if (z11) {
        }
        onOverScrolled(i18, i20, z10, z11);
        if (z10) {
        }
    }

    public boolean K(int i10) {
        boolean z9 = i10 == 130;
        int height = getHeight();
        if (z9) {
            this.f2340i.top = getScrollY() + height;
            int childCount = getChildCount();
            if (childCount > 0) {
                View childAt = getChildAt(childCount - 1);
                int bottom = childAt.getBottom() + ((FrameLayout.LayoutParams) childAt.getLayoutParams()).bottomMargin + getPaddingBottom();
                Rect rect = this.f2340i;
                if (rect.top + height > bottom) {
                    rect.top = bottom - height;
                }
            }
        } else {
            this.f2340i.top = getScrollY() - height;
            Rect rect2 = this.f2340i;
            if (rect2.top < 0) {
                rect2.top = 0;
            }
        }
        Rect rect3 = this.f2340i;
        int i11 = rect3.top;
        int i12 = height + i11;
        rect3.bottom = i12;
        return O(i10, i11, i12);
    }

    public final void T(int i10, int i11) {
        U(i10, i11, 250, false);
    }

    void V(int i10, int i11, int i12, boolean z9) {
        U(i10 - getScrollX(), i11 - getScrollY(), i12, z9);
    }

    void W(int i10, int i11, boolean z9) {
        V(i10, i11, 250, z9);
    }

    public boolean X(int i10, int i11) {
        return this.E.q(i10, i11);
    }

    public void Z(int i10) {
        this.E.s(i10);
    }

    @Override // android.view.ViewGroup
    public void addView(View view) {
        if (getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(view);
    }

    @Override // android.view.ViewGroup
    public void addView(View view, int i10) {
        if (getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(view, i10);
    }

    @Override // android.view.ViewGroup
    public void addView(View view, int i10, ViewGroup.LayoutParams layoutParams) {
        if (getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(view, i10, layoutParams);
    }

    @Override // android.view.ViewGroup, android.view.ViewManager
    public void addView(View view, ViewGroup.LayoutParams layoutParams) {
        if (getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(view, layoutParams);
    }

    public boolean c(int i10) {
        View findFocus = findFocus();
        if (findFocus == this) {
            findFocus = null;
        }
        View findNextFocus = FocusFinder.getInstance().findNextFocus(this, findFocus, i10);
        int maxScrollAmount = getMaxScrollAmount();
        if (findNextFocus == null || !G(findNextFocus, maxScrollAmount, getHeight())) {
            if (i10 == 33 && getScrollY() < maxScrollAmount) {
                maxScrollAmount = getScrollY();
            } else if (i10 == 130 && getChildCount() > 0) {
                View childAt = getChildAt(0);
                maxScrollAmount = Math.min((childAt.getBottom() + ((FrameLayout.LayoutParams) childAt.getLayoutParams()).bottomMargin) - ((getScrollY() + getHeight()) - getPaddingBottom()), maxScrollAmount);
            }
            if (maxScrollAmount == 0) {
                return false;
            }
            if (i10 != 130) {
                maxScrollAmount = -maxScrollAmount;
            }
            P(maxScrollAmount, 0, 1, true);
        } else {
            findNextFocus.getDrawingRect(this.f2340i);
            offsetDescendantRectToMyCoords(findNextFocus, this.f2340i);
            P(g(this.f2340i), 0, 1, true);
            findNextFocus.requestFocus(i10);
        }
        if (findFocus != null && findFocus.isFocused() && E(findFocus)) {
            int descendantFocusability = getDescendantFocusability();
            setDescendantFocusability(131072);
            requestFocus();
            setDescendantFocusability(descendantFocusability);
        }
        return true;
    }

    @Override // android.view.View
    public int computeHorizontalScrollExtent() {
        return super.computeHorizontalScrollExtent();
    }

    @Override // android.view.View
    public int computeHorizontalScrollOffset() {
        return super.computeHorizontalScrollOffset();
    }

    @Override // android.view.View
    public int computeHorizontalScrollRange() {
        return super.computeHorizontalScrollRange();
    }

    @Override // android.view.View
    public void computeScroll() {
        EdgeEffect edgeEffect;
        if (this.f2341j.isFinished()) {
            return;
        }
        this.f2341j.computeScrollOffset();
        int currY = this.f2341j.getCurrY();
        int h10 = h(currY - this.B);
        this.B = currY;
        int[] iArr = this.f2357z;
        boolean z9 = false;
        iArr[1] = 0;
        i(0, h10, iArr, null, 1);
        int i10 = h10 - this.f2357z[1];
        int scrollRange = getScrollRange();
        if (i10 != 0) {
            int scrollY = getScrollY();
            J(0, i10, getScrollX(), scrollY, 0, scrollRange, 0, 0, false);
            int scrollY2 = getScrollY() - scrollY;
            int i11 = i10 - scrollY2;
            int[] iArr2 = this.f2357z;
            iArr2[1] = 0;
            p(0, scrollY2, 0, i11, this.f2356y, 1, iArr2);
            i10 = i11 - this.f2357z[1];
        }
        if (i10 != 0) {
            int overScrollMode = getOverScrollMode();
            if (overScrollMode == 0 || (overScrollMode == 1 && scrollRange > 0)) {
                z9 = true;
            }
            if (z9) {
                if (i10 < 0) {
                    if (this.f2342k.isFinished()) {
                        edgeEffect = this.f2342k;
                        edgeEffect.onAbsorb((int) this.f2341j.getCurrVelocity());
                    }
                } else if (this.f2343l.isFinished()) {
                    edgeEffect = this.f2343l;
                    edgeEffect.onAbsorb((int) this.f2341j.getCurrVelocity());
                }
            }
            a();
        }
        if (this.f2341j.isFinished()) {
            Z(1);
        } else {
            postInvalidateOnAnimation();
        }
    }

    @Override // android.view.View
    public int computeVerticalScrollExtent() {
        return super.computeVerticalScrollExtent();
    }

    @Override // android.view.View
    public int computeVerticalScrollOffset() {
        return Math.max(0, super.computeVerticalScrollOffset());
    }

    @Override // android.view.View
    public int computeVerticalScrollRange() {
        int childCount = getChildCount();
        int height = (getHeight() - getPaddingBottom()) - getPaddingTop();
        if (childCount == 0) {
            return height;
        }
        View childAt = getChildAt(0);
        int bottom = childAt.getBottom() + ((FrameLayout.LayoutParams) childAt.getLayoutParams()).bottomMargin;
        int scrollY = getScrollY();
        int max = Math.max(0, bottom - height);
        return scrollY < 0 ? bottom - scrollY : scrollY > max ? bottom + (scrollY - max) : bottom;
    }

    @Override // android.view.ViewGroup, android.view.View
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return super.dispatchKeyEvent(keyEvent) || t(keyEvent);
    }

    @Override // android.view.View
    public boolean dispatchNestedFling(float f10, float f11, boolean z9) {
        return this.E.a(f10, f11, z9);
    }

    @Override // android.view.View
    public boolean dispatchNestedPreFling(float f10, float f11) {
        return this.E.b(f10, f11);
    }

    @Override // android.view.View
    public boolean dispatchNestedPreScroll(int i10, int i11, int[] iArr, int[] iArr2) {
        return i(i10, i11, iArr, iArr2, 0);
    }

    @Override // android.view.View
    public boolean dispatchNestedScroll(int i10, int i11, int i12, int i13, int[] iArr) {
        return this.E.f(i10, i11, i12, i13, iArr);
    }

    @Override // android.view.View
    public void draw(Canvas canvas) {
        int i10;
        super.draw(canvas);
        int scrollY = getScrollY();
        int i11 = 0;
        if (!this.f2342k.isFinished()) {
            int save = canvas.save();
            int width = getWidth();
            int height = getHeight();
            int min = Math.min(0, scrollY);
            if (b.a(this)) {
                width -= getPaddingLeft() + getPaddingRight();
                i10 = getPaddingLeft() + 0;
            } else {
                i10 = 0;
            }
            if (b.a(this)) {
                height -= getPaddingTop() + getPaddingBottom();
                min += getPaddingTop();
            }
            canvas.translate(i10, min);
            this.f2342k.setSize(width, height);
            if (this.f2342k.draw(canvas)) {
                postInvalidateOnAnimation();
            }
            canvas.restoreToCount(save);
        }
        if (this.f2343l.isFinished()) {
            return;
        }
        int save2 = canvas.save();
        int width2 = getWidth();
        int height2 = getHeight();
        int max = Math.max(getScrollRange(), scrollY) + height2;
        if (b.a(this)) {
            width2 -= getPaddingLeft() + getPaddingRight();
            i11 = 0 + getPaddingLeft();
        }
        if (b.a(this)) {
            height2 -= getPaddingTop() + getPaddingBottom();
            max -= getPaddingBottom();
        }
        canvas.translate(i11 - width2, max);
        canvas.rotate(180.0f, width2, 0.0f);
        this.f2343l.setSize(width2, height2);
        if (this.f2343l.draw(canvas)) {
            postInvalidateOnAnimation();
        }
        canvas.restoreToCount(save2);
    }

    protected int g(Rect rect) {
        if (getChildCount() == 0) {
            return 0;
        }
        int height = getHeight();
        int scrollY = getScrollY();
        int i10 = scrollY + height;
        int verticalFadingEdgeLength = getVerticalFadingEdgeLength();
        if (rect.top > 0) {
            scrollY += verticalFadingEdgeLength;
        }
        View childAt = getChildAt(0);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) childAt.getLayoutParams();
        int i11 = rect.bottom < (childAt.getHeight() + layoutParams.topMargin) + layoutParams.bottomMargin ? i10 - verticalFadingEdgeLength : i10;
        int i12 = rect.bottom;
        if (i12 > i11 && rect.top > scrollY) {
            return Math.min((rect.height() > height ? rect.top - scrollY : rect.bottom - i11) + 0, (childAt.getBottom() + layoutParams.bottomMargin) - i10);
        } else if (rect.top >= scrollY || i12 >= i11) {
            return 0;
        } else {
            return Math.max(rect.height() > height ? 0 - (i11 - rect.bottom) : 0 - (scrollY - rect.top), -getScrollY());
        }
    }

    @Override // android.view.View
    protected float getBottomFadingEdgeStrength() {
        if (getChildCount() == 0) {
            return 0.0f;
        }
        View childAt = getChildAt(0);
        int verticalFadingEdgeLength = getVerticalFadingEdgeLength();
        int bottom = ((childAt.getBottom() + ((FrameLayout.LayoutParams) childAt.getLayoutParams()).bottomMargin) - getScrollY()) - (getHeight() - getPaddingBottom());
        if (bottom < verticalFadingEdgeLength) {
            return bottom / verticalFadingEdgeLength;
        }
        return 1.0f;
    }

    public int getMaxScrollAmount() {
        return (int) (getHeight() * 0.5f);
    }

    @Override // android.view.ViewGroup
    public int getNestedScrollAxes() {
        return this.D.a();
    }

    int getScrollRange() {
        if (getChildCount() > 0) {
            View childAt = getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) childAt.getLayoutParams();
            return Math.max(0, ((childAt.getHeight() + layoutParams.topMargin) + layoutParams.bottomMargin) - ((getHeight() - getPaddingTop()) - getPaddingBottom()));
        }
        return 0;
    }

    @Override // android.view.View
    protected float getTopFadingEdgeStrength() {
        if (getChildCount() == 0) {
            return 0.0f;
        }
        int verticalFadingEdgeLength = getVerticalFadingEdgeLength();
        int scrollY = getScrollY();
        if (scrollY < verticalFadingEdgeLength) {
            return scrollY / verticalFadingEdgeLength;
        }
        return 1.0f;
    }

    float getVerticalScrollFactorCompat() {
        if (this.F == 0.0f) {
            TypedValue typedValue = new TypedValue();
            Context context = getContext();
            if (!context.getTheme().resolveAttribute(16842829, typedValue, true)) {
                throw new IllegalStateException("Expected theme to define listPreferredItemHeight.");
            }
            this.F = typedValue.getDimension(context.getResources().getDisplayMetrics());
        }
        return this.F;
    }

    int h(int i10) {
        int height = getHeight();
        if (i10 > 0 && androidx.core.widget.e.b(this.f2342k) != 0.0f) {
            int round = Math.round(((-height) / 4.0f) * androidx.core.widget.e.d(this.f2342k, ((-i10) * 4.0f) / height, 0.5f));
            if (round != i10) {
                this.f2342k.finish();
            }
            return i10 - round;
        } else if (i10 >= 0 || androidx.core.widget.e.b(this.f2343l) == 0.0f) {
            return i10;
        } else {
            float f10 = height;
            int round2 = Math.round((f10 / 4.0f) * androidx.core.widget.e.d(this.f2343l, (i10 * 4.0f) / f10, 0.5f));
            if (round2 != i10) {
                this.f2343l.finish();
            }
            return i10 - round2;
        }
    }

    @Override // android.view.View
    public boolean hasNestedScrollingParent() {
        return y(0);
    }

    public boolean i(int i10, int i11, int[] iArr, int[] iArr2, int i12) {
        return this.E.d(i10, i11, iArr, iArr2, i12);
    }

    @Override // android.view.View
    public boolean isNestedScrollingEnabled() {
        return this.E.m();
    }

    @Override // androidx.core.view.h0
    public void j(View view, int i10, int i11, int i12, int i13, int i14, int[] iArr) {
        H(i13, i14, iArr);
    }

    @Override // androidx.core.view.g0
    public void k(View view, int i10, int i11, int i12, int i13, int i14) {
        H(i13, i14, null);
    }

    @Override // androidx.core.view.g0
    public boolean l(View view, View view2, int i10, int i11) {
        return (i10 & 2) != 0;
    }

    @Override // androidx.core.view.g0
    public void m(View view, View view2, int i10, int i11) {
        this.D.c(view, view2, i10, i11);
        X(2, i11);
    }

    @Override // android.view.ViewGroup
    protected void measureChild(View view, int i10, int i11) {
        view.measure(ViewGroup.getChildMeasureSpec(i10, getPaddingLeft() + getPaddingRight(), view.getLayoutParams().width), View.MeasureSpec.makeMeasureSpec(0, 0));
    }

    @Override // android.view.ViewGroup
    protected void measureChildWithMargins(View view, int i10, int i11, int i12, int i13) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) view.getLayoutParams();
        view.measure(ViewGroup.getChildMeasureSpec(i10, getPaddingLeft() + getPaddingRight() + marginLayoutParams.leftMargin + marginLayoutParams.rightMargin + i11, marginLayoutParams.width), View.MeasureSpec.makeMeasureSpec(marginLayoutParams.topMargin + marginLayoutParams.bottomMargin, 0));
    }

    @Override // androidx.core.view.g0
    public void n(View view, int i10) {
        this.D.d(view, i10);
        Z(i10);
    }

    @Override // androidx.core.view.g0
    public void o(View view, int i10, int i11, int[] iArr, int i12) {
        i(i10, i11, iArr, null, i12);
    }

    @Override // android.view.ViewGroup, android.view.View
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.f2346o = false;
    }

    @Override // android.view.View
    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        float f10;
        int i10;
        if (motionEvent.getAction() == 8 && !this.f2348q) {
            int i11 = 26;
            if (e0.a(motionEvent, 2)) {
                f10 = motionEvent.getAxisValue(9);
                i10 = (int) motionEvent.getX();
                i11 = 9;
            } else if (e0.a(motionEvent, 4194304)) {
                float axisValue = motionEvent.getAxisValue(26);
                i10 = getWidth() / 2;
                f10 = axisValue;
            } else {
                f10 = 0.0f;
                i10 = 0;
                i11 = 0;
            }
            if (f10 != 0.0f) {
                P(-((int) (f10 * getVerticalScrollFactorCompat())), i10, 1, e0.a(motionEvent, 8194));
                if (i11 != 0) {
                    this.I.g(motionEvent, i11);
                }
                return true;
            }
        }
        return false;
    }

    @Override // android.view.ViewGroup
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int action = motionEvent.getAction();
        boolean z9 = true;
        if (action == 2 && this.f2348q) {
            return true;
        }
        int i10 = action & 255;
        if (i10 != 0) {
            if (i10 != 1) {
                if (i10 == 2) {
                    int i11 = this.f2355x;
                    if (i11 != -1) {
                        int findPointerIndex = motionEvent.findPointerIndex(i11);
                        if (findPointerIndex == -1) {
                            Log.e("NestedScrollView", "Invalid pointerId=" + i11 + " in onInterceptTouchEvent");
                        } else {
                            int y9 = (int) motionEvent.getY(findPointerIndex);
                            if (Math.abs(y9 - this.f2344m) > this.f2352u && (2 & getNestedScrollAxes()) == 0) {
                                this.f2348q = true;
                                this.f2344m = y9;
                                C();
                                this.f2349r.addMovement(motionEvent);
                                this.A = 0;
                                ViewParent parent = getParent();
                                if (parent != null) {
                                    parent.requestDisallowInterceptTouchEvent(true);
                                }
                            }
                        }
                    }
                } else if (i10 != 3) {
                    if (i10 == 6) {
                        I(motionEvent);
                    }
                }
            }
            this.f2348q = false;
            this.f2355x = -1;
            L();
            if (this.f2341j.springBack(getScrollX(), getScrollY(), 0, 0, 0, getScrollRange())) {
                postInvalidateOnAnimation();
            }
            Z(0);
        } else {
            int y10 = (int) motionEvent.getY();
            if (z((int) motionEvent.getX(), y10)) {
                this.f2344m = y10;
                this.f2355x = motionEvent.getPointerId(0);
                A();
                this.f2349r.addMovement(motionEvent);
                this.f2341j.computeScrollOffset();
                if (!Y(motionEvent) && this.f2341j.isFinished()) {
                    z9 = false;
                }
                this.f2348q = z9;
                X(2, 0);
            } else {
                if (!Y(motionEvent) && this.f2341j.isFinished()) {
                    z9 = false;
                }
                this.f2348q = z9;
                L();
            }
        }
        return this.f2348q;
    }

    @Override // android.widget.FrameLayout, android.view.ViewGroup, android.view.View
    protected void onLayout(boolean z9, int i10, int i11, int i12, int i13) {
        super.onLayout(z9, i10, i11, i12, i13);
        int i14 = 0;
        this.f2345n = false;
        View view = this.f2347p;
        if (view != null && F(view, this)) {
            Q(this.f2347p);
        }
        this.f2347p = null;
        if (!this.f2346o) {
            if (this.C != null) {
                scrollTo(getScrollX(), this.C.f2359g);
                this.C = null;
            }
            if (getChildCount() > 0) {
                View childAt = getChildAt(0);
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) childAt.getLayoutParams();
                i14 = childAt.getMeasuredHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
            }
            int paddingTop = ((i13 - i11) - getPaddingTop()) - getPaddingBottom();
            int scrollY = getScrollY();
            int f10 = f(scrollY, paddingTop, i14);
            if (f10 != scrollY) {
                scrollTo(getScrollX(), f10);
            }
        }
        scrollTo(getScrollX(), getScrollY());
        this.f2346o = true;
    }

    @Override // android.widget.FrameLayout, android.view.View
    protected void onMeasure(int i10, int i11) {
        super.onMeasure(i10, i11);
        if (this.f2350s && View.MeasureSpec.getMode(i11) != 0 && getChildCount() > 0) {
            View childAt = getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) childAt.getLayoutParams();
            int measuredHeight = childAt.getMeasuredHeight();
            int measuredHeight2 = (((getMeasuredHeight() - getPaddingTop()) - getPaddingBottom()) - layoutParams.topMargin) - layoutParams.bottomMargin;
            if (measuredHeight < measuredHeight2) {
                childAt.measure(ViewGroup.getChildMeasureSpec(i10, getPaddingLeft() + getPaddingRight() + layoutParams.leftMargin + layoutParams.rightMargin, layoutParams.width), View.MeasureSpec.makeMeasureSpec(measuredHeight2, 1073741824));
            }
        }
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public boolean onNestedFling(View view, float f10, float f11, boolean z9) {
        if (z9) {
            return false;
        }
        dispatchNestedFling(0.0f, f11, true);
        v((int) f11);
        return true;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public boolean onNestedPreFling(View view, float f10, float f11) {
        return dispatchNestedPreFling(f10, f11);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public void onNestedPreScroll(View view, int i10, int i11, int[] iArr) {
        o(view, i10, i11, iArr, 0);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public void onNestedScroll(View view, int i10, int i11, int i12, int i13) {
        H(i13, 0, null);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public void onNestedScrollAccepted(View view, View view2, int i10) {
        m(view, view2, i10, 0);
    }

    @Override // android.view.View
    protected void onOverScrolled(int i10, int i11, boolean z9, boolean z10) {
        super.scrollTo(i10, i11);
    }

    @Override // android.view.ViewGroup
    protected boolean onRequestFocusInDescendants(int i10, Rect rect) {
        if (i10 == 2) {
            i10 = 130;
        } else if (i10 == 1) {
            i10 = 33;
        }
        FocusFinder focusFinder = FocusFinder.getInstance();
        View findNextFocus = rect == null ? focusFinder.findNextFocus(this, null, i10) : focusFinder.findNextFocusFromRect(this, rect, i10);
        if (findNextFocus == null || E(findNextFocus)) {
            return false;
        }
        return findNextFocus.requestFocus(i10, rect);
    }

    @Override // android.view.View
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof e)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        e eVar = (e) parcelable;
        super.onRestoreInstanceState(eVar.getSuperState());
        this.C = eVar;
        requestLayout();
    }

    @Override // android.view.View
    protected Parcelable onSaveInstanceState() {
        e eVar = new e(super.onSaveInstanceState());
        eVar.f2359g = getScrollY();
        return eVar;
    }

    @Override // android.view.View
    protected void onScrollChanged(int i10, int i11, int i12, int i13) {
        super.onScrollChanged(i10, i11, i12, i13);
        d dVar = this.G;
        if (dVar != null) {
            dVar.a(this, i10, i11, i12, i13);
        }
    }

    @Override // android.view.View
    protected void onSizeChanged(int i10, int i11, int i12, int i13) {
        super.onSizeChanged(i10, i11, i12, i13);
        View findFocus = findFocus();
        if (findFocus == null || this == findFocus || !G(findFocus, 0, i13)) {
            return;
        }
        findFocus.getDrawingRect(this.f2340i);
        offsetDescendantRectToMyCoords(findFocus, this.f2340i);
        q(g(this.f2340i));
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public boolean onStartNestedScroll(View view, View view2, int i10) {
        return l(view, view2, i10, 0);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public void onStopNestedScroll(View view) {
        n(view, 0);
    }

    /* JADX WARN: Code restructure failed: missing block: B:24:0x006e, code lost:
        if (r12.f2341j.springBack(getScrollX(), getScrollY(), 0, 0, 0, getScrollRange()) != false) goto L29;
     */
    /* JADX WARN: Code restructure failed: missing block: B:25:0x0070, code lost:
        postInvalidateOnAnimation();
     */
    /* JADX WARN: Code restructure failed: missing block: B:52:0x012a, code lost:
        if (r12.f2341j.springBack(getScrollX(), getScrollY(), 0, 0, 0, getScrollRange()) != false) goto L29;
     */
    @Override // android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        ViewParent parent;
        C();
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 0) {
            this.A = 0;
        }
        MotionEvent obtain = MotionEvent.obtain(motionEvent);
        obtain.offsetLocation(0.0f, this.A);
        if (actionMasked != 0) {
            if (actionMasked == 1) {
                VelocityTracker velocityTracker = this.f2349r;
                velocityTracker.computeCurrentVelocity(1000, this.f2354w);
                int yVelocity = (int) velocityTracker.getYVelocity(this.f2355x);
                if (Math.abs(yVelocity) >= this.f2353v) {
                    if (!r(yVelocity)) {
                        int i10 = -yVelocity;
                        float f10 = i10;
                        if (!dispatchNestedPreFling(0.0f, f10)) {
                            dispatchNestedFling(0.0f, f10, true);
                            v(i10);
                        }
                    }
                }
                s();
            } else if (actionMasked == 2) {
                int findPointerIndex = motionEvent.findPointerIndex(this.f2355x);
                if (findPointerIndex == -1) {
                    Log.e("NestedScrollView", "Invalid pointerId=" + this.f2355x + " in onTouchEvent");
                } else {
                    int y9 = (int) motionEvent.getY(findPointerIndex);
                    int i11 = this.f2344m - y9;
                    int M = i11 - M(i11, motionEvent.getX(findPointerIndex));
                    if (!this.f2348q && Math.abs(M) > this.f2352u) {
                        ViewParent parent2 = getParent();
                        if (parent2 != null) {
                            parent2.requestDisallowInterceptTouchEvent(true);
                        }
                        this.f2348q = true;
                        int i12 = this.f2352u;
                        M = M > 0 ? M - i12 : M + i12;
                    }
                    if (this.f2348q) {
                        int P = P(M, (int) motionEvent.getX(findPointerIndex), 0, false);
                        this.f2344m = y9 - P;
                        this.A += P;
                    }
                }
            } else if (actionMasked == 3) {
                if (this.f2348q) {
                    if (getChildCount() > 0) {
                    }
                }
                s();
            } else if (actionMasked == 5) {
                int actionIndex = motionEvent.getActionIndex();
                this.f2344m = (int) motionEvent.getY(actionIndex);
                this.f2355x = motionEvent.getPointerId(actionIndex);
            } else if (actionMasked == 6) {
                I(motionEvent);
                this.f2344m = (int) motionEvent.getY(motionEvent.findPointerIndex(this.f2355x));
            }
        } else if (getChildCount() == 0) {
            return false;
        } else {
            if (this.f2348q && (parent = getParent()) != null) {
                parent.requestDisallowInterceptTouchEvent(true);
            }
            if (!this.f2341j.isFinished()) {
                a();
            }
            D((int) motionEvent.getY(), motionEvent.getPointerId(0));
        }
        VelocityTracker velocityTracker2 = this.f2349r;
        if (velocityTracker2 != null) {
            velocityTracker2.addMovement(obtain);
        }
        obtain.recycle();
        return true;
    }

    public void p(int i10, int i11, int i12, int i13, int[] iArr, int i14, int[] iArr2) {
        this.E.e(i10, i11, i12, i13, iArr, i14, iArr2);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public void requestChildFocus(View view, View view2) {
        if (this.f2345n) {
            this.f2347p = view2;
        } else {
            Q(view2);
        }
        super.requestChildFocus(view, view2);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean z9) {
        rect.offset(view.getLeft() - view.getScrollX(), view.getTop() - view.getScrollY());
        return R(rect, z9);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public void requestDisallowInterceptTouchEvent(boolean z9) {
        if (z9) {
            L();
        }
        super.requestDisallowInterceptTouchEvent(z9);
    }

    @Override // android.view.View, android.view.ViewParent
    public void requestLayout() {
        this.f2345n = true;
        super.requestLayout();
    }

    @Override // android.view.View
    public void scrollTo(int i10, int i11) {
        if (getChildCount() > 0) {
            View childAt = getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) childAt.getLayoutParams();
            int f10 = f(i10, (getWidth() - getPaddingLeft()) - getPaddingRight(), childAt.getWidth() + layoutParams.leftMargin + layoutParams.rightMargin);
            int f11 = f(i11, (getHeight() - getPaddingTop()) - getPaddingBottom(), childAt.getHeight() + layoutParams.topMargin + layoutParams.bottomMargin);
            if (f10 == getScrollX() && f11 == getScrollY()) {
                return;
            }
            super.scrollTo(f10, f11);
        }
    }

    public void setFillViewport(boolean z9) {
        if (z9 != this.f2350s) {
            this.f2350s = z9;
            requestLayout();
        }
    }

    @Override // android.view.View
    public void setNestedScrollingEnabled(boolean z9) {
        this.E.n(z9);
    }

    public void setOnScrollChangeListener(d dVar) {
        this.G = dVar;
    }

    public void setSmoothScrollingEnabled(boolean z9) {
        this.f2351t = z9;
    }

    @Override // android.widget.FrameLayout, android.view.ViewGroup
    public boolean shouldDelayChildPressedState() {
        return true;
    }

    @Override // android.view.View
    public boolean startNestedScroll(int i10) {
        return X(i10, 0);
    }

    @Override // android.view.View
    public void stopNestedScroll() {
        Z(0);
    }

    public boolean t(KeyEvent keyEvent) {
        this.f2340i.setEmpty();
        int i10 = 130;
        if (!e()) {
            if (!isFocused() || keyEvent.getKeyCode() == 4) {
                return false;
            }
            View findFocus = findFocus();
            if (findFocus == this) {
                findFocus = null;
            }
            View findNextFocus = FocusFinder.getInstance().findNextFocus(this, findFocus, 130);
            return (findNextFocus == null || findNextFocus == this || !findNextFocus.requestFocus(130)) ? false : true;
        } else if (keyEvent.getAction() == 0) {
            int keyCode = keyEvent.getKeyCode();
            if (keyCode != 19) {
                if (keyCode != 20) {
                    if (keyCode != 62) {
                        if (keyCode != 92) {
                            if (keyCode != 93) {
                                if (keyCode == 122) {
                                    K(33);
                                    return false;
                                } else if (keyCode != 123) {
                                    return false;
                                }
                            }
                        }
                    } else if (keyEvent.isShiftPressed()) {
                        i10 = 33;
                    }
                    K(i10);
                    return false;
                } else if (!keyEvent.isAltPressed()) {
                    return c(130);
                }
                return w(130);
            } else if (!keyEvent.isAltPressed()) {
                return c(33);
            }
            return w(33);
        } else {
            return false;
        }
    }

    public void v(int i10) {
        if (getChildCount() > 0) {
            this.f2341j.fling(getScrollX(), getScrollY(), 0, i10, 0, 0, RecyclerView.UNDEFINED_DURATION, Integer.MAX_VALUE, 0, 0);
            N(true);
        }
    }

    public boolean w(int i10) {
        int childCount;
        boolean z9 = i10 == 130;
        int height = getHeight();
        Rect rect = this.f2340i;
        rect.top = 0;
        rect.bottom = height;
        if (z9 && (childCount = getChildCount()) > 0) {
            View childAt = getChildAt(childCount - 1);
            this.f2340i.bottom = childAt.getBottom() + ((FrameLayout.LayoutParams) childAt.getLayoutParams()).bottomMargin + getPaddingBottom();
            Rect rect2 = this.f2340i;
            rect2.top = rect2.bottom - height;
        }
        Rect rect3 = this.f2340i;
        return O(i10, rect3.top, rect3.bottom);
    }

    public boolean y(int i10) {
        return this.E.l(i10);
    }
}
