package androidx.core.view;

import android.annotation.SuppressLint;
import android.graphics.Insets;
import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.DisplayCutout;
import android.view.View;
import android.view.WindowInsets;
import android.view.WindowInsets$Builder;
import android.view.WindowInsets$Type;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
/* loaded from: classes.dex */
public class y2 {

    /* renamed from: b  reason: collision with root package name */
    public static final y2 f2305b;

    /* renamed from: a  reason: collision with root package name */
    private final l f2306a;

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class a {

        /* renamed from: a  reason: collision with root package name */
        private static Field f2307a;

        /* renamed from: b  reason: collision with root package name */
        private static Field f2308b;

        /* renamed from: c  reason: collision with root package name */
        private static Field f2309c;

        /* renamed from: d  reason: collision with root package name */
        private static boolean f2310d;

        static {
            try {
                Field declaredField = View.class.getDeclaredField("mAttachInfo");
                f2307a = declaredField;
                declaredField.setAccessible(true);
                Class<?> cls = Class.forName("android.view.View$AttachInfo");
                Field declaredField2 = cls.getDeclaredField("mStableInsets");
                f2308b = declaredField2;
                declaredField2.setAccessible(true);
                Field declaredField3 = cls.getDeclaredField("mContentInsets");
                f2309c = declaredField3;
                declaredField3.setAccessible(true);
                f2310d = true;
            } catch (ReflectiveOperationException e10) {
                Log.w("WindowInsetsCompat", "Failed to get visible insets from AttachInfo " + e10.getMessage(), e10);
            }
        }

        public static y2 a(View view) {
            if (f2310d && view.isAttachedToWindow()) {
                try {
                    Object obj = f2307a.get(view.getRootView());
                    if (obj != null) {
                        Rect rect = (Rect) f2308b.get(obj);
                        Rect rect2 = (Rect) f2309c.get(obj);
                        if (rect != null && rect2 != null) {
                            y2 a10 = new b().b(androidx.core.graphics.b.c(rect)).c(androidx.core.graphics.b.c(rect2)).a();
                            a10.r(a10);
                            a10.d(view.getRootView());
                            return a10;
                        }
                    }
                } catch (IllegalAccessException e10) {
                    Log.w("WindowInsetsCompat", "Failed to get insets from AttachInfo. " + e10.getMessage(), e10);
                }
            }
            return null;
        }
    }

    /* loaded from: classes.dex */
    public static final class b {

        /* renamed from: a  reason: collision with root package name */
        private final f f2311a;

        public b() {
            int i10 = Build.VERSION.SDK_INT;
            this.f2311a = i10 >= 30 ? new e() : i10 >= 29 ? new d() : new c();
        }

        public b(y2 y2Var) {
            int i10 = Build.VERSION.SDK_INT;
            this.f2311a = i10 >= 30 ? new e(y2Var) : i10 >= 29 ? new d(y2Var) : new c(y2Var);
        }

        public y2 a() {
            return this.f2311a.b();
        }

        public b b(androidx.core.graphics.b bVar) {
            this.f2311a.d(bVar);
            return this;
        }

        public b c(androidx.core.graphics.b bVar) {
            this.f2311a.f(bVar);
            return this;
        }
    }

    /* loaded from: classes.dex */
    private static class c extends f {

        /* renamed from: e  reason: collision with root package name */
        private static Field f2312e = null;

        /* renamed from: f  reason: collision with root package name */
        private static boolean f2313f = false;

        /* renamed from: g  reason: collision with root package name */
        private static Constructor f2314g = null;

        /* renamed from: h  reason: collision with root package name */
        private static boolean f2315h = false;

        /* renamed from: c  reason: collision with root package name */
        private WindowInsets f2316c;

        /* renamed from: d  reason: collision with root package name */
        private androidx.core.graphics.b f2317d;

        c() {
            this.f2316c = h();
        }

        c(y2 y2Var) {
            super(y2Var);
            this.f2316c = y2Var.t();
        }

        private static WindowInsets h() {
            if (!f2313f) {
                try {
                    f2312e = WindowInsets.class.getDeclaredField("CONSUMED");
                } catch (ReflectiveOperationException e10) {
                    Log.i("WindowInsetsCompat", "Could not retrieve WindowInsets.CONSUMED field", e10);
                }
                f2313f = true;
            }
            Field field = f2312e;
            if (field != null) {
                try {
                    WindowInsets windowInsets = (WindowInsets) field.get(null);
                    if (windowInsets != null) {
                        return new WindowInsets(windowInsets);
                    }
                } catch (ReflectiveOperationException e11) {
                    Log.i("WindowInsetsCompat", "Could not get value from WindowInsets.CONSUMED field", e11);
                }
            }
            if (!f2315h) {
                try {
                    f2314g = WindowInsets.class.getConstructor(Rect.class);
                } catch (ReflectiveOperationException e12) {
                    Log.i("WindowInsetsCompat", "Could not retrieve WindowInsets(Rect) constructor", e12);
                }
                f2315h = true;
            }
            Constructor constructor = f2314g;
            if (constructor != null) {
                try {
                    return (WindowInsets) constructor.newInstance(new Rect());
                } catch (ReflectiveOperationException e13) {
                    Log.i("WindowInsetsCompat", "Could not invoke WindowInsets(Rect) constructor", e13);
                }
            }
            return null;
        }

        @Override // androidx.core.view.y2.f
        y2 b() {
            a();
            y2 u9 = y2.u(this.f2316c);
            u9.p(this.f2320b);
            u9.s(this.f2317d);
            return u9;
        }

        @Override // androidx.core.view.y2.f
        void d(androidx.core.graphics.b bVar) {
            this.f2317d = bVar;
        }

        @Override // androidx.core.view.y2.f
        void f(androidx.core.graphics.b bVar) {
            WindowInsets windowInsets = this.f2316c;
            if (windowInsets != null) {
                this.f2316c = windowInsets.replaceSystemWindowInsets(bVar.f2079a, bVar.f2080b, bVar.f2081c, bVar.f2082d);
            }
        }
    }

    /* loaded from: classes.dex */
    private static class d extends f {

        /* renamed from: c  reason: collision with root package name */
        final WindowInsets$Builder f2318c;

        d() {
            this.f2318c = new WindowInsets$Builder();
        }

        d(y2 y2Var) {
            super(y2Var);
            WindowInsets t9 = y2Var.t();
            this.f2318c = t9 != null ? new WindowInsets$Builder(t9) : new WindowInsets$Builder();
        }

        @Override // androidx.core.view.y2.f
        y2 b() {
            a();
            y2 u9 = y2.u(this.f2318c.build());
            u9.p(this.f2320b);
            return u9;
        }

        @Override // androidx.core.view.y2.f
        void c(androidx.core.graphics.b bVar) {
            this.f2318c.setMandatorySystemGestureInsets(bVar.e());
        }

        @Override // androidx.core.view.y2.f
        void d(androidx.core.graphics.b bVar) {
            this.f2318c.setStableInsets(bVar.e());
        }

        @Override // androidx.core.view.y2.f
        void e(androidx.core.graphics.b bVar) {
            this.f2318c.setSystemGestureInsets(bVar.e());
        }

        @Override // androidx.core.view.y2.f
        void f(androidx.core.graphics.b bVar) {
            this.f2318c.setSystemWindowInsets(bVar.e());
        }

        @Override // androidx.core.view.y2.f
        void g(androidx.core.graphics.b bVar) {
            this.f2318c.setTappableElementInsets(bVar.e());
        }
    }

    /* loaded from: classes.dex */
    private static class e extends d {
        e() {
        }

        e(y2 y2Var) {
            super(y2Var);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class f {

        /* renamed from: a  reason: collision with root package name */
        private final y2 f2319a;

        /* renamed from: b  reason: collision with root package name */
        androidx.core.graphics.b[] f2320b;

        f() {
            this(new y2((y2) null));
        }

        f(y2 y2Var) {
            this.f2319a = y2Var;
        }

        protected final void a() {
            androidx.core.graphics.b[] bVarArr = this.f2320b;
            if (bVarArr != null) {
                androidx.core.graphics.b bVar = bVarArr[m.a(1)];
                androidx.core.graphics.b bVar2 = this.f2320b[m.a(2)];
                if (bVar2 == null) {
                    bVar2 = this.f2319a.f(2);
                }
                if (bVar == null) {
                    bVar = this.f2319a.f(1);
                }
                f(androidx.core.graphics.b.a(bVar, bVar2));
                androidx.core.graphics.b bVar3 = this.f2320b[m.a(16)];
                if (bVar3 != null) {
                    e(bVar3);
                }
                androidx.core.graphics.b bVar4 = this.f2320b[m.a(32)];
                if (bVar4 != null) {
                    c(bVar4);
                }
                androidx.core.graphics.b bVar5 = this.f2320b[m.a(64)];
                if (bVar5 != null) {
                    g(bVar5);
                }
            }
        }

        abstract y2 b();

        void c(androidx.core.graphics.b bVar) {
        }

        abstract void d(androidx.core.graphics.b bVar);

        void e(androidx.core.graphics.b bVar) {
        }

        abstract void f(androidx.core.graphics.b bVar);

        void g(androidx.core.graphics.b bVar) {
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class g extends l {

        /* renamed from: h  reason: collision with root package name */
        private static boolean f2321h = false;

        /* renamed from: i  reason: collision with root package name */
        private static Method f2322i;

        /* renamed from: j  reason: collision with root package name */
        private static Class f2323j;

        /* renamed from: k  reason: collision with root package name */
        private static Field f2324k;

        /* renamed from: l  reason: collision with root package name */
        private static Field f2325l;

        /* renamed from: c  reason: collision with root package name */
        final WindowInsets f2326c;

        /* renamed from: d  reason: collision with root package name */
        private androidx.core.graphics.b[] f2327d;

        /* renamed from: e  reason: collision with root package name */
        private androidx.core.graphics.b f2328e;

        /* renamed from: f  reason: collision with root package name */
        private y2 f2329f;

        /* renamed from: g  reason: collision with root package name */
        androidx.core.graphics.b f2330g;

        g(y2 y2Var, WindowInsets windowInsets) {
            super(y2Var);
            this.f2328e = null;
            this.f2326c = windowInsets;
        }

        g(y2 y2Var, g gVar) {
            this(y2Var, new WindowInsets(gVar.f2326c));
        }

        @SuppressLint({"WrongConstant"})
        private androidx.core.graphics.b t(int i10, boolean z9) {
            androidx.core.graphics.b bVar = androidx.core.graphics.b.f2078e;
            for (int i11 = 1; i11 <= 256; i11 <<= 1) {
                if ((i10 & i11) != 0) {
                    bVar = androidx.core.graphics.b.a(bVar, u(i11, z9));
                }
            }
            return bVar;
        }

        private androidx.core.graphics.b v() {
            y2 y2Var = this.f2329f;
            return y2Var != null ? y2Var.g() : androidx.core.graphics.b.f2078e;
        }

        private androidx.core.graphics.b w(View view) {
            if (Build.VERSION.SDK_INT < 30) {
                if (!f2321h) {
                    x();
                }
                Method method = f2322i;
                if (method != null && f2323j != null && f2324k != null) {
                    try {
                        Object invoke = method.invoke(view, new Object[0]);
                        if (invoke == null) {
                            Log.w("WindowInsetsCompat", "Failed to get visible insets. getViewRootImpl() returned null from the provided view. This means that the view is either not attached or the method has been overridden", new NullPointerException());
                            return null;
                        }
                        Rect rect = (Rect) f2324k.get(f2325l.get(invoke));
                        if (rect != null) {
                            return androidx.core.graphics.b.c(rect);
                        }
                        return null;
                    } catch (ReflectiveOperationException e10) {
                        Log.e("WindowInsetsCompat", "Failed to get visible insets. (Reflection error). " + e10.getMessage(), e10);
                    }
                }
                return null;
            }
            throw new UnsupportedOperationException("getVisibleInsets() should not be called on API >= 30. Use WindowInsets.isVisible() instead.");
        }

        @SuppressLint({"PrivateApi"})
        private static void x() {
            try {
                f2322i = View.class.getDeclaredMethod("getViewRootImpl", new Class[0]);
                Class<?> cls = Class.forName("android.view.View$AttachInfo");
                f2323j = cls;
                f2324k = cls.getDeclaredField("mVisibleInsets");
                f2325l = Class.forName("android.view.ViewRootImpl").getDeclaredField("mAttachInfo");
                f2324k.setAccessible(true);
                f2325l.setAccessible(true);
            } catch (ReflectiveOperationException e10) {
                Log.e("WindowInsetsCompat", "Failed to get visible insets. (Reflection error). " + e10.getMessage(), e10);
            }
            f2321h = true;
        }

        @Override // androidx.core.view.y2.l
        void d(View view) {
            androidx.core.graphics.b w9 = w(view);
            if (w9 == null) {
                w9 = androidx.core.graphics.b.f2078e;
            }
            q(w9);
        }

        @Override // androidx.core.view.y2.l
        void e(y2 y2Var) {
            y2Var.r(this.f2329f);
            y2Var.q(this.f2330g);
        }

        @Override // androidx.core.view.y2.l
        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                return Objects.equals(this.f2330g, ((g) obj).f2330g);
            }
            return false;
        }

        @Override // androidx.core.view.y2.l
        public androidx.core.graphics.b g(int i10) {
            return t(i10, false);
        }

        @Override // androidx.core.view.y2.l
        final androidx.core.graphics.b k() {
            if (this.f2328e == null) {
                this.f2328e = androidx.core.graphics.b.b(this.f2326c.getSystemWindowInsetLeft(), this.f2326c.getSystemWindowInsetTop(), this.f2326c.getSystemWindowInsetRight(), this.f2326c.getSystemWindowInsetBottom());
            }
            return this.f2328e;
        }

        @Override // androidx.core.view.y2.l
        y2 m(int i10, int i11, int i12, int i13) {
            b bVar = new b(y2.u(this.f2326c));
            bVar.c(y2.m(k(), i10, i11, i12, i13));
            bVar.b(y2.m(i(), i10, i11, i12, i13));
            return bVar.a();
        }

        @Override // androidx.core.view.y2.l
        boolean o() {
            return this.f2326c.isRound();
        }

        @Override // androidx.core.view.y2.l
        public void p(androidx.core.graphics.b[] bVarArr) {
            this.f2327d = bVarArr;
        }

        @Override // androidx.core.view.y2.l
        void q(androidx.core.graphics.b bVar) {
            this.f2330g = bVar;
        }

        @Override // androidx.core.view.y2.l
        void r(y2 y2Var) {
            this.f2329f = y2Var;
        }

        protected androidx.core.graphics.b u(int i10, boolean z9) {
            androidx.core.graphics.b g10;
            int i11;
            if (i10 == 1) {
                return z9 ? androidx.core.graphics.b.b(0, Math.max(v().f2080b, k().f2080b), 0, 0) : androidx.core.graphics.b.b(0, k().f2080b, 0, 0);
            }
            if (i10 == 2) {
                if (z9) {
                    androidx.core.graphics.b v9 = v();
                    androidx.core.graphics.b i12 = i();
                    return androidx.core.graphics.b.b(Math.max(v9.f2079a, i12.f2079a), 0, Math.max(v9.f2081c, i12.f2081c), Math.max(v9.f2082d, i12.f2082d));
                }
                androidx.core.graphics.b k10 = k();
                y2 y2Var = this.f2329f;
                g10 = y2Var != null ? y2Var.g() : null;
                int i13 = k10.f2082d;
                if (g10 != null) {
                    i13 = Math.min(i13, g10.f2082d);
                }
                return androidx.core.graphics.b.b(k10.f2079a, 0, k10.f2081c, i13);
            } else if (i10 != 8) {
                if (i10 != 16) {
                    if (i10 != 32) {
                        if (i10 != 64) {
                            if (i10 != 128) {
                                return androidx.core.graphics.b.f2078e;
                            }
                            y2 y2Var2 = this.f2329f;
                            androidx.core.view.h e10 = y2Var2 != null ? y2Var2.e() : f();
                            return e10 != null ? androidx.core.graphics.b.b(e10.b(), e10.d(), e10.c(), e10.a()) : androidx.core.graphics.b.f2078e;
                        }
                        return l();
                    }
                    return h();
                }
                return j();
            } else {
                androidx.core.graphics.b[] bVarArr = this.f2327d;
                g10 = bVarArr != null ? bVarArr[m.a(8)] : null;
                if (g10 != null) {
                    return g10;
                }
                androidx.core.graphics.b k11 = k();
                androidx.core.graphics.b v10 = v();
                int i14 = k11.f2082d;
                if (i14 > v10.f2082d) {
                    return androidx.core.graphics.b.b(0, 0, 0, i14);
                }
                androidx.core.graphics.b bVar = this.f2330g;
                return (bVar == null || bVar.equals(androidx.core.graphics.b.f2078e) || (i11 = this.f2330g.f2082d) <= v10.f2082d) ? androidx.core.graphics.b.f2078e : androidx.core.graphics.b.b(0, 0, 0, i11);
            }
        }
    }

    /* loaded from: classes.dex */
    private static class h extends g {

        /* renamed from: m  reason: collision with root package name */
        private androidx.core.graphics.b f2331m;

        h(y2 y2Var, WindowInsets windowInsets) {
            super(y2Var, windowInsets);
            this.f2331m = null;
        }

        h(y2 y2Var, h hVar) {
            super(y2Var, hVar);
            this.f2331m = null;
            this.f2331m = hVar.f2331m;
        }

        @Override // androidx.core.view.y2.l
        y2 b() {
            return y2.u(this.f2326c.consumeStableInsets());
        }

        @Override // androidx.core.view.y2.l
        y2 c() {
            return y2.u(this.f2326c.consumeSystemWindowInsets());
        }

        @Override // androidx.core.view.y2.l
        final androidx.core.graphics.b i() {
            if (this.f2331m == null) {
                this.f2331m = androidx.core.graphics.b.b(this.f2326c.getStableInsetLeft(), this.f2326c.getStableInsetTop(), this.f2326c.getStableInsetRight(), this.f2326c.getStableInsetBottom());
            }
            return this.f2331m;
        }

        @Override // androidx.core.view.y2.l
        boolean n() {
            return this.f2326c.isConsumed();
        }

        @Override // androidx.core.view.y2.l
        public void s(androidx.core.graphics.b bVar) {
            this.f2331m = bVar;
        }
    }

    /* loaded from: classes.dex */
    private static class i extends h {
        i(y2 y2Var, WindowInsets windowInsets) {
            super(y2Var, windowInsets);
        }

        i(y2 y2Var, i iVar) {
            super(y2Var, iVar);
        }

        @Override // androidx.core.view.y2.l
        y2 a() {
            WindowInsets consumeDisplayCutout;
            consumeDisplayCutout = this.f2326c.consumeDisplayCutout();
            return y2.u(consumeDisplayCutout);
        }

        @Override // androidx.core.view.y2.g, androidx.core.view.y2.l
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof i) {
                i iVar = (i) obj;
                return Objects.equals(this.f2326c, iVar.f2326c) && Objects.equals(this.f2330g, iVar.f2330g);
            }
            return false;
        }

        @Override // androidx.core.view.y2.l
        androidx.core.view.h f() {
            DisplayCutout displayCutout;
            displayCutout = this.f2326c.getDisplayCutout();
            return androidx.core.view.h.e(displayCutout);
        }

        @Override // androidx.core.view.y2.l
        public int hashCode() {
            return this.f2326c.hashCode();
        }
    }

    /* loaded from: classes.dex */
    private static class j extends i {

        /* renamed from: n  reason: collision with root package name */
        private androidx.core.graphics.b f2332n;

        /* renamed from: o  reason: collision with root package name */
        private androidx.core.graphics.b f2333o;

        /* renamed from: p  reason: collision with root package name */
        private androidx.core.graphics.b f2334p;

        j(y2 y2Var, WindowInsets windowInsets) {
            super(y2Var, windowInsets);
            this.f2332n = null;
            this.f2333o = null;
            this.f2334p = null;
        }

        j(y2 y2Var, j jVar) {
            super(y2Var, jVar);
            this.f2332n = null;
            this.f2333o = null;
            this.f2334p = null;
        }

        @Override // androidx.core.view.y2.l
        androidx.core.graphics.b h() {
            Insets mandatorySystemGestureInsets;
            if (this.f2333o == null) {
                mandatorySystemGestureInsets = this.f2326c.getMandatorySystemGestureInsets();
                this.f2333o = androidx.core.graphics.b.d(mandatorySystemGestureInsets);
            }
            return this.f2333o;
        }

        @Override // androidx.core.view.y2.l
        androidx.core.graphics.b j() {
            Insets systemGestureInsets;
            if (this.f2332n == null) {
                systemGestureInsets = this.f2326c.getSystemGestureInsets();
                this.f2332n = androidx.core.graphics.b.d(systemGestureInsets);
            }
            return this.f2332n;
        }

        @Override // androidx.core.view.y2.l
        androidx.core.graphics.b l() {
            Insets tappableElementInsets;
            if (this.f2334p == null) {
                tappableElementInsets = this.f2326c.getTappableElementInsets();
                this.f2334p = androidx.core.graphics.b.d(tappableElementInsets);
            }
            return this.f2334p;
        }

        @Override // androidx.core.view.y2.g, androidx.core.view.y2.l
        y2 m(int i10, int i11, int i12, int i13) {
            WindowInsets inset;
            inset = this.f2326c.inset(i10, i11, i12, i13);
            return y2.u(inset);
        }

        @Override // androidx.core.view.y2.h, androidx.core.view.y2.l
        public void s(androidx.core.graphics.b bVar) {
        }
    }

    /* loaded from: classes.dex */
    private static class k extends j {

        /* renamed from: q  reason: collision with root package name */
        static final y2 f2335q = y2.u(WindowInsets.CONSUMED);

        k(y2 y2Var, WindowInsets windowInsets) {
            super(y2Var, windowInsets);
        }

        k(y2 y2Var, k kVar) {
            super(y2Var, kVar);
        }

        @Override // androidx.core.view.y2.g, androidx.core.view.y2.l
        final void d(View view) {
        }

        @Override // androidx.core.view.y2.g, androidx.core.view.y2.l
        public androidx.core.graphics.b g(int i10) {
            Insets insets;
            insets = this.f2326c.getInsets(n.a(i10));
            return androidx.core.graphics.b.d(insets);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class l {

        /* renamed from: b  reason: collision with root package name */
        static final y2 f2336b = new b().a().a().b().c();

        /* renamed from: a  reason: collision with root package name */
        final y2 f2337a;

        l(y2 y2Var) {
            this.f2337a = y2Var;
        }

        y2 a() {
            return this.f2337a;
        }

        y2 b() {
            return this.f2337a;
        }

        y2 c() {
            return this.f2337a;
        }

        void d(View view) {
        }

        void e(y2 y2Var) {
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof l) {
                l lVar = (l) obj;
                return o() == lVar.o() && n() == lVar.n() && v.c.a(k(), lVar.k()) && v.c.a(i(), lVar.i()) && v.c.a(f(), lVar.f());
            }
            return false;
        }

        androidx.core.view.h f() {
            return null;
        }

        androidx.core.graphics.b g(int i10) {
            return androidx.core.graphics.b.f2078e;
        }

        androidx.core.graphics.b h() {
            return k();
        }

        public int hashCode() {
            return v.c.b(Boolean.valueOf(o()), Boolean.valueOf(n()), k(), i(), f());
        }

        androidx.core.graphics.b i() {
            return androidx.core.graphics.b.f2078e;
        }

        androidx.core.graphics.b j() {
            return k();
        }

        androidx.core.graphics.b k() {
            return androidx.core.graphics.b.f2078e;
        }

        androidx.core.graphics.b l() {
            return k();
        }

        y2 m(int i10, int i11, int i12, int i13) {
            return f2336b;
        }

        boolean n() {
            return false;
        }

        boolean o() {
            return false;
        }

        public void p(androidx.core.graphics.b[] bVarArr) {
        }

        void q(androidx.core.graphics.b bVar) {
        }

        void r(y2 y2Var) {
        }

        public void s(androidx.core.graphics.b bVar) {
        }
    }

    /* loaded from: classes.dex */
    public static final class m {
        static int a(int i10) {
            if (i10 != 1) {
                if (i10 != 2) {
                    if (i10 != 4) {
                        if (i10 != 8) {
                            if (i10 != 16) {
                                if (i10 != 32) {
                                    if (i10 != 64) {
                                        if (i10 != 128) {
                                            if (i10 == 256) {
                                                return 8;
                                            }
                                            throw new IllegalArgumentException("type needs to be >= FIRST and <= LAST, type=" + i10);
                                        }
                                        return 7;
                                    }
                                    return 6;
                                }
                                return 5;
                            }
                            return 4;
                        }
                        return 3;
                    }
                    return 2;
                }
                return 1;
            }
            return 0;
        }
    }

    /* loaded from: classes.dex */
    private static final class n {
        static int a(int i10) {
            int statusBars;
            int i11 = 0;
            for (int i12 = 1; i12 <= 256; i12 <<= 1) {
                if ((i10 & i12) != 0) {
                    if (i12 == 1) {
                        statusBars = WindowInsets$Type.statusBars();
                    } else if (i12 == 2) {
                        statusBars = WindowInsets$Type.navigationBars();
                    } else if (i12 == 4) {
                        statusBars = WindowInsets$Type.captionBar();
                    } else if (i12 == 8) {
                        statusBars = WindowInsets$Type.ime();
                    } else if (i12 == 16) {
                        statusBars = WindowInsets$Type.systemGestures();
                    } else if (i12 == 32) {
                        statusBars = WindowInsets$Type.mandatorySystemGestures();
                    } else if (i12 == 64) {
                        statusBars = WindowInsets$Type.tappableElement();
                    } else if (i12 == 128) {
                        statusBars = WindowInsets$Type.displayCutout();
                    }
                    i11 |= statusBars;
                }
            }
            return i11;
        }
    }

    static {
        f2305b = Build.VERSION.SDK_INT >= 30 ? k.f2335q : l.f2336b;
    }

    private y2(WindowInsets windowInsets) {
        int i10 = Build.VERSION.SDK_INT;
        this.f2306a = i10 >= 30 ? new k(this, windowInsets) : i10 >= 29 ? new j(this, windowInsets) : i10 >= 28 ? new i(this, windowInsets) : new h(this, windowInsets);
    }

    public y2(y2 y2Var) {
        if (y2Var == null) {
            this.f2306a = new l(this);
            return;
        }
        l lVar = y2Var.f2306a;
        int i10 = Build.VERSION.SDK_INT;
        this.f2306a = (i10 < 30 || !(lVar instanceof k)) ? (i10 < 29 || !(lVar instanceof j)) ? (i10 < 28 || !(lVar instanceof i)) ? lVar instanceof h ? new h(this, (h) lVar) : lVar instanceof g ? new g(this, (g) lVar) : new l(this) : new i(this, (i) lVar) : new j(this, (j) lVar) : new k(this, (k) lVar);
        lVar.e(this);
    }

    static androidx.core.graphics.b m(androidx.core.graphics.b bVar, int i10, int i11, int i12, int i13) {
        int max = Math.max(0, bVar.f2079a - i10);
        int max2 = Math.max(0, bVar.f2080b - i11);
        int max3 = Math.max(0, bVar.f2081c - i12);
        int max4 = Math.max(0, bVar.f2082d - i13);
        return (max == i10 && max2 == i11 && max3 == i12 && max4 == i13) ? bVar : androidx.core.graphics.b.b(max, max2, max3, max4);
    }

    public static y2 u(WindowInsets windowInsets) {
        return v(windowInsets, null);
    }

    public static y2 v(WindowInsets windowInsets, View view) {
        y2 y2Var = new y2((WindowInsets) v.h.g(windowInsets));
        if (view != null && view.isAttachedToWindow()) {
            y2Var.r(r0.H(view));
            y2Var.d(view.getRootView());
        }
        return y2Var;
    }

    public y2 a() {
        return this.f2306a.a();
    }

    public y2 b() {
        return this.f2306a.b();
    }

    public y2 c() {
        return this.f2306a.c();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void d(View view) {
        this.f2306a.d(view);
    }

    public androidx.core.view.h e() {
        return this.f2306a.f();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof y2) {
            return v.c.a(this.f2306a, ((y2) obj).f2306a);
        }
        return false;
    }

    public androidx.core.graphics.b f(int i10) {
        return this.f2306a.g(i10);
    }

    public androidx.core.graphics.b g() {
        return this.f2306a.i();
    }

    public int h() {
        return this.f2306a.k().f2082d;
    }

    public int hashCode() {
        l lVar = this.f2306a;
        if (lVar == null) {
            return 0;
        }
        return lVar.hashCode();
    }

    public int i() {
        return this.f2306a.k().f2079a;
    }

    public int j() {
        return this.f2306a.k().f2081c;
    }

    public int k() {
        return this.f2306a.k().f2080b;
    }

    public y2 l(int i10, int i11, int i12, int i13) {
        return this.f2306a.m(i10, i11, i12, i13);
    }

    public boolean n() {
        return this.f2306a.n();
    }

    public y2 o(int i10, int i11, int i12, int i13) {
        return new b(this).c(androidx.core.graphics.b.b(i10, i11, i12, i13)).a();
    }

    void p(androidx.core.graphics.b[] bVarArr) {
        this.f2306a.p(bVarArr);
    }

    void q(androidx.core.graphics.b bVar) {
        this.f2306a.q(bVar);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void r(y2 y2Var) {
        this.f2306a.r(y2Var);
    }

    void s(androidx.core.graphics.b bVar) {
        this.f2306a.s(bVar);
    }

    public WindowInsets t() {
        l lVar = this.f2306a;
        if (lVar instanceof g) {
            return ((g) lVar).f2326c;
        }
        return null;
    }
}
