package androidx.core.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.ContentInfo;
import android.view.Display;
import android.view.KeyEvent;
import android.view.OnReceiveContentListener;
import android.view.View;
import android.view.View$OnUnhandledKeyEventListener;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.WindowInsets;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.autofill.AutofillId;
import android.view.contentcapture.ContentCaptureSession;
import androidx.core.view.a;
import androidx.core.view.r0;
import androidx.core.view.y2;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import w.l;
/* loaded from: classes.dex */
public abstract class r0 {

    /* renamed from: a  reason: collision with root package name */
    private static WeakHashMap f2278a = null;

    /* renamed from: b  reason: collision with root package name */
    private static Field f2279b = null;

    /* renamed from: c  reason: collision with root package name */
    private static boolean f2280c = false;

    /* renamed from: d  reason: collision with root package name */
    private static ThreadLocal f2281d;

    /* renamed from: e  reason: collision with root package name */
    private static final int[] f2282e = {q.b.f11964b, q.b.f11965c, q.b.f11976n, q.b.f11987y, q.b.B, q.b.C, q.b.D, q.b.E, q.b.F, q.b.G, q.b.f11966d, q.b.f11967e, q.b.f11968f, q.b.f11969g, q.b.f11970h, q.b.f11971i, q.b.f11972j, q.b.f11973k, q.b.f11974l, q.b.f11975m, q.b.f11977o, q.b.f11978p, q.b.f11979q, q.b.f11980r, q.b.f11981s, q.b.f11982t, q.b.f11983u, q.b.f11984v, q.b.f11985w, q.b.f11986x, q.b.f11988z, q.b.A};

    /* renamed from: f  reason: collision with root package name */
    private static final l0 f2283f = new l0() { // from class: androidx.core.view.q0
        @Override // androidx.core.view.l0
        public final c a(c cVar) {
            c V;
            V = r0.V(cVar);
            return V;
        }
    };

    /* renamed from: g  reason: collision with root package name */
    private static final e f2284g = new e();

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class a extends f {
        a(int i10, Class cls, int i11) {
            super(i10, cls, i11);
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        @Override // androidx.core.view.r0.f
        /* renamed from: h */
        public Boolean c(View view) {
            return Boolean.valueOf(k.d(view));
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        @Override // androidx.core.view.r0.f
        /* renamed from: i */
        public void d(View view, Boolean bool) {
            k.j(view, bool.booleanValue());
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        @Override // androidx.core.view.r0.f
        /* renamed from: j */
        public boolean g(Boolean bool, Boolean bool2) {
            return !a(bool, bool2);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class b extends f {
        b(int i10, Class cls, int i11, int i12) {
            super(i10, cls, i11, i12);
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        @Override // androidx.core.view.r0.f
        /* renamed from: h */
        public CharSequence c(View view) {
            return k.b(view);
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        @Override // androidx.core.view.r0.f
        /* renamed from: i */
        public void d(View view, CharSequence charSequence) {
            k.h(view, charSequence);
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        @Override // androidx.core.view.r0.f
        /* renamed from: j */
        public boolean g(CharSequence charSequence, CharSequence charSequence2) {
            return !TextUtils.equals(charSequence, charSequence2);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class c extends f {
        c(int i10, Class cls, int i11, int i12) {
            super(i10, cls, i11, i12);
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        @Override // androidx.core.view.r0.f
        /* renamed from: h */
        public CharSequence c(View view) {
            return m.b(view);
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        @Override // androidx.core.view.r0.f
        /* renamed from: i */
        public void d(View view, CharSequence charSequence) {
            m.e(view, charSequence);
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        @Override // androidx.core.view.r0.f
        /* renamed from: j */
        public boolean g(CharSequence charSequence, CharSequence charSequence2) {
            return !TextUtils.equals(charSequence, charSequence2);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class d extends f {
        d(int i10, Class cls, int i11) {
            super(i10, cls, i11);
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        @Override // androidx.core.view.r0.f
        /* renamed from: h */
        public Boolean c(View view) {
            return Boolean.valueOf(k.c(view));
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        @Override // androidx.core.view.r0.f
        /* renamed from: i */
        public void d(View view, Boolean bool) {
            k.g(view, bool.booleanValue());
        }

        /* JADX INFO: Access modifiers changed from: package-private */
        @Override // androidx.core.view.r0.f
        /* renamed from: j */
        public boolean g(Boolean bool, Boolean bool2) {
            return !a(bool, bool2);
        }
    }

    /* loaded from: classes.dex */
    static class e implements ViewTreeObserver.OnGlobalLayoutListener, View.OnAttachStateChangeListener {

        /* renamed from: g  reason: collision with root package name */
        private final WeakHashMap f2285g = new WeakHashMap();

        e() {
        }

        private void b(Map.Entry entry) {
            View view = (View) entry.getKey();
            boolean booleanValue = ((Boolean) entry.getValue()).booleanValue();
            boolean z9 = view.isShown() && view.getWindowVisibility() == 0;
            if (booleanValue != z9) {
                r0.W(view, z9 ? 16 : 32);
                entry.setValue(Boolean.valueOf(z9));
            }
        }

        private void c(View view) {
            view.getViewTreeObserver().addOnGlobalLayoutListener(this);
        }

        private void e(View view) {
            view.getViewTreeObserver().removeOnGlobalLayoutListener(this);
        }

        void a(View view) {
            this.f2285g.put(view, Boolean.valueOf(view.isShown() && view.getWindowVisibility() == 0));
            view.addOnAttachStateChangeListener(this);
            if (view.isAttachedToWindow()) {
                c(view);
            }
        }

        void d(View view) {
            this.f2285g.remove(view);
            view.removeOnAttachStateChangeListener(this);
            e(view);
        }

        @Override // android.view.ViewTreeObserver.OnGlobalLayoutListener
        public void onGlobalLayout() {
            if (Build.VERSION.SDK_INT < 28) {
                for (Map.Entry entry : this.f2285g.entrySet()) {
                    b(entry);
                }
            }
        }

        @Override // android.view.View.OnAttachStateChangeListener
        public void onViewAttachedToWindow(View view) {
            c(view);
        }

        @Override // android.view.View.OnAttachStateChangeListener
        public void onViewDetachedFromWindow(View view) {
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static abstract class f {

        /* renamed from: a  reason: collision with root package name */
        private final int f2286a;

        /* renamed from: b  reason: collision with root package name */
        private final Class f2287b;

        /* renamed from: c  reason: collision with root package name */
        private final int f2288c;

        /* renamed from: d  reason: collision with root package name */
        private final int f2289d;

        f(int i10, Class cls, int i11) {
            this(i10, cls, 0, i11);
        }

        f(int i10, Class cls, int i11, int i12) {
            this.f2286a = i10;
            this.f2287b = cls;
            this.f2289d = i11;
            this.f2288c = i12;
        }

        private boolean b() {
            return Build.VERSION.SDK_INT >= this.f2288c;
        }

        boolean a(Boolean bool, Boolean bool2) {
            return (bool != null && bool.booleanValue()) == (bool2 != null && bool2.booleanValue());
        }

        abstract Object c(View view);

        abstract void d(View view, Object obj);

        Object e(View view) {
            if (b()) {
                return c(view);
            }
            Object tag = view.getTag(this.f2286a);
            if (this.f2287b.isInstance(tag)) {
                return tag;
            }
            return null;
        }

        void f(View view, Object obj) {
            if (b()) {
                d(view, obj);
            } else if (g(e(view), obj)) {
                r0.k(view);
                view.setTag(this.f2286a, obj);
                r0.W(view, this.f2289d);
            }
        }

        abstract boolean g(Object obj, Object obj2);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class g {
        static WindowInsets a(View view, WindowInsets windowInsets) {
            return view.dispatchApplyWindowInsets(windowInsets);
        }

        static WindowInsets b(View view, WindowInsets windowInsets) {
            return view.onApplyWindowInsets(windowInsets);
        }

        static void c(View view) {
            view.requestApplyInsets();
        }
    }

    /* loaded from: classes.dex */
    private static class h {

        /* JADX INFO: Access modifiers changed from: package-private */
        /* loaded from: classes.dex */
        public class a implements View.OnApplyWindowInsetsListener {

            /* renamed from: a  reason: collision with root package name */
            y2 f2290a = null;

            /* renamed from: b  reason: collision with root package name */
            final /* synthetic */ View f2291b;

            /* renamed from: c  reason: collision with root package name */
            final /* synthetic */ j0 f2292c;

            a(View view, j0 j0Var) {
                this.f2291b = view;
                this.f2292c = j0Var;
            }

            @Override // android.view.View.OnApplyWindowInsetsListener
            public WindowInsets onApplyWindowInsets(View view, WindowInsets windowInsets) {
                y2 v9 = y2.v(windowInsets, view);
                int i10 = Build.VERSION.SDK_INT;
                if (i10 < 30) {
                    h.a(windowInsets, this.f2291b);
                    if (v9.equals(this.f2290a)) {
                        return this.f2292c.a(view, v9).t();
                    }
                }
                this.f2290a = v9;
                y2 a10 = this.f2292c.a(view, v9);
                if (i10 >= 30) {
                    return a10.t();
                }
                r0.k0(view);
                return a10.t();
            }
        }

        static void a(WindowInsets windowInsets, View view) {
            View.OnApplyWindowInsetsListener onApplyWindowInsetsListener = (View.OnApplyWindowInsetsListener) view.getTag(q.b.S);
            if (onApplyWindowInsetsListener != null) {
                onApplyWindowInsetsListener.onApplyWindowInsets(view, windowInsets);
            }
        }

        static y2 b(View view, y2 y2Var, Rect rect) {
            WindowInsets t9 = y2Var.t();
            if (t9 != null) {
                return y2.v(view.computeSystemWindowInsets(t9, rect), view);
            }
            rect.setEmpty();
            return y2Var;
        }

        static boolean c(View view, float f10, float f11, boolean z9) {
            return view.dispatchNestedFling(f10, f11, z9);
        }

        static boolean d(View view, float f10, float f11) {
            return view.dispatchNestedPreFling(f10, f11);
        }

        static boolean e(View view, int i10, int i11, int[] iArr, int[] iArr2) {
            return view.dispatchNestedPreScroll(i10, i11, iArr, iArr2);
        }

        static boolean f(View view, int i10, int i11, int i12, int i13, int[] iArr) {
            return view.dispatchNestedScroll(i10, i11, i12, i13, iArr);
        }

        static ColorStateList g(View view) {
            return view.getBackgroundTintList();
        }

        static PorterDuff.Mode h(View view) {
            return view.getBackgroundTintMode();
        }

        static float i(View view) {
            return view.getElevation();
        }

        public static y2 j(View view) {
            return y2.a.a(view);
        }

        static String k(View view) {
            return view.getTransitionName();
        }

        static float l(View view) {
            return view.getTranslationZ();
        }

        static float m(View view) {
            return view.getZ();
        }

        static boolean n(View view) {
            return view.hasNestedScrollingParent();
        }

        static boolean o(View view) {
            return view.isImportantForAccessibility();
        }

        static boolean p(View view) {
            return view.isNestedScrollingEnabled();
        }

        static void q(View view, ColorStateList colorStateList) {
            view.setBackgroundTintList(colorStateList);
        }

        static void r(View view, PorterDuff.Mode mode) {
            view.setBackgroundTintMode(mode);
        }

        static void s(View view, float f10) {
            view.setElevation(f10);
        }

        static void t(View view, boolean z9) {
            view.setNestedScrollingEnabled(z9);
        }

        static void u(View view, j0 j0Var) {
            if (Build.VERSION.SDK_INT < 30) {
                view.setTag(q.b.L, j0Var);
            }
            if (j0Var == null) {
                view.setOnApplyWindowInsetsListener((View.OnApplyWindowInsetsListener) view.getTag(q.b.S));
            } else {
                view.setOnApplyWindowInsetsListener(new a(view, j0Var));
            }
        }

        static void v(View view, String str) {
            view.setTransitionName(str);
        }

        static void w(View view, float f10) {
            view.setTranslationZ(f10);
        }

        static void x(View view, float f10) {
            view.setZ(f10);
        }

        static boolean y(View view, int i10) {
            return view.startNestedScroll(i10);
        }

        static void z(View view) {
            view.stopNestedScroll();
        }
    }

    /* loaded from: classes.dex */
    private static class i {
        public static y2 a(View view) {
            WindowInsets rootWindowInsets;
            rootWindowInsets = view.getRootWindowInsets();
            if (rootWindowInsets == null) {
                return null;
            }
            y2 u9 = y2.u(rootWindowInsets);
            u9.r(u9);
            u9.d(view.getRootView());
            return u9;
        }

        static int b(View view) {
            int scrollIndicators;
            scrollIndicators = view.getScrollIndicators();
            return scrollIndicators;
        }

        static void c(View view, int i10) {
            view.setScrollIndicators(i10);
        }

        static void d(View view, int i10, int i11) {
            view.setScrollIndicators(i10, i11);
        }
    }

    /* loaded from: classes.dex */
    static class j {
        static void a(View view, Collection<View> collection, int i10) {
            view.addKeyboardNavigationClusters(collection, i10);
        }

        public static AutofillId b(View view) {
            AutofillId autofillId;
            autofillId = view.getAutofillId();
            return autofillId;
        }

        static int c(View view) {
            int importantForAutofill;
            importantForAutofill = view.getImportantForAutofill();
            return importantForAutofill;
        }

        static int d(View view) {
            int nextClusterForwardId;
            nextClusterForwardId = view.getNextClusterForwardId();
            return nextClusterForwardId;
        }

        static boolean e(View view) {
            boolean hasExplicitFocusable;
            hasExplicitFocusable = view.hasExplicitFocusable();
            return hasExplicitFocusable;
        }

        static boolean f(View view) {
            boolean isFocusedByDefault;
            isFocusedByDefault = view.isFocusedByDefault();
            return isFocusedByDefault;
        }

        static boolean g(View view) {
            boolean isImportantForAutofill;
            isImportantForAutofill = view.isImportantForAutofill();
            return isImportantForAutofill;
        }

        static boolean h(View view) {
            boolean isKeyboardNavigationCluster;
            isKeyboardNavigationCluster = view.isKeyboardNavigationCluster();
            return isKeyboardNavigationCluster;
        }

        static View i(View view, View view2, int i10) {
            View keyboardNavigationClusterSearch;
            keyboardNavigationClusterSearch = view.keyboardNavigationClusterSearch(view2, i10);
            return keyboardNavigationClusterSearch;
        }

        static boolean j(View view) {
            boolean restoreDefaultFocus;
            restoreDefaultFocus = view.restoreDefaultFocus();
            return restoreDefaultFocus;
        }

        static void k(View view, String... strArr) {
            view.setAutofillHints(strArr);
        }

        static void l(View view, boolean z9) {
            view.setFocusedByDefault(z9);
        }

        static void m(View view, int i10) {
            view.setImportantForAutofill(i10);
        }

        static void n(View view, boolean z9) {
            view.setKeyboardNavigationCluster(z9);
        }

        static void o(View view, int i10) {
            view.setNextClusterForwardId(i10);
        }

        static void p(View view, CharSequence charSequence) {
            view.setTooltipText(charSequence);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class k {
        static void a(View view, final p pVar) {
            int i10 = q.b.R;
            o.h hVar = (o.h) view.getTag(i10);
            if (hVar == null) {
                hVar = new o.h();
                view.setTag(i10, hVar);
            }
            Objects.requireNonNull(pVar);
            View$OnUnhandledKeyEventListener view$OnUnhandledKeyEventListener = new View$OnUnhandledKeyEventListener() { // from class: androidx.core.view.v1
                public final boolean onUnhandledKeyEvent(View view2, KeyEvent keyEvent) {
                    return r0.p.this.onUnhandledKeyEvent(view2, keyEvent);
                }
            };
            hVar.put(pVar, view$OnUnhandledKeyEventListener);
            view.addOnUnhandledKeyEventListener(view$OnUnhandledKeyEventListener);
        }

        static CharSequence b(View view) {
            CharSequence accessibilityPaneTitle;
            accessibilityPaneTitle = view.getAccessibilityPaneTitle();
            return accessibilityPaneTitle;
        }

        static boolean c(View view) {
            boolean isAccessibilityHeading;
            isAccessibilityHeading = view.isAccessibilityHeading();
            return isAccessibilityHeading;
        }

        static boolean d(View view) {
            boolean isScreenReaderFocusable;
            isScreenReaderFocusable = view.isScreenReaderFocusable();
            return isScreenReaderFocusable;
        }

        static void e(View view, p pVar) {
            View$OnUnhandledKeyEventListener view$OnUnhandledKeyEventListener;
            o.h hVar = (o.h) view.getTag(q.b.R);
            if (hVar == null || (view$OnUnhandledKeyEventListener = (View$OnUnhandledKeyEventListener) hVar.get(pVar)) == null) {
                return;
            }
            view.removeOnUnhandledKeyEventListener(view$OnUnhandledKeyEventListener);
        }

        static <T> T f(View view, int i10) {
            View requireViewById;
            requireViewById = view.requireViewById(i10);
            return (T) requireViewById;
        }

        static void g(View view, boolean z9) {
            view.setAccessibilityHeading(z9);
        }

        static void h(View view, CharSequence charSequence) {
            view.setAccessibilityPaneTitle(charSequence);
        }

        public static void i(View view, x.a aVar) {
            view.setAutofillId(null);
        }

        static void j(View view, boolean z9) {
            view.setScreenReaderFocusable(z9);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class l {
        static View.AccessibilityDelegate a(View view) {
            View.AccessibilityDelegate accessibilityDelegate;
            accessibilityDelegate = view.getAccessibilityDelegate();
            return accessibilityDelegate;
        }

        static ContentCaptureSession b(View view) {
            ContentCaptureSession contentCaptureSession;
            contentCaptureSession = view.getContentCaptureSession();
            return contentCaptureSession;
        }

        static List<Rect> c(View view) {
            List<Rect> systemGestureExclusionRects;
            systemGestureExclusionRects = view.getSystemGestureExclusionRects();
            return systemGestureExclusionRects;
        }

        static void d(View view, Context context, int[] iArr, AttributeSet attributeSet, TypedArray typedArray, int i10, int i11) {
            view.saveAttributeDataForStyleable(context, iArr, attributeSet, typedArray, i10, i11);
        }

        static void e(View view, y.a aVar) {
            view.setContentCaptureSession(null);
        }

        static void f(View view, List<Rect> list) {
            view.setSystemGestureExclusionRects(list);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class m {
        static int a(View view) {
            int importantForContentCapture;
            importantForContentCapture = view.getImportantForContentCapture();
            return importantForContentCapture;
        }

        static CharSequence b(View view) {
            CharSequence stateDescription;
            stateDescription = view.getStateDescription();
            return stateDescription;
        }

        static boolean c(View view) {
            boolean isImportantForContentCapture;
            isImportantForContentCapture = view.isImportantForContentCapture();
            return isImportantForContentCapture;
        }

        static void d(View view, int i10) {
            view.setImportantForContentCapture(i10);
        }

        static void e(View view, CharSequence charSequence) {
            view.setStateDescription(charSequence);
        }
    }

    /* loaded from: classes.dex */
    private static final class n {
        public static String[] a(View view) {
            String[] receiveContentMimeTypes;
            receiveContentMimeTypes = view.getReceiveContentMimeTypes();
            return receiveContentMimeTypes;
        }

        public static androidx.core.view.c b(View view, androidx.core.view.c cVar) {
            ContentInfo performReceiveContent;
            ContentInfo f10 = cVar.f();
            performReceiveContent = view.performReceiveContent(f10);
            if (performReceiveContent == null) {
                return null;
            }
            return performReceiveContent == f10 ? cVar : androidx.core.view.c.g(performReceiveContent);
        }

        public static void c(View view, String[] strArr, k0 k0Var) {
            if (k0Var == null) {
                view.setOnReceiveContentListener(strArr, null);
            } else {
                view.setOnReceiveContentListener(strArr, new o(k0Var));
            }
        }
    }

    /* loaded from: classes.dex */
    private static final class o implements OnReceiveContentListener {

        /* renamed from: a  reason: collision with root package name */
        private final k0 f2293a;

        o(k0 k0Var) {
            this.f2293a = k0Var;
        }

        public ContentInfo onReceiveContent(View view, ContentInfo contentInfo) {
            androidx.core.view.c g10 = androidx.core.view.c.g(contentInfo);
            androidx.core.view.c a10 = this.f2293a.a(view, g10);
            if (a10 == null) {
                return null;
            }
            return a10 == g10 ? contentInfo : a10.f();
        }
    }

    /* loaded from: classes.dex */
    public interface p {
        boolean onUnhandledKeyEvent(View view, KeyEvent keyEvent);
    }

    /* loaded from: classes.dex */
    static class q {

        /* renamed from: d  reason: collision with root package name */
        private static final ArrayList f2294d = new ArrayList();

        /* renamed from: a  reason: collision with root package name */
        private WeakHashMap f2295a = null;

        /* renamed from: b  reason: collision with root package name */
        private SparseArray f2296b = null;

        /* renamed from: c  reason: collision with root package name */
        private WeakReference f2297c = null;

        q() {
        }

        static q a(View view) {
            int i10 = q.b.Q;
            q qVar = (q) view.getTag(i10);
            if (qVar == null) {
                q qVar2 = new q();
                view.setTag(i10, qVar2);
                return qVar2;
            }
            return qVar;
        }

        private View c(View view, KeyEvent keyEvent) {
            WeakHashMap weakHashMap = this.f2295a;
            if (weakHashMap != null && weakHashMap.containsKey(view)) {
                if (view instanceof ViewGroup) {
                    ViewGroup viewGroup = (ViewGroup) view;
                    for (int childCount = viewGroup.getChildCount() - 1; childCount >= 0; childCount--) {
                        View c10 = c(viewGroup.getChildAt(childCount), keyEvent);
                        if (c10 != null) {
                            return c10;
                        }
                    }
                }
                if (e(view, keyEvent)) {
                    return view;
                }
            }
            return null;
        }

        private SparseArray d() {
            if (this.f2296b == null) {
                this.f2296b = new SparseArray();
            }
            return this.f2296b;
        }

        private boolean e(View view, KeyEvent keyEvent) {
            ArrayList arrayList = (ArrayList) view.getTag(q.b.R);
            if (arrayList != null) {
                for (int size = arrayList.size() - 1; size >= 0; size--) {
                    if (((p) arrayList.get(size)).onUnhandledKeyEvent(view, keyEvent)) {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        private void g() {
            WeakHashMap weakHashMap = this.f2295a;
            if (weakHashMap != null) {
                weakHashMap.clear();
            }
            ArrayList arrayList = f2294d;
            if (arrayList.isEmpty()) {
                return;
            }
            synchronized (arrayList) {
                if (this.f2295a == null) {
                    this.f2295a = new WeakHashMap();
                }
                for (int size = arrayList.size() - 1; size >= 0; size--) {
                    ArrayList arrayList2 = f2294d;
                    View view = (View) ((WeakReference) arrayList2.get(size)).get();
                    if (view == null) {
                        arrayList2.remove(size);
                    } else {
                        this.f2295a.put(view, Boolean.TRUE);
                        for (ViewParent parent = view.getParent(); parent instanceof View; parent = parent.getParent()) {
                            this.f2295a.put((View) parent, Boolean.TRUE);
                        }
                    }
                }
            }
        }

        boolean b(View view, KeyEvent keyEvent) {
            if (keyEvent.getAction() == 0) {
                g();
            }
            View c10 = c(view, keyEvent);
            if (keyEvent.getAction() == 0) {
                int keyCode = keyEvent.getKeyCode();
                if (c10 != null && !KeyEvent.isModifierKey(keyCode)) {
                    d().put(keyCode, new WeakReference(c10));
                }
            }
            return c10 != null;
        }

        boolean f(KeyEvent keyEvent) {
            int indexOfKey;
            WeakReference weakReference = this.f2297c;
            if (weakReference == null || weakReference.get() != keyEvent) {
                this.f2297c = new WeakReference(keyEvent);
                WeakReference weakReference2 = null;
                SparseArray d10 = d();
                if (keyEvent.getAction() == 1 && (indexOfKey = d10.indexOfKey(keyEvent.getKeyCode())) >= 0) {
                    weakReference2 = (WeakReference) d10.valueAt(indexOfKey);
                    d10.removeAt(indexOfKey);
                }
                if (weakReference2 == null) {
                    weakReference2 = (WeakReference) d10.get(keyEvent.getKeyCode());
                }
                if (weakReference2 != null) {
                    View view = (View) weakReference2.get();
                    if (view != null && view.isAttachedToWindow()) {
                        e(view, keyEvent);
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
    }

    public static int A(View view) {
        if (Build.VERSION.SDK_INT >= 26) {
            return j.c(view);
        }
        return 0;
    }

    public static void A0(View view, j0 j0Var) {
        h.u(view, j0Var);
    }

    public static int B(View view) {
        return view.getLayoutDirection();
    }

    public static void B0(View view, int i10, int i11, int i12, int i13) {
        view.setPaddingRelative(i10, i11, i12, i13);
    }

    public static int C(View view) {
        return view.getMinimumHeight();
    }

    public static void C0(View view, boolean z9) {
        m0().f(view, Boolean.valueOf(z9));
    }

    public static int D(View view) {
        return view.getMinimumWidth();
    }

    public static void D0(View view, int i10, int i11) {
        if (Build.VERSION.SDK_INT >= 23) {
            i.d(view, i10, i11);
        }
    }

    public static String[] E(View view) {
        return Build.VERSION.SDK_INT >= 31 ? n.a(view) : (String[]) view.getTag(q.b.N);
    }

    public static void E0(View view, String str) {
        h.v(view, str);
    }

    public static int F(View view) {
        return view.getPaddingEnd();
    }

    private static f F0() {
        return new c(q.b.P, CharSequence.class, 64, 30);
    }

    public static int G(View view) {
        return view.getPaddingStart();
    }

    public static void G0(View view) {
        h.z(view);
    }

    public static y2 H(View view) {
        return Build.VERSION.SDK_INT >= 23 ? i.a(view) : h.j(view);
    }

    private static void H0(View view) {
        float translationY = view.getTranslationY();
        view.setTranslationY(1.0f + translationY);
        view.setTranslationY(translationY);
    }

    public static CharSequence I(View view) {
        return (CharSequence) F0().e(view);
    }

    public static String J(View view) {
        return h.k(view);
    }

    public static int K(View view) {
        return view.getWindowSystemUiVisibility();
    }

    public static float L(View view) {
        return h.m(view);
    }

    public static boolean M(View view) {
        return view.hasOnClickListeners();
    }

    public static boolean N(View view) {
        return view.hasOverlappingRendering();
    }

    public static boolean O(View view) {
        return view.hasTransientState();
    }

    public static boolean P(View view) {
        Boolean bool = (Boolean) b().e(view);
        return bool != null && bool.booleanValue();
    }

    public static boolean Q(View view) {
        return view.isAttachedToWindow();
    }

    public static boolean R(View view) {
        return view.isLaidOut();
    }

    public static boolean S(View view) {
        return h.p(view);
    }

    public static boolean T(View view) {
        return view.isPaddingRelative();
    }

    public static boolean U(View view) {
        Boolean bool = (Boolean) m0().e(view);
        return bool != null && bool.booleanValue();
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static /* synthetic */ androidx.core.view.c V(androidx.core.view.c cVar) {
        return cVar;
    }

    static void W(View view, int i10) {
        AccessibilityManager accessibilityManager = (AccessibilityManager) view.getContext().getSystemService("accessibility");
        if (accessibilityManager.isEnabled()) {
            boolean z9 = p(view) != null && view.isShown() && view.getWindowVisibility() == 0;
            if (view.getAccessibilityLiveRegion() != 0 || z9) {
                AccessibilityEvent obtain = AccessibilityEvent.obtain();
                obtain.setEventType(z9 ? 32 : 2048);
                obtain.setContentChangeTypes(i10);
                if (z9) {
                    obtain.getText().add(p(view));
                    y0(view);
                }
                view.sendAccessibilityEventUnchecked(obtain);
            } else if (i10 == 32) {
                AccessibilityEvent obtain2 = AccessibilityEvent.obtain();
                view.onInitializeAccessibilityEvent(obtain2);
                obtain2.setEventType(32);
                obtain2.setContentChangeTypes(i10);
                obtain2.setSource(view);
                view.onPopulateAccessibilityEvent(obtain2);
                obtain2.getText().add(p(view));
                accessibilityManager.sendAccessibilityEvent(obtain2);
            } else if (view.getParent() != null) {
                try {
                    view.getParent().notifySubtreeAccessibilityStateChanged(view, view, i10);
                } catch (AbstractMethodError e10) {
                    Log.e("ViewCompat", view.getParent().getClass().getSimpleName() + " does not fully implement ViewParent", e10);
                }
            }
        }
    }

    public static void X(View view, int i10) {
        if (Build.VERSION.SDK_INT >= 23) {
            view.offsetLeftAndRight(i10);
            return;
        }
        Rect w9 = w();
        boolean z9 = false;
        ViewParent parent = view.getParent();
        if (parent instanceof View) {
            View view2 = (View) parent;
            w9.set(view2.getLeft(), view2.getTop(), view2.getRight(), view2.getBottom());
            z9 = !w9.intersects(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        }
        e(view, i10);
        if (z9 && w9.intersect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom())) {
            ((View) parent).invalidate(w9);
        }
    }

    public static void Y(View view, int i10) {
        if (Build.VERSION.SDK_INT >= 23) {
            view.offsetTopAndBottom(i10);
            return;
        }
        Rect w9 = w();
        boolean z9 = false;
        ViewParent parent = view.getParent();
        if (parent instanceof View) {
            View view2 = (View) parent;
            w9.set(view2.getLeft(), view2.getTop(), view2.getRight(), view2.getBottom());
            z9 = !w9.intersects(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        }
        f(view, i10);
        if (z9 && w9.intersect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom())) {
            ((View) parent).invalidate(w9);
        }
    }

    public static y2 Z(View view, y2 y2Var) {
        WindowInsets t9 = y2Var.t();
        if (t9 != null) {
            WindowInsets b10 = g.b(view, t9);
            if (!b10.equals(t9)) {
                return y2.v(b10, view);
            }
        }
        return y2Var;
    }

    public static void a0(View view, w.l lVar) {
        view.onInitializeAccessibilityNodeInfo(lVar.G0());
    }

    private static f b() {
        return new d(q.b.J, Boolean.class, 28);
    }

    private static f b0() {
        return new b(q.b.K, CharSequence.class, 8, 28);
    }

    private static void c(View view, l.a aVar) {
        k(view);
        i0(aVar.b(), view);
        q(view).add(aVar);
        W(view, 0);
    }

    public static boolean c0(View view, int i10, Bundle bundle) {
        return view.performAccessibilityAction(i10, bundle);
    }

    public static u2 d(View view) {
        if (f2278a == null) {
            f2278a = new WeakHashMap();
        }
        u2 u2Var = (u2) f2278a.get(view);
        if (u2Var == null) {
            u2 u2Var2 = new u2(view);
            f2278a.put(view, u2Var2);
            return u2Var2;
        }
        return u2Var;
    }

    public static androidx.core.view.c d0(View view, androidx.core.view.c cVar) {
        if (Log.isLoggable("ViewCompat", 3)) {
            Log.d("ViewCompat", "performReceiveContent: " + cVar + ", view=" + view.getClass().getSimpleName() + "[" + view.getId() + "]");
        }
        if (Build.VERSION.SDK_INT >= 31) {
            return n.b(view, cVar);
        }
        k0 k0Var = (k0) view.getTag(q.b.M);
        if (k0Var != null) {
            androidx.core.view.c a10 = k0Var.a(view, cVar);
            if (a10 == null) {
                return null;
            }
            return x(view).a(a10);
        }
        return x(view).a(cVar);
    }

    private static void e(View view, int i10) {
        view.offsetLeftAndRight(i10);
        if (view.getVisibility() == 0) {
            H0(view);
            ViewParent parent = view.getParent();
            if (parent instanceof View) {
                H0((View) parent);
            }
        }
    }

    public static void e0(View view) {
        view.postInvalidateOnAnimation();
    }

    private static void f(View view, int i10) {
        view.offsetTopAndBottom(i10);
        if (view.getVisibility() == 0) {
            H0(view);
            ViewParent parent = view.getParent();
            if (parent instanceof View) {
                H0((View) parent);
            }
        }
    }

    public static void f0(View view, Runnable runnable) {
        view.postOnAnimation(runnable);
    }

    public static y2 g(View view, y2 y2Var, Rect rect) {
        return h.b(view, y2Var, rect);
    }

    public static void g0(View view, Runnable runnable, long j10) {
        view.postOnAnimationDelayed(runnable, j10);
    }

    public static y2 h(View view, y2 y2Var) {
        WindowInsets t9 = y2Var.t();
        if (t9 != null) {
            WindowInsets a10 = g.a(view, t9);
            if (!a10.equals(t9)) {
                return y2.v(a10, view);
            }
        }
        return y2Var;
    }

    public static void h0(View view, int i10) {
        i0(i10, view);
        W(view, 0);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static boolean i(View view, KeyEvent keyEvent) {
        if (Build.VERSION.SDK_INT >= 28) {
            return false;
        }
        return q.a(view).b(view, keyEvent);
    }

    private static void i0(int i10, View view) {
        List q10 = q(view);
        for (int i11 = 0; i11 < q10.size(); i11++) {
            if (((l.a) q10.get(i11)).b() == i10) {
                q10.remove(i11);
                return;
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static boolean j(View view, KeyEvent keyEvent) {
        if (Build.VERSION.SDK_INT >= 28) {
            return false;
        }
        return q.a(view).f(keyEvent);
    }

    public static void j0(View view, l.a aVar, CharSequence charSequence, w.r rVar) {
        if (rVar == null && charSequence == null) {
            h0(view, aVar.b());
        } else {
            c(view, aVar.a(charSequence, rVar));
        }
    }

    static void k(View view) {
        androidx.core.view.a l10 = l(view);
        if (l10 == null) {
            l10 = new androidx.core.view.a();
        }
        n0(view, l10);
    }

    public static void k0(View view) {
        g.c(view);
    }

    public static androidx.core.view.a l(View view) {
        View.AccessibilityDelegate m10 = m(view);
        if (m10 == null) {
            return null;
        }
        return m10 instanceof a.C0020a ? ((a.C0020a) m10).f2205a : new androidx.core.view.a(m10);
    }

    public static void l0(View view, Context context, int[] iArr, AttributeSet attributeSet, TypedArray typedArray, int i10, int i11) {
        if (Build.VERSION.SDK_INT >= 29) {
            l.d(view, context, iArr, attributeSet, typedArray, i10, i11);
        }
    }

    private static View.AccessibilityDelegate m(View view) {
        return Build.VERSION.SDK_INT >= 29 ? l.a(view) : n(view);
    }

    private static f m0() {
        return new a(q.b.O, Boolean.class, 28);
    }

    private static View.AccessibilityDelegate n(View view) {
        if (f2280c) {
            return null;
        }
        if (f2279b == null) {
            try {
                Field declaredField = View.class.getDeclaredField("mAccessibilityDelegate");
                f2279b = declaredField;
                declaredField.setAccessible(true);
            } catch (Throwable unused) {
                f2280c = true;
                return null;
            }
        }
        try {
            Object obj = f2279b.get(view);
            if (obj instanceof View.AccessibilityDelegate) {
                return (View.AccessibilityDelegate) obj;
            }
            return null;
        } catch (Throwable unused2) {
            f2280c = true;
            return null;
        }
    }

    public static void n0(View view, androidx.core.view.a aVar) {
        if (aVar == null && (m(view) instanceof a.C0020a)) {
            aVar = new androidx.core.view.a();
        }
        y0(view);
        view.setAccessibilityDelegate(aVar == null ? null : aVar.d());
    }

    public static int o(View view) {
        return view.getAccessibilityLiveRegion();
    }

    public static void o0(View view, boolean z9) {
        b().f(view, Boolean.valueOf(z9));
    }

    public static CharSequence p(View view) {
        return (CharSequence) b0().e(view);
    }

    public static void p0(View view, int i10) {
        view.setAccessibilityLiveRegion(i10);
    }

    private static List q(View view) {
        int i10 = q.b.H;
        ArrayList arrayList = (ArrayList) view.getTag(i10);
        if (arrayList == null) {
            ArrayList arrayList2 = new ArrayList();
            view.setTag(i10, arrayList2);
            return arrayList2;
        }
        return arrayList;
    }

    public static void q0(View view, CharSequence charSequence) {
        b0().f(view, charSequence);
        if (charSequence != null) {
            f2284g.a(view);
        } else {
            f2284g.d(view);
        }
    }

    public static ColorStateList r(View view) {
        return h.g(view);
    }

    public static void r0(View view, Drawable drawable) {
        view.setBackground(drawable);
    }

    public static PorterDuff.Mode s(View view) {
        return h.h(view);
    }

    public static void s0(View view, ColorStateList colorStateList) {
        int i10 = Build.VERSION.SDK_INT;
        h.q(view, colorStateList);
        if (i10 == 21) {
            Drawable background = view.getBackground();
            boolean z9 = (h.g(view) == null && h.h(view) == null) ? false : true;
            if (background == null || !z9) {
                return;
            }
            if (background.isStateful()) {
                background.setState(view.getDrawableState());
            }
            view.setBackground(background);
        }
    }

    public static Rect t(View view) {
        return view.getClipBounds();
    }

    public static void t0(View view, PorterDuff.Mode mode) {
        int i10 = Build.VERSION.SDK_INT;
        h.r(view, mode);
        if (i10 == 21) {
            Drawable background = view.getBackground();
            boolean z9 = (h.g(view) == null && h.h(view) == null) ? false : true;
            if (background == null || !z9) {
                return;
            }
            if (background.isStateful()) {
                background.setState(view.getDrawableState());
            }
            view.setBackground(background);
        }
    }

    public static Display u(View view) {
        return view.getDisplay();
    }

    public static void u0(View view, Rect rect) {
        view.setClipBounds(rect);
    }

    public static float v(View view) {
        return h.i(view);
    }

    public static void v0(View view, float f10) {
        h.s(view, f10);
    }

    private static Rect w() {
        if (f2281d == null) {
            f2281d = new ThreadLocal();
        }
        Rect rect = (Rect) f2281d.get();
        if (rect == null) {
            rect = new Rect();
            f2281d.set(rect);
        }
        rect.setEmpty();
        return rect;
    }

    public static void w0(View view, boolean z9) {
        view.setHasTransientState(z9);
    }

    private static l0 x(View view) {
        return view instanceof l0 ? (l0) view : f2283f;
    }

    public static void x0(View view, int i10) {
        view.setImportantForAccessibility(i10);
    }

    public static boolean y(View view) {
        return view.getFitsSystemWindows();
    }

    private static void y0(View view) {
        if (view.getImportantForAccessibility() == 0) {
            view.setImportantForAccessibility(1);
        }
    }

    public static int z(View view) {
        return view.getImportantForAccessibility();
    }

    public static void z0(View view, int i10) {
        if (Build.VERSION.SDK_INT >= 26) {
            j.m(view, i10);
        }
    }
}
