package androidx.core.view;

import android.os.Bundle;
import android.text.style.ClickableSpan;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import w.l;
/* loaded from: classes.dex */
public class a {

    /* renamed from: c  reason: collision with root package name */
    private static final View.AccessibilityDelegate f2202c = new View.AccessibilityDelegate();

    /* renamed from: a  reason: collision with root package name */
    private final View.AccessibilityDelegate f2203a;

    /* renamed from: b  reason: collision with root package name */
    private final View.AccessibilityDelegate f2204b;

    /* JADX INFO: Access modifiers changed from: package-private */
    /* renamed from: androidx.core.view.a$a  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public static final class C0020a extends View.AccessibilityDelegate {

        /* renamed from: a  reason: collision with root package name */
        final a f2205a;

        C0020a(a aVar) {
            this.f2205a = aVar;
        }

        @Override // android.view.View.AccessibilityDelegate
        public boolean dispatchPopulateAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
            return this.f2205a.a(view, accessibilityEvent);
        }

        @Override // android.view.View.AccessibilityDelegate
        public AccessibilityNodeProvider getAccessibilityNodeProvider(View view) {
            w.p b10 = this.f2205a.b(view);
            if (b10 != null) {
                return (AccessibilityNodeProvider) b10.e();
            }
            return null;
        }

        @Override // android.view.View.AccessibilityDelegate
        public void onInitializeAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
            this.f2205a.f(view, accessibilityEvent);
        }

        @Override // android.view.View.AccessibilityDelegate
        public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfo accessibilityNodeInfo) {
            w.l H0 = w.l.H0(accessibilityNodeInfo);
            H0.z0(r0.U(view));
            H0.t0(r0.P(view));
            H0.w0(r0.p(view));
            H0.D0(r0.I(view));
            this.f2205a.g(view, H0);
            H0.e(accessibilityNodeInfo.getText(), view);
            List c10 = a.c(view);
            for (int i10 = 0; i10 < c10.size(); i10++) {
                H0.b((l.a) c10.get(i10));
            }
        }

        @Override // android.view.View.AccessibilityDelegate
        public void onPopulateAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
            this.f2205a.h(view, accessibilityEvent);
        }

        @Override // android.view.View.AccessibilityDelegate
        public boolean onRequestSendAccessibilityEvent(ViewGroup viewGroup, View view, AccessibilityEvent accessibilityEvent) {
            return this.f2205a.i(viewGroup, view, accessibilityEvent);
        }

        @Override // android.view.View.AccessibilityDelegate
        public boolean performAccessibilityAction(View view, int i10, Bundle bundle) {
            return this.f2205a.j(view, i10, bundle);
        }

        @Override // android.view.View.AccessibilityDelegate
        public void sendAccessibilityEvent(View view, int i10) {
            this.f2205a.l(view, i10);
        }

        @Override // android.view.View.AccessibilityDelegate
        public void sendAccessibilityEventUnchecked(View view, AccessibilityEvent accessibilityEvent) {
            this.f2205a.m(view, accessibilityEvent);
        }
    }

    public a() {
        this(f2202c);
    }

    public a(View.AccessibilityDelegate accessibilityDelegate) {
        this.f2203a = accessibilityDelegate;
        this.f2204b = new C0020a(this);
    }

    static List c(View view) {
        List list = (List) view.getTag(q.b.H);
        return list == null ? Collections.emptyList() : list;
    }

    private boolean e(ClickableSpan clickableSpan, View view) {
        if (clickableSpan != null) {
            ClickableSpan[] q10 = w.l.q(view.createAccessibilityNodeInfo().getText());
            for (int i10 = 0; q10 != null && i10 < q10.length; i10++) {
                if (clickableSpan.equals(q10[i10])) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean k(int i10, View view) {
        WeakReference weakReference;
        SparseArray sparseArray = (SparseArray) view.getTag(q.b.I);
        if (sparseArray == null || (weakReference = (WeakReference) sparseArray.get(i10)) == null) {
            return false;
        }
        ClickableSpan clickableSpan = (ClickableSpan) weakReference.get();
        if (e(clickableSpan, view)) {
            clickableSpan.onClick(view);
            return true;
        }
        return false;
    }

    public boolean a(View view, AccessibilityEvent accessibilityEvent) {
        return this.f2203a.dispatchPopulateAccessibilityEvent(view, accessibilityEvent);
    }

    public w.p b(View view) {
        AccessibilityNodeProvider accessibilityNodeProvider = this.f2203a.getAccessibilityNodeProvider(view);
        if (accessibilityNodeProvider != null) {
            return new w.p(accessibilityNodeProvider);
        }
        return null;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public View.AccessibilityDelegate d() {
        return this.f2204b;
    }

    public void f(View view, AccessibilityEvent accessibilityEvent) {
        this.f2203a.onInitializeAccessibilityEvent(view, accessibilityEvent);
    }

    public void g(View view, w.l lVar) {
        this.f2203a.onInitializeAccessibilityNodeInfo(view, lVar.G0());
    }

    public void h(View view, AccessibilityEvent accessibilityEvent) {
        this.f2203a.onPopulateAccessibilityEvent(view, accessibilityEvent);
    }

    public boolean i(ViewGroup viewGroup, View view, AccessibilityEvent accessibilityEvent) {
        return this.f2203a.onRequestSendAccessibilityEvent(viewGroup, view, accessibilityEvent);
    }

    public boolean j(View view, int i10, Bundle bundle) {
        List c10 = c(view);
        boolean z9 = false;
        int i11 = 0;
        while (true) {
            if (i11 >= c10.size()) {
                break;
            }
            l.a aVar = (l.a) c10.get(i11);
            if (aVar.b() == i10) {
                z9 = aVar.d(view, bundle);
                break;
            }
            i11++;
        }
        if (!z9) {
            z9 = this.f2203a.performAccessibilityAction(view, i10, bundle);
        }
        return (z9 || i10 != q.b.f11963a || bundle == null) ? z9 : k(bundle.getInt("ACCESSIBILITY_CLICKABLE_SPAN_ID", -1), view);
    }

    public void l(View view, int i10) {
        this.f2203a.sendAccessibilityEvent(view, i10);
    }

    public void m(View view, AccessibilityEvent accessibilityEvent) {
        this.f2203a.sendAccessibilityEventUnchecked(view, accessibilityEvent);
    }
}
