package androidx.core.text;

import android.annotation.NonNull;
import android.os.Build;
import android.os.LocaleList;
import android.text.PrecomputedText;
import android.text.Spannable;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
/* loaded from: classes.dex */
public abstract class e implements Spannable {

    /* loaded from: classes.dex */
    public static final class a {

        /* renamed from: a  reason: collision with root package name */
        private final TextPaint f2181a;

        /* renamed from: b  reason: collision with root package name */
        private final TextDirectionHeuristic f2182b;

        /* renamed from: c  reason: collision with root package name */
        private final int f2183c;

        /* renamed from: d  reason: collision with root package name */
        private final int f2184d;

        /* renamed from: e  reason: collision with root package name */
        final PrecomputedText.Params f2185e;

        /* renamed from: androidx.core.text.e$a$a  reason: collision with other inner class name */
        /* loaded from: classes.dex */
        public static class C0019a {

            /* renamed from: a  reason: collision with root package name */
            private final TextPaint f2186a;

            /* renamed from: b  reason: collision with root package name */
            private TextDirectionHeuristic f2187b;

            /* renamed from: c  reason: collision with root package name */
            private int f2188c;

            /* renamed from: d  reason: collision with root package name */
            private int f2189d;

            public C0019a(TextPaint textPaint) {
                this.f2186a = textPaint;
                if (Build.VERSION.SDK_INT >= 23) {
                    this.f2188c = 1;
                    this.f2189d = 1;
                } else {
                    this.f2189d = 0;
                    this.f2188c = 0;
                }
                this.f2187b = TextDirectionHeuristics.FIRSTSTRONG_LTR;
            }

            public a a() {
                return new a(this.f2186a, this.f2187b, this.f2188c, this.f2189d);
            }

            public C0019a b(int i10) {
                this.f2188c = i10;
                return this;
            }

            public C0019a c(int i10) {
                this.f2189d = i10;
                return this;
            }

            public C0019a d(TextDirectionHeuristic textDirectionHeuristic) {
                this.f2187b = textDirectionHeuristic;
                return this;
            }
        }

        public a(PrecomputedText.Params params) {
            this.f2181a = params.getTextPaint();
            this.f2182b = params.getTextDirection();
            this.f2183c = params.getBreakStrategy();
            this.f2184d = params.getHyphenationFrequency();
            this.f2185e = Build.VERSION.SDK_INT < 29 ? null : params;
        }

        /* JADX WARN: Type inference failed for: r0v3, types: [android.text.PrecomputedText$Params$Builder] */
        a(TextPaint textPaint, TextDirectionHeuristic textDirectionHeuristic, int i10, int i11) {
            this.f2185e = Build.VERSION.SDK_INT >= 29 ? new Object(textPaint) { // from class: android.text.PrecomputedText.Params.Builder
                static {
                    throw new NoClassDefFoundError();
                }

                @NonNull
                public native /* synthetic */ Params build();

                public native /* synthetic */ Builder setBreakStrategy(int i12);

                public native /* synthetic */ Builder setHyphenationFrequency(int i12);

                public native /* synthetic */ Builder setTextDirection(@NonNull TextDirectionHeuristic textDirectionHeuristic2);
            }.setBreakStrategy(i10).setHyphenationFrequency(i11).setTextDirection(textDirectionHeuristic).build() : null;
            this.f2181a = textPaint;
            this.f2182b = textDirectionHeuristic;
            this.f2183c = i10;
            this.f2184d = i11;
        }

        public boolean a(a aVar) {
            LocaleList textLocales;
            LocaleList textLocales2;
            int i10 = Build.VERSION.SDK_INT;
            if ((i10 < 23 || (this.f2183c == aVar.b() && this.f2184d == aVar.c())) && this.f2181a.getTextSize() == aVar.e().getTextSize() && this.f2181a.getTextScaleX() == aVar.e().getTextScaleX() && this.f2181a.getTextSkewX() == aVar.e().getTextSkewX() && this.f2181a.getLetterSpacing() == aVar.e().getLetterSpacing() && TextUtils.equals(this.f2181a.getFontFeatureSettings(), aVar.e().getFontFeatureSettings()) && this.f2181a.getFlags() == aVar.e().getFlags()) {
                if (i10 >= 24) {
                    textLocales = this.f2181a.getTextLocales();
                    textLocales2 = aVar.e().getTextLocales();
                    if (!textLocales.equals(textLocales2)) {
                        return false;
                    }
                } else if (!this.f2181a.getTextLocale().equals(aVar.e().getTextLocale())) {
                    return false;
                }
                return this.f2181a.getTypeface() == null ? aVar.e().getTypeface() == null : this.f2181a.getTypeface().equals(aVar.e().getTypeface());
            }
            return false;
        }

        public int b() {
            return this.f2183c;
        }

        public int c() {
            return this.f2184d;
        }

        public TextDirectionHeuristic d() {
            return this.f2182b;
        }

        public TextPaint e() {
            return this.f2181a;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof a) {
                a aVar = (a) obj;
                return a(aVar) && this.f2182b == aVar.d();
            }
            return false;
        }

        public int hashCode() {
            LocaleList textLocales;
            if (Build.VERSION.SDK_INT >= 24) {
                textLocales = this.f2181a.getTextLocales();
                return v.c.b(Float.valueOf(this.f2181a.getTextSize()), Float.valueOf(this.f2181a.getTextScaleX()), Float.valueOf(this.f2181a.getTextSkewX()), Float.valueOf(this.f2181a.getLetterSpacing()), Integer.valueOf(this.f2181a.getFlags()), textLocales, this.f2181a.getTypeface(), Boolean.valueOf(this.f2181a.isElegantTextHeight()), this.f2182b, Integer.valueOf(this.f2183c), Integer.valueOf(this.f2184d));
            }
            return v.c.b(Float.valueOf(this.f2181a.getTextSize()), Float.valueOf(this.f2181a.getTextScaleX()), Float.valueOf(this.f2181a.getTextSkewX()), Float.valueOf(this.f2181a.getLetterSpacing()), Integer.valueOf(this.f2181a.getFlags()), this.f2181a.getTextLocale(), this.f2181a.getTypeface(), Boolean.valueOf(this.f2181a.isElegantTextHeight()), this.f2182b, Integer.valueOf(this.f2183c), Integer.valueOf(this.f2184d));
        }

        public String toString() {
            StringBuilder sb;
            Object textLocale;
            String fontVariationSettings;
            StringBuilder sb2 = new StringBuilder("{");
            sb2.append("textSize=" + this.f2181a.getTextSize());
            sb2.append(", textScaleX=" + this.f2181a.getTextScaleX());
            sb2.append(", textSkewX=" + this.f2181a.getTextSkewX());
            int i10 = Build.VERSION.SDK_INT;
            sb2.append(", letterSpacing=" + this.f2181a.getLetterSpacing());
            sb2.append(", elegantTextHeight=" + this.f2181a.isElegantTextHeight());
            if (i10 >= 24) {
                sb = new StringBuilder();
                sb.append(", textLocale=");
                textLocale = this.f2181a.getTextLocales();
            } else {
                sb = new StringBuilder();
                sb.append(", textLocale=");
                textLocale = this.f2181a.getTextLocale();
            }
            sb.append(textLocale);
            sb2.append(sb.toString());
            sb2.append(", typeface=" + this.f2181a.getTypeface());
            if (i10 >= 26) {
                StringBuilder sb3 = new StringBuilder();
                sb3.append(", variationSettings=");
                fontVariationSettings = this.f2181a.getFontVariationSettings();
                sb3.append(fontVariationSettings);
                sb2.append(sb3.toString());
            }
            sb2.append(", textDir=" + this.f2182b);
            sb2.append(", breakStrategy=" + this.f2183c);
            sb2.append(", hyphenationFrequency=" + this.f2184d);
            sb2.append("}");
            return sb2.toString();
        }
    }
}
