package androidx.core.graphics;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.graphics.fonts.FontVariationAxis;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import androidx.core.content.res.e;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Map;
import u.i;
/* loaded from: classes.dex */
public class i extends g {

    /* renamed from: g  reason: collision with root package name */
    protected final Class f2127g;

    /* renamed from: h  reason: collision with root package name */
    protected final Constructor f2128h;

    /* renamed from: i  reason: collision with root package name */
    protected final Method f2129i;

    /* renamed from: j  reason: collision with root package name */
    protected final Method f2130j;

    /* renamed from: k  reason: collision with root package name */
    protected final Method f2131k;

    /* renamed from: l  reason: collision with root package name */
    protected final Method f2132l;

    /* renamed from: m  reason: collision with root package name */
    protected final Method f2133m;

    public i() {
        Method method;
        Constructor constructor;
        Method method2;
        Method method3;
        Method method4;
        Method method5;
        Class cls = null;
        try {
            Class v9 = v();
            constructor = w(v9);
            method2 = s(v9);
            method3 = t(v9);
            method4 = x(v9);
            method5 = r(v9);
            method = u(v9);
            cls = v9;
        } catch (ClassNotFoundException | NoSuchMethodException e10) {
            Log.e("TypefaceCompatApi26Impl", "Unable to collect necessary methods for class " + e10.getClass().getName(), e10);
            method = null;
            constructor = null;
            method2 = null;
            method3 = null;
            method4 = null;
            method5 = null;
        }
        this.f2127g = cls;
        this.f2128h = constructor;
        this.f2129i = method2;
        this.f2130j = method3;
        this.f2131k = method4;
        this.f2132l = method5;
        this.f2133m = method;
    }

    private Object l() {
        try {
            return this.f2128h.newInstance(new Object[0]);
        } catch (IllegalAccessException | InstantiationException | InvocationTargetException unused) {
            return null;
        }
    }

    private void m(Object obj) {
        try {
            this.f2132l.invoke(obj, new Object[0]);
        } catch (IllegalAccessException | InvocationTargetException unused) {
        }
    }

    private boolean n(Context context, Object obj, String str, int i10, int i11, int i12, FontVariationAxis[] fontVariationAxisArr) {
        try {
            return ((Boolean) this.f2129i.invoke(obj, context.getAssets(), str, 0, Boolean.FALSE, Integer.valueOf(i10), Integer.valueOf(i11), Integer.valueOf(i12), fontVariationAxisArr)).booleanValue();
        } catch (IllegalAccessException | InvocationTargetException unused) {
            return false;
        }
    }

    private boolean o(Object obj, ByteBuffer byteBuffer, int i10, int i11, int i12) {
        try {
            return ((Boolean) this.f2130j.invoke(obj, byteBuffer, Integer.valueOf(i10), null, Integer.valueOf(i11), Integer.valueOf(i12))).booleanValue();
        } catch (IllegalAccessException | InvocationTargetException unused) {
            return false;
        }
    }

    private boolean p(Object obj) {
        try {
            return ((Boolean) this.f2131k.invoke(obj, new Object[0])).booleanValue();
        } catch (IllegalAccessException | InvocationTargetException unused) {
            return false;
        }
    }

    private boolean q() {
        if (this.f2129i == null) {
            Log.w("TypefaceCompatApi26Impl", "Unable to collect necessary private methods. Fallback to legacy implementation.");
        }
        return this.f2129i != null;
    }

    @Override // androidx.core.graphics.g, androidx.core.graphics.l
    public Typeface a(Context context, e.c cVar, Resources resources, int i10) {
        e.d[] a10;
        if (q()) {
            Object l10 = l();
            if (l10 == null) {
                return null;
            }
            for (e.d dVar : cVar.a()) {
                if (!n(context, l10, dVar.a(), dVar.c(), dVar.e(), dVar.f() ? 1 : 0, FontVariationAxis.fromFontVariationSettings(dVar.d()))) {
                    m(l10);
                    return null;
                }
            }
            if (p(l10)) {
                return i(l10);
            }
            return null;
        }
        return super.a(context, cVar, resources, i10);
    }

    /* JADX WARN: Type inference failed for: r12v2, types: [android.graphics.Typeface$Builder] */
    @Override // androidx.core.graphics.g, androidx.core.graphics.l
    public Typeface b(Context context, CancellationSignal cancellationSignal, i.b[] bVarArr, int i10) {
        Typeface i11;
        if (bVarArr.length < 1) {
            return null;
        }
        if (!q()) {
            i.b g10 = g(bVarArr, i10);
            try {
                ParcelFileDescriptor openFileDescriptor = context.getContentResolver().openFileDescriptor(g10.d(), "r", cancellationSignal);
                if (openFileDescriptor == null) {
                    if (openFileDescriptor != null) {
                        openFileDescriptor.close();
                    }
                    return null;
                }
                final FileDescriptor fileDescriptor = openFileDescriptor.getFileDescriptor();
                Typeface build = new Object(fileDescriptor) { // from class: android.graphics.Typeface$Builder
                    static {
                        throw new NoClassDefFoundError();
                    }

                    public native /* synthetic */ Typeface build();

                    public native /* synthetic */ Typeface$Builder setItalic(boolean z9);

                    public native /* synthetic */ Typeface$Builder setWeight(int i12);
                }.setWeight(g10.e()).setItalic(g10.f()).build();
                openFileDescriptor.close();
                return build;
            } catch (IOException unused) {
                return null;
            }
        }
        Map h10 = m.h(context, bVarArr, cancellationSignal);
        Object l10 = l();
        if (l10 == null) {
            return null;
        }
        boolean z9 = false;
        for (i.b bVar : bVarArr) {
            ByteBuffer byteBuffer = (ByteBuffer) h10.get(bVar.d());
            if (byteBuffer != null) {
                if (!o(l10, byteBuffer, bVar.c(), bVar.e(), bVar.f() ? 1 : 0)) {
                    m(l10);
                    return null;
                }
                z9 = true;
            }
        }
        if (!z9) {
            m(l10);
            return null;
        } else if (p(l10) && (i11 = i(l10)) != null) {
            return Typeface.create(i11, i10);
        } else {
            return null;
        }
    }

    @Override // androidx.core.graphics.l
    public Typeface d(Context context, Resources resources, int i10, String str, int i11) {
        if (q()) {
            Object l10 = l();
            if (l10 == null) {
                return null;
            }
            if (!n(context, l10, str, 0, -1, -1, null)) {
                m(l10);
                return null;
            } else if (p(l10)) {
                return i(l10);
            } else {
                return null;
            }
        }
        return super.d(context, resources, i10, str, i11);
    }

    protected Typeface i(Object obj) {
        try {
            Object newInstance = Array.newInstance(this.f2127g, 1);
            Array.set(newInstance, 0, obj);
            return (Typeface) this.f2133m.invoke(null, newInstance, -1, -1);
        } catch (IllegalAccessException | InvocationTargetException unused) {
            return null;
        }
    }

    protected Method r(Class cls) {
        return cls.getMethod("abortCreation", new Class[0]);
    }

    protected Method s(Class cls) {
        Class<?> cls2 = Integer.TYPE;
        return cls.getMethod("addFontFromAssetManager", AssetManager.class, String.class, cls2, Boolean.TYPE, cls2, cls2, cls2, FontVariationAxis[].class);
    }

    protected Method t(Class cls) {
        Class<?> cls2 = Integer.TYPE;
        return cls.getMethod("addFontFromBuffer", ByteBuffer.class, cls2, FontVariationAxis[].class, cls2, cls2);
    }

    protected Method u(Class cls) {
        Class cls2 = Integer.TYPE;
        Method declaredMethod = Typeface.class.getDeclaredMethod("createFromFamiliesWithDefault", Array.newInstance(cls, 1).getClass(), cls2, cls2);
        declaredMethod.setAccessible(true);
        return declaredMethod;
    }

    protected Class v() {
        return Class.forName("android.graphics.FontFamily");
    }

    protected Constructor w(Class cls) {
        return cls.getConstructor(new Class[0]);
    }

    protected Method x(Class cls) {
        return cls.getMethod("freeze", new Class[0]);
    }
}
