package androidx.core.graphics;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import androidx.core.content.res.e;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import u.i;
/* loaded from: classes.dex */
class g extends l {

    /* renamed from: b  reason: collision with root package name */
    private static Class f2118b = null;

    /* renamed from: c  reason: collision with root package name */
    private static Constructor f2119c = null;

    /* renamed from: d  reason: collision with root package name */
    private static Method f2120d = null;

    /* renamed from: e  reason: collision with root package name */
    private static Method f2121e = null;

    /* renamed from: f  reason: collision with root package name */
    private static boolean f2122f = false;

    private static boolean h(Object obj, String str, int i10, boolean z9) {
        k();
        try {
            return ((Boolean) f2120d.invoke(obj, str, Integer.valueOf(i10), Boolean.valueOf(z9))).booleanValue();
        } catch (IllegalAccessException | InvocationTargetException e10) {
            throw new RuntimeException(e10);
        }
    }

    private static Typeface i(Object obj) {
        k();
        try {
            Object newInstance = Array.newInstance(f2118b, 1);
            Array.set(newInstance, 0, obj);
            return (Typeface) f2121e.invoke(null, newInstance);
        } catch (IllegalAccessException | InvocationTargetException e10) {
            throw new RuntimeException(e10);
        }
    }

    private File j(ParcelFileDescriptor parcelFileDescriptor) {
        try {
            String readlink = Os.readlink("/proc/self/fd/" + parcelFileDescriptor.getFd());
            if (OsConstants.S_ISREG(Os.stat(readlink).st_mode)) {
                return new File(readlink);
            }
        } catch (ErrnoException unused) {
        }
        return null;
    }

    private static void k() {
        Method method;
        Class<?> cls;
        Method method2;
        if (f2122f) {
            return;
        }
        f2122f = true;
        Constructor<?> constructor = null;
        try {
            cls = Class.forName("android.graphics.FontFamily");
            Constructor<?> constructor2 = cls.getConstructor(new Class[0]);
            method2 = cls.getMethod("addFontWeightStyle", String.class, Integer.TYPE, Boolean.TYPE);
            method = Typeface.class.getMethod("createFromFamiliesWithDefault", Array.newInstance(cls, 1).getClass());
            constructor = constructor2;
        } catch (ClassNotFoundException | NoSuchMethodException e10) {
            Log.e("TypefaceCompatApi21Impl", e10.getClass().getName(), e10);
            method = null;
            cls = null;
            method2 = null;
        }
        f2119c = constructor;
        f2118b = cls;
        f2120d = method2;
        f2121e = method;
    }

    private static Object l() {
        k();
        try {
            return f2119c.newInstance(new Object[0]);
        } catch (IllegalAccessException | InstantiationException | InvocationTargetException e10) {
            throw new RuntimeException(e10);
        }
    }

    @Override // androidx.core.graphics.l
    public Typeface a(Context context, e.c cVar, Resources resources, int i10) {
        e.d[] a10;
        Object l10 = l();
        for (e.d dVar : cVar.a()) {
            File e10 = m.e(context);
            if (e10 == null) {
                return null;
            }
            try {
                if (!m.c(e10, resources, dVar.b())) {
                    return null;
                }
                if (!h(l10, e10.getPath(), dVar.e(), dVar.f())) {
                    return null;
                }
            } catch (RuntimeException unused) {
                return null;
            } finally {
                e10.delete();
            }
        }
        return i(l10);
    }

    @Override // androidx.core.graphics.l
    public Typeface b(Context context, CancellationSignal cancellationSignal, i.b[] bVarArr, int i10) {
        if (bVarArr.length < 1) {
            return null;
        }
        i.b g10 = g(bVarArr, i10);
        try {
            ParcelFileDescriptor openFileDescriptor = context.getContentResolver().openFileDescriptor(g10.d(), "r", cancellationSignal);
            if (openFileDescriptor == null) {
                if (openFileDescriptor != null) {
                    openFileDescriptor.close();
                }
                return null;
            }
            File j10 = j(openFileDescriptor);
            if (j10 != null && j10.canRead()) {
                Typeface createFromFile = Typeface.createFromFile(j10);
                openFileDescriptor.close();
                return createFromFile;
            }
            FileInputStream fileInputStream = new FileInputStream(openFileDescriptor.getFileDescriptor());
            Typeface c10 = super.c(context, fileInputStream);
            fileInputStream.close();
            openFileDescriptor.close();
            return c10;
        } catch (IOException unused) {
            return null;
        }
    }
}
