package androidx.core.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
/* loaded from: classes.dex */
abstract class l extends Drawable implements Drawable.Callback, k, j {

    /* renamed from: m  reason: collision with root package name */
    static final PorterDuff.Mode f2099m = PorterDuff.Mode.SRC_IN;

    /* renamed from: g  reason: collision with root package name */
    private int f2100g;

    /* renamed from: h  reason: collision with root package name */
    private PorterDuff.Mode f2101h;

    /* renamed from: i  reason: collision with root package name */
    private boolean f2102i;

    /* renamed from: j  reason: collision with root package name */
    n f2103j;

    /* renamed from: k  reason: collision with root package name */
    private boolean f2104k;

    /* renamed from: l  reason: collision with root package name */
    Drawable f2105l;

    /* JADX INFO: Access modifiers changed from: package-private */
    public l(Drawable drawable) {
        this.f2103j = d();
        a(drawable);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public l(n nVar, Resources resources) {
        this.f2103j = nVar;
        e(resources);
    }

    private n d() {
        return new n(this.f2103j);
    }

    private void e(Resources resources) {
        Drawable.ConstantState constantState;
        n nVar = this.f2103j;
        if (nVar == null || (constantState = nVar.f2108b) == null) {
            return;
        }
        a(constantState.newDrawable(resources));
    }

    private boolean f(int[] iArr) {
        if (c()) {
            n nVar = this.f2103j;
            ColorStateList colorStateList = nVar.f2109c;
            PorterDuff.Mode mode = nVar.f2110d;
            if (colorStateList == null || mode == null) {
                this.f2102i = false;
                clearColorFilter();
            } else {
                int colorForState = colorStateList.getColorForState(iArr, colorStateList.getDefaultColor());
                if (!this.f2102i || colorForState != this.f2100g || mode != this.f2101h) {
                    setColorFilter(colorForState, mode);
                    this.f2100g = colorForState;
                    this.f2101h = mode;
                    this.f2102i = true;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override // androidx.core.graphics.drawable.k
    public final void a(Drawable drawable) {
        Drawable drawable2 = this.f2105l;
        if (drawable2 != null) {
            drawable2.setCallback(null);
        }
        this.f2105l = drawable;
        if (drawable != null) {
            drawable.setCallback(this);
            setVisible(drawable.isVisible(), true);
            setState(drawable.getState());
            setLevel(drawable.getLevel());
            setBounds(drawable.getBounds());
            n nVar = this.f2103j;
            if (nVar != null) {
                nVar.f2108b = drawable.getConstantState();
            }
        }
        invalidateSelf();
    }

    @Override // androidx.core.graphics.drawable.k
    public final Drawable b() {
        return this.f2105l;
    }

    protected abstract boolean c();

    @Override // android.graphics.drawable.Drawable
    public void draw(Canvas canvas) {
        this.f2105l.draw(canvas);
    }

    @Override // android.graphics.drawable.Drawable
    public int getChangingConfigurations() {
        int changingConfigurations = super.getChangingConfigurations();
        n nVar = this.f2103j;
        return changingConfigurations | (nVar != null ? nVar.getChangingConfigurations() : 0) | this.f2105l.getChangingConfigurations();
    }

    @Override // android.graphics.drawable.Drawable
    public Drawable.ConstantState getConstantState() {
        n nVar = this.f2103j;
        if (nVar == null || !nVar.a()) {
            return null;
        }
        this.f2103j.f2107a = getChangingConfigurations();
        return this.f2103j;
    }

    @Override // android.graphics.drawable.Drawable
    public Drawable getCurrent() {
        return this.f2105l.getCurrent();
    }

    @Override // android.graphics.drawable.Drawable
    public int getIntrinsicHeight() {
        return this.f2105l.getIntrinsicHeight();
    }

    @Override // android.graphics.drawable.Drawable
    public int getIntrinsicWidth() {
        return this.f2105l.getIntrinsicWidth();
    }

    @Override // android.graphics.drawable.Drawable
    public int getLayoutDirection() {
        return a.f(this.f2105l);
    }

    @Override // android.graphics.drawable.Drawable
    public int getMinimumHeight() {
        return this.f2105l.getMinimumHeight();
    }

    @Override // android.graphics.drawable.Drawable
    public int getMinimumWidth() {
        return this.f2105l.getMinimumWidth();
    }

    @Override // android.graphics.drawable.Drawable
    public int getOpacity() {
        return this.f2105l.getOpacity();
    }

    @Override // android.graphics.drawable.Drawable
    public boolean getPadding(Rect rect) {
        return this.f2105l.getPadding(rect);
    }

    @Override // android.graphics.drawable.Drawable
    public int[] getState() {
        return this.f2105l.getState();
    }

    @Override // android.graphics.drawable.Drawable
    public Region getTransparentRegion() {
        return this.f2105l.getTransparentRegion();
    }

    @Override // android.graphics.drawable.Drawable.Callback
    public void invalidateDrawable(Drawable drawable) {
        invalidateSelf();
    }

    @Override // android.graphics.drawable.Drawable
    public boolean isAutoMirrored() {
        return a.h(this.f2105l);
    }

    @Override // android.graphics.drawable.Drawable
    public boolean isStateful() {
        n nVar;
        ColorStateList colorStateList = (!c() || (nVar = this.f2103j) == null) ? null : nVar.f2109c;
        return (colorStateList != null && colorStateList.isStateful()) || this.f2105l.isStateful();
    }

    @Override // android.graphics.drawable.Drawable
    public void jumpToCurrentState() {
        this.f2105l.jumpToCurrentState();
    }

    @Override // android.graphics.drawable.Drawable
    public Drawable mutate() {
        if (!this.f2104k && super.mutate() == this) {
            this.f2103j = d();
            Drawable drawable = this.f2105l;
            if (drawable != null) {
                drawable.mutate();
            }
            n nVar = this.f2103j;
            if (nVar != null) {
                Drawable drawable2 = this.f2105l;
                nVar.f2108b = drawable2 != null ? drawable2.getConstantState() : null;
            }
            this.f2104k = true;
        }
        return this;
    }

    @Override // android.graphics.drawable.Drawable
    protected void onBoundsChange(Rect rect) {
        Drawable drawable = this.f2105l;
        if (drawable != null) {
            drawable.setBounds(rect);
        }
    }

    @Override // android.graphics.drawable.Drawable
    public boolean onLayoutDirectionChanged(int i10) {
        return a.m(this.f2105l, i10);
    }

    @Override // android.graphics.drawable.Drawable
    protected boolean onLevelChange(int i10) {
        return this.f2105l.setLevel(i10);
    }

    @Override // android.graphics.drawable.Drawable.Callback
    public void scheduleDrawable(Drawable drawable, Runnable runnable, long j10) {
        scheduleSelf(runnable, j10);
    }

    @Override // android.graphics.drawable.Drawable
    public void setAlpha(int i10) {
        this.f2105l.setAlpha(i10);
    }

    @Override // android.graphics.drawable.Drawable
    public void setAutoMirrored(boolean z9) {
        a.j(this.f2105l, z9);
    }

    @Override // android.graphics.drawable.Drawable
    public void setChangingConfigurations(int i10) {
        this.f2105l.setChangingConfigurations(i10);
    }

    @Override // android.graphics.drawable.Drawable
    public void setColorFilter(ColorFilter colorFilter) {
        this.f2105l.setColorFilter(colorFilter);
    }

    @Override // android.graphics.drawable.Drawable
    public void setDither(boolean z9) {
        this.f2105l.setDither(z9);
    }

    @Override // android.graphics.drawable.Drawable
    public void setFilterBitmap(boolean z9) {
        this.f2105l.setFilterBitmap(z9);
    }

    @Override // android.graphics.drawable.Drawable
    public boolean setState(int[] iArr) {
        return f(iArr) || this.f2105l.setState(iArr);
    }

    @Override // android.graphics.drawable.Drawable
    public void setTint(int i10) {
        setTintList(ColorStateList.valueOf(i10));
    }

    @Override // android.graphics.drawable.Drawable
    public void setTintList(ColorStateList colorStateList) {
        this.f2103j.f2109c = colorStateList;
        f(getState());
    }

    @Override // android.graphics.drawable.Drawable
    public void setTintMode(PorterDuff.Mode mode) {
        this.f2103j.f2110d = mode;
        f(getState());
    }

    @Override // android.graphics.drawable.Drawable
    public boolean setVisible(boolean z9, boolean z10) {
        return super.setVisible(z9, z10) || this.f2105l.setVisible(z9, z10);
    }

    @Override // android.graphics.drawable.Drawable.Callback
    public void unscheduleDrawable(Drawable drawable, Runnable runnable) {
        unscheduleSelf(runnable);
    }
}
