package androidx.core.graphics.drawable;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Shader;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.versionedparcelable.CustomVersionedParcelable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
/* loaded from: classes.dex */
public class IconCompat extends CustomVersionedParcelable {

    /* renamed from: k  reason: collision with root package name */
    static final PorterDuff.Mode f2084k = PorterDuff.Mode.SRC_IN;

    /* renamed from: b  reason: collision with root package name */
    Object f2086b;

    /* renamed from: j  reason: collision with root package name */
    public String f2094j;

    /* renamed from: a  reason: collision with root package name */
    public int f2085a = -1;

    /* renamed from: c  reason: collision with root package name */
    public byte[] f2087c = null;

    /* renamed from: d  reason: collision with root package name */
    public Parcelable f2088d = null;

    /* renamed from: e  reason: collision with root package name */
    public int f2089e = 0;

    /* renamed from: f  reason: collision with root package name */
    public int f2090f = 0;

    /* renamed from: g  reason: collision with root package name */
    public ColorStateList f2091g = null;

    /* renamed from: h  reason: collision with root package name */
    PorterDuff.Mode f2092h = f2084k;

    /* renamed from: i  reason: collision with root package name */
    public String f2093i = null;

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class a {
        static int a(Object obj) {
            if (Build.VERSION.SDK_INT >= 28) {
                return c.a(obj);
            }
            try {
                return ((Integer) obj.getClass().getMethod("getResId", new Class[0]).invoke(obj, new Object[0])).intValue();
            } catch (IllegalAccessException e10) {
                Log.e("IconCompat", "Unable to get icon resource", e10);
                return 0;
            } catch (NoSuchMethodException e11) {
                Log.e("IconCompat", "Unable to get icon resource", e11);
                return 0;
            } catch (InvocationTargetException e12) {
                Log.e("IconCompat", "Unable to get icon resource", e12);
                return 0;
            }
        }

        static String b(Object obj) {
            if (Build.VERSION.SDK_INT >= 28) {
                return c.b(obj);
            }
            try {
                return (String) obj.getClass().getMethod("getResPackage", new Class[0]).invoke(obj, new Object[0]);
            } catch (IllegalAccessException e10) {
                Log.e("IconCompat", "Unable to get icon package", e10);
                return null;
            } catch (NoSuchMethodException e11) {
                Log.e("IconCompat", "Unable to get icon package", e11);
                return null;
            } catch (InvocationTargetException e12) {
                Log.e("IconCompat", "Unable to get icon package", e12);
                return null;
            }
        }

        static Uri c(Object obj) {
            if (Build.VERSION.SDK_INT >= 28) {
                return c.d(obj);
            }
            try {
                return (Uri) obj.getClass().getMethod("getUri", new Class[0]).invoke(obj, new Object[0]);
            } catch (IllegalAccessException e10) {
                Log.e("IconCompat", "Unable to get icon uri", e10);
                return null;
            } catch (NoSuchMethodException e11) {
                Log.e("IconCompat", "Unable to get icon uri", e11);
                return null;
            } catch (InvocationTargetException e12) {
                Log.e("IconCompat", "Unable to get icon uri", e12);
                return null;
            }
        }

        static Drawable d(Icon icon, Context context) {
            return icon.loadDrawable(context);
        }

        /* JADX WARN: Code restructure failed: missing block: B:13:0x002c, code lost:
            if (r0 >= 26) goto L23;
         */
        /*
            Code decompiled incorrectly, please refer to instructions dump.
        */
        static Icon e(IconCompat iconCompat, Context context) {
            Bitmap bitmap;
            Icon createWithResource;
            Bitmap bitmap2;
            switch (iconCompat.f2085a) {
                case -1:
                    return (Icon) iconCompat.f2086b;
                case 0:
                default:
                    throw new IllegalArgumentException("Unknown type");
                case 1:
                    bitmap = (Bitmap) iconCompat.f2086b;
                    createWithResource = Icon.createWithBitmap(bitmap);
                    break;
                case 2:
                    createWithResource = Icon.createWithResource(iconCompat.d(), iconCompat.f2089e);
                    break;
                case 3:
                    createWithResource = Icon.createWithData((byte[]) iconCompat.f2086b, iconCompat.f2089e, iconCompat.f2090f);
                    break;
                case 4:
                    createWithResource = Icon.createWithContentUri((String) iconCompat.f2086b);
                    break;
                case 5:
                    if (Build.VERSION.SDK_INT < 26) {
                        bitmap2 = (Bitmap) iconCompat.f2086b;
                        bitmap = IconCompat.a(bitmap2, false);
                        createWithResource = Icon.createWithBitmap(bitmap);
                        break;
                    } else {
                        bitmap2 = (Bitmap) iconCompat.f2086b;
                        createWithResource = b.b(bitmap2);
                        break;
                    }
                case 6:
                    int i10 = Build.VERSION.SDK_INT;
                    if (i10 >= 30) {
                        createWithResource = d.a(iconCompat.e());
                        break;
                    } else if (context == null) {
                        throw new IllegalArgumentException("Context is required to resolve the file uri of the icon: " + iconCompat.e());
                    } else {
                        InputStream f10 = iconCompat.f(context);
                        if (f10 == null) {
                            throw new IllegalStateException("Cannot load adaptive icon from uri: " + iconCompat.e());
                        }
                        bitmap2 = BitmapFactory.decodeStream(f10);
                        break;
                    }
            }
            ColorStateList colorStateList = iconCompat.f2091g;
            if (colorStateList != null) {
                createWithResource.setTintList(colorStateList);
            }
            PorterDuff.Mode mode = iconCompat.f2092h;
            if (mode != IconCompat.f2084k) {
                createWithResource.setTintMode(mode);
            }
            return createWithResource;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class b {
        static Drawable a(Drawable drawable, Drawable drawable2) {
            return new AdaptiveIconDrawable(drawable, drawable2);
        }

        static Icon b(Bitmap bitmap) {
            Icon createWithAdaptiveBitmap;
            createWithAdaptiveBitmap = Icon.createWithAdaptiveBitmap(bitmap);
            return createWithAdaptiveBitmap;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class c {
        static int a(Object obj) {
            int resId;
            resId = ((Icon) obj).getResId();
            return resId;
        }

        static String b(Object obj) {
            String resPackage;
            resPackage = ((Icon) obj).getResPackage();
            return resPackage;
        }

        static int c(Object obj) {
            int type;
            type = ((Icon) obj).getType();
            return type;
        }

        static Uri d(Object obj) {
            Uri uri;
            uri = ((Icon) obj).getUri();
            return uri;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class d {
        static Icon a(Uri uri) {
            Icon createWithAdaptiveBitmapContentUri;
            createWithAdaptiveBitmapContentUri = Icon.createWithAdaptiveBitmapContentUri(uri);
            return createWithAdaptiveBitmapContentUri;
        }
    }

    static Bitmap a(Bitmap bitmap, boolean z9) {
        int min = (int) (Math.min(bitmap.getWidth(), bitmap.getHeight()) * 0.6666667f);
        Bitmap createBitmap = Bitmap.createBitmap(min, min, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(createBitmap);
        Paint paint = new Paint(3);
        float f10 = min;
        float f11 = 0.5f * f10;
        float f12 = 0.9166667f * f11;
        if (z9) {
            float f13 = 0.010416667f * f10;
            paint.setColor(0);
            paint.setShadowLayer(f13, 0.0f, f10 * 0.020833334f, 1023410176);
            canvas.drawCircle(f11, f11, f12, paint);
            paint.setShadowLayer(f13, 0.0f, 0.0f, 503316480);
            canvas.drawCircle(f11, f11, f12, paint);
            paint.clearShadowLayer();
        }
        paint.setColor(-16777216);
        Shader.TileMode tileMode = Shader.TileMode.CLAMP;
        BitmapShader bitmapShader = new BitmapShader(bitmap, tileMode, tileMode);
        Matrix matrix = new Matrix();
        matrix.setTranslate((-(bitmap.getWidth() - min)) / 2.0f, (-(bitmap.getHeight() - min)) / 2.0f);
        bitmapShader.setLocalMatrix(matrix);
        paint.setShader(bitmapShader);
        canvas.drawCircle(f11, f11, f12, paint);
        canvas.setBitmap(null);
        return createBitmap;
    }

    private static String j(int i10) {
        switch (i10) {
            case 1:
                return "BITMAP";
            case 2:
                return "RESOURCE";
            case 3:
                return "DATA";
            case 4:
                return "URI";
            case 5:
                return "BITMAP_MASKABLE";
            case 6:
                return "URI_MASKABLE";
            default:
                return "UNKNOWN";
        }
    }

    public Bitmap b() {
        int i10 = this.f2085a;
        if (i10 == -1 && Build.VERSION.SDK_INT >= 23) {
            Object obj = this.f2086b;
            if (obj instanceof Bitmap) {
                return (Bitmap) obj;
            }
            return null;
        } else if (i10 == 1) {
            return (Bitmap) this.f2086b;
        } else {
            if (i10 == 5) {
                return a((Bitmap) this.f2086b, true);
            }
            throw new IllegalStateException("called getBitmap() on " + this);
        }
    }

    public int c() {
        int i10 = this.f2085a;
        if (i10 != -1 || Build.VERSION.SDK_INT < 23) {
            if (i10 == 2) {
                return this.f2089e;
            }
            throw new IllegalStateException("called getResId() on " + this);
        }
        return a.a(this.f2086b);
    }

    public String d() {
        int i10 = this.f2085a;
        if (i10 != -1 || Build.VERSION.SDK_INT < 23) {
            if (i10 == 2) {
                String str = this.f2094j;
                return (str == null || TextUtils.isEmpty(str)) ? ((String) this.f2086b).split(":", -1)[0] : this.f2094j;
            }
            throw new IllegalStateException("called getResPackage() on " + this);
        }
        return a.b(this.f2086b);
    }

    public Uri e() {
        int i10 = this.f2085a;
        if (i10 != -1 || Build.VERSION.SDK_INT < 23) {
            if (i10 == 4 || i10 == 6) {
                return Uri.parse((String) this.f2086b);
            }
            throw new IllegalStateException("called getUri() on " + this);
        }
        return a.c(this.f2086b);
    }

    public InputStream f(Context context) {
        StringBuilder sb;
        String str;
        Uri e10 = e();
        String scheme = e10.getScheme();
        if ("content".equals(scheme) || "file".equals(scheme)) {
            try {
                return context.getContentResolver().openInputStream(e10);
            } catch (Exception e11) {
                e = e11;
                sb = new StringBuilder();
                str = "Unable to load image from URI: ";
            }
        } else {
            try {
                return new FileInputStream(new File((String) this.f2086b));
            } catch (FileNotFoundException e12) {
                e = e12;
                sb = new StringBuilder();
                str = "Unable to load image from path: ";
            }
        }
        sb.append(str);
        sb.append(e10);
        Log.w("IconCompat", sb.toString(), e);
        return null;
    }

    public void g() {
        Parcelable parcelable;
        this.f2092h = PorterDuff.Mode.valueOf(this.f2093i);
        switch (this.f2085a) {
            case -1:
                parcelable = this.f2088d;
                if (parcelable == null) {
                    throw new IllegalArgumentException("Invalid icon");
                }
                break;
            case 0:
            default:
                return;
            case 1:
            case 5:
                parcelable = this.f2088d;
                if (parcelable == null) {
                    byte[] bArr = this.f2087c;
                    this.f2086b = bArr;
                    this.f2085a = 3;
                    this.f2089e = 0;
                    this.f2090f = bArr.length;
                    return;
                }
                break;
            case 2:
            case 4:
            case 6:
                String str = new String(this.f2087c, Charset.forName("UTF-16"));
                this.f2086b = str;
                if (this.f2085a == 2 && this.f2094j == null) {
                    this.f2094j = str.split(":", -1)[0];
                    return;
                }
                return;
            case 3:
                this.f2086b = this.f2087c;
                return;
        }
        this.f2086b = parcelable;
    }

    public void h(boolean z9) {
        this.f2093i = this.f2092h.name();
        switch (this.f2085a) {
            case -1:
                if (z9) {
                    throw new IllegalArgumentException("Can't serialize Icon created with IconCompat#createFromIcon");
                }
                break;
            case 0:
            default:
                return;
            case 1:
            case 5:
                if (z9) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ((Bitmap) this.f2086b).compress(Bitmap.CompressFormat.PNG, 90, byteArrayOutputStream);
                    this.f2087c = byteArrayOutputStream.toByteArray();
                    return;
                }
                break;
            case 2:
                this.f2087c = ((String) this.f2086b).getBytes(Charset.forName("UTF-16"));
                return;
            case 3:
                this.f2087c = (byte[]) this.f2086b;
                return;
            case 4:
            case 6:
                this.f2087c = this.f2086b.toString().getBytes(Charset.forName("UTF-16"));
                return;
        }
        this.f2088d = (Parcelable) this.f2086b;
    }

    public Icon i(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            return a.e(this, context);
        }
        throw new UnsupportedOperationException("This method is only supported on API level 23+");
    }

    public String toString() {
        int height;
        if (this.f2085a == -1) {
            return String.valueOf(this.f2086b);
        }
        StringBuilder sb = new StringBuilder("Icon(typ=");
        sb.append(j(this.f2085a));
        switch (this.f2085a) {
            case 1:
            case 5:
                sb.append(" size=");
                sb.append(((Bitmap) this.f2086b).getWidth());
                sb.append("x");
                height = ((Bitmap) this.f2086b).getHeight();
                sb.append(height);
                break;
            case 2:
                sb.append(" pkg=");
                sb.append(this.f2094j);
                sb.append(" id=");
                sb.append(String.format("0x%08x", Integer.valueOf(c())));
                break;
            case 3:
                sb.append(" len=");
                sb.append(this.f2089e);
                if (this.f2090f != 0) {
                    sb.append(" off=");
                    height = this.f2090f;
                    sb.append(height);
                    break;
                }
                break;
            case 4:
            case 6:
                sb.append(" uri=");
                sb.append(this.f2086b);
                break;
        }
        if (this.f2091g != null) {
            sb.append(" tint=");
            sb.append(this.f2091g);
        }
        if (this.f2092h != f2084k) {
            sb.append(" mode=");
            sb.append(this.f2092h);
        }
        sb.append(")");
        return sb.toString();
    }
}
