package androidx.core.content.res;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import androidx.core.content.res.e;
import androidx.core.content.res.h;
import java.io.IOException;
import java.util.WeakHashMap;
import org.xmlpull.v1.XmlPullParserException;
/* loaded from: classes.dex */
public abstract class h {

    /* renamed from: a  reason: collision with root package name */
    private static final ThreadLocal f2054a = new ThreadLocal();

    /* renamed from: b  reason: collision with root package name */
    private static final WeakHashMap f2055b = new WeakHashMap(0);

    /* renamed from: c  reason: collision with root package name */
    private static final Object f2056c = new Object();

    /* loaded from: classes.dex */
    static class a {
        static Drawable a(Resources resources, int i10, Resources.Theme theme) {
            return resources.getDrawable(i10, theme);
        }

        static Drawable b(Resources resources, int i10, int i11, Resources.Theme theme) {
            return resources.getDrawableForDensity(i10, i11, theme);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class b {
        static int a(Resources resources, int i10, Resources.Theme theme) {
            int color;
            color = resources.getColor(i10, theme);
            return color;
        }

        static ColorStateList b(Resources resources, int i10, Resources.Theme theme) {
            ColorStateList colorStateList;
            colorStateList = resources.getColorStateList(i10, theme);
            return colorStateList;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class c {

        /* renamed from: a  reason: collision with root package name */
        final ColorStateList f2057a;

        /* renamed from: b  reason: collision with root package name */
        final Configuration f2058b;

        /* renamed from: c  reason: collision with root package name */
        final int f2059c;

        c(ColorStateList colorStateList, Configuration configuration, Resources.Theme theme) {
            this.f2057a = colorStateList;
            this.f2058b = configuration;
            this.f2059c = theme == null ? 0 : theme.hashCode();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static final class d {

        /* renamed from: a  reason: collision with root package name */
        final Resources f2060a;

        /* renamed from: b  reason: collision with root package name */
        final Resources.Theme f2061b;

        d(Resources resources, Resources.Theme theme) {
            this.f2060a = resources;
            this.f2061b = theme;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || d.class != obj.getClass()) {
                return false;
            }
            d dVar = (d) obj;
            return this.f2060a.equals(dVar.f2060a) && v.c.a(this.f2061b, dVar.f2061b);
        }

        public int hashCode() {
            return v.c.b(this.f2060a, this.f2061b);
        }
    }

    /* loaded from: classes.dex */
    public static abstract class e {
        public static Handler e(Handler handler) {
            return handler == null ? new Handler(Looper.getMainLooper()) : handler;
        }

        public final void c(final int i10, Handler handler) {
            e(handler).post(new Runnable() { // from class: androidx.core.content.res.l
                @Override // java.lang.Runnable
                public final void run() {
                    h.e.this.f(i10);
                }
            });
        }

        public final void d(final Typeface typeface, Handler handler) {
            e(handler).post(new Runnable() { // from class: androidx.core.content.res.k
                @Override // java.lang.Runnable
                public final void run() {
                    h.e.this.g(typeface);
                }
            });
        }

        /* renamed from: h */
        public abstract void f(int i10);

        /* renamed from: i */
        public abstract void g(Typeface typeface);
    }

    private static void a(d dVar, int i10, ColorStateList colorStateList, Resources.Theme theme) {
        synchronized (f2056c) {
            WeakHashMap weakHashMap = f2055b;
            SparseArray sparseArray = (SparseArray) weakHashMap.get(dVar);
            if (sparseArray == null) {
                sparseArray = new SparseArray();
                weakHashMap.put(dVar, sparseArray);
            }
            sparseArray.append(i10, new c(colorStateList, dVar.f2060a.getConfiguration(), theme));
        }
    }

    private static ColorStateList b(d dVar, int i10) {
        c cVar;
        Resources.Theme theme;
        synchronized (f2056c) {
            SparseArray sparseArray = (SparseArray) f2055b.get(dVar);
            if (sparseArray != null && sparseArray.size() > 0 && (cVar = (c) sparseArray.get(i10)) != null) {
                if (cVar.f2058b.equals(dVar.f2060a.getConfiguration()) && (((theme = dVar.f2061b) == null && cVar.f2059c == 0) || (theme != null && cVar.f2059c == theme.hashCode()))) {
                    return cVar.f2057a;
                }
                sparseArray.remove(i10);
            }
            return null;
        }
    }

    public static ColorStateList c(Resources resources, int i10, Resources.Theme theme) {
        d dVar = new d(resources, theme);
        ColorStateList b10 = b(dVar, i10);
        if (b10 != null) {
            return b10;
        }
        ColorStateList j10 = j(resources, i10, theme);
        if (j10 == null) {
            return Build.VERSION.SDK_INT >= 23 ? b.b(resources, i10, theme) : resources.getColorStateList(i10);
        }
        a(dVar, i10, j10, theme);
        return j10;
    }

    public static Drawable d(Resources resources, int i10, Resources.Theme theme) {
        return a.a(resources, i10, theme);
    }

    public static Drawable e(Resources resources, int i10, int i11, Resources.Theme theme) {
        return a.b(resources, i10, i11, theme);
    }

    public static Typeface f(Context context, int i10) {
        if (context.isRestricted()) {
            return null;
        }
        return l(context, i10, new TypedValue(), 0, null, null, false, false);
    }

    public static Typeface g(Context context, int i10, TypedValue typedValue, int i11, e eVar) {
        if (context.isRestricted()) {
            return null;
        }
        return l(context, i10, typedValue, i11, eVar, null, true, false);
    }

    public static void h(Context context, int i10, e eVar, Handler handler) {
        v.h.g(eVar);
        if (context.isRestricted()) {
            eVar.c(-4, handler);
        } else {
            l(context, i10, new TypedValue(), 0, eVar, handler, false, false);
        }
    }

    private static TypedValue i() {
        ThreadLocal threadLocal = f2054a;
        TypedValue typedValue = (TypedValue) threadLocal.get();
        if (typedValue == null) {
            TypedValue typedValue2 = new TypedValue();
            threadLocal.set(typedValue2);
            return typedValue2;
        }
        return typedValue;
    }

    private static ColorStateList j(Resources resources, int i10, Resources.Theme theme) {
        if (k(resources, i10)) {
            return null;
        }
        try {
            return androidx.core.content.res.c.a(resources, resources.getXml(i10), theme);
        } catch (Exception e10) {
            Log.w("ResourcesCompat", "Failed to inflate ColorStateList, leaving it to the framework", e10);
            return null;
        }
    }

    private static boolean k(Resources resources, int i10) {
        TypedValue i11 = i();
        resources.getValue(i10, i11, true);
        int i12 = i11.type;
        return i12 >= 28 && i12 <= 31;
    }

    private static Typeface l(Context context, int i10, TypedValue typedValue, int i11, e eVar, Handler handler, boolean z9, boolean z10) {
        Resources resources = context.getResources();
        resources.getValue(i10, typedValue, true);
        Typeface m10 = m(context, resources, typedValue, i10, i11, eVar, handler, z9, z10);
        if (m10 == null && eVar == null && !z10) {
            throw new Resources.NotFoundException("Font resource ID #0x" + Integer.toHexString(i10) + " could not be retrieved.");
        }
        return m10;
    }

    /* JADX WARN: Removed duplicated region for block: B:38:0x00aa  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    private static Typeface m(Context context, Resources resources, TypedValue typedValue, int i10, int i11, e eVar, Handler handler, boolean z9, boolean z10) {
        StringBuilder sb;
        String str;
        CharSequence charSequence = typedValue.string;
        if (charSequence == null) {
            throw new Resources.NotFoundException("Resource \"" + resources.getResourceName(i10) + "\" (" + Integer.toHexString(i10) + ") is not a Font: " + typedValue);
        }
        String charSequence2 = charSequence.toString();
        if (!charSequence2.startsWith("res/")) {
            if (eVar != null) {
                eVar.c(-3, handler);
            }
            return null;
        }
        Typeface f10 = androidx.core.graphics.f.f(resources, i10, charSequence2, typedValue.assetCookie, i11);
        if (f10 != null) {
            if (eVar != null) {
                eVar.d(f10, handler);
            }
            return f10;
        } else if (z10) {
            return null;
        } else {
            try {
                if (!charSequence2.toLowerCase().endsWith(".xml")) {
                    Typeface d10 = androidx.core.graphics.f.d(context, resources, i10, charSequence2, typedValue.assetCookie, i11);
                    if (eVar != null) {
                        if (d10 != null) {
                            eVar.d(d10, handler);
                        } else {
                            eVar.c(-3, handler);
                        }
                    }
                    return d10;
                }
                e.b b10 = androidx.core.content.res.e.b(resources.getXml(i10), resources);
                if (b10 == null) {
                    Log.e("ResourcesCompat", "Failed to find font-family tag");
                    if (eVar != null) {
                        eVar.c(-3, handler);
                    }
                    return null;
                }
                return androidx.core.graphics.f.c(context, b10, resources, i10, charSequence2, typedValue.assetCookie, i11, eVar, handler, z9);
            } catch (IOException e10) {
                e = e10;
                sb = new StringBuilder();
                str = "Failed to read xml resource ";
                sb.append(str);
                sb.append(charSequence2);
                Log.e("ResourcesCompat", sb.toString(), e);
                if (eVar != null) {
                    eVar.c(-3, handler);
                }
                return null;
            } catch (XmlPullParserException e11) {
                e = e11;
                sb = new StringBuilder();
                str = "Failed to parse xml resource ";
                sb.append(str);
                sb.append(charSequence2);
                Log.e("ResourcesCompat", sb.toString(), e);
                if (eVar != null) {
                }
                return null;
            }
        }
    }
}
