package androidx.core.content.res;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.Base64;
import android.util.Xml;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
/* loaded from: classes.dex */
public abstract class e {

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class a {
        static int a(TypedArray typedArray, int i10) {
            return typedArray.getType(i10);
        }
    }

    /* loaded from: classes.dex */
    public interface b {
    }

    /* loaded from: classes.dex */
    public static final class c implements b {

        /* renamed from: a  reason: collision with root package name */
        private final d[] f2041a;

        public c(d[] dVarArr) {
            this.f2041a = dVarArr;
        }

        public d[] a() {
            return this.f2041a;
        }
    }

    /* loaded from: classes.dex */
    public static final class d {

        /* renamed from: a  reason: collision with root package name */
        private final String f2042a;

        /* renamed from: b  reason: collision with root package name */
        private final int f2043b;

        /* renamed from: c  reason: collision with root package name */
        private final boolean f2044c;

        /* renamed from: d  reason: collision with root package name */
        private final String f2045d;

        /* renamed from: e  reason: collision with root package name */
        private final int f2046e;

        /* renamed from: f  reason: collision with root package name */
        private final int f2047f;

        public d(String str, int i10, boolean z9, String str2, int i11, int i12) {
            this.f2042a = str;
            this.f2043b = i10;
            this.f2044c = z9;
            this.f2045d = str2;
            this.f2046e = i11;
            this.f2047f = i12;
        }

        public String a() {
            return this.f2042a;
        }

        public int b() {
            return this.f2047f;
        }

        public int c() {
            return this.f2046e;
        }

        public String d() {
            return this.f2045d;
        }

        public int e() {
            return this.f2043b;
        }

        public boolean f() {
            return this.f2044c;
        }
    }

    /* renamed from: androidx.core.content.res.e$e  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public static final class C0014e implements b {

        /* renamed from: a  reason: collision with root package name */
        private final u.g f2048a;

        /* renamed from: b  reason: collision with root package name */
        private final int f2049b;

        /* renamed from: c  reason: collision with root package name */
        private final int f2050c;

        /* renamed from: d  reason: collision with root package name */
        private final String f2051d;

        public C0014e(u.g gVar, int i10, int i11, String str) {
            this.f2048a = gVar;
            this.f2050c = i10;
            this.f2049b = i11;
            this.f2051d = str;
        }

        public int a() {
            return this.f2050c;
        }

        public u.g b() {
            return this.f2048a;
        }

        public String c() {
            return this.f2051d;
        }

        public int d() {
            return this.f2049b;
        }
    }

    private static int a(TypedArray typedArray, int i10) {
        return a.a(typedArray, i10);
    }

    public static b b(XmlPullParser xmlPullParser, Resources resources) {
        int next;
        do {
            next = xmlPullParser.next();
            if (next == 2) {
                break;
            }
        } while (next != 1);
        if (next == 2) {
            return d(xmlPullParser, resources);
        }
        throw new XmlPullParserException("No start tag found");
    }

    public static List c(Resources resources, int i10) {
        if (i10 == 0) {
            return Collections.emptyList();
        }
        TypedArray obtainTypedArray = resources.obtainTypedArray(i10);
        try {
            if (obtainTypedArray.length() == 0) {
                return Collections.emptyList();
            }
            ArrayList arrayList = new ArrayList();
            if (a(obtainTypedArray, 0) == 1) {
                for (int i11 = 0; i11 < obtainTypedArray.length(); i11++) {
                    int resourceId = obtainTypedArray.getResourceId(i11, 0);
                    if (resourceId != 0) {
                        arrayList.add(h(resources.getStringArray(resourceId)));
                    }
                }
            } else {
                arrayList.add(h(resources.getStringArray(i10)));
            }
            return arrayList;
        } finally {
            obtainTypedArray.recycle();
        }
    }

    private static b d(XmlPullParser xmlPullParser, Resources resources) {
        xmlPullParser.require(2, null, "font-family");
        if (xmlPullParser.getName().equals("font-family")) {
            return e(xmlPullParser, resources);
        }
        g(xmlPullParser);
        return null;
    }

    private static b e(XmlPullParser xmlPullParser, Resources resources) {
        TypedArray obtainAttributes = resources.obtainAttributes(Xml.asAttributeSet(xmlPullParser), q.c.f11996h);
        String string = obtainAttributes.getString(q.c.f11997i);
        String string2 = obtainAttributes.getString(q.c.f12001m);
        String string3 = obtainAttributes.getString(q.c.f12002n);
        int resourceId = obtainAttributes.getResourceId(q.c.f11998j, 0);
        int integer = obtainAttributes.getInteger(q.c.f11999k, 1);
        int integer2 = obtainAttributes.getInteger(q.c.f12000l, 500);
        String string4 = obtainAttributes.getString(q.c.f12003o);
        obtainAttributes.recycle();
        if (string != null && string2 != null && string3 != null) {
            while (xmlPullParser.next() != 3) {
                g(xmlPullParser);
            }
            return new C0014e(new u.g(string, string2, string3, c(resources, resourceId)), integer, integer2, string4);
        }
        ArrayList arrayList = new ArrayList();
        while (xmlPullParser.next() != 3) {
            if (xmlPullParser.getEventType() == 2) {
                if (xmlPullParser.getName().equals("font")) {
                    arrayList.add(f(xmlPullParser, resources));
                } else {
                    g(xmlPullParser);
                }
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return new c((d[]) arrayList.toArray(new d[0]));
    }

    private static d f(XmlPullParser xmlPullParser, Resources resources) {
        TypedArray obtainAttributes = resources.obtainAttributes(Xml.asAttributeSet(xmlPullParser), q.c.f12004p);
        int i10 = q.c.f12013y;
        if (!obtainAttributes.hasValue(i10)) {
            i10 = q.c.f12006r;
        }
        int i11 = obtainAttributes.getInt(i10, 400);
        int i12 = q.c.f12011w;
        if (!obtainAttributes.hasValue(i12)) {
            i12 = q.c.f12007s;
        }
        boolean z9 = 1 == obtainAttributes.getInt(i12, 0);
        int i13 = q.c.f12014z;
        if (!obtainAttributes.hasValue(i13)) {
            i13 = q.c.f12008t;
        }
        int i14 = q.c.f12012x;
        if (!obtainAttributes.hasValue(i14)) {
            i14 = q.c.f12009u;
        }
        String string = obtainAttributes.getString(i14);
        int i15 = obtainAttributes.getInt(i13, 0);
        int i16 = q.c.f12010v;
        if (!obtainAttributes.hasValue(i16)) {
            i16 = q.c.f12005q;
        }
        int resourceId = obtainAttributes.getResourceId(i16, 0);
        String string2 = obtainAttributes.getString(i16);
        obtainAttributes.recycle();
        while (xmlPullParser.next() != 3) {
            g(xmlPullParser);
        }
        return new d(string2, i11, z9, string, i15, resourceId);
    }

    private static void g(XmlPullParser xmlPullParser) {
        int i10 = 1;
        while (i10 > 0) {
            int next = xmlPullParser.next();
            if (next == 2) {
                i10++;
            } else if (next == 3) {
                i10--;
            }
        }
    }

    private static List h(String[] strArr) {
        ArrayList arrayList = new ArrayList();
        for (String str : strArr) {
            arrayList.add(Base64.decode(str, 0));
        }
        return arrayList;
    }
}
