package androidx.core.content.res;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.StateSet;
import android.util.TypedValue;
import android.util.Xml;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
/* loaded from: classes.dex */
public abstract class c {

    /* renamed from: a  reason: collision with root package name */
    private static final ThreadLocal f2037a = new ThreadLocal();

    public static ColorStateList a(Resources resources, XmlPullParser xmlPullParser, Resources.Theme theme) {
        int next;
        AttributeSet asAttributeSet = Xml.asAttributeSet(xmlPullParser);
        do {
            next = xmlPullParser.next();
            if (next == 2) {
                break;
            }
        } while (next != 1);
        if (next == 2) {
            return b(resources, xmlPullParser, asAttributeSet, theme);
        }
        throw new XmlPullParserException("No start tag found");
    }

    public static ColorStateList b(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) {
        String name = xmlPullParser.getName();
        if (name.equals("selector")) {
            return e(resources, xmlPullParser, attributeSet, theme);
        }
        throw new XmlPullParserException(xmlPullParser.getPositionDescription() + ": invalid color state list tag " + name);
    }

    private static TypedValue c() {
        ThreadLocal threadLocal = f2037a;
        TypedValue typedValue = (TypedValue) threadLocal.get();
        if (typedValue == null) {
            TypedValue typedValue2 = new TypedValue();
            threadLocal.set(typedValue2);
            return typedValue2;
        }
        return typedValue;
    }

    public static ColorStateList d(Resources resources, int i10, Resources.Theme theme) {
        try {
            return a(resources, resources.getXml(i10), theme);
        } catch (Exception e10) {
            Log.e("CSLCompat", "Failed to inflate ColorStateList.", e10);
            return null;
        }
    }

    /* JADX WARN: Code restructure failed: missing block: B:27:0x0075, code lost:
        if (r9.hasValue(r12) != false) goto L25;
     */
    /* JADX WARN: Code restructure failed: missing block: B:32:0x0086, code lost:
        if (r9.hasValue(r12) != false) goto L30;
     */
    /* JADX WARN: Removed duplicated region for block: B:26:0x006f  */
    /* JADX WARN: Removed duplicated region for block: B:31:0x0080  */
    /* JADX WARN: Removed duplicated region for block: B:37:0x009c  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    private static ColorStateList e(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) {
        int depth;
        int color;
        int i10;
        int i11;
        int attributeCount;
        int i12;
        Resources resources2 = resources;
        int i13 = 1;
        int depth2 = xmlPullParser.getDepth() + 1;
        int[][] iArr = new int[20];
        int[] iArr2 = new int[20];
        int i14 = 0;
        while (true) {
            int next = xmlPullParser.next();
            if (next == i13 || ((depth = xmlPullParser.getDepth()) < depth2 && next == 3)) {
                break;
            }
            if (next == 2 && depth <= depth2 && xmlPullParser.getName().equals("item")) {
                TypedArray h10 = h(resources2, theme, attributeSet, q.c.f11990b);
                int i15 = q.c.f11991c;
                int resourceId = h10.getResourceId(i15, -1);
                if (resourceId != -1 && !f(resources2, resourceId)) {
                    try {
                        color = a(resources2, resources2.getXml(resourceId), theme).getDefaultColor();
                    } catch (Exception unused) {
                        i15 = q.c.f11991c;
                    }
                    float f10 = 1.0f;
                    i10 = q.c.f11992d;
                    if (!h10.hasValue(i10)) {
                        i10 = q.c.f11994f;
                    }
                    f10 = h10.getFloat(i10, 1.0f);
                    if (Build.VERSION.SDK_INT >= 31) {
                        i11 = q.c.f11993e;
                    }
                    i11 = q.c.f11995g;
                    float f11 = h10.getFloat(i11, -1.0f);
                    h10.recycle();
                    attributeCount = attributeSet.getAttributeCount();
                    int[] iArr3 = new int[attributeCount];
                    int i16 = 0;
                    for (i12 = 0; i12 < attributeCount; i12++) {
                        int attributeNameResource = attributeSet.getAttributeNameResource(i12);
                        if (attributeNameResource != 16843173 && attributeNameResource != 16843551 && attributeNameResource != q.a.f11960a && attributeNameResource != q.a.f11961b) {
                            int i17 = i16 + 1;
                            if (!attributeSet.getAttributeBooleanValue(i12, false)) {
                                attributeNameResource = -attributeNameResource;
                            }
                            iArr3[i16] = attributeNameResource;
                            i16 = i17;
                        }
                    }
                    int[] trimStateSet = StateSet.trimStateSet(iArr3, i16);
                    iArr2 = g.a(iArr2, i14, g(color, f10, f11));
                    iArr = (int[][]) g.b(iArr, i14, trimStateSet);
                    i14++;
                }
                color = h10.getColor(i15, -65281);
                float f102 = 1.0f;
                i10 = q.c.f11992d;
                if (!h10.hasValue(i10)) {
                }
                f102 = h10.getFloat(i10, 1.0f);
                if (Build.VERSION.SDK_INT >= 31) {
                }
                i11 = q.c.f11995g;
                float f112 = h10.getFloat(i11, -1.0f);
                h10.recycle();
                attributeCount = attributeSet.getAttributeCount();
                int[] iArr32 = new int[attributeCount];
                int i162 = 0;
                while (i12 < attributeCount) {
                }
                int[] trimStateSet2 = StateSet.trimStateSet(iArr32, i162);
                iArr2 = g.a(iArr2, i14, g(color, f102, f112));
                iArr = (int[][]) g.b(iArr, i14, trimStateSet2);
                i14++;
            }
            i13 = 1;
            resources2 = resources;
        }
        int[] iArr4 = new int[i14];
        int[][] iArr5 = new int[i14];
        System.arraycopy(iArr2, 0, iArr4, 0, i14);
        System.arraycopy(iArr, 0, iArr5, 0, i14);
        return new ColorStateList(iArr5, iArr4);
    }

    private static boolean f(Resources resources, int i10) {
        TypedValue c10 = c();
        resources.getValue(i10, c10, true);
        int i11 = c10.type;
        return i11 >= 28 && i11 <= 31;
    }

    private static int g(int i10, float f10, float f11) {
        boolean z9 = f11 >= 0.0f && f11 <= 100.0f;
        if (f10 != 1.0f || z9) {
            int b10 = s.a.b((int) ((Color.alpha(i10) * f10) + 0.5f), 0, 255);
            if (z9) {
                a c10 = a.c(i10);
                i10 = a.m(c10.j(), c10.i(), f11);
            }
            return (i10 & 16777215) | (b10 << 24);
        }
        return i10;
    }

    private static TypedArray h(Resources resources, Resources.Theme theme, AttributeSet attributeSet, int[] iArr) {
        return theme == null ? resources.obtainAttributes(attributeSet, iArr) : theme.obtainStyledAttributes(attributeSet, iArr, 0, 0);
    }
}
