package androidx.core.app;

import android.app.Notification;
import android.app.PendingIntent;
import android.app.RemoteInput;
import android.content.Context;
import android.content.LocusId;
import android.graphics.drawable.Icon;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.RemoteViews;
import androidx.core.app.p;
import androidx.core.graphics.drawable.IconCompat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
/* loaded from: classes.dex */
class q {

    /* renamed from: a  reason: collision with root package name */
    private final Context f2010a;

    /* renamed from: b  reason: collision with root package name */
    private final Notification.Builder f2011b;

    /* renamed from: c  reason: collision with root package name */
    private final p.c f2012c;

    /* renamed from: d  reason: collision with root package name */
    private RemoteViews f2013d;

    /* renamed from: e  reason: collision with root package name */
    private RemoteViews f2014e;

    /* renamed from: f  reason: collision with root package name */
    private final List f2015f = new ArrayList();

    /* renamed from: g  reason: collision with root package name */
    private final Bundle f2016g = new Bundle();

    /* renamed from: h  reason: collision with root package name */
    private int f2017h;

    /* renamed from: i  reason: collision with root package name */
    private RemoteViews f2018i;

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class a {
        static Notification.Builder a(Notification.Builder builder, Notification.Action action) {
            return builder.addAction(action);
        }

        static Notification.Action.Builder b(Notification.Action.Builder builder, Bundle bundle) {
            return builder.addExtras(bundle);
        }

        static Notification.Action.Builder c(Notification.Action.Builder builder, RemoteInput remoteInput) {
            return builder.addRemoteInput(remoteInput);
        }

        static Notification.Action d(Notification.Action.Builder builder) {
            return builder.build();
        }

        static Notification.Action.Builder e(int i10, CharSequence charSequence, PendingIntent pendingIntent) {
            return new Notification.Action.Builder(i10, charSequence, pendingIntent);
        }

        static String f(Notification notification) {
            return notification.getGroup();
        }

        static Notification.Builder g(Notification.Builder builder, String str) {
            return builder.setGroup(str);
        }

        static Notification.Builder h(Notification.Builder builder, boolean z9) {
            return builder.setGroupSummary(z9);
        }

        static Notification.Builder i(Notification.Builder builder, boolean z9) {
            return builder.setLocalOnly(z9);
        }

        static Notification.Builder j(Notification.Builder builder, String str) {
            return builder.setSortKey(str);
        }
    }

    /* loaded from: classes.dex */
    static class b {
        static Notification.Builder a(Notification.Builder builder, String str) {
            return builder.addPerson(str);
        }

        static Notification.Builder b(Notification.Builder builder, String str) {
            return builder.setCategory(str);
        }

        static Notification.Builder c(Notification.Builder builder, int i10) {
            return builder.setColor(i10);
        }

        static Notification.Builder d(Notification.Builder builder, Notification notification) {
            return builder.setPublicVersion(notification);
        }

        static Notification.Builder e(Notification.Builder builder, Uri uri, Object obj) {
            return builder.setSound(uri, (AudioAttributes) obj);
        }

        static Notification.Builder f(Notification.Builder builder, int i10) {
            return builder.setVisibility(i10);
        }
    }

    /* loaded from: classes.dex */
    static class c {
        static Notification.Action.Builder a(Icon icon, CharSequence charSequence, PendingIntent pendingIntent) {
            return new Notification.Action.Builder(icon, charSequence, pendingIntent);
        }

        static Notification.Builder b(Notification.Builder builder, Icon icon) {
            Notification.Builder largeIcon;
            largeIcon = builder.setLargeIcon(icon);
            return largeIcon;
        }

        static Notification.Builder c(Notification.Builder builder, Object obj) {
            Notification.Builder smallIcon;
            smallIcon = builder.setSmallIcon((Icon) obj);
            return smallIcon;
        }
    }

    /* loaded from: classes.dex */
    static class d {
        static Notification.Action.Builder a(Notification.Action.Builder builder, boolean z9) {
            Notification.Action.Builder allowGeneratedReplies;
            allowGeneratedReplies = builder.setAllowGeneratedReplies(z9);
            return allowGeneratedReplies;
        }

        static Notification.Builder b(Notification.Builder builder, RemoteViews remoteViews) {
            Notification.Builder customBigContentView;
            customBigContentView = builder.setCustomBigContentView(remoteViews);
            return customBigContentView;
        }

        static Notification.Builder c(Notification.Builder builder, RemoteViews remoteViews) {
            Notification.Builder customContentView;
            customContentView = builder.setCustomContentView(remoteViews);
            return customContentView;
        }

        static Notification.Builder d(Notification.Builder builder, RemoteViews remoteViews) {
            Notification.Builder customHeadsUpContentView;
            customHeadsUpContentView = builder.setCustomHeadsUpContentView(remoteViews);
            return customHeadsUpContentView;
        }

        static Notification.Builder e(Notification.Builder builder, CharSequence[] charSequenceArr) {
            Notification.Builder remoteInputHistory;
            remoteInputHistory = builder.setRemoteInputHistory(charSequenceArr);
            return remoteInputHistory;
        }
    }

    /* loaded from: classes.dex */
    static class e {
        static Notification.Builder a(Context context, String str) {
            return new Notification.Builder(context, str);
        }

        static Notification.Builder b(Notification.Builder builder, int i10) {
            Notification.Builder badgeIconType;
            badgeIconType = builder.setBadgeIconType(i10);
            return badgeIconType;
        }

        static Notification.Builder c(Notification.Builder builder, boolean z9) {
            Notification.Builder colorized;
            colorized = builder.setColorized(z9);
            return colorized;
        }

        static Notification.Builder d(Notification.Builder builder, int i10) {
            Notification.Builder groupAlertBehavior;
            groupAlertBehavior = builder.setGroupAlertBehavior(i10);
            return groupAlertBehavior;
        }

        static Notification.Builder e(Notification.Builder builder, CharSequence charSequence) {
            Notification.Builder settingsText;
            settingsText = builder.setSettingsText(charSequence);
            return settingsText;
        }

        static Notification.Builder f(Notification.Builder builder, String str) {
            Notification.Builder shortcutId;
            shortcutId = builder.setShortcutId(str);
            return shortcutId;
        }

        static Notification.Builder g(Notification.Builder builder, long j10) {
            Notification.Builder timeoutAfter;
            timeoutAfter = builder.setTimeoutAfter(j10);
            return timeoutAfter;
        }
    }

    /* loaded from: classes.dex */
    static class f {
        static Notification.Builder a(Notification.Builder builder, boolean z9) {
            Notification.Builder allowSystemGeneratedContextualActions;
            allowSystemGeneratedContextualActions = builder.setAllowSystemGeneratedContextualActions(z9);
            return allowSystemGeneratedContextualActions;
        }

        static Notification.Builder b(Notification.Builder builder, Notification.BubbleMetadata bubbleMetadata) {
            Notification.Builder bubbleMetadata2;
            bubbleMetadata2 = builder.setBubbleMetadata(bubbleMetadata);
            return bubbleMetadata2;
        }

        static Notification.Action.Builder c(Notification.Action.Builder builder, boolean z9) {
            Notification.Action.Builder contextual;
            contextual = builder.setContextual(z9);
            return contextual;
        }

        static Notification.Builder d(Notification.Builder builder, Object obj) {
            Notification.Builder locusId;
            locusId = builder.setLocusId((LocusId) obj);
            return locusId;
        }
    }

    /* loaded from: classes.dex */
    static class g {
        static Notification.Action.Builder a(Notification.Action.Builder builder, boolean z9) {
            Notification.Action.Builder authenticationRequired;
            authenticationRequired = builder.setAuthenticationRequired(z9);
            return authenticationRequired;
        }

        static Notification.Builder b(Notification.Builder builder, int i10) {
            Notification.Builder foregroundServiceBehavior;
            foregroundServiceBehavior = builder.setForegroundServiceBehavior(i10);
            return foregroundServiceBehavior;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public q(p.c cVar) {
        int i10;
        Object obj;
        this.f2012c = cVar;
        Context context = cVar.f1984a;
        this.f2010a = context;
        int i11 = Build.VERSION.SDK_INT;
        this.f2011b = i11 >= 26 ? e.a(context, cVar.J) : new Notification.Builder(cVar.f1984a);
        Notification notification = cVar.Q;
        this.f2011b.setWhen(notification.when).setSmallIcon(notification.icon, notification.iconLevel).setContent(notification.contentView).setTicker(notification.tickerText, cVar.f1992i).setVibrate(notification.vibrate).setLights(notification.ledARGB, notification.ledOnMS, notification.ledOffMS).setOngoing((notification.flags & 2) != 0).setOnlyAlertOnce((notification.flags & 8) != 0).setAutoCancel((notification.flags & 16) != 0).setDefaults(notification.defaults).setContentTitle(cVar.f1988e).setContentText(cVar.f1989f).setContentInfo(cVar.f1994k).setContentIntent(cVar.f1990g).setDeleteIntent(notification.deleteIntent).setFullScreenIntent(cVar.f1991h, (notification.flags & 128) != 0).setNumber(cVar.f1995l).setProgress(cVar.f2002s, cVar.f2003t, cVar.f2004u);
        if (i11 < 23) {
            Notification.Builder builder = this.f2011b;
            IconCompat iconCompat = cVar.f1993j;
            builder.setLargeIcon(iconCompat == null ? null : iconCompat.b());
        } else {
            Notification.Builder builder2 = this.f2011b;
            IconCompat iconCompat2 = cVar.f1993j;
            c.b(builder2, iconCompat2 == null ? null : iconCompat2.i(context));
        }
        this.f2011b.setSubText(cVar.f1999p).setUsesChronometer(cVar.f1998o).setPriority(cVar.f1996m);
        Iterator it = cVar.f1985b.iterator();
        while (it.hasNext()) {
            android.support.v4.media.session.b.a(it.next());
            a(null);
        }
        Bundle bundle = cVar.C;
        if (bundle != null) {
            this.f2016g.putAll(bundle);
        }
        int i12 = Build.VERSION.SDK_INT;
        this.f2013d = cVar.G;
        this.f2014e = cVar.H;
        this.f2011b.setShowWhen(cVar.f1997n);
        a.i(this.f2011b, cVar.f2008y);
        a.g(this.f2011b, cVar.f2005v);
        a.j(this.f2011b, cVar.f2007x);
        a.h(this.f2011b, cVar.f2006w);
        this.f2017h = cVar.N;
        b.b(this.f2011b, cVar.B);
        b.c(this.f2011b, cVar.D);
        b.f(this.f2011b, cVar.E);
        b.d(this.f2011b, cVar.F);
        b.e(this.f2011b, notification.sound, notification.audioAttributes);
        List<String> d10 = i12 < 28 ? d(e(cVar.f1986c), cVar.T) : cVar.T;
        if (d10 != null && !d10.isEmpty()) {
            for (String str : d10) {
                b.a(this.f2011b, str);
            }
        }
        this.f2018i = cVar.I;
        if (cVar.f1987d.size() > 0) {
            Bundle bundle2 = cVar.b().getBundle("android.car.EXTENSIONS");
            bundle2 = bundle2 == null ? new Bundle() : bundle2;
            Bundle bundle3 = new Bundle(bundle2);
            Bundle bundle4 = new Bundle();
            for (int i13 = 0; i13 < cVar.f1987d.size(); i13++) {
                String num = Integer.toString(i13);
                android.support.v4.media.session.b.a(cVar.f1987d.get(i13));
                bundle4.putBundle(num, k0.a(null));
            }
            bundle2.putBundle("invisible_actions", bundle4);
            bundle3.putBundle("invisible_actions", bundle4);
            cVar.b().putBundle("android.car.EXTENSIONS", bundle2);
            this.f2016g.putBundle("android.car.EXTENSIONS", bundle3);
        }
        int i14 = Build.VERSION.SDK_INT;
        if (i14 >= 23 && (obj = cVar.S) != null) {
            c.c(this.f2011b, obj);
        }
        if (i14 >= 24) {
            this.f2011b.setExtras(cVar.C);
            d.e(this.f2011b, cVar.f2001r);
            RemoteViews remoteViews = cVar.G;
            if (remoteViews != null) {
                d.c(this.f2011b, remoteViews);
            }
            RemoteViews remoteViews2 = cVar.H;
            if (remoteViews2 != null) {
                d.b(this.f2011b, remoteViews2);
            }
            RemoteViews remoteViews3 = cVar.I;
            if (remoteViews3 != null) {
                d.d(this.f2011b, remoteViews3);
            }
        }
        if (i14 >= 26) {
            e.b(this.f2011b, cVar.K);
            e.e(this.f2011b, cVar.f2000q);
            e.f(this.f2011b, cVar.L);
            e.g(this.f2011b, cVar.M);
            e.d(this.f2011b, cVar.N);
            if (cVar.A) {
                e.c(this.f2011b, cVar.f2009z);
            }
            if (!TextUtils.isEmpty(cVar.J)) {
                this.f2011b.setSound(null).setDefaults(0).setLights(0, 0, 0).setVibrate(null);
            }
        }
        if (i14 >= 28) {
            Iterator it2 = cVar.f1986c.iterator();
            if (it2.hasNext()) {
                android.support.v4.media.session.b.a(it2.next());
                throw null;
            }
        }
        if (i14 >= 29) {
            f.a(this.f2011b, cVar.P);
            f.b(this.f2011b, p.b.a(null));
        }
        if (i14 >= 31 && (i10 = cVar.O) != 0) {
            g.b(this.f2011b, i10);
        }
        if (cVar.R) {
            if (this.f2012c.f2006w) {
                this.f2017h = 2;
            } else {
                this.f2017h = 1;
            }
            this.f2011b.setVibrate(null);
            this.f2011b.setSound(null);
            int i15 = notification.defaults & (-2) & (-3);
            notification.defaults = i15;
            this.f2011b.setDefaults(i15);
            if (i14 >= 26) {
                if (TextUtils.isEmpty(this.f2012c.f2005v)) {
                    a.g(this.f2011b, "silent");
                }
                e.d(this.f2011b, this.f2017h);
            }
        }
    }

    private void a(p.a aVar) {
        throw null;
    }

    private static List d(List list, List list2) {
        if (list == null) {
            return list2;
        }
        if (list2 == null) {
            return list;
        }
        o.b bVar = new o.b(list.size() + list2.size());
        bVar.addAll(list);
        bVar.addAll(list2);
        return new ArrayList(bVar);
    }

    private static List e(List list) {
        if (list == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList(list.size());
        Iterator it = list.iterator();
        if (it.hasNext()) {
            android.support.v4.media.session.b.a(it.next());
            throw null;
        }
        return arrayList;
    }

    private void f(Notification notification) {
        notification.sound = null;
        notification.vibrate = null;
        notification.defaults = notification.defaults & (-2) & (-3);
    }

    public Notification b() {
        this.f2012c.getClass();
        Notification c10 = c();
        RemoteViews remoteViews = this.f2012c.G;
        if (remoteViews != null) {
            c10.contentView = remoteViews;
        }
        return c10;
    }

    protected Notification c() {
        int i10 = Build.VERSION.SDK_INT;
        if (i10 >= 26) {
            return this.f2011b.build();
        }
        if (i10 >= 24) {
            Notification build = this.f2011b.build();
            if (this.f2017h != 0) {
                if (a.f(build) != null && (build.flags & 512) != 0 && this.f2017h == 2) {
                    f(build);
                }
                if (a.f(build) != null && (build.flags & 512) == 0 && this.f2017h == 1) {
                    f(build);
                }
            }
            return build;
        }
        this.f2011b.setExtras(this.f2016g);
        Notification build2 = this.f2011b.build();
        RemoteViews remoteViews = this.f2013d;
        if (remoteViews != null) {
            build2.contentView = remoteViews;
        }
        RemoteViews remoteViews2 = this.f2014e;
        if (remoteViews2 != null) {
            build2.bigContentView = remoteViews2;
        }
        RemoteViews remoteViews3 = this.f2018i;
        if (remoteViews3 != null) {
            build2.headsUpContentView = remoteViews3;
        }
        if (this.f2017h != 0) {
            if (a.f(build2) != null && (build2.flags & 512) != 0 && this.f2017h == 2) {
                f(build2);
            }
            if (a.f(build2) != null && (build2.flags & 512) == 0 && this.f2017h == 1) {
                f(build2);
            }
        }
        return build2;
    }
}
