package androidx.core.app;

import android.app.AppOpsManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.NotificationManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.provider.Settings;
import android.util.Log;
import b.a;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
/* loaded from: classes.dex */
public final class n0 {

    /* renamed from: d  reason: collision with root package name */
    private static String f1962d;

    /* renamed from: g  reason: collision with root package name */
    private static e f1965g;

    /* renamed from: a  reason: collision with root package name */
    private final Context f1966a;

    /* renamed from: b  reason: collision with root package name */
    private final NotificationManager f1967b;

    /* renamed from: c  reason: collision with root package name */
    private static final Object f1961c = new Object();

    /* renamed from: e  reason: collision with root package name */
    private static Set f1963e = new HashSet();

    /* renamed from: f  reason: collision with root package name */
    private static final Object f1964f = new Object();

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class a {
        static boolean a(NotificationManager notificationManager) {
            boolean areNotificationsEnabled;
            areNotificationsEnabled = notificationManager.areNotificationsEnabled();
            return areNotificationsEnabled;
        }

        static int b(NotificationManager notificationManager) {
            int importance;
            importance = notificationManager.getImportance();
            return importance;
        }
    }

    /* loaded from: classes.dex */
    static class b {
        static void a(NotificationManager notificationManager, NotificationChannel notificationChannel) {
            notificationManager.createNotificationChannel(notificationChannel);
        }

        static void b(NotificationManager notificationManager, NotificationChannelGroup notificationChannelGroup) {
            notificationManager.createNotificationChannelGroup(notificationChannelGroup);
        }

        static void c(NotificationManager notificationManager, List<NotificationChannelGroup> list) {
            notificationManager.createNotificationChannelGroups(list);
        }

        static void d(NotificationManager notificationManager, List<NotificationChannel> list) {
            notificationManager.createNotificationChannels(list);
        }

        static void e(NotificationManager notificationManager, String str) {
            notificationManager.deleteNotificationChannel(str);
        }

        static void f(NotificationManager notificationManager, String str) {
            notificationManager.deleteNotificationChannelGroup(str);
        }

        static String g(NotificationChannel notificationChannel) {
            return notificationChannel.getId();
        }

        static String h(NotificationChannelGroup notificationChannelGroup) {
            return notificationChannelGroup.getId();
        }

        static NotificationChannel i(NotificationManager notificationManager, String str) {
            NotificationChannel notificationChannel;
            notificationChannel = notificationManager.getNotificationChannel(str);
            return notificationChannel;
        }

        static List<NotificationChannelGroup> j(NotificationManager notificationManager) {
            List<NotificationChannelGroup> notificationChannelGroups;
            notificationChannelGroups = notificationManager.getNotificationChannelGroups();
            return notificationChannelGroups;
        }

        static List<NotificationChannel> k(NotificationManager notificationManager) {
            List<NotificationChannel> notificationChannels;
            notificationChannels = notificationManager.getNotificationChannels();
            return notificationChannels;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class c implements f {

        /* renamed from: a  reason: collision with root package name */
        final String f1968a;

        /* renamed from: b  reason: collision with root package name */
        final int f1969b;

        /* renamed from: c  reason: collision with root package name */
        final String f1970c;

        /* renamed from: d  reason: collision with root package name */
        final Notification f1971d;

        c(String str, int i10, String str2, Notification notification) {
            this.f1968a = str;
            this.f1969b = i10;
            this.f1970c = str2;
            this.f1971d = notification;
        }

        @Override // androidx.core.app.n0.f
        public void a(b.a aVar) {
            aVar.e(this.f1968a, this.f1969b, this.f1970c, this.f1971d);
        }

        public String toString() {
            return "NotifyTask[packageName:" + this.f1968a + ", id:" + this.f1969b + ", tag:" + this.f1970c + "]";
        }
    }

    /* loaded from: classes.dex */
    private static class d {

        /* renamed from: a  reason: collision with root package name */
        final ComponentName f1972a;

        /* renamed from: b  reason: collision with root package name */
        final IBinder f1973b;

        d(ComponentName componentName, IBinder iBinder) {
            this.f1972a = componentName;
            this.f1973b = iBinder;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class e implements Handler.Callback, ServiceConnection {

        /* renamed from: g  reason: collision with root package name */
        private final Context f1974g;

        /* renamed from: h  reason: collision with root package name */
        private final HandlerThread f1975h;

        /* renamed from: i  reason: collision with root package name */
        private final Handler f1976i;

        /* renamed from: j  reason: collision with root package name */
        private final Map f1977j = new HashMap();

        /* renamed from: k  reason: collision with root package name */
        private Set f1978k = new HashSet();

        /* JADX INFO: Access modifiers changed from: private */
        /* loaded from: classes.dex */
        public static class a {

            /* renamed from: a  reason: collision with root package name */
            final ComponentName f1979a;

            /* renamed from: c  reason: collision with root package name */
            b.a f1981c;

            /* renamed from: b  reason: collision with root package name */
            boolean f1980b = false;

            /* renamed from: d  reason: collision with root package name */
            ArrayDeque f1982d = new ArrayDeque();

            /* renamed from: e  reason: collision with root package name */
            int f1983e = 0;

            a(ComponentName componentName) {
                this.f1979a = componentName;
            }
        }

        e(Context context) {
            this.f1974g = context;
            HandlerThread handlerThread = new HandlerThread("NotificationManagerCompat");
            this.f1975h = handlerThread;
            handlerThread.start();
            this.f1976i = new Handler(handlerThread.getLooper(), this);
        }

        private boolean a(a aVar) {
            if (aVar.f1980b) {
                return true;
            }
            boolean bindService = this.f1974g.bindService(new Intent("android.support.BIND_NOTIFICATION_SIDE_CHANNEL").setComponent(aVar.f1979a), this, 33);
            aVar.f1980b = bindService;
            if (bindService) {
                aVar.f1983e = 0;
            } else {
                Log.w("NotifManCompat", "Unable to bind to listener " + aVar.f1979a);
                this.f1974g.unbindService(this);
            }
            return aVar.f1980b;
        }

        private void b(a aVar) {
            if (aVar.f1980b) {
                this.f1974g.unbindService(this);
                aVar.f1980b = false;
            }
            aVar.f1981c = null;
        }

        private void c(f fVar) {
            j();
            for (a aVar : this.f1977j.values()) {
                aVar.f1982d.add(fVar);
                g(aVar);
            }
        }

        private void d(ComponentName componentName) {
            a aVar = (a) this.f1977j.get(componentName);
            if (aVar != null) {
                g(aVar);
            }
        }

        private void e(ComponentName componentName, IBinder iBinder) {
            a aVar = (a) this.f1977j.get(componentName);
            if (aVar != null) {
                aVar.f1981c = a.AbstractBinderC0062a.g(iBinder);
                aVar.f1983e = 0;
                g(aVar);
            }
        }

        private void f(ComponentName componentName) {
            a aVar = (a) this.f1977j.get(componentName);
            if (aVar != null) {
                b(aVar);
            }
        }

        private void g(a aVar) {
            if (Log.isLoggable("NotifManCompat", 3)) {
                Log.d("NotifManCompat", "Processing component " + aVar.f1979a + ", " + aVar.f1982d.size() + " queued tasks");
            }
            if (aVar.f1982d.isEmpty()) {
                return;
            }
            if (!a(aVar) || aVar.f1981c == null) {
                i(aVar);
                return;
            }
            while (true) {
                f fVar = (f) aVar.f1982d.peek();
                if (fVar == null) {
                    break;
                }
                try {
                    if (Log.isLoggable("NotifManCompat", 3)) {
                        Log.d("NotifManCompat", "Sending task " + fVar);
                    }
                    fVar.a(aVar.f1981c);
                    aVar.f1982d.remove();
                } catch (DeadObjectException unused) {
                    if (Log.isLoggable("NotifManCompat", 3)) {
                        Log.d("NotifManCompat", "Remote service has died: " + aVar.f1979a);
                    }
                } catch (RemoteException e10) {
                    Log.w("NotifManCompat", "RemoteException communicating with " + aVar.f1979a, e10);
                }
            }
            if (aVar.f1982d.isEmpty()) {
                return;
            }
            i(aVar);
        }

        private void i(a aVar) {
            if (this.f1976i.hasMessages(3, aVar.f1979a)) {
                return;
            }
            int i10 = aVar.f1983e + 1;
            aVar.f1983e = i10;
            if (i10 <= 6) {
                int i11 = (1 << (i10 - 1)) * 1000;
                if (Log.isLoggable("NotifManCompat", 3)) {
                    Log.d("NotifManCompat", "Scheduling retry for " + i11 + " ms");
                }
                this.f1976i.sendMessageDelayed(this.f1976i.obtainMessage(3, aVar.f1979a), i11);
                return;
            }
            Log.w("NotifManCompat", "Giving up on delivering " + aVar.f1982d.size() + " tasks to " + aVar.f1979a + " after " + aVar.f1983e + " retries");
            aVar.f1982d.clear();
        }

        private void j() {
            Set f10 = n0.f(this.f1974g);
            if (f10.equals(this.f1978k)) {
                return;
            }
            this.f1978k = f10;
            List<ResolveInfo> queryIntentServices = this.f1974g.getPackageManager().queryIntentServices(new Intent().setAction("android.support.BIND_NOTIFICATION_SIDE_CHANNEL"), 0);
            HashSet<ComponentName> hashSet = new HashSet();
            for (ResolveInfo resolveInfo : queryIntentServices) {
                if (f10.contains(resolveInfo.serviceInfo.packageName)) {
                    ServiceInfo serviceInfo = resolveInfo.serviceInfo;
                    ComponentName componentName = new ComponentName(serviceInfo.packageName, serviceInfo.name);
                    if (resolveInfo.serviceInfo.permission != null) {
                        Log.w("NotifManCompat", "Permission present on component " + componentName + ", not adding listener record.");
                    } else {
                        hashSet.add(componentName);
                    }
                }
            }
            for (ComponentName componentName2 : hashSet) {
                if (!this.f1977j.containsKey(componentName2)) {
                    if (Log.isLoggable("NotifManCompat", 3)) {
                        Log.d("NotifManCompat", "Adding listener record for " + componentName2);
                    }
                    this.f1977j.put(componentName2, new a(componentName2));
                }
            }
            Iterator it = this.f1977j.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry) it.next();
                if (!hashSet.contains(entry.getKey())) {
                    if (Log.isLoggable("NotifManCompat", 3)) {
                        Log.d("NotifManCompat", "Removing listener record for " + entry.getKey());
                    }
                    b((a) entry.getValue());
                    it.remove();
                }
            }
        }

        public void h(f fVar) {
            this.f1976i.obtainMessage(0, fVar).sendToTarget();
        }

        @Override // android.os.Handler.Callback
        public boolean handleMessage(Message message) {
            int i10 = message.what;
            if (i10 == 0) {
                c((f) message.obj);
                return true;
            } else if (i10 == 1) {
                d dVar = (d) message.obj;
                e(dVar.f1972a, dVar.f1973b);
                return true;
            } else if (i10 == 2) {
                f((ComponentName) message.obj);
                return true;
            } else if (i10 != 3) {
                return false;
            } else {
                d((ComponentName) message.obj);
                return true;
            }
        }

        @Override // android.content.ServiceConnection
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            if (Log.isLoggable("NotifManCompat", 3)) {
                Log.d("NotifManCompat", "Connected to service " + componentName);
            }
            this.f1976i.obtainMessage(1, new d(componentName, iBinder)).sendToTarget();
        }

        @Override // android.content.ServiceConnection
        public void onServiceDisconnected(ComponentName componentName) {
            if (Log.isLoggable("NotifManCompat", 3)) {
                Log.d("NotifManCompat", "Disconnected from service " + componentName);
            }
            this.f1976i.obtainMessage(2, componentName).sendToTarget();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public interface f {
        void a(b.a aVar);
    }

    private n0(Context context) {
        this.f1966a = context;
        this.f1967b = (NotificationManager) context.getSystemService("notification");
    }

    public static n0 e(Context context) {
        return new n0(context);
    }

    public static Set f(Context context) {
        Set set;
        String string = Settings.Secure.getString(context.getContentResolver(), "enabled_notification_listeners");
        synchronized (f1961c) {
            if (string != null) {
                if (!string.equals(f1962d)) {
                    String[] split = string.split(":", -1);
                    HashSet hashSet = new HashSet(split.length);
                    for (String str : split) {
                        ComponentName unflattenFromString = ComponentName.unflattenFromString(str);
                        if (unflattenFromString != null) {
                            hashSet.add(unflattenFromString.getPackageName());
                        }
                    }
                    f1963e = hashSet;
                    f1962d = string;
                }
            }
            set = f1963e;
        }
        return set;
    }

    private void i(f fVar) {
        synchronized (f1964f) {
            if (f1965g == null) {
                f1965g = new e(this.f1966a.getApplicationContext());
            }
            f1965g.h(fVar);
        }
    }

    private static boolean j(Notification notification) {
        Bundle a10 = p.a(notification);
        return a10 != null && a10.getBoolean("android.support.useSideChannel");
    }

    public boolean a() {
        if (Build.VERSION.SDK_INT >= 24) {
            return a.a(this.f1967b);
        }
        AppOpsManager appOpsManager = (AppOpsManager) this.f1966a.getSystemService("appops");
        ApplicationInfo applicationInfo = this.f1966a.getApplicationInfo();
        String packageName = this.f1966a.getApplicationContext().getPackageName();
        int i10 = applicationInfo.uid;
        try {
            Class<?> cls = Class.forName(AppOpsManager.class.getName());
            Class<?> cls2 = Integer.TYPE;
            return ((Integer) cls.getMethod("checkOpNoThrow", cls2, cls2, String.class).invoke(appOpsManager, Integer.valueOf(((Integer) cls.getDeclaredField("OP_POST_NOTIFICATION").get(Integer.class)).intValue()), Integer.valueOf(i10), packageName)).intValue() == 0;
        } catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | RuntimeException | InvocationTargetException unused) {
            return true;
        }
    }

    public void b(int i10) {
        c(null, i10);
    }

    public void c(String str, int i10) {
        this.f1967b.cancel(str, i10);
    }

    public void d(NotificationChannel notificationChannel) {
        if (Build.VERSION.SDK_INT >= 26) {
            b.a(this.f1967b, notificationChannel);
        }
    }

    public void g(int i10, Notification notification) {
        h(null, i10, notification);
    }

    public void h(String str, int i10, Notification notification) {
        if (!j(notification)) {
            this.f1967b.notify(str, i10, notification);
            return;
        }
        i(new c(this.f1966a.getPackageName(), i10, str, notification));
        this.f1967b.cancel(str, i10);
    }
}
