package androidx.core.app;

import android.app.Activity;
import android.app.Application;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public abstract class g {

    /* renamed from: a  reason: collision with root package name */
    protected static final Class f1938a;

    /* renamed from: b  reason: collision with root package name */
    protected static final Field f1939b;

    /* renamed from: c  reason: collision with root package name */
    protected static final Field f1940c;

    /* renamed from: d  reason: collision with root package name */
    protected static final Method f1941d;

    /* renamed from: e  reason: collision with root package name */
    protected static final Method f1942e;

    /* renamed from: f  reason: collision with root package name */
    protected static final Method f1943f;

    /* renamed from: g  reason: collision with root package name */
    private static final Handler f1944g = new Handler(Looper.getMainLooper());

    /* loaded from: classes.dex */
    class a implements Runnable {

        /* renamed from: g  reason: collision with root package name */
        final /* synthetic */ d f1945g;

        /* renamed from: h  reason: collision with root package name */
        final /* synthetic */ Object f1946h;

        a(d dVar, Object obj) {
            this.f1945g = dVar;
            this.f1946h = obj;
        }

        @Override // java.lang.Runnable
        public void run() {
            this.f1945g.f1951g = this.f1946h;
        }
    }

    /* loaded from: classes.dex */
    class b implements Runnable {

        /* renamed from: g  reason: collision with root package name */
        final /* synthetic */ Application f1947g;

        /* renamed from: h  reason: collision with root package name */
        final /* synthetic */ d f1948h;

        b(Application application, d dVar) {
            this.f1947g = application;
            this.f1948h = dVar;
        }

        @Override // java.lang.Runnable
        public void run() {
            this.f1947g.unregisterActivityLifecycleCallbacks(this.f1948h);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class c implements Runnable {

        /* renamed from: g  reason: collision with root package name */
        final /* synthetic */ Object f1949g;

        /* renamed from: h  reason: collision with root package name */
        final /* synthetic */ Object f1950h;

        c(Object obj, Object obj2) {
            this.f1949g = obj;
            this.f1950h = obj2;
        }

        @Override // java.lang.Runnable
        public void run() {
            try {
                Method method = g.f1941d;
                if (method != null) {
                    method.invoke(this.f1949g, this.f1950h, Boolean.FALSE, "AppCompat recreation");
                } else {
                    g.f1942e.invoke(this.f1949g, this.f1950h, Boolean.FALSE);
                }
            } catch (RuntimeException e10) {
                if (e10.getClass() == RuntimeException.class && e10.getMessage() != null && e10.getMessage().startsWith("Unable to stop")) {
                    throw e10;
                }
            } catch (Throwable th) {
                Log.e("ActivityRecreator", "Exception while invoking performStopActivity", th);
            }
        }
    }

    /* loaded from: classes.dex */
    private static final class d implements Application.ActivityLifecycleCallbacks {

        /* renamed from: g  reason: collision with root package name */
        Object f1951g;

        /* renamed from: h  reason: collision with root package name */
        private Activity f1952h;

        /* renamed from: i  reason: collision with root package name */
        private final int f1953i;

        /* renamed from: j  reason: collision with root package name */
        private boolean f1954j = false;

        /* renamed from: k  reason: collision with root package name */
        private boolean f1955k = false;

        /* renamed from: l  reason: collision with root package name */
        private boolean f1956l = false;

        d(Activity activity) {
            this.f1952h = activity;
            this.f1953i = activity.hashCode();
        }

        @Override // android.app.Application.ActivityLifecycleCallbacks
        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        @Override // android.app.Application.ActivityLifecycleCallbacks
        public void onActivityDestroyed(Activity activity) {
            if (this.f1952h == activity) {
                this.f1952h = null;
                this.f1955k = true;
            }
        }

        @Override // android.app.Application.ActivityLifecycleCallbacks
        public void onActivityPaused(Activity activity) {
            if (!this.f1955k || this.f1956l || this.f1954j || !g.h(this.f1951g, this.f1953i, activity)) {
                return;
            }
            this.f1956l = true;
            this.f1951g = null;
        }

        @Override // android.app.Application.ActivityLifecycleCallbacks
        public void onActivityResumed(Activity activity) {
        }

        @Override // android.app.Application.ActivityLifecycleCallbacks
        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        @Override // android.app.Application.ActivityLifecycleCallbacks
        public void onActivityStarted(Activity activity) {
            if (this.f1952h == activity) {
                this.f1954j = true;
            }
        }

        @Override // android.app.Application.ActivityLifecycleCallbacks
        public void onActivityStopped(Activity activity) {
        }
    }

    static {
        Class a10 = a();
        f1938a = a10;
        f1939b = b();
        f1940c = f();
        f1941d = d(a10);
        f1942e = c(a10);
        f1943f = e(a10);
    }

    private static Class a() {
        try {
            return Class.forName("android.app.ActivityThread");
        } catch (Throwable unused) {
            return null;
        }
    }

    private static Field b() {
        try {
            Field declaredField = Activity.class.getDeclaredField("mMainThread");
            declaredField.setAccessible(true);
            return declaredField;
        } catch (Throwable unused) {
            return null;
        }
    }

    private static Method c(Class cls) {
        if (cls == null) {
            return null;
        }
        try {
            Method declaredMethod = cls.getDeclaredMethod("performStopActivity", IBinder.class, Boolean.TYPE);
            declaredMethod.setAccessible(true);
            return declaredMethod;
        } catch (Throwable unused) {
            return null;
        }
    }

    private static Method d(Class cls) {
        if (cls == null) {
            return null;
        }
        try {
            Method declaredMethod = cls.getDeclaredMethod("performStopActivity", IBinder.class, Boolean.TYPE, String.class);
            declaredMethod.setAccessible(true);
            return declaredMethod;
        } catch (Throwable unused) {
            return null;
        }
    }

    private static Method e(Class cls) {
        if (g() && cls != null) {
            try {
                Class<?> cls2 = Boolean.TYPE;
                Method declaredMethod = cls.getDeclaredMethod("requestRelaunchActivity", IBinder.class, List.class, List.class, Integer.TYPE, cls2, Configuration.class, Configuration.class, cls2, cls2);
                declaredMethod.setAccessible(true);
                return declaredMethod;
            } catch (Throwable unused) {
            }
        }
        return null;
    }

    private static Field f() {
        try {
            Field declaredField = Activity.class.getDeclaredField("mToken");
            declaredField.setAccessible(true);
            return declaredField;
        } catch (Throwable unused) {
            return null;
        }
    }

    private static boolean g() {
        int i10 = Build.VERSION.SDK_INT;
        return i10 == 26 || i10 == 27;
    }

    protected static boolean h(Object obj, int i10, Activity activity) {
        try {
            Object obj2 = f1940c.get(activity);
            if (obj2 == obj && activity.hashCode() == i10) {
                f1944g.postAtFrontOfQueue(new c(f1939b.get(activity), obj2));
                return true;
            }
            return false;
        } catch (Throwable th) {
            Log.e("ActivityRecreator", "Exception while fetching field values", th);
            return false;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static boolean i(Activity activity) {
        Object obj;
        if (Build.VERSION.SDK_INT >= 28) {
            activity.recreate();
            return true;
        } else if (g() && f1943f == null) {
            return false;
        } else {
            if (f1942e == null && f1941d == null) {
                return false;
            }
            try {
                Object obj2 = f1940c.get(activity);
                if (obj2 == null || (obj = f1939b.get(activity)) == null) {
                    return false;
                }
                Application application = activity.getApplication();
                d dVar = new d(activity);
                application.registerActivityLifecycleCallbacks(dVar);
                Handler handler = f1944g;
                handler.post(new a(dVar, obj2));
                if (g()) {
                    Method method = f1943f;
                    Boolean bool = Boolean.FALSE;
                    method.invoke(obj, obj2, null, null, 0, bool, null, null, bool, bool);
                } else {
                    activity.recreate();
                }
                handler.post(new b(application, dVar));
                return true;
            } catch (Throwable unused) {
                return false;
            }
        }
    }
}
