package androidx.core.app;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.SharedElementCallback;
import android.app.SharedElementCallback$OnSharedElementsReadyListener;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
/* loaded from: classes.dex */
public abstract class b extends androidx.core.content.a {

    /* renamed from: b  reason: collision with root package name */
    private static g f1934b;

    /* loaded from: classes.dex */
    class a implements Runnable {

        /* renamed from: g  reason: collision with root package name */
        final /* synthetic */ String[] f1935g;

        /* renamed from: h  reason: collision with root package name */
        final /* synthetic */ Activity f1936h;

        /* renamed from: i  reason: collision with root package name */
        final /* synthetic */ int f1937i;

        a(String[] strArr, Activity activity, int i10) {
            this.f1935g = strArr;
            this.f1936h = activity;
            this.f1937i = i10;
        }

        @Override // java.lang.Runnable
        public void run() {
            int[] iArr = new int[this.f1935g.length];
            PackageManager packageManager = this.f1936h.getPackageManager();
            String packageName = this.f1936h.getPackageName();
            int length = this.f1935g.length;
            for (int i10 = 0; i10 < length; i10++) {
                iArr[i10] = packageManager.checkPermission(this.f1935g[i10], packageName);
            }
            ((f) this.f1936h).onRequestPermissionsResult(this.f1937i, this.f1935g, iArr);
        }
    }

    /* renamed from: androidx.core.app.b$b  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    static class C0012b {
        static void a(Activity activity) {
            activity.finishAfterTransition();
        }

        static void b(Activity activity) {
            activity.postponeEnterTransition();
        }

        static void c(Activity activity, SharedElementCallback sharedElementCallback) {
            activity.setEnterSharedElementCallback(sharedElementCallback);
        }

        static void d(Activity activity, SharedElementCallback sharedElementCallback) {
            activity.setExitSharedElementCallback(sharedElementCallback);
        }

        static void e(Activity activity) {
            activity.startPostponedEnterTransition();
        }
    }

    /* loaded from: classes.dex */
    static class c {
        static void a(Object obj) {
            ((SharedElementCallback$OnSharedElementsReadyListener) obj).onSharedElementsReady();
        }

        static void b(Activity activity, String[] strArr, int i10) {
            activity.requestPermissions(strArr, i10);
        }

        static boolean c(Activity activity, String str) {
            boolean shouldShowRequestPermissionRationale;
            shouldShowRequestPermissionRationale = activity.shouldShowRequestPermissionRationale(str);
            return shouldShowRequestPermissionRationale;
        }
    }

    /* loaded from: classes.dex */
    static class d {
        static boolean a(Activity activity) {
            boolean isLaunchedFromBubble;
            isLaunchedFromBubble = activity.isLaunchedFromBubble();
            return isLaunchedFromBubble;
        }

        @SuppressLint({"BanUncheckedReflection"})
        static boolean b(Activity activity, String str) {
            boolean shouldShowRequestPermissionRationale;
            try {
                return ((Boolean) PackageManager.class.getMethod("shouldShowRequestPermissionRationale", String.class).invoke(activity.getApplication().getPackageManager(), str)).booleanValue();
            } catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException unused) {
                shouldShowRequestPermissionRationale = activity.shouldShowRequestPermissionRationale(str);
                return shouldShowRequestPermissionRationale;
            }
        }
    }

    /* loaded from: classes.dex */
    static class e {
        static boolean a(Activity activity, String str) {
            boolean shouldShowRequestPermissionRationale;
            shouldShowRequestPermissionRationale = activity.shouldShowRequestPermissionRationale(str);
            return shouldShowRequestPermissionRationale;
        }
    }

    /* loaded from: classes.dex */
    public interface f {
        void onRequestPermissionsResult(int i10, String[] strArr, int[] iArr);
    }

    /* loaded from: classes.dex */
    public interface g {
        boolean a(Activity activity, String[] strArr, int i10);
    }

    /* loaded from: classes.dex */
    public interface h {
        void validateRequestPermissionsRequestCode(int i10);
    }

    public static void n(Activity activity) {
        C0012b.a(activity);
    }

    /* JADX INFO: Access modifiers changed from: private */
    public static /* synthetic */ void o(Activity activity) {
        if (activity.isFinishing() || androidx.core.app.g.i(activity)) {
            return;
        }
        activity.recreate();
    }

    public static void p(Activity activity) {
        C0012b.b(activity);
    }

    public static void q(final Activity activity) {
        if (Build.VERSION.SDK_INT >= 28) {
            activity.recreate();
        } else {
            new Handler(activity.getMainLooper()).post(new Runnable() { // from class: androidx.core.app.a
                @Override // java.lang.Runnable
                public final void run() {
                    b.o(activity);
                }
            });
        }
    }

    public static void r(Activity activity, String[] strArr, int i10) {
        g gVar = f1934b;
        if (gVar == null || !gVar.a(activity, strArr, i10)) {
            HashSet hashSet = new HashSet();
            for (int i11 = 0; i11 < strArr.length; i11++) {
                if (TextUtils.isEmpty(strArr[i11])) {
                    throw new IllegalArgumentException("Permission request for permissions " + Arrays.toString(strArr) + " must not contain null or empty values");
                }
                if (Build.VERSION.SDK_INT < 33 && TextUtils.equals(strArr[i11], "android.permission.POST_NOTIFICATIONS")) {
                    hashSet.add(Integer.valueOf(i11));
                }
            }
            int size = hashSet.size();
            String[] strArr2 = size > 0 ? new String[strArr.length - size] : strArr;
            if (size > 0) {
                if (size == strArr.length) {
                    return;
                }
                int i12 = 0;
                for (int i13 = 0; i13 < strArr.length; i13++) {
                    if (!hashSet.contains(Integer.valueOf(i13))) {
                        strArr2[i12] = strArr[i13];
                        i12++;
                    }
                }
            }
            if (Build.VERSION.SDK_INT >= 23) {
                if (activity instanceof h) {
                    ((h) activity).validateRequestPermissionsRequestCode(i10);
                }
                c.b(activity, strArr, i10);
            } else if (activity instanceof f) {
                new Handler(Looper.getMainLooper()).post(new a(strArr2, activity, i10));
            }
        }
    }

    public static void s(Activity activity, y0 y0Var) {
        C0012b.c(activity, null);
    }

    public static void t(Activity activity, y0 y0Var) {
        C0012b.d(activity, null);
    }

    public static boolean u(Activity activity, String str) {
        int i10 = Build.VERSION.SDK_INT;
        if (i10 >= 33 || !TextUtils.equals("android.permission.POST_NOTIFICATIONS", str)) {
            if (i10 >= 32) {
                return e.a(activity, str);
            }
            if (i10 == 31) {
                return d.b(activity, str);
            }
            if (i10 >= 23) {
                return c.c(activity, str);
            }
            return false;
        }
        return false;
    }

    public static void v(Activity activity, Intent intent, int i10, Bundle bundle) {
        activity.startActivityForResult(intent, i10, bundle);
    }

    public static void w(Activity activity, IntentSender intentSender, int i10, Intent intent, int i11, int i12, int i13, Bundle bundle) {
        activity.startIntentSenderForResult(intentSender, i10, intent, i11, i12, i13, bundle);
    }

    public static void x(Activity activity) {
        C0012b.e(activity);
    }
}
