package androidx.coordinatorlayout.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import androidx.core.view.g0;
import androidx.core.view.h0;
import androidx.core.view.i;
import androidx.core.view.i0;
import androidx.core.view.j0;
import androidx.core.view.r0;
import androidx.core.view.y2;
import io.flutter.plugin.platform.PlatformPlugin;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
/* loaded from: classes.dex */
public class CoordinatorLayout extends ViewGroup implements g0, h0 {
    static final String A;
    static final Class[] B;
    static final ThreadLocal C;
    static final Comparator D;
    private static final v.e E;

    /* renamed from: g  reason: collision with root package name */
    private final List f1879g;

    /* renamed from: h  reason: collision with root package name */
    private final androidx.coordinatorlayout.widget.a f1880h;

    /* renamed from: i  reason: collision with root package name */
    private final List f1881i;

    /* renamed from: j  reason: collision with root package name */
    private final List f1882j;

    /* renamed from: k  reason: collision with root package name */
    private Paint f1883k;

    /* renamed from: l  reason: collision with root package name */
    private final int[] f1884l;

    /* renamed from: m  reason: collision with root package name */
    private final int[] f1885m;

    /* renamed from: n  reason: collision with root package name */
    private boolean f1886n;

    /* renamed from: o  reason: collision with root package name */
    private boolean f1887o;

    /* renamed from: p  reason: collision with root package name */
    private int[] f1888p;

    /* renamed from: q  reason: collision with root package name */
    private View f1889q;

    /* renamed from: r  reason: collision with root package name */
    private View f1890r;

    /* renamed from: s  reason: collision with root package name */
    private f f1891s;

    /* renamed from: t  reason: collision with root package name */
    private boolean f1892t;

    /* renamed from: u  reason: collision with root package name */
    private y2 f1893u;

    /* renamed from: v  reason: collision with root package name */
    private boolean f1894v;

    /* renamed from: w  reason: collision with root package name */
    private Drawable f1895w;

    /* renamed from: x  reason: collision with root package name */
    ViewGroup.OnHierarchyChangeListener f1896x;

    /* renamed from: y  reason: collision with root package name */
    private j0 f1897y;

    /* renamed from: z  reason: collision with root package name */
    private final i0 f1898z;

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class a implements j0 {
        a() {
        }

        @Override // androidx.core.view.j0
        public y2 a(View view, y2 y2Var) {
            return CoordinatorLayout.this.U(y2Var);
        }
    }

    /* loaded from: classes.dex */
    public static abstract class b {
        public b() {
        }

        public b(Context context, AttributeSet attributeSet) {
        }

        public boolean A(CoordinatorLayout coordinatorLayout, View view, View view2, View view3, int i10, int i11) {
            if (i11 == 0) {
                return z(coordinatorLayout, view, view2, view3, i10);
            }
            return false;
        }

        public void B(CoordinatorLayout coordinatorLayout, View view, View view2) {
        }

        public void C(CoordinatorLayout coordinatorLayout, View view, View view2, int i10) {
            if (i10 == 0) {
                B(coordinatorLayout, view, view2);
            }
        }

        public boolean D(CoordinatorLayout coordinatorLayout, View view, MotionEvent motionEvent) {
            return false;
        }

        public boolean a(CoordinatorLayout coordinatorLayout, View view) {
            return d(coordinatorLayout, view) > 0.0f;
        }

        public boolean b(CoordinatorLayout coordinatorLayout, View view, Rect rect) {
            return false;
        }

        public int c(CoordinatorLayout coordinatorLayout, View view) {
            return -16777216;
        }

        public float d(CoordinatorLayout coordinatorLayout, View view) {
            return 0.0f;
        }

        public boolean e(CoordinatorLayout coordinatorLayout, View view, View view2) {
            return false;
        }

        public y2 f(CoordinatorLayout coordinatorLayout, View view, y2 y2Var) {
            return y2Var;
        }

        public void g(e eVar) {
        }

        public boolean h(CoordinatorLayout coordinatorLayout, View view, View view2) {
            return false;
        }

        public void i(CoordinatorLayout coordinatorLayout, View view, View view2) {
        }

        public void j() {
        }

        public boolean k(CoordinatorLayout coordinatorLayout, View view, MotionEvent motionEvent) {
            return false;
        }

        public boolean l(CoordinatorLayout coordinatorLayout, View view, int i10) {
            return false;
        }

        public boolean m(CoordinatorLayout coordinatorLayout, View view, int i10, int i11, int i12, int i13) {
            return false;
        }

        public boolean n(CoordinatorLayout coordinatorLayout, View view, View view2, float f10, float f11, boolean z9) {
            return false;
        }

        public boolean o(CoordinatorLayout coordinatorLayout, View view, View view2, float f10, float f11) {
            return false;
        }

        public void p(CoordinatorLayout coordinatorLayout, View view, View view2, int i10, int i11, int[] iArr) {
        }

        public void q(CoordinatorLayout coordinatorLayout, View view, View view2, int i10, int i11, int[] iArr, int i12) {
            if (i12 == 0) {
                p(coordinatorLayout, view, view2, i10, i11, iArr);
            }
        }

        public void r(CoordinatorLayout coordinatorLayout, View view, View view2, int i10, int i11, int i12, int i13) {
        }

        public void s(CoordinatorLayout coordinatorLayout, View view, View view2, int i10, int i11, int i12, int i13, int i14) {
            if (i14 == 0) {
                r(coordinatorLayout, view, view2, i10, i11, i12, i13);
            }
        }

        public void t(CoordinatorLayout coordinatorLayout, View view, View view2, int i10, int i11, int i12, int i13, int i14, int[] iArr) {
            iArr[0] = iArr[0] + i12;
            iArr[1] = iArr[1] + i13;
            s(coordinatorLayout, view, view2, i10, i11, i12, i13, i14);
        }

        public void u(CoordinatorLayout coordinatorLayout, View view, View view2, View view3, int i10) {
        }

        public void v(CoordinatorLayout coordinatorLayout, View view, View view2, View view3, int i10, int i11) {
            if (i11 == 0) {
                u(coordinatorLayout, view, view2, view3, i10);
            }
        }

        public boolean w(CoordinatorLayout coordinatorLayout, View view, Rect rect, boolean z9) {
            return false;
        }

        public void x(CoordinatorLayout coordinatorLayout, View view, Parcelable parcelable) {
        }

        public Parcelable y(CoordinatorLayout coordinatorLayout, View view) {
            return View.BaseSavedState.EMPTY_STATE;
        }

        public boolean z(CoordinatorLayout coordinatorLayout, View view, View view2, View view3, int i10) {
            return false;
        }
    }

    @Retention(RetentionPolicy.RUNTIME)
    /* loaded from: classes.dex */
    public @interface c {
        Class value();
    }

    /* loaded from: classes.dex */
    private class d implements ViewGroup.OnHierarchyChangeListener {
        d() {
        }

        @Override // android.view.ViewGroup.OnHierarchyChangeListener
        public void onChildViewAdded(View view, View view2) {
            ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener = CoordinatorLayout.this.f1896x;
            if (onHierarchyChangeListener != null) {
                onHierarchyChangeListener.onChildViewAdded(view, view2);
            }
        }

        @Override // android.view.ViewGroup.OnHierarchyChangeListener
        public void onChildViewRemoved(View view, View view2) {
            CoordinatorLayout.this.F(2);
            ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener = CoordinatorLayout.this.f1896x;
            if (onHierarchyChangeListener != null) {
                onHierarchyChangeListener.onChildViewRemoved(view, view2);
            }
        }
    }

    /* loaded from: classes.dex */
    public static class e extends ViewGroup.MarginLayoutParams {

        /* renamed from: a  reason: collision with root package name */
        b f1901a;

        /* renamed from: b  reason: collision with root package name */
        boolean f1902b;

        /* renamed from: c  reason: collision with root package name */
        public int f1903c;

        /* renamed from: d  reason: collision with root package name */
        public int f1904d;

        /* renamed from: e  reason: collision with root package name */
        public int f1905e;

        /* renamed from: f  reason: collision with root package name */
        int f1906f;

        /* renamed from: g  reason: collision with root package name */
        public int f1907g;

        /* renamed from: h  reason: collision with root package name */
        public int f1908h;

        /* renamed from: i  reason: collision with root package name */
        int f1909i;

        /* renamed from: j  reason: collision with root package name */
        int f1910j;

        /* renamed from: k  reason: collision with root package name */
        View f1911k;

        /* renamed from: l  reason: collision with root package name */
        View f1912l;

        /* renamed from: m  reason: collision with root package name */
        private boolean f1913m;

        /* renamed from: n  reason: collision with root package name */
        private boolean f1914n;

        /* renamed from: o  reason: collision with root package name */
        private boolean f1915o;

        /* renamed from: p  reason: collision with root package name */
        private boolean f1916p;

        /* renamed from: q  reason: collision with root package name */
        final Rect f1917q;

        /* renamed from: r  reason: collision with root package name */
        Object f1918r;

        public e(int i10, int i11) {
            super(i10, i11);
            this.f1902b = false;
            this.f1903c = 0;
            this.f1904d = 0;
            this.f1905e = -1;
            this.f1906f = -1;
            this.f1907g = 0;
            this.f1908h = 0;
            this.f1917q = new Rect();
        }

        e(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.f1902b = false;
            this.f1903c = 0;
            this.f1904d = 0;
            this.f1905e = -1;
            this.f1906f = -1;
            this.f1907g = 0;
            this.f1908h = 0;
            this.f1917q = new Rect();
            TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, p.c.f10879e);
            this.f1903c = obtainStyledAttributes.getInteger(p.c.f10880f, 0);
            this.f1906f = obtainStyledAttributes.getResourceId(p.c.f10881g, -1);
            this.f1904d = obtainStyledAttributes.getInteger(p.c.f10882h, 0);
            this.f1905e = obtainStyledAttributes.getInteger(p.c.f10886l, -1);
            this.f1907g = obtainStyledAttributes.getInt(p.c.f10885k, 0);
            this.f1908h = obtainStyledAttributes.getInt(p.c.f10884j, 0);
            int i10 = p.c.f10883i;
            boolean hasValue = obtainStyledAttributes.hasValue(i10);
            this.f1902b = hasValue;
            if (hasValue) {
                this.f1901a = CoordinatorLayout.I(context, attributeSet, obtainStyledAttributes.getString(i10));
            }
            obtainStyledAttributes.recycle();
            b bVar = this.f1901a;
            if (bVar != null) {
                bVar.g(this);
            }
        }

        public e(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.f1902b = false;
            this.f1903c = 0;
            this.f1904d = 0;
            this.f1905e = -1;
            this.f1906f = -1;
            this.f1907g = 0;
            this.f1908h = 0;
            this.f1917q = new Rect();
        }

        public e(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
            this.f1902b = false;
            this.f1903c = 0;
            this.f1904d = 0;
            this.f1905e = -1;
            this.f1906f = -1;
            this.f1907g = 0;
            this.f1908h = 0;
            this.f1917q = new Rect();
        }

        public e(e eVar) {
            super((ViewGroup.MarginLayoutParams) eVar);
            this.f1902b = false;
            this.f1903c = 0;
            this.f1904d = 0;
            this.f1905e = -1;
            this.f1906f = -1;
            this.f1907g = 0;
            this.f1908h = 0;
            this.f1917q = new Rect();
        }

        private void m(View view, CoordinatorLayout coordinatorLayout) {
            View findViewById = coordinatorLayout.findViewById(this.f1906f);
            this.f1911k = findViewById;
            if (findViewById != null) {
                if (findViewById != coordinatorLayout) {
                    for (ViewParent parent = findViewById.getParent(); parent != coordinatorLayout && parent != null; parent = parent.getParent()) {
                        if (parent != view) {
                            if (parent instanceof View) {
                                findViewById = (View) parent;
                            }
                        } else if (!coordinatorLayout.isInEditMode()) {
                            throw new IllegalStateException("Anchor must not be a descendant of the anchored view");
                        }
                    }
                    this.f1912l = findViewById;
                    return;
                } else if (!coordinatorLayout.isInEditMode()) {
                    throw new IllegalStateException("View can not be anchored to the the parent CoordinatorLayout");
                }
            } else if (!coordinatorLayout.isInEditMode()) {
                throw new IllegalStateException("Could not find CoordinatorLayout descendant view with id " + coordinatorLayout.getResources().getResourceName(this.f1906f) + " to anchor view " + view);
            }
            this.f1912l = null;
            this.f1911k = null;
        }

        private boolean r(View view, int i10) {
            int b10 = i.b(((e) view.getLayoutParams()).f1907g, i10);
            return b10 != 0 && (i.b(this.f1908h, i10) & b10) == b10;
        }

        private boolean s(View view, CoordinatorLayout coordinatorLayout) {
            if (this.f1911k.getId() != this.f1906f) {
                return false;
            }
            View view2 = this.f1911k;
            for (ViewParent parent = view2.getParent(); parent != coordinatorLayout; parent = parent.getParent()) {
                if (parent == null || parent == view) {
                    this.f1912l = null;
                    this.f1911k = null;
                    return false;
                }
                if (parent instanceof View) {
                    view2 = (View) parent;
                }
            }
            this.f1912l = view2;
            return true;
        }

        boolean a() {
            return this.f1911k == null && this.f1906f != -1;
        }

        boolean b(CoordinatorLayout coordinatorLayout, View view, View view2) {
            b bVar;
            return view2 == this.f1912l || r(view2, r0.B(coordinatorLayout)) || ((bVar = this.f1901a) != null && bVar.e(coordinatorLayout, view, view2));
        }

        boolean c() {
            if (this.f1901a == null) {
                this.f1913m = false;
            }
            return this.f1913m;
        }

        View d(CoordinatorLayout coordinatorLayout, View view) {
            if (this.f1906f == -1) {
                this.f1912l = null;
                this.f1911k = null;
                return null;
            }
            if (this.f1911k == null || !s(view, coordinatorLayout)) {
                m(view, coordinatorLayout);
            }
            return this.f1911k;
        }

        public b e() {
            return this.f1901a;
        }

        boolean f() {
            return this.f1916p;
        }

        Rect g() {
            return this.f1917q;
        }

        boolean h(CoordinatorLayout coordinatorLayout, View view) {
            boolean z9 = this.f1913m;
            if (z9) {
                return true;
            }
            b bVar = this.f1901a;
            boolean a10 = (bVar != null ? bVar.a(coordinatorLayout, view) : false) | z9;
            this.f1913m = a10;
            return a10;
        }

        boolean i(int i10) {
            if (i10 != 0) {
                if (i10 != 1) {
                    return false;
                }
                return this.f1915o;
            }
            return this.f1914n;
        }

        void j() {
            this.f1916p = false;
        }

        void k(int i10) {
            q(i10, false);
        }

        void l() {
            this.f1913m = false;
        }

        public void n(b bVar) {
            b bVar2 = this.f1901a;
            if (bVar2 != bVar) {
                if (bVar2 != null) {
                    bVar2.j();
                }
                this.f1901a = bVar;
                this.f1918r = null;
                this.f1902b = true;
                if (bVar != null) {
                    bVar.g(this);
                }
            }
        }

        void o(boolean z9) {
            this.f1916p = z9;
        }

        void p(Rect rect) {
            this.f1917q.set(rect);
        }

        void q(int i10, boolean z9) {
            if (i10 == 0) {
                this.f1914n = z9;
            } else if (i10 != 1) {
            } else {
                this.f1915o = z9;
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class f implements ViewTreeObserver.OnPreDrawListener {
        f() {
        }

        @Override // android.view.ViewTreeObserver.OnPreDrawListener
        public boolean onPreDraw() {
            CoordinatorLayout.this.F(0);
            return true;
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    /* loaded from: classes.dex */
    public static class g extends b0.a {
        public static final Parcelable.Creator<g> CREATOR = new a();

        /* renamed from: i  reason: collision with root package name */
        SparseArray f1920i;

        /* loaded from: classes.dex */
        static class a implements Parcelable.ClassLoaderCreator {
            a() {
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: a */
            public g createFromParcel(Parcel parcel) {
                return new g(parcel, null);
            }

            @Override // android.os.Parcelable.ClassLoaderCreator
            /* renamed from: b */
            public g createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new g(parcel, classLoader);
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: c */
            public g[] newArray(int i10) {
                return new g[i10];
            }
        }

        public g(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            int readInt = parcel.readInt();
            int[] iArr = new int[readInt];
            parcel.readIntArray(iArr);
            Parcelable[] readParcelableArray = parcel.readParcelableArray(classLoader);
            this.f1920i = new SparseArray(readInt);
            for (int i10 = 0; i10 < readInt; i10++) {
                this.f1920i.append(iArr[i10], readParcelableArray[i10]);
            }
        }

        public g(Parcelable parcelable) {
            super(parcelable);
        }

        @Override // b0.a, android.os.Parcelable
        public void writeToParcel(Parcel parcel, int i10) {
            super.writeToParcel(parcel, i10);
            SparseArray sparseArray = this.f1920i;
            int size = sparseArray != null ? sparseArray.size() : 0;
            parcel.writeInt(size);
            int[] iArr = new int[size];
            Parcelable[] parcelableArr = new Parcelable[size];
            for (int i11 = 0; i11 < size; i11++) {
                iArr[i11] = this.f1920i.keyAt(i11);
                parcelableArr[i11] = (Parcelable) this.f1920i.valueAt(i11);
            }
            parcel.writeIntArray(iArr);
            parcel.writeParcelableArray(parcelableArr, i10);
        }
    }

    /* loaded from: classes.dex */
    static class h implements Comparator {
        h() {
        }

        @Override // java.util.Comparator
        /* renamed from: a */
        public int compare(View view, View view2) {
            float L = r0.L(view);
            float L2 = r0.L(view2);
            if (L > L2) {
                return -1;
            }
            return L < L2 ? 1 : 0;
        }
    }

    static {
        Package r02 = CoordinatorLayout.class.getPackage();
        A = r02 != null ? r02.getName() : null;
        D = new h();
        B = new Class[]{Context.class, AttributeSet.class};
        C = new ThreadLocal();
        E = new v.g(12);
    }

    public CoordinatorLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, p.a.coordinatorLayoutStyle);
    }

    public CoordinatorLayout(Context context, AttributeSet attributeSet, int i10) {
        super(context, attributeSet, i10);
        this.f1879g = new ArrayList();
        this.f1880h = new androidx.coordinatorlayout.widget.a();
        this.f1881i = new ArrayList();
        this.f1882j = new ArrayList();
        this.f1884l = new int[2];
        this.f1885m = new int[2];
        this.f1898z = new i0(this);
        int[] iArr = p.c.f10876b;
        TypedArray obtainStyledAttributes = i10 == 0 ? context.obtainStyledAttributes(attributeSet, iArr, 0, p.b.Widget_Support_CoordinatorLayout) : context.obtainStyledAttributes(attributeSet, iArr, i10, 0);
        if (Build.VERSION.SDK_INT >= 29) {
            int[] iArr2 = p.c.f10876b;
            if (i10 == 0) {
                saveAttributeDataForStyleable(context, iArr2, attributeSet, obtainStyledAttributes, 0, p.b.Widget_Support_CoordinatorLayout);
            } else {
                saveAttributeDataForStyleable(context, iArr2, attributeSet, obtainStyledAttributes, i10, 0);
            }
        }
        int resourceId = obtainStyledAttributes.getResourceId(p.c.f10877c, 0);
        if (resourceId != 0) {
            Resources resources = context.getResources();
            this.f1888p = resources.getIntArray(resourceId);
            float f10 = resources.getDisplayMetrics().density;
            int length = this.f1888p.length;
            for (int i11 = 0; i11 < length; i11++) {
                int[] iArr3 = this.f1888p;
                iArr3[i11] = (int) (iArr3[i11] * f10);
            }
        }
        this.f1895w = obtainStyledAttributes.getDrawable(p.c.f10878d);
        obtainStyledAttributes.recycle();
        V();
        super.setOnHierarchyChangeListener(new d());
        if (r0.z(this) == 0) {
            r0.x0(this, 1);
        }
    }

    private void A(View view, int i10) {
        e eVar = (e) view.getLayoutParams();
        Rect a10 = a();
        a10.set(getPaddingLeft() + ((ViewGroup.MarginLayoutParams) eVar).leftMargin, getPaddingTop() + ((ViewGroup.MarginLayoutParams) eVar).topMargin, (getWidth() - getPaddingRight()) - ((ViewGroup.MarginLayoutParams) eVar).rightMargin, (getHeight() - getPaddingBottom()) - ((ViewGroup.MarginLayoutParams) eVar).bottomMargin);
        if (this.f1893u != null && r0.y(this) && !r0.y(view)) {
            a10.left += this.f1893u.i();
            a10.top += this.f1893u.k();
            a10.right -= this.f1893u.j();
            a10.bottom -= this.f1893u.h();
        }
        Rect a11 = a();
        i.a(Q(eVar.f1903c), view.getMeasuredWidth(), view.getMeasuredHeight(), a10, a11, i10);
        view.layout(a11.left, a11.top, a11.right, a11.bottom);
        M(a10);
        M(a11);
    }

    private void B(View view, View view2, int i10) {
        Rect a10 = a();
        Rect a11 = a();
        try {
            r(view2, a10);
            s(view, i10, a10, a11);
            view.layout(a11.left, a11.top, a11.right, a11.bottom);
        } finally {
            M(a10);
            M(a11);
        }
    }

    private void C(View view, int i10, int i11) {
        e eVar = (e) view.getLayoutParams();
        int b10 = i.b(R(eVar.f1903c), i11);
        int i12 = b10 & 7;
        int i13 = b10 & 112;
        int width = getWidth();
        int height = getHeight();
        int measuredWidth = view.getMeasuredWidth();
        int measuredHeight = view.getMeasuredHeight();
        if (i11 == 1) {
            i10 = width - i10;
        }
        int u9 = u(i10) - measuredWidth;
        int i14 = 0;
        if (i12 == 1) {
            u9 += measuredWidth / 2;
        } else if (i12 == 5) {
            u9 += measuredWidth;
        }
        if (i13 == 16) {
            i14 = 0 + (measuredHeight / 2);
        } else if (i13 == 80) {
            i14 = measuredHeight + 0;
        }
        int max = Math.max(getPaddingLeft() + ((ViewGroup.MarginLayoutParams) eVar).leftMargin, Math.min(u9, ((width - getPaddingRight()) - measuredWidth) - ((ViewGroup.MarginLayoutParams) eVar).rightMargin));
        int max2 = Math.max(getPaddingTop() + ((ViewGroup.MarginLayoutParams) eVar).topMargin, Math.min(i14, ((height - getPaddingBottom()) - measuredHeight) - ((ViewGroup.MarginLayoutParams) eVar).bottomMargin));
        view.layout(max, max2, measuredWidth + max, measuredHeight + max2);
    }

    private void D(View view, Rect rect, int i10) {
        boolean z9;
        boolean z10;
        int width;
        int i11;
        int i12;
        int i13;
        int height;
        int i14;
        int i15;
        int i16;
        if (r0.R(view) && view.getWidth() > 0 && view.getHeight() > 0) {
            e eVar = (e) view.getLayoutParams();
            b e10 = eVar.e();
            Rect a10 = a();
            Rect a11 = a();
            a11.set(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
            if (e10 == null || !e10.b(this, view, a10)) {
                a10.set(a11);
            } else if (!a11.contains(a10)) {
                throw new IllegalArgumentException("Rect should be within the child's bounds. Rect:" + a10.toShortString() + " | Bounds:" + a11.toShortString());
            }
            M(a11);
            if (a10.isEmpty()) {
                M(a10);
                return;
            }
            int b10 = i.b(eVar.f1908h, i10);
            boolean z11 = true;
            if ((b10 & 48) != 48 || (i15 = (a10.top - ((ViewGroup.MarginLayoutParams) eVar).topMargin) - eVar.f1910j) >= (i16 = rect.top)) {
                z9 = false;
            } else {
                T(view, i16 - i15);
                z9 = true;
            }
            if ((b10 & 80) == 80 && (height = ((getHeight() - a10.bottom) - ((ViewGroup.MarginLayoutParams) eVar).bottomMargin) + eVar.f1910j) < (i14 = rect.bottom)) {
                T(view, height - i14);
                z9 = true;
            }
            if (!z9) {
                T(view, 0);
            }
            if ((b10 & 3) != 3 || (i12 = (a10.left - ((ViewGroup.MarginLayoutParams) eVar).leftMargin) - eVar.f1909i) >= (i13 = rect.left)) {
                z10 = false;
            } else {
                S(view, i13 - i12);
                z10 = true;
            }
            if ((b10 & 5) != 5 || (width = ((getWidth() - a10.right) - ((ViewGroup.MarginLayoutParams) eVar).rightMargin) + eVar.f1909i) >= (i11 = rect.right)) {
                z11 = z10;
            } else {
                S(view, width - i11);
            }
            if (!z11) {
                S(view, 0);
            }
            M(a10);
        }
    }

    static b I(Context context, AttributeSet attributeSet, String str) {
        if (TextUtils.isEmpty(str)) {
            return null;
        }
        if (str.startsWith(".")) {
            str = context.getPackageName() + str;
        } else if (str.indexOf(46) < 0) {
            String str2 = A;
            if (!TextUtils.isEmpty(str2)) {
                str = str2 + '.' + str;
            }
        }
        try {
            ThreadLocal threadLocal = C;
            Map map = (Map) threadLocal.get();
            if (map == null) {
                map = new HashMap();
                threadLocal.set(map);
            }
            Constructor<?> constructor = (Constructor) map.get(str);
            if (constructor == null) {
                constructor = Class.forName(str, false, context.getClassLoader()).getConstructor(B);
                constructor.setAccessible(true);
                map.put(str, constructor);
            }
            return (b) constructor.newInstance(context, attributeSet);
        } catch (Exception e10) {
            throw new RuntimeException("Could not inflate Behavior subclass " + str, e10);
        }
    }

    private boolean J(MotionEvent motionEvent, int i10) {
        int actionMasked = motionEvent.getActionMasked();
        List list = this.f1881i;
        x(list);
        int size = list.size();
        MotionEvent motionEvent2 = null;
        boolean z9 = false;
        boolean z10 = false;
        for (int i11 = 0; i11 < size; i11++) {
            View view = (View) list.get(i11);
            e eVar = (e) view.getLayoutParams();
            b e10 = eVar.e();
            if (!(z9 || z10) || actionMasked == 0) {
                if (!z9 && e10 != null) {
                    if (i10 == 0) {
                        z9 = e10.k(this, view, motionEvent);
                    } else if (i10 == 1) {
                        z9 = e10.D(this, view, motionEvent);
                    }
                    if (z9) {
                        this.f1889q = view;
                    }
                }
                boolean c10 = eVar.c();
                boolean h10 = eVar.h(this, view);
                z10 = h10 && !c10;
                if (h10 && !z10) {
                    break;
                }
            } else if (e10 != null) {
                if (motionEvent2 == null) {
                    long uptimeMillis = SystemClock.uptimeMillis();
                    motionEvent2 = MotionEvent.obtain(uptimeMillis, uptimeMillis, 3, 0.0f, 0.0f, 0);
                }
                if (i10 == 0) {
                    e10.k(this, view, motionEvent2);
                } else if (i10 == 1) {
                    e10.D(this, view, motionEvent2);
                }
            }
        }
        list.clear();
        return z9;
    }

    private void K() {
        this.f1879g.clear();
        this.f1880h.c();
        int childCount = getChildCount();
        for (int i10 = 0; i10 < childCount; i10++) {
            View childAt = getChildAt(i10);
            e w9 = w(childAt);
            w9.d(this, childAt);
            this.f1880h.b(childAt);
            for (int i11 = 0; i11 < childCount; i11++) {
                if (i11 != i10) {
                    View childAt2 = getChildAt(i11);
                    if (w9.b(this, childAt, childAt2)) {
                        if (!this.f1880h.d(childAt2)) {
                            this.f1880h.b(childAt2);
                        }
                        this.f1880h.a(childAt2, childAt);
                    }
                }
            }
        }
        this.f1879g.addAll(this.f1880h.h());
        Collections.reverse(this.f1879g);
    }

    private static void M(Rect rect) {
        rect.setEmpty();
        E.a(rect);
    }

    private void O(boolean z9) {
        int childCount = getChildCount();
        for (int i10 = 0; i10 < childCount; i10++) {
            View childAt = getChildAt(i10);
            b e10 = ((e) childAt.getLayoutParams()).e();
            if (e10 != null) {
                long uptimeMillis = SystemClock.uptimeMillis();
                MotionEvent obtain = MotionEvent.obtain(uptimeMillis, uptimeMillis, 3, 0.0f, 0.0f, 0);
                if (z9) {
                    e10.k(this, childAt, obtain);
                } else {
                    e10.D(this, childAt, obtain);
                }
                obtain.recycle();
            }
        }
        for (int i11 = 0; i11 < childCount; i11++) {
            ((e) getChildAt(i11).getLayoutParams()).l();
        }
        this.f1889q = null;
        this.f1886n = false;
    }

    private static int P(int i10) {
        if (i10 == 0) {
            return 17;
        }
        return i10;
    }

    private static int Q(int i10) {
        if ((i10 & 7) == 0) {
            i10 |= 8388611;
        }
        return (i10 & 112) == 0 ? i10 | 48 : i10;
    }

    private static int R(int i10) {
        if (i10 == 0) {
            return 8388661;
        }
        return i10;
    }

    private void S(View view, int i10) {
        e eVar = (e) view.getLayoutParams();
        int i11 = eVar.f1909i;
        if (i11 != i10) {
            r0.X(view, i10 - i11);
            eVar.f1909i = i10;
        }
    }

    private void T(View view, int i10) {
        e eVar = (e) view.getLayoutParams();
        int i11 = eVar.f1910j;
        if (i11 != i10) {
            r0.Y(view, i10 - i11);
            eVar.f1910j = i10;
        }
    }

    private void V() {
        if (!r0.y(this)) {
            r0.A0(this, null);
            return;
        }
        if (this.f1897y == null) {
            this.f1897y = new a();
        }
        r0.A0(this, this.f1897y);
        setSystemUiVisibility(PlatformPlugin.DEFAULT_SYSTEM_UI);
    }

    private static Rect a() {
        Rect rect = (Rect) E.b();
        return rect == null ? new Rect() : rect;
    }

    private static int c(int i10, int i11, int i12) {
        return i10 < i11 ? i11 : i10 > i12 ? i12 : i10;
    }

    private void d(e eVar, Rect rect, int i10, int i11) {
        int width = getWidth();
        int height = getHeight();
        int max = Math.max(getPaddingLeft() + ((ViewGroup.MarginLayoutParams) eVar).leftMargin, Math.min(rect.left, ((width - getPaddingRight()) - i10) - ((ViewGroup.MarginLayoutParams) eVar).rightMargin));
        int max2 = Math.max(getPaddingTop() + ((ViewGroup.MarginLayoutParams) eVar).topMargin, Math.min(rect.top, ((height - getPaddingBottom()) - i11) - ((ViewGroup.MarginLayoutParams) eVar).bottomMargin));
        rect.set(max, max2, i10 + max, i11 + max2);
    }

    private y2 e(y2 y2Var) {
        b e10;
        if (y2Var.n()) {
            return y2Var;
        }
        int childCount = getChildCount();
        for (int i10 = 0; i10 < childCount; i10++) {
            View childAt = getChildAt(i10);
            if (r0.y(childAt) && (e10 = ((e) childAt.getLayoutParams()).e()) != null) {
                y2Var = e10.f(this, childAt, y2Var);
                if (y2Var.n()) {
                    break;
                }
            }
        }
        return y2Var;
    }

    private void t(View view, int i10, Rect rect, Rect rect2, e eVar, int i11, int i12) {
        int b10 = i.b(P(eVar.f1903c), i10);
        int b11 = i.b(Q(eVar.f1904d), i10);
        int i13 = b10 & 7;
        int i14 = b10 & 112;
        int i15 = b11 & 7;
        int i16 = b11 & 112;
        int width = i15 != 1 ? i15 != 5 ? rect.left : rect.right : rect.left + (rect.width() / 2);
        int height = i16 != 16 ? i16 != 80 ? rect.top : rect.bottom : rect.top + (rect.height() / 2);
        if (i13 == 1) {
            width -= i11 / 2;
        } else if (i13 != 5) {
            width -= i11;
        }
        if (i14 == 16) {
            height -= i12 / 2;
        } else if (i14 != 80) {
            height -= i12;
        }
        rect2.set(width, height, i11 + width, i12 + height);
    }

    private int u(int i10) {
        StringBuilder sb;
        int[] iArr = this.f1888p;
        if (iArr == null) {
            sb = new StringBuilder();
            sb.append("No keylines defined for ");
            sb.append(this);
            sb.append(" - attempted index lookup ");
            sb.append(i10);
        } else if (i10 >= 0 && i10 < iArr.length) {
            return iArr[i10];
        } else {
            sb = new StringBuilder();
            sb.append("Keyline index ");
            sb.append(i10);
            sb.append(" out of range for ");
            sb.append(this);
        }
        Log.e("CoordinatorLayout", sb.toString());
        return 0;
    }

    private void x(List list) {
        list.clear();
        boolean isChildrenDrawingOrderEnabled = isChildrenDrawingOrderEnabled();
        int childCount = getChildCount();
        for (int i10 = childCount - 1; i10 >= 0; i10--) {
            list.add(getChildAt(isChildrenDrawingOrderEnabled ? getChildDrawingOrder(childCount, i10) : i10));
        }
        Comparator comparator = D;
        if (comparator != null) {
            Collections.sort(list, comparator);
        }
    }

    private boolean y(View view) {
        return this.f1880h.i(view);
    }

    void E(View view, int i10) {
        b e10;
        e eVar = (e) view.getLayoutParams();
        if (eVar.f1911k != null) {
            Rect a10 = a();
            Rect a11 = a();
            Rect a12 = a();
            r(eVar.f1911k, a10);
            boolean z9 = false;
            p(view, false, a11);
            int measuredWidth = view.getMeasuredWidth();
            int measuredHeight = view.getMeasuredHeight();
            t(view, i10, a10, a12, eVar, measuredWidth, measuredHeight);
            z9 = (a12.left == a11.left && a12.top == a11.top) ? true : true;
            d(eVar, a12, measuredWidth, measuredHeight);
            int i11 = a12.left - a11.left;
            int i12 = a12.top - a11.top;
            if (i11 != 0) {
                r0.X(view, i11);
            }
            if (i12 != 0) {
                r0.Y(view, i12);
            }
            if (z9 && (e10 = eVar.e()) != null) {
                e10.h(this, view, eVar.f1911k);
            }
            M(a10);
            M(a11);
            M(a12);
        }
    }

    final void F(int i10) {
        boolean z9;
        int B2 = r0.B(this);
        int size = this.f1879g.size();
        Rect a10 = a();
        Rect a11 = a();
        Rect a12 = a();
        for (int i11 = 0; i11 < size; i11++) {
            View view = (View) this.f1879g.get(i11);
            e eVar = (e) view.getLayoutParams();
            if (i10 != 0 || view.getVisibility() != 8) {
                for (int i12 = 0; i12 < i11; i12++) {
                    if (eVar.f1912l == ((View) this.f1879g.get(i12))) {
                        E(view, B2);
                    }
                }
                p(view, true, a11);
                if (eVar.f1907g != 0 && !a11.isEmpty()) {
                    int b10 = i.b(eVar.f1907g, B2);
                    int i13 = b10 & 112;
                    if (i13 == 48) {
                        a10.top = Math.max(a10.top, a11.bottom);
                    } else if (i13 == 80) {
                        a10.bottom = Math.max(a10.bottom, getHeight() - a11.top);
                    }
                    int i14 = b10 & 7;
                    if (i14 == 3) {
                        a10.left = Math.max(a10.left, a11.right);
                    } else if (i14 == 5) {
                        a10.right = Math.max(a10.right, getWidth() - a11.left);
                    }
                }
                if (eVar.f1908h != 0 && view.getVisibility() == 0) {
                    D(view, a10, B2);
                }
                if (i10 != 2) {
                    v(view, a12);
                    if (!a12.equals(a11)) {
                        L(view, a11);
                    }
                }
                for (int i15 = i11 + 1; i15 < size; i15++) {
                    View view2 = (View) this.f1879g.get(i15);
                    e eVar2 = (e) view2.getLayoutParams();
                    b e10 = eVar2.e();
                    if (e10 != null && e10.e(this, view2, view)) {
                        if (i10 == 0 && eVar2.f()) {
                            eVar2.j();
                        } else {
                            if (i10 != 2) {
                                z9 = e10.h(this, view2, view);
                            } else {
                                e10.i(this, view2, view);
                                z9 = true;
                            }
                            if (i10 == 1) {
                                eVar2.o(z9);
                            }
                        }
                    }
                }
            }
        }
        M(a10);
        M(a11);
        M(a12);
    }

    public void G(View view, int i10) {
        e eVar = (e) view.getLayoutParams();
        if (eVar.a()) {
            throw new IllegalStateException("An anchor may not be changed after CoordinatorLayout measurement begins before layout is complete.");
        }
        View view2 = eVar.f1911k;
        if (view2 != null) {
            B(view, view2, i10);
            return;
        }
        int i11 = eVar.f1905e;
        if (i11 >= 0) {
            C(view, i11, i10);
        } else {
            A(view, i10);
        }
    }

    public void H(View view, int i10, int i11, int i12, int i13) {
        measureChildWithMargins(view, i10, i11, i12, i13);
    }

    void L(View view, Rect rect) {
        ((e) view.getLayoutParams()).p(rect);
    }

    void N() {
        if (this.f1887o && this.f1891s != null) {
            getViewTreeObserver().removeOnPreDrawListener(this.f1891s);
        }
        this.f1892t = false;
    }

    final y2 U(y2 y2Var) {
        if (v.c.a(this.f1893u, y2Var)) {
            return y2Var;
        }
        this.f1893u = y2Var;
        boolean z9 = true;
        boolean z10 = y2Var != null && y2Var.k() > 0;
        this.f1894v = z10;
        setWillNotDraw((z10 || getBackground() != null) ? false : false);
        y2 e10 = e(y2Var);
        requestLayout();
        return e10;
    }

    void b() {
        if (this.f1887o) {
            if (this.f1891s == null) {
                this.f1891s = new f();
            }
            getViewTreeObserver().addOnPreDrawListener(this.f1891s);
        }
        this.f1892t = true;
    }

    @Override // android.view.ViewGroup
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (layoutParams instanceof e) && super.checkLayoutParams(layoutParams);
    }

    @Override // android.view.ViewGroup
    protected boolean drawChild(Canvas canvas, View view, long j10) {
        e eVar = (e) view.getLayoutParams();
        b bVar = eVar.f1901a;
        if (bVar != null) {
            float d10 = bVar.d(this, view);
            if (d10 > 0.0f) {
                if (this.f1883k == null) {
                    this.f1883k = new Paint();
                }
                this.f1883k.setColor(eVar.f1901a.c(this, view));
                this.f1883k.setAlpha(c(Math.round(d10 * 255.0f), 0, 255));
                int save = canvas.save();
                if (view.isOpaque()) {
                    canvas.clipRect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom(), Region.Op.DIFFERENCE);
                }
                canvas.drawRect(getPaddingLeft(), getPaddingTop(), getWidth() - getPaddingRight(), getHeight() - getPaddingBottom(), this.f1883k);
                canvas.restoreToCount(save);
            }
        }
        return super.drawChild(canvas, view, j10);
    }

    @Override // android.view.ViewGroup, android.view.View
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        int[] drawableState = getDrawableState();
        Drawable drawable = this.f1895w;
        boolean z9 = false;
        if (drawable != null && drawable.isStateful()) {
            z9 = false | drawable.setState(drawableState);
        }
        if (z9) {
            invalidate();
        }
    }

    void f() {
        int childCount = getChildCount();
        boolean z9 = false;
        int i10 = 0;
        while (true) {
            if (i10 >= childCount) {
                break;
            } else if (y(getChildAt(i10))) {
                z9 = true;
                break;
            } else {
                i10++;
            }
        }
        if (z9 != this.f1892t) {
            if (z9) {
                b();
            } else {
                N();
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // android.view.ViewGroup
    /* renamed from: g */
    public e generateDefaultLayoutParams() {
        return new e(-2, -2);
    }

    final List<View> getDependencySortedChildren() {
        K();
        return Collections.unmodifiableList(this.f1879g);
    }

    public final y2 getLastWindowInsets() {
        return this.f1893u;
    }

    @Override // android.view.ViewGroup
    public int getNestedScrollAxes() {
        return this.f1898z.a();
    }

    public Drawable getStatusBarBackground() {
        return this.f1895w;
    }

    @Override // android.view.View
    protected int getSuggestedMinimumHeight() {
        return Math.max(super.getSuggestedMinimumHeight(), getPaddingTop() + getPaddingBottom());
    }

    @Override // android.view.View
    protected int getSuggestedMinimumWidth() {
        return Math.max(super.getSuggestedMinimumWidth(), getPaddingLeft() + getPaddingRight());
    }

    @Override // android.view.ViewGroup
    /* renamed from: h */
    public e generateLayoutParams(AttributeSet attributeSet) {
        return new e(getContext(), attributeSet);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // android.view.ViewGroup
    /* renamed from: i */
    public e generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof e ? new e((e) layoutParams) : layoutParams instanceof ViewGroup.MarginLayoutParams ? new e((ViewGroup.MarginLayoutParams) layoutParams) : new e(layoutParams);
    }

    @Override // androidx.core.view.h0
    public void j(View view, int i10, int i11, int i12, int i13, int i14, int[] iArr) {
        b e10;
        int childCount = getChildCount();
        boolean z9 = false;
        int i15 = 0;
        int i16 = 0;
        for (int i17 = 0; i17 < childCount; i17++) {
            View childAt = getChildAt(i17);
            if (childAt.getVisibility() != 8) {
                e eVar = (e) childAt.getLayoutParams();
                if (eVar.i(i14) && (e10 = eVar.e()) != null) {
                    int[] iArr2 = this.f1884l;
                    iArr2[0] = 0;
                    iArr2[1] = 0;
                    e10.t(this, childAt, view, i10, i11, i12, i13, i14, iArr2);
                    int[] iArr3 = this.f1884l;
                    i15 = i12 > 0 ? Math.max(i15, iArr3[0]) : Math.min(i15, iArr3[0]);
                    i16 = i13 > 0 ? Math.max(i16, this.f1884l[1]) : Math.min(i16, this.f1884l[1]);
                    z9 = true;
                }
            }
        }
        iArr[0] = iArr[0] + i15;
        iArr[1] = iArr[1] + i16;
        if (z9) {
            F(1);
        }
    }

    @Override // androidx.core.view.g0
    public void k(View view, int i10, int i11, int i12, int i13, int i14) {
        j(view, i10, i11, i12, i13, 0, this.f1885m);
    }

    @Override // androidx.core.view.g0
    public boolean l(View view, View view2, int i10, int i11) {
        int childCount = getChildCount();
        boolean z9 = false;
        for (int i12 = 0; i12 < childCount; i12++) {
            View childAt = getChildAt(i12);
            if (childAt.getVisibility() != 8) {
                e eVar = (e) childAt.getLayoutParams();
                b e10 = eVar.e();
                if (e10 != null) {
                    boolean A2 = e10.A(this, childAt, view, view2, i10, i11);
                    z9 |= A2;
                    eVar.q(i11, A2);
                } else {
                    eVar.q(i11, false);
                }
            }
        }
        return z9;
    }

    @Override // androidx.core.view.g0
    public void m(View view, View view2, int i10, int i11) {
        b e10;
        this.f1898z.c(view, view2, i10, i11);
        this.f1890r = view2;
        int childCount = getChildCount();
        for (int i12 = 0; i12 < childCount; i12++) {
            View childAt = getChildAt(i12);
            e eVar = (e) childAt.getLayoutParams();
            if (eVar.i(i11) && (e10 = eVar.e()) != null) {
                e10.v(this, childAt, view, view2, i10, i11);
            }
        }
    }

    @Override // androidx.core.view.g0
    public void n(View view, int i10) {
        this.f1898z.d(view, i10);
        int childCount = getChildCount();
        for (int i11 = 0; i11 < childCount; i11++) {
            View childAt = getChildAt(i11);
            e eVar = (e) childAt.getLayoutParams();
            if (eVar.i(i10)) {
                b e10 = eVar.e();
                if (e10 != null) {
                    e10.C(this, childAt, view, i10);
                }
                eVar.k(i10);
                eVar.j();
            }
        }
        this.f1890r = null;
    }

    @Override // androidx.core.view.g0
    public void o(View view, int i10, int i11, int[] iArr, int i12) {
        b e10;
        int childCount = getChildCount();
        boolean z9 = false;
        int i13 = 0;
        int i14 = 0;
        for (int i15 = 0; i15 < childCount; i15++) {
            View childAt = getChildAt(i15);
            if (childAt.getVisibility() != 8) {
                e eVar = (e) childAt.getLayoutParams();
                if (eVar.i(i12) && (e10 = eVar.e()) != null) {
                    int[] iArr2 = this.f1884l;
                    iArr2[0] = 0;
                    iArr2[1] = 0;
                    e10.q(this, childAt, view, i10, i11, iArr2, i12);
                    int[] iArr3 = this.f1884l;
                    i13 = i10 > 0 ? Math.max(i13, iArr3[0]) : Math.min(i13, iArr3[0]);
                    int[] iArr4 = this.f1884l;
                    i14 = i11 > 0 ? Math.max(i14, iArr4[1]) : Math.min(i14, iArr4[1]);
                    z9 = true;
                }
            }
        }
        iArr[0] = i13;
        iArr[1] = i14;
        if (z9) {
            F(1);
        }
    }

    @Override // android.view.ViewGroup, android.view.View
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        O(false);
        if (this.f1892t) {
            if (this.f1891s == null) {
                this.f1891s = new f();
            }
            getViewTreeObserver().addOnPreDrawListener(this.f1891s);
        }
        if (this.f1893u == null && r0.y(this)) {
            r0.k0(this);
        }
        this.f1887o = true;
    }

    @Override // android.view.ViewGroup, android.view.View
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        O(false);
        if (this.f1892t && this.f1891s != null) {
            getViewTreeObserver().removeOnPreDrawListener(this.f1891s);
        }
        View view = this.f1890r;
        if (view != null) {
            onStopNestedScroll(view);
        }
        this.f1887o = false;
    }

    @Override // android.view.View
    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.f1894v || this.f1895w == null) {
            return;
        }
        y2 y2Var = this.f1893u;
        int k10 = y2Var != null ? y2Var.k() : 0;
        if (k10 > 0) {
            this.f1895w.setBounds(0, 0, getWidth(), k10);
            this.f1895w.draw(canvas);
        }
    }

    @Override // android.view.ViewGroup
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 0) {
            O(true);
        }
        boolean J = J(motionEvent, 0);
        if (actionMasked == 1 || actionMasked == 3) {
            O(true);
        }
        return J;
    }

    @Override // android.view.ViewGroup, android.view.View
    protected void onLayout(boolean z9, int i10, int i11, int i12, int i13) {
        b e10;
        int B2 = r0.B(this);
        int size = this.f1879g.size();
        for (int i14 = 0; i14 < size; i14++) {
            View view = (View) this.f1879g.get(i14);
            if (view.getVisibility() != 8 && ((e10 = ((e) view.getLayoutParams()).e()) == null || !e10.l(this, view, B2))) {
                G(view, B2);
            }
        }
    }

    /* JADX WARN: Code restructure failed: missing block: B:43:0x011a, code lost:
        if (r0.m(r30, r20, r11, r21, r23, 0) == false) goto L33;
     */
    /* JADX WARN: Removed duplicated region for block: B:42:0x00fb  */
    /* JADX WARN: Removed duplicated region for block: B:45:0x011d  */
    @Override // android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    protected void onMeasure(int i10, int i11) {
        int i12;
        int i13;
        int i14;
        int i15;
        b e10;
        e eVar;
        int i16;
        int i17;
        int i18;
        int i19;
        int i20;
        int i21;
        K();
        f();
        int paddingLeft = getPaddingLeft();
        int paddingTop = getPaddingTop();
        int paddingRight = getPaddingRight();
        int paddingBottom = getPaddingBottom();
        int B2 = r0.B(this);
        boolean z9 = B2 == 1;
        int mode = View.MeasureSpec.getMode(i10);
        int size = View.MeasureSpec.getSize(i10);
        int mode2 = View.MeasureSpec.getMode(i11);
        int size2 = View.MeasureSpec.getSize(i11);
        int i22 = paddingLeft + paddingRight;
        int i23 = paddingTop + paddingBottom;
        int suggestedMinimumWidth = getSuggestedMinimumWidth();
        int suggestedMinimumHeight = getSuggestedMinimumHeight();
        boolean z10 = this.f1893u != null && r0.y(this);
        int size3 = this.f1879g.size();
        int i24 = suggestedMinimumWidth;
        int i25 = suggestedMinimumHeight;
        int i26 = 0;
        int i27 = 0;
        while (i27 < size3) {
            View view = (View) this.f1879g.get(i27);
            if (view.getVisibility() == 8) {
                i20 = i27;
                i17 = size3;
                i18 = paddingLeft;
            } else {
                e eVar2 = (e) view.getLayoutParams();
                int i28 = eVar2.f1905e;
                if (i28 < 0 || mode == 0) {
                    i12 = i26;
                } else {
                    int u9 = u(i28);
                    int b10 = i.b(R(eVar2.f1903c), B2) & 7;
                    i12 = i26;
                    if ((b10 == 3 && !z9) || (b10 == 5 && z9)) {
                        i13 = Math.max(0, (size - paddingRight) - u9);
                    } else if ((b10 == 5 && !z9) || (b10 == 3 && z9)) {
                        i13 = Math.max(0, u9 - paddingLeft);
                    }
                    if (z10 || r0.y(view)) {
                        i14 = i10;
                        i15 = i11;
                    } else {
                        i14 = View.MeasureSpec.makeMeasureSpec(size - (this.f1893u.i() + this.f1893u.j()), mode);
                        i15 = View.MeasureSpec.makeMeasureSpec(size2 - (this.f1893u.k() + this.f1893u.h()), mode2);
                    }
                    e10 = eVar2.e();
                    if (e10 == null) {
                        eVar = eVar2;
                        i19 = i12;
                        i20 = i27;
                        i16 = i25;
                        i18 = paddingLeft;
                        i21 = i24;
                        i17 = size3;
                    } else {
                        eVar = eVar2;
                        i16 = i25;
                        i17 = size3;
                        i18 = paddingLeft;
                        i19 = i12;
                        i20 = i27;
                        i21 = i24;
                    }
                    H(view, i14, i13, i15, 0);
                    e eVar3 = eVar;
                    int max = Math.max(i21, i22 + view.getMeasuredWidth() + ((ViewGroup.MarginLayoutParams) eVar3).leftMargin + ((ViewGroup.MarginLayoutParams) eVar3).rightMargin);
                    int max2 = Math.max(i16, i23 + view.getMeasuredHeight() + ((ViewGroup.MarginLayoutParams) eVar3).topMargin + ((ViewGroup.MarginLayoutParams) eVar3).bottomMargin);
                    i26 = View.combineMeasuredStates(i19, view.getMeasuredState());
                    i24 = max;
                    i25 = max2;
                }
                i13 = 0;
                if (z10) {
                }
                i14 = i10;
                i15 = i11;
                e10 = eVar2.e();
                if (e10 == null) {
                }
                H(view, i14, i13, i15, 0);
                e eVar32 = eVar;
                int max3 = Math.max(i21, i22 + view.getMeasuredWidth() + ((ViewGroup.MarginLayoutParams) eVar32).leftMargin + ((ViewGroup.MarginLayoutParams) eVar32).rightMargin);
                int max22 = Math.max(i16, i23 + view.getMeasuredHeight() + ((ViewGroup.MarginLayoutParams) eVar32).topMargin + ((ViewGroup.MarginLayoutParams) eVar32).bottomMargin);
                i26 = View.combineMeasuredStates(i19, view.getMeasuredState());
                i24 = max3;
                i25 = max22;
            }
            i27 = i20 + 1;
            paddingLeft = i18;
            size3 = i17;
        }
        int i29 = i26;
        setMeasuredDimension(View.resolveSizeAndState(i24, i10, (-16777216) & i29), View.resolveSizeAndState(i25, i11, i29 << 16));
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public boolean onNestedFling(View view, float f10, float f11, boolean z9) {
        b e10;
        int childCount = getChildCount();
        boolean z10 = false;
        for (int i10 = 0; i10 < childCount; i10++) {
            View childAt = getChildAt(i10);
            if (childAt.getVisibility() != 8) {
                e eVar = (e) childAt.getLayoutParams();
                if (eVar.i(0) && (e10 = eVar.e()) != null) {
                    z10 |= e10.n(this, childAt, view, f10, f11, z9);
                }
            }
        }
        if (z10) {
            F(1);
        }
        return z10;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public boolean onNestedPreFling(View view, float f10, float f11) {
        b e10;
        int childCount = getChildCount();
        boolean z9 = false;
        for (int i10 = 0; i10 < childCount; i10++) {
            View childAt = getChildAt(i10);
            if (childAt.getVisibility() != 8) {
                e eVar = (e) childAt.getLayoutParams();
                if (eVar.i(0) && (e10 = eVar.e()) != null) {
                    z9 |= e10.o(this, childAt, view, f10, f11);
                }
            }
        }
        return z9;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public void onNestedPreScroll(View view, int i10, int i11, int[] iArr) {
        o(view, i10, i11, iArr, 0);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public void onNestedScroll(View view, int i10, int i11, int i12, int i13) {
        k(view, i10, i11, i12, i13, 0);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public void onNestedScrollAccepted(View view, View view2, int i10) {
        m(view, view2, i10, 0);
    }

    @Override // android.view.View
    protected void onRestoreInstanceState(Parcelable parcelable) {
        Parcelable parcelable2;
        if (!(parcelable instanceof g)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        g gVar = (g) parcelable;
        super.onRestoreInstanceState(gVar.a());
        SparseArray sparseArray = gVar.f1920i;
        int childCount = getChildCount();
        for (int i10 = 0; i10 < childCount; i10++) {
            View childAt = getChildAt(i10);
            int id = childAt.getId();
            b e10 = w(childAt).e();
            if (id != -1 && e10 != null && (parcelable2 = (Parcelable) sparseArray.get(id)) != null) {
                e10.x(this, childAt, parcelable2);
            }
        }
    }

    @Override // android.view.View
    protected Parcelable onSaveInstanceState() {
        Parcelable y9;
        g gVar = new g(super.onSaveInstanceState());
        SparseArray sparseArray = new SparseArray();
        int childCount = getChildCount();
        for (int i10 = 0; i10 < childCount; i10++) {
            View childAt = getChildAt(i10);
            int id = childAt.getId();
            b e10 = ((e) childAt.getLayoutParams()).e();
            if (id != -1 && e10 != null && (y9 = e10.y(this, childAt)) != null) {
                sparseArray.append(id, y9);
            }
        }
        gVar.f1920i = sparseArray;
        return gVar;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public boolean onStartNestedScroll(View view, View view2, int i10) {
        return l(view, view2, i10, 0);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public void onStopNestedScroll(View view) {
        n(view, 0);
    }

    /* JADX WARN: Code restructure failed: missing block: B:5:0x0012, code lost:
        if (r3 != false) goto L19;
     */
    /* JADX WARN: Removed duplicated region for block: B:14:0x0031  */
    /* JADX WARN: Removed duplicated region for block: B:15:0x0037  */
    /* JADX WARN: Removed duplicated region for block: B:18:0x004c  */
    @Override // android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean z9;
        boolean D2;
        MotionEvent motionEvent2;
        int actionMasked = motionEvent.getActionMasked();
        if (this.f1889q == null) {
            z9 = J(motionEvent, 1);
        } else {
            z9 = false;
        }
        b e10 = ((e) this.f1889q.getLayoutParams()).e();
        if (e10 != null) {
            D2 = e10.D(this, this.f1889q, motionEvent);
            motionEvent2 = null;
            if (this.f1889q != null) {
                D2 |= super.onTouchEvent(motionEvent);
            } else if (z9) {
                long uptimeMillis = SystemClock.uptimeMillis();
                motionEvent2 = MotionEvent.obtain(uptimeMillis, uptimeMillis, 3, 0.0f, 0.0f, 0);
                super.onTouchEvent(motionEvent2);
            }
            if (motionEvent2 != null) {
                motionEvent2.recycle();
            }
            if (actionMasked != 1 || actionMasked == 3) {
                O(false);
            }
            return D2;
        }
        D2 = false;
        motionEvent2 = null;
        if (this.f1889q != null) {
        }
        if (motionEvent2 != null) {
        }
        if (actionMasked != 1) {
        }
        O(false);
        return D2;
    }

    void p(View view, boolean z9, Rect rect) {
        if (view.isLayoutRequested() || view.getVisibility() == 8) {
            rect.setEmpty();
        } else if (z9) {
            r(view, rect);
        } else {
            rect.set(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        }
    }

    public List q(View view) {
        List g10 = this.f1880h.g(view);
        this.f1882j.clear();
        if (g10 != null) {
            this.f1882j.addAll(g10);
        }
        return this.f1882j;
    }

    void r(View view, Rect rect) {
        androidx.coordinatorlayout.widget.b.a(this, view, rect);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean z9) {
        b e10 = ((e) view.getLayoutParams()).e();
        if (e10 == null || !e10.w(this, view, rect, z9)) {
            return super.requestChildRectangleOnScreen(view, rect, z9);
        }
        return true;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public void requestDisallowInterceptTouchEvent(boolean z9) {
        super.requestDisallowInterceptTouchEvent(z9);
        if (!z9 || this.f1886n) {
            return;
        }
        O(false);
        this.f1886n = true;
    }

    void s(View view, int i10, Rect rect, Rect rect2) {
        e eVar = (e) view.getLayoutParams();
        int measuredWidth = view.getMeasuredWidth();
        int measuredHeight = view.getMeasuredHeight();
        t(view, i10, rect, rect2, eVar, measuredWidth, measuredHeight);
        d(eVar, rect2, measuredWidth, measuredHeight);
    }

    @Override // android.view.View
    public void setFitsSystemWindows(boolean z9) {
        super.setFitsSystemWindows(z9);
        V();
    }

    @Override // android.view.ViewGroup
    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
        this.f1896x = onHierarchyChangeListener;
    }

    public void setStatusBarBackground(Drawable drawable) {
        Drawable drawable2 = this.f1895w;
        if (drawable2 != drawable) {
            if (drawable2 != null) {
                drawable2.setCallback(null);
            }
            Drawable mutate = drawable != null ? drawable.mutate() : null;
            this.f1895w = mutate;
            if (mutate != null) {
                if (mutate.isStateful()) {
                    this.f1895w.setState(getDrawableState());
                }
                androidx.core.graphics.drawable.a.m(this.f1895w, r0.B(this));
                this.f1895w.setVisible(getVisibility() == 0, false);
                this.f1895w.setCallback(this);
            }
            r0.e0(this);
        }
    }

    public void setStatusBarBackgroundColor(int i10) {
        setStatusBarBackground(new ColorDrawable(i10));
    }

    public void setStatusBarBackgroundResource(int i10) {
        setStatusBarBackground(i10 != 0 ? androidx.core.content.a.d(getContext(), i10) : null);
    }

    @Override // android.view.View
    public void setVisibility(int i10) {
        super.setVisibility(i10);
        boolean z9 = i10 == 0;
        Drawable drawable = this.f1895w;
        if (drawable == null || drawable.isVisible() == z9) {
            return;
        }
        this.f1895w.setVisible(z9, false);
    }

    void v(View view, Rect rect) {
        rect.set(((e) view.getLayoutParams()).g());
    }

    @Override // android.view.View
    protected boolean verifyDrawable(Drawable drawable) {
        return super.verifyDrawable(drawable) || drawable == this.f1895w;
    }

    e w(View view) {
        e eVar = (e) view.getLayoutParams();
        if (!eVar.f1902b) {
            c cVar = null;
            for (Class<?> cls = view.getClass(); cls != null; cls = cls.getSuperclass()) {
                cVar = (c) cls.getAnnotation(c.class);
                if (cVar != null) {
                    break;
                }
            }
            if (cVar != null) {
                try {
                    eVar.n((b) cVar.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                } catch (Exception e10) {
                    Log.e("CoordinatorLayout", "Default behavior class " + cVar.value().getName() + " could not be instantiated. Did you forget a default constructor?", e10);
                }
            }
            eVar.f1902b = true;
        }
        return eVar;
    }

    public boolean z(View view, int i10, int i11) {
        Rect a10 = a();
        r(view, a10);
        try {
            return a10.contains(i10, i11);
        } finally {
            M(a10);
        }
    }
}
