package androidx.concurrent.futures;

import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
/* loaded from: classes.dex */
public abstract class a implements v6.e {

    /* renamed from: j  reason: collision with root package name */
    static final boolean f1855j = Boolean.parseBoolean(System.getProperty("guava.concurrent.generate_cancellation_cause", "false"));

    /* renamed from: k  reason: collision with root package name */
    private static final Logger f1856k = Logger.getLogger(a.class.getName());

    /* renamed from: l  reason: collision with root package name */
    static final b f1857l;

    /* renamed from: m  reason: collision with root package name */
    private static final Object f1858m;

    /* renamed from: g  reason: collision with root package name */
    volatile Object f1859g;

    /* renamed from: h  reason: collision with root package name */
    volatile e f1860h;

    /* renamed from: i  reason: collision with root package name */
    volatile h f1861i;

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static abstract class b {
        private b() {
        }

        abstract boolean a(a aVar, e eVar, e eVar2);

        abstract boolean b(a aVar, Object obj, Object obj2);

        abstract boolean c(a aVar, h hVar, h hVar2);

        abstract void d(h hVar, h hVar2);

        abstract void e(h hVar, Thread thread);
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static final class c {

        /* renamed from: c  reason: collision with root package name */
        static final c f1862c;

        /* renamed from: d  reason: collision with root package name */
        static final c f1863d;

        /* renamed from: a  reason: collision with root package name */
        final boolean f1864a;

        /* renamed from: b  reason: collision with root package name */
        final Throwable f1865b;

        static {
            if (a.f1855j) {
                f1863d = null;
                f1862c = null;
                return;
            }
            f1863d = new c(false, null);
            f1862c = new c(true, null);
        }

        c(boolean z9, Throwable th) {
            this.f1864a = z9;
            this.f1865b = th;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static final class d {

        /* renamed from: a  reason: collision with root package name */
        final Throwable f1866a;
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static final class e {

        /* renamed from: d  reason: collision with root package name */
        static final e f1867d = new e(null, null);

        /* renamed from: a  reason: collision with root package name */
        final Runnable f1868a;

        /* renamed from: b  reason: collision with root package name */
        final Executor f1869b;

        /* renamed from: c  reason: collision with root package name */
        e f1870c;

        e(Runnable runnable, Executor executor) {
            this.f1868a = runnable;
            this.f1869b = executor;
        }
    }

    /* loaded from: classes.dex */
    private static final class f extends b {

        /* renamed from: a  reason: collision with root package name */
        final AtomicReferenceFieldUpdater f1871a;

        /* renamed from: b  reason: collision with root package name */
        final AtomicReferenceFieldUpdater f1872b;

        /* renamed from: c  reason: collision with root package name */
        final AtomicReferenceFieldUpdater f1873c;

        /* renamed from: d  reason: collision with root package name */
        final AtomicReferenceFieldUpdater f1874d;

        /* renamed from: e  reason: collision with root package name */
        final AtomicReferenceFieldUpdater f1875e;

        f(AtomicReferenceFieldUpdater atomicReferenceFieldUpdater, AtomicReferenceFieldUpdater atomicReferenceFieldUpdater2, AtomicReferenceFieldUpdater atomicReferenceFieldUpdater3, AtomicReferenceFieldUpdater atomicReferenceFieldUpdater4, AtomicReferenceFieldUpdater atomicReferenceFieldUpdater5) {
            super();
            this.f1871a = atomicReferenceFieldUpdater;
            this.f1872b = atomicReferenceFieldUpdater2;
            this.f1873c = atomicReferenceFieldUpdater3;
            this.f1874d = atomicReferenceFieldUpdater4;
            this.f1875e = atomicReferenceFieldUpdater5;
        }

        @Override // androidx.concurrent.futures.a.b
        boolean a(a aVar, e eVar, e eVar2) {
            return androidx.concurrent.futures.b.a(this.f1874d, aVar, eVar, eVar2);
        }

        @Override // androidx.concurrent.futures.a.b
        boolean b(a aVar, Object obj, Object obj2) {
            return androidx.concurrent.futures.b.a(this.f1875e, aVar, obj, obj2);
        }

        @Override // androidx.concurrent.futures.a.b
        boolean c(a aVar, h hVar, h hVar2) {
            return androidx.concurrent.futures.b.a(this.f1873c, aVar, hVar, hVar2);
        }

        @Override // androidx.concurrent.futures.a.b
        void d(h hVar, h hVar2) {
            this.f1872b.lazySet(hVar, hVar2);
        }

        @Override // androidx.concurrent.futures.a.b
        void e(h hVar, Thread thread) {
            this.f1871a.lazySet(hVar, thread);
        }
    }

    /* loaded from: classes.dex */
    private static final class g extends b {
        g() {
            super();
        }

        @Override // androidx.concurrent.futures.a.b
        boolean a(a aVar, e eVar, e eVar2) {
            synchronized (aVar) {
                if (aVar.f1860h == eVar) {
                    aVar.f1860h = eVar2;
                    return true;
                }
                return false;
            }
        }

        @Override // androidx.concurrent.futures.a.b
        boolean b(a aVar, Object obj, Object obj2) {
            synchronized (aVar) {
                if (aVar.f1859g == obj) {
                    aVar.f1859g = obj2;
                    return true;
                }
                return false;
            }
        }

        @Override // androidx.concurrent.futures.a.b
        boolean c(a aVar, h hVar, h hVar2) {
            synchronized (aVar) {
                if (aVar.f1861i == hVar) {
                    aVar.f1861i = hVar2;
                    return true;
                }
                return false;
            }
        }

        @Override // androidx.concurrent.futures.a.b
        void d(h hVar, h hVar2) {
            hVar.f1878b = hVar2;
        }

        @Override // androidx.concurrent.futures.a.b
        void e(h hVar, Thread thread) {
            hVar.f1877a = thread;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static final class h {

        /* renamed from: c  reason: collision with root package name */
        static final h f1876c = new h(false);

        /* renamed from: a  reason: collision with root package name */
        volatile Thread f1877a;

        /* renamed from: b  reason: collision with root package name */
        volatile h f1878b;

        h() {
            a.f1857l.e(this, Thread.currentThread());
        }

        h(boolean z9) {
        }

        void a(h hVar) {
            a.f1857l.d(this, hVar);
        }

        void b() {
            Thread thread = this.f1877a;
            if (thread != null) {
                this.f1877a = null;
                LockSupport.unpark(thread);
            }
        }
    }

    static {
        b gVar;
        try {
            gVar = new f(AtomicReferenceFieldUpdater.newUpdater(h.class, Thread.class, "a"), AtomicReferenceFieldUpdater.newUpdater(h.class, h.class, "b"), AtomicReferenceFieldUpdater.newUpdater(a.class, h.class, "i"), AtomicReferenceFieldUpdater.newUpdater(a.class, e.class, "h"), AtomicReferenceFieldUpdater.newUpdater(a.class, Object.class, "g"));
            th = null;
        } catch (Throwable th) {
            th = th;
            gVar = new g();
        }
        f1857l = gVar;
        if (th != null) {
            f1856k.log(Level.SEVERE, "SafeAtomicHelper is broken!", th);
        }
        f1858m = new Object();
    }

    private void a(StringBuilder sb) {
        String str = "]";
        try {
            Object j10 = j(this);
            sb.append("SUCCESS, result=[");
            sb.append(p(j10));
            sb.append("]");
        } catch (CancellationException unused) {
            str = "CANCELLED";
            sb.append(str);
        } catch (RuntimeException e10) {
            sb.append("UNKNOWN, cause=[");
            sb.append(e10.getClass());
            str = " thrown from get()]";
            sb.append(str);
        } catch (ExecutionException e11) {
            sb.append("FAILURE, cause=[");
            sb.append(e11.getCause());
            sb.append(str);
        }
    }

    private static CancellationException d(String str, Throwable th) {
        CancellationException cancellationException = new CancellationException(str);
        cancellationException.initCause(th);
        return cancellationException;
    }

    static Object e(Object obj) {
        obj.getClass();
        return obj;
    }

    private e f(e eVar) {
        e eVar2;
        do {
            eVar2 = this.f1860h;
        } while (!f1857l.a(this, eVar2, e.f1867d));
        e eVar3 = eVar;
        e eVar4 = eVar2;
        while (eVar4 != null) {
            e eVar5 = eVar4.f1870c;
            eVar4.f1870c = eVar3;
            eVar3 = eVar4;
            eVar4 = eVar5;
        }
        return eVar3;
    }

    static void g(a aVar) {
        aVar.m();
        aVar.b();
        e f10 = aVar.f(null);
        while (f10 != null) {
            e eVar = f10.f1870c;
            h(f10.f1868a, f10.f1869b);
            f10 = eVar;
        }
    }

    private static void h(Runnable runnable, Executor executor) {
        try {
            executor.execute(runnable);
        } catch (RuntimeException e10) {
            Logger logger = f1856k;
            Level level = Level.SEVERE;
            logger.log(level, "RuntimeException while executing runnable " + runnable + " with executor " + executor, (Throwable) e10);
        }
    }

    private Object i(Object obj) {
        if (obj instanceof c) {
            throw d("Task was cancelled.", ((c) obj).f1865b);
        }
        if (obj instanceof d) {
            throw new ExecutionException(((d) obj).f1866a);
        }
        if (obj == f1858m) {
            return null;
        }
        return obj;
    }

    static Object j(Future future) {
        Object obj;
        boolean z9 = false;
        while (true) {
            try {
                obj = future.get();
                break;
            } catch (InterruptedException unused) {
                z9 = true;
            } catch (Throwable th) {
                if (z9) {
                    Thread.currentThread().interrupt();
                }
                throw th;
            }
        }
        if (z9) {
            Thread.currentThread().interrupt();
        }
        return obj;
    }

    private void m() {
        h hVar;
        do {
            hVar = this.f1861i;
        } while (!f1857l.c(this, hVar, h.f1876c));
        while (hVar != null) {
            hVar.b();
            hVar = hVar.f1878b;
        }
    }

    private void n(h hVar) {
        hVar.f1877a = null;
        while (true) {
            h hVar2 = this.f1861i;
            if (hVar2 == h.f1876c) {
                return;
            }
            h hVar3 = null;
            while (hVar2 != null) {
                h hVar4 = hVar2.f1878b;
                if (hVar2.f1877a != null) {
                    hVar3 = hVar2;
                } else if (hVar3 != null) {
                    hVar3.f1878b = hVar4;
                    if (hVar3.f1877a == null) {
                        break;
                    }
                } else if (!f1857l.c(this, hVar2, hVar4)) {
                    break;
                }
                hVar2 = hVar4;
            }
            return;
        }
    }

    private String p(Object obj) {
        return obj == this ? "this future" : String.valueOf(obj);
    }

    protected void b() {
    }

    @Override // v6.e
    public final void c(Runnable runnable, Executor executor) {
        e(runnable);
        e(executor);
        e eVar = this.f1860h;
        if (eVar == e.f1867d) {
            h(runnable, executor);
        }
        e eVar2 = new e(runnable, executor);
        do {
            eVar2.f1870c = eVar;
            if (f1857l.a(this, eVar, eVar2)) {
                return;
            }
            eVar = this.f1860h;
        } while (eVar != e.f1867d);
        h(runnable, executor);
    }

    @Override // java.util.concurrent.Future
    public final boolean cancel(boolean z9) {
        Object obj = this.f1859g;
        if ((obj == null) | false) {
            if (f1857l.b(this, obj, f1855j ? new c(z9, new CancellationException("Future.cancel() was called.")) : z9 ? c.f1862c : c.f1863d)) {
                if (z9) {
                    k();
                }
                g(this);
                return true;
            }
        }
        return false;
    }

    @Override // java.util.concurrent.Future
    public final Object get() {
        Object obj;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object obj2 = this.f1859g;
        if ((obj2 != null) && true) {
            return i(obj2);
        }
        h hVar = this.f1861i;
        if (hVar != h.f1876c) {
            h hVar2 = new h();
            do {
                hVar2.a(hVar);
                if (f1857l.c(this, hVar, hVar2)) {
                    do {
                        LockSupport.park(this);
                        if (Thread.interrupted()) {
                            n(hVar2);
                            throw new InterruptedException();
                        }
                        obj = this.f1859g;
                    } while (!((obj != null) & true));
                    return i(obj);
                }
                hVar = this.f1861i;
            } while (hVar != h.f1876c);
            return i(this.f1859g);
        }
        return i(this.f1859g);
    }

    @Override // java.util.concurrent.Future
    public final Object get(long j10, TimeUnit timeUnit) {
        Locale locale;
        long nanos = timeUnit.toNanos(j10);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object obj = this.f1859g;
        if ((obj != null) && true) {
            return i(obj);
        }
        long nanoTime = nanos > 0 ? System.nanoTime() + nanos : 0L;
        if (nanos >= 1000) {
            h hVar = this.f1861i;
            if (hVar != h.f1876c) {
                h hVar2 = new h();
                do {
                    hVar2.a(hVar);
                    if (f1857l.c(this, hVar, hVar2)) {
                        do {
                            LockSupport.parkNanos(this, nanos);
                            if (Thread.interrupted()) {
                                n(hVar2);
                                throw new InterruptedException();
                            }
                            Object obj2 = this.f1859g;
                            if ((obj2 != null) && true) {
                                return i(obj2);
                            }
                            nanos = nanoTime - System.nanoTime();
                        } while (nanos >= 1000);
                        n(hVar2);
                    } else {
                        hVar = this.f1861i;
                    }
                } while (hVar != h.f1876c);
                return i(this.f1859g);
            }
            return i(this.f1859g);
        }
        while (nanos > 0) {
            Object obj3 = this.f1859g;
            if ((obj3 != null) && true) {
                return i(obj3);
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            nanos = nanoTime - System.nanoTime();
        }
        String aVar = toString();
        String lowerCase = timeUnit.toString().toLowerCase(Locale.ROOT);
        String str = "Waited " + j10 + " " + timeUnit.toString().toLowerCase(locale);
        if (nanos + 1000 < 0) {
            String str2 = str + " (plus ";
            long j11 = -nanos;
            long convert = timeUnit.convert(j11, TimeUnit.NANOSECONDS);
            long nanos2 = j11 - timeUnit.toNanos(convert);
            int i10 = (convert > 0L ? 1 : (convert == 0L ? 0 : -1));
            boolean z9 = i10 == 0 || nanos2 > 1000;
            if (i10 > 0) {
                String str3 = str2 + convert + " " + lowerCase;
                if (z9) {
                    str3 = str3 + ",";
                }
                str2 = str3 + " ";
            }
            if (z9) {
                str2 = str2 + nanos2 + " nanoseconds ";
            }
            str = str2 + "delay)";
        }
        if (isDone()) {
            throw new TimeoutException(str + " but future completed as timeout expired");
        }
        throw new TimeoutException(str + " for " + aVar);
    }

    @Override // java.util.concurrent.Future
    public final boolean isCancelled() {
        return this.f1859g instanceof c;
    }

    @Override // java.util.concurrent.Future
    public final boolean isDone() {
        return (this.f1859g != null) & true;
    }

    protected void k() {
    }

    protected String l() {
        if (this instanceof ScheduledFuture) {
            return "remaining delay=[" + ((ScheduledFuture) this).getDelay(TimeUnit.MILLISECONDS) + " ms]";
        }
        return null;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public boolean o(Object obj) {
        if (obj == null) {
            obj = f1858m;
        }
        if (f1857l.b(this, null, obj)) {
            g(this);
            return true;
        }
        return false;
    }

    public String toString() {
        String str;
        String str2;
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("[status=");
        if (!isCancelled()) {
            if (!isDone()) {
                try {
                    str = l();
                } catch (RuntimeException e10) {
                    str = "Exception thrown from implementation: " + e10.getClass();
                }
                if (str != null && !str.isEmpty()) {
                    sb.append("PENDING, info=[");
                    sb.append(str);
                    sb.append("]");
                    sb.append("]");
                    return sb.toString();
                }
                str2 = isDone() ? "PENDING" : "PENDING";
            }
            a(sb);
            sb.append("]");
            return sb.toString();
        }
        str2 = "CANCELLED";
        sb.append(str2);
        sb.append("]");
        return sb.toString();
    }
}
