package androidx.browser.customtabs;

import android.app.ActivityOptions;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.LocaleList;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.SparseArray;
import androidx.browser.customtabs.a;
import java.util.ArrayList;
/* loaded from: classes.dex */
public final class d {

    /* renamed from: a  reason: collision with root package name */
    public final Intent f1843a;

    /* renamed from: b  reason: collision with root package name */
    public final Bundle f1844b;

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class a {
        static ActivityOptions a() {
            ActivityOptions makeBasic;
            makeBasic = ActivityOptions.makeBasic();
            return makeBasic;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class b {
        static String a() {
            LocaleList adjustedDefault = LocaleList.getAdjustedDefault();
            if (adjustedDefault.size() > 0) {
                return adjustedDefault.get(0).toLanguageTag();
            }
            return null;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class c {
        static void a(ActivityOptions activityOptions, boolean z9) {
            activityOptions.setShareIdentityEnabled(z9);
        }
    }

    /* renamed from: androidx.browser.customtabs.d$d  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public static final class C0010d {

        /* renamed from: c  reason: collision with root package name */
        private ArrayList f1847c;

        /* renamed from: d  reason: collision with root package name */
        private ActivityOptions f1848d;

        /* renamed from: e  reason: collision with root package name */
        private ArrayList f1849e;

        /* renamed from: f  reason: collision with root package name */
        private SparseArray f1850f;

        /* renamed from: g  reason: collision with root package name */
        private Bundle f1851g;

        /* renamed from: j  reason: collision with root package name */
        private boolean f1854j;

        /* renamed from: a  reason: collision with root package name */
        private final Intent f1845a = new Intent("android.intent.action.VIEW");

        /* renamed from: b  reason: collision with root package name */
        private final a.C0009a f1846b = new a.C0009a();

        /* renamed from: h  reason: collision with root package name */
        private int f1852h = 0;

        /* renamed from: i  reason: collision with root package name */
        private boolean f1853i = true;

        private void b() {
            String a10 = b.a();
            if (TextUtils.isEmpty(a10)) {
                return;
            }
            Bundle bundleExtra = this.f1845a.hasExtra("com.android.browser.headers") ? this.f1845a.getBundleExtra("com.android.browser.headers") : new Bundle();
            if (bundleExtra.containsKey("Accept-Language")) {
                return;
            }
            bundleExtra.putString("Accept-Language", a10);
            this.f1845a.putExtra("com.android.browser.headers", bundleExtra);
        }

        private void c(IBinder iBinder, PendingIntent pendingIntent) {
            Bundle bundle = new Bundle();
            bundle.putBinder("android.support.customtabs.extra.SESSION", iBinder);
            if (pendingIntent != null) {
                bundle.putParcelable("android.support.customtabs.extra.SESSION_ID", pendingIntent);
            }
            this.f1845a.putExtras(bundle);
        }

        private void d() {
            if (this.f1848d == null) {
                this.f1848d = a.a();
            }
            c.a(this.f1848d, this.f1854j);
        }

        public d a() {
            if (!this.f1845a.hasExtra("android.support.customtabs.extra.SESSION")) {
                c(null, null);
            }
            ArrayList<? extends Parcelable> arrayList = this.f1847c;
            if (arrayList != null) {
                this.f1845a.putParcelableArrayListExtra("android.support.customtabs.extra.MENU_ITEMS", arrayList);
            }
            ArrayList<? extends Parcelable> arrayList2 = this.f1849e;
            if (arrayList2 != null) {
                this.f1845a.putParcelableArrayListExtra("android.support.customtabs.extra.TOOLBAR_ITEMS", arrayList2);
            }
            this.f1845a.putExtra("android.support.customtabs.extra.EXTRA_ENABLE_INSTANT_APPS", this.f1853i);
            this.f1845a.putExtras(this.f1846b.a().a());
            Bundle bundle = this.f1851g;
            if (bundle != null) {
                this.f1845a.putExtras(bundle);
            }
            if (this.f1850f != null) {
                Bundle bundle2 = new Bundle();
                bundle2.putSparseParcelableArray("androidx.browser.customtabs.extra.COLOR_SCHEME_PARAMS", this.f1850f);
                this.f1845a.putExtras(bundle2);
            }
            this.f1845a.putExtra("androidx.browser.customtabs.extra.SHARE_STATE", this.f1852h);
            int i10 = Build.VERSION.SDK_INT;
            if (i10 >= 24) {
                b();
            }
            if (i10 >= 34) {
                d();
            }
            ActivityOptions activityOptions = this.f1848d;
            return new d(this.f1845a, activityOptions != null ? activityOptions.toBundle() : null);
        }

        public C0010d e(boolean z9) {
            this.f1845a.putExtra("android.support.customtabs.extra.TITLE_VISIBILITY", z9 ? 1 : 0);
            return this;
        }
    }

    d(Intent intent, Bundle bundle) {
        this.f1843a = intent;
        this.f1844b = bundle;
    }

    public void a(Context context, Uri uri) {
        this.f1843a.setData(uri);
        androidx.core.content.a.k(context, this.f1843a, this.f1844b);
    }
}
