package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.LocaleList;
import android.text.method.PasswordTransformationMethod;
import android.util.AttributeSet;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.TextView;
import androidx.core.content.res.h;
import java.lang.ref.WeakReference;
import java.util.Locale;
/* loaded from: classes.dex */
class w0 {

    /* renamed from: a  reason: collision with root package name */
    private final TextView f1806a;

    /* renamed from: b  reason: collision with root package name */
    private i2 f1807b;

    /* renamed from: c  reason: collision with root package name */
    private i2 f1808c;

    /* renamed from: d  reason: collision with root package name */
    private i2 f1809d;

    /* renamed from: e  reason: collision with root package name */
    private i2 f1810e;

    /* renamed from: f  reason: collision with root package name */
    private i2 f1811f;

    /* renamed from: g  reason: collision with root package name */
    private i2 f1812g;

    /* renamed from: h  reason: collision with root package name */
    private i2 f1813h;

    /* renamed from: i  reason: collision with root package name */
    private final e1 f1814i;

    /* renamed from: j  reason: collision with root package name */
    private int f1815j = 0;

    /* renamed from: k  reason: collision with root package name */
    private int f1816k = -1;

    /* renamed from: l  reason: collision with root package name */
    private Typeface f1817l;

    /* renamed from: m  reason: collision with root package name */
    private boolean f1818m;

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class a extends h.e {

        /* renamed from: a  reason: collision with root package name */
        final /* synthetic */ int f1819a;

        /* renamed from: b  reason: collision with root package name */
        final /* synthetic */ int f1820b;

        /* renamed from: c  reason: collision with root package name */
        final /* synthetic */ WeakReference f1821c;

        a(int i10, int i11, WeakReference weakReference) {
            this.f1819a = i10;
            this.f1820b = i11;
            this.f1821c = weakReference;
        }

        @Override // androidx.core.content.res.h.e
        public void h(int i10) {
        }

        @Override // androidx.core.content.res.h.e
        public void i(Typeface typeface) {
            int i10;
            if (Build.VERSION.SDK_INT >= 28 && (i10 = this.f1819a) != -1) {
                typeface = g.a(typeface, i10, (this.f1820b & 2) != 0);
            }
            w0.this.n(this.f1821c, typeface);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class b implements Runnable {

        /* renamed from: g  reason: collision with root package name */
        final /* synthetic */ TextView f1823g;

        /* renamed from: h  reason: collision with root package name */
        final /* synthetic */ Typeface f1824h;

        /* renamed from: i  reason: collision with root package name */
        final /* synthetic */ int f1825i;

        b(TextView textView, Typeface typeface, int i10) {
            this.f1823g = textView;
            this.f1824h = typeface;
            this.f1825i = i10;
        }

        @Override // java.lang.Runnable
        public void run() {
            this.f1823g.setTypeface(this.f1824h, this.f1825i);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class c {
        static Drawable[] a(TextView textView) {
            return textView.getCompoundDrawablesRelative();
        }

        static void b(TextView textView, Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
            textView.setCompoundDrawablesRelativeWithIntrinsicBounds(drawable, drawable2, drawable3, drawable4);
        }

        static void c(TextView textView, Locale locale) {
            textView.setTextLocale(locale);
        }
    }

    /* loaded from: classes.dex */
    static class d {
        static Locale a(String str) {
            return Locale.forLanguageTag(str);
        }
    }

    /* loaded from: classes.dex */
    static class e {
        static LocaleList a(String str) {
            return LocaleList.forLanguageTags(str);
        }

        static void b(TextView textView, LocaleList localeList) {
            textView.setTextLocales(localeList);
        }
    }

    /* loaded from: classes.dex */
    static class f {
        static int a(TextView textView) {
            int autoSizeStepGranularity;
            autoSizeStepGranularity = textView.getAutoSizeStepGranularity();
            return autoSizeStepGranularity;
        }

        static void b(TextView textView, int i10, int i11, int i12, int i13) {
            textView.setAutoSizeTextTypeUniformWithConfiguration(i10, i11, i12, i13);
        }

        static void c(TextView textView, int[] iArr, int i10) {
            textView.setAutoSizeTextTypeUniformWithPresetSizes(iArr, i10);
        }

        static boolean d(TextView textView, String str) {
            boolean fontVariationSettings;
            fontVariationSettings = textView.setFontVariationSettings(str);
            return fontVariationSettings;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class g {
        static Typeface a(Typeface typeface, int i10, boolean z9) {
            Typeface create;
            create = Typeface.create(typeface, i10, z9);
            return create;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public w0(TextView textView) {
        this.f1806a = textView;
        this.f1814i = new e1(textView);
    }

    private void B(int i10, float f10) {
        this.f1814i.t(i10, f10);
    }

    private void C(Context context, k2 k2Var) {
        String o10;
        Typeface create;
        Typeface typeface;
        this.f1815j = k2Var.k(g.j.H2, this.f1815j);
        int i10 = Build.VERSION.SDK_INT;
        if (i10 >= 28) {
            int k10 = k2Var.k(g.j.M2, -1);
            this.f1816k = k10;
            if (k10 != -1) {
                this.f1815j = (this.f1815j & 2) | 0;
            }
        }
        int i11 = g.j.L2;
        if (!k2Var.s(i11) && !k2Var.s(g.j.N2)) {
            int i12 = g.j.G2;
            if (k2Var.s(i12)) {
                this.f1818m = false;
                int k11 = k2Var.k(i12, 1);
                if (k11 == 1) {
                    typeface = Typeface.SANS_SERIF;
                } else if (k11 == 2) {
                    typeface = Typeface.SERIF;
                } else if (k11 != 3) {
                    return;
                } else {
                    typeface = Typeface.MONOSPACE;
                }
                this.f1817l = typeface;
                return;
            }
            return;
        }
        this.f1817l = null;
        int i13 = g.j.N2;
        if (k2Var.s(i13)) {
            i11 = i13;
        }
        int i14 = this.f1816k;
        int i15 = this.f1815j;
        if (!context.isRestricted()) {
            try {
                Typeface j10 = k2Var.j(i11, this.f1815j, new a(i14, i15, new WeakReference(this.f1806a)));
                if (j10 != null) {
                    if (i10 >= 28 && this.f1816k != -1) {
                        j10 = g.a(Typeface.create(j10, 0), this.f1816k, (this.f1815j & 2) != 0);
                    }
                    this.f1817l = j10;
                }
                this.f1818m = this.f1817l == null;
            } catch (Resources.NotFoundException | UnsupportedOperationException unused) {
            }
        }
        if (this.f1817l != null || (o10 = k2Var.o(i11)) == null) {
            return;
        }
        if (Build.VERSION.SDK_INT < 28 || this.f1816k == -1) {
            create = Typeface.create(o10, this.f1815j);
        } else {
            create = g.a(Typeface.create(o10, 0), this.f1816k, (this.f1815j & 2) != 0);
        }
        this.f1817l = create;
    }

    private void a(Drawable drawable, i2 i2Var) {
        if (drawable == null || i2Var == null) {
            return;
        }
        k.h(drawable, i2Var, this.f1806a.getDrawableState());
    }

    private static i2 d(Context context, k kVar, int i10) {
        ColorStateList f10 = kVar.f(context, i10);
        if (f10 != null) {
            i2 i2Var = new i2();
            i2Var.f1590d = true;
            i2Var.f1587a = f10;
            return i2Var;
        }
        return null;
    }

    private void y(Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4, Drawable drawable5, Drawable drawable6) {
        if (drawable5 != null || drawable6 != null) {
            Drawable[] a10 = c.a(this.f1806a);
            TextView textView = this.f1806a;
            if (drawable5 == null) {
                drawable5 = a10[0];
            }
            if (drawable2 == null) {
                drawable2 = a10[1];
            }
            if (drawable6 == null) {
                drawable6 = a10[2];
            }
            if (drawable4 == null) {
                drawable4 = a10[3];
            }
            c.b(textView, drawable5, drawable2, drawable6, drawable4);
        } else if (drawable == null && drawable2 == null && drawable3 == null && drawable4 == null) {
        } else {
            Drawable[] a11 = c.a(this.f1806a);
            Drawable drawable7 = a11[0];
            if (drawable7 != null || a11[2] != null) {
                TextView textView2 = this.f1806a;
                if (drawable2 == null) {
                    drawable2 = a11[1];
                }
                Drawable drawable8 = a11[2];
                if (drawable4 == null) {
                    drawable4 = a11[3];
                }
                c.b(textView2, drawable7, drawable2, drawable8, drawable4);
                return;
            }
            Drawable[] compoundDrawables = this.f1806a.getCompoundDrawables();
            TextView textView3 = this.f1806a;
            if (drawable == null) {
                drawable = compoundDrawables[0];
            }
            if (drawable2 == null) {
                drawable2 = compoundDrawables[1];
            }
            if (drawable3 == null) {
                drawable3 = compoundDrawables[2];
            }
            if (drawable4 == null) {
                drawable4 = compoundDrawables[3];
            }
            textView3.setCompoundDrawablesWithIntrinsicBounds(drawable, drawable2, drawable3, drawable4);
        }
    }

    private void z() {
        i2 i2Var = this.f1813h;
        this.f1807b = i2Var;
        this.f1808c = i2Var;
        this.f1809d = i2Var;
        this.f1810e = i2Var;
        this.f1811f = i2Var;
        this.f1812g = i2Var;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void A(int i10, float f10) {
        if (w2.f1828b || l()) {
            return;
        }
        B(i10, f10);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void b() {
        if (this.f1807b != null || this.f1808c != null || this.f1809d != null || this.f1810e != null) {
            Drawable[] compoundDrawables = this.f1806a.getCompoundDrawables();
            a(compoundDrawables[0], this.f1807b);
            a(compoundDrawables[1], this.f1808c);
            a(compoundDrawables[2], this.f1809d);
            a(compoundDrawables[3], this.f1810e);
        }
        if (this.f1811f == null && this.f1812g == null) {
            return;
        }
        Drawable[] a10 = c.a(this.f1806a);
        a(a10[0], this.f1811f);
        a(a10[2], this.f1812g);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void c() {
        this.f1814i.a();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public int e() {
        return this.f1814i.f();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public int f() {
        return this.f1814i.g();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public int g() {
        return this.f1814i.h();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public int[] h() {
        return this.f1814i.i();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public int i() {
        return this.f1814i.j();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public ColorStateList j() {
        i2 i2Var = this.f1813h;
        if (i2Var != null) {
            return i2Var.f1587a;
        }
        return null;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public PorterDuff.Mode k() {
        i2 i2Var = this.f1813h;
        if (i2Var != null) {
            return i2Var.f1588b;
        }
        return null;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean l() {
        return this.f1814i.n();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* JADX WARN: Removed duplicated region for block: B:104:0x01de  */
    /* JADX WARN: Removed duplicated region for block: B:106:0x01e5  */
    /* JADX WARN: Removed duplicated region for block: B:112:0x0210  */
    /* JADX WARN: Removed duplicated region for block: B:116:0x0221  */
    /* JADX WARN: Removed duplicated region for block: B:122:0x025e  */
    /* JADX WARN: Removed duplicated region for block: B:123:0x0264  */
    /* JADX WARN: Removed duplicated region for block: B:126:0x026d  */
    /* JADX WARN: Removed duplicated region for block: B:127:0x0273  */
    /* JADX WARN: Removed duplicated region for block: B:130:0x027c  */
    /* JADX WARN: Removed duplicated region for block: B:131:0x0282  */
    /* JADX WARN: Removed duplicated region for block: B:134:0x028b  */
    /* JADX WARN: Removed duplicated region for block: B:135:0x0291  */
    /* JADX WARN: Removed duplicated region for block: B:138:0x029a  */
    /* JADX WARN: Removed duplicated region for block: B:139:0x02a0  */
    /* JADX WARN: Removed duplicated region for block: B:142:0x02a9  */
    /* JADX WARN: Removed duplicated region for block: B:143:0x02af  */
    /* JADX WARN: Removed duplicated region for block: B:146:0x02c3  */
    /* JADX WARN: Removed duplicated region for block: B:149:0x02d4  */
    /* JADX WARN: Removed duplicated region for block: B:150:0x02e4  */
    /* JADX WARN: Removed duplicated region for block: B:153:0x02fc  */
    /* JADX WARN: Removed duplicated region for block: B:155:0x0303  */
    /* JADX WARN: Removed duplicated region for block: B:157:0x030a  */
    /* JADX WARN: Removed duplicated region for block: B:159:? A[RETURN, SYNTHETIC] */
    /* JADX WARN: Removed duplicated region for block: B:30:0x00cc  */
    /* JADX WARN: Removed duplicated region for block: B:41:0x00f5  */
    /* JADX WARN: Removed duplicated region for block: B:45:0x0100  */
    /* JADX WARN: Removed duplicated region for block: B:46:0x0105  */
    /* JADX WARN: Removed duplicated region for block: B:48:0x0108  */
    /* JADX WARN: Removed duplicated region for block: B:61:0x0142  */
    /* JADX WARN: Removed duplicated region for block: B:72:0x016e  */
    /* JADX WARN: Removed duplicated region for block: B:75:0x0176  */
    /* JADX WARN: Removed duplicated region for block: B:81:0x0189  */
    /* JADX WARN: Removed duplicated region for block: B:89:0x01ac  */
    /* JADX WARN: Removed duplicated region for block: B:91:0x01b3  */
    /* JADX WARN: Removed duplicated region for block: B:93:0x01ba  */
    /* JADX WARN: Removed duplicated region for block: B:95:0x01c1 A[ADDED_TO_REGION] */
    /* JADX WARN: Removed duplicated region for block: B:99:0x01ca  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public void m(AttributeSet attributeSet, int i10) {
        String str;
        ColorStateList colorStateList;
        String str2;
        boolean z9;
        ColorStateList colorStateList2;
        ColorStateList colorStateList3;
        boolean z10;
        String str3;
        int i11;
        int i12;
        String str4;
        k kVar;
        Typeface typeface;
        k2 u9;
        int i13;
        int i14;
        int i15;
        int f10;
        int f11;
        int f12;
        int[] i16;
        Context context = this.f1806a.getContext();
        k b10 = k.b();
        int[] iArr = g.j.Y;
        k2 v9 = k2.v(context, attributeSet, iArr, i10, 0);
        TextView textView = this.f1806a;
        androidx.core.view.r0.l0(textView, textView.getContext(), iArr, attributeSet, v9.r(), i10, 0);
        int n10 = v9.n(g.j.Z, -1);
        int i17 = g.j.f7782c0;
        if (v9.s(i17)) {
            this.f1807b = d(context, b10, v9.n(i17, 0));
        }
        int i18 = g.j.f7772a0;
        if (v9.s(i18)) {
            this.f1808c = d(context, b10, v9.n(i18, 0));
        }
        int i19 = g.j.f7787d0;
        if (v9.s(i19)) {
            this.f1809d = d(context, b10, v9.n(i19, 0));
        }
        int i20 = g.j.f7777b0;
        if (v9.s(i20)) {
            this.f1810e = d(context, b10, v9.n(i20, 0));
        }
        int i21 = Build.VERSION.SDK_INT;
        int i22 = g.j.f7792e0;
        if (v9.s(i22)) {
            this.f1811f = d(context, b10, v9.n(i22, 0));
        }
        int i23 = g.j.f7797f0;
        if (v9.s(i23)) {
            this.f1812g = d(context, b10, v9.n(i23, 0));
        }
        v9.w();
        boolean z11 = this.f1806a.getTransformationMethod() instanceof PasswordTransformationMethod;
        if (n10 != -1) {
            k2 t9 = k2.t(context, n10, g.j.E2);
            if (!z11) {
                int i24 = g.j.P2;
                if (t9.s(i24)) {
                    z9 = t9.a(i24, false);
                    z10 = true;
                    C(context, t9);
                    if (i21 >= 23) {
                        int i25 = g.j.I2;
                        colorStateList = t9.s(i25) ? t9.c(i25) : null;
                        int i26 = g.j.J2;
                        colorStateList2 = t9.s(i26) ? t9.c(i26) : null;
                        int i27 = g.j.K2;
                        if (t9.s(i27)) {
                            colorStateList3 = t9.c(i27);
                            int i28 = g.j.Q2;
                            str2 = t9.s(i28) ? t9.o(i28) : null;
                            if (i21 >= 26) {
                                int i29 = g.j.O2;
                                if (t9.s(i29)) {
                                    str = t9.o(i29);
                                    t9.w();
                                }
                            }
                            str = null;
                            t9.w();
                        }
                    } else {
                        colorStateList = null;
                        colorStateList2 = null;
                    }
                    colorStateList3 = null;
                    int i282 = g.j.Q2;
                    if (t9.s(i282)) {
                    }
                    if (i21 >= 26) {
                    }
                    str = null;
                    t9.w();
                }
            }
            z9 = false;
            z10 = false;
            C(context, t9);
            if (i21 >= 23) {
            }
            colorStateList3 = null;
            int i2822 = g.j.Q2;
            if (t9.s(i2822)) {
            }
            if (i21 >= 26) {
            }
            str = null;
            t9.w();
        } else {
            str = null;
            colorStateList = null;
            str2 = null;
            z9 = false;
            colorStateList2 = null;
            colorStateList3 = null;
            z10 = false;
        }
        k2 v10 = k2.v(context, attributeSet, g.j.E2, i10, 0);
        if (!z11) {
            int i30 = g.j.P2;
            if (v10.s(i30)) {
                str3 = str;
                z9 = v10.a(i30, false);
                i11 = 23;
                z10 = true;
                if (i21 < i11) {
                    int i31 = g.j.I2;
                    if (v10.s(i31)) {
                        colorStateList = v10.c(i31);
                    }
                    int i32 = g.j.J2;
                    if (v10.s(i32)) {
                        colorStateList2 = v10.c(i32);
                    }
                    int i33 = g.j.K2;
                    if (v10.s(i33)) {
                        colorStateList3 = v10.c(i33);
                    }
                }
                i12 = g.j.Q2;
                if (v10.s(i12)) {
                    str2 = v10.o(i12);
                }
                if (i21 >= 26) {
                    int i34 = g.j.O2;
                    if (v10.s(i34)) {
                        str4 = v10.o(i34);
                        if (i21 >= 28) {
                            int i35 = g.j.F2;
                            if (v10.s(i35)) {
                                kVar = b10;
                                if (v10.f(i35, -1) == 0) {
                                    this.f1806a.setTextSize(0, 0.0f);
                                }
                                C(context, v10);
                                v10.w();
                                if (colorStateList != null) {
                                    this.f1806a.setTextColor(colorStateList);
                                }
                                if (colorStateList2 != null) {
                                    this.f1806a.setHintTextColor(colorStateList2);
                                }
                                if (colorStateList3 != null) {
                                    this.f1806a.setLinkTextColor(colorStateList3);
                                }
                                if (!z11 && z10) {
                                    s(z9);
                                }
                                typeface = this.f1817l;
                                if (typeface != null) {
                                    if (this.f1816k == -1) {
                                        this.f1806a.setTypeface(typeface, this.f1815j);
                                    } else {
                                        this.f1806a.setTypeface(typeface);
                                    }
                                }
                                if (str4 != null) {
                                    f.d(this.f1806a, str4);
                                }
                                if (str2 != null) {
                                    if (i21 >= 24) {
                                        e.b(this.f1806a, e.a(str2));
                                    } else {
                                        c.c(this.f1806a, d.a(str2.split(",")[0]));
                                    }
                                }
                                this.f1814i.o(attributeSet, i10);
                                if (w2.f1828b && this.f1814i.j() != 0) {
                                    i16 = this.f1814i.i();
                                    if (i16.length > 0) {
                                        if (f.a(this.f1806a) != -1.0f) {
                                            f.b(this.f1806a, this.f1814i.g(), this.f1814i.f(), this.f1814i.h(), 0);
                                        } else {
                                            f.c(this.f1806a, i16, 0);
                                        }
                                    }
                                }
                                u9 = k2.u(context, attributeSet, g.j.f7802g0);
                                int n11 = u9.n(g.j.f7842o0, -1);
                                k kVar2 = kVar;
                                Drawable c10 = n11 == -1 ? kVar2.c(context, n11) : null;
                                int n12 = u9.n(g.j.f7867t0, -1);
                                Drawable c11 = n12 == -1 ? kVar2.c(context, n12) : null;
                                int n13 = u9.n(g.j.f7847p0, -1);
                                Drawable c12 = n13 == -1 ? kVar2.c(context, n13) : null;
                                int n14 = u9.n(g.j.f7832m0, -1);
                                Drawable c13 = n14 == -1 ? kVar2.c(context, n14) : null;
                                int n15 = u9.n(g.j.f7852q0, -1);
                                Drawable c14 = n15 == -1 ? kVar2.c(context, n15) : null;
                                int n16 = u9.n(g.j.f7837n0, -1);
                                y(c10, c11, c12, c13, c14, n16 == -1 ? kVar2.c(context, n16) : null);
                                i13 = g.j.f7857r0;
                                if (u9.s(i13)) {
                                    androidx.core.widget.v.g(this.f1806a, u9.c(i13));
                                }
                                i14 = g.j.f7862s0;
                                if (u9.s(i14)) {
                                    i15 = -1;
                                } else {
                                    i15 = -1;
                                    androidx.core.widget.v.h(this.f1806a, m1.d(u9.k(i14, -1), null));
                                }
                                f10 = u9.f(g.j.f7877v0, i15);
                                f11 = u9.f(g.j.f7882w0, i15);
                                f12 = u9.f(g.j.f7887x0, i15);
                                u9.w();
                                if (f10 != i15) {
                                    androidx.core.widget.v.j(this.f1806a, f10);
                                }
                                if (f11 != i15) {
                                    androidx.core.widget.v.k(this.f1806a, f11);
                                }
                                if (f12 == i15) {
                                    androidx.core.widget.v.l(this.f1806a, f12);
                                    return;
                                }
                                return;
                            }
                        }
                        kVar = b10;
                        C(context, v10);
                        v10.w();
                        if (colorStateList != null) {
                        }
                        if (colorStateList2 != null) {
                        }
                        if (colorStateList3 != null) {
                        }
                        if (!z11) {
                            s(z9);
                        }
                        typeface = this.f1817l;
                        if (typeface != null) {
                        }
                        if (str4 != null) {
                        }
                        if (str2 != null) {
                        }
                        this.f1814i.o(attributeSet, i10);
                        if (w2.f1828b) {
                            i16 = this.f1814i.i();
                            if (i16.length > 0) {
                            }
                        }
                        u9 = k2.u(context, attributeSet, g.j.f7802g0);
                        int n112 = u9.n(g.j.f7842o0, -1);
                        k kVar22 = kVar;
                        if (n112 == -1) {
                        }
                        int n122 = u9.n(g.j.f7867t0, -1);
                        if (n122 == -1) {
                        }
                        int n132 = u9.n(g.j.f7847p0, -1);
                        if (n132 == -1) {
                        }
                        int n142 = u9.n(g.j.f7832m0, -1);
                        if (n142 == -1) {
                        }
                        int n152 = u9.n(g.j.f7852q0, -1);
                        if (n152 == -1) {
                        }
                        int n162 = u9.n(g.j.f7837n0, -1);
                        y(c10, c11, c12, c13, c14, n162 == -1 ? kVar22.c(context, n162) : null);
                        i13 = g.j.f7857r0;
                        if (u9.s(i13)) {
                        }
                        i14 = g.j.f7862s0;
                        if (u9.s(i14)) {
                        }
                        f10 = u9.f(g.j.f7877v0, i15);
                        f11 = u9.f(g.j.f7882w0, i15);
                        f12 = u9.f(g.j.f7887x0, i15);
                        u9.w();
                        if (f10 != i15) {
                        }
                        if (f11 != i15) {
                        }
                        if (f12 == i15) {
                        }
                    }
                }
                str4 = str3;
                if (i21 >= 28) {
                }
                kVar = b10;
                C(context, v10);
                v10.w();
                if (colorStateList != null) {
                }
                if (colorStateList2 != null) {
                }
                if (colorStateList3 != null) {
                }
                if (!z11) {
                }
                typeface = this.f1817l;
                if (typeface != null) {
                }
                if (str4 != null) {
                }
                if (str2 != null) {
                }
                this.f1814i.o(attributeSet, i10);
                if (w2.f1828b) {
                }
                u9 = k2.u(context, attributeSet, g.j.f7802g0);
                int n1122 = u9.n(g.j.f7842o0, -1);
                k kVar222 = kVar;
                if (n1122 == -1) {
                }
                int n1222 = u9.n(g.j.f7867t0, -1);
                if (n1222 == -1) {
                }
                int n1322 = u9.n(g.j.f7847p0, -1);
                if (n1322 == -1) {
                }
                int n1422 = u9.n(g.j.f7832m0, -1);
                if (n1422 == -1) {
                }
                int n1522 = u9.n(g.j.f7852q0, -1);
                if (n1522 == -1) {
                }
                int n1622 = u9.n(g.j.f7837n0, -1);
                y(c10, c11, c12, c13, c14, n1622 == -1 ? kVar222.c(context, n1622) : null);
                i13 = g.j.f7857r0;
                if (u9.s(i13)) {
                }
                i14 = g.j.f7862s0;
                if (u9.s(i14)) {
                }
                f10 = u9.f(g.j.f7877v0, i15);
                f11 = u9.f(g.j.f7882w0, i15);
                f12 = u9.f(g.j.f7887x0, i15);
                u9.w();
                if (f10 != i15) {
                }
                if (f11 != i15) {
                }
                if (f12 == i15) {
                }
            }
        }
        str3 = str;
        i11 = 23;
        if (i21 < i11) {
        }
        i12 = g.j.Q2;
        if (v10.s(i12)) {
        }
        if (i21 >= 26) {
        }
        str4 = str3;
        if (i21 >= 28) {
        }
        kVar = b10;
        C(context, v10);
        v10.w();
        if (colorStateList != null) {
        }
        if (colorStateList2 != null) {
        }
        if (colorStateList3 != null) {
        }
        if (!z11) {
        }
        typeface = this.f1817l;
        if (typeface != null) {
        }
        if (str4 != null) {
        }
        if (str2 != null) {
        }
        this.f1814i.o(attributeSet, i10);
        if (w2.f1828b) {
        }
        u9 = k2.u(context, attributeSet, g.j.f7802g0);
        int n11222 = u9.n(g.j.f7842o0, -1);
        k kVar2222 = kVar;
        if (n11222 == -1) {
        }
        int n12222 = u9.n(g.j.f7867t0, -1);
        if (n12222 == -1) {
        }
        int n13222 = u9.n(g.j.f7847p0, -1);
        if (n13222 == -1) {
        }
        int n14222 = u9.n(g.j.f7832m0, -1);
        if (n14222 == -1) {
        }
        int n15222 = u9.n(g.j.f7852q0, -1);
        if (n15222 == -1) {
        }
        int n16222 = u9.n(g.j.f7837n0, -1);
        y(c10, c11, c12, c13, c14, n16222 == -1 ? kVar2222.c(context, n16222) : null);
        i13 = g.j.f7857r0;
        if (u9.s(i13)) {
        }
        i14 = g.j.f7862s0;
        if (u9.s(i14)) {
        }
        f10 = u9.f(g.j.f7877v0, i15);
        f11 = u9.f(g.j.f7882w0, i15);
        f12 = u9.f(g.j.f7887x0, i15);
        u9.w();
        if (f10 != i15) {
        }
        if (f11 != i15) {
        }
        if (f12 == i15) {
        }
    }

    void n(WeakReference weakReference, Typeface typeface) {
        if (this.f1818m) {
            this.f1817l = typeface;
            TextView textView = (TextView) weakReference.get();
            if (textView != null) {
                if (androidx.core.view.r0.Q(textView)) {
                    textView.post(new b(textView, typeface, this.f1815j));
                } else {
                    textView.setTypeface(typeface, this.f1815j);
                }
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void o(boolean z9, int i10, int i11, int i12, int i13) {
        if (w2.f1828b) {
            return;
        }
        c();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void p() {
        b();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void q(Context context, int i10) {
        String o10;
        ColorStateList c10;
        ColorStateList c11;
        ColorStateList c12;
        k2 t9 = k2.t(context, i10, g.j.E2);
        int i11 = g.j.P2;
        if (t9.s(i11)) {
            s(t9.a(i11, false));
        }
        int i12 = Build.VERSION.SDK_INT;
        if (i12 < 23) {
            int i13 = g.j.I2;
            if (t9.s(i13) && (c12 = t9.c(i13)) != null) {
                this.f1806a.setTextColor(c12);
            }
            int i14 = g.j.K2;
            if (t9.s(i14) && (c11 = t9.c(i14)) != null) {
                this.f1806a.setLinkTextColor(c11);
            }
            int i15 = g.j.J2;
            if (t9.s(i15) && (c10 = t9.c(i15)) != null) {
                this.f1806a.setHintTextColor(c10);
            }
        }
        int i16 = g.j.F2;
        if (t9.s(i16) && t9.f(i16, -1) == 0) {
            this.f1806a.setTextSize(0, 0.0f);
        }
        C(context, t9);
        if (i12 >= 26) {
            int i17 = g.j.O2;
            if (t9.s(i17) && (o10 = t9.o(i17)) != null) {
                f.d(this.f1806a, o10);
            }
        }
        t9.w();
        Typeface typeface = this.f1817l;
        if (typeface != null) {
            this.f1806a.setTypeface(typeface, this.f1815j);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void r(TextView textView, InputConnection inputConnection, EditorInfo editorInfo) {
        if (Build.VERSION.SDK_INT >= 30 || inputConnection == null) {
            return;
        }
        z.b.f(editorInfo, textView.getText());
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void s(boolean z9) {
        this.f1806a.setAllCaps(z9);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void t(int i10, int i11, int i12, int i13) {
        this.f1814i.p(i10, i11, i12, i13);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void u(int[] iArr, int i10) {
        this.f1814i.q(iArr, i10);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void v(int i10) {
        this.f1814i.r(i10);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void w(ColorStateList colorStateList) {
        if (this.f1813h == null) {
            this.f1813h = new i2();
        }
        i2 i2Var = this.f1813h;
        i2Var.f1587a = colorStateList;
        i2Var.f1590d = colorStateList != null;
        z();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void x(PorterDuff.Mode mode) {
        if (this.f1813h == null) {
            this.f1813h = new i2();
        }
        i2 i2Var = this.f1813h;
        i2Var.f1588b = mode;
        i2Var.f1589c = mode != null;
        z();
    }
}
