package androidx.appcompat.widget;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.TextView;
/* loaded from: classes.dex */
class u2 {

    /* renamed from: a  reason: collision with root package name */
    private final Context f1795a;

    /* renamed from: b  reason: collision with root package name */
    private final View f1796b;

    /* renamed from: c  reason: collision with root package name */
    private final TextView f1797c;

    /* renamed from: d  reason: collision with root package name */
    private final WindowManager.LayoutParams f1798d;

    /* renamed from: e  reason: collision with root package name */
    private final Rect f1799e;

    /* renamed from: f  reason: collision with root package name */
    private final int[] f1800f;

    /* renamed from: g  reason: collision with root package name */
    private final int[] f1801g;

    /* JADX INFO: Access modifiers changed from: package-private */
    public u2(Context context) {
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
        this.f1798d = layoutParams;
        this.f1799e = new Rect();
        this.f1800f = new int[2];
        this.f1801g = new int[2];
        this.f1795a = context;
        View inflate = LayoutInflater.from(context).inflate(g.g.abc_tooltip, (ViewGroup) null);
        this.f1796b = inflate;
        this.f1797c = (TextView) inflate.findViewById(g.f.message);
        layoutParams.setTitle(getClass().getSimpleName());
        layoutParams.packageName = context.getPackageName();
        layoutParams.type = 1002;
        layoutParams.width = -2;
        layoutParams.height = -2;
        layoutParams.format = -3;
        layoutParams.windowAnimations = g.i.Animation_AppCompat_Tooltip;
        layoutParams.flags = 24;
    }

    private void a(View view, int i10, int i11, boolean z9, WindowManager.LayoutParams layoutParams) {
        int height;
        int i12;
        layoutParams.token = view.getApplicationWindowToken();
        int dimensionPixelOffset = this.f1795a.getResources().getDimensionPixelOffset(g.d.tooltip_precise_anchor_threshold);
        if (view.getWidth() < dimensionPixelOffset) {
            i10 = view.getWidth() / 2;
        }
        if (view.getHeight() >= dimensionPixelOffset) {
            int dimensionPixelOffset2 = this.f1795a.getResources().getDimensionPixelOffset(g.d.tooltip_precise_anchor_extra_offset);
            height = i11 + dimensionPixelOffset2;
            i12 = i11 - dimensionPixelOffset2;
        } else {
            height = view.getHeight();
            i12 = 0;
        }
        layoutParams.gravity = 49;
        int dimensionPixelOffset3 = this.f1795a.getResources().getDimensionPixelOffset(z9 ? g.d.tooltip_y_offset_touch : g.d.tooltip_y_offset_non_touch);
        View b10 = b(view);
        if (b10 == null) {
            Log.e("TooltipPopup", "Cannot find app view");
            return;
        }
        b10.getWindowVisibleDisplayFrame(this.f1799e);
        Rect rect = this.f1799e;
        if (rect.left < 0 && rect.top < 0) {
            Resources resources = this.f1795a.getResources();
            int identifier = resources.getIdentifier("status_bar_height", "dimen", "android");
            int dimensionPixelSize = identifier != 0 ? resources.getDimensionPixelSize(identifier) : 0;
            DisplayMetrics displayMetrics = resources.getDisplayMetrics();
            this.f1799e.set(0, dimensionPixelSize, displayMetrics.widthPixels, displayMetrics.heightPixels);
        }
        b10.getLocationOnScreen(this.f1801g);
        view.getLocationOnScreen(this.f1800f);
        int[] iArr = this.f1800f;
        int i13 = iArr[0];
        int[] iArr2 = this.f1801g;
        int i14 = i13 - iArr2[0];
        iArr[0] = i14;
        iArr[1] = iArr[1] - iArr2[1];
        layoutParams.x = (i14 + i10) - (b10.getWidth() / 2);
        int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
        this.f1796b.measure(makeMeasureSpec, makeMeasureSpec);
        int measuredHeight = this.f1796b.getMeasuredHeight();
        int i15 = this.f1800f[1];
        int i16 = ((i12 + i15) - dimensionPixelOffset3) - measuredHeight;
        int i17 = i15 + height + dimensionPixelOffset3;
        if (!z9 ? measuredHeight + i17 <= this.f1799e.height() : i16 < 0) {
            layoutParams.y = i16;
        } else {
            layoutParams.y = i17;
        }
    }

    private static View b(View view) {
        View rootView = view.getRootView();
        ViewGroup.LayoutParams layoutParams = rootView.getLayoutParams();
        if ((layoutParams instanceof WindowManager.LayoutParams) && ((WindowManager.LayoutParams) layoutParams).type == 2) {
            return rootView;
        }
        for (Context context = view.getContext(); context instanceof ContextWrapper; context = ((ContextWrapper) context).getBaseContext()) {
            if (context instanceof Activity) {
                return ((Activity) context).getWindow().getDecorView();
            }
        }
        return rootView;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void c() {
        if (d()) {
            ((WindowManager) this.f1795a.getSystemService("window")).removeView(this.f1796b);
        }
    }

    boolean d() {
        return this.f1796b.getParent() != null;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void e(View view, int i10, int i11, boolean z9, CharSequence charSequence) {
        if (d()) {
            c();
        }
        this.f1797c.setText(charSequence);
        a(view, i10, i11, z9, this.f1798d);
        ((WindowManager) this.f1795a.getSystemService("window")).addView(this.f1796b, this.f1798d);
    }
}
