package androidx.appcompat.widget;

import android.text.TextUtils;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityManager;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public class t2 implements View.OnLongClickListener, View.OnHoverListener, View.OnAttachStateChangeListener {

    /* renamed from: q  reason: collision with root package name */
    private static t2 f1783q;

    /* renamed from: r  reason: collision with root package name */
    private static t2 f1784r;

    /* renamed from: g  reason: collision with root package name */
    private final View f1785g;

    /* renamed from: h  reason: collision with root package name */
    private final CharSequence f1786h;

    /* renamed from: i  reason: collision with root package name */
    private final int f1787i;

    /* renamed from: j  reason: collision with root package name */
    private final Runnable f1788j = new Runnable() { // from class: androidx.appcompat.widget.r2
        @Override // java.lang.Runnable
        public final void run() {
            t2.this.e();
        }
    };

    /* renamed from: k  reason: collision with root package name */
    private final Runnable f1789k = new Runnable() { // from class: androidx.appcompat.widget.s2
        @Override // java.lang.Runnable
        public final void run() {
            t2.this.d();
        }
    };

    /* renamed from: l  reason: collision with root package name */
    private int f1790l;

    /* renamed from: m  reason: collision with root package name */
    private int f1791m;

    /* renamed from: n  reason: collision with root package name */
    private u2 f1792n;

    /* renamed from: o  reason: collision with root package name */
    private boolean f1793o;

    /* renamed from: p  reason: collision with root package name */
    private boolean f1794p;

    private t2(View view, CharSequence charSequence) {
        this.f1785g = view;
        this.f1786h = charSequence;
        this.f1787i = androidx.core.view.o2.g(ViewConfiguration.get(view.getContext()));
        c();
        view.setOnLongClickListener(this);
        view.setOnHoverListener(this);
    }

    private void b() {
        this.f1785g.removeCallbacks(this.f1788j);
    }

    private void c() {
        this.f1794p = true;
    }

    /* JADX INFO: Access modifiers changed from: private */
    public /* synthetic */ void e() {
        i(false);
    }

    private void f() {
        this.f1785g.postDelayed(this.f1788j, ViewConfiguration.getLongPressTimeout());
    }

    private static void g(t2 t2Var) {
        t2 t2Var2 = f1783q;
        if (t2Var2 != null) {
            t2Var2.b();
        }
        f1783q = t2Var;
        if (t2Var != null) {
            t2Var.f();
        }
    }

    public static void h(View view, CharSequence charSequence) {
        t2 t2Var = f1783q;
        if (t2Var != null && t2Var.f1785g == view) {
            g(null);
        }
        if (!TextUtils.isEmpty(charSequence)) {
            new t2(view, charSequence);
            return;
        }
        t2 t2Var2 = f1784r;
        if (t2Var2 != null && t2Var2.f1785g == view) {
            t2Var2.d();
        }
        view.setOnLongClickListener(null);
        view.setLongClickable(false);
        view.setOnHoverListener(null);
    }

    private boolean j(MotionEvent motionEvent) {
        int x9 = (int) motionEvent.getX();
        int y9 = (int) motionEvent.getY();
        if (this.f1794p || Math.abs(x9 - this.f1790l) > this.f1787i || Math.abs(y9 - this.f1791m) > this.f1787i) {
            this.f1790l = x9;
            this.f1791m = y9;
            this.f1794p = false;
            return true;
        }
        return false;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void d() {
        if (f1784r == this) {
            f1784r = null;
            u2 u2Var = this.f1792n;
            if (u2Var != null) {
                u2Var.c();
                this.f1792n = null;
                c();
                this.f1785g.removeOnAttachStateChangeListener(this);
            } else {
                Log.e("TooltipCompatHandler", "sActiveHandler.mPopup == null");
            }
        }
        if (f1783q == this) {
            g(null);
        }
        this.f1785g.removeCallbacks(this.f1789k);
    }

    void i(boolean z9) {
        long longPressTimeout;
        if (androidx.core.view.r0.Q(this.f1785g)) {
            g(null);
            t2 t2Var = f1784r;
            if (t2Var != null) {
                t2Var.d();
            }
            f1784r = this;
            this.f1793o = z9;
            u2 u2Var = new u2(this.f1785g.getContext());
            this.f1792n = u2Var;
            u2Var.e(this.f1785g, this.f1790l, this.f1791m, this.f1793o, this.f1786h);
            this.f1785g.addOnAttachStateChangeListener(this);
            if (this.f1793o) {
                longPressTimeout = 2500;
            } else {
                longPressTimeout = ((androidx.core.view.r0.K(this.f1785g) & 1) == 1 ? 3000L : 15000L) - ViewConfiguration.getLongPressTimeout();
            }
            this.f1785g.removeCallbacks(this.f1789k);
            this.f1785g.postDelayed(this.f1789k, longPressTimeout);
        }
    }

    @Override // android.view.View.OnHoverListener
    public boolean onHover(View view, MotionEvent motionEvent) {
        if (this.f1792n == null || !this.f1793o) {
            AccessibilityManager accessibilityManager = (AccessibilityManager) this.f1785g.getContext().getSystemService("accessibility");
            if (accessibilityManager.isEnabled() && accessibilityManager.isTouchExplorationEnabled()) {
                return false;
            }
            int action = motionEvent.getAction();
            if (action != 7) {
                if (action == 10) {
                    c();
                    d();
                }
            } else if (this.f1785g.isEnabled() && this.f1792n == null && j(motionEvent)) {
                g(this);
            }
            return false;
        }
        return false;
    }

    @Override // android.view.View.OnLongClickListener
    public boolean onLongClick(View view) {
        this.f1790l = view.getWidth() / 2;
        this.f1791m = view.getHeight() / 2;
        i(true);
        return true;
    }

    @Override // android.view.View.OnAttachStateChangeListener
    public void onViewAttachedToWindow(View view) {
    }

    @Override // android.view.View.OnAttachStateChangeListener
    public void onViewDetachedFromWindow(View view) {
        d();
    }
}
