package androidx.appcompat.widget;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.ThemedSpinnerAdapter;
import androidx.appcompat.app.b;
/* loaded from: classes.dex */
public class t0 extends Spinner {

    /* renamed from: o  reason: collision with root package name */
    private static final int[] f1759o = {16843505};

    /* renamed from: g  reason: collision with root package name */
    private final androidx.appcompat.widget.e f1760g;

    /* renamed from: h  reason: collision with root package name */
    private final Context f1761h;

    /* renamed from: i  reason: collision with root package name */
    private p1 f1762i;

    /* renamed from: j  reason: collision with root package name */
    private SpinnerAdapter f1763j;

    /* renamed from: k  reason: collision with root package name */
    private final boolean f1764k;

    /* renamed from: l  reason: collision with root package name */
    private j f1765l;

    /* renamed from: m  reason: collision with root package name */
    int f1766m;

    /* renamed from: n  reason: collision with root package name */
    final Rect f1767n;

    /* loaded from: classes.dex */
    class a extends p1 {

        /* renamed from: p  reason: collision with root package name */
        final /* synthetic */ h f1768p;

        /* JADX WARN: 'super' call moved to the top of the method (can break code semantics) */
        a(View view, h hVar) {
            super(view);
            this.f1768p = hVar;
        }

        @Override // androidx.appcompat.widget.p1
        public androidx.appcompat.view.menu.p b() {
            return this.f1768p;
        }

        @Override // androidx.appcompat.widget.p1
        public boolean c() {
            if (t0.this.getInternalPopup().a()) {
                return true;
            }
            t0.this.b();
            return true;
        }
    }

    /* loaded from: classes.dex */
    class b implements ViewTreeObserver.OnGlobalLayoutListener {
        b() {
        }

        @Override // android.view.ViewTreeObserver.OnGlobalLayoutListener
        public void onGlobalLayout() {
            if (!t0.this.getInternalPopup().a()) {
                t0.this.b();
            }
            ViewTreeObserver viewTreeObserver = t0.this.getViewTreeObserver();
            if (viewTreeObserver != null) {
                c.a(viewTreeObserver, this);
            }
        }
    }

    /* loaded from: classes.dex */
    private static final class c {
        static void a(ViewTreeObserver viewTreeObserver, ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
            viewTreeObserver.removeOnGlobalLayoutListener(onGlobalLayoutListener);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static final class d {
        static int a(View view) {
            return view.getTextAlignment();
        }

        static int b(View view) {
            return view.getTextDirection();
        }

        static void c(View view, int i10) {
            view.setTextAlignment(i10);
        }

        static void d(View view, int i10) {
            view.setTextDirection(i10);
        }
    }

    /* loaded from: classes.dex */
    private static final class e {
        static void a(ThemedSpinnerAdapter themedSpinnerAdapter, Resources.Theme theme) {
            if (v.c.a(themedSpinnerAdapter.getDropDownViewTheme(), theme)) {
                return;
            }
            themedSpinnerAdapter.setDropDownViewTheme(theme);
        }
    }

    /* loaded from: classes.dex */
    class f implements j, DialogInterface.OnClickListener {

        /* renamed from: g  reason: collision with root package name */
        androidx.appcompat.app.b f1771g;

        /* renamed from: h  reason: collision with root package name */
        private ListAdapter f1772h;

        /* renamed from: i  reason: collision with root package name */
        private CharSequence f1773i;

        f() {
        }

        @Override // androidx.appcompat.widget.t0.j
        public boolean a() {
            androidx.appcompat.app.b bVar = this.f1771g;
            if (bVar != null) {
                return bVar.isShowing();
            }
            return false;
        }

        @Override // androidx.appcompat.widget.t0.j
        public int b() {
            return 0;
        }

        @Override // androidx.appcompat.widget.t0.j
        public void d(int i10) {
            Log.e("AppCompatSpinner", "Cannot set horizontal offset for MODE_DIALOG, ignoring");
        }

        @Override // androidx.appcompat.widget.t0.j
        public void dismiss() {
            androidx.appcompat.app.b bVar = this.f1771g;
            if (bVar != null) {
                bVar.dismiss();
                this.f1771g = null;
            }
        }

        @Override // androidx.appcompat.widget.t0.j
        public CharSequence e() {
            return this.f1773i;
        }

        @Override // androidx.appcompat.widget.t0.j
        public Drawable g() {
            return null;
        }

        @Override // androidx.appcompat.widget.t0.j
        public void h(CharSequence charSequence) {
            this.f1773i = charSequence;
        }

        @Override // androidx.appcompat.widget.t0.j
        public void j(Drawable drawable) {
            Log.e("AppCompatSpinner", "Cannot set popup background for MODE_DIALOG, ignoring");
        }

        @Override // androidx.appcompat.widget.t0.j
        public void k(int i10) {
            Log.e("AppCompatSpinner", "Cannot set vertical offset for MODE_DIALOG, ignoring");
        }

        @Override // androidx.appcompat.widget.t0.j
        public void l(int i10) {
            Log.e("AppCompatSpinner", "Cannot set horizontal (original) offset for MODE_DIALOG, ignoring");
        }

        @Override // androidx.appcompat.widget.t0.j
        public void m(int i10, int i11) {
            if (this.f1772h == null) {
                return;
            }
            b.a aVar = new b.a(t0.this.getPopupContext());
            CharSequence charSequence = this.f1773i;
            if (charSequence != null) {
                aVar.h(charSequence);
            }
            androidx.appcompat.app.b a10 = aVar.g(this.f1772h, t0.this.getSelectedItemPosition(), this).a();
            this.f1771g = a10;
            ListView k10 = a10.k();
            d.d(k10, i10);
            d.c(k10, i11);
            this.f1771g.show();
        }

        @Override // androidx.appcompat.widget.t0.j
        public int n() {
            return 0;
        }

        @Override // androidx.appcompat.widget.t0.j
        public void o(ListAdapter listAdapter) {
            this.f1772h = listAdapter;
        }

        @Override // android.content.DialogInterface.OnClickListener
        public void onClick(DialogInterface dialogInterface, int i10) {
            t0.this.setSelection(i10);
            if (t0.this.getOnItemClickListener() != null) {
                t0.this.performItemClick(null, i10, this.f1772h.getItemId(i10));
            }
            dismiss();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class g implements ListAdapter, SpinnerAdapter {

        /* renamed from: g  reason: collision with root package name */
        private SpinnerAdapter f1775g;

        /* renamed from: h  reason: collision with root package name */
        private ListAdapter f1776h;

        public g(SpinnerAdapter spinnerAdapter, Resources.Theme theme) {
            this.f1775g = spinnerAdapter;
            if (spinnerAdapter instanceof ListAdapter) {
                this.f1776h = (ListAdapter) spinnerAdapter;
            }
            if (theme == null || Build.VERSION.SDK_INT < 23 || !(spinnerAdapter instanceof ThemedSpinnerAdapter)) {
                return;
            }
            e.a((ThemedSpinnerAdapter) spinnerAdapter, theme);
        }

        @Override // android.widget.ListAdapter
        public boolean areAllItemsEnabled() {
            ListAdapter listAdapter = this.f1776h;
            if (listAdapter != null) {
                return listAdapter.areAllItemsEnabled();
            }
            return true;
        }

        @Override // android.widget.Adapter
        public int getCount() {
            SpinnerAdapter spinnerAdapter = this.f1775g;
            if (spinnerAdapter == null) {
                return 0;
            }
            return spinnerAdapter.getCount();
        }

        @Override // android.widget.SpinnerAdapter
        public View getDropDownView(int i10, View view, ViewGroup viewGroup) {
            SpinnerAdapter spinnerAdapter = this.f1775g;
            if (spinnerAdapter == null) {
                return null;
            }
            return spinnerAdapter.getDropDownView(i10, view, viewGroup);
        }

        @Override // android.widget.Adapter
        public Object getItem(int i10) {
            SpinnerAdapter spinnerAdapter = this.f1775g;
            if (spinnerAdapter == null) {
                return null;
            }
            return spinnerAdapter.getItem(i10);
        }

        @Override // android.widget.Adapter
        public long getItemId(int i10) {
            SpinnerAdapter spinnerAdapter = this.f1775g;
            if (spinnerAdapter == null) {
                return -1L;
            }
            return spinnerAdapter.getItemId(i10);
        }

        @Override // android.widget.Adapter
        public int getItemViewType(int i10) {
            return 0;
        }

        @Override // android.widget.Adapter
        public View getView(int i10, View view, ViewGroup viewGroup) {
            return getDropDownView(i10, view, viewGroup);
        }

        @Override // android.widget.Adapter
        public int getViewTypeCount() {
            return 1;
        }

        @Override // android.widget.Adapter
        public boolean hasStableIds() {
            SpinnerAdapter spinnerAdapter = this.f1775g;
            return spinnerAdapter != null && spinnerAdapter.hasStableIds();
        }

        @Override // android.widget.Adapter
        public boolean isEmpty() {
            return getCount() == 0;
        }

        @Override // android.widget.ListAdapter
        public boolean isEnabled(int i10) {
            ListAdapter listAdapter = this.f1776h;
            if (listAdapter != null) {
                return listAdapter.isEnabled(i10);
            }
            return true;
        }

        @Override // android.widget.Adapter
        public void registerDataSetObserver(DataSetObserver dataSetObserver) {
            SpinnerAdapter spinnerAdapter = this.f1775g;
            if (spinnerAdapter != null) {
                spinnerAdapter.registerDataSetObserver(dataSetObserver);
            }
        }

        @Override // android.widget.Adapter
        public void unregisterDataSetObserver(DataSetObserver dataSetObserver) {
            SpinnerAdapter spinnerAdapter = this.f1775g;
            if (spinnerAdapter != null) {
                spinnerAdapter.unregisterDataSetObserver(dataSetObserver);
            }
        }
    }

    /* loaded from: classes.dex */
    class h extends r1 implements j {
        private CharSequence P;
        ListAdapter Q;
        private final Rect R;
        private int S;

        /* loaded from: classes.dex */
        class a implements AdapterView.OnItemClickListener {

            /* renamed from: g  reason: collision with root package name */
            final /* synthetic */ t0 f1777g;

            a(t0 t0Var) {
                this.f1777g = t0Var;
            }

            @Override // android.widget.AdapterView.OnItemClickListener
            public void onItemClick(AdapterView adapterView, View view, int i10, long j10) {
                t0.this.setSelection(i10);
                if (t0.this.getOnItemClickListener() != null) {
                    h hVar = h.this;
                    t0.this.performItemClick(view, i10, hVar.Q.getItemId(i10));
                }
                h.this.dismiss();
            }
        }

        /* loaded from: classes.dex */
        class b implements ViewTreeObserver.OnGlobalLayoutListener {
            b() {
            }

            @Override // android.view.ViewTreeObserver.OnGlobalLayoutListener
            public void onGlobalLayout() {
                h hVar = h.this;
                if (!hVar.P(t0.this)) {
                    h.this.dismiss();
                    return;
                }
                h.this.N();
                h.super.show();
            }
        }

        /* loaded from: classes.dex */
        class c implements PopupWindow.OnDismissListener {

            /* renamed from: g  reason: collision with root package name */
            final /* synthetic */ ViewTreeObserver.OnGlobalLayoutListener f1780g;

            c(ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
                this.f1780g = onGlobalLayoutListener;
            }

            @Override // android.widget.PopupWindow.OnDismissListener
            public void onDismiss() {
                ViewTreeObserver viewTreeObserver = t0.this.getViewTreeObserver();
                if (viewTreeObserver != null) {
                    viewTreeObserver.removeGlobalOnLayoutListener(this.f1780g);
                }
            }
        }

        public h(Context context, AttributeSet attributeSet, int i10) {
            super(context, attributeSet, i10);
            this.R = new Rect();
            y(t0.this);
            E(true);
            J(0);
            G(new a(t0.this));
        }

        /* JADX WARN: Removed duplicated region for block: B:23:0x008d  */
        /* JADX WARN: Removed duplicated region for block: B:24:0x009a  */
        /*
            Code decompiled incorrectly, please refer to instructions dump.
        */
        void N() {
            int i10;
            Drawable g10 = g();
            int i11 = 0;
            if (g10 != null) {
                g10.getPadding(t0.this.f1767n);
                i11 = w2.b(t0.this) ? t0.this.f1767n.right : -t0.this.f1767n.left;
            } else {
                Rect rect = t0.this.f1767n;
                rect.right = 0;
                rect.left = 0;
            }
            int paddingLeft = t0.this.getPaddingLeft();
            int paddingRight = t0.this.getPaddingRight();
            int width = t0.this.getWidth();
            t0 t0Var = t0.this;
            int i12 = t0Var.f1766m;
            if (i12 == -2) {
                int a10 = t0Var.a((SpinnerAdapter) this.Q, g());
                int i13 = t0.this.getContext().getResources().getDisplayMetrics().widthPixels;
                Rect rect2 = t0.this.f1767n;
                int i14 = (i13 - rect2.left) - rect2.right;
                if (a10 > i14) {
                    a10 = i14;
                }
                i10 = Math.max(a10, (width - paddingLeft) - paddingRight);
            } else if (i12 != -1) {
                A(i12);
                d(!w2.b(t0.this) ? i11 + (((width - paddingRight) - u()) - O()) : i11 + paddingLeft + O());
            } else {
                i10 = (width - paddingLeft) - paddingRight;
            }
            A(i10);
            d(!w2.b(t0.this) ? i11 + (((width - paddingRight) - u()) - O()) : i11 + paddingLeft + O());
        }

        public int O() {
            return this.S;
        }

        boolean P(View view) {
            return androidx.core.view.r0.Q(view) && view.getGlobalVisibleRect(this.R);
        }

        @Override // androidx.appcompat.widget.t0.j
        public CharSequence e() {
            return this.P;
        }

        @Override // androidx.appcompat.widget.t0.j
        public void h(CharSequence charSequence) {
            this.P = charSequence;
        }

        @Override // androidx.appcompat.widget.t0.j
        public void l(int i10) {
            this.S = i10;
        }

        @Override // androidx.appcompat.widget.t0.j
        public void m(int i10, int i11) {
            ViewTreeObserver viewTreeObserver;
            boolean a10 = a();
            N();
            D(2);
            super.show();
            ListView i12 = i();
            i12.setChoiceMode(1);
            d.d(i12, i10);
            d.c(i12, i11);
            K(t0.this.getSelectedItemPosition());
            if (a10 || (viewTreeObserver = t0.this.getViewTreeObserver()) == null) {
                return;
            }
            b bVar = new b();
            viewTreeObserver.addOnGlobalLayoutListener(bVar);
            F(new c(bVar));
        }

        @Override // androidx.appcompat.widget.r1, androidx.appcompat.widget.t0.j
        public void o(ListAdapter listAdapter) {
            super.o(listAdapter);
            this.Q = listAdapter;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class i extends View.BaseSavedState {
        public static final Parcelable.Creator<i> CREATOR = new a();

        /* renamed from: g  reason: collision with root package name */
        boolean f1782g;

        /* loaded from: classes.dex */
        class a implements Parcelable.Creator {
            a() {
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: a */
            public i createFromParcel(Parcel parcel) {
                return new i(parcel);
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: b */
            public i[] newArray(int i10) {
                return new i[i10];
            }
        }

        i(Parcel parcel) {
            super(parcel);
            this.f1782g = parcel.readByte() != 0;
        }

        i(Parcelable parcelable) {
            super(parcelable);
        }

        @Override // android.view.View.BaseSavedState, android.view.AbsSavedState, android.os.Parcelable
        public void writeToParcel(Parcel parcel, int i10) {
            super.writeToParcel(parcel, i10);
            parcel.writeByte(this.f1782g ? (byte) 1 : (byte) 0);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public interface j {
        boolean a();

        int b();

        void d(int i10);

        void dismiss();

        CharSequence e();

        Drawable g();

        void h(CharSequence charSequence);

        void j(Drawable drawable);

        void k(int i10);

        void l(int i10);

        void m(int i10, int i11);

        int n();

        void o(ListAdapter listAdapter);
    }

    public t0(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, g.a.spinnerStyle);
    }

    public t0(Context context, AttributeSet attributeSet, int i10) {
        this(context, attributeSet, i10, -1);
    }

    public t0(Context context, AttributeSet attributeSet, int i10, int i11) {
        this(context, attributeSet, i10, i11, null);
    }

    /* JADX WARN: Code restructure failed: missing block: B:24:0x005e, code lost:
        if (r11 == null) goto L8;
     */
    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Removed duplicated region for block: B:33:0x006c  */
    /* JADX WARN: Removed duplicated region for block: B:36:0x00a6  */
    /* JADX WARN: Removed duplicated region for block: B:39:0x00be  */
    /* JADX WARN: Removed duplicated region for block: B:42:0x00d7  */
    /* JADX WARN: Removed duplicated region for block: B:49:0x003d A[EXC_TOP_SPLITTER, SYNTHETIC] */
    /* JADX WARN: Type inference failed for: r11v10 */
    /* JADX WARN: Type inference failed for: r11v11 */
    /* JADX WARN: Type inference failed for: r11v12 */
    /* JADX WARN: Type inference failed for: r11v3 */
    /* JADX WARN: Type inference failed for: r11v4 */
    /* JADX WARN: Type inference failed for: r11v7, types: [android.content.res.TypedArray] */
    /* JADX WARN: Type inference failed for: r6v0, types: [androidx.appcompat.widget.t0, android.view.View] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public t0(Context context, AttributeSet attributeSet, int i10, int i11, Resources.Theme theme) {
        super(context, attributeSet, i10);
        androidx.appcompat.view.d dVar;
        ?? r11;
        TypedArray typedArray;
        TypedArray typedArray2;
        CharSequence[] q10;
        SpinnerAdapter spinnerAdapter;
        this.f1767n = new Rect();
        g2.a(this, getContext());
        k2 v9 = k2.v(context, attributeSet, g.j.f7889x2, i10, 0);
        this.f1760g = new androidx.appcompat.widget.e(this);
        try {
            if (theme != null) {
                dVar = new androidx.appcompat.view.d(context, theme);
            } else {
                int n10 = v9.n(g.j.C2, 0);
                if (n10 == 0) {
                    this.f1761h = context;
                    r11 = -1;
                    typedArray = null;
                    if (i11 == -1) {
                        try {
                            typedArray2 = context.obtainStyledAttributes(attributeSet, f1759o, i10, 0);
                            try {
                                boolean hasValue = typedArray2.hasValue(0);
                                r11 = typedArray2;
                                if (hasValue) {
                                    i11 = typedArray2.getInt(0, 0);
                                    r11 = typedArray2;
                                }
                            } catch (Exception e10) {
                                e = e10;
                                Log.i("AppCompatSpinner", "Could not read android:spinnerMode", e);
                                r11 = typedArray2;
                            }
                        } catch (Exception e11) {
                            e = e11;
                            typedArray2 = null;
                        } catch (Throwable th) {
                            th = th;
                            if (typedArray != null) {
                                typedArray.recycle();
                            }
                            throw th;
                        }
                        r11.recycle();
                    }
                    if (i11 != 0) {
                        f fVar = new f();
                        this.f1765l = fVar;
                        fVar.h(v9.o(g.j.A2));
                    } else if (i11 == 1) {
                        h hVar = new h(this.f1761h, attributeSet, i10);
                        k2 v10 = k2.v(this.f1761h, attributeSet, g.j.f7889x2, i10, 0);
                        this.f1766m = v10.m(g.j.B2, -2);
                        hVar.j(v10.g(g.j.f7899z2));
                        hVar.h(v9.o(g.j.A2));
                        v10.w();
                        this.f1765l = hVar;
                        this.f1762i = new a(this, hVar);
                    }
                    q10 = v9.q(g.j.f7894y2);
                    if (q10 != null) {
                        ArrayAdapter arrayAdapter = new ArrayAdapter(context, 17367048, q10);
                        arrayAdapter.setDropDownViewResource(g.g.support_simple_spinner_dropdown_item);
                        setAdapter(arrayAdapter);
                    }
                    v9.w();
                    this.f1764k = true;
                    spinnerAdapter = this.f1763j;
                    if (spinnerAdapter != null) {
                        setAdapter(spinnerAdapter);
                        this.f1763j = null;
                    }
                    this.f1760g.e(attributeSet, i10);
                    return;
                }
                dVar = new androidx.appcompat.view.d(context, n10);
            }
            if (i11 == -1) {
            }
            if (i11 != 0) {
            }
            q10 = v9.q(g.j.f7894y2);
            if (q10 != null) {
            }
            v9.w();
            this.f1764k = true;
            spinnerAdapter = this.f1763j;
            if (spinnerAdapter != null) {
            }
            this.f1760g.e(attributeSet, i10);
            return;
        } catch (Throwable th2) {
            th = th2;
            typedArray = r11;
        }
        this.f1761h = dVar;
        r11 = -1;
        typedArray = null;
    }

    int a(SpinnerAdapter spinnerAdapter, Drawable drawable) {
        int i10 = 0;
        if (spinnerAdapter == null) {
            return 0;
        }
        int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(getMeasuredWidth(), 0);
        int makeMeasureSpec2 = View.MeasureSpec.makeMeasureSpec(getMeasuredHeight(), 0);
        int max = Math.max(0, getSelectedItemPosition());
        int min = Math.min(spinnerAdapter.getCount(), max + 15);
        View view = null;
        int i11 = 0;
        for (int max2 = Math.max(0, max - (15 - (min - max))); max2 < min; max2++) {
            int itemViewType = spinnerAdapter.getItemViewType(max2);
            if (itemViewType != i10) {
                view = null;
                i10 = itemViewType;
            }
            view = spinnerAdapter.getView(max2, view, this);
            if (view.getLayoutParams() == null) {
                view.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            }
            view.measure(makeMeasureSpec, makeMeasureSpec2);
            i11 = Math.max(i11, view.getMeasuredWidth());
        }
        if (drawable != null) {
            drawable.getPadding(this.f1767n);
            Rect rect = this.f1767n;
            return i11 + rect.left + rect.right;
        }
        return i11;
    }

    void b() {
        this.f1765l.m(d.b(this), d.a(this));
    }

    @Override // android.view.ViewGroup, android.view.View
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        androidx.appcompat.widget.e eVar = this.f1760g;
        if (eVar != null) {
            eVar.b();
        }
    }

    @Override // android.widget.Spinner
    public int getDropDownHorizontalOffset() {
        j jVar = this.f1765l;
        return jVar != null ? jVar.b() : super.getDropDownHorizontalOffset();
    }

    @Override // android.widget.Spinner
    public int getDropDownVerticalOffset() {
        j jVar = this.f1765l;
        return jVar != null ? jVar.n() : super.getDropDownVerticalOffset();
    }

    @Override // android.widget.Spinner
    public int getDropDownWidth() {
        return this.f1765l != null ? this.f1766m : super.getDropDownWidth();
    }

    final j getInternalPopup() {
        return this.f1765l;
    }

    @Override // android.widget.Spinner
    public Drawable getPopupBackground() {
        j jVar = this.f1765l;
        return jVar != null ? jVar.g() : super.getPopupBackground();
    }

    @Override // android.widget.Spinner
    public Context getPopupContext() {
        return this.f1761h;
    }

    @Override // android.widget.Spinner
    public CharSequence getPrompt() {
        j jVar = this.f1765l;
        return jVar != null ? jVar.e() : super.getPrompt();
    }

    public ColorStateList getSupportBackgroundTintList() {
        androidx.appcompat.widget.e eVar = this.f1760g;
        if (eVar != null) {
            return eVar.c();
        }
        return null;
    }

    public PorterDuff.Mode getSupportBackgroundTintMode() {
        androidx.appcompat.widget.e eVar = this.f1760g;
        if (eVar != null) {
            return eVar.d();
        }
        return null;
    }

    @Override // android.widget.Spinner, android.widget.AdapterView, android.view.ViewGroup, android.view.View
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        j jVar = this.f1765l;
        if (jVar == null || !jVar.a()) {
            return;
        }
        this.f1765l.dismiss();
    }

    @Override // android.widget.Spinner, android.widget.AbsSpinner, android.view.View
    protected void onMeasure(int i10, int i11) {
        super.onMeasure(i10, i11);
        if (this.f1765l == null || View.MeasureSpec.getMode(i10) != Integer.MIN_VALUE) {
            return;
        }
        setMeasuredDimension(Math.min(Math.max(getMeasuredWidth(), a(getAdapter(), getBackground())), View.MeasureSpec.getSize(i10)), getMeasuredHeight());
    }

    @Override // android.widget.Spinner, android.widget.AbsSpinner, android.view.View
    public void onRestoreInstanceState(Parcelable parcelable) {
        ViewTreeObserver viewTreeObserver;
        i iVar = (i) parcelable;
        super.onRestoreInstanceState(iVar.getSuperState());
        if (!iVar.f1782g || (viewTreeObserver = getViewTreeObserver()) == null) {
            return;
        }
        viewTreeObserver.addOnGlobalLayoutListener(new b());
    }

    @Override // android.widget.Spinner, android.widget.AbsSpinner, android.view.View
    public Parcelable onSaveInstanceState() {
        i iVar = new i(super.onSaveInstanceState());
        j jVar = this.f1765l;
        iVar.f1782g = jVar != null && jVar.a();
        return iVar;
    }

    @Override // android.widget.Spinner, android.view.View
    public boolean onTouchEvent(MotionEvent motionEvent) {
        p1 p1Var = this.f1762i;
        if (p1Var == null || !p1Var.onTouch(this, motionEvent)) {
            return super.onTouchEvent(motionEvent);
        }
        return true;
    }

    @Override // android.widget.Spinner, android.view.View
    public boolean performClick() {
        j jVar = this.f1765l;
        if (jVar != null) {
            if (jVar.a()) {
                return true;
            }
            b();
            return true;
        }
        return super.performClick();
    }

    @Override // android.widget.AdapterView
    public void setAdapter(SpinnerAdapter spinnerAdapter) {
        if (!this.f1764k) {
            this.f1763j = spinnerAdapter;
            return;
        }
        super.setAdapter(spinnerAdapter);
        if (this.f1765l != null) {
            Context context = this.f1761h;
            if (context == null) {
                context = getContext();
            }
            this.f1765l.o(new g(spinnerAdapter, context.getTheme()));
        }
    }

    @Override // android.view.View
    public void setBackgroundDrawable(Drawable drawable) {
        super.setBackgroundDrawable(drawable);
        androidx.appcompat.widget.e eVar = this.f1760g;
        if (eVar != null) {
            eVar.f(drawable);
        }
    }

    @Override // android.view.View
    public void setBackgroundResource(int i10) {
        super.setBackgroundResource(i10);
        androidx.appcompat.widget.e eVar = this.f1760g;
        if (eVar != null) {
            eVar.g(i10);
        }
    }

    @Override // android.widget.Spinner
    public void setDropDownHorizontalOffset(int i10) {
        j jVar = this.f1765l;
        if (jVar == null) {
            super.setDropDownHorizontalOffset(i10);
            return;
        }
        jVar.l(i10);
        this.f1765l.d(i10);
    }

    @Override // android.widget.Spinner
    public void setDropDownVerticalOffset(int i10) {
        j jVar = this.f1765l;
        if (jVar != null) {
            jVar.k(i10);
        } else {
            super.setDropDownVerticalOffset(i10);
        }
    }

    @Override // android.widget.Spinner
    public void setDropDownWidth(int i10) {
        if (this.f1765l != null) {
            this.f1766m = i10;
        } else {
            super.setDropDownWidth(i10);
        }
    }

    @Override // android.widget.Spinner
    public void setPopupBackgroundDrawable(Drawable drawable) {
        j jVar = this.f1765l;
        if (jVar != null) {
            jVar.j(drawable);
        } else {
            super.setPopupBackgroundDrawable(drawable);
        }
    }

    @Override // android.widget.Spinner
    public void setPopupBackgroundResource(int i10) {
        setPopupBackgroundDrawable(h.a.b(getPopupContext(), i10));
    }

    @Override // android.widget.Spinner
    public void setPrompt(CharSequence charSequence) {
        j jVar = this.f1765l;
        if (jVar != null) {
            jVar.h(charSequence);
        } else {
            super.setPrompt(charSequence);
        }
    }

    public void setSupportBackgroundTintList(ColorStateList colorStateList) {
        androidx.appcompat.widget.e eVar = this.f1760g;
        if (eVar != null) {
            eVar.i(colorStateList);
        }
    }

    public void setSupportBackgroundTintMode(PorterDuff.Mode mode) {
        androidx.appcompat.widget.e eVar = this.f1760g;
        if (eVar != null) {
            eVar.j(mode);
        }
    }
}
