package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.SeekBar;
/* loaded from: classes.dex */
class s0 extends m0 {

    /* renamed from: d  reason: collision with root package name */
    private final SeekBar f1750d;

    /* renamed from: e  reason: collision with root package name */
    private Drawable f1751e;

    /* renamed from: f  reason: collision with root package name */
    private ColorStateList f1752f;

    /* renamed from: g  reason: collision with root package name */
    private PorterDuff.Mode f1753g;

    /* renamed from: h  reason: collision with root package name */
    private boolean f1754h;

    /* renamed from: i  reason: collision with root package name */
    private boolean f1755i;

    /* JADX INFO: Access modifiers changed from: package-private */
    public s0(SeekBar seekBar) {
        super(seekBar);
        this.f1752f = null;
        this.f1753g = null;
        this.f1754h = false;
        this.f1755i = false;
        this.f1750d = seekBar;
    }

    private void f() {
        Drawable drawable = this.f1751e;
        if (drawable != null) {
            if (this.f1754h || this.f1755i) {
                Drawable r10 = androidx.core.graphics.drawable.a.r(drawable.mutate());
                this.f1751e = r10;
                if (this.f1754h) {
                    androidx.core.graphics.drawable.a.o(r10, this.f1752f);
                }
                if (this.f1755i) {
                    androidx.core.graphics.drawable.a.p(this.f1751e, this.f1753g);
                }
                if (this.f1751e.isStateful()) {
                    this.f1751e.setState(this.f1750d.getDrawableState());
                }
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    @Override // androidx.appcompat.widget.m0
    public void c(AttributeSet attributeSet, int i10) {
        super.c(attributeSet, i10);
        Context context = this.f1750d.getContext();
        int[] iArr = g.j.T;
        k2 v9 = k2.v(context, attributeSet, iArr, i10, 0);
        SeekBar seekBar = this.f1750d;
        androidx.core.view.r0.l0(seekBar, seekBar.getContext(), iArr, attributeSet, v9.r(), i10, 0);
        Drawable h10 = v9.h(g.j.U);
        if (h10 != null) {
            this.f1750d.setThumb(h10);
        }
        j(v9.g(g.j.V));
        int i11 = g.j.X;
        if (v9.s(i11)) {
            this.f1753g = m1.d(v9.k(i11, -1), this.f1753g);
            this.f1755i = true;
        }
        int i12 = g.j.W;
        if (v9.s(i12)) {
            this.f1752f = v9.c(i12);
            this.f1754h = true;
        }
        v9.w();
        f();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void g(Canvas canvas) {
        if (this.f1751e != null) {
            int max = this.f1750d.getMax();
            if (max > 1) {
                int intrinsicWidth = this.f1751e.getIntrinsicWidth();
                int intrinsicHeight = this.f1751e.getIntrinsicHeight();
                int i10 = intrinsicWidth >= 0 ? intrinsicWidth / 2 : 1;
                int i11 = intrinsicHeight >= 0 ? intrinsicHeight / 2 : 1;
                this.f1751e.setBounds(-i10, -i11, i10, i11);
                float width = ((this.f1750d.getWidth() - this.f1750d.getPaddingLeft()) - this.f1750d.getPaddingRight()) / max;
                int save = canvas.save();
                canvas.translate(this.f1750d.getPaddingLeft(), this.f1750d.getHeight() / 2);
                for (int i12 = 0; i12 <= max; i12++) {
                    this.f1751e.draw(canvas);
                    canvas.translate(width, 0.0f);
                }
                canvas.restoreToCount(save);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void h() {
        Drawable drawable = this.f1751e;
        if (drawable != null && drawable.isStateful() && drawable.setState(this.f1750d.getDrawableState())) {
            this.f1750d.invalidateDrawable(drawable);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void i() {
        Drawable drawable = this.f1751e;
        if (drawable != null) {
            drawable.jumpToCurrentState();
        }
    }

    void j(Drawable drawable) {
        Drawable drawable2 = this.f1751e;
        if (drawable2 != null) {
            drawable2.setCallback(null);
        }
        this.f1751e = drawable;
        if (drawable != null) {
            drawable.setCallback(this.f1750d);
            androidx.core.graphics.drawable.a.m(drawable, androidx.core.view.r0.B(this.f1750d));
            if (drawable.isStateful()) {
                drawable.setState(this.f1750d.getDrawableState());
            }
            f();
        }
        this.f1750d.invalidate();
    }
}
