package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import androidx.recyclerview.widget.RecyclerView;
import java.lang.reflect.Method;
/* loaded from: classes.dex */
public abstract class r1 implements androidx.appcompat.view.menu.p {
    private static Method M;
    private static Method N;
    private static Method O;
    private AdapterView.OnItemClickListener A;
    private AdapterView.OnItemSelectedListener B;
    final i C;
    private final h D;
    private final g E;
    private final e F;
    private Runnable G;
    final Handler H;
    private final Rect I;
    private Rect J;
    private boolean K;
    PopupWindow L;

    /* renamed from: g  reason: collision with root package name */
    private Context f1718g;

    /* renamed from: h  reason: collision with root package name */
    private ListAdapter f1719h;

    /* renamed from: i  reason: collision with root package name */
    n1 f1720i;

    /* renamed from: j  reason: collision with root package name */
    private int f1721j;

    /* renamed from: k  reason: collision with root package name */
    private int f1722k;

    /* renamed from: l  reason: collision with root package name */
    private int f1723l;

    /* renamed from: m  reason: collision with root package name */
    private int f1724m;

    /* renamed from: n  reason: collision with root package name */
    private int f1725n;

    /* renamed from: o  reason: collision with root package name */
    private boolean f1726o;

    /* renamed from: p  reason: collision with root package name */
    private boolean f1727p;

    /* renamed from: q  reason: collision with root package name */
    private boolean f1728q;

    /* renamed from: r  reason: collision with root package name */
    private int f1729r;

    /* renamed from: s  reason: collision with root package name */
    private boolean f1730s;

    /* renamed from: t  reason: collision with root package name */
    private boolean f1731t;

    /* renamed from: u  reason: collision with root package name */
    int f1732u;

    /* renamed from: v  reason: collision with root package name */
    private View f1733v;

    /* renamed from: w  reason: collision with root package name */
    private int f1734w;

    /* renamed from: x  reason: collision with root package name */
    private DataSetObserver f1735x;

    /* renamed from: y  reason: collision with root package name */
    private View f1736y;

    /* renamed from: z  reason: collision with root package name */
    private Drawable f1737z;

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class a implements Runnable {
        a() {
        }

        @Override // java.lang.Runnable
        public void run() {
            View s9 = r1.this.s();
            if (s9 == null || s9.getWindowToken() == null) {
                return;
            }
            r1.this.show();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class b implements AdapterView.OnItemSelectedListener {
        b() {
        }

        @Override // android.widget.AdapterView.OnItemSelectedListener
        public void onItemSelected(AdapterView adapterView, View view, int i10, long j10) {
            n1 n1Var;
            if (i10 == -1 || (n1Var = r1.this.f1720i) == null) {
                return;
            }
            n1Var.setListSelectionHidden(false);
        }

        @Override // android.widget.AdapterView.OnItemSelectedListener
        public void onNothingSelected(AdapterView adapterView) {
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class c {
        static int a(PopupWindow popupWindow, View view, int i10, boolean z9) {
            int maxAvailableHeight;
            maxAvailableHeight = popupWindow.getMaxAvailableHeight(view, i10, z9);
            return maxAvailableHeight;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class d {
        static void a(PopupWindow popupWindow, Rect rect) {
            popupWindow.setEpicenterBounds(rect);
        }

        static void b(PopupWindow popupWindow, boolean z9) {
            popupWindow.setIsClippedToScreen(z9);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class e implements Runnable {
        e() {
        }

        @Override // java.lang.Runnable
        public void run() {
            r1.this.q();
        }
    }

    /* loaded from: classes.dex */
    private class f extends DataSetObserver {
        f() {
        }

        @Override // android.database.DataSetObserver
        public void onChanged() {
            if (r1.this.a()) {
                r1.this.show();
            }
        }

        @Override // android.database.DataSetObserver
        public void onInvalidated() {
            r1.this.dismiss();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class g implements AbsListView.OnScrollListener {
        g() {
        }

        @Override // android.widget.AbsListView.OnScrollListener
        public void onScroll(AbsListView absListView, int i10, int i11, int i12) {
        }

        @Override // android.widget.AbsListView.OnScrollListener
        public void onScrollStateChanged(AbsListView absListView, int i10) {
            if (i10 != 1 || r1.this.v() || r1.this.L.getContentView() == null) {
                return;
            }
            r1 r1Var = r1.this;
            r1Var.H.removeCallbacks(r1Var.C);
            r1.this.C.run();
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class h implements View.OnTouchListener {
        h() {
        }

        @Override // android.view.View.OnTouchListener
        public boolean onTouch(View view, MotionEvent motionEvent) {
            PopupWindow popupWindow;
            int action = motionEvent.getAction();
            int x9 = (int) motionEvent.getX();
            int y9 = (int) motionEvent.getY();
            if (action == 0 && (popupWindow = r1.this.L) != null && popupWindow.isShowing() && x9 >= 0 && x9 < r1.this.L.getWidth() && y9 >= 0 && y9 < r1.this.L.getHeight()) {
                r1 r1Var = r1.this;
                r1Var.H.postDelayed(r1Var.C, 250L);
                return false;
            } else if (action == 1) {
                r1 r1Var2 = r1.this;
                r1Var2.H.removeCallbacks(r1Var2.C);
                return false;
            } else {
                return false;
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class i implements Runnable {
        i() {
        }

        @Override // java.lang.Runnable
        public void run() {
            n1 n1Var = r1.this.f1720i;
            if (n1Var == null || !androidx.core.view.r0.Q(n1Var) || r1.this.f1720i.getCount() <= r1.this.f1720i.getChildCount()) {
                return;
            }
            int childCount = r1.this.f1720i.getChildCount();
            r1 r1Var = r1.this;
            if (childCount <= r1Var.f1732u) {
                r1Var.L.setInputMethodMode(2);
                r1.this.show();
            }
        }
    }

    static {
        if (Build.VERSION.SDK_INT <= 28) {
            try {
                M = PopupWindow.class.getDeclaredMethod("setClipToScreenEnabled", Boolean.TYPE);
            } catch (NoSuchMethodException unused) {
                Log.i("ListPopupWindow", "Could not find method setClipToScreenEnabled() on PopupWindow. Oh well.");
            }
            try {
                O = PopupWindow.class.getDeclaredMethod("setEpicenterBounds", Rect.class);
            } catch (NoSuchMethodException unused2) {
                Log.i("ListPopupWindow", "Could not find method setEpicenterBounds(Rect) on PopupWindow. Oh well.");
            }
        }
        if (Build.VERSION.SDK_INT <= 23) {
            try {
                N = PopupWindow.class.getDeclaredMethod("getMaxAvailableHeight", View.class, Integer.TYPE, Boolean.TYPE);
            } catch (NoSuchMethodException unused3) {
                Log.i("ListPopupWindow", "Could not find method getMaxAvailableHeight(View, int, boolean) on PopupWindow. Oh well.");
            }
        }
    }

    public r1(Context context, AttributeSet attributeSet, int i10) {
        this(context, attributeSet, i10, 0);
    }

    public r1(Context context, AttributeSet attributeSet, int i10, int i11) {
        this.f1721j = -2;
        this.f1722k = -2;
        this.f1725n = 1002;
        this.f1729r = 0;
        this.f1730s = false;
        this.f1731t = false;
        this.f1732u = Integer.MAX_VALUE;
        this.f1734w = 0;
        this.C = new i();
        this.D = new h();
        this.E = new g();
        this.F = new e();
        this.I = new Rect();
        this.f1718g = context;
        this.H = new Handler(context.getMainLooper());
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, g.j.f7828l1, i10, i11);
        this.f1723l = obtainStyledAttributes.getDimensionPixelOffset(g.j.f7833m1, 0);
        int dimensionPixelOffset = obtainStyledAttributes.getDimensionPixelOffset(g.j.f7838n1, 0);
        this.f1724m = dimensionPixelOffset;
        if (dimensionPixelOffset != 0) {
            this.f1726o = true;
        }
        obtainStyledAttributes.recycle();
        t tVar = new t(context, attributeSet, i10, i11);
        this.L = tVar;
        tVar.setInputMethodMode(1);
    }

    private void I(boolean z9) {
        if (Build.VERSION.SDK_INT > 28) {
            d.b(this.L, z9);
            return;
        }
        Method method = M;
        if (method != null) {
            try {
                method.invoke(this.L, Boolean.valueOf(z9));
            } catch (Exception unused) {
                Log.i("ListPopupWindow", "Could not call setClipToScreenEnabled() on PopupWindow. Oh well.");
            }
        }
    }

    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Removed duplicated region for block: B:52:0x0151  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    private int p() {
        int i10;
        int i11;
        int makeMeasureSpec;
        int d10;
        int i12;
        n1 n1Var = this.f1720i;
        int i13 = RecyclerView.UNDEFINED_DURATION;
        if (n1Var == null) {
            Context context = this.f1718g;
            this.G = new a();
            n1 r10 = r(context, !this.K);
            this.f1720i = r10;
            Drawable drawable = this.f1737z;
            if (drawable != null) {
                r10.setSelector(drawable);
            }
            this.f1720i.setAdapter(this.f1719h);
            this.f1720i.setOnItemClickListener(this.A);
            this.f1720i.setFocusable(true);
            this.f1720i.setFocusableInTouchMode(true);
            this.f1720i.setOnItemSelectedListener(new b());
            this.f1720i.setOnScrollListener(this.E);
            AdapterView.OnItemSelectedListener onItemSelectedListener = this.B;
            if (onItemSelectedListener != null) {
                this.f1720i.setOnItemSelectedListener(onItemSelectedListener);
            }
            n1 n1Var2 = this.f1720i;
            View view = this.f1733v;
            if (view != null) {
                LinearLayout linearLayout = new LinearLayout(context);
                linearLayout.setOrientation(1);
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, 0, 1.0f);
                int i14 = this.f1734w;
                if (i14 == 0) {
                    linearLayout.addView(view);
                    linearLayout.addView(n1Var2, layoutParams);
                } else if (i14 != 1) {
                    Log.e("ListPopupWindow", "Invalid hint position " + this.f1734w);
                } else {
                    linearLayout.addView(n1Var2, layoutParams);
                    linearLayout.addView(view);
                }
                int i15 = this.f1722k;
                if (i15 >= 0) {
                    i12 = RecyclerView.UNDEFINED_DURATION;
                } else {
                    i15 = 0;
                    i12 = 0;
                }
                view.measure(View.MeasureSpec.makeMeasureSpec(i15, i12), 0);
                LinearLayout.LayoutParams layoutParams2 = (LinearLayout.LayoutParams) view.getLayoutParams();
                i10 = view.getMeasuredHeight() + layoutParams2.topMargin + layoutParams2.bottomMargin;
                n1Var2 = linearLayout;
            } else {
                i10 = 0;
            }
            this.L.setContentView(n1Var2);
        } else {
            ViewGroup viewGroup = (ViewGroup) this.L.getContentView();
            View view2 = this.f1733v;
            if (view2 != null) {
                LinearLayout.LayoutParams layoutParams3 = (LinearLayout.LayoutParams) view2.getLayoutParams();
                i10 = view2.getMeasuredHeight() + layoutParams3.topMargin + layoutParams3.bottomMargin;
            } else {
                i10 = 0;
            }
        }
        Drawable background = this.L.getBackground();
        if (background != null) {
            background.getPadding(this.I);
            Rect rect = this.I;
            int i16 = rect.top;
            i11 = rect.bottom + i16;
            if (!this.f1726o) {
                this.f1724m = -i16;
            }
        } else {
            this.I.setEmpty();
            i11 = 0;
        }
        int t9 = t(s(), this.f1724m, this.L.getInputMethodMode() == 2);
        if (this.f1730s || this.f1721j == -1) {
            return t9 + i11;
        }
        int i17 = this.f1722k;
        if (i17 != -2) {
            i13 = 1073741824;
            if (i17 != -1) {
                makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(i17, 1073741824);
                d10 = this.f1720i.d(makeMeasureSpec, 0, -1, t9 - i10, -1);
                if (d10 > 0) {
                    i10 += i11 + this.f1720i.getPaddingTop() + this.f1720i.getPaddingBottom();
                }
                return d10 + i10;
            }
        }
        int i18 = this.f1718g.getResources().getDisplayMetrics().widthPixels;
        Rect rect2 = this.I;
        makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(i18 - (rect2.left + rect2.right), i13);
        d10 = this.f1720i.d(makeMeasureSpec, 0, -1, t9 - i10, -1);
        if (d10 > 0) {
        }
        return d10 + i10;
    }

    private int t(View view, int i10, boolean z9) {
        if (Build.VERSION.SDK_INT <= 23) {
            Method method = N;
            if (method != null) {
                try {
                    return ((Integer) method.invoke(this.L, view, Integer.valueOf(i10), Boolean.valueOf(z9))).intValue();
                } catch (Exception unused) {
                    Log.i("ListPopupWindow", "Could not call getMaxAvailableHeightMethod(View, int, boolean) on PopupWindow. Using the public version.");
                }
            }
            return this.L.getMaxAvailableHeight(view, i10);
        }
        return c.a(this.L, view, i10, z9);
    }

    private void x() {
        View view = this.f1733v;
        if (view != null) {
            ViewParent parent = view.getParent();
            if (parent instanceof ViewGroup) {
                ((ViewGroup) parent).removeView(this.f1733v);
            }
        }
    }

    public void A(int i10) {
        Drawable background = this.L.getBackground();
        if (background == null) {
            L(i10);
            return;
        }
        background.getPadding(this.I);
        Rect rect = this.I;
        this.f1722k = rect.left + rect.right + i10;
    }

    public void B(int i10) {
        this.f1729r = i10;
    }

    public void C(Rect rect) {
        this.J = rect != null ? new Rect(rect) : null;
    }

    public void D(int i10) {
        this.L.setInputMethodMode(i10);
    }

    public void E(boolean z9) {
        this.K = z9;
        this.L.setFocusable(z9);
    }

    public void F(PopupWindow.OnDismissListener onDismissListener) {
        this.L.setOnDismissListener(onDismissListener);
    }

    public void G(AdapterView.OnItemClickListener onItemClickListener) {
        this.A = onItemClickListener;
    }

    public void H(boolean z9) {
        this.f1728q = true;
        this.f1727p = z9;
    }

    public void J(int i10) {
        this.f1734w = i10;
    }

    public void K(int i10) {
        n1 n1Var = this.f1720i;
        if (!a() || n1Var == null) {
            return;
        }
        n1Var.setListSelectionHidden(false);
        n1Var.setSelection(i10);
        if (n1Var.getChoiceMode() != 0) {
            n1Var.setItemChecked(i10, true);
        }
    }

    public void L(int i10) {
        this.f1722k = i10;
    }

    @Override // androidx.appcompat.view.menu.p
    public boolean a() {
        return this.L.isShowing();
    }

    public int b() {
        return this.f1723l;
    }

    public void d(int i10) {
        this.f1723l = i10;
    }

    @Override // androidx.appcompat.view.menu.p
    public void dismiss() {
        this.L.dismiss();
        x();
        this.L.setContentView(null);
        this.f1720i = null;
        this.H.removeCallbacks(this.C);
    }

    public Drawable g() {
        return this.L.getBackground();
    }

    @Override // androidx.appcompat.view.menu.p
    public ListView i() {
        return this.f1720i;
    }

    public void j(Drawable drawable) {
        this.L.setBackgroundDrawable(drawable);
    }

    public void k(int i10) {
        this.f1724m = i10;
        this.f1726o = true;
    }

    public int n() {
        if (this.f1726o) {
            return this.f1724m;
        }
        return 0;
    }

    public void o(ListAdapter listAdapter) {
        DataSetObserver dataSetObserver = this.f1735x;
        if (dataSetObserver == null) {
            this.f1735x = new f();
        } else {
            ListAdapter listAdapter2 = this.f1719h;
            if (listAdapter2 != null) {
                listAdapter2.unregisterDataSetObserver(dataSetObserver);
            }
        }
        this.f1719h = listAdapter;
        if (listAdapter != null) {
            listAdapter.registerDataSetObserver(this.f1735x);
        }
        n1 n1Var = this.f1720i;
        if (n1Var != null) {
            n1Var.setAdapter(this.f1719h);
        }
    }

    public void q() {
        n1 n1Var = this.f1720i;
        if (n1Var != null) {
            n1Var.setListSelectionHidden(true);
            n1Var.requestLayout();
        }
    }

    n1 r(Context context, boolean z9) {
        return new n1(context, z9);
    }

    public View s() {
        return this.f1736y;
    }

    @Override // androidx.appcompat.view.menu.p
    public void show() {
        int p10 = p();
        boolean v9 = v();
        androidx.core.widget.n.b(this.L, this.f1725n);
        boolean z9 = true;
        if (this.L.isShowing()) {
            if (androidx.core.view.r0.Q(s())) {
                int i10 = this.f1722k;
                if (i10 == -1) {
                    i10 = -1;
                } else if (i10 == -2) {
                    i10 = s().getWidth();
                }
                int i11 = this.f1721j;
                if (i11 == -1) {
                    if (!v9) {
                        p10 = -1;
                    }
                    if (v9) {
                        this.L.setWidth(this.f1722k == -1 ? -1 : 0);
                        this.L.setHeight(0);
                    } else {
                        this.L.setWidth(this.f1722k == -1 ? -1 : 0);
                        this.L.setHeight(-1);
                    }
                } else if (i11 != -2) {
                    p10 = i11;
                }
                this.L.setOutsideTouchable((this.f1731t || this.f1730s) ? false : false);
                this.L.update(s(), this.f1723l, this.f1724m, i10 < 0 ? -1 : i10, p10 < 0 ? -1 : p10);
                return;
            }
            return;
        }
        int i12 = this.f1722k;
        if (i12 == -1) {
            i12 = -1;
        } else if (i12 == -2) {
            i12 = s().getWidth();
        }
        int i13 = this.f1721j;
        if (i13 == -1) {
            p10 = -1;
        } else if (i13 != -2) {
            p10 = i13;
        }
        this.L.setWidth(i12);
        this.L.setHeight(p10);
        I(true);
        this.L.setOutsideTouchable((this.f1731t || this.f1730s) ? false : true);
        this.L.setTouchInterceptor(this.D);
        if (this.f1728q) {
            androidx.core.widget.n.a(this.L, this.f1727p);
        }
        if (Build.VERSION.SDK_INT <= 28) {
            Method method = O;
            if (method != null) {
                try {
                    method.invoke(this.L, this.J);
                } catch (Exception e10) {
                    Log.e("ListPopupWindow", "Could not invoke setEpicenterBounds on PopupWindow", e10);
                }
            }
        } else {
            d.a(this.L, this.J);
        }
        androidx.core.widget.n.c(this.L, s(), this.f1723l, this.f1724m, this.f1729r);
        this.f1720i.setSelection(-1);
        if (!this.K || this.f1720i.isInTouchMode()) {
            q();
        }
        if (this.K) {
            return;
        }
        this.H.post(this.F);
    }

    public int u() {
        return this.f1722k;
    }

    public boolean v() {
        return this.L.getInputMethodMode() == 2;
    }

    public boolean w() {
        return this.K;
    }

    public void y(View view) {
        this.f1736y = view;
    }

    public void z(int i10) {
        this.L.setAnimationStyle(i10);
    }
}
