package androidx.appcompat.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.LinearLayout;
import androidx.recyclerview.widget.RecyclerView;
/* loaded from: classes.dex */
public abstract class q1 extends ViewGroup {

    /* renamed from: g  reason: collision with root package name */
    private boolean f1699g;

    /* renamed from: h  reason: collision with root package name */
    private int f1700h;

    /* renamed from: i  reason: collision with root package name */
    private int f1701i;

    /* renamed from: j  reason: collision with root package name */
    private int f1702j;

    /* renamed from: k  reason: collision with root package name */
    private int f1703k;

    /* renamed from: l  reason: collision with root package name */
    private int f1704l;

    /* renamed from: m  reason: collision with root package name */
    private float f1705m;

    /* renamed from: n  reason: collision with root package name */
    private boolean f1706n;

    /* renamed from: o  reason: collision with root package name */
    private int[] f1707o;

    /* renamed from: p  reason: collision with root package name */
    private int[] f1708p;

    /* renamed from: q  reason: collision with root package name */
    private Drawable f1709q;

    /* renamed from: r  reason: collision with root package name */
    private int f1710r;

    /* renamed from: s  reason: collision with root package name */
    private int f1711s;

    /* renamed from: t  reason: collision with root package name */
    private int f1712t;

    /* renamed from: u  reason: collision with root package name */
    private int f1713u;

    /* loaded from: classes.dex */
    public static class a extends LinearLayout.LayoutParams {
        public a(int i10, int i11) {
            super(i10, i11);
        }

        public a(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public a(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }
    }

    public q1(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public q1(Context context, AttributeSet attributeSet, int i10) {
        super(context, attributeSet, i10);
        this.f1699g = true;
        this.f1700h = -1;
        this.f1701i = 0;
        this.f1703k = 8388659;
        int[] iArr = g.j.f7773a1;
        k2 v9 = k2.v(context, attributeSet, iArr, i10, 0);
        androidx.core.view.r0.l0(this, context, iArr, attributeSet, v9.r(), i10, 0);
        int k10 = v9.k(g.j.f7783c1, -1);
        if (k10 >= 0) {
            setOrientation(k10);
        }
        int k11 = v9.k(g.j.f7778b1, -1);
        if (k11 >= 0) {
            setGravity(k11);
        }
        boolean a10 = v9.a(g.j.f7788d1, true);
        if (!a10) {
            setBaselineAligned(a10);
        }
        this.f1705m = v9.i(g.j.f7798f1, -1.0f);
        this.f1700h = v9.k(g.j.f7793e1, -1);
        this.f1706n = v9.a(g.j.f7813i1, false);
        setDividerDrawable(v9.g(g.j.f7803g1));
        this.f1712t = v9.k(g.j.f7818j1, 0);
        this.f1713u = v9.f(g.j.f7808h1, 0);
        v9.w();
    }

    private void i(int i10, int i11) {
        int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(getMeasuredHeight(), 1073741824);
        for (int i12 = 0; i12 < i10; i12++) {
            View q10 = q(i12);
            if (q10.getVisibility() != 8) {
                a aVar = (a) q10.getLayoutParams();
                if (((LinearLayout.LayoutParams) aVar).height == -1) {
                    int i13 = ((LinearLayout.LayoutParams) aVar).width;
                    ((LinearLayout.LayoutParams) aVar).width = q10.getMeasuredWidth();
                    measureChildWithMargins(q10, i11, 0, makeMeasureSpec, 0);
                    ((LinearLayout.LayoutParams) aVar).width = i13;
                }
            }
        }
    }

    private void j(int i10, int i11) {
        int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(getMeasuredWidth(), 1073741824);
        for (int i12 = 0; i12 < i10; i12++) {
            View q10 = q(i12);
            if (q10.getVisibility() != 8) {
                a aVar = (a) q10.getLayoutParams();
                if (((LinearLayout.LayoutParams) aVar).width == -1) {
                    int i13 = ((LinearLayout.LayoutParams) aVar).height;
                    ((LinearLayout.LayoutParams) aVar).height = q10.getMeasuredHeight();
                    measureChildWithMargins(q10, makeMeasureSpec, 0, i11, 0);
                    ((LinearLayout.LayoutParams) aVar).height = i13;
                }
            }
        }
    }

    private void y(View view, int i10, int i11, int i12, int i13) {
        view.layout(i10, i11, i12 + i10, i13 + i11);
    }

    @Override // android.view.ViewGroup
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof a;
    }

    void e(Canvas canvas) {
        int right;
        int left;
        int i10;
        int virtualChildCount = getVirtualChildCount();
        boolean b10 = w2.b(this);
        for (int i11 = 0; i11 < virtualChildCount; i11++) {
            View q10 = q(i11);
            if (q10 != null && q10.getVisibility() != 8 && r(i11)) {
                a aVar = (a) q10.getLayoutParams();
                h(canvas, b10 ? q10.getRight() + ((LinearLayout.LayoutParams) aVar).rightMargin : (q10.getLeft() - ((LinearLayout.LayoutParams) aVar).leftMargin) - this.f1710r);
            }
        }
        if (r(virtualChildCount)) {
            View q11 = q(virtualChildCount - 1);
            if (q11 != null) {
                a aVar2 = (a) q11.getLayoutParams();
                if (b10) {
                    left = q11.getLeft();
                    i10 = ((LinearLayout.LayoutParams) aVar2).leftMargin;
                    right = (left - i10) - this.f1710r;
                } else {
                    right = q11.getRight() + ((LinearLayout.LayoutParams) aVar2).rightMargin;
                }
            } else if (b10) {
                right = getPaddingLeft();
            } else {
                left = getWidth();
                i10 = getPaddingRight();
                right = (left - i10) - this.f1710r;
            }
            h(canvas, right);
        }
    }

    void f(Canvas canvas) {
        int virtualChildCount = getVirtualChildCount();
        for (int i10 = 0; i10 < virtualChildCount; i10++) {
            View q10 = q(i10);
            if (q10 != null && q10.getVisibility() != 8 && r(i10)) {
                g(canvas, (q10.getTop() - ((LinearLayout.LayoutParams) ((a) q10.getLayoutParams())).topMargin) - this.f1711s);
            }
        }
        if (r(virtualChildCount)) {
            View q11 = q(virtualChildCount - 1);
            g(canvas, q11 == null ? (getHeight() - getPaddingBottom()) - this.f1711s : q11.getBottom() + ((LinearLayout.LayoutParams) ((a) q11.getLayoutParams())).bottomMargin);
        }
    }

    void g(Canvas canvas, int i10) {
        this.f1709q.setBounds(getPaddingLeft() + this.f1713u, i10, (getWidth() - getPaddingRight()) - this.f1713u, this.f1711s + i10);
        this.f1709q.draw(canvas);
    }

    @Override // android.view.View
    public int getBaseline() {
        int i10;
        if (this.f1700h < 0) {
            return super.getBaseline();
        }
        int childCount = getChildCount();
        int i11 = this.f1700h;
        if (childCount > i11) {
            View childAt = getChildAt(i11);
            int baseline = childAt.getBaseline();
            if (baseline == -1) {
                if (this.f1700h == 0) {
                    return -1;
                }
                throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout points to a View that doesn't know how to get its baseline.");
            }
            int i12 = this.f1701i;
            if (this.f1702j == 1 && (i10 = this.f1703k & 112) != 48) {
                if (i10 == 16) {
                    i12 += ((((getBottom() - getTop()) - getPaddingTop()) - getPaddingBottom()) - this.f1704l) / 2;
                } else if (i10 == 80) {
                    i12 = ((getBottom() - getTop()) - getPaddingBottom()) - this.f1704l;
                }
            }
            return i12 + ((LinearLayout.LayoutParams) ((a) childAt.getLayoutParams())).topMargin + baseline;
        }
        throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout set to an index that is out of bounds.");
    }

    public int getBaselineAlignedChildIndex() {
        return this.f1700h;
    }

    public Drawable getDividerDrawable() {
        return this.f1709q;
    }

    public int getDividerPadding() {
        return this.f1713u;
    }

    public int getDividerWidth() {
        return this.f1710r;
    }

    public int getGravity() {
        return this.f1703k;
    }

    public int getOrientation() {
        return this.f1702j;
    }

    public int getShowDividers() {
        return this.f1712t;
    }

    int getVirtualChildCount() {
        return getChildCount();
    }

    public float getWeightSum() {
        return this.f1705m;
    }

    void h(Canvas canvas, int i10) {
        this.f1709q.setBounds(i10, getPaddingTop() + this.f1713u, this.f1710r + i10, (getHeight() - getPaddingBottom()) - this.f1713u);
        this.f1709q.draw(canvas);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // android.view.ViewGroup
    /* renamed from: k */
    public a generateDefaultLayoutParams() {
        int i10 = this.f1702j;
        if (i10 == 0) {
            return new a(-2, -2);
        }
        if (i10 == 1) {
            return new a(-1, -2);
        }
        return null;
    }

    @Override // android.view.ViewGroup
    /* renamed from: l */
    public a generateLayoutParams(AttributeSet attributeSet) {
        return new a(getContext(), attributeSet);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // android.view.ViewGroup
    /* renamed from: m */
    public a generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new a(layoutParams);
    }

    int n(View view, int i10) {
        return 0;
    }

    int o(View view) {
        return 0;
    }

    @Override // android.view.View
    protected void onDraw(Canvas canvas) {
        if (this.f1709q == null) {
            return;
        }
        if (this.f1702j == 1) {
            f(canvas);
        } else {
            e(canvas);
        }
    }

    @Override // android.view.View
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName("androidx.appcompat.widget.LinearLayoutCompat");
    }

    @Override // android.view.View
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName("androidx.appcompat.widget.LinearLayoutCompat");
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // android.view.ViewGroup, android.view.View
    public void onLayout(boolean z9, int i10, int i11, int i12, int i13) {
        if (this.f1702j == 1) {
            t(i10, i11, i12, i13);
        } else {
            s(i10, i11, i12, i13);
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // android.view.View
    public void onMeasure(int i10, int i11) {
        if (this.f1702j == 1) {
            x(i10, i11);
        } else {
            v(i10, i11);
        }
    }

    int p(View view) {
        return 0;
    }

    View q(int i10) {
        return getChildAt(i10);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public boolean r(int i10) {
        if (i10 == 0) {
            return (this.f1712t & 1) != 0;
        } else if (i10 == getChildCount()) {
            return (this.f1712t & 4) != 0;
        } else if ((this.f1712t & 2) != 0) {
            for (int i11 = i10 - 1; i11 >= 0; i11--) {
                if (getChildAt(i11).getVisibility() != 8) {
                    return true;
                }
            }
            return false;
        } else {
            return false;
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:29:0x00a7  */
    /* JADX WARN: Removed duplicated region for block: B:32:0x00b0  */
    /* JADX WARN: Removed duplicated region for block: B:44:0x00e3  */
    /* JADX WARN: Removed duplicated region for block: B:47:0x00f7  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    void s(int i10, int i11, int i12, int i13) {
        int i14;
        int i15;
        int i16;
        int i17;
        int i18;
        int i19;
        int i20;
        int i21;
        int i22;
        boolean b10 = w2.b(this);
        int paddingTop = getPaddingTop();
        int i23 = i13 - i11;
        int paddingBottom = i23 - getPaddingBottom();
        int paddingBottom2 = (i23 - paddingTop) - getPaddingBottom();
        int virtualChildCount = getVirtualChildCount();
        int i24 = this.f1703k;
        int i25 = i24 & 112;
        boolean z9 = this.f1699g;
        int[] iArr = this.f1707o;
        int[] iArr2 = this.f1708p;
        int b11 = androidx.core.view.i.b(8388615 & i24, androidx.core.view.r0.B(this));
        int paddingLeft = b11 != 1 ? b11 != 5 ? getPaddingLeft() : ((getPaddingLeft() + i12) - i10) - this.f1704l : getPaddingLeft() + (((i12 - i10) - this.f1704l) / 2);
        if (b10) {
            i14 = virtualChildCount - 1;
            i15 = -1;
        } else {
            i14 = 0;
            i15 = 1;
        }
        int i26 = 0;
        while (i26 < virtualChildCount) {
            int i27 = i14 + (i15 * i26);
            View q10 = q(i27);
            if (q10 == null) {
                paddingLeft += w(i27);
            } else if (q10.getVisibility() != 8) {
                int measuredWidth = q10.getMeasuredWidth();
                int measuredHeight = q10.getMeasuredHeight();
                a aVar = (a) q10.getLayoutParams();
                int i28 = i26;
                if (z9) {
                    i16 = virtualChildCount;
                    if (((LinearLayout.LayoutParams) aVar).height != -1) {
                        i17 = q10.getBaseline();
                        i18 = ((LinearLayout.LayoutParams) aVar).gravity;
                        if (i18 < 0) {
                            i18 = i25;
                        }
                        i19 = i18 & 112;
                        i20 = i25;
                        if (i19 != 16) {
                            i21 = ((((paddingBottom2 - measuredHeight) / 2) + paddingTop) + ((LinearLayout.LayoutParams) aVar).topMargin) - ((LinearLayout.LayoutParams) aVar).bottomMargin;
                        } else if (i19 == 48) {
                            i21 = ((LinearLayout.LayoutParams) aVar).topMargin + paddingTop;
                            if (i17 != -1) {
                                i21 += iArr[1] - i17;
                            }
                        } else if (i19 != 80) {
                            i21 = paddingTop;
                        } else {
                            i21 = (paddingBottom - measuredHeight) - ((LinearLayout.LayoutParams) aVar).bottomMargin;
                            if (i17 != -1) {
                                i21 -= iArr2[2] - (q10.getMeasuredHeight() - i17);
                            }
                        }
                        if (r(i27)) {
                            paddingLeft += this.f1710r;
                        }
                        int i29 = ((LinearLayout.LayoutParams) aVar).leftMargin + paddingLeft;
                        i22 = paddingTop;
                        y(q10, i29 + o(q10), i21, measuredWidth, measuredHeight);
                        i26 = i28 + n(q10, i27);
                        paddingLeft = i29 + measuredWidth + ((LinearLayout.LayoutParams) aVar).rightMargin + p(q10);
                        i26++;
                        virtualChildCount = i16;
                        i25 = i20;
                        paddingTop = i22;
                    }
                } else {
                    i16 = virtualChildCount;
                }
                i17 = -1;
                i18 = ((LinearLayout.LayoutParams) aVar).gravity;
                if (i18 < 0) {
                }
                i19 = i18 & 112;
                i20 = i25;
                if (i19 != 16) {
                }
                if (r(i27)) {
                }
                int i292 = ((LinearLayout.LayoutParams) aVar).leftMargin + paddingLeft;
                i22 = paddingTop;
                y(q10, i292 + o(q10), i21, measuredWidth, measuredHeight);
                i26 = i28 + n(q10, i27);
                paddingLeft = i292 + measuredWidth + ((LinearLayout.LayoutParams) aVar).rightMargin + p(q10);
                i26++;
                virtualChildCount = i16;
                i25 = i20;
                paddingTop = i22;
            }
            i22 = paddingTop;
            i16 = virtualChildCount;
            i20 = i25;
            i26++;
            virtualChildCount = i16;
            i25 = i20;
            paddingTop = i22;
        }
    }

    public void setBaselineAligned(boolean z9) {
        this.f1699g = z9;
    }

    public void setBaselineAlignedChildIndex(int i10) {
        if (i10 >= 0 && i10 < getChildCount()) {
            this.f1700h = i10;
            return;
        }
        throw new IllegalArgumentException("base aligned child index out of range (0, " + getChildCount() + ")");
    }

    public void setDividerDrawable(Drawable drawable) {
        if (drawable == this.f1709q) {
            return;
        }
        this.f1709q = drawable;
        if (drawable != null) {
            this.f1710r = drawable.getIntrinsicWidth();
            this.f1711s = drawable.getIntrinsicHeight();
        } else {
            this.f1710r = 0;
            this.f1711s = 0;
        }
        setWillNotDraw(drawable == null);
        requestLayout();
    }

    public void setDividerPadding(int i10) {
        this.f1713u = i10;
    }

    public void setGravity(int i10) {
        if (this.f1703k != i10) {
            if ((8388615 & i10) == 0) {
                i10 |= 8388611;
            }
            if ((i10 & 112) == 0) {
                i10 |= 48;
            }
            this.f1703k = i10;
            requestLayout();
        }
    }

    public void setHorizontalGravity(int i10) {
        int i11 = i10 & 8388615;
        int i12 = this.f1703k;
        if ((8388615 & i12) != i11) {
            this.f1703k = i11 | ((-8388616) & i12);
            requestLayout();
        }
    }

    public void setMeasureWithLargestChildEnabled(boolean z9) {
        this.f1706n = z9;
    }

    public void setOrientation(int i10) {
        if (this.f1702j != i10) {
            this.f1702j = i10;
            requestLayout();
        }
    }

    public void setShowDividers(int i10) {
        if (i10 != this.f1712t) {
            requestLayout();
        }
        this.f1712t = i10;
    }

    public void setVerticalGravity(int i10) {
        int i11 = i10 & 112;
        int i12 = this.f1703k;
        if ((i12 & 112) != i11) {
            this.f1703k = i11 | (i12 & (-113));
            requestLayout();
        }
    }

    public void setWeightSum(float f10) {
        this.f1705m = Math.max(0.0f, f10);
    }

    @Override // android.view.ViewGroup
    public boolean shouldDelayChildPressedState() {
        return false;
    }

    /* JADX WARN: Removed duplicated region for block: B:29:0x009d  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    void t(int i10, int i11, int i12, int i13) {
        int i14;
        int i15;
        int paddingLeft = getPaddingLeft();
        int i16 = i12 - i10;
        int paddingRight = i16 - getPaddingRight();
        int paddingRight2 = (i16 - paddingLeft) - getPaddingRight();
        int virtualChildCount = getVirtualChildCount();
        int i17 = this.f1703k;
        int i18 = i17 & 112;
        int i19 = i17 & 8388615;
        int paddingTop = i18 != 16 ? i18 != 80 ? getPaddingTop() : ((getPaddingTop() + i13) - i11) - this.f1704l : getPaddingTop() + (((i13 - i11) - this.f1704l) / 2);
        int i20 = 0;
        while (i20 < virtualChildCount) {
            View q10 = q(i20);
            if (q10 == null) {
                paddingTop += w(i20);
            } else if (q10.getVisibility() != 8) {
                int measuredWidth = q10.getMeasuredWidth();
                int measuredHeight = q10.getMeasuredHeight();
                a aVar = (a) q10.getLayoutParams();
                int i21 = ((LinearLayout.LayoutParams) aVar).gravity;
                if (i21 < 0) {
                    i21 = i19;
                }
                int b10 = androidx.core.view.i.b(i21, androidx.core.view.r0.B(this)) & 7;
                if (b10 == 1) {
                    i14 = ((paddingRight2 - measuredWidth) / 2) + paddingLeft + ((LinearLayout.LayoutParams) aVar).leftMargin;
                } else if (b10 != 5) {
                    i15 = ((LinearLayout.LayoutParams) aVar).leftMargin + paddingLeft;
                    int i22 = i15;
                    if (r(i20)) {
                        paddingTop += this.f1711s;
                    }
                    int i23 = paddingTop + ((LinearLayout.LayoutParams) aVar).topMargin;
                    y(q10, i22, i23 + o(q10), measuredWidth, measuredHeight);
                    i20 += n(q10, i20);
                    paddingTop = i23 + measuredHeight + ((LinearLayout.LayoutParams) aVar).bottomMargin + p(q10);
                } else {
                    i14 = paddingRight - measuredWidth;
                }
                i15 = i14 - ((LinearLayout.LayoutParams) aVar).rightMargin;
                int i222 = i15;
                if (r(i20)) {
                }
                int i232 = paddingTop + ((LinearLayout.LayoutParams) aVar).topMargin;
                y(q10, i222, i232 + o(q10), measuredWidth, measuredHeight);
                i20 += n(q10, i20);
                paddingTop = i232 + measuredHeight + ((LinearLayout.LayoutParams) aVar).bottomMargin + p(q10);
            }
            i20++;
        }
    }

    void u(View view, int i10, int i11, int i12, int i13, int i14) {
        measureChildWithMargins(view, i11, i12, i13, i14);
    }

    /* JADX WARN: Code restructure failed: missing block: B:164:0x03a0, code lost:
        if (r8 > 0) goto L176;
     */
    /* JADX WARN: Code restructure failed: missing block: B:168:0x03ab, code lost:
        if (r8 < 0) goto L175;
     */
    /* JADX WARN: Code restructure failed: missing block: B:169:0x03ad, code lost:
        r8 = 0;
     */
    /* JADX WARN: Code restructure failed: missing block: B:170:0x03ae, code lost:
        r14.measure(android.view.View.MeasureSpec.makeMeasureSpec(r8, r3), r0);
        r9 = android.view.View.combineMeasuredStates(r9, r14.getMeasuredState() & (-16777216));
        r0 = r0;
        r3 = r2;
     */
    /* JADX WARN: Removed duplicated region for block: B:198:0x0439  */
    /* JADX WARN: Removed duplicated region for block: B:70:0x018f  */
    /* JADX WARN: Removed duplicated region for block: B:80:0x01c3  */
    /* JADX WARN: Removed duplicated region for block: B:84:0x01ce  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    void v(int i10, int i11) {
        int[] iArr;
        int i12;
        int max;
        int i13;
        int i14;
        int max2;
        int i15;
        int i16;
        int i17;
        float f10;
        int i18;
        boolean z9;
        int baseline;
        int i19;
        int i20;
        int i21;
        int i22;
        int i23;
        boolean z10;
        boolean z11;
        View view;
        int max3;
        int i24;
        boolean z12;
        int measuredHeight;
        int n10;
        int baseline2;
        int i25;
        this.f1704l = 0;
        int virtualChildCount = getVirtualChildCount();
        int mode = View.MeasureSpec.getMode(i10);
        int mode2 = View.MeasureSpec.getMode(i11);
        if (this.f1707o == null || this.f1708p == null) {
            this.f1707o = new int[4];
            this.f1708p = new int[4];
        }
        int[] iArr2 = this.f1707o;
        int[] iArr3 = this.f1708p;
        iArr2[3] = -1;
        iArr2[2] = -1;
        iArr2[1] = -1;
        iArr2[0] = -1;
        iArr3[3] = -1;
        iArr3[2] = -1;
        iArr3[1] = -1;
        iArr3[0] = -1;
        boolean z13 = this.f1699g;
        boolean z14 = this.f1706n;
        int i26 = 1073741824;
        boolean z15 = mode == 1073741824;
        float f11 = 0.0f;
        int i27 = 0;
        int i28 = 0;
        int i29 = 0;
        int i30 = 0;
        int i31 = 0;
        boolean z16 = false;
        int i32 = 0;
        boolean z17 = true;
        boolean z18 = false;
        while (true) {
            iArr = iArr3;
            if (i27 >= virtualChildCount) {
                break;
            }
            View q10 = q(i27);
            if (q10 == null) {
                this.f1704l += w(i27);
            } else if (q10.getVisibility() == 8) {
                i27 += n(q10, i27);
            } else {
                if (r(i27)) {
                    this.f1704l += this.f1710r;
                }
                a aVar = (a) q10.getLayoutParams();
                float f12 = ((LinearLayout.LayoutParams) aVar).weight;
                float f13 = f11 + f12;
                if (mode == i26 && ((LinearLayout.LayoutParams) aVar).width == 0 && f12 > 0.0f) {
                    int i33 = this.f1704l;
                    this.f1704l = z15 ? i33 + ((LinearLayout.LayoutParams) aVar).leftMargin + ((LinearLayout.LayoutParams) aVar).rightMargin : Math.max(i33, ((LinearLayout.LayoutParams) aVar).leftMargin + i33 + ((LinearLayout.LayoutParams) aVar).rightMargin);
                    if (z13) {
                        int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
                        q10.measure(makeMeasureSpec, makeMeasureSpec);
                        i23 = i27;
                        z10 = z14;
                        z11 = z13;
                        view = q10;
                    } else {
                        i23 = i27;
                        z10 = z14;
                        z11 = z13;
                        view = q10;
                        i24 = 1073741824;
                        z16 = true;
                        if (mode2 == i24 && ((LinearLayout.LayoutParams) aVar).height == -1) {
                            z12 = true;
                            z18 = true;
                        } else {
                            z12 = false;
                        }
                        int i34 = ((LinearLayout.LayoutParams) aVar).topMargin + ((LinearLayout.LayoutParams) aVar).bottomMargin;
                        measuredHeight = view.getMeasuredHeight() + i34;
                        i32 = View.combineMeasuredStates(i32, view.getMeasuredState());
                        if (z11 && (baseline2 = view.getBaseline()) != -1) {
                            i25 = ((LinearLayout.LayoutParams) aVar).gravity;
                            if (i25 < 0) {
                                i25 = this.f1703k;
                            }
                            int i35 = (((i25 & 112) >> 4) & (-2)) >> 1;
                            iArr2[i35] = Math.max(iArr2[i35], baseline2);
                            iArr[i35] = Math.max(iArr[i35], measuredHeight - baseline2);
                        }
                        i29 = Math.max(i29, measuredHeight);
                        z17 = !z17 && ((LinearLayout.LayoutParams) aVar).height == -1;
                        if (((LinearLayout.LayoutParams) aVar).weight <= 0.0f) {
                            if (!z12) {
                                i34 = measuredHeight;
                            }
                            i31 = Math.max(i31, i34);
                        } else {
                            int i36 = i31;
                            if (!z12) {
                                i34 = measuredHeight;
                            }
                            i30 = Math.max(i30, i34);
                            i31 = i36;
                        }
                        int i37 = i23;
                        n10 = n(view, i37) + i37;
                        f11 = f13;
                        i27 = n10 + 1;
                        iArr3 = iArr;
                        z14 = z10;
                        z13 = z11;
                        i26 = 1073741824;
                    }
                } else {
                    if (((LinearLayout.LayoutParams) aVar).width != 0 || f12 <= 0.0f) {
                        i22 = RecyclerView.UNDEFINED_DURATION;
                    } else {
                        ((LinearLayout.LayoutParams) aVar).width = -2;
                        i22 = 0;
                    }
                    i23 = i27;
                    int i38 = i22;
                    z10 = z14;
                    z11 = z13;
                    u(q10, i23, i10, f13 == 0.0f ? this.f1704l : 0, i11, 0);
                    if (i38 != Integer.MIN_VALUE) {
                        ((LinearLayout.LayoutParams) aVar).width = i38;
                    }
                    int measuredWidth = q10.getMeasuredWidth();
                    if (z15) {
                        view = q10;
                        max3 = this.f1704l + ((LinearLayout.LayoutParams) aVar).leftMargin + measuredWidth + ((LinearLayout.LayoutParams) aVar).rightMargin + p(view);
                    } else {
                        view = q10;
                        int i39 = this.f1704l;
                        max3 = Math.max(i39, i39 + measuredWidth + ((LinearLayout.LayoutParams) aVar).leftMargin + ((LinearLayout.LayoutParams) aVar).rightMargin + p(view));
                    }
                    this.f1704l = max3;
                    if (z10) {
                        i28 = Math.max(measuredWidth, i28);
                    }
                }
                i24 = 1073741824;
                if (mode2 == i24) {
                }
                z12 = false;
                int i342 = ((LinearLayout.LayoutParams) aVar).topMargin + ((LinearLayout.LayoutParams) aVar).bottomMargin;
                measuredHeight = view.getMeasuredHeight() + i342;
                i32 = View.combineMeasuredStates(i32, view.getMeasuredState());
                if (z11) {
                    i25 = ((LinearLayout.LayoutParams) aVar).gravity;
                    if (i25 < 0) {
                    }
                    int i352 = (((i25 & 112) >> 4) & (-2)) >> 1;
                    iArr2[i352] = Math.max(iArr2[i352], baseline2);
                    iArr[i352] = Math.max(iArr[i352], measuredHeight - baseline2);
                }
                i29 = Math.max(i29, measuredHeight);
                if (z17) {
                }
                if (((LinearLayout.LayoutParams) aVar).weight <= 0.0f) {
                }
                int i372 = i23;
                n10 = n(view, i372) + i372;
                f11 = f13;
                i27 = n10 + 1;
                iArr3 = iArr;
                z14 = z10;
                z13 = z11;
                i26 = 1073741824;
            }
            n10 = i27;
            z10 = z14;
            z11 = z13;
            i27 = n10 + 1;
            iArr3 = iArr;
            z14 = z10;
            z13 = z11;
            i26 = 1073741824;
        }
        boolean z19 = z14;
        boolean z20 = z13;
        int i40 = i29;
        int i41 = i30;
        int i42 = i31;
        int i43 = i32;
        if (this.f1704l > 0 && r(virtualChildCount)) {
            this.f1704l += this.f1710r;
        }
        int i44 = iArr2[1];
        if (i44 == -1 && iArr2[0] == -1 && iArr2[2] == -1 && iArr2[3] == -1) {
            max = i40;
            i12 = i43;
        } else {
            i12 = i43;
            max = Math.max(i40, Math.max(iArr2[3], Math.max(iArr2[0], Math.max(i44, iArr2[2]))) + Math.max(iArr[3], Math.max(iArr[0], Math.max(iArr[1], iArr[2]))));
        }
        if (z19 && (mode == Integer.MIN_VALUE || mode == 0)) {
            this.f1704l = 0;
            int i45 = 0;
            while (i45 < virtualChildCount) {
                View q11 = q(i45);
                if (q11 == null) {
                    this.f1704l += w(i45);
                } else if (q11.getVisibility() == 8) {
                    i45 += n(q11, i45);
                } else {
                    a aVar2 = (a) q11.getLayoutParams();
                    int i46 = this.f1704l;
                    if (z15) {
                        this.f1704l = i46 + ((LinearLayout.LayoutParams) aVar2).leftMargin + i28 + ((LinearLayout.LayoutParams) aVar2).rightMargin + p(q11);
                    } else {
                        i21 = max;
                        this.f1704l = Math.max(i46, i46 + i28 + ((LinearLayout.LayoutParams) aVar2).leftMargin + ((LinearLayout.LayoutParams) aVar2).rightMargin + p(q11));
                        i45++;
                        max = i21;
                    }
                }
                i21 = max;
                i45++;
                max = i21;
            }
        }
        int i47 = max;
        int paddingLeft = this.f1704l + getPaddingLeft() + getPaddingRight();
        this.f1704l = paddingLeft;
        int resolveSizeAndState = View.resolveSizeAndState(Math.max(paddingLeft, getSuggestedMinimumWidth()), i10, 0);
        int i48 = (16777215 & resolveSizeAndState) - this.f1704l;
        if (z16 || (i48 != 0 && f11 > 0.0f)) {
            float f14 = this.f1705m;
            if (f14 > 0.0f) {
                f11 = f14;
            }
            iArr2[3] = -1;
            iArr2[2] = -1;
            iArr2[1] = -1;
            iArr2[0] = -1;
            iArr[3] = -1;
            iArr[2] = -1;
            iArr[1] = -1;
            iArr[0] = -1;
            this.f1704l = 0;
            int i49 = i41;
            int i50 = i12;
            int i51 = -1;
            int i52 = 0;
            while (i52 < virtualChildCount) {
                View q12 = q(i52);
                if (q12 == null || q12.getVisibility() == 8) {
                    i16 = i48;
                    i17 = virtualChildCount;
                } else {
                    a aVar3 = (a) q12.getLayoutParams();
                    float f15 = ((LinearLayout.LayoutParams) aVar3).weight;
                    if (f15 > 0.0f) {
                        int i53 = (int) ((i48 * f15) / f11);
                        float f16 = f11 - f15;
                        int i54 = i48 - i53;
                        i17 = virtualChildCount;
                        int childMeasureSpec = ViewGroup.getChildMeasureSpec(i11, getPaddingTop() + getPaddingBottom() + ((LinearLayout.LayoutParams) aVar3).topMargin + ((LinearLayout.LayoutParams) aVar3).bottomMargin, ((LinearLayout.LayoutParams) aVar3).height);
                        if (((LinearLayout.LayoutParams) aVar3).width == 0) {
                            i20 = 1073741824;
                            if (mode == 1073741824) {
                            }
                        } else {
                            i20 = 1073741824;
                        }
                        i53 = q12.getMeasuredWidth() + i53;
                    } else {
                        i16 = i48;
                        i17 = virtualChildCount;
                    }
                    int i55 = this.f1704l;
                    if (z15) {
                        this.f1704l = i55 + q12.getMeasuredWidth() + ((LinearLayout.LayoutParams) aVar3).leftMargin + ((LinearLayout.LayoutParams) aVar3).rightMargin + p(q12);
                        f10 = f11;
                    } else {
                        f10 = f11;
                        this.f1704l = Math.max(i55, q12.getMeasuredWidth() + i55 + ((LinearLayout.LayoutParams) aVar3).leftMargin + ((LinearLayout.LayoutParams) aVar3).rightMargin + p(q12));
                    }
                    boolean z21 = mode2 != 1073741824 && ((LinearLayout.LayoutParams) aVar3).height == -1;
                    int i56 = ((LinearLayout.LayoutParams) aVar3).topMargin + ((LinearLayout.LayoutParams) aVar3).bottomMargin;
                    int measuredHeight2 = q12.getMeasuredHeight() + i56;
                    i51 = Math.max(i51, measuredHeight2);
                    if (!z21) {
                        i56 = measuredHeight2;
                    }
                    int max4 = Math.max(i49, i56);
                    if (z17) {
                        i18 = -1;
                        if (((LinearLayout.LayoutParams) aVar3).height == -1) {
                            z9 = true;
                            if (z20 && (baseline = q12.getBaseline()) != i18) {
                                i19 = ((LinearLayout.LayoutParams) aVar3).gravity;
                                if (i19 < 0) {
                                    i19 = this.f1703k;
                                }
                                int i57 = (((i19 & 112) >> 4) & (-2)) >> 1;
                                iArr2[i57] = Math.max(iArr2[i57], baseline);
                                iArr[i57] = Math.max(iArr[i57], measuredHeight2 - baseline);
                            }
                            z17 = z9;
                            i49 = max4;
                            f11 = f10;
                        }
                    } else {
                        i18 = -1;
                    }
                    z9 = false;
                    if (z20) {
                        i19 = ((LinearLayout.LayoutParams) aVar3).gravity;
                        if (i19 < 0) {
                        }
                        int i572 = (((i19 & 112) >> 4) & (-2)) >> 1;
                        iArr2[i572] = Math.max(iArr2[i572], baseline);
                        iArr[i572] = Math.max(iArr[i572], measuredHeight2 - baseline);
                    }
                    z17 = z9;
                    i49 = max4;
                    f11 = f10;
                }
                i52++;
                i48 = i16;
                virtualChildCount = i17;
            }
            i13 = i11;
            i14 = virtualChildCount;
            this.f1704l += getPaddingLeft() + getPaddingRight();
            int i58 = iArr2[1];
            max2 = (i58 == -1 && iArr2[0] == -1 && iArr2[2] == -1 && iArr2[3] == -1) ? i51 : Math.max(i51, Math.max(iArr2[3], Math.max(iArr2[0], Math.max(i58, iArr2[2]))) + Math.max(iArr[3], Math.max(iArr[0], Math.max(iArr[1], iArr[2]))));
            i15 = i49;
            i12 = i50;
        } else {
            i15 = Math.max(i41, i42);
            if (z19 && mode != 1073741824) {
                for (int i59 = 0; i59 < virtualChildCount; i59++) {
                    View q13 = q(i59);
                    if (q13 != null && q13.getVisibility() != 8 && ((LinearLayout.LayoutParams) ((a) q13.getLayoutParams())).weight > 0.0f) {
                        q13.measure(View.MeasureSpec.makeMeasureSpec(i28, 1073741824), View.MeasureSpec.makeMeasureSpec(q13.getMeasuredHeight(), 1073741824));
                    }
                }
            }
            i13 = i11;
            i14 = virtualChildCount;
            max2 = i47;
        }
        if (z17 || mode2 == 1073741824) {
            i15 = max2;
        }
        setMeasuredDimension(resolveSizeAndState | (i12 & (-16777216)), View.resolveSizeAndState(Math.max(i15 + getPaddingTop() + getPaddingBottom(), getSuggestedMinimumHeight()), i13, i12 << 16));
        if (z18) {
            i(i14, i10);
        }
    }

    int w(int i10) {
        return 0;
    }

    /* JADX WARN: Code restructure failed: missing block: B:131:0x02ce, code lost:
        if (r15 > 0) goto L150;
     */
    /* JADX WARN: Code restructure failed: missing block: B:135:0x02d9, code lost:
        if (r15 < 0) goto L149;
     */
    /* JADX WARN: Code restructure failed: missing block: B:136:0x02db, code lost:
        r15 = 0;
     */
    /* JADX WARN: Code restructure failed: missing block: B:137:0x02dc, code lost:
        r13.measure(r0, android.view.View.MeasureSpec.makeMeasureSpec(r15, r10));
        r1 = android.view.View.combineMeasuredStates(r1, r13.getMeasuredState() & (-256));
        r0 = r0;
     */
    /* JADX WARN: Removed duplicated region for block: B:148:0x0319  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    void x(int i10, int i11) {
        int i12;
        int i13;
        int i14;
        int i15;
        int i16;
        int i17;
        int i18;
        boolean z9;
        int i19;
        int max;
        int i20;
        int i21;
        int i22;
        int i23;
        int i24;
        int i25;
        int i26;
        int i27;
        View view;
        int max2;
        boolean z10;
        int max3;
        this.f1704l = 0;
        int virtualChildCount = getVirtualChildCount();
        int mode = View.MeasureSpec.getMode(i10);
        int mode2 = View.MeasureSpec.getMode(i11);
        int i28 = this.f1700h;
        boolean z11 = this.f1706n;
        float f10 = 0.0f;
        int i29 = 0;
        int i30 = 0;
        int i31 = 0;
        int i32 = 0;
        int i33 = 0;
        int i34 = 0;
        boolean z12 = false;
        boolean z13 = true;
        boolean z14 = false;
        while (true) {
            int i35 = 8;
            int i36 = i32;
            if (i34 >= virtualChildCount) {
                int i37 = i29;
                int i38 = i31;
                int i39 = i33;
                int i40 = virtualChildCount;
                int i41 = mode2;
                int i42 = i30;
                if (this.f1704l > 0) {
                    i12 = i40;
                    if (r(i12)) {
                        this.f1704l += this.f1711s;
                    }
                } else {
                    i12 = i40;
                }
                if (z11 && (i41 == Integer.MIN_VALUE || i41 == 0)) {
                    this.f1704l = 0;
                    int i43 = 0;
                    while (i43 < i12) {
                        View q10 = q(i43);
                        if (q10 == null) {
                            max = this.f1704l + w(i43);
                        } else if (q10.getVisibility() == i35) {
                            i43 += n(q10, i43);
                            i43++;
                            i35 = 8;
                        } else {
                            a aVar = (a) q10.getLayoutParams();
                            int i44 = this.f1704l;
                            max = Math.max(i44, i44 + i38 + ((LinearLayout.LayoutParams) aVar).topMargin + ((LinearLayout.LayoutParams) aVar).bottomMargin + p(q10));
                        }
                        this.f1704l = max;
                        i43++;
                        i35 = 8;
                    }
                }
                int paddingTop = this.f1704l + getPaddingTop() + getPaddingBottom();
                this.f1704l = paddingTop;
                int resolveSizeAndState = View.resolveSizeAndState(Math.max(paddingTop, getSuggestedMinimumHeight()), i11, 0);
                int i45 = (16777215 & resolveSizeAndState) - this.f1704l;
                if (z12 || (i45 != 0 && f10 > 0.0f)) {
                    float f11 = this.f1705m;
                    if (f11 > 0.0f) {
                        f10 = f11;
                    }
                    this.f1704l = 0;
                    int i46 = i45;
                    int i47 = i39;
                    i13 = i37;
                    int i48 = 0;
                    while (i48 < i12) {
                        View q11 = q(i48);
                        if (q11.getVisibility() == 8) {
                            i16 = i46;
                        } else {
                            a aVar2 = (a) q11.getLayoutParams();
                            float f12 = ((LinearLayout.LayoutParams) aVar2).weight;
                            if (f12 > 0.0f) {
                                int i49 = (int) ((i46 * f12) / f10);
                                float f13 = f10 - f12;
                                i16 = i46 - i49;
                                int childMeasureSpec = ViewGroup.getChildMeasureSpec(i10, getPaddingLeft() + getPaddingRight() + ((LinearLayout.LayoutParams) aVar2).leftMargin + ((LinearLayout.LayoutParams) aVar2).rightMargin, ((LinearLayout.LayoutParams) aVar2).width);
                                if (((LinearLayout.LayoutParams) aVar2).height == 0) {
                                    i19 = 1073741824;
                                    if (i41 == 1073741824) {
                                    }
                                } else {
                                    i19 = 1073741824;
                                }
                                i49 = q11.getMeasuredHeight() + i49;
                            } else {
                                i16 = i46;
                            }
                            int i50 = ((LinearLayout.LayoutParams) aVar2).leftMargin + ((LinearLayout.LayoutParams) aVar2).rightMargin;
                            int measuredWidth = q11.getMeasuredWidth() + i50;
                            i42 = Math.max(i42, measuredWidth);
                            float f14 = f10;
                            if (mode != 1073741824) {
                                i17 = i13;
                                i18 = -1;
                                if (((LinearLayout.LayoutParams) aVar2).width == -1) {
                                    z9 = true;
                                    if (!z9) {
                                        i50 = measuredWidth;
                                    }
                                    int max4 = Math.max(i47, i50);
                                    boolean z15 = !z13 && ((LinearLayout.LayoutParams) aVar2).width == i18;
                                    int i51 = this.f1704l;
                                    this.f1704l = Math.max(i51, q11.getMeasuredHeight() + i51 + ((LinearLayout.LayoutParams) aVar2).topMargin + ((LinearLayout.LayoutParams) aVar2).bottomMargin + p(q11));
                                    z13 = z15;
                                    i13 = i17;
                                    i47 = max4;
                                    f10 = f14;
                                }
                            } else {
                                i17 = i13;
                                i18 = -1;
                            }
                            z9 = false;
                            if (!z9) {
                            }
                            int max42 = Math.max(i47, i50);
                            if (z13) {
                            }
                            int i512 = this.f1704l;
                            this.f1704l = Math.max(i512, q11.getMeasuredHeight() + i512 + ((LinearLayout.LayoutParams) aVar2).topMargin + ((LinearLayout.LayoutParams) aVar2).bottomMargin + p(q11));
                            z13 = z15;
                            i13 = i17;
                            i47 = max42;
                            f10 = f14;
                        }
                        i48++;
                        i46 = i16;
                    }
                    i14 = i10;
                    this.f1704l += getPaddingTop() + getPaddingBottom();
                    i15 = i47;
                } else {
                    i15 = Math.max(i39, i36);
                    if (z11 && i41 != 1073741824) {
                        for (int i52 = 0; i52 < i12; i52++) {
                            View q12 = q(i52);
                            if (q12 != null && q12.getVisibility() != 8 && ((LinearLayout.LayoutParams) ((a) q12.getLayoutParams())).weight > 0.0f) {
                                q12.measure(View.MeasureSpec.makeMeasureSpec(q12.getMeasuredWidth(), 1073741824), View.MeasureSpec.makeMeasureSpec(i38, 1073741824));
                            }
                        }
                    }
                    i14 = i10;
                    i13 = i37;
                }
                if (z13 || mode == 1073741824) {
                    i15 = i42;
                }
                setMeasuredDimension(View.resolveSizeAndState(Math.max(i15 + getPaddingLeft() + getPaddingRight(), getSuggestedMinimumWidth()), i14, i13), resolveSizeAndState);
                if (z14) {
                    j(i12, i11);
                    return;
                }
                return;
            }
            View q13 = q(i34);
            if (q13 == null) {
                this.f1704l += w(i34);
                i23 = virtualChildCount;
                i24 = mode2;
                i32 = i36;
            } else {
                int i53 = i29;
                if (q13.getVisibility() == 8) {
                    i34 += n(q13, i34);
                    i23 = virtualChildCount;
                    i32 = i36;
                    i29 = i53;
                    i24 = mode2;
                } else {
                    if (r(i34)) {
                        this.f1704l += this.f1711s;
                    }
                    a aVar3 = (a) q13.getLayoutParams();
                    float f15 = ((LinearLayout.LayoutParams) aVar3).weight;
                    float f16 = f10 + f15;
                    if (mode2 == 1073741824 && ((LinearLayout.LayoutParams) aVar3).height == 0 && f15 > 0.0f) {
                        int i54 = this.f1704l;
                        this.f1704l = Math.max(i54, ((LinearLayout.LayoutParams) aVar3).topMargin + i54 + ((LinearLayout.LayoutParams) aVar3).bottomMargin);
                        max2 = i31;
                        view = q13;
                        i26 = i33;
                        i21 = i53;
                        i22 = i30;
                        z12 = true;
                        i23 = virtualChildCount;
                        i24 = mode2;
                        i25 = i36;
                        i27 = i34;
                    } else {
                        int i55 = i30;
                        if (((LinearLayout.LayoutParams) aVar3).height != 0 || f15 <= 0.0f) {
                            i20 = RecyclerView.UNDEFINED_DURATION;
                        } else {
                            ((LinearLayout.LayoutParams) aVar3).height = -2;
                            i20 = 0;
                        }
                        i21 = i53;
                        int i56 = i20;
                        i22 = i55;
                        int i57 = i31;
                        i23 = virtualChildCount;
                        i24 = mode2;
                        i25 = i36;
                        i26 = i33;
                        i27 = i34;
                        u(q13, i34, i10, 0, i11, f16 == 0.0f ? this.f1704l : 0);
                        if (i56 != Integer.MIN_VALUE) {
                            ((LinearLayout.LayoutParams) aVar3).height = i56;
                        }
                        int measuredHeight = q13.getMeasuredHeight();
                        int i58 = this.f1704l;
                        view = q13;
                        this.f1704l = Math.max(i58, i58 + measuredHeight + ((LinearLayout.LayoutParams) aVar3).topMargin + ((LinearLayout.LayoutParams) aVar3).bottomMargin + p(view));
                        max2 = z11 ? Math.max(measuredHeight, i57) : i57;
                    }
                    if (i28 >= 0 && i28 == i27 + 1) {
                        this.f1701i = this.f1704l;
                    }
                    if (i27 < i28 && ((LinearLayout.LayoutParams) aVar3).weight > 0.0f) {
                        throw new RuntimeException("A child of LinearLayout with index less than mBaselineAlignedChildIndex has weight > 0, which won't work.  Either remove the weight, or don't set mBaselineAlignedChildIndex.");
                    }
                    if (mode == 1073741824 || ((LinearLayout.LayoutParams) aVar3).width != -1) {
                        z10 = false;
                    } else {
                        z10 = true;
                        z14 = true;
                    }
                    int i59 = ((LinearLayout.LayoutParams) aVar3).leftMargin + ((LinearLayout.LayoutParams) aVar3).rightMargin;
                    int measuredWidth2 = view.getMeasuredWidth() + i59;
                    int max5 = Math.max(i22, measuredWidth2);
                    int combineMeasuredStates = View.combineMeasuredStates(i21, view.getMeasuredState());
                    z13 = z13 && ((LinearLayout.LayoutParams) aVar3).width == -1;
                    if (((LinearLayout.LayoutParams) aVar3).weight > 0.0f) {
                        if (!z10) {
                            i59 = measuredWidth2;
                        }
                        i32 = Math.max(i25, i59);
                        max3 = i26;
                    } else {
                        if (!z10) {
                            i59 = measuredWidth2;
                        }
                        max3 = Math.max(i26, i59);
                        i32 = i25;
                    }
                    i31 = max2;
                    f10 = f16;
                    i33 = max3;
                    i29 = combineMeasuredStates;
                    i34 = n(view, i27) + i27;
                    i30 = max5;
                }
            }
            i34++;
            mode2 = i24;
            virtualChildCount = i23;
        }
    }
}
