package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.ImageView;
/* loaded from: classes.dex */
public class q {

    /* renamed from: a  reason: collision with root package name */
    private final ImageView f1694a;

    /* renamed from: b  reason: collision with root package name */
    private i2 f1695b;

    /* renamed from: c  reason: collision with root package name */
    private i2 f1696c;

    /* renamed from: d  reason: collision with root package name */
    private i2 f1697d;

    /* renamed from: e  reason: collision with root package name */
    private int f1698e = 0;

    public q(ImageView imageView) {
        this.f1694a = imageView;
    }

    private boolean a(Drawable drawable) {
        if (this.f1697d == null) {
            this.f1697d = new i2();
        }
        i2 i2Var = this.f1697d;
        i2Var.a();
        ColorStateList a10 = androidx.core.widget.h.a(this.f1694a);
        if (a10 != null) {
            i2Var.f1590d = true;
            i2Var.f1587a = a10;
        }
        PorterDuff.Mode b10 = androidx.core.widget.h.b(this.f1694a);
        if (b10 != null) {
            i2Var.f1589c = true;
            i2Var.f1588b = b10;
        }
        if (i2Var.f1590d || i2Var.f1589c) {
            k.h(drawable, i2Var, this.f1694a.getDrawableState());
            return true;
        }
        return false;
    }

    private boolean l() {
        int i10 = Build.VERSION.SDK_INT;
        return i10 > 21 ? this.f1695b != null : i10 == 21;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void b() {
        if (this.f1694a.getDrawable() != null) {
            this.f1694a.getDrawable().setLevel(this.f1698e);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void c() {
        Drawable drawable = this.f1694a.getDrawable();
        if (drawable != null) {
            m1.b(drawable);
        }
        if (drawable != null) {
            if (l() && a(drawable)) {
                return;
            }
            i2 i2Var = this.f1696c;
            if (i2Var != null) {
                k.h(drawable, i2Var, this.f1694a.getDrawableState());
                return;
            }
            i2 i2Var2 = this.f1695b;
            if (i2Var2 != null) {
                k.h(drawable, i2Var2, this.f1694a.getDrawableState());
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public ColorStateList d() {
        i2 i2Var = this.f1696c;
        if (i2Var != null) {
            return i2Var.f1587a;
        }
        return null;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public PorterDuff.Mode e() {
        i2 i2Var = this.f1696c;
        if (i2Var != null) {
            return i2Var.f1588b;
        }
        return null;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean f() {
        return !(this.f1694a.getBackground() instanceof RippleDrawable);
    }

    public void g(AttributeSet attributeSet, int i10) {
        int n10;
        Context context = this.f1694a.getContext();
        int[] iArr = g.j.P;
        k2 v9 = k2.v(context, attributeSet, iArr, i10, 0);
        ImageView imageView = this.f1694a;
        androidx.core.view.r0.l0(imageView, imageView.getContext(), iArr, attributeSet, v9.r(), i10, 0);
        try {
            Drawable drawable = this.f1694a.getDrawable();
            if (drawable == null && (n10 = v9.n(g.j.Q, -1)) != -1 && (drawable = h.a.b(this.f1694a.getContext(), n10)) != null) {
                this.f1694a.setImageDrawable(drawable);
            }
            if (drawable != null) {
                m1.b(drawable);
            }
            int i11 = g.j.R;
            if (v9.s(i11)) {
                androidx.core.widget.h.c(this.f1694a, v9.c(i11));
            }
            int i12 = g.j.S;
            if (v9.s(i12)) {
                androidx.core.widget.h.d(this.f1694a, m1.d(v9.k(i12, -1), null));
            }
        } finally {
            v9.w();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void h(Drawable drawable) {
        this.f1698e = drawable.getLevel();
    }

    public void i(int i10) {
        if (i10 != 0) {
            Drawable b10 = h.a.b(this.f1694a.getContext(), i10);
            if (b10 != null) {
                m1.b(b10);
            }
            this.f1694a.setImageDrawable(b10);
        } else {
            this.f1694a.setImageDrawable(null);
        }
        c();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void j(ColorStateList colorStateList) {
        if (this.f1696c == null) {
            this.f1696c = new i2();
        }
        i2 i2Var = this.f1696c;
        i2Var.f1587a = colorStateList;
        i2Var.f1590d = true;
        c();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void k(PorterDuff.Mode mode) {
        if (this.f1696c == null) {
            this.f1696c = new i2();
        }
        i2 i2Var = this.f1696c;
        i2Var.f1588b = mode;
        i2Var.f1589c = true;
        c();
    }
}
