package androidx.appcompat.widget;

import android.os.SystemClock;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
/* loaded from: classes.dex */
public abstract class p1 implements View.OnTouchListener, View.OnAttachStateChangeListener {

    /* renamed from: g  reason: collision with root package name */
    private final float f1683g;

    /* renamed from: h  reason: collision with root package name */
    private final int f1684h;

    /* renamed from: i  reason: collision with root package name */
    private final int f1685i;

    /* renamed from: j  reason: collision with root package name */
    final View f1686j;

    /* renamed from: k  reason: collision with root package name */
    private Runnable f1687k;

    /* renamed from: l  reason: collision with root package name */
    private Runnable f1688l;

    /* renamed from: m  reason: collision with root package name */
    private boolean f1689m;

    /* renamed from: n  reason: collision with root package name */
    private int f1690n;

    /* renamed from: o  reason: collision with root package name */
    private final int[] f1691o = new int[2];

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class a implements Runnable {
        a() {
        }

        @Override // java.lang.Runnable
        public void run() {
            ViewParent parent = p1.this.f1686j.getParent();
            if (parent != null) {
                parent.requestDisallowInterceptTouchEvent(true);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class b implements Runnable {
        b() {
        }

        @Override // java.lang.Runnable
        public void run() {
            p1.this.e();
        }
    }

    public p1(View view) {
        this.f1686j = view;
        view.setLongClickable(true);
        view.addOnAttachStateChangeListener(this);
        this.f1683g = ViewConfiguration.get(view.getContext()).getScaledTouchSlop();
        int tapTimeout = ViewConfiguration.getTapTimeout();
        this.f1684h = tapTimeout;
        this.f1685i = (tapTimeout + ViewConfiguration.getLongPressTimeout()) / 2;
    }

    private void a() {
        Runnable runnable = this.f1688l;
        if (runnable != null) {
            this.f1686j.removeCallbacks(runnable);
        }
        Runnable runnable2 = this.f1687k;
        if (runnable2 != null) {
            this.f1686j.removeCallbacks(runnable2);
        }
    }

    private boolean f(MotionEvent motionEvent) {
        n1 n1Var;
        View view = this.f1686j;
        androidx.appcompat.view.menu.p b10 = b();
        if (b10 == null || !b10.a() || (n1Var = (n1) b10.i()) == null || !n1Var.isShown()) {
            return false;
        }
        MotionEvent obtainNoHistory = MotionEvent.obtainNoHistory(motionEvent);
        i(view, obtainNoHistory);
        j(n1Var, obtainNoHistory);
        boolean e10 = n1Var.e(obtainNoHistory, this.f1690n);
        obtainNoHistory.recycle();
        int actionMasked = motionEvent.getActionMasked();
        return e10 && (actionMasked != 1 && actionMasked != 3);
    }

    /* JADX WARN: Code restructure failed: missing block: B:12:0x0017, code lost:
        if (r1 != 3) goto L13;
     */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    private boolean g(MotionEvent motionEvent) {
        View view = this.f1686j;
        if (view.isEnabled()) {
            int actionMasked = motionEvent.getActionMasked();
            if (actionMasked != 0) {
                if (actionMasked != 1) {
                    if (actionMasked == 2) {
                        int findPointerIndex = motionEvent.findPointerIndex(this.f1690n);
                        if (findPointerIndex >= 0 && !h(view, motionEvent.getX(findPointerIndex), motionEvent.getY(findPointerIndex), this.f1683g)) {
                            a();
                            view.getParent().requestDisallowInterceptTouchEvent(true);
                            return true;
                        }
                    }
                }
                a();
            } else {
                this.f1690n = motionEvent.getPointerId(0);
                if (this.f1687k == null) {
                    this.f1687k = new a();
                }
                view.postDelayed(this.f1687k, this.f1684h);
                if (this.f1688l == null) {
                    this.f1688l = new b();
                }
                view.postDelayed(this.f1688l, this.f1685i);
            }
            return false;
        }
        return false;
    }

    private static boolean h(View view, float f10, float f11, float f12) {
        float f13 = -f12;
        return f10 >= f13 && f11 >= f13 && f10 < ((float) (view.getRight() - view.getLeft())) + f12 && f11 < ((float) (view.getBottom() - view.getTop())) + f12;
    }

    private boolean i(View view, MotionEvent motionEvent) {
        int[] iArr = this.f1691o;
        view.getLocationOnScreen(iArr);
        motionEvent.offsetLocation(iArr[0], iArr[1]);
        return true;
    }

    private boolean j(View view, MotionEvent motionEvent) {
        int[] iArr = this.f1691o;
        view.getLocationOnScreen(iArr);
        motionEvent.offsetLocation(-iArr[0], -iArr[1]);
        return true;
    }

    public abstract androidx.appcompat.view.menu.p b();

    protected abstract boolean c();

    protected boolean d() {
        androidx.appcompat.view.menu.p b10 = b();
        if (b10 == null || !b10.a()) {
            return true;
        }
        b10.dismiss();
        return true;
    }

    void e() {
        a();
        View view = this.f1686j;
        if (view.isEnabled() && !view.isLongClickable() && c()) {
            view.getParent().requestDisallowInterceptTouchEvent(true);
            long uptimeMillis = SystemClock.uptimeMillis();
            MotionEvent obtain = MotionEvent.obtain(uptimeMillis, uptimeMillis, 3, 0.0f, 0.0f, 0);
            view.onTouchEvent(obtain);
            obtain.recycle();
            this.f1689m = true;
        }
    }

    @Override // android.view.View.OnTouchListener
    public boolean onTouch(View view, MotionEvent motionEvent) {
        boolean z9;
        boolean z10 = this.f1689m;
        if (z10) {
            z9 = f(motionEvent) || !d();
        } else {
            z9 = g(motionEvent) && c();
            if (z9) {
                long uptimeMillis = SystemClock.uptimeMillis();
                MotionEvent obtain = MotionEvent.obtain(uptimeMillis, uptimeMillis, 3, 0.0f, 0.0f, 0);
                this.f1686j.onTouchEvent(obtain);
                obtain.recycle();
            }
        }
        this.f1689m = z9;
        return z9 || z10;
    }

    @Override // android.view.View.OnAttachStateChangeListener
    public void onViewAttachedToWindow(View view) {
    }

    @Override // android.view.View.OnAttachStateChangeListener
    public void onViewDetachedFromWindow(View view) {
        this.f1689m = false;
        this.f1690n = -1;
        Runnable runnable = this.f1687k;
        if (runnable != null) {
            this.f1686j.removeCallbacks(runnable);
        }
    }
}
