package androidx.appcompat.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import androidx.appcompat.view.menu.m;
/* loaded from: classes.dex */
public class o2 implements l1 {

    /* renamed from: a  reason: collision with root package name */
    Toolbar f1658a;

    /* renamed from: b  reason: collision with root package name */
    private int f1659b;

    /* renamed from: c  reason: collision with root package name */
    private View f1660c;

    /* renamed from: d  reason: collision with root package name */
    private View f1661d;

    /* renamed from: e  reason: collision with root package name */
    private Drawable f1662e;

    /* renamed from: f  reason: collision with root package name */
    private Drawable f1663f;

    /* renamed from: g  reason: collision with root package name */
    private Drawable f1664g;

    /* renamed from: h  reason: collision with root package name */
    private boolean f1665h;

    /* renamed from: i  reason: collision with root package name */
    CharSequence f1666i;

    /* renamed from: j  reason: collision with root package name */
    private CharSequence f1667j;

    /* renamed from: k  reason: collision with root package name */
    private CharSequence f1668k;

    /* renamed from: l  reason: collision with root package name */
    Window.Callback f1669l;

    /* renamed from: m  reason: collision with root package name */
    boolean f1670m;

    /* renamed from: n  reason: collision with root package name */
    private c f1671n;

    /* renamed from: o  reason: collision with root package name */
    private int f1672o;

    /* renamed from: p  reason: collision with root package name */
    private int f1673p;

    /* renamed from: q  reason: collision with root package name */
    private Drawable f1674q;

    /* loaded from: classes.dex */
    class a implements View.OnClickListener {

        /* renamed from: g  reason: collision with root package name */
        final androidx.appcompat.view.menu.a f1675g;

        a() {
            this.f1675g = new androidx.appcompat.view.menu.a(o2.this.f1658a.getContext(), 0, 16908332, 0, 0, o2.this.f1666i);
        }

        @Override // android.view.View.OnClickListener
        public void onClick(View view) {
            o2 o2Var = o2.this;
            Window.Callback callback = o2Var.f1669l;
            if (callback == null || !o2Var.f1670m) {
                return;
            }
            callback.onMenuItemSelected(0, this.f1675g);
        }
    }

    /* loaded from: classes.dex */
    class b extends androidx.core.view.w2 {

        /* renamed from: a  reason: collision with root package name */
        private boolean f1677a = false;

        /* renamed from: b  reason: collision with root package name */
        final /* synthetic */ int f1678b;

        b(int i10) {
            this.f1678b = i10;
        }

        @Override // androidx.core.view.w2, androidx.core.view.v2
        public void a(View view) {
            this.f1677a = true;
        }

        @Override // androidx.core.view.v2
        public void b(View view) {
            if (this.f1677a) {
                return;
            }
            o2.this.f1658a.setVisibility(this.f1678b);
        }

        @Override // androidx.core.view.w2, androidx.core.view.v2
        public void c(View view) {
            o2.this.f1658a.setVisibility(0);
        }
    }

    public o2(Toolbar toolbar, boolean z9) {
        this(toolbar, z9, g.h.abc_action_bar_up_description, g.e.abc_ic_ab_back_material);
    }

    public o2(Toolbar toolbar, boolean z9, int i10, int i11) {
        Drawable drawable;
        this.f1672o = 0;
        this.f1673p = 0;
        this.f1658a = toolbar;
        this.f1666i = toolbar.getTitle();
        this.f1667j = toolbar.getSubtitle();
        this.f1665h = this.f1666i != null;
        this.f1664g = toolbar.getNavigationIcon();
        k2 v9 = k2.v(toolbar.getContext(), null, g.j.f7771a, g.a.actionBarStyle, 0);
        this.f1674q = v9.g(g.j.f7826l);
        if (z9) {
            CharSequence p10 = v9.p(g.j.f7856r);
            if (!TextUtils.isEmpty(p10)) {
                C(p10);
            }
            CharSequence p11 = v9.p(g.j.f7846p);
            if (!TextUtils.isEmpty(p11)) {
                B(p11);
            }
            Drawable g10 = v9.g(g.j.f7836n);
            if (g10 != null) {
                x(g10);
            }
            Drawable g11 = v9.g(g.j.f7831m);
            if (g11 != null) {
                setIcon(g11);
            }
            if (this.f1664g == null && (drawable = this.f1674q) != null) {
                A(drawable);
            }
            k(v9.k(g.j.f7806h, 0));
            int n10 = v9.n(g.j.f7801g, 0);
            if (n10 != 0) {
                v(LayoutInflater.from(this.f1658a.getContext()).inflate(n10, (ViewGroup) this.f1658a, false));
                k(this.f1659b | 16);
            }
            int m10 = v9.m(g.j.f7816j, 0);
            if (m10 > 0) {
                ViewGroup.LayoutParams layoutParams = this.f1658a.getLayoutParams();
                layoutParams.height = m10;
                this.f1658a.setLayoutParams(layoutParams);
            }
            int e10 = v9.e(g.j.f7796f, -1);
            int e11 = v9.e(g.j.f7791e, -1);
            if (e10 >= 0 || e11 >= 0) {
                this.f1658a.J(Math.max(e10, 0), Math.max(e11, 0));
            }
            int n11 = v9.n(g.j.f7861s, 0);
            if (n11 != 0) {
                Toolbar toolbar2 = this.f1658a;
                toolbar2.M(toolbar2.getContext(), n11);
            }
            int n12 = v9.n(g.j.f7851q, 0);
            if (n12 != 0) {
                Toolbar toolbar3 = this.f1658a;
                toolbar3.L(toolbar3.getContext(), n12);
            }
            int n13 = v9.n(g.j.f7841o, 0);
            if (n13 != 0) {
                this.f1658a.setPopupTheme(n13);
            }
        } else {
            this.f1659b = u();
        }
        v9.w();
        w(i10);
        this.f1668k = this.f1658a.getNavigationContentDescription();
        this.f1658a.setNavigationOnClickListener(new a());
    }

    private void D(CharSequence charSequence) {
        this.f1666i = charSequence;
        if ((this.f1659b & 8) != 0) {
            this.f1658a.setTitle(charSequence);
            if (this.f1665h) {
                androidx.core.view.r0.q0(this.f1658a.getRootView(), charSequence);
            }
        }
    }

    private void E() {
        if ((this.f1659b & 4) != 0) {
            if (TextUtils.isEmpty(this.f1668k)) {
                this.f1658a.setNavigationContentDescription(this.f1673p);
            } else {
                this.f1658a.setNavigationContentDescription(this.f1668k);
            }
        }
    }

    private void F() {
        Toolbar toolbar;
        Drawable drawable;
        if ((this.f1659b & 4) != 0) {
            toolbar = this.f1658a;
            drawable = this.f1664g;
            if (drawable == null) {
                drawable = this.f1674q;
            }
        } else {
            toolbar = this.f1658a;
            drawable = null;
        }
        toolbar.setNavigationIcon(drawable);
    }

    private void G() {
        Drawable drawable;
        int i10 = this.f1659b;
        if ((i10 & 2) == 0) {
            drawable = null;
        } else if ((i10 & 1) == 0 || (drawable = this.f1663f) == null) {
            drawable = this.f1662e;
        }
        this.f1658a.setLogo(drawable);
    }

    private int u() {
        if (this.f1658a.getNavigationIcon() != null) {
            this.f1674q = this.f1658a.getNavigationIcon();
            return 15;
        }
        return 11;
    }

    public void A(Drawable drawable) {
        this.f1664g = drawable;
        F();
    }

    public void B(CharSequence charSequence) {
        this.f1667j = charSequence;
        if ((this.f1659b & 8) != 0) {
            this.f1658a.setSubtitle(charSequence);
        }
    }

    public void C(CharSequence charSequence) {
        this.f1665h = true;
        D(charSequence);
    }

    @Override // androidx.appcompat.widget.l1
    public void a(Menu menu, m.a aVar) {
        if (this.f1671n == null) {
            c cVar = new c(this.f1658a.getContext());
            this.f1671n = cVar;
            cVar.p(g.f.action_menu_presenter);
        }
        this.f1671n.g(aVar);
        this.f1658a.K((androidx.appcompat.view.menu.g) menu, this.f1671n);
    }

    @Override // androidx.appcompat.widget.l1
    public boolean b() {
        return this.f1658a.B();
    }

    @Override // androidx.appcompat.widget.l1
    public void c() {
        this.f1670m = true;
    }

    @Override // androidx.appcompat.widget.l1
    public void collapseActionView() {
        this.f1658a.e();
    }

    @Override // androidx.appcompat.widget.l1
    public boolean d() {
        return this.f1658a.d();
    }

    @Override // androidx.appcompat.widget.l1
    public boolean e() {
        return this.f1658a.A();
    }

    @Override // androidx.appcompat.widget.l1
    public boolean f() {
        return this.f1658a.w();
    }

    @Override // androidx.appcompat.widget.l1
    public boolean g() {
        return this.f1658a.P();
    }

    @Override // androidx.appcompat.widget.l1
    public Context getContext() {
        return this.f1658a.getContext();
    }

    @Override // androidx.appcompat.widget.l1
    public CharSequence getTitle() {
        return this.f1658a.getTitle();
    }

    @Override // androidx.appcompat.widget.l1
    public void h() {
        this.f1658a.f();
    }

    @Override // androidx.appcompat.widget.l1
    public void i(d2 d2Var) {
        View view = this.f1660c;
        if (view != null) {
            ViewParent parent = view.getParent();
            Toolbar toolbar = this.f1658a;
            if (parent == toolbar) {
                toolbar.removeView(this.f1660c);
            }
        }
        this.f1660c = d2Var;
    }

    @Override // androidx.appcompat.widget.l1
    public boolean j() {
        return this.f1658a.v();
    }

    @Override // androidx.appcompat.widget.l1
    public void k(int i10) {
        View view;
        CharSequence charSequence;
        Toolbar toolbar;
        int i11 = this.f1659b ^ i10;
        this.f1659b = i10;
        if (i11 != 0) {
            if ((i11 & 4) != 0) {
                if ((i10 & 4) != 0) {
                    E();
                }
                F();
            }
            if ((i11 & 3) != 0) {
                G();
            }
            if ((i11 & 8) != 0) {
                if ((i10 & 8) != 0) {
                    this.f1658a.setTitle(this.f1666i);
                    toolbar = this.f1658a;
                    charSequence = this.f1667j;
                } else {
                    charSequence = null;
                    this.f1658a.setTitle((CharSequence) null);
                    toolbar = this.f1658a;
                }
                toolbar.setSubtitle(charSequence);
            }
            if ((i11 & 16) == 0 || (view = this.f1661d) == null) {
                return;
            }
            if ((i10 & 16) != 0) {
                this.f1658a.addView(view);
            } else {
                this.f1658a.removeView(view);
            }
        }
    }

    @Override // androidx.appcompat.widget.l1
    public void l(int i10) {
        x(i10 != 0 ? h.a.b(getContext(), i10) : null);
    }

    @Override // androidx.appcompat.widget.l1
    public int m() {
        return this.f1672o;
    }

    @Override // androidx.appcompat.widget.l1
    public androidx.core.view.u2 n(int i10, long j10) {
        return androidx.core.view.r0.d(this.f1658a).b(i10 == 0 ? 1.0f : 0.0f).f(j10).h(new b(i10));
    }

    @Override // androidx.appcompat.widget.l1
    public void o(int i10) {
        this.f1658a.setVisibility(i10);
    }

    @Override // androidx.appcompat.widget.l1
    public void p(boolean z9) {
    }

    @Override // androidx.appcompat.widget.l1
    public int q() {
        return this.f1659b;
    }

    @Override // androidx.appcompat.widget.l1
    public void r() {
        Log.i("ToolbarWidgetWrapper", "Progress display unsupported");
    }

    @Override // androidx.appcompat.widget.l1
    public void s() {
        Log.i("ToolbarWidgetWrapper", "Progress display unsupported");
    }

    @Override // androidx.appcompat.widget.l1
    public void setIcon(int i10) {
        setIcon(i10 != 0 ? h.a.b(getContext(), i10) : null);
    }

    @Override // androidx.appcompat.widget.l1
    public void setIcon(Drawable drawable) {
        this.f1662e = drawable;
        G();
    }

    @Override // androidx.appcompat.widget.l1
    public void setWindowCallback(Window.Callback callback) {
        this.f1669l = callback;
    }

    @Override // androidx.appcompat.widget.l1
    public void setWindowTitle(CharSequence charSequence) {
        if (this.f1665h) {
            return;
        }
        D(charSequence);
    }

    @Override // androidx.appcompat.widget.l1
    public void t(boolean z9) {
        this.f1658a.setCollapsible(z9);
    }

    public void v(View view) {
        View view2 = this.f1661d;
        if (view2 != null && (this.f1659b & 16) != 0) {
            this.f1658a.removeView(view2);
        }
        this.f1661d = view;
        if (view == null || (this.f1659b & 16) == 0) {
            return;
        }
        this.f1658a.addView(view);
    }

    public void w(int i10) {
        if (i10 == this.f1673p) {
            return;
        }
        this.f1673p = i10;
        if (TextUtils.isEmpty(this.f1658a.getNavigationContentDescription())) {
            y(this.f1673p);
        }
    }

    public void x(Drawable drawable) {
        this.f1663f = drawable;
        G();
    }

    public void y(int i10) {
        z(i10 == 0 ? null : getContext().getString(i10));
    }

    public void z(CharSequence charSequence) {
        this.f1668k = charSequence;
        E();
    }
}
