package androidx.appcompat.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public class n1 extends ListView {

    /* renamed from: g  reason: collision with root package name */
    private final Rect f1636g;

    /* renamed from: h  reason: collision with root package name */
    private int f1637h;

    /* renamed from: i  reason: collision with root package name */
    private int f1638i;

    /* renamed from: j  reason: collision with root package name */
    private int f1639j;

    /* renamed from: k  reason: collision with root package name */
    private int f1640k;

    /* renamed from: l  reason: collision with root package name */
    private int f1641l;

    /* renamed from: m  reason: collision with root package name */
    private d f1642m;

    /* renamed from: n  reason: collision with root package name */
    private boolean f1643n;

    /* renamed from: o  reason: collision with root package name */
    private boolean f1644o;

    /* renamed from: p  reason: collision with root package name */
    private boolean f1645p;

    /* renamed from: q  reason: collision with root package name */
    private androidx.core.view.u2 f1646q;

    /* renamed from: r  reason: collision with root package name */
    private androidx.core.widget.i f1647r;

    /* renamed from: s  reason: collision with root package name */
    f f1648s;

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class a {
        static void a(View view, float f10, float f11) {
            view.drawableHotspotChanged(f10, f11);
        }
    }

    /* loaded from: classes.dex */
    static class b {

        /* renamed from: a  reason: collision with root package name */
        private static Method f1649a;

        /* renamed from: b  reason: collision with root package name */
        private static Method f1650b;

        /* renamed from: c  reason: collision with root package name */
        private static Method f1651c;

        /* renamed from: d  reason: collision with root package name */
        private static boolean f1652d;

        static {
            try {
                Class cls = Integer.TYPE;
                Class cls2 = Float.TYPE;
                Method declaredMethod = AbsListView.class.getDeclaredMethod("positionSelector", cls, View.class, Boolean.TYPE, cls2, cls2);
                f1649a = declaredMethod;
                declaredMethod.setAccessible(true);
                Method declaredMethod2 = AdapterView.class.getDeclaredMethod("setSelectedPositionInt", cls);
                f1650b = declaredMethod2;
                declaredMethod2.setAccessible(true);
                Method declaredMethod3 = AdapterView.class.getDeclaredMethod("setNextSelectedPositionInt", cls);
                f1651c = declaredMethod3;
                declaredMethod3.setAccessible(true);
                f1652d = true;
            } catch (NoSuchMethodException e10) {
                e10.printStackTrace();
            }
        }

        static boolean a() {
            return f1652d;
        }

        static void b(n1 n1Var, int i10, View view) {
            try {
                f1649a.invoke(n1Var, Integer.valueOf(i10), view, Boolean.FALSE, -1, -1);
                f1650b.invoke(n1Var, Integer.valueOf(i10));
                f1651c.invoke(n1Var, Integer.valueOf(i10));
            } catch (IllegalAccessException | InvocationTargetException e10) {
                e10.printStackTrace();
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class c {
        static boolean a(AbsListView absListView) {
            return absListView.isSelectedChildViewEnabled();
        }

        static void b(AbsListView absListView, boolean z9) {
            absListView.setSelectedChildViewEnabled(z9);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class d extends i.c {

        /* renamed from: h  reason: collision with root package name */
        private boolean f1653h;

        d(Drawable drawable) {
            super(drawable);
            this.f1653h = true;
        }

        void b(boolean z9) {
            this.f1653h = z9;
        }

        @Override // i.c, android.graphics.drawable.Drawable
        public void draw(Canvas canvas) {
            if (this.f1653h) {
                super.draw(canvas);
            }
        }

        @Override // i.c, android.graphics.drawable.Drawable
        public void setHotspot(float f10, float f11) {
            if (this.f1653h) {
                super.setHotspot(f10, f11);
            }
        }

        @Override // i.c, android.graphics.drawable.Drawable
        public void setHotspotBounds(int i10, int i11, int i12, int i13) {
            if (this.f1653h) {
                super.setHotspotBounds(i10, i11, i12, i13);
            }
        }

        @Override // i.c, android.graphics.drawable.Drawable
        public boolean setState(int[] iArr) {
            if (this.f1653h) {
                return super.setState(iArr);
            }
            return false;
        }

        @Override // i.c, android.graphics.drawable.Drawable
        public boolean setVisible(boolean z9, boolean z10) {
            if (this.f1653h) {
                return super.setVisible(z9, z10);
            }
            return false;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class e {

        /* renamed from: a  reason: collision with root package name */
        private static final Field f1654a;

        static {
            Field field = null;
            try {
                field = AbsListView.class.getDeclaredField("mIsChildViewEnabled");
                field.setAccessible(true);
            } catch (NoSuchFieldException e10) {
                e10.printStackTrace();
            }
            f1654a = field;
        }

        static boolean a(AbsListView absListView) {
            Field field = f1654a;
            if (field != null) {
                try {
                    return field.getBoolean(absListView);
                } catch (IllegalAccessException e10) {
                    e10.printStackTrace();
                    return false;
                }
            }
            return false;
        }

        static void b(AbsListView absListView, boolean z9) {
            Field field = f1654a;
            if (field != null) {
                try {
                    field.set(absListView, Boolean.valueOf(z9));
                } catch (IllegalAccessException e10) {
                    e10.printStackTrace();
                }
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class f implements Runnable {
        f() {
        }

        public void a() {
            n1 n1Var = n1.this;
            n1Var.f1648s = null;
            n1Var.removeCallbacks(this);
        }

        public void b() {
            n1.this.post(this);
        }

        @Override // java.lang.Runnable
        public void run() {
            n1 n1Var = n1.this;
            n1Var.f1648s = null;
            n1Var.drawableStateChanged();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public n1(Context context, boolean z9) {
        super(context, null, g.a.dropDownListViewStyle);
        this.f1636g = new Rect();
        this.f1637h = 0;
        this.f1638i = 0;
        this.f1639j = 0;
        this.f1640k = 0;
        this.f1644o = z9;
        setCacheColorHint(0);
    }

    private void a() {
        this.f1645p = false;
        setPressed(false);
        drawableStateChanged();
        View childAt = getChildAt(this.f1641l - getFirstVisiblePosition());
        if (childAt != null) {
            childAt.setPressed(false);
        }
        androidx.core.view.u2 u2Var = this.f1646q;
        if (u2Var != null) {
            u2Var.c();
            this.f1646q = null;
        }
    }

    private void b(View view, int i10) {
        performItemClick(view, i10, getItemIdAtPosition(i10));
    }

    private void c(Canvas canvas) {
        Drawable selector;
        if (this.f1636g.isEmpty() || (selector = getSelector()) == null) {
            return;
        }
        selector.setBounds(this.f1636g);
        selector.draw(canvas);
    }

    private void f(int i10, View view) {
        Rect rect = this.f1636g;
        rect.set(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        rect.left -= this.f1637h;
        rect.top -= this.f1638i;
        rect.right += this.f1639j;
        rect.bottom += this.f1640k;
        boolean k10 = k();
        if (view.isEnabled() != k10) {
            l(!k10);
            if (i10 != -1) {
                refreshDrawableState();
            }
        }
    }

    private void g(int i10, View view) {
        Drawable selector = getSelector();
        boolean z9 = (selector == null || i10 == -1) ? false : true;
        if (z9) {
            selector.setVisible(false, false);
        }
        f(i10, view);
        if (z9) {
            Rect rect = this.f1636g;
            float exactCenterX = rect.exactCenterX();
            float exactCenterY = rect.exactCenterY();
            selector.setVisible(getVisibility() == 0, false);
            androidx.core.graphics.drawable.a.k(selector, exactCenterX, exactCenterY);
        }
    }

    private void h(int i10, View view, float f10, float f11) {
        g(i10, view);
        Drawable selector = getSelector();
        if (selector == null || i10 == -1) {
            return;
        }
        androidx.core.graphics.drawable.a.k(selector, f10, f11);
    }

    private void i(View view, int i10, float f10, float f11) {
        View childAt;
        this.f1645p = true;
        a.a(this, f10, f11);
        if (!isPressed()) {
            setPressed(true);
        }
        layoutChildren();
        int i11 = this.f1641l;
        if (i11 != -1 && (childAt = getChildAt(i11 - getFirstVisiblePosition())) != null && childAt != view && childAt.isPressed()) {
            childAt.setPressed(false);
        }
        this.f1641l = i10;
        a.a(view, f10 - view.getLeft(), f11 - view.getTop());
        if (!view.isPressed()) {
            view.setPressed(true);
        }
        h(i10, view, f10, f11);
        j(false);
        refreshDrawableState();
    }

    private void j(boolean z9) {
        d dVar = this.f1642m;
        if (dVar != null) {
            dVar.b(z9);
        }
    }

    private boolean k() {
        return androidx.core.os.a.b() ? c.a(this) : e.a(this);
    }

    private void l(boolean z9) {
        if (androidx.core.os.a.b()) {
            c.b(this, z9);
        } else {
            e.b(this, z9);
        }
    }

    private boolean m() {
        return this.f1645p;
    }

    private void n() {
        Drawable selector = getSelector();
        if (selector != null && m() && isPressed()) {
            selector.setState(getDrawableState());
        }
    }

    public int d(int i10, int i11, int i12, int i13, int i14) {
        int listPaddingTop = getListPaddingTop();
        int listPaddingBottom = getListPaddingBottom();
        int dividerHeight = getDividerHeight();
        Drawable divider = getDivider();
        ListAdapter adapter = getAdapter();
        int i15 = listPaddingTop + listPaddingBottom;
        if (adapter == null) {
            return i15;
        }
        dividerHeight = (dividerHeight <= 0 || divider == null) ? 0 : 0;
        int count = adapter.getCount();
        View view = null;
        int i16 = 0;
        int i17 = 0;
        int i18 = 0;
        while (i16 < count) {
            int itemViewType = adapter.getItemViewType(i16);
            if (itemViewType != i17) {
                view = null;
                i17 = itemViewType;
            }
            view = adapter.getView(i16, view, this);
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            if (layoutParams == null) {
                layoutParams = generateDefaultLayoutParams();
                view.setLayoutParams(layoutParams);
            }
            int i19 = layoutParams.height;
            view.measure(i10, i19 > 0 ? View.MeasureSpec.makeMeasureSpec(i19, 1073741824) : View.MeasureSpec.makeMeasureSpec(0, 0));
            view.forceLayout();
            if (i16 > 0) {
                i15 += dividerHeight;
            }
            i15 += view.getMeasuredHeight();
            if (i15 >= i13) {
                return (i14 < 0 || i16 <= i14 || i18 <= 0 || i15 == i13) ? i13 : i18;
            }
            if (i14 >= 0 && i16 >= i14) {
                i18 = i15;
            }
            i16++;
        }
        return i15;
    }

    @Override // android.widget.ListView, android.widget.AbsListView, android.view.ViewGroup, android.view.View
    protected void dispatchDraw(Canvas canvas) {
        c(canvas);
        super.dispatchDraw(canvas);
    }

    @Override // android.widget.AbsListView, android.view.ViewGroup, android.view.View
    protected void drawableStateChanged() {
        if (this.f1648s != null) {
            return;
        }
        super.drawableStateChanged();
        j(true);
        n();
    }

    /* JADX WARN: Code restructure failed: missing block: B:7:0x000c, code lost:
        if (r0 != 3) goto L7;
     */
    /* JADX WARN: Removed duplicated region for block: B:22:0x0048 A[ADDED_TO_REGION] */
    /* JADX WARN: Removed duplicated region for block: B:25:0x004f  */
    /* JADX WARN: Removed duplicated region for block: B:29:0x0065  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public boolean e(MotionEvent motionEvent, int i10) {
        boolean z9;
        boolean z10;
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 1) {
            z9 = false;
        } else if (actionMasked == 2) {
            z9 = true;
        }
        int findPointerIndex = motionEvent.findPointerIndex(i10);
        if (findPointerIndex >= 0) {
            int x9 = (int) motionEvent.getX(findPointerIndex);
            int y9 = (int) motionEvent.getY(findPointerIndex);
            int pointToPosition = pointToPosition(x9, y9);
            if (pointToPosition != -1) {
                View childAt = getChildAt(pointToPosition - getFirstVisiblePosition());
                i(childAt, pointToPosition, x9, y9);
                if (actionMasked == 1) {
                    b(childAt, pointToPosition);
                }
                z10 = false;
                z9 = true;
                if (z9) {
                }
                a();
                if (z9) {
                }
                return z9;
            }
            z10 = true;
            if (z9 || z10) {
                a();
            }
            if (z9) {
                if (this.f1647r == null) {
                    this.f1647r = new androidx.core.widget.i(this);
                }
                this.f1647r.m(true);
                this.f1647r.onTouch(this, motionEvent);
            } else {
                androidx.core.widget.i iVar = this.f1647r;
                if (iVar != null) {
                    iVar.m(false);
                }
            }
            return z9;
        }
        z10 = false;
        z9 = false;
        if (z9) {
        }
        a();
        if (z9) {
        }
        return z9;
    }

    @Override // android.view.ViewGroup, android.view.View
    public boolean hasFocus() {
        return this.f1644o || super.hasFocus();
    }

    @Override // android.view.View
    public boolean hasWindowFocus() {
        return this.f1644o || super.hasWindowFocus();
    }

    @Override // android.view.View
    public boolean isFocused() {
        return this.f1644o || super.isFocused();
    }

    @Override // android.view.View
    public boolean isInTouchMode() {
        return (this.f1644o && this.f1643n) || super.isInTouchMode();
    }

    @Override // android.widget.ListView, android.widget.AbsListView, android.widget.AdapterView, android.view.ViewGroup, android.view.View
    protected void onDetachedFromWindow() {
        this.f1648s = null;
        super.onDetachedFromWindow();
    }

    @Override // android.view.View
    public boolean onHoverEvent(MotionEvent motionEvent) {
        int i10 = Build.VERSION.SDK_INT;
        if (i10 < 26) {
            return super.onHoverEvent(motionEvent);
        }
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 10 && this.f1648s == null) {
            f fVar = new f();
            this.f1648s = fVar;
            fVar.b();
        }
        boolean onHoverEvent = super.onHoverEvent(motionEvent);
        if (actionMasked == 9 || actionMasked == 7) {
            int pointToPosition = pointToPosition((int) motionEvent.getX(), (int) motionEvent.getY());
            if (pointToPosition != -1 && pointToPosition != getSelectedItemPosition()) {
                View childAt = getChildAt(pointToPosition - getFirstVisiblePosition());
                if (childAt.isEnabled()) {
                    requestFocus();
                    if (i10 < 30 || !b.a()) {
                        setSelectionFromTop(pointToPosition, childAt.getTop() - getTop());
                    } else {
                        b.b(this, pointToPosition, childAt);
                    }
                }
                n();
            }
        } else {
            setSelection(-1);
        }
        return onHoverEvent;
    }

    @Override // android.widget.AbsListView, android.view.View
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getAction() == 0) {
            this.f1641l = pointToPosition((int) motionEvent.getX(), (int) motionEvent.getY());
        }
        f fVar = this.f1648s;
        if (fVar != null) {
            fVar.a();
        }
        return super.onTouchEvent(motionEvent);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void setListSelectionHidden(boolean z9) {
        this.f1643n = z9;
    }

    @Override // android.widget.AbsListView
    public void setSelector(Drawable drawable) {
        d dVar = drawable != null ? new d(drawable) : null;
        this.f1642m = dVar;
        super.setSelector(dVar);
        Rect rect = new Rect();
        if (drawable != null) {
            drawable.getPadding(rect);
        }
        this.f1637h = rect.left;
        this.f1638i = rect.top;
        this.f1639j = rect.right;
        this.f1640k = rect.bottom;
    }
}
