package androidx.appcompat.widget;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Shader;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.ProgressBar;
/* loaded from: classes.dex */
class m0 {

    /* renamed from: c  reason: collision with root package name */
    private static final int[] f1623c = {16843067, 16843068};

    /* renamed from: a  reason: collision with root package name */
    private final ProgressBar f1624a;

    /* renamed from: b  reason: collision with root package name */
    private Bitmap f1625b;

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class a {
        public static void a(LayerDrawable layerDrawable, LayerDrawable layerDrawable2, int i10) {
            int layerGravity;
            int layerWidth;
            int layerHeight;
            int layerInsetLeft;
            int layerInsetRight;
            int layerInsetTop;
            int layerInsetBottom;
            int layerInsetStart;
            int layerInsetEnd;
            layerGravity = layerDrawable.getLayerGravity(i10);
            layerDrawable2.setLayerGravity(i10, layerGravity);
            layerWidth = layerDrawable.getLayerWidth(i10);
            layerDrawable2.setLayerWidth(i10, layerWidth);
            layerHeight = layerDrawable.getLayerHeight(i10);
            layerDrawable2.setLayerHeight(i10, layerHeight);
            layerInsetLeft = layerDrawable.getLayerInsetLeft(i10);
            layerDrawable2.setLayerInsetLeft(i10, layerInsetLeft);
            layerInsetRight = layerDrawable.getLayerInsetRight(i10);
            layerDrawable2.setLayerInsetRight(i10, layerInsetRight);
            layerInsetTop = layerDrawable.getLayerInsetTop(i10);
            layerDrawable2.setLayerInsetTop(i10, layerInsetTop);
            layerInsetBottom = layerDrawable.getLayerInsetBottom(i10);
            layerDrawable2.setLayerInsetBottom(i10, layerInsetBottom);
            layerInsetStart = layerDrawable.getLayerInsetStart(i10);
            layerDrawable2.setLayerInsetStart(i10, layerInsetStart);
            layerInsetEnd = layerDrawable.getLayerInsetEnd(i10);
            layerDrawable2.setLayerInsetEnd(i10, layerInsetEnd);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public m0(ProgressBar progressBar) {
        this.f1624a = progressBar;
    }

    private Shape a() {
        return new RoundRectShape(new float[]{5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f}, null, null);
    }

    private Drawable e(Drawable drawable) {
        if (drawable instanceof AnimationDrawable) {
            AnimationDrawable animationDrawable = (AnimationDrawable) drawable;
            int numberOfFrames = animationDrawable.getNumberOfFrames();
            AnimationDrawable animationDrawable2 = new AnimationDrawable();
            animationDrawable2.setOneShot(animationDrawable.isOneShot());
            for (int i10 = 0; i10 < numberOfFrames; i10++) {
                Drawable d10 = d(animationDrawable.getFrame(i10), true);
                d10.setLevel(10000);
                animationDrawable2.addFrame(d10, animationDrawable.getDuration(i10));
            }
            animationDrawable2.setLevel(10000);
            return animationDrawable2;
        }
        return drawable;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public Bitmap b() {
        return this.f1625b;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public void c(AttributeSet attributeSet, int i10) {
        k2 v9 = k2.v(this.f1624a.getContext(), attributeSet, f1623c, i10, 0);
        Drawable h10 = v9.h(0);
        if (h10 != null) {
            this.f1624a.setIndeterminateDrawable(e(h10));
        }
        Drawable h11 = v9.h(1);
        if (h11 != null) {
            this.f1624a.setProgressDrawable(d(h11, false));
        }
        v9.w();
    }

    Drawable d(Drawable drawable, boolean z9) {
        if (drawable instanceof androidx.core.graphics.drawable.k) {
            androidx.core.graphics.drawable.k kVar = (androidx.core.graphics.drawable.k) drawable;
            Drawable b10 = kVar.b();
            if (b10 != null) {
                kVar.a(d(b10, z9));
            }
        } else if (drawable instanceof LayerDrawable) {
            LayerDrawable layerDrawable = (LayerDrawable) drawable;
            int numberOfLayers = layerDrawable.getNumberOfLayers();
            Drawable[] drawableArr = new Drawable[numberOfLayers];
            for (int i10 = 0; i10 < numberOfLayers; i10++) {
                int id = layerDrawable.getId(i10);
                drawableArr[i10] = d(layerDrawable.getDrawable(i10), id == 16908301 || id == 16908303);
            }
            LayerDrawable layerDrawable2 = new LayerDrawable(drawableArr);
            for (int i11 = 0; i11 < numberOfLayers; i11++) {
                layerDrawable2.setId(i11, layerDrawable.getId(i11));
                if (Build.VERSION.SDK_INT >= 23) {
                    a.a(layerDrawable, layerDrawable2, i11);
                }
            }
            return layerDrawable2;
        } else if (drawable instanceof BitmapDrawable) {
            BitmapDrawable bitmapDrawable = (BitmapDrawable) drawable;
            Bitmap bitmap = bitmapDrawable.getBitmap();
            if (this.f1625b == null) {
                this.f1625b = bitmap;
            }
            ShapeDrawable shapeDrawable = new ShapeDrawable(a());
            shapeDrawable.getPaint().setShader(new BitmapShader(bitmap, Shader.TileMode.REPEAT, Shader.TileMode.CLAMP));
            shapeDrawable.getPaint().setColorFilter(bitmapDrawable.getPaint().getColorFilter());
            return z9 ? new ClipDrawable(shapeDrawable, 3, 1) : shapeDrawable;
        }
        return drawable;
    }
}
