package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Editable;
import android.text.method.KeyListener;
import android.util.AttributeSet;
import android.view.ActionMode;
import android.view.DragEvent;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.textclassifier.TextClassifier;
import android.widget.EditText;
/* loaded from: classes.dex */
public class l extends EditText implements androidx.core.view.l0, androidx.core.widget.b0 {

    /* renamed from: g  reason: collision with root package name */
    private final e f1613g;

    /* renamed from: h  reason: collision with root package name */
    private final w0 f1614h;

    /* renamed from: i  reason: collision with root package name */
    private final v0 f1615i;

    /* renamed from: j  reason: collision with root package name */
    private final androidx.core.widget.a0 f1616j;

    /* renamed from: k  reason: collision with root package name */
    private final m f1617k;

    /* renamed from: l  reason: collision with root package name */
    private a f1618l;

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class a {
        a() {
        }

        public TextClassifier a() {
            return l.super.getTextClassifier();
        }

        public void b(TextClassifier textClassifier) {
            l.super.setTextClassifier(textClassifier);
        }
    }

    public l(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, g.a.f7770y);
    }

    public l(Context context, AttributeSet attributeSet, int i10) {
        super(h2.b(context), attributeSet, i10);
        g2.a(this, getContext());
        e eVar = new e(this);
        this.f1613g = eVar;
        eVar.e(attributeSet, i10);
        w0 w0Var = new w0(this);
        this.f1614h = w0Var;
        w0Var.m(attributeSet, i10);
        w0Var.b();
        this.f1615i = new v0(this);
        this.f1616j = new androidx.core.widget.a0();
        m mVar = new m(this);
        this.f1617k = mVar;
        mVar.c(attributeSet, i10);
        d(mVar);
    }

    private a getSuperCaller() {
        if (this.f1618l == null) {
            this.f1618l = new a();
        }
        return this.f1618l;
    }

    @Override // androidx.core.view.l0
    public androidx.core.view.c a(androidx.core.view.c cVar) {
        return this.f1616j.a(this, cVar);
    }

    void d(m mVar) {
        KeyListener keyListener = getKeyListener();
        if (mVar.b(keyListener)) {
            boolean isFocusable = super.isFocusable();
            boolean isClickable = super.isClickable();
            boolean isLongClickable = super.isLongClickable();
            int inputType = super.getInputType();
            KeyListener a10 = mVar.a(keyListener);
            if (a10 == keyListener) {
                return;
            }
            super.setKeyListener(a10);
            super.setRawInputType(inputType);
            super.setFocusable(isFocusable);
            super.setClickable(isClickable);
            super.setLongClickable(isLongClickable);
        }
    }

    @Override // android.widget.TextView, android.view.View
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        e eVar = this.f1613g;
        if (eVar != null) {
            eVar.b();
        }
        w0 w0Var = this.f1614h;
        if (w0Var != null) {
            w0Var.b();
        }
    }

    @Override // android.widget.TextView
    public ActionMode.Callback getCustomSelectionActionModeCallback() {
        return androidx.core.widget.v.p(super.getCustomSelectionActionModeCallback());
    }

    public ColorStateList getSupportBackgroundTintList() {
        e eVar = this.f1613g;
        if (eVar != null) {
            return eVar.c();
        }
        return null;
    }

    public PorterDuff.Mode getSupportBackgroundTintMode() {
        e eVar = this.f1613g;
        if (eVar != null) {
            return eVar.d();
        }
        return null;
    }

    public ColorStateList getSupportCompoundDrawablesTintList() {
        return this.f1614h.j();
    }

    public PorterDuff.Mode getSupportCompoundDrawablesTintMode() {
        return this.f1614h.k();
    }

    @Override // android.widget.EditText, android.widget.TextView
    public Editable getText() {
        return Build.VERSION.SDK_INT >= 28 ? super.getText() : super.getEditableText();
    }

    @Override // android.widget.TextView
    public TextClassifier getTextClassifier() {
        v0 v0Var;
        return (Build.VERSION.SDK_INT >= 28 || (v0Var = this.f1615i) == null) ? getSuperCaller().a() : v0Var.a();
    }

    @Override // android.widget.TextView, android.view.View
    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        String[] E;
        InputConnection onCreateInputConnection = super.onCreateInputConnection(editorInfo);
        this.f1614h.r(this, onCreateInputConnection, editorInfo);
        InputConnection a10 = o.a(onCreateInputConnection, editorInfo, this);
        if (a10 != null && Build.VERSION.SDK_INT <= 30 && (E = androidx.core.view.r0.E(this)) != null) {
            z.b.d(editorInfo, E);
            a10 = z.d.c(this, a10, editorInfo);
        }
        return this.f1617k.d(a10, editorInfo);
    }

    @Override // android.widget.TextView, android.view.View
    public boolean onDragEvent(DragEvent dragEvent) {
        if (q0.a(this, dragEvent)) {
            return true;
        }
        return super.onDragEvent(dragEvent);
    }

    @Override // android.widget.TextView
    public boolean onTextContextMenuItem(int i10) {
        if (q0.b(this, i10)) {
            return true;
        }
        return super.onTextContextMenuItem(i10);
    }

    @Override // android.view.View
    public void setBackgroundDrawable(Drawable drawable) {
        super.setBackgroundDrawable(drawable);
        e eVar = this.f1613g;
        if (eVar != null) {
            eVar.f(drawable);
        }
    }

    @Override // android.view.View
    public void setBackgroundResource(int i10) {
        super.setBackgroundResource(i10);
        e eVar = this.f1613g;
        if (eVar != null) {
            eVar.g(i10);
        }
    }

    @Override // android.widget.TextView
    public void setCompoundDrawables(Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        super.setCompoundDrawables(drawable, drawable2, drawable3, drawable4);
        w0 w0Var = this.f1614h;
        if (w0Var != null) {
            w0Var.p();
        }
    }

    @Override // android.widget.TextView
    public void setCompoundDrawablesRelative(Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        super.setCompoundDrawablesRelative(drawable, drawable2, drawable3, drawable4);
        w0 w0Var = this.f1614h;
        if (w0Var != null) {
            w0Var.p();
        }
    }

    @Override // android.widget.TextView
    public void setCustomSelectionActionModeCallback(ActionMode.Callback callback) {
        super.setCustomSelectionActionModeCallback(androidx.core.widget.v.q(this, callback));
    }

    public void setEmojiCompatEnabled(boolean z9) {
        this.f1617k.e(z9);
    }

    @Override // android.widget.TextView
    public void setKeyListener(KeyListener keyListener) {
        super.setKeyListener(this.f1617k.a(keyListener));
    }

    public void setSupportBackgroundTintList(ColorStateList colorStateList) {
        e eVar = this.f1613g;
        if (eVar != null) {
            eVar.i(colorStateList);
        }
    }

    public void setSupportBackgroundTintMode(PorterDuff.Mode mode) {
        e eVar = this.f1613g;
        if (eVar != null) {
            eVar.j(mode);
        }
    }

    @Override // androidx.core.widget.b0
    public void setSupportCompoundDrawablesTintList(ColorStateList colorStateList) {
        this.f1614h.w(colorStateList);
        this.f1614h.b();
    }

    @Override // androidx.core.widget.b0
    public void setSupportCompoundDrawablesTintMode(PorterDuff.Mode mode) {
        this.f1614h.x(mode);
        this.f1614h.b();
    }

    @Override // android.widget.TextView
    public void setTextAppearance(Context context, int i10) {
        super.setTextAppearance(context, i10);
        w0 w0Var = this.f1614h;
        if (w0Var != null) {
            w0Var.q(context, i10);
        }
    }

    @Override // android.widget.TextView
    public void setTextClassifier(TextClassifier textClassifier) {
        v0 v0Var;
        if (Build.VERSION.SDK_INT >= 28 || (v0Var = this.f1615i) == null) {
            getSuperCaller().b(textClassifier);
        } else {
            v0Var.b(textClassifier);
        }
    }
}
