package androidx.appcompat.widget;

import android.app.SearchableInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.WeakHashMap;
/* loaded from: classes.dex */
class f2 extends a0.c implements View.OnClickListener {
    private int A;
    private int B;
    private int C;
    private int D;
    private int E;

    /* renamed from: r  reason: collision with root package name */
    private final SearchView f1545r;

    /* renamed from: s  reason: collision with root package name */
    private final SearchableInfo f1546s;

    /* renamed from: t  reason: collision with root package name */
    private final Context f1547t;

    /* renamed from: u  reason: collision with root package name */
    private final WeakHashMap f1548u;

    /* renamed from: v  reason: collision with root package name */
    private final int f1549v;

    /* renamed from: w  reason: collision with root package name */
    private boolean f1550w;

    /* renamed from: x  reason: collision with root package name */
    private int f1551x;

    /* renamed from: y  reason: collision with root package name */
    private ColorStateList f1552y;

    /* renamed from: z  reason: collision with root package name */
    private int f1553z;

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static final class a {

        /* renamed from: a  reason: collision with root package name */
        public final TextView f1554a;

        /* renamed from: b  reason: collision with root package name */
        public final TextView f1555b;

        /* renamed from: c  reason: collision with root package name */
        public final ImageView f1556c;

        /* renamed from: d  reason: collision with root package name */
        public final ImageView f1557d;

        /* renamed from: e  reason: collision with root package name */
        public final ImageView f1558e;

        public a(View view) {
            this.f1554a = (TextView) view.findViewById(16908308);
            this.f1555b = (TextView) view.findViewById(16908309);
            this.f1556c = (ImageView) view.findViewById(16908295);
            this.f1557d = (ImageView) view.findViewById(16908296);
            this.f1558e = (ImageView) view.findViewById(g.f.edit_query);
        }
    }

    public f2(Context context, SearchView searchView, SearchableInfo searchableInfo, WeakHashMap weakHashMap) {
        super(context, searchView.getSuggestionRowLayout(), null, true);
        this.f1550w = false;
        this.f1551x = 1;
        this.f1553z = -1;
        this.A = -1;
        this.B = -1;
        this.C = -1;
        this.D = -1;
        this.E = -1;
        this.f1545r = searchView;
        this.f1546s = searchableInfo;
        this.f1549v = searchView.getSuggestionCommitIconResId();
        this.f1547t = context;
        this.f1548u = weakHashMap;
    }

    private void A(Cursor cursor) {
        Bundle extras = cursor != null ? cursor.getExtras() : null;
        if (extras != null) {
            extras.getBoolean("in_progress");
        }
    }

    private Drawable j(String str) {
        Drawable.ConstantState constantState = (Drawable.ConstantState) this.f1548u.get(str);
        if (constantState == null) {
            return null;
        }
        return constantState.newDrawable();
    }

    private CharSequence k(CharSequence charSequence) {
        if (this.f1552y == null) {
            TypedValue typedValue = new TypedValue();
            this.f1547t.getTheme().resolveAttribute(g.a.textColorSearchUrl, typedValue, true);
            this.f1552y = this.f1547t.getResources().getColorStateList(typedValue.resourceId);
        }
        SpannableString spannableString = new SpannableString(charSequence);
        spannableString.setSpan(new TextAppearanceSpan(null, 0, 0, this.f1552y, null), 0, charSequence.length(), 33);
        return spannableString;
    }

    private Drawable l(ComponentName componentName) {
        String obj;
        ActivityInfo activityInfo;
        int iconResource;
        PackageManager packageManager = this.f1547t.getPackageManager();
        try {
            activityInfo = packageManager.getActivityInfo(componentName, 128);
            iconResource = activityInfo.getIconResource();
        } catch (PackageManager.NameNotFoundException e10) {
            obj = e10.toString();
        }
        if (iconResource == 0) {
            return null;
        }
        Drawable drawable = packageManager.getDrawable(componentName.getPackageName(), iconResource, activityInfo.applicationInfo);
        if (drawable == null) {
            obj = "Invalid icon resource " + iconResource + " for " + componentName.flattenToShortString();
            Log.w("SuggestionsAdapter", obj);
            return null;
        }
        return drawable;
    }

    private Drawable m(ComponentName componentName) {
        String flattenToShortString = componentName.flattenToShortString();
        if (!this.f1548u.containsKey(flattenToShortString)) {
            Drawable l10 = l(componentName);
            this.f1548u.put(flattenToShortString, l10 != null ? l10.getConstantState() : null);
            return l10;
        }
        Drawable.ConstantState constantState = (Drawable.ConstantState) this.f1548u.get(flattenToShortString);
        if (constantState == null) {
            return null;
        }
        return constantState.newDrawable(this.f1547t.getResources());
    }

    public static String n(Cursor cursor, String str) {
        return v(cursor, cursor.getColumnIndex(str));
    }

    private Drawable o() {
        Drawable m10 = m(this.f1546s.getSearchActivity());
        return m10 != null ? m10 : this.f1547t.getPackageManager().getDefaultActivityIcon();
    }

    private Drawable p(Uri uri) {
        try {
            if ("android.resource".equals(uri.getScheme())) {
                try {
                    return q(uri);
                } catch (Resources.NotFoundException unused) {
                    throw new FileNotFoundException("Resource does not exist: " + uri);
                }
            }
            InputStream openInputStream = this.f1547t.getContentResolver().openInputStream(uri);
            if (openInputStream == null) {
                throw new FileNotFoundException("Failed to open " + uri);
            }
            Drawable createFromStream = Drawable.createFromStream(openInputStream, null);
            try {
                openInputStream.close();
            } catch (IOException e10) {
                Log.e("SuggestionsAdapter", "Error closing icon stream for " + uri, e10);
            }
            return createFromStream;
        } catch (FileNotFoundException e11) {
            Log.w("SuggestionsAdapter", "Icon not found: " + uri + ", " + e11.getMessage());
            return null;
        }
        Log.w("SuggestionsAdapter", "Icon not found: " + uri + ", " + e11.getMessage());
        return null;
    }

    private Drawable r(String str) {
        if (str == null || str.isEmpty() || "0".equals(str)) {
            return null;
        }
        try {
            int parseInt = Integer.parseInt(str);
            String str2 = "android.resource://" + this.f1547t.getPackageName() + "/" + parseInt;
            Drawable j10 = j(str2);
            if (j10 != null) {
                return j10;
            }
            Drawable d10 = androidx.core.content.a.d(this.f1547t, parseInt);
            z(str2, d10);
            return d10;
        } catch (Resources.NotFoundException unused) {
            Log.w("SuggestionsAdapter", "Icon resource not found: " + str);
            return null;
        } catch (NumberFormatException unused2) {
            Drawable j11 = j(str);
            if (j11 != null) {
                return j11;
            }
            Drawable p10 = p(Uri.parse(str));
            z(str, p10);
            return p10;
        }
    }

    private Drawable s(Cursor cursor) {
        int i10 = this.C;
        if (i10 == -1) {
            return null;
        }
        Drawable r10 = r(cursor.getString(i10));
        return r10 != null ? r10 : o();
    }

    private Drawable t(Cursor cursor) {
        int i10 = this.D;
        if (i10 == -1) {
            return null;
        }
        return r(cursor.getString(i10));
    }

    private static String v(Cursor cursor, int i10) {
        if (i10 == -1) {
            return null;
        }
        try {
            return cursor.getString(i10);
        } catch (Exception e10) {
            Log.e("SuggestionsAdapter", "unexpected error retrieving valid column from cursor, did the remote process die?", e10);
            return null;
        }
    }

    private void x(ImageView imageView, Drawable drawable, int i10) {
        imageView.setImageDrawable(drawable);
        if (drawable == null) {
            imageView.setVisibility(i10);
            return;
        }
        imageView.setVisibility(0);
        drawable.setVisible(false, false);
        drawable.setVisible(true, false);
    }

    private void y(TextView textView, CharSequence charSequence) {
        textView.setText(charSequence);
        textView.setVisibility(TextUtils.isEmpty(charSequence) ? 8 : 0);
    }

    private void z(String str, Drawable drawable) {
        if (drawable != null) {
            this.f1548u.put(str, drawable.getConstantState());
        }
    }

    @Override // a0.a, a0.b.a
    public void a(Cursor cursor) {
        if (this.f1550w) {
            Log.w("SuggestionsAdapter", "Tried to change cursor after adapter was closed.");
            if (cursor != null) {
                cursor.close();
                return;
            }
            return;
        }
        try {
            super.a(cursor);
            if (cursor != null) {
                this.f1553z = cursor.getColumnIndex("suggest_text_1");
                this.A = cursor.getColumnIndex("suggest_text_2");
                this.B = cursor.getColumnIndex("suggest_text_2_url");
                this.C = cursor.getColumnIndex("suggest_icon_1");
                this.D = cursor.getColumnIndex("suggest_icon_2");
                this.E = cursor.getColumnIndex("suggest_flags");
            }
        } catch (Exception e10) {
            Log.e("SuggestionsAdapter", "error changing cursor and caching columns", e10);
        }
    }

    @Override // a0.b.a
    public Cursor c(CharSequence charSequence) {
        String charSequence2 = charSequence == null ? "" : charSequence.toString();
        if (this.f1545r.getVisibility() == 0 && this.f1545r.getWindowVisibility() == 0) {
            try {
                Cursor u9 = u(this.f1546s, charSequence2, 50);
                if (u9 != null) {
                    u9.getCount();
                    return u9;
                }
            } catch (RuntimeException e10) {
                Log.w("SuggestionsAdapter", "Search suggestions query threw an exception.", e10);
            }
        }
        return null;
    }

    @Override // a0.a, a0.b.a
    public CharSequence convertToString(Cursor cursor) {
        String n10;
        String n11;
        if (cursor == null) {
            return null;
        }
        String n12 = n(cursor, "suggest_intent_query");
        if (n12 != null) {
            return n12;
        }
        if (!this.f1546s.shouldRewriteQueryFromData() || (n11 = n(cursor, "suggest_intent_data")) == null) {
            if (!this.f1546s.shouldRewriteQueryFromText() || (n10 = n(cursor, "suggest_text_1")) == null) {
                return null;
            }
            return n10;
        }
        return n11;
    }

    @Override // a0.a
    public void d(View view, Context context, Cursor cursor) {
        a aVar = (a) view.getTag();
        int i10 = this.E;
        int i11 = i10 != -1 ? cursor.getInt(i10) : 0;
        if (aVar.f1554a != null) {
            y(aVar.f1554a, v(cursor, this.f1553z));
        }
        if (aVar.f1555b != null) {
            String v9 = v(cursor, this.B);
            CharSequence k10 = v9 != null ? k(v9) : v(cursor, this.A);
            if (TextUtils.isEmpty(k10)) {
                TextView textView = aVar.f1554a;
                if (textView != null) {
                    textView.setSingleLine(false);
                    aVar.f1554a.setMaxLines(2);
                }
            } else {
                TextView textView2 = aVar.f1554a;
                if (textView2 != null) {
                    textView2.setSingleLine(true);
                    aVar.f1554a.setMaxLines(1);
                }
            }
            y(aVar.f1555b, k10);
        }
        ImageView imageView = aVar.f1556c;
        if (imageView != null) {
            x(imageView, s(cursor), 4);
        }
        ImageView imageView2 = aVar.f1557d;
        if (imageView2 != null) {
            x(imageView2, t(cursor), 8);
        }
        int i12 = this.f1551x;
        if (i12 != 2 && (i12 != 1 || (i11 & 1) == 0)) {
            aVar.f1558e.setVisibility(8);
            return;
        }
        aVar.f1558e.setVisibility(0);
        aVar.f1558e.setTag(aVar.f1554a.getText());
        aVar.f1558e.setOnClickListener(this);
    }

    @Override // a0.c, a0.a
    public View g(Context context, Cursor cursor, ViewGroup viewGroup) {
        View g10 = super.g(context, cursor, viewGroup);
        g10.setTag(new a(g10));
        ((ImageView) g10.findViewById(g.f.edit_query)).setImageResource(this.f1549v);
        return g10;
    }

    @Override // a0.a, android.widget.BaseAdapter, android.widget.SpinnerAdapter
    public View getDropDownView(int i10, View view, ViewGroup viewGroup) {
        try {
            return super.getDropDownView(i10, view, viewGroup);
        } catch (RuntimeException e10) {
            Log.w("SuggestionsAdapter", "Search suggestions cursor threw exception.", e10);
            View f10 = f(this.f1547t, b(), viewGroup);
            if (f10 != null) {
                ((a) f10.getTag()).f1554a.setText(e10.toString());
            }
            return f10;
        }
    }

    @Override // a0.a, android.widget.Adapter
    public View getView(int i10, View view, ViewGroup viewGroup) {
        try {
            return super.getView(i10, view, viewGroup);
        } catch (RuntimeException e10) {
            Log.w("SuggestionsAdapter", "Search suggestions cursor threw exception.", e10);
            View g10 = g(this.f1547t, b(), viewGroup);
            if (g10 != null) {
                ((a) g10.getTag()).f1554a.setText(e10.toString());
            }
            return g10;
        }
    }

    @Override // android.widget.BaseAdapter, android.widget.Adapter
    public boolean hasStableIds() {
        return false;
    }

    @Override // android.widget.BaseAdapter
    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        A(b());
    }

    @Override // android.widget.BaseAdapter
    public void notifyDataSetInvalidated() {
        super.notifyDataSetInvalidated();
        A(b());
    }

    @Override // android.view.View.OnClickListener
    public void onClick(View view) {
        Object tag = view.getTag();
        if (tag instanceof CharSequence) {
            this.f1545r.S((CharSequence) tag);
        }
    }

    Drawable q(Uri uri) {
        int parseInt;
        String authority = uri.getAuthority();
        if (TextUtils.isEmpty(authority)) {
            throw new FileNotFoundException("No authority: " + uri);
        }
        try {
            Resources resourcesForApplication = this.f1547t.getPackageManager().getResourcesForApplication(authority);
            List<String> pathSegments = uri.getPathSegments();
            if (pathSegments == null) {
                throw new FileNotFoundException("No path: " + uri);
            }
            int size = pathSegments.size();
            if (size == 1) {
                try {
                    parseInt = Integer.parseInt(pathSegments.get(0));
                } catch (NumberFormatException unused) {
                    throw new FileNotFoundException("Single path segment is not a resource ID: " + uri);
                }
            } else if (size != 2) {
                throw new FileNotFoundException("More than two path segments: " + uri);
            } else {
                parseInt = resourcesForApplication.getIdentifier(pathSegments.get(1), pathSegments.get(0), authority);
            }
            if (parseInt != 0) {
                return resourcesForApplication.getDrawable(parseInt);
            }
            throw new FileNotFoundException("No resource found for: " + uri);
        } catch (PackageManager.NameNotFoundException unused2) {
            throw new FileNotFoundException("No package found for authority: " + uri);
        }
    }

    Cursor u(SearchableInfo searchableInfo, String str, int i10) {
        String suggestAuthority;
        String[] strArr = null;
        if (searchableInfo == null || (suggestAuthority = searchableInfo.getSuggestAuthority()) == null) {
            return null;
        }
        Uri.Builder fragment = new Uri.Builder().scheme("content").authority(suggestAuthority).query("").fragment("");
        String suggestPath = searchableInfo.getSuggestPath();
        if (suggestPath != null) {
            fragment.appendEncodedPath(suggestPath);
        }
        fragment.appendPath("search_suggest_query");
        String suggestSelection = searchableInfo.getSuggestSelection();
        if (suggestSelection != null) {
            strArr = new String[]{str};
        } else {
            fragment.appendPath(str);
        }
        String[] strArr2 = strArr;
        if (i10 > 0) {
            fragment.appendQueryParameter("limit", String.valueOf(i10));
        }
        return this.f1547t.getContentResolver().query(fragment.build(), null, suggestSelection, strArr2, null);
    }

    public void w(int i10) {
        this.f1551x = i10;
    }
}
