package androidx.appcompat.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.InputFilter;
import android.util.AttributeSet;
import android.view.ActionMode;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.textclassifier.TextClassifier;
import android.widget.TextView;
import androidx.core.text.e;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
/* loaded from: classes.dex */
public class d1 extends TextView implements androidx.core.widget.b0 {

    /* renamed from: g  reason: collision with root package name */
    private final e f1513g;

    /* renamed from: h  reason: collision with root package name */
    private final w0 f1514h;

    /* renamed from: i  reason: collision with root package name */
    private final v0 f1515i;

    /* renamed from: j  reason: collision with root package name */
    private n f1516j;

    /* renamed from: k  reason: collision with root package name */
    private boolean f1517k;

    /* renamed from: l  reason: collision with root package name */
    private a f1518l;

    /* renamed from: m  reason: collision with root package name */
    private Future f1519m;

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public interface a {
        void a(int[] iArr, int i10);

        int[] b();

        TextClassifier c();

        int d();

        void e(TextClassifier textClassifier);

        void f(int i10);

        void g(int i10, int i11, int i12, int i13);

        int h();

        int i();

        void j(int i10);

        int k();

        void l(int i10);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class b implements a {
        b() {
        }

        @Override // androidx.appcompat.widget.d1.a
        public void a(int[] iArr, int i10) {
            d1.super.setAutoSizeTextTypeUniformWithPresetSizes(iArr, i10);
        }

        @Override // androidx.appcompat.widget.d1.a
        public int[] b() {
            return d1.super.getAutoSizeTextAvailableSizes();
        }

        @Override // androidx.appcompat.widget.d1.a
        public TextClassifier c() {
            return d1.super.getTextClassifier();
        }

        @Override // androidx.appcompat.widget.d1.a
        public int d() {
            return d1.super.getAutoSizeMaxTextSize();
        }

        @Override // androidx.appcompat.widget.d1.a
        public void e(TextClassifier textClassifier) {
            d1.super.setTextClassifier(textClassifier);
        }

        @Override // androidx.appcompat.widget.d1.a
        public void f(int i10) {
        }

        @Override // androidx.appcompat.widget.d1.a
        public void g(int i10, int i11, int i12, int i13) {
            d1.super.setAutoSizeTextTypeUniformWithConfiguration(i10, i11, i12, i13);
        }

        @Override // androidx.appcompat.widget.d1.a
        public int h() {
            return d1.super.getAutoSizeTextType();
        }

        @Override // androidx.appcompat.widget.d1.a
        public int i() {
            return d1.super.getAutoSizeMinTextSize();
        }

        @Override // androidx.appcompat.widget.d1.a
        public void j(int i10) {
        }

        @Override // androidx.appcompat.widget.d1.a
        public int k() {
            return d1.super.getAutoSizeStepGranularity();
        }

        @Override // androidx.appcompat.widget.d1.a
        public void l(int i10) {
            d1.super.setAutoSizeTextTypeWithDefaults(i10);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class c extends b {
        c() {
            super();
        }

        @Override // androidx.appcompat.widget.d1.b, androidx.appcompat.widget.d1.a
        public void f(int i10) {
            d1.super.setLastBaselineToBottomHeight(i10);
        }

        @Override // androidx.appcompat.widget.d1.b, androidx.appcompat.widget.d1.a
        public void j(int i10) {
            d1.super.setFirstBaselineToTopHeight(i10);
        }
    }

    public d1(Context context) {
        this(context, null);
    }

    public d1(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842884);
    }

    public d1(Context context, AttributeSet attributeSet, int i10) {
        super(h2.b(context), attributeSet, i10);
        this.f1517k = false;
        this.f1518l = null;
        g2.a(this, getContext());
        e eVar = new e(this);
        this.f1513g = eVar;
        eVar.e(attributeSet, i10);
        w0 w0Var = new w0(this);
        this.f1514h = w0Var;
        w0Var.m(attributeSet, i10);
        w0Var.b();
        this.f1515i = new v0(this);
        getEmojiTextViewHelper().b(attributeSet, i10);
    }

    private n getEmojiTextViewHelper() {
        if (this.f1516j == null) {
            this.f1516j = new n(this);
        }
        return this.f1516j;
    }

    private void q() {
        Future future = this.f1519m;
        if (future != null) {
            try {
                this.f1519m = null;
                android.support.v4.media.session.b.a(future.get());
                androidx.core.widget.v.m(this, null);
            } catch (InterruptedException | ExecutionException unused) {
            }
        }
    }

    @Override // android.widget.TextView, android.view.View
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        e eVar = this.f1513g;
        if (eVar != null) {
            eVar.b();
        }
        w0 w0Var = this.f1514h;
        if (w0Var != null) {
            w0Var.b();
        }
    }

    @Override // android.widget.TextView
    public int getAutoSizeMaxTextSize() {
        if (w2.f1828b) {
            return getSuperCaller().d();
        }
        w0 w0Var = this.f1514h;
        if (w0Var != null) {
            return w0Var.e();
        }
        return -1;
    }

    @Override // android.widget.TextView
    public int getAutoSizeMinTextSize() {
        if (w2.f1828b) {
            return getSuperCaller().i();
        }
        w0 w0Var = this.f1514h;
        if (w0Var != null) {
            return w0Var.f();
        }
        return -1;
    }

    @Override // android.widget.TextView
    public int getAutoSizeStepGranularity() {
        if (w2.f1828b) {
            return getSuperCaller().k();
        }
        w0 w0Var = this.f1514h;
        if (w0Var != null) {
            return w0Var.g();
        }
        return -1;
    }

    @Override // android.widget.TextView
    public int[] getAutoSizeTextAvailableSizes() {
        if (w2.f1828b) {
            return getSuperCaller().b();
        }
        w0 w0Var = this.f1514h;
        return w0Var != null ? w0Var.h() : new int[0];
    }

    @Override // android.widget.TextView
    @SuppressLint({"WrongConstant"})
    public int getAutoSizeTextType() {
        if (w2.f1828b) {
            return getSuperCaller().h() == 1 ? 1 : 0;
        }
        w0 w0Var = this.f1514h;
        if (w0Var != null) {
            return w0Var.i();
        }
        return 0;
    }

    @Override // android.widget.TextView
    public ActionMode.Callback getCustomSelectionActionModeCallback() {
        return androidx.core.widget.v.p(super.getCustomSelectionActionModeCallback());
    }

    @Override // android.widget.TextView
    public int getFirstBaselineToTopHeight() {
        return androidx.core.widget.v.b(this);
    }

    @Override // android.widget.TextView
    public int getLastBaselineToBottomHeight() {
        return androidx.core.widget.v.c(this);
    }

    a getSuperCaller() {
        a bVar;
        if (this.f1518l == null) {
            int i10 = Build.VERSION.SDK_INT;
            if (i10 >= 28) {
                bVar = new c();
            } else if (i10 >= 26) {
                bVar = new b();
            }
            this.f1518l = bVar;
        }
        return this.f1518l;
    }

    public ColorStateList getSupportBackgroundTintList() {
        e eVar = this.f1513g;
        if (eVar != null) {
            return eVar.c();
        }
        return null;
    }

    public PorterDuff.Mode getSupportBackgroundTintMode() {
        e eVar = this.f1513g;
        if (eVar != null) {
            return eVar.d();
        }
        return null;
    }

    public ColorStateList getSupportCompoundDrawablesTintList() {
        return this.f1514h.j();
    }

    public PorterDuff.Mode getSupportCompoundDrawablesTintMode() {
        return this.f1514h.k();
    }

    @Override // android.widget.TextView
    public CharSequence getText() {
        q();
        return super.getText();
    }

    @Override // android.widget.TextView
    public TextClassifier getTextClassifier() {
        v0 v0Var;
        return (Build.VERSION.SDK_INT >= 28 || (v0Var = this.f1515i) == null) ? getSuperCaller().c() : v0Var.a();
    }

    public e.a getTextMetricsParamsCompat() {
        return androidx.core.widget.v.f(this);
    }

    @Override // android.widget.TextView, android.view.View
    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        InputConnection onCreateInputConnection = super.onCreateInputConnection(editorInfo);
        this.f1514h.r(this, onCreateInputConnection, editorInfo);
        return o.a(onCreateInputConnection, editorInfo, this);
    }

    @Override // android.widget.TextView, android.view.View
    protected void onLayout(boolean z9, int i10, int i11, int i12, int i13) {
        super.onLayout(z9, i10, i11, i12, i13);
        w0 w0Var = this.f1514h;
        if (w0Var != null) {
            w0Var.o(z9, i10, i11, i12, i13);
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // android.widget.TextView, android.view.View
    public void onMeasure(int i10, int i11) {
        q();
        super.onMeasure(i10, i11);
    }

    @Override // android.widget.TextView
    protected void onTextChanged(CharSequence charSequence, int i10, int i11, int i12) {
        super.onTextChanged(charSequence, i10, i11, i12);
        w0 w0Var = this.f1514h;
        if ((w0Var == null || w2.f1828b || !w0Var.l()) ? false : true) {
            this.f1514h.c();
        }
    }

    @Override // android.widget.TextView
    public void setAllCaps(boolean z9) {
        super.setAllCaps(z9);
        getEmojiTextViewHelper().c(z9);
    }

    @Override // android.widget.TextView
    public void setAutoSizeTextTypeUniformWithConfiguration(int i10, int i11, int i12, int i13) {
        if (w2.f1828b) {
            getSuperCaller().g(i10, i11, i12, i13);
            return;
        }
        w0 w0Var = this.f1514h;
        if (w0Var != null) {
            w0Var.t(i10, i11, i12, i13);
        }
    }

    @Override // android.widget.TextView
    public void setAutoSizeTextTypeUniformWithPresetSizes(int[] iArr, int i10) {
        if (w2.f1828b) {
            getSuperCaller().a(iArr, i10);
            return;
        }
        w0 w0Var = this.f1514h;
        if (w0Var != null) {
            w0Var.u(iArr, i10);
        }
    }

    @Override // android.widget.TextView
    public void setAutoSizeTextTypeWithDefaults(int i10) {
        if (w2.f1828b) {
            getSuperCaller().l(i10);
            return;
        }
        w0 w0Var = this.f1514h;
        if (w0Var != null) {
            w0Var.v(i10);
        }
    }

    @Override // android.view.View
    public void setBackgroundDrawable(Drawable drawable) {
        super.setBackgroundDrawable(drawable);
        e eVar = this.f1513g;
        if (eVar != null) {
            eVar.f(drawable);
        }
    }

    @Override // android.view.View
    public void setBackgroundResource(int i10) {
        super.setBackgroundResource(i10);
        e eVar = this.f1513g;
        if (eVar != null) {
            eVar.g(i10);
        }
    }

    @Override // android.widget.TextView
    public void setCompoundDrawables(Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        super.setCompoundDrawables(drawable, drawable2, drawable3, drawable4);
        w0 w0Var = this.f1514h;
        if (w0Var != null) {
            w0Var.p();
        }
    }

    @Override // android.widget.TextView
    public void setCompoundDrawablesRelative(Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        super.setCompoundDrawablesRelative(drawable, drawable2, drawable3, drawable4);
        w0 w0Var = this.f1514h;
        if (w0Var != null) {
            w0Var.p();
        }
    }

    @Override // android.widget.TextView
    public void setCompoundDrawablesRelativeWithIntrinsicBounds(int i10, int i11, int i12, int i13) {
        Context context = getContext();
        setCompoundDrawablesRelativeWithIntrinsicBounds(i10 != 0 ? h.a.b(context, i10) : null, i11 != 0 ? h.a.b(context, i11) : null, i12 != 0 ? h.a.b(context, i12) : null, i13 != 0 ? h.a.b(context, i13) : null);
        w0 w0Var = this.f1514h;
        if (w0Var != null) {
            w0Var.p();
        }
    }

    @Override // android.widget.TextView
    public void setCompoundDrawablesRelativeWithIntrinsicBounds(Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        super.setCompoundDrawablesRelativeWithIntrinsicBounds(drawable, drawable2, drawable3, drawable4);
        w0 w0Var = this.f1514h;
        if (w0Var != null) {
            w0Var.p();
        }
    }

    @Override // android.widget.TextView
    public void setCompoundDrawablesWithIntrinsicBounds(int i10, int i11, int i12, int i13) {
        Context context = getContext();
        setCompoundDrawablesWithIntrinsicBounds(i10 != 0 ? h.a.b(context, i10) : null, i11 != 0 ? h.a.b(context, i11) : null, i12 != 0 ? h.a.b(context, i12) : null, i13 != 0 ? h.a.b(context, i13) : null);
        w0 w0Var = this.f1514h;
        if (w0Var != null) {
            w0Var.p();
        }
    }

    @Override // android.widget.TextView
    public void setCompoundDrawablesWithIntrinsicBounds(Drawable drawable, Drawable drawable2, Drawable drawable3, Drawable drawable4) {
        super.setCompoundDrawablesWithIntrinsicBounds(drawable, drawable2, drawable3, drawable4);
        w0 w0Var = this.f1514h;
        if (w0Var != null) {
            w0Var.p();
        }
    }

    @Override // android.widget.TextView
    public void setCustomSelectionActionModeCallback(ActionMode.Callback callback) {
        super.setCustomSelectionActionModeCallback(androidx.core.widget.v.q(this, callback));
    }

    public void setEmojiCompatEnabled(boolean z9) {
        getEmojiTextViewHelper().d(z9);
    }

    @Override // android.widget.TextView
    public void setFilters(InputFilter[] inputFilterArr) {
        super.setFilters(getEmojiTextViewHelper().a(inputFilterArr));
    }

    @Override // android.widget.TextView
    public void setFirstBaselineToTopHeight(int i10) {
        if (Build.VERSION.SDK_INT >= 28) {
            getSuperCaller().j(i10);
        } else {
            androidx.core.widget.v.j(this, i10);
        }
    }

    @Override // android.widget.TextView
    public void setLastBaselineToBottomHeight(int i10) {
        if (Build.VERSION.SDK_INT >= 28) {
            getSuperCaller().f(i10);
        } else {
            androidx.core.widget.v.k(this, i10);
        }
    }

    @Override // android.widget.TextView
    public void setLineHeight(int i10) {
        androidx.core.widget.v.l(this, i10);
    }

    public void setPrecomputedText(androidx.core.text.e eVar) {
        androidx.core.widget.v.m(this, eVar);
    }

    public void setSupportBackgroundTintList(ColorStateList colorStateList) {
        e eVar = this.f1513g;
        if (eVar != null) {
            eVar.i(colorStateList);
        }
    }

    public void setSupportBackgroundTintMode(PorterDuff.Mode mode) {
        e eVar = this.f1513g;
        if (eVar != null) {
            eVar.j(mode);
        }
    }

    @Override // androidx.core.widget.b0
    public void setSupportCompoundDrawablesTintList(ColorStateList colorStateList) {
        this.f1514h.w(colorStateList);
        this.f1514h.b();
    }

    @Override // androidx.core.widget.b0
    public void setSupportCompoundDrawablesTintMode(PorterDuff.Mode mode) {
        this.f1514h.x(mode);
        this.f1514h.b();
    }

    @Override // android.widget.TextView
    public void setTextAppearance(Context context, int i10) {
        super.setTextAppearance(context, i10);
        w0 w0Var = this.f1514h;
        if (w0Var != null) {
            w0Var.q(context, i10);
        }
    }

    @Override // android.widget.TextView
    public void setTextClassifier(TextClassifier textClassifier) {
        v0 v0Var;
        if (Build.VERSION.SDK_INT >= 28 || (v0Var = this.f1515i) == null) {
            getSuperCaller().e(textClassifier);
        } else {
            v0Var.b(textClassifier);
        }
    }

    public void setTextFuture(Future<androidx.core.text.e> future) {
        this.f1519m = future;
        if (future != null) {
            requestLayout();
        }
    }

    public void setTextMetricsParamsCompat(e.a aVar) {
        androidx.core.widget.v.o(this, aVar);
    }

    @Override // android.widget.TextView
    public void setTextSize(int i10, float f10) {
        if (w2.f1828b) {
            super.setTextSize(i10, f10);
            return;
        }
        w0 w0Var = this.f1514h;
        if (w0Var != null) {
            w0Var.A(i10, f10);
        }
    }

    @Override // android.widget.TextView
    public void setTypeface(Typeface typeface, int i10) {
        if (this.f1517k) {
            return;
        }
        Typeface typeface2 = null;
        if (typeface != null && i10 > 0) {
            typeface2 = androidx.core.graphics.f.a(getContext(), typeface, i10);
        }
        this.f1517k = true;
        if (typeface2 != null) {
            typeface = typeface2;
        }
        try {
            super.setTypeface(typeface, i10);
        } finally {
            this.f1517k = false;
        }
    }
}
