package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.SparseBooleanArray;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.appcompat.view.menu.ActionMenuItemView;
import androidx.appcompat.view.menu.m;
import androidx.appcompat.view.menu.n;
import androidx.appcompat.widget.ActionMenuView;
import androidx.core.view.b;
import java.util.ArrayList;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public class c extends androidx.appcompat.view.menu.b implements b.a {
    private boolean A;
    private boolean B;
    private int C;
    private final SparseBooleanArray D;
    e E;
    a F;
    RunnableC0008c G;
    private b H;
    final f I;
    int J;

    /* renamed from: q  reason: collision with root package name */
    d f1482q;

    /* renamed from: r  reason: collision with root package name */
    private Drawable f1483r;

    /* renamed from: s  reason: collision with root package name */
    private boolean f1484s;

    /* renamed from: t  reason: collision with root package name */
    private boolean f1485t;

    /* renamed from: u  reason: collision with root package name */
    private boolean f1486u;

    /* renamed from: v  reason: collision with root package name */
    private int f1487v;

    /* renamed from: w  reason: collision with root package name */
    private int f1488w;

    /* renamed from: x  reason: collision with root package name */
    private int f1489x;

    /* renamed from: y  reason: collision with root package name */
    private boolean f1490y;

    /* renamed from: z  reason: collision with root package name */
    private boolean f1491z;

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class a extends androidx.appcompat.view.menu.l {
        public a(Context context, androidx.appcompat.view.menu.r rVar, View view) {
            super(context, rVar, view, false, g.a.actionOverflowMenuStyle);
            if (!((androidx.appcompat.view.menu.i) rVar.getItem()).l()) {
                View view2 = c.this.f1482q;
                f(view2 == null ? (View) ((androidx.appcompat.view.menu.b) c.this).f1140o : view2);
            }
            j(c.this.I);
        }

        @Override // androidx.appcompat.view.menu.l
        protected void e() {
            c cVar = c.this;
            cVar.F = null;
            cVar.J = 0;
            super.e();
        }
    }

    /* loaded from: classes.dex */
    private class b extends ActionMenuItemView.b {
        b() {
        }

        @Override // androidx.appcompat.view.menu.ActionMenuItemView.b
        public androidx.appcompat.view.menu.p a() {
            a aVar = c.this.F;
            if (aVar != null) {
                return aVar.c();
            }
            return null;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* renamed from: androidx.appcompat.widget.c$c  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    public class RunnableC0008c implements Runnable {

        /* renamed from: g  reason: collision with root package name */
        private e f1494g;

        public RunnableC0008c(e eVar) {
            this.f1494g = eVar;
        }

        @Override // java.lang.Runnable
        public void run() {
            if (((androidx.appcompat.view.menu.b) c.this).f1134i != null) {
                ((androidx.appcompat.view.menu.b) c.this).f1134i.d();
            }
            View view = (View) ((androidx.appcompat.view.menu.b) c.this).f1140o;
            if (view != null && view.getWindowToken() != null && this.f1494g.m()) {
                c.this.E = this.f1494g;
            }
            c.this.G = null;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class d extends r implements ActionMenuView.a {

        /* loaded from: classes.dex */
        class a extends p1 {

            /* renamed from: p  reason: collision with root package name */
            final /* synthetic */ c f1497p;

            /* JADX WARN: 'super' call moved to the top of the method (can break code semantics) */
            a(View view, c cVar) {
                super(view);
                this.f1497p = cVar;
            }

            @Override // androidx.appcompat.widget.p1
            public androidx.appcompat.view.menu.p b() {
                e eVar = c.this.E;
                if (eVar == null) {
                    return null;
                }
                return eVar.c();
            }

            @Override // androidx.appcompat.widget.p1
            public boolean c() {
                c.this.K();
                return true;
            }

            @Override // androidx.appcompat.widget.p1
            public boolean d() {
                c cVar = c.this;
                if (cVar.G != null) {
                    return false;
                }
                cVar.B();
                return true;
            }
        }

        public d(Context context) {
            super(context, null, g.a.actionOverflowButtonStyle);
            setClickable(true);
            setFocusable(true);
            setVisibility(0);
            setEnabled(true);
            q2.a(this, getContentDescription());
            setOnTouchListener(new a(this, c.this));
        }

        @Override // androidx.appcompat.widget.ActionMenuView.a
        public boolean a() {
            return false;
        }

        @Override // androidx.appcompat.widget.ActionMenuView.a
        public boolean b() {
            return false;
        }

        @Override // android.view.View
        public boolean performClick() {
            if (super.performClick()) {
                return true;
            }
            playSoundEffect(0);
            c.this.K();
            return true;
        }

        @Override // android.widget.ImageView
        protected boolean setFrame(int i10, int i11, int i12, int i13) {
            boolean frame = super.setFrame(i10, i11, i12, i13);
            Drawable drawable = getDrawable();
            Drawable background = getBackground();
            if (drawable != null && background != null) {
                int width = getWidth();
                int height = getHeight();
                int max = Math.max(width, height) / 2;
                int paddingLeft = (width + (getPaddingLeft() - getPaddingRight())) / 2;
                int paddingTop = (height + (getPaddingTop() - getPaddingBottom())) / 2;
                androidx.core.graphics.drawable.a.l(background, paddingLeft - max, paddingTop - max, paddingLeft + max, paddingTop + max);
            }
            return frame;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class e extends androidx.appcompat.view.menu.l {
        public e(Context context, androidx.appcompat.view.menu.g gVar, View view, boolean z9) {
            super(context, gVar, view, z9, g.a.actionOverflowMenuStyle);
            h(8388613);
            j(c.this.I);
        }

        @Override // androidx.appcompat.view.menu.l
        protected void e() {
            if (((androidx.appcompat.view.menu.b) c.this).f1134i != null) {
                ((androidx.appcompat.view.menu.b) c.this).f1134i.close();
            }
            c.this.E = null;
            super.e();
        }
    }

    /* loaded from: classes.dex */
    private class f implements m.a {
        f() {
        }

        @Override // androidx.appcompat.view.menu.m.a
        public void b(androidx.appcompat.view.menu.g gVar, boolean z9) {
            if (gVar instanceof androidx.appcompat.view.menu.r) {
                gVar.D().e(false);
            }
            m.a m10 = c.this.m();
            if (m10 != null) {
                m10.b(gVar, z9);
            }
        }

        @Override // androidx.appcompat.view.menu.m.a
        public boolean c(androidx.appcompat.view.menu.g gVar) {
            if (gVar == ((androidx.appcompat.view.menu.b) c.this).f1134i) {
                return false;
            }
            c.this.J = ((androidx.appcompat.view.menu.r) gVar).getItem().getItemId();
            m.a m10 = c.this.m();
            if (m10 != null) {
                return m10.c(gVar);
            }
            return false;
        }
    }

    public c(Context context) {
        super(context, g.g.abc_action_menu_layout, g.g.abc_action_menu_item_layout);
        this.D = new SparseBooleanArray();
        this.I = new f();
    }

    private View z(MenuItem menuItem) {
        ViewGroup viewGroup = (ViewGroup) this.f1140o;
        if (viewGroup == null) {
            return null;
        }
        int childCount = viewGroup.getChildCount();
        for (int i10 = 0; i10 < childCount; i10++) {
            View childAt = viewGroup.getChildAt(i10);
            if ((childAt instanceof n.a) && ((n.a) childAt).getItemData() == menuItem) {
                return childAt;
            }
        }
        return null;
    }

    public Drawable A() {
        d dVar = this.f1482q;
        if (dVar != null) {
            return dVar.getDrawable();
        }
        if (this.f1484s) {
            return this.f1483r;
        }
        return null;
    }

    public boolean B() {
        androidx.appcompat.view.menu.n nVar;
        RunnableC0008c runnableC0008c = this.G;
        if (runnableC0008c != null && (nVar = this.f1140o) != null) {
            ((View) nVar).removeCallbacks(runnableC0008c);
            this.G = null;
            return true;
        }
        e eVar = this.E;
        if (eVar != null) {
            eVar.b();
            return true;
        }
        return false;
    }

    public boolean C() {
        a aVar = this.F;
        if (aVar != null) {
            aVar.b();
            return true;
        }
        return false;
    }

    public boolean D() {
        return this.G != null || E();
    }

    public boolean E() {
        e eVar = this.E;
        return eVar != null && eVar.d();
    }

    public void F(Configuration configuration) {
        if (!this.f1490y) {
            this.f1489x = androidx.appcompat.view.a.b(this.f1133h).d();
        }
        androidx.appcompat.view.menu.g gVar = this.f1134i;
        if (gVar != null) {
            gVar.K(true);
        }
    }

    public void G(boolean z9) {
        this.B = z9;
    }

    public void H(ActionMenuView actionMenuView) {
        this.f1140o = actionMenuView;
        actionMenuView.b(this.f1134i);
    }

    public void I(Drawable drawable) {
        d dVar = this.f1482q;
        if (dVar != null) {
            dVar.setImageDrawable(drawable);
            return;
        }
        this.f1484s = true;
        this.f1483r = drawable;
    }

    public void J(boolean z9) {
        this.f1485t = z9;
        this.f1486u = true;
    }

    public boolean K() {
        androidx.appcompat.view.menu.g gVar;
        if (!this.f1485t || E() || (gVar = this.f1134i) == null || this.f1140o == null || this.G != null || gVar.z().isEmpty()) {
            return false;
        }
        RunnableC0008c runnableC0008c = new RunnableC0008c(new e(this.f1133h, this.f1134i, this.f1482q, true));
        this.G = runnableC0008c;
        ((View) this.f1140o).post(runnableC0008c);
        return true;
    }

    @Override // androidx.appcompat.view.menu.b, androidx.appcompat.view.menu.m
    public void b(androidx.appcompat.view.menu.g gVar, boolean z9) {
        y();
        super.b(gVar, z9);
    }

    @Override // androidx.appcompat.view.menu.b, androidx.appcompat.view.menu.m
    public void c(boolean z9) {
        super.c(z9);
        ((View) this.f1140o).requestLayout();
        androidx.appcompat.view.menu.g gVar = this.f1134i;
        boolean z10 = false;
        if (gVar != null) {
            ArrayList s9 = gVar.s();
            int size = s9.size();
            for (int i10 = 0; i10 < size; i10++) {
                androidx.core.view.b b10 = ((androidx.appcompat.view.menu.i) s9.get(i10)).b();
                if (b10 != null) {
                    b10.h(this);
                }
            }
        }
        androidx.appcompat.view.menu.g gVar2 = this.f1134i;
        ArrayList z11 = gVar2 != null ? gVar2.z() : null;
        if (this.f1485t && z11 != null) {
            int size2 = z11.size();
            if (size2 == 1) {
                z10 = !((androidx.appcompat.view.menu.i) z11.get(0)).isActionViewExpanded();
            } else if (size2 > 0) {
                z10 = true;
            }
        }
        d dVar = this.f1482q;
        if (z10) {
            if (dVar == null) {
                this.f1482q = new d(this.f1132g);
            }
            ViewGroup viewGroup = (ViewGroup) this.f1482q.getParent();
            if (viewGroup != this.f1140o) {
                if (viewGroup != null) {
                    viewGroup.removeView(this.f1482q);
                }
                ActionMenuView actionMenuView = (ActionMenuView) this.f1140o;
                actionMenuView.addView(this.f1482q, actionMenuView.D());
            }
        } else if (dVar != null) {
            ViewParent parent = dVar.getParent();
            androidx.appcompat.view.menu.n nVar = this.f1140o;
            if (parent == nVar) {
                ((ViewGroup) nVar).removeView(this.f1482q);
            }
        }
        ((ActionMenuView) this.f1140o).setOverflowReserved(this.f1485t);
    }

    @Override // androidx.appcompat.view.menu.m
    public boolean d() {
        ArrayList arrayList;
        int i10;
        int i11;
        int i12;
        int i13;
        c cVar = this;
        androidx.appcompat.view.menu.g gVar = cVar.f1134i;
        View view = null;
        int i14 = 0;
        if (gVar != null) {
            arrayList = gVar.E();
            i10 = arrayList.size();
        } else {
            arrayList = null;
            i10 = 0;
        }
        int i15 = cVar.f1489x;
        int i16 = cVar.f1488w;
        int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
        ViewGroup viewGroup = (ViewGroup) cVar.f1140o;
        boolean z9 = false;
        int i17 = 0;
        int i18 = 0;
        for (int i19 = 0; i19 < i10; i19++) {
            androidx.appcompat.view.menu.i iVar = (androidx.appcompat.view.menu.i) arrayList.get(i19);
            if (iVar.o()) {
                i17++;
            } else if (iVar.n()) {
                i18++;
            } else {
                z9 = true;
            }
            if (cVar.B && iVar.isActionViewExpanded()) {
                i15 = 0;
            }
        }
        if (cVar.f1485t && (z9 || i18 + i17 > i15)) {
            i15--;
        }
        int i20 = i15 - i17;
        SparseBooleanArray sparseBooleanArray = cVar.D;
        sparseBooleanArray.clear();
        if (cVar.f1491z) {
            int i21 = cVar.C;
            i12 = i16 / i21;
            i11 = i21 + ((i16 % i21) / i12);
        } else {
            i11 = 0;
            i12 = 0;
        }
        int i22 = 0;
        int i23 = 0;
        while (i22 < i10) {
            androidx.appcompat.view.menu.i iVar2 = (androidx.appcompat.view.menu.i) arrayList.get(i22);
            if (iVar2.o()) {
                View n10 = cVar.n(iVar2, view, viewGroup);
                if (cVar.f1491z) {
                    i12 -= ActionMenuView.J(n10, i11, i12, makeMeasureSpec, i14);
                } else {
                    n10.measure(makeMeasureSpec, makeMeasureSpec);
                }
                int measuredWidth = n10.getMeasuredWidth();
                i16 -= measuredWidth;
                if (i23 == 0) {
                    i23 = measuredWidth;
                }
                int groupId = iVar2.getGroupId();
                if (groupId != 0) {
                    sparseBooleanArray.put(groupId, true);
                }
                iVar2.u(true);
                i13 = i10;
            } else if (iVar2.n()) {
                int groupId2 = iVar2.getGroupId();
                boolean z10 = sparseBooleanArray.get(groupId2);
                boolean z11 = (i20 > 0 || z10) && i16 > 0 && (!cVar.f1491z || i12 > 0);
                boolean z12 = z11;
                i13 = i10;
                if (z11) {
                    View n11 = cVar.n(iVar2, null, viewGroup);
                    if (cVar.f1491z) {
                        int J = ActionMenuView.J(n11, i11, i12, makeMeasureSpec, 0);
                        i12 -= J;
                        if (J == 0) {
                            z12 = false;
                        }
                    } else {
                        n11.measure(makeMeasureSpec, makeMeasureSpec);
                    }
                    boolean z13 = z12;
                    int measuredWidth2 = n11.getMeasuredWidth();
                    i16 -= measuredWidth2;
                    if (i23 == 0) {
                        i23 = measuredWidth2;
                    }
                    z11 = z13 & (!cVar.f1491z ? i16 + i23 <= 0 : i16 < 0);
                }
                if (z11 && groupId2 != 0) {
                    sparseBooleanArray.put(groupId2, true);
                } else if (z10) {
                    sparseBooleanArray.put(groupId2, false);
                    for (int i24 = 0; i24 < i22; i24++) {
                        androidx.appcompat.view.menu.i iVar3 = (androidx.appcompat.view.menu.i) arrayList.get(i24);
                        if (iVar3.getGroupId() == groupId2) {
                            if (iVar3.l()) {
                                i20++;
                            }
                            iVar3.u(false);
                        }
                    }
                }
                if (z11) {
                    i20--;
                }
                iVar2.u(z11);
            } else {
                i13 = i10;
                iVar2.u(false);
                i22++;
                view = null;
                cVar = this;
                i10 = i13;
                i14 = 0;
            }
            i22++;
            view = null;
            cVar = this;
            i10 = i13;
            i14 = 0;
        }
        return true;
    }

    @Override // androidx.appcompat.view.menu.b, androidx.appcompat.view.menu.m
    public void h(Context context, androidx.appcompat.view.menu.g gVar) {
        super.h(context, gVar);
        Resources resources = context.getResources();
        androidx.appcompat.view.a b10 = androidx.appcompat.view.a.b(context);
        if (!this.f1486u) {
            this.f1485t = b10.f();
        }
        if (!this.A) {
            this.f1487v = b10.c();
        }
        if (!this.f1490y) {
            this.f1489x = b10.d();
        }
        int i10 = this.f1487v;
        if (this.f1485t) {
            if (this.f1482q == null) {
                d dVar = new d(this.f1132g);
                this.f1482q = dVar;
                if (this.f1484s) {
                    dVar.setImageDrawable(this.f1483r);
                    this.f1483r = null;
                    this.f1484s = false;
                }
                int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
                this.f1482q.measure(makeMeasureSpec, makeMeasureSpec);
            }
            i10 -= this.f1482q.getMeasuredWidth();
        } else {
            this.f1482q = null;
        }
        this.f1488w = i10;
        this.C = (int) (resources.getDisplayMetrics().density * 56.0f);
    }

    @Override // androidx.appcompat.view.menu.b
    public void i(androidx.appcompat.view.menu.i iVar, n.a aVar) {
        aVar.d(iVar, 0);
        ActionMenuItemView actionMenuItemView = (ActionMenuItemView) aVar;
        actionMenuItemView.setItemInvoker((ActionMenuView) this.f1140o);
        if (this.H == null) {
            this.H = new b();
        }
        actionMenuItemView.setPopupCallback(this.H);
    }

    @Override // androidx.appcompat.view.menu.b, androidx.appcompat.view.menu.m
    public boolean j(androidx.appcompat.view.menu.r rVar) {
        boolean z9 = false;
        if (rVar.hasVisibleItems()) {
            androidx.appcompat.view.menu.r rVar2 = rVar;
            while (rVar2.e0() != this.f1134i) {
                rVar2 = (androidx.appcompat.view.menu.r) rVar2.e0();
            }
            View z10 = z(rVar2.getItem());
            if (z10 == null) {
                return false;
            }
            this.J = rVar.getItem().getItemId();
            int size = rVar.size();
            int i10 = 0;
            while (true) {
                if (i10 >= size) {
                    break;
                }
                MenuItem item = rVar.getItem(i10);
                if (item.isVisible() && item.getIcon() != null) {
                    z9 = true;
                    break;
                }
                i10++;
            }
            a aVar = new a(this.f1133h, rVar, z10);
            this.F = aVar;
            aVar.g(z9);
            this.F.k();
            super.j(rVar);
            return true;
        }
        return false;
    }

    @Override // androidx.appcompat.view.menu.b
    public boolean l(ViewGroup viewGroup, int i10) {
        if (viewGroup.getChildAt(i10) == this.f1482q) {
            return false;
        }
        return super.l(viewGroup, i10);
    }

    @Override // androidx.appcompat.view.menu.b
    public View n(androidx.appcompat.view.menu.i iVar, View view, ViewGroup viewGroup) {
        View actionView = iVar.getActionView();
        if (actionView == null || iVar.j()) {
            actionView = super.n(iVar, view, viewGroup);
        }
        actionView.setVisibility(iVar.isActionViewExpanded() ? 8 : 0);
        ActionMenuView actionMenuView = (ActionMenuView) viewGroup;
        ViewGroup.LayoutParams layoutParams = actionView.getLayoutParams();
        if (!actionMenuView.checkLayoutParams(layoutParams)) {
            actionView.setLayoutParams(actionMenuView.m(layoutParams));
        }
        return actionView;
    }

    @Override // androidx.appcompat.view.menu.b
    public androidx.appcompat.view.menu.n o(ViewGroup viewGroup) {
        androidx.appcompat.view.menu.n nVar = this.f1140o;
        androidx.appcompat.view.menu.n o10 = super.o(viewGroup);
        if (nVar != o10) {
            ((ActionMenuView) o10).setPresenter(this);
        }
        return o10;
    }

    @Override // androidx.appcompat.view.menu.b
    public boolean q(int i10, androidx.appcompat.view.menu.i iVar) {
        return iVar.l();
    }

    public boolean y() {
        return B() | C();
    }
}
