package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.util.Xml;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
/* loaded from: classes.dex */
public final class a2 {

    /* renamed from: i  reason: collision with root package name */
    private static a2 f1471i;

    /* renamed from: a  reason: collision with root package name */
    private WeakHashMap f1473a;

    /* renamed from: b  reason: collision with root package name */
    private o.h f1474b;

    /* renamed from: c  reason: collision with root package name */
    private o.i f1475c;

    /* renamed from: d  reason: collision with root package name */
    private final WeakHashMap f1476d = new WeakHashMap(0);

    /* renamed from: e  reason: collision with root package name */
    private TypedValue f1477e;

    /* renamed from: f  reason: collision with root package name */
    private boolean f1478f;

    /* renamed from: g  reason: collision with root package name */
    private f f1479g;

    /* renamed from: h  reason: collision with root package name */
    private static final PorterDuff.Mode f1470h = PorterDuff.Mode.SRC_IN;

    /* renamed from: j  reason: collision with root package name */
    private static final c f1472j = new c(6);

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class a implements e {
        a() {
        }

        @Override // androidx.appcompat.widget.a2.e
        public Drawable a(Context context, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) {
            try {
                return i.a.l(context, context.getResources(), xmlPullParser, attributeSet, theme);
            } catch (Exception e10) {
                Log.e("AsldcInflateDelegate", "Exception while inflating <animated-selector>", e10);
                return null;
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class b implements e {
        b() {
        }

        @Override // androidx.appcompat.widget.a2.e
        public Drawable a(Context context, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) {
            try {
                return androidx.vectordrawable.graphics.drawable.b.a(context, context.getResources(), xmlPullParser, attributeSet, theme);
            } catch (Exception e10) {
                Log.e("AvdcInflateDelegate", "Exception while inflating <animated-vector>", e10);
                return null;
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class c extends o.g {
        public c(int i10) {
            super(i10);
        }

        private static int h(int i10, PorterDuff.Mode mode) {
            return ((i10 + 31) * 31) + mode.hashCode();
        }

        PorterDuffColorFilter i(int i10, PorterDuff.Mode mode) {
            return (PorterDuffColorFilter) c(Integer.valueOf(h(i10, mode)));
        }

        PorterDuffColorFilter j(int i10, PorterDuff.Mode mode, PorterDuffColorFilter porterDuffColorFilter) {
            return (PorterDuffColorFilter) d(Integer.valueOf(h(i10, mode)), porterDuffColorFilter);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class d implements e {
        d() {
        }

        @Override // androidx.appcompat.widget.a2.e
        public Drawable a(Context context, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) {
            String classAttribute = attributeSet.getClassAttribute();
            if (classAttribute != null) {
                try {
                    Drawable drawable = (Drawable) d.class.getClassLoader().loadClass(classAttribute).asSubclass(Drawable.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    j.c.c(drawable, context.getResources(), xmlPullParser, attributeSet, theme);
                    return drawable;
                } catch (Exception e10) {
                    Log.e("DrawableDelegate", "Exception while inflating <drawable>", e10);
                }
            }
            return null;
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public interface e {
        Drawable a(Context context, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme);
    }

    /* loaded from: classes.dex */
    public interface f {
        boolean a(Context context, int i10, Drawable drawable);

        PorterDuff.Mode b(int i10);

        Drawable c(a2 a2Var, Context context, int i10);

        ColorStateList d(Context context, int i10);

        boolean e(Context context, int i10, Drawable drawable);
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class g implements e {
        g() {
        }

        @Override // androidx.appcompat.widget.a2.e
        public Drawable a(Context context, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) {
            try {
                return androidx.vectordrawable.graphics.drawable.g.c(context.getResources(), xmlPullParser, attributeSet, theme);
            } catch (Exception e10) {
                Log.e("VdcInflateDelegate", "Exception while inflating <vector>", e10);
                return null;
            }
        }
    }

    private void a(String str, e eVar) {
        if (this.f1474b == null) {
            this.f1474b = new o.h();
        }
        this.f1474b.put(str, eVar);
    }

    private synchronized boolean b(Context context, long j10, Drawable drawable) {
        boolean z9;
        Drawable.ConstantState constantState = drawable.getConstantState();
        if (constantState != null) {
            o.f fVar = (o.f) this.f1476d.get(context);
            if (fVar == null) {
                fVar = new o.f();
                this.f1476d.put(context, fVar);
            }
            fVar.l(j10, new WeakReference(constantState));
            z9 = true;
        } else {
            z9 = false;
        }
        return z9;
    }

    private void c(Context context, int i10, ColorStateList colorStateList) {
        if (this.f1473a == null) {
            this.f1473a = new WeakHashMap();
        }
        o.i iVar = (o.i) this.f1473a.get(context);
        if (iVar == null) {
            iVar = new o.i();
            this.f1473a.put(context, iVar);
        }
        iVar.a(i10, colorStateList);
    }

    private void d(Context context) {
        if (this.f1478f) {
            return;
        }
        this.f1478f = true;
        Drawable j10 = j(context, j.d.abc_vector_test);
        if (j10 == null || !q(j10)) {
            this.f1478f = false;
            throw new IllegalStateException("This app has been built with an incorrect configuration. Please configure your build for VectorDrawableCompat.");
        }
    }

    private static long e(TypedValue typedValue) {
        return (typedValue.assetCookie << 32) | typedValue.data;
    }

    private Drawable f(Context context, int i10) {
        if (this.f1477e == null) {
            this.f1477e = new TypedValue();
        }
        TypedValue typedValue = this.f1477e;
        context.getResources().getValue(i10, typedValue, true);
        long e10 = e(typedValue);
        Drawable i11 = i(context, e10);
        if (i11 != null) {
            return i11;
        }
        f fVar = this.f1479g;
        Drawable c10 = fVar == null ? null : fVar.c(this, context, i10);
        if (c10 != null) {
            c10.setChangingConfigurations(typedValue.changingConfigurations);
            b(context, e10, c10);
        }
        return c10;
    }

    private static PorterDuffColorFilter g(ColorStateList colorStateList, PorterDuff.Mode mode, int[] iArr) {
        if (colorStateList == null || mode == null) {
            return null;
        }
        return l(colorStateList.getColorForState(iArr, 0), mode);
    }

    public static synchronized a2 h() {
        a2 a2Var;
        synchronized (a2.class) {
            if (f1471i == null) {
                a2 a2Var2 = new a2();
                f1471i = a2Var2;
                p(a2Var2);
            }
            a2Var = f1471i;
        }
        return a2Var;
    }

    private synchronized Drawable i(Context context, long j10) {
        o.f fVar = (o.f) this.f1476d.get(context);
        if (fVar == null) {
            return null;
        }
        WeakReference weakReference = (WeakReference) fVar.f(j10);
        if (weakReference != null) {
            Drawable.ConstantState constantState = (Drawable.ConstantState) weakReference.get();
            if (constantState != null) {
                return constantState.newDrawable(context.getResources());
            }
            fVar.m(j10);
        }
        return null;
    }

    public static synchronized PorterDuffColorFilter l(int i10, PorterDuff.Mode mode) {
        PorterDuffColorFilter i11;
        synchronized (a2.class) {
            c cVar = f1472j;
            i11 = cVar.i(i10, mode);
            if (i11 == null) {
                i11 = new PorterDuffColorFilter(i10, mode);
                cVar.j(i10, mode, i11);
            }
        }
        return i11;
    }

    private ColorStateList n(Context context, int i10) {
        o.i iVar;
        WeakHashMap weakHashMap = this.f1473a;
        if (weakHashMap == null || (iVar = (o.i) weakHashMap.get(context)) == null) {
            return null;
        }
        return (ColorStateList) iVar.f(i10);
    }

    private static void p(a2 a2Var) {
        if (Build.VERSION.SDK_INT < 24) {
            a2Var.a("vector", new g());
            a2Var.a("animated-vector", new b());
            a2Var.a("animated-selector", new a());
            a2Var.a("drawable", new d());
        }
    }

    private static boolean q(Drawable drawable) {
        return (drawable instanceof androidx.vectordrawable.graphics.drawable.g) || "android.graphics.drawable.VectorDrawable".equals(drawable.getClass().getName());
    }

    private Drawable r(Context context, int i10) {
        int next;
        o.h hVar = this.f1474b;
        if (hVar == null || hVar.isEmpty()) {
            return null;
        }
        o.i iVar = this.f1475c;
        if (iVar != null) {
            String str = (String) iVar.f(i10);
            if ("appcompat_skip_skip".equals(str) || (str != null && this.f1474b.get(str) == null)) {
                return null;
            }
        } else {
            this.f1475c = new o.i();
        }
        if (this.f1477e == null) {
            this.f1477e = new TypedValue();
        }
        TypedValue typedValue = this.f1477e;
        Resources resources = context.getResources();
        resources.getValue(i10, typedValue, true);
        long e10 = e(typedValue);
        Drawable i11 = i(context, e10);
        if (i11 != null) {
            return i11;
        }
        CharSequence charSequence = typedValue.string;
        if (charSequence != null && charSequence.toString().endsWith(".xml")) {
            try {
                XmlResourceParser xml = resources.getXml(i10);
                AttributeSet asAttributeSet = Xml.asAttributeSet(xml);
                while (true) {
                    next = xml.next();
                    if (next == 2 || next == 1) {
                        break;
                    }
                }
                if (next != 2) {
                    throw new XmlPullParserException("No start tag found");
                }
                String name = xml.getName();
                this.f1475c.a(i10, name);
                e eVar = (e) this.f1474b.get(name);
                if (eVar != null) {
                    i11 = eVar.a(context, xml, asAttributeSet, context.getTheme());
                }
                if (i11 != null) {
                    i11.setChangingConfigurations(typedValue.changingConfigurations);
                    b(context, e10, i11);
                }
            } catch (Exception e11) {
                Log.e("ResourceManagerInternal", "Exception while inflating drawable", e11);
            }
        }
        if (i11 == null) {
            this.f1475c.a(i10, "appcompat_skip_skip");
        }
        return i11;
    }

    private Drawable u(Context context, int i10, boolean z9, Drawable drawable) {
        ColorStateList m10 = m(context, i10);
        if (m10 == null) {
            f fVar = this.f1479g;
            if ((fVar == null || !fVar.e(context, i10, drawable)) && !w(context, i10, drawable) && z9) {
                return null;
            }
            return drawable;
        }
        if (m1.a(drawable)) {
            drawable = drawable.mutate();
        }
        Drawable r10 = androidx.core.graphics.drawable.a.r(drawable);
        androidx.core.graphics.drawable.a.o(r10, m10);
        PorterDuff.Mode o10 = o(i10);
        if (o10 != null) {
            androidx.core.graphics.drawable.a.p(r10, o10);
            return r10;
        }
        return r10;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static void v(Drawable drawable, i2 i2Var, int[] iArr) {
        int[] state = drawable.getState();
        if (m1.a(drawable)) {
            if (!(drawable.mutate() == drawable)) {
                Log.d("ResourceManagerInternal", "Mutated drawable is not the same instance as the input.");
                return;
            }
        }
        if ((drawable instanceof LayerDrawable) && drawable.isStateful()) {
            drawable.setState(new int[0]);
            drawable.setState(state);
        }
        boolean z9 = i2Var.f1590d;
        if (z9 || i2Var.f1589c) {
            drawable.setColorFilter(g(z9 ? i2Var.f1587a : null, i2Var.f1589c ? i2Var.f1588b : f1470h, iArr));
        } else {
            drawable.clearColorFilter();
        }
        if (Build.VERSION.SDK_INT <= 23) {
            drawable.invalidateSelf();
        }
    }

    public synchronized Drawable j(Context context, int i10) {
        return k(context, i10, false);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public synchronized Drawable k(Context context, int i10, boolean z9) {
        Drawable r10;
        d(context);
        r10 = r(context, i10);
        if (r10 == null) {
            r10 = f(context, i10);
        }
        if (r10 == null) {
            r10 = androidx.core.content.a.d(context, i10);
        }
        if (r10 != null) {
            r10 = u(context, i10, z9, r10);
        }
        if (r10 != null) {
            m1.b(r10);
        }
        return r10;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public synchronized ColorStateList m(Context context, int i10) {
        ColorStateList n10;
        n10 = n(context, i10);
        if (n10 == null) {
            f fVar = this.f1479g;
            n10 = fVar == null ? null : fVar.d(context, i10);
            if (n10 != null) {
                c(context, i10, n10);
            }
        }
        return n10;
    }

    PorterDuff.Mode o(int i10) {
        f fVar = this.f1479g;
        if (fVar == null) {
            return null;
        }
        return fVar.b(i10);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public synchronized Drawable s(Context context, v2 v2Var, int i10) {
        Drawable r10 = r(context, i10);
        if (r10 == null) {
            r10 = v2Var.a(i10);
        }
        if (r10 != null) {
            return u(context, i10, false, r10);
        }
        return null;
    }

    public synchronized void t(f fVar) {
        this.f1479g = fVar;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean w(Context context, int i10, Drawable drawable) {
        f fVar = this.f1479g;
        return fVar != null && fVar.a(context, i10, drawable);
    }
}
