package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: classes.dex */
public abstract class a extends ViewGroup {

    /* renamed from: g  reason: collision with root package name */
    protected final C0007a f1459g;

    /* renamed from: h  reason: collision with root package name */
    protected final Context f1460h;

    /* renamed from: i  reason: collision with root package name */
    protected ActionMenuView f1461i;

    /* renamed from: j  reason: collision with root package name */
    protected c f1462j;

    /* renamed from: k  reason: collision with root package name */
    protected int f1463k;

    /* renamed from: l  reason: collision with root package name */
    protected androidx.core.view.u2 f1464l;

    /* renamed from: m  reason: collision with root package name */
    private boolean f1465m;

    /* renamed from: n  reason: collision with root package name */
    private boolean f1466n;

    /* renamed from: androidx.appcompat.widget.a$a  reason: collision with other inner class name */
    /* loaded from: classes.dex */
    protected class C0007a implements androidx.core.view.v2 {

        /* renamed from: a  reason: collision with root package name */
        private boolean f1467a = false;

        /* renamed from: b  reason: collision with root package name */
        int f1468b;

        protected C0007a() {
        }

        @Override // androidx.core.view.v2
        public void a(View view) {
            this.f1467a = true;
        }

        @Override // androidx.core.view.v2
        public void b(View view) {
            if (this.f1467a) {
                return;
            }
            a aVar = a.this;
            aVar.f1464l = null;
            a.super.setVisibility(this.f1468b);
        }

        @Override // androidx.core.view.v2
        public void c(View view) {
            a.super.setVisibility(0);
            this.f1467a = false;
        }

        public C0007a d(androidx.core.view.u2 u2Var, int i10) {
            a.this.f1464l = u2Var;
            this.f1468b = i10;
            return this;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public a(Context context, AttributeSet attributeSet, int i10) {
        super(context, attributeSet, i10);
        this.f1459g = new C0007a();
        TypedValue typedValue = new TypedValue();
        if (!context.getTheme().resolveAttribute(g.a.actionBarPopupTheme, typedValue, true) || typedValue.resourceId == 0) {
            this.f1460h = context;
        } else {
            this.f1460h = new ContextThemeWrapper(context, typedValue.resourceId);
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public static int d(int i10, int i11, boolean z9) {
        return z9 ? i10 - i11 : i10 + i11;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public int c(View view, int i10, int i11, int i12) {
        view.measure(View.MeasureSpec.makeMeasureSpec(i10, RecyclerView.UNDEFINED_DURATION), i11);
        return Math.max(0, (i10 - view.getMeasuredWidth()) - i12);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public int e(View view, int i10, int i11, int i12, boolean z9) {
        int measuredWidth = view.getMeasuredWidth();
        int measuredHeight = view.getMeasuredHeight();
        int i13 = i11 + ((i12 - measuredHeight) / 2);
        if (z9) {
            view.layout(i10 - measuredWidth, i13, i10, measuredHeight + i13);
        } else {
            view.layout(i10, i13, i10 + measuredWidth, measuredHeight + i13);
        }
        return z9 ? -measuredWidth : measuredWidth;
    }

    public androidx.core.view.u2 f(int i10, long j10) {
        androidx.core.view.u2 b10;
        androidx.core.view.u2 u2Var = this.f1464l;
        if (u2Var != null) {
            u2Var.c();
        }
        if (i10 == 0) {
            if (getVisibility() != 0) {
                setAlpha(0.0f);
            }
            b10 = androidx.core.view.r0.d(this).b(1.0f);
        } else {
            b10 = androidx.core.view.r0.d(this).b(0.0f);
        }
        b10.f(j10);
        b10.h(this.f1459g.d(b10, i10));
        return b10;
    }

    public int getAnimatedVisibility() {
        return this.f1464l != null ? this.f1459g.f1468b : getVisibility();
    }

    public int getContentHeight() {
        return this.f1463k;
    }

    @Override // android.view.View
    protected void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        TypedArray obtainStyledAttributes = getContext().obtainStyledAttributes(null, g.j.f7771a, g.a.actionBarStyle, 0);
        setContentHeight(obtainStyledAttributes.getLayoutDimension(g.j.f7816j, 0));
        obtainStyledAttributes.recycle();
        c cVar = this.f1462j;
        if (cVar != null) {
            cVar.F(configuration);
        }
    }

    @Override // android.view.View
    public boolean onHoverEvent(MotionEvent motionEvent) {
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 9) {
            this.f1466n = false;
        }
        if (!this.f1466n) {
            boolean onHoverEvent = super.onHoverEvent(motionEvent);
            if (actionMasked == 9 && !onHoverEvent) {
                this.f1466n = true;
            }
        }
        if (actionMasked == 10 || actionMasked == 3) {
            this.f1466n = false;
        }
        return true;
    }

    @Override // android.view.View
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 0) {
            this.f1465m = false;
        }
        if (!this.f1465m) {
            boolean onTouchEvent = super.onTouchEvent(motionEvent);
            if (actionMasked == 0 && !onTouchEvent) {
                this.f1465m = true;
            }
        }
        if (actionMasked == 1 || actionMasked == 3) {
            this.f1465m = false;
        }
        return true;
    }

    public abstract void setContentHeight(int i10);

    @Override // android.view.View
    public void setVisibility(int i10) {
        if (i10 != getVisibility()) {
            androidx.core.view.u2 u2Var = this.f1464l;
            if (u2Var != null) {
                u2Var.c();
            }
            super.setVisibility(i10);
        }
    }
}
