package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import android.window.OnBackInvokedCallback;
import android.window.OnBackInvokedDispatcher;
import androidx.appcompat.app.a;
import androidx.appcompat.view.menu.g;
import androidx.appcompat.view.menu.m;
import androidx.appcompat.widget.ActionMenuView;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
/* loaded from: classes.dex */
public class Toolbar extends ViewGroup {
    private int A;
    private int B;
    private int C;
    private CharSequence D;
    private CharSequence E;
    private ColorStateList F;
    private ColorStateList G;
    private boolean H;
    private boolean I;
    private final ArrayList J;
    private final ArrayList K;
    private final int[] L;
    final androidx.core.view.o M;
    private ArrayList N;
    h O;
    private final ActionMenuView.e P;
    private o2 Q;
    private androidx.appcompat.widget.c R;
    private f S;
    private m.a T;
    g.a U;
    private boolean V;
    private OnBackInvokedCallback W;

    /* renamed from: a0  reason: collision with root package name */
    private OnBackInvokedDispatcher f1421a0;

    /* renamed from: b0  reason: collision with root package name */
    private boolean f1422b0;

    /* renamed from: c0  reason: collision with root package name */
    private final Runnable f1423c0;

    /* renamed from: g  reason: collision with root package name */
    ActionMenuView f1424g;

    /* renamed from: h  reason: collision with root package name */
    private TextView f1425h;

    /* renamed from: i  reason: collision with root package name */
    private TextView f1426i;

    /* renamed from: j  reason: collision with root package name */
    private ImageButton f1427j;

    /* renamed from: k  reason: collision with root package name */
    private ImageView f1428k;

    /* renamed from: l  reason: collision with root package name */
    private Drawable f1429l;

    /* renamed from: m  reason: collision with root package name */
    private CharSequence f1430m;

    /* renamed from: n  reason: collision with root package name */
    ImageButton f1431n;

    /* renamed from: o  reason: collision with root package name */
    View f1432o;

    /* renamed from: p  reason: collision with root package name */
    private Context f1433p;

    /* renamed from: q  reason: collision with root package name */
    private int f1434q;

    /* renamed from: r  reason: collision with root package name */
    private int f1435r;

    /* renamed from: s  reason: collision with root package name */
    private int f1436s;

    /* renamed from: t  reason: collision with root package name */
    int f1437t;

    /* renamed from: u  reason: collision with root package name */
    private int f1438u;

    /* renamed from: v  reason: collision with root package name */
    private int f1439v;

    /* renamed from: w  reason: collision with root package name */
    private int f1440w;

    /* renamed from: x  reason: collision with root package name */
    private int f1441x;

    /* renamed from: y  reason: collision with root package name */
    private int f1442y;

    /* renamed from: z  reason: collision with root package name */
    private c2 f1443z;

    /* loaded from: classes.dex */
    class a implements ActionMenuView.e {
        a() {
        }

        @Override // androidx.appcompat.widget.ActionMenuView.e
        public boolean onMenuItemClick(MenuItem menuItem) {
            if (Toolbar.this.M.j(menuItem)) {
                return true;
            }
            h hVar = Toolbar.this.O;
            if (hVar != null) {
                return hVar.onMenuItemClick(menuItem);
            }
            return false;
        }
    }

    /* loaded from: classes.dex */
    class b implements Runnable {
        b() {
        }

        @Override // java.lang.Runnable
        public void run() {
            Toolbar.this.P();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class c implements g.a {
        c() {
        }

        @Override // androidx.appcompat.view.menu.g.a
        public boolean a(androidx.appcompat.view.menu.g gVar, MenuItem menuItem) {
            g.a aVar = Toolbar.this.U;
            return aVar != null && aVar.a(gVar, menuItem);
        }

        @Override // androidx.appcompat.view.menu.g.a
        public void b(androidx.appcompat.view.menu.g gVar) {
            if (!Toolbar.this.f1424g.H()) {
                Toolbar.this.M.k(gVar);
            }
            g.a aVar = Toolbar.this.U;
            if (aVar != null) {
                aVar.b(gVar);
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public class d implements View.OnClickListener {
        d() {
        }

        @Override // android.view.View.OnClickListener
        public void onClick(View view) {
            Toolbar.this.e();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class e {
        static OnBackInvokedDispatcher a(View view) {
            return view.findOnBackInvokedDispatcher();
        }

        static OnBackInvokedCallback b(final Runnable runnable) {
            Objects.requireNonNull(runnable);
            return new OnBackInvokedCallback() { // from class: androidx.appcompat.widget.n2
                public final void onBackInvoked() {
                    runnable.run();
                }
            };
        }

        static void c(Object obj, Object obj2) {
            ((OnBackInvokedDispatcher) obj).registerOnBackInvokedCallback(1000000, (OnBackInvokedCallback) obj2);
        }

        static void d(Object obj, Object obj2) {
            ((OnBackInvokedDispatcher) obj).unregisterOnBackInvokedCallback((OnBackInvokedCallback) obj2);
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public class f implements androidx.appcompat.view.menu.m {

        /* renamed from: g  reason: collision with root package name */
        androidx.appcompat.view.menu.g f1448g;

        /* renamed from: h  reason: collision with root package name */
        androidx.appcompat.view.menu.i f1449h;

        f() {
        }

        @Override // androidx.appcompat.view.menu.m
        public void b(androidx.appcompat.view.menu.g gVar, boolean z9) {
        }

        @Override // androidx.appcompat.view.menu.m
        public void c(boolean z9) {
            if (this.f1449h != null) {
                androidx.appcompat.view.menu.g gVar = this.f1448g;
                boolean z10 = false;
                if (gVar != null) {
                    int size = gVar.size();
                    int i10 = 0;
                    while (true) {
                        if (i10 >= size) {
                            break;
                        } else if (this.f1448g.getItem(i10) == this.f1449h) {
                            z10 = true;
                            break;
                        } else {
                            i10++;
                        }
                    }
                }
                if (z10) {
                    return;
                }
                e(this.f1448g, this.f1449h);
            }
        }

        @Override // androidx.appcompat.view.menu.m
        public boolean d() {
            return false;
        }

        @Override // androidx.appcompat.view.menu.m
        public boolean e(androidx.appcompat.view.menu.g gVar, androidx.appcompat.view.menu.i iVar) {
            View view = Toolbar.this.f1432o;
            if (view instanceof androidx.appcompat.view.c) {
                ((androidx.appcompat.view.c) view).onActionViewCollapsed();
            }
            Toolbar toolbar = Toolbar.this;
            toolbar.removeView(toolbar.f1432o);
            Toolbar toolbar2 = Toolbar.this;
            toolbar2.removeView(toolbar2.f1431n);
            Toolbar toolbar3 = Toolbar.this;
            toolbar3.f1432o = null;
            toolbar3.a();
            this.f1449h = null;
            Toolbar.this.requestLayout();
            iVar.r(false);
            Toolbar.this.Q();
            return true;
        }

        @Override // androidx.appcompat.view.menu.m
        public boolean f(androidx.appcompat.view.menu.g gVar, androidx.appcompat.view.menu.i iVar) {
            Toolbar.this.g();
            ViewParent parent = Toolbar.this.f1431n.getParent();
            Toolbar toolbar = Toolbar.this;
            if (parent != toolbar) {
                if (parent instanceof ViewGroup) {
                    ((ViewGroup) parent).removeView(toolbar.f1431n);
                }
                Toolbar toolbar2 = Toolbar.this;
                toolbar2.addView(toolbar2.f1431n);
            }
            Toolbar.this.f1432o = iVar.getActionView();
            this.f1449h = iVar;
            ViewParent parent2 = Toolbar.this.f1432o.getParent();
            Toolbar toolbar3 = Toolbar.this;
            if (parent2 != toolbar3) {
                if (parent2 instanceof ViewGroup) {
                    ((ViewGroup) parent2).removeView(toolbar3.f1432o);
                }
                g generateDefaultLayoutParams = Toolbar.this.generateDefaultLayoutParams();
                Toolbar toolbar4 = Toolbar.this;
                generateDefaultLayoutParams.f860a = 8388611 | (toolbar4.f1437t & 112);
                generateDefaultLayoutParams.f1451b = 2;
                toolbar4.f1432o.setLayoutParams(generateDefaultLayoutParams);
                Toolbar toolbar5 = Toolbar.this;
                toolbar5.addView(toolbar5.f1432o);
            }
            Toolbar.this.I();
            Toolbar.this.requestLayout();
            iVar.r(true);
            View view = Toolbar.this.f1432o;
            if (view instanceof androidx.appcompat.view.c) {
                ((androidx.appcompat.view.c) view).onActionViewExpanded();
            }
            Toolbar.this.Q();
            return true;
        }

        @Override // androidx.appcompat.view.menu.m
        public void h(Context context, androidx.appcompat.view.menu.g gVar) {
            androidx.appcompat.view.menu.i iVar;
            androidx.appcompat.view.menu.g gVar2 = this.f1448g;
            if (gVar2 != null && (iVar = this.f1449h) != null) {
                gVar2.f(iVar);
            }
            this.f1448g = gVar;
        }

        @Override // androidx.appcompat.view.menu.m
        public boolean j(androidx.appcompat.view.menu.r rVar) {
            return false;
        }
    }

    /* loaded from: classes.dex */
    public static class g extends a.C0004a {

        /* renamed from: b  reason: collision with root package name */
        int f1451b;

        public g(int i10, int i11) {
            super(i10, i11);
            this.f1451b = 0;
            this.f860a = 8388627;
        }

        public g(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.f1451b = 0;
        }

        public g(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.f1451b = 0;
        }

        public g(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
            this.f1451b = 0;
            a(marginLayoutParams);
        }

        public g(a.C0004a c0004a) {
            super(c0004a);
            this.f1451b = 0;
        }

        public g(g gVar) {
            super((a.C0004a) gVar);
            this.f1451b = 0;
            this.f1451b = gVar.f1451b;
        }

        void a(ViewGroup.MarginLayoutParams marginLayoutParams) {
            ((ViewGroup.MarginLayoutParams) this).leftMargin = marginLayoutParams.leftMargin;
            ((ViewGroup.MarginLayoutParams) this).topMargin = marginLayoutParams.topMargin;
            ((ViewGroup.MarginLayoutParams) this).rightMargin = marginLayoutParams.rightMargin;
            ((ViewGroup.MarginLayoutParams) this).bottomMargin = marginLayoutParams.bottomMargin;
        }
    }

    /* loaded from: classes.dex */
    public interface h {
        boolean onMenuItemClick(MenuItem menuItem);
    }

    /* loaded from: classes.dex */
    public static class i extends b0.a {
        public static final Parcelable.Creator<i> CREATOR = new a();

        /* renamed from: i  reason: collision with root package name */
        int f1452i;

        /* renamed from: j  reason: collision with root package name */
        boolean f1453j;

        /* loaded from: classes.dex */
        class a implements Parcelable.ClassLoaderCreator {
            a() {
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: a */
            public i createFromParcel(Parcel parcel) {
                return new i(parcel, null);
            }

            @Override // android.os.Parcelable.ClassLoaderCreator
            /* renamed from: b */
            public i createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new i(parcel, classLoader);
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: c */
            public i[] newArray(int i10) {
                return new i[i10];
            }
        }

        public i(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            this.f1452i = parcel.readInt();
            this.f1453j = parcel.readInt() != 0;
        }

        public i(Parcelable parcelable) {
            super(parcelable);
        }

        @Override // b0.a, android.os.Parcelable
        public void writeToParcel(Parcel parcel, int i10) {
            super.writeToParcel(parcel, i10);
            parcel.writeInt(this.f1452i);
            parcel.writeInt(this.f1453j ? 1 : 0);
        }
    }

    public Toolbar(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, g.a.J);
    }

    public Toolbar(Context context, AttributeSet attributeSet, int i10) {
        super(context, attributeSet, i10);
        this.C = 8388627;
        this.J = new ArrayList();
        this.K = new ArrayList();
        this.L = new int[2];
        this.M = new androidx.core.view.o(new Runnable() { // from class: androidx.appcompat.widget.l2
            @Override // java.lang.Runnable
            public final void run() {
                Toolbar.this.y();
            }
        });
        this.N = new ArrayList();
        this.P = new a();
        this.f1423c0 = new b();
        Context context2 = getContext();
        int[] iArr = g.j.R2;
        k2 v9 = k2.v(context2, attributeSet, iArr, i10, 0);
        androidx.core.view.r0.l0(this, context, iArr, attributeSet, v9.r(), i10, 0);
        this.f1435r = v9.n(g.j.f7870t3, 0);
        this.f1436s = v9.n(g.j.f7825k3, 0);
        this.C = v9.l(g.j.S2, this.C);
        this.f1437t = v9.l(g.j.T2, 48);
        int e10 = v9.e(g.j.f7840n3, 0);
        int i11 = g.j.f7865s3;
        e10 = v9.s(i11) ? v9.e(i11, e10) : e10;
        this.f1442y = e10;
        this.f1441x = e10;
        this.f1440w = e10;
        this.f1439v = e10;
        int e11 = v9.e(g.j.f7855q3, -1);
        if (e11 >= 0) {
            this.f1439v = e11;
        }
        int e12 = v9.e(g.j.f7850p3, -1);
        if (e12 >= 0) {
            this.f1440w = e12;
        }
        int e13 = v9.e(g.j.f7860r3, -1);
        if (e13 >= 0) {
            this.f1441x = e13;
        }
        int e14 = v9.e(g.j.f7845o3, -1);
        if (e14 >= 0) {
            this.f1442y = e14;
        }
        this.f1438u = v9.f(g.j.f7795e3, -1);
        int e15 = v9.e(g.j.f7775a3, RecyclerView.UNDEFINED_DURATION);
        int e16 = v9.e(g.j.W2, RecyclerView.UNDEFINED_DURATION);
        int f10 = v9.f(g.j.Y2, 0);
        int f11 = v9.f(g.j.Z2, 0);
        h();
        this.f1443z.e(f10, f11);
        if (e15 != Integer.MIN_VALUE || e16 != Integer.MIN_VALUE) {
            this.f1443z.g(e15, e16);
        }
        this.A = v9.e(g.j.f7780b3, RecyclerView.UNDEFINED_DURATION);
        this.B = v9.e(g.j.X2, RecyclerView.UNDEFINED_DURATION);
        this.f1429l = v9.g(g.j.V2);
        this.f1430m = v9.p(g.j.U2);
        CharSequence p10 = v9.p(g.j.f7835m3);
        if (!TextUtils.isEmpty(p10)) {
            setTitle(p10);
        }
        CharSequence p11 = v9.p(g.j.f7820j3);
        if (!TextUtils.isEmpty(p11)) {
            setSubtitle(p11);
        }
        this.f1433p = getContext();
        setPopupTheme(v9.n(g.j.f7815i3, 0));
        Drawable g10 = v9.g(g.j.f7810h3);
        if (g10 != null) {
            setNavigationIcon(g10);
        }
        CharSequence p12 = v9.p(g.j.f7805g3);
        if (!TextUtils.isEmpty(p12)) {
            setNavigationContentDescription(p12);
        }
        Drawable g11 = v9.g(g.j.f7785c3);
        if (g11 != null) {
            setLogo(g11);
        }
        CharSequence p13 = v9.p(g.j.f7790d3);
        if (!TextUtils.isEmpty(p13)) {
            setLogoDescription(p13);
        }
        int i12 = g.j.f7875u3;
        if (v9.s(i12)) {
            setTitleTextColor(v9.c(i12));
        }
        int i13 = g.j.f7830l3;
        if (v9.s(i13)) {
            setSubtitleTextColor(v9.c(i13));
        }
        int i14 = g.j.f7800f3;
        if (v9.s(i14)) {
            x(v9.n(i14, 0));
        }
        v9.w();
    }

    private int C(View view, int i10, int[] iArr, int i11) {
        g gVar = (g) view.getLayoutParams();
        int i12 = ((ViewGroup.MarginLayoutParams) gVar).leftMargin - iArr[0];
        int max = i10 + Math.max(0, i12);
        iArr[0] = Math.max(0, -i12);
        int q10 = q(view, i11);
        int measuredWidth = view.getMeasuredWidth();
        view.layout(max, q10, max + measuredWidth, view.getMeasuredHeight() + q10);
        return max + measuredWidth + ((ViewGroup.MarginLayoutParams) gVar).rightMargin;
    }

    private int D(View view, int i10, int[] iArr, int i11) {
        g gVar = (g) view.getLayoutParams();
        int i12 = ((ViewGroup.MarginLayoutParams) gVar).rightMargin - iArr[1];
        int max = i10 - Math.max(0, i12);
        iArr[1] = Math.max(0, -i12);
        int q10 = q(view, i11);
        int measuredWidth = view.getMeasuredWidth();
        view.layout(max - measuredWidth, q10, max, view.getMeasuredHeight() + q10);
        return max - (measuredWidth + ((ViewGroup.MarginLayoutParams) gVar).leftMargin);
    }

    private int E(View view, int i10, int i11, int i12, int i13, int[] iArr) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) view.getLayoutParams();
        int i14 = marginLayoutParams.leftMargin - iArr[0];
        int i15 = marginLayoutParams.rightMargin - iArr[1];
        int max = Math.max(0, i14) + Math.max(0, i15);
        iArr[0] = Math.max(0, -i14);
        iArr[1] = Math.max(0, -i15);
        view.measure(ViewGroup.getChildMeasureSpec(i10, getPaddingLeft() + getPaddingRight() + max + i11, marginLayoutParams.width), ViewGroup.getChildMeasureSpec(i12, getPaddingTop() + getPaddingBottom() + marginLayoutParams.topMargin + marginLayoutParams.bottomMargin + i13, marginLayoutParams.height));
        return view.getMeasuredWidth() + max;
    }

    private void F(View view, int i10, int i11, int i12, int i13, int i14) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) view.getLayoutParams();
        int childMeasureSpec = ViewGroup.getChildMeasureSpec(i10, getPaddingLeft() + getPaddingRight() + marginLayoutParams.leftMargin + marginLayoutParams.rightMargin + i11, marginLayoutParams.width);
        int childMeasureSpec2 = ViewGroup.getChildMeasureSpec(i12, getPaddingTop() + getPaddingBottom() + marginLayoutParams.topMargin + marginLayoutParams.bottomMargin + i13, marginLayoutParams.height);
        int mode = View.MeasureSpec.getMode(childMeasureSpec2);
        if (mode != 1073741824 && i14 >= 0) {
            if (mode != 0) {
                i14 = Math.min(View.MeasureSpec.getSize(childMeasureSpec2), i14);
            }
            childMeasureSpec2 = View.MeasureSpec.makeMeasureSpec(i14, 1073741824);
        }
        view.measure(childMeasureSpec, childMeasureSpec2);
    }

    private void G() {
        Menu menu = getMenu();
        ArrayList<MenuItem> currentMenuItems = getCurrentMenuItems();
        this.M.h(menu, getMenuInflater());
        ArrayList<MenuItem> currentMenuItems2 = getCurrentMenuItems();
        currentMenuItems2.removeAll(currentMenuItems);
        this.N = currentMenuItems2;
    }

    private void H() {
        removeCallbacks(this.f1423c0);
        post(this.f1423c0);
    }

    private boolean N() {
        if (this.V) {
            int childCount = getChildCount();
            for (int i10 = 0; i10 < childCount; i10++) {
                View childAt = getChildAt(i10);
                if (O(childAt) && childAt.getMeasuredWidth() > 0 && childAt.getMeasuredHeight() > 0) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean O(View view) {
        return (view == null || view.getParent() != this || view.getVisibility() == 8) ? false : true;
    }

    private void b(List list, int i10) {
        boolean z9 = androidx.core.view.r0.B(this) == 1;
        int childCount = getChildCount();
        int b10 = androidx.core.view.i.b(i10, androidx.core.view.r0.B(this));
        list.clear();
        if (!z9) {
            for (int i11 = 0; i11 < childCount; i11++) {
                View childAt = getChildAt(i11);
                g gVar = (g) childAt.getLayoutParams();
                if (gVar.f1451b == 0 && O(childAt) && p(gVar.f860a) == b10) {
                    list.add(childAt);
                }
            }
            return;
        }
        for (int i12 = childCount - 1; i12 >= 0; i12--) {
            View childAt2 = getChildAt(i12);
            g gVar2 = (g) childAt2.getLayoutParams();
            if (gVar2.f1451b == 0 && O(childAt2) && p(gVar2.f860a) == b10) {
                list.add(childAt2);
            }
        }
    }

    private void c(View view, boolean z9) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        g generateDefaultLayoutParams = layoutParams == null ? generateDefaultLayoutParams() : !checkLayoutParams(layoutParams) ? generateLayoutParams(layoutParams) : (g) layoutParams;
        generateDefaultLayoutParams.f1451b = 1;
        if (!z9 || this.f1432o == null) {
            addView(view, generateDefaultLayoutParams);
            return;
        }
        view.setLayoutParams(generateDefaultLayoutParams);
        this.K.add(view);
    }

    private ArrayList<MenuItem> getCurrentMenuItems() {
        ArrayList<MenuItem> arrayList = new ArrayList<>();
        Menu menu = getMenu();
        for (int i10 = 0; i10 < menu.size(); i10++) {
            arrayList.add(menu.getItem(i10));
        }
        return arrayList;
    }

    private MenuInflater getMenuInflater() {
        return new androidx.appcompat.view.g(getContext());
    }

    private void h() {
        if (this.f1443z == null) {
            this.f1443z = new c2();
        }
    }

    private void i() {
        if (this.f1428k == null) {
            this.f1428k = new r(getContext());
        }
    }

    private void j() {
        k();
        if (this.f1424g.L() == null) {
            androidx.appcompat.view.menu.g gVar = (androidx.appcompat.view.menu.g) this.f1424g.getMenu();
            if (this.S == null) {
                this.S = new f();
            }
            this.f1424g.setExpandedActionViewsExclusive(true);
            gVar.c(this.S, this.f1433p);
            Q();
        }
    }

    private void k() {
        if (this.f1424g == null) {
            ActionMenuView actionMenuView = new ActionMenuView(getContext());
            this.f1424g = actionMenuView;
            actionMenuView.setPopupTheme(this.f1434q);
            this.f1424g.setOnMenuItemClickListener(this.P);
            this.f1424g.M(this.T, new c());
            g generateDefaultLayoutParams = generateDefaultLayoutParams();
            generateDefaultLayoutParams.f860a = 8388613 | (this.f1437t & 112);
            this.f1424g.setLayoutParams(generateDefaultLayoutParams);
            c(this.f1424g, false);
        }
    }

    private void l() {
        if (this.f1427j == null) {
            this.f1427j = new p(getContext(), null, g.a.toolbarNavigationButtonStyle);
            g generateDefaultLayoutParams = generateDefaultLayoutParams();
            generateDefaultLayoutParams.f860a = 8388611 | (this.f1437t & 112);
            this.f1427j.setLayoutParams(generateDefaultLayoutParams);
        }
    }

    private int p(int i10) {
        int B = androidx.core.view.r0.B(this);
        int b10 = androidx.core.view.i.b(i10, B) & 7;
        return (b10 == 1 || b10 == 3 || b10 == 5) ? b10 : B == 1 ? 5 : 3;
    }

    private int q(View view, int i10) {
        g gVar = (g) view.getLayoutParams();
        int measuredHeight = view.getMeasuredHeight();
        int i11 = i10 > 0 ? (measuredHeight - i10) / 2 : 0;
        int r10 = r(gVar.f860a);
        if (r10 != 48) {
            if (r10 != 80) {
                int paddingTop = getPaddingTop();
                int paddingBottom = getPaddingBottom();
                int height = getHeight();
                int i12 = (((height - paddingTop) - paddingBottom) - measuredHeight) / 2;
                int i13 = ((ViewGroup.MarginLayoutParams) gVar).topMargin;
                if (i12 < i13) {
                    i12 = i13;
                } else {
                    int i14 = (((height - paddingBottom) - measuredHeight) - i12) - paddingTop;
                    int i15 = ((ViewGroup.MarginLayoutParams) gVar).bottomMargin;
                    if (i14 < i15) {
                        i12 = Math.max(0, i12 - (i15 - i14));
                    }
                }
                return paddingTop + i12;
            }
            return (((getHeight() - getPaddingBottom()) - measuredHeight) - ((ViewGroup.MarginLayoutParams) gVar).bottomMargin) - i11;
        }
        return getPaddingTop() - i11;
    }

    private int r(int i10) {
        int i11 = i10 & 112;
        return (i11 == 16 || i11 == 48 || i11 == 80) ? i11 : this.C & 112;
    }

    private int s(View view) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) view.getLayoutParams();
        return androidx.core.view.l.b(marginLayoutParams) + androidx.core.view.l.a(marginLayoutParams);
    }

    private int t(View view) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) view.getLayoutParams();
        return marginLayoutParams.topMargin + marginLayoutParams.bottomMargin;
    }

    private int u(List list, int[] iArr) {
        int i10 = iArr[0];
        int i11 = iArr[1];
        int size = list.size();
        int i12 = 0;
        int i13 = 0;
        while (i12 < size) {
            View view = (View) list.get(i12);
            g gVar = (g) view.getLayoutParams();
            int i14 = ((ViewGroup.MarginLayoutParams) gVar).leftMargin - i10;
            int i15 = ((ViewGroup.MarginLayoutParams) gVar).rightMargin - i11;
            int max = Math.max(0, i14);
            int max2 = Math.max(0, i15);
            int max3 = Math.max(0, -i14);
            int max4 = Math.max(0, -i15);
            i13 += max + view.getMeasuredWidth() + max2;
            i12++;
            i11 = max4;
            i10 = max3;
        }
        return i13;
    }

    private boolean z(View view) {
        return view.getParent() == this || this.K.contains(view);
    }

    public boolean A() {
        ActionMenuView actionMenuView = this.f1424g;
        return actionMenuView != null && actionMenuView.G();
    }

    public boolean B() {
        ActionMenuView actionMenuView = this.f1424g;
        return actionMenuView != null && actionMenuView.H();
    }

    void I() {
        for (int childCount = getChildCount() - 1; childCount >= 0; childCount--) {
            View childAt = getChildAt(childCount);
            if (((g) childAt.getLayoutParams()).f1451b != 2 && childAt != this.f1424g) {
                removeViewAt(childCount);
                this.K.add(childAt);
            }
        }
    }

    public void J(int i10, int i11) {
        h();
        this.f1443z.g(i10, i11);
    }

    public void K(androidx.appcompat.view.menu.g gVar, androidx.appcompat.widget.c cVar) {
        if (gVar == null && this.f1424g == null) {
            return;
        }
        k();
        androidx.appcompat.view.menu.g L = this.f1424g.L();
        if (L == gVar) {
            return;
        }
        if (L != null) {
            L.O(this.R);
            L.O(this.S);
        }
        if (this.S == null) {
            this.S = new f();
        }
        cVar.G(true);
        if (gVar != null) {
            gVar.c(cVar, this.f1433p);
            gVar.c(this.S, this.f1433p);
        } else {
            cVar.h(this.f1433p, null);
            this.S.h(this.f1433p, null);
            cVar.c(true);
            this.S.c(true);
        }
        this.f1424g.setPopupTheme(this.f1434q);
        this.f1424g.setPresenter(cVar);
        this.R = cVar;
        Q();
    }

    public void L(Context context, int i10) {
        this.f1436s = i10;
        TextView textView = this.f1426i;
        if (textView != null) {
            textView.setTextAppearance(context, i10);
        }
    }

    public void M(Context context, int i10) {
        this.f1435r = i10;
        TextView textView = this.f1425h;
        if (textView != null) {
            textView.setTextAppearance(context, i10);
        }
    }

    public boolean P() {
        ActionMenuView actionMenuView = this.f1424g;
        return actionMenuView != null && actionMenuView.N();
    }

    void Q() {
        OnBackInvokedDispatcher onBackInvokedDispatcher;
        if (Build.VERSION.SDK_INT >= 33) {
            OnBackInvokedDispatcher a10 = e.a(this);
            boolean z9 = v() && a10 != null && androidx.core.view.r0.Q(this) && this.f1422b0;
            if (z9 && this.f1421a0 == null) {
                if (this.W == null) {
                    this.W = e.b(new Runnable() { // from class: androidx.appcompat.widget.m2
                        @Override // java.lang.Runnable
                        public final void run() {
                            Toolbar.this.e();
                        }
                    });
                }
                e.c(a10, this.W);
            } else if (z9 || (onBackInvokedDispatcher = this.f1421a0) == null) {
                return;
            } else {
                e.d(onBackInvokedDispatcher, this.W);
                a10 = null;
            }
            this.f1421a0 = a10;
        }
    }

    void a() {
        for (int size = this.K.size() - 1; size >= 0; size--) {
            addView((View) this.K.get(size));
        }
        this.K.clear();
    }

    @Override // android.view.ViewGroup
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return super.checkLayoutParams(layoutParams) && (layoutParams instanceof g);
    }

    public boolean d() {
        ActionMenuView actionMenuView;
        return getVisibility() == 0 && (actionMenuView = this.f1424g) != null && actionMenuView.I();
    }

    public void e() {
        f fVar = this.S;
        androidx.appcompat.view.menu.i iVar = fVar == null ? null : fVar.f1449h;
        if (iVar != null) {
            iVar.collapseActionView();
        }
    }

    public void f() {
        ActionMenuView actionMenuView = this.f1424g;
        if (actionMenuView != null) {
            actionMenuView.z();
        }
    }

    void g() {
        if (this.f1431n == null) {
            p pVar = new p(getContext(), null, g.a.toolbarNavigationButtonStyle);
            this.f1431n = pVar;
            pVar.setImageDrawable(this.f1429l);
            this.f1431n.setContentDescription(this.f1430m);
            g generateDefaultLayoutParams = generateDefaultLayoutParams();
            generateDefaultLayoutParams.f860a = 8388611 | (this.f1437t & 112);
            generateDefaultLayoutParams.f1451b = 2;
            this.f1431n.setLayoutParams(generateDefaultLayoutParams);
            this.f1431n.setOnClickListener(new d());
        }
    }

    public CharSequence getCollapseContentDescription() {
        ImageButton imageButton = this.f1431n;
        if (imageButton != null) {
            return imageButton.getContentDescription();
        }
        return null;
    }

    public Drawable getCollapseIcon() {
        ImageButton imageButton = this.f1431n;
        if (imageButton != null) {
            return imageButton.getDrawable();
        }
        return null;
    }

    public int getContentInsetEnd() {
        c2 c2Var = this.f1443z;
        if (c2Var != null) {
            return c2Var.a();
        }
        return 0;
    }

    public int getContentInsetEndWithActions() {
        int i10 = this.B;
        return i10 != Integer.MIN_VALUE ? i10 : getContentInsetEnd();
    }

    public int getContentInsetLeft() {
        c2 c2Var = this.f1443z;
        if (c2Var != null) {
            return c2Var.b();
        }
        return 0;
    }

    public int getContentInsetRight() {
        c2 c2Var = this.f1443z;
        if (c2Var != null) {
            return c2Var.c();
        }
        return 0;
    }

    public int getContentInsetStart() {
        c2 c2Var = this.f1443z;
        if (c2Var != null) {
            return c2Var.d();
        }
        return 0;
    }

    public int getContentInsetStartWithNavigation() {
        int i10 = this.A;
        return i10 != Integer.MIN_VALUE ? i10 : getContentInsetStart();
    }

    public int getCurrentContentInsetEnd() {
        androidx.appcompat.view.menu.g L;
        ActionMenuView actionMenuView = this.f1424g;
        return actionMenuView != null && (L = actionMenuView.L()) != null && L.hasVisibleItems() ? Math.max(getContentInsetEnd(), Math.max(this.B, 0)) : getContentInsetEnd();
    }

    public int getCurrentContentInsetLeft() {
        return androidx.core.view.r0.B(this) == 1 ? getCurrentContentInsetEnd() : getCurrentContentInsetStart();
    }

    public int getCurrentContentInsetRight() {
        return androidx.core.view.r0.B(this) == 1 ? getCurrentContentInsetStart() : getCurrentContentInsetEnd();
    }

    public int getCurrentContentInsetStart() {
        return getNavigationIcon() != null ? Math.max(getContentInsetStart(), Math.max(this.A, 0)) : getContentInsetStart();
    }

    public Drawable getLogo() {
        ImageView imageView = this.f1428k;
        if (imageView != null) {
            return imageView.getDrawable();
        }
        return null;
    }

    public CharSequence getLogoDescription() {
        ImageView imageView = this.f1428k;
        if (imageView != null) {
            return imageView.getContentDescription();
        }
        return null;
    }

    public Menu getMenu() {
        j();
        return this.f1424g.getMenu();
    }

    View getNavButtonView() {
        return this.f1427j;
    }

    public CharSequence getNavigationContentDescription() {
        ImageButton imageButton = this.f1427j;
        if (imageButton != null) {
            return imageButton.getContentDescription();
        }
        return null;
    }

    public Drawable getNavigationIcon() {
        ImageButton imageButton = this.f1427j;
        if (imageButton != null) {
            return imageButton.getDrawable();
        }
        return null;
    }

    androidx.appcompat.widget.c getOuterActionMenuPresenter() {
        return this.R;
    }

    public Drawable getOverflowIcon() {
        j();
        return this.f1424g.getOverflowIcon();
    }

    Context getPopupContext() {
        return this.f1433p;
    }

    public int getPopupTheme() {
        return this.f1434q;
    }

    public CharSequence getSubtitle() {
        return this.E;
    }

    final TextView getSubtitleTextView() {
        return this.f1426i;
    }

    public CharSequence getTitle() {
        return this.D;
    }

    public int getTitleMarginBottom() {
        return this.f1442y;
    }

    public int getTitleMarginEnd() {
        return this.f1440w;
    }

    public int getTitleMarginStart() {
        return this.f1439v;
    }

    public int getTitleMarginTop() {
        return this.f1441x;
    }

    final TextView getTitleTextView() {
        return this.f1425h;
    }

    public l1 getWrapper() {
        if (this.Q == null) {
            this.Q = new o2(this, true);
        }
        return this.Q;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // android.view.ViewGroup
    /* renamed from: m */
    public g generateDefaultLayoutParams() {
        return new g(-2, -2);
    }

    @Override // android.view.ViewGroup
    /* renamed from: n */
    public g generateLayoutParams(AttributeSet attributeSet) {
        return new g(getContext(), attributeSet);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // android.view.ViewGroup
    /* renamed from: o */
    public g generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof g ? new g((g) layoutParams) : layoutParams instanceof a.C0004a ? new g((a.C0004a) layoutParams) : layoutParams instanceof ViewGroup.MarginLayoutParams ? new g((ViewGroup.MarginLayoutParams) layoutParams) : new g(layoutParams);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // android.view.ViewGroup, android.view.View
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        Q();
    }

    @Override // android.view.ViewGroup, android.view.View
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        removeCallbacks(this.f1423c0);
        Q();
    }

    @Override // android.view.View
    public boolean onHoverEvent(MotionEvent motionEvent) {
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 9) {
            this.I = false;
        }
        if (!this.I) {
            boolean onHoverEvent = super.onHoverEvent(motionEvent);
            if (actionMasked == 9 && !onHoverEvent) {
                this.I = true;
            }
        }
        if (actionMasked == 10 || actionMasked == 3) {
            this.I = false;
        }
        return true;
    }

    /* JADX WARN: Removed duplicated region for block: B:110:0x0295 A[LOOP:0: B:109:0x0293->B:110:0x0295, LOOP_END] */
    /* JADX WARN: Removed duplicated region for block: B:113:0x02b7 A[LOOP:1: B:112:0x02b5->B:113:0x02b7, LOOP_END] */
    /* JADX WARN: Removed duplicated region for block: B:117:0x02e1  */
    /* JADX WARN: Removed duplicated region for block: B:122:0x02f0 A[LOOP:2: B:121:0x02ee->B:122:0x02f0, LOOP_END] */
    /* JADX WARN: Removed duplicated region for block: B:20:0x005d  */
    /* JADX WARN: Removed duplicated region for block: B:26:0x0072  */
    /* JADX WARN: Removed duplicated region for block: B:32:0x00ad  */
    /* JADX WARN: Removed duplicated region for block: B:38:0x00c2  */
    /* JADX WARN: Removed duplicated region for block: B:44:0x00dd  */
    /* JADX WARN: Removed duplicated region for block: B:45:0x00f6  */
    /* JADX WARN: Removed duplicated region for block: B:47:0x00fb  */
    /* JADX WARN: Removed duplicated region for block: B:48:0x0113  */
    /* JADX WARN: Removed duplicated region for block: B:55:0x0123  */
    /* JADX WARN: Removed duplicated region for block: B:56:0x0126  */
    /* JADX WARN: Removed duplicated region for block: B:58:0x012a  */
    /* JADX WARN: Removed duplicated region for block: B:59:0x012d  */
    /* JADX WARN: Removed duplicated region for block: B:71:0x015e  */
    /* JADX WARN: Removed duplicated region for block: B:81:0x019c  */
    /* JADX WARN: Removed duplicated region for block: B:83:0x01ad  */
    /* JADX WARN: Removed duplicated region for block: B:96:0x021d  */
    @Override // android.view.ViewGroup, android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    protected void onLayout(boolean z9, int i10, int i11, int i12, int i13) {
        int i14;
        int i15;
        boolean O;
        boolean O2;
        int i16;
        int i17;
        int i18;
        int i19;
        int i20;
        int i21;
        int i22;
        int paddingTop;
        int i23;
        int i24;
        int i25;
        int i26;
        int i27;
        int i28;
        int size;
        int i29;
        int size2;
        int i30;
        int i31;
        int size3;
        boolean z10 = androidx.core.view.r0.B(this) == 1;
        int width = getWidth();
        int height = getHeight();
        int paddingLeft = getPaddingLeft();
        int paddingRight = getPaddingRight();
        int paddingTop2 = getPaddingTop();
        int paddingBottom = getPaddingBottom();
        int i32 = width - paddingRight;
        int[] iArr = this.L;
        iArr[1] = 0;
        iArr[0] = 0;
        int C = androidx.core.view.r0.C(this);
        int min = C >= 0 ? Math.min(C, i13 - i11) : 0;
        if (O(this.f1427j)) {
            ImageButton imageButton = this.f1427j;
            if (z10) {
                i15 = D(imageButton, i32, iArr, min);
                i14 = paddingLeft;
                if (O(this.f1431n)) {
                    ImageButton imageButton2 = this.f1431n;
                    if (z10) {
                        i15 = D(imageButton2, i15, iArr, min);
                    } else {
                        i14 = C(imageButton2, i14, iArr, min);
                    }
                }
                if (O(this.f1424g)) {
                    ActionMenuView actionMenuView = this.f1424g;
                    if (z10) {
                        i14 = C(actionMenuView, i14, iArr, min);
                    } else {
                        i15 = D(actionMenuView, i15, iArr, min);
                    }
                }
                int currentContentInsetLeft = getCurrentContentInsetLeft();
                int currentContentInsetRight = getCurrentContentInsetRight();
                iArr[0] = Math.max(0, currentContentInsetLeft - i14);
                iArr[1] = Math.max(0, currentContentInsetRight - (i32 - i15));
                int max = Math.max(i14, currentContentInsetLeft);
                int min2 = Math.min(i15, i32 - currentContentInsetRight);
                if (O(this.f1432o)) {
                    View view = this.f1432o;
                    if (z10) {
                        min2 = D(view, min2, iArr, min);
                    } else {
                        max = C(view, max, iArr, min);
                    }
                }
                if (O(this.f1428k)) {
                    ImageView imageView = this.f1428k;
                    if (z10) {
                        min2 = D(imageView, min2, iArr, min);
                    } else {
                        max = C(imageView, max, iArr, min);
                    }
                }
                O = O(this.f1425h);
                O2 = O(this.f1426i);
                if (O) {
                    i16 = paddingRight;
                    i17 = 0;
                } else {
                    g gVar = (g) this.f1425h.getLayoutParams();
                    i16 = paddingRight;
                    i17 = ((ViewGroup.MarginLayoutParams) gVar).topMargin + this.f1425h.getMeasuredHeight() + ((ViewGroup.MarginLayoutParams) gVar).bottomMargin + 0;
                }
                if (O2) {
                    i18 = width;
                } else {
                    g gVar2 = (g) this.f1426i.getLayoutParams();
                    i18 = width;
                    i17 += ((ViewGroup.MarginLayoutParams) gVar2).topMargin + this.f1426i.getMeasuredHeight() + ((ViewGroup.MarginLayoutParams) gVar2).bottomMargin;
                }
                if (!O || O2) {
                    TextView textView = !O ? this.f1425h : this.f1426i;
                    TextView textView2 = !O2 ? this.f1426i : this.f1425h;
                    g gVar3 = (g) textView.getLayoutParams();
                    g gVar4 = (g) textView2.getLayoutParams();
                    boolean z11 = (!O && this.f1425h.getMeasuredWidth() > 0) || (O2 && this.f1426i.getMeasuredWidth() > 0);
                    i19 = this.C & 112;
                    i20 = paddingLeft;
                    if (i19 != 48) {
                        i21 = max;
                        i22 = min;
                        paddingTop = getPaddingTop() + ((ViewGroup.MarginLayoutParams) gVar3).topMargin + this.f1441x;
                    } else if (i19 != 80) {
                        int i33 = (((height - paddingTop2) - paddingBottom) - i17) / 2;
                        int i34 = ((ViewGroup.MarginLayoutParams) gVar3).topMargin;
                        i22 = min;
                        int i35 = this.f1441x;
                        i21 = max;
                        if (i33 < i34 + i35) {
                            i33 = i34 + i35;
                        } else {
                            int i36 = (((height - paddingBottom) - i17) - i33) - paddingTop2;
                            int i37 = ((ViewGroup.MarginLayoutParams) gVar3).bottomMargin;
                            int i38 = this.f1442y;
                            if (i36 < i37 + i38) {
                                i33 = Math.max(0, i33 - ((((ViewGroup.MarginLayoutParams) gVar4).bottomMargin + i38) - i36));
                            }
                        }
                        paddingTop = paddingTop2 + i33;
                    } else {
                        i21 = max;
                        i22 = min;
                        paddingTop = (((height - paddingBottom) - ((ViewGroup.MarginLayoutParams) gVar4).bottomMargin) - this.f1442y) - i17;
                    }
                    if (z10) {
                        if (z11) {
                            i24 = this.f1439v;
                            i23 = 0;
                        } else {
                            i23 = 0;
                            i24 = 0;
                        }
                        int i39 = i24 - iArr[i23];
                        max = i21 + Math.max(i23, i39);
                        iArr[i23] = Math.max(i23, -i39);
                        if (O) {
                            int measuredWidth = this.f1425h.getMeasuredWidth() + max;
                            int measuredHeight = this.f1425h.getMeasuredHeight() + paddingTop;
                            this.f1425h.layout(max, paddingTop, measuredWidth, measuredHeight);
                            i25 = measuredWidth + this.f1440w;
                            paddingTop = measuredHeight + ((ViewGroup.MarginLayoutParams) ((g) this.f1425h.getLayoutParams())).bottomMargin;
                        } else {
                            i25 = max;
                        }
                        if (O2) {
                            int i40 = paddingTop + ((ViewGroup.MarginLayoutParams) ((g) this.f1426i.getLayoutParams())).topMargin;
                            int measuredWidth2 = this.f1426i.getMeasuredWidth() + max;
                            this.f1426i.layout(max, i40, measuredWidth2, this.f1426i.getMeasuredHeight() + i40);
                            i26 = measuredWidth2 + this.f1440w;
                        } else {
                            i26 = max;
                        }
                        if (z11) {
                            max = Math.max(i25, i26);
                        }
                        b(this.J, 3);
                        size = this.J.size();
                        for (i29 = 0; i29 < size; i29++) {
                            max = C((View) this.J.get(i29), max, iArr, i22);
                        }
                        int i41 = i22;
                        b(this.J, 5);
                        size2 = this.J.size();
                        for (i30 = 0; i30 < size2; i30++) {
                            min2 = D((View) this.J.get(i30), min2, iArr, i41);
                        }
                        b(this.J, 1);
                        int u9 = u(this.J, iArr);
                        i31 = (i20 + (((i18 - i20) - i16) / 2)) - (u9 / 2);
                        int i42 = u9 + i31;
                        if (i31 >= max) {
                            max = i42 > min2 ? i31 - (i42 - min2) : i31;
                        }
                        size3 = this.J.size();
                        while (i23 < size3) {
                            max = C((View) this.J.get(i23), max, iArr, i41);
                            i23++;
                        }
                        this.J.clear();
                        return;
                    }
                    int i43 = (z11 ? this.f1439v : 0) - iArr[1];
                    min2 -= Math.max(0, i43);
                    iArr[1] = Math.max(0, -i43);
                    if (O) {
                        int measuredWidth3 = min2 - this.f1425h.getMeasuredWidth();
                        int measuredHeight2 = this.f1425h.getMeasuredHeight() + paddingTop;
                        this.f1425h.layout(measuredWidth3, paddingTop, min2, measuredHeight2);
                        i27 = measuredWidth3 - this.f1440w;
                        paddingTop = measuredHeight2 + ((ViewGroup.MarginLayoutParams) ((g) this.f1425h.getLayoutParams())).bottomMargin;
                    } else {
                        i27 = min2;
                    }
                    if (O2) {
                        int i44 = paddingTop + ((ViewGroup.MarginLayoutParams) ((g) this.f1426i.getLayoutParams())).topMargin;
                        this.f1426i.layout(min2 - this.f1426i.getMeasuredWidth(), i44, min2, this.f1426i.getMeasuredHeight() + i44);
                        i28 = min2 - this.f1440w;
                    } else {
                        i28 = min2;
                    }
                    if (z11) {
                        min2 = Math.min(i27, i28);
                    }
                    max = i21;
                } else {
                    i20 = paddingLeft;
                    i22 = min;
                }
                i23 = 0;
                b(this.J, 3);
                size = this.J.size();
                while (i29 < size) {
                }
                int i412 = i22;
                b(this.J, 5);
                size2 = this.J.size();
                while (i30 < size2) {
                }
                b(this.J, 1);
                int u92 = u(this.J, iArr);
                i31 = (i20 + (((i18 - i20) - i16) / 2)) - (u92 / 2);
                int i422 = u92 + i31;
                if (i31 >= max) {
                }
                size3 = this.J.size();
                while (i23 < size3) {
                }
                this.J.clear();
                return;
            }
            i14 = C(imageButton, paddingLeft, iArr, min);
        } else {
            i14 = paddingLeft;
        }
        i15 = i32;
        if (O(this.f1431n)) {
        }
        if (O(this.f1424g)) {
        }
        int currentContentInsetLeft2 = getCurrentContentInsetLeft();
        int currentContentInsetRight2 = getCurrentContentInsetRight();
        iArr[0] = Math.max(0, currentContentInsetLeft2 - i14);
        iArr[1] = Math.max(0, currentContentInsetRight2 - (i32 - i15));
        int max2 = Math.max(i14, currentContentInsetLeft2);
        int min22 = Math.min(i15, i32 - currentContentInsetRight2);
        if (O(this.f1432o)) {
        }
        if (O(this.f1428k)) {
        }
        O = O(this.f1425h);
        O2 = O(this.f1426i);
        if (O) {
        }
        if (O2) {
        }
        if (O) {
        }
        if (!O) {
        }
        if (!O2) {
        }
        g gVar32 = (g) textView.getLayoutParams();
        g gVar42 = (g) textView2.getLayoutParams();
        if (O) {
        }
        i19 = this.C & 112;
        i20 = paddingLeft;
        if (i19 != 48) {
        }
        if (z10) {
        }
    }

    @Override // android.view.View
    protected void onMeasure(int i10, int i11) {
        int i12;
        int i13;
        int i14;
        int i15;
        int i16;
        int i17;
        int i18;
        int[] iArr = this.L;
        boolean b10 = w2.b(this);
        int i19 = !b10 ? 1 : 0;
        if (O(this.f1427j)) {
            F(this.f1427j, i10, 0, i11, 0, this.f1438u);
            i12 = this.f1427j.getMeasuredWidth() + s(this.f1427j);
            i13 = Math.max(0, this.f1427j.getMeasuredHeight() + t(this.f1427j));
            i14 = View.combineMeasuredStates(0, this.f1427j.getMeasuredState());
        } else {
            i12 = 0;
            i13 = 0;
            i14 = 0;
        }
        if (O(this.f1431n)) {
            F(this.f1431n, i10, 0, i11, 0, this.f1438u);
            i12 = this.f1431n.getMeasuredWidth() + s(this.f1431n);
            i13 = Math.max(i13, this.f1431n.getMeasuredHeight() + t(this.f1431n));
            i14 = View.combineMeasuredStates(i14, this.f1431n.getMeasuredState());
        }
        int currentContentInsetStart = getCurrentContentInsetStart();
        int max = 0 + Math.max(currentContentInsetStart, i12);
        iArr[b10 ? 1 : 0] = Math.max(0, currentContentInsetStart - i12);
        if (O(this.f1424g)) {
            F(this.f1424g, i10, max, i11, 0, this.f1438u);
            i15 = this.f1424g.getMeasuredWidth() + s(this.f1424g);
            i13 = Math.max(i13, this.f1424g.getMeasuredHeight() + t(this.f1424g));
            i14 = View.combineMeasuredStates(i14, this.f1424g.getMeasuredState());
        } else {
            i15 = 0;
        }
        int currentContentInsetEnd = getCurrentContentInsetEnd();
        int max2 = max + Math.max(currentContentInsetEnd, i15);
        iArr[i19] = Math.max(0, currentContentInsetEnd - i15);
        if (O(this.f1432o)) {
            max2 += E(this.f1432o, i10, max2, i11, 0, iArr);
            i13 = Math.max(i13, this.f1432o.getMeasuredHeight() + t(this.f1432o));
            i14 = View.combineMeasuredStates(i14, this.f1432o.getMeasuredState());
        }
        if (O(this.f1428k)) {
            max2 += E(this.f1428k, i10, max2, i11, 0, iArr);
            i13 = Math.max(i13, this.f1428k.getMeasuredHeight() + t(this.f1428k));
            i14 = View.combineMeasuredStates(i14, this.f1428k.getMeasuredState());
        }
        int childCount = getChildCount();
        for (int i20 = 0; i20 < childCount; i20++) {
            View childAt = getChildAt(i20);
            if (((g) childAt.getLayoutParams()).f1451b == 0 && O(childAt)) {
                max2 += E(childAt, i10, max2, i11, 0, iArr);
                i13 = Math.max(i13, childAt.getMeasuredHeight() + t(childAt));
                i14 = View.combineMeasuredStates(i14, childAt.getMeasuredState());
            }
        }
        int i21 = this.f1441x + this.f1442y;
        int i22 = this.f1439v + this.f1440w;
        if (O(this.f1425h)) {
            E(this.f1425h, i10, max2 + i22, i11, i21, iArr);
            int measuredWidth = this.f1425h.getMeasuredWidth() + s(this.f1425h);
            i18 = this.f1425h.getMeasuredHeight() + t(this.f1425h);
            i16 = View.combineMeasuredStates(i14, this.f1425h.getMeasuredState());
            i17 = measuredWidth;
        } else {
            i16 = i14;
            i17 = 0;
            i18 = 0;
        }
        if (O(this.f1426i)) {
            i17 = Math.max(i17, E(this.f1426i, i10, max2 + i22, i11, i18 + i21, iArr));
            i18 += this.f1426i.getMeasuredHeight() + t(this.f1426i);
            i16 = View.combineMeasuredStates(i16, this.f1426i.getMeasuredState());
        }
        int max3 = Math.max(i13, i18);
        setMeasuredDimension(View.resolveSizeAndState(Math.max(max2 + i17 + getPaddingLeft() + getPaddingRight(), getSuggestedMinimumWidth()), i10, (-16777216) & i16), N() ? 0 : View.resolveSizeAndState(Math.max(max3 + getPaddingTop() + getPaddingBottom(), getSuggestedMinimumHeight()), i11, i16 << 16));
    }

    @Override // android.view.View
    protected void onRestoreInstanceState(Parcelable parcelable) {
        MenuItem findItem;
        if (!(parcelable instanceof i)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        i iVar = (i) parcelable;
        super.onRestoreInstanceState(iVar.a());
        ActionMenuView actionMenuView = this.f1424g;
        androidx.appcompat.view.menu.g L = actionMenuView != null ? actionMenuView.L() : null;
        int i10 = iVar.f1452i;
        if (i10 != 0 && this.S != null && L != null && (findItem = L.findItem(i10)) != null) {
            findItem.expandActionView();
        }
        if (iVar.f1453j) {
            H();
        }
    }

    @Override // android.view.View
    public void onRtlPropertiesChanged(int i10) {
        super.onRtlPropertiesChanged(i10);
        h();
        this.f1443z.f(i10 == 1);
    }

    @Override // android.view.View
    protected Parcelable onSaveInstanceState() {
        androidx.appcompat.view.menu.i iVar;
        i iVar2 = new i(super.onSaveInstanceState());
        f fVar = this.S;
        if (fVar != null && (iVar = fVar.f1449h) != null) {
            iVar2.f1452i = iVar.getItemId();
        }
        iVar2.f1453j = B();
        return iVar2;
    }

    @Override // android.view.View
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 0) {
            this.H = false;
        }
        if (!this.H) {
            boolean onTouchEvent = super.onTouchEvent(motionEvent);
            if (actionMasked == 0 && !onTouchEvent) {
                this.H = true;
            }
        }
        if (actionMasked == 1 || actionMasked == 3) {
            this.H = false;
        }
        return true;
    }

    public void setBackInvokedCallbackEnabled(boolean z9) {
        if (this.f1422b0 != z9) {
            this.f1422b0 = z9;
            Q();
        }
    }

    public void setCollapseContentDescription(int i10) {
        setCollapseContentDescription(i10 != 0 ? getContext().getText(i10) : null);
    }

    public void setCollapseContentDescription(CharSequence charSequence) {
        if (!TextUtils.isEmpty(charSequence)) {
            g();
        }
        ImageButton imageButton = this.f1431n;
        if (imageButton != null) {
            imageButton.setContentDescription(charSequence);
        }
    }

    public void setCollapseIcon(int i10) {
        setCollapseIcon(h.a.b(getContext(), i10));
    }

    public void setCollapseIcon(Drawable drawable) {
        if (drawable != null) {
            g();
            this.f1431n.setImageDrawable(drawable);
            return;
        }
        ImageButton imageButton = this.f1431n;
        if (imageButton != null) {
            imageButton.setImageDrawable(this.f1429l);
        }
    }

    public void setCollapsible(boolean z9) {
        this.V = z9;
        requestLayout();
    }

    public void setContentInsetEndWithActions(int i10) {
        if (i10 < 0) {
            i10 = RecyclerView.UNDEFINED_DURATION;
        }
        if (i10 != this.B) {
            this.B = i10;
            if (getNavigationIcon() != null) {
                requestLayout();
            }
        }
    }

    public void setContentInsetStartWithNavigation(int i10) {
        if (i10 < 0) {
            i10 = RecyclerView.UNDEFINED_DURATION;
        }
        if (i10 != this.A) {
            this.A = i10;
            if (getNavigationIcon() != null) {
                requestLayout();
            }
        }
    }

    public void setLogo(int i10) {
        setLogo(h.a.b(getContext(), i10));
    }

    public void setLogo(Drawable drawable) {
        if (drawable != null) {
            i();
            if (!z(this.f1428k)) {
                c(this.f1428k, true);
            }
        } else {
            ImageView imageView = this.f1428k;
            if (imageView != null && z(imageView)) {
                removeView(this.f1428k);
                this.K.remove(this.f1428k);
            }
        }
        ImageView imageView2 = this.f1428k;
        if (imageView2 != null) {
            imageView2.setImageDrawable(drawable);
        }
    }

    public void setLogoDescription(int i10) {
        setLogoDescription(getContext().getText(i10));
    }

    public void setLogoDescription(CharSequence charSequence) {
        if (!TextUtils.isEmpty(charSequence)) {
            i();
        }
        ImageView imageView = this.f1428k;
        if (imageView != null) {
            imageView.setContentDescription(charSequence);
        }
    }

    public void setNavigationContentDescription(int i10) {
        setNavigationContentDescription(i10 != 0 ? getContext().getText(i10) : null);
    }

    public void setNavigationContentDescription(CharSequence charSequence) {
        if (!TextUtils.isEmpty(charSequence)) {
            l();
        }
        ImageButton imageButton = this.f1427j;
        if (imageButton != null) {
            imageButton.setContentDescription(charSequence);
            q2.a(this.f1427j, charSequence);
        }
    }

    public void setNavigationIcon(int i10) {
        setNavigationIcon(h.a.b(getContext(), i10));
    }

    public void setNavigationIcon(Drawable drawable) {
        if (drawable != null) {
            l();
            if (!z(this.f1427j)) {
                c(this.f1427j, true);
            }
        } else {
            ImageButton imageButton = this.f1427j;
            if (imageButton != null && z(imageButton)) {
                removeView(this.f1427j);
                this.K.remove(this.f1427j);
            }
        }
        ImageButton imageButton2 = this.f1427j;
        if (imageButton2 != null) {
            imageButton2.setImageDrawable(drawable);
        }
    }

    public void setNavigationOnClickListener(View.OnClickListener onClickListener) {
        l();
        this.f1427j.setOnClickListener(onClickListener);
    }

    public void setOnMenuItemClickListener(h hVar) {
        this.O = hVar;
    }

    public void setOverflowIcon(Drawable drawable) {
        j();
        this.f1424g.setOverflowIcon(drawable);
    }

    public void setPopupTheme(int i10) {
        if (this.f1434q != i10) {
            this.f1434q = i10;
            if (i10 == 0) {
                this.f1433p = getContext();
            } else {
                this.f1433p = new ContextThemeWrapper(getContext(), i10);
            }
        }
    }

    public void setSubtitle(int i10) {
        setSubtitle(getContext().getText(i10));
    }

    public void setSubtitle(CharSequence charSequence) {
        if (TextUtils.isEmpty(charSequence)) {
            TextView textView = this.f1426i;
            if (textView != null && z(textView)) {
                removeView(this.f1426i);
                this.K.remove(this.f1426i);
            }
        } else {
            if (this.f1426i == null) {
                Context context = getContext();
                d1 d1Var = new d1(context);
                this.f1426i = d1Var;
                d1Var.setSingleLine();
                this.f1426i.setEllipsize(TextUtils.TruncateAt.END);
                int i10 = this.f1436s;
                if (i10 != 0) {
                    this.f1426i.setTextAppearance(context, i10);
                }
                ColorStateList colorStateList = this.G;
                if (colorStateList != null) {
                    this.f1426i.setTextColor(colorStateList);
                }
            }
            if (!z(this.f1426i)) {
                c(this.f1426i, true);
            }
        }
        TextView textView2 = this.f1426i;
        if (textView2 != null) {
            textView2.setText(charSequence);
        }
        this.E = charSequence;
    }

    public void setSubtitleTextColor(int i10) {
        setSubtitleTextColor(ColorStateList.valueOf(i10));
    }

    public void setSubtitleTextColor(ColorStateList colorStateList) {
        this.G = colorStateList;
        TextView textView = this.f1426i;
        if (textView != null) {
            textView.setTextColor(colorStateList);
        }
    }

    public void setTitle(int i10) {
        setTitle(getContext().getText(i10));
    }

    public void setTitle(CharSequence charSequence) {
        if (TextUtils.isEmpty(charSequence)) {
            TextView textView = this.f1425h;
            if (textView != null && z(textView)) {
                removeView(this.f1425h);
                this.K.remove(this.f1425h);
            }
        } else {
            if (this.f1425h == null) {
                Context context = getContext();
                d1 d1Var = new d1(context);
                this.f1425h = d1Var;
                d1Var.setSingleLine();
                this.f1425h.setEllipsize(TextUtils.TruncateAt.END);
                int i10 = this.f1435r;
                if (i10 != 0) {
                    this.f1425h.setTextAppearance(context, i10);
                }
                ColorStateList colorStateList = this.F;
                if (colorStateList != null) {
                    this.f1425h.setTextColor(colorStateList);
                }
            }
            if (!z(this.f1425h)) {
                c(this.f1425h, true);
            }
        }
        TextView textView2 = this.f1425h;
        if (textView2 != null) {
            textView2.setText(charSequence);
        }
        this.D = charSequence;
    }

    public void setTitleMarginBottom(int i10) {
        this.f1442y = i10;
        requestLayout();
    }

    public void setTitleMarginEnd(int i10) {
        this.f1440w = i10;
        requestLayout();
    }

    public void setTitleMarginStart(int i10) {
        this.f1439v = i10;
        requestLayout();
    }

    public void setTitleMarginTop(int i10) {
        this.f1441x = i10;
        requestLayout();
    }

    public void setTitleTextColor(int i10) {
        setTitleTextColor(ColorStateList.valueOf(i10));
    }

    public void setTitleTextColor(ColorStateList colorStateList) {
        this.F = colorStateList;
        TextView textView = this.f1425h;
        if (textView != null) {
            textView.setTextColor(colorStateList);
        }
    }

    public boolean v() {
        f fVar = this.S;
        return (fVar == null || fVar.f1449h == null) ? false : true;
    }

    public boolean w() {
        ActionMenuView actionMenuView = this.f1424g;
        return actionMenuView != null && actionMenuView.F();
    }

    public void x(int i10) {
        getMenuInflater().inflate(i10, getMenu());
    }

    public void y() {
        Iterator it = this.N.iterator();
        while (it.hasNext()) {
            getMenu().removeItem(((MenuItem) it.next()).getItemId());
        }
        G();
    }
}
