package androidx.appcompat.widget;

import android.app.PendingIntent;
import android.app.SearchableInfo;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.ImageSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.ImageView;
import android.widget.TextView;
import java.lang.reflect.Method;
import java.util.WeakHashMap;
/* loaded from: classes.dex */
public class SearchView extends q1 implements androidx.appcompat.view.c {

    /* renamed from: w0  reason: collision with root package name */
    static final o f1368w0;
    final ImageView A;
    final ImageView B;
    final ImageView C;
    private final View D;
    private q E;
    private Rect F;
    private Rect G;
    private int[] H;
    private int[] I;
    private final ImageView J;
    private final Drawable K;
    private final int L;
    private final int M;
    private final Intent N;
    private final Intent O;
    private final CharSequence P;
    private m Q;
    private l R;
    View.OnFocusChangeListener S;
    private n T;
    private View.OnClickListener U;
    private boolean V;
    private boolean W;

    /* renamed from: a0  reason: collision with root package name */
    a0.a f1369a0;

    /* renamed from: b0  reason: collision with root package name */
    private boolean f1370b0;

    /* renamed from: c0  reason: collision with root package name */
    private CharSequence f1371c0;

    /* renamed from: d0  reason: collision with root package name */
    private boolean f1372d0;

    /* renamed from: e0  reason: collision with root package name */
    private boolean f1373e0;

    /* renamed from: f0  reason: collision with root package name */
    private int f1374f0;

    /* renamed from: g0  reason: collision with root package name */
    private boolean f1375g0;

    /* renamed from: h0  reason: collision with root package name */
    private CharSequence f1376h0;

    /* renamed from: i0  reason: collision with root package name */
    private CharSequence f1377i0;

    /* renamed from: j0  reason: collision with root package name */
    private boolean f1378j0;

    /* renamed from: k0  reason: collision with root package name */
    private int f1379k0;

    /* renamed from: l0  reason: collision with root package name */
    SearchableInfo f1380l0;

    /* renamed from: m0  reason: collision with root package name */
    private Bundle f1381m0;

    /* renamed from: n0  reason: collision with root package name */
    private final Runnable f1382n0;

    /* renamed from: o0  reason: collision with root package name */
    private Runnable f1383o0;

    /* renamed from: p0  reason: collision with root package name */
    private final WeakHashMap f1384p0;

    /* renamed from: q0  reason: collision with root package name */
    private final View.OnClickListener f1385q0;

    /* renamed from: r0  reason: collision with root package name */
    View.OnKeyListener f1386r0;

    /* renamed from: s0  reason: collision with root package name */
    private final TextView.OnEditorActionListener f1387s0;

    /* renamed from: t0  reason: collision with root package name */
    private final AdapterView.OnItemClickListener f1388t0;

    /* renamed from: u0  reason: collision with root package name */
    private final AdapterView.OnItemSelectedListener f1389u0;

    /* renamed from: v  reason: collision with root package name */
    final SearchAutoComplete f1390v;

    /* renamed from: v0  reason: collision with root package name */
    private TextWatcher f1391v0;

    /* renamed from: w  reason: collision with root package name */
    private final View f1392w;

    /* renamed from: x  reason: collision with root package name */
    private final View f1393x;

    /* renamed from: y  reason: collision with root package name */
    private final View f1394y;

    /* renamed from: z  reason: collision with root package name */
    final ImageView f1395z;

    /* loaded from: classes.dex */
    public static class SearchAutoComplete extends androidx.appcompat.widget.d {

        /* renamed from: k  reason: collision with root package name */
        private int f1396k;

        /* renamed from: l  reason: collision with root package name */
        private SearchView f1397l;

        /* renamed from: m  reason: collision with root package name */
        private boolean f1398m;

        /* renamed from: n  reason: collision with root package name */
        final Runnable f1399n;

        /* loaded from: classes.dex */
        class a implements Runnable {
            a() {
            }

            @Override // java.lang.Runnable
            public void run() {
                SearchAutoComplete.this.d();
            }
        }

        public SearchAutoComplete(Context context, AttributeSet attributeSet) {
            this(context, attributeSet, g.a.autoCompleteTextViewStyle);
        }

        public SearchAutoComplete(Context context, AttributeSet attributeSet, int i10) {
            super(context, attributeSet, i10);
            this.f1399n = new a();
            this.f1396k = getThreshold();
        }

        private int getSearchViewTextMinWidthDp() {
            Configuration configuration = getResources().getConfiguration();
            int i10 = configuration.screenWidthDp;
            int i11 = configuration.screenHeightDp;
            if (i10 < 960 || i11 < 720 || configuration.orientation != 2) {
                if (i10 < 600) {
                    return (i10 < 640 || i11 < 480) ? 160 : 192;
                }
                return 192;
            }
            return 256;
        }

        void b() {
            if (Build.VERSION.SDK_INT < 29) {
                SearchView.f1368w0.c(this);
                return;
            }
            k.b(this, 1);
            if (enoughToFilter()) {
                showDropDown();
            }
        }

        boolean c() {
            return TextUtils.getTrimmedLength(getText()) == 0;
        }

        void d() {
            if (this.f1398m) {
                ((InputMethodManager) getContext().getSystemService("input_method")).showSoftInput(this, 0);
                this.f1398m = false;
            }
        }

        @Override // android.widget.AutoCompleteTextView
        public boolean enoughToFilter() {
            return this.f1396k <= 0 || super.enoughToFilter();
        }

        @Override // androidx.appcompat.widget.d, android.widget.TextView, android.view.View
        public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
            InputConnection onCreateInputConnection = super.onCreateInputConnection(editorInfo);
            if (this.f1398m) {
                removeCallbacks(this.f1399n);
                post(this.f1399n);
            }
            return onCreateInputConnection;
        }

        @Override // android.view.View
        protected void onFinishInflate() {
            super.onFinishInflate();
            setMinWidth((int) TypedValue.applyDimension(1, getSearchViewTextMinWidthDp(), getResources().getDisplayMetrics()));
        }

        @Override // android.widget.AutoCompleteTextView, android.widget.TextView, android.view.View
        protected void onFocusChanged(boolean z9, int i10, Rect rect) {
            super.onFocusChanged(z9, i10, rect);
            this.f1397l.X();
        }

        @Override // android.widget.AutoCompleteTextView, android.widget.TextView, android.view.View
        public boolean onKeyPreIme(int i10, KeyEvent keyEvent) {
            if (i10 == 4) {
                if (keyEvent.getAction() == 0 && keyEvent.getRepeatCount() == 0) {
                    KeyEvent.DispatcherState keyDispatcherState = getKeyDispatcherState();
                    if (keyDispatcherState != null) {
                        keyDispatcherState.startTracking(keyEvent, this);
                    }
                    return true;
                } else if (keyEvent.getAction() == 1) {
                    KeyEvent.DispatcherState keyDispatcherState2 = getKeyDispatcherState();
                    if (keyDispatcherState2 != null) {
                        keyDispatcherState2.handleUpEvent(keyEvent);
                    }
                    if (keyEvent.isTracking() && !keyEvent.isCanceled()) {
                        this.f1397l.clearFocus();
                        setImeVisibility(false);
                        return true;
                    }
                }
            }
            return super.onKeyPreIme(i10, keyEvent);
        }

        @Override // android.widget.AutoCompleteTextView, android.widget.TextView, android.view.View
        public void onWindowFocusChanged(boolean z9) {
            super.onWindowFocusChanged(z9);
            if (z9 && this.f1397l.hasFocus() && getVisibility() == 0) {
                this.f1398m = true;
                if (SearchView.K(getContext())) {
                    b();
                }
            }
        }

        @Override // android.widget.AutoCompleteTextView
        public void performCompletion() {
        }

        @Override // android.widget.AutoCompleteTextView
        protected void replaceText(CharSequence charSequence) {
        }

        void setImeVisibility(boolean z9) {
            InputMethodManager inputMethodManager = (InputMethodManager) getContext().getSystemService("input_method");
            if (!z9) {
                this.f1398m = false;
                removeCallbacks(this.f1399n);
                inputMethodManager.hideSoftInputFromWindow(getWindowToken(), 0);
            } else if (!inputMethodManager.isActive(this)) {
                this.f1398m = true;
            } else {
                this.f1398m = false;
                removeCallbacks(this.f1399n);
                inputMethodManager.showSoftInput(this, 0);
            }
        }

        void setSearchView(SearchView searchView) {
            this.f1397l = searchView;
        }

        @Override // android.widget.AutoCompleteTextView
        public void setThreshold(int i10) {
            super.setThreshold(i10);
            this.f1396k = i10;
        }
    }

    /* loaded from: classes.dex */
    class a implements TextWatcher {
        a() {
        }

        @Override // android.text.TextWatcher
        public void afterTextChanged(Editable editable) {
        }

        @Override // android.text.TextWatcher
        public void beforeTextChanged(CharSequence charSequence, int i10, int i11, int i12) {
        }

        @Override // android.text.TextWatcher
        public void onTextChanged(CharSequence charSequence, int i10, int i11, int i12) {
            SearchView.this.W(charSequence);
        }
    }

    /* loaded from: classes.dex */
    class b implements Runnable {
        b() {
        }

        @Override // java.lang.Runnable
        public void run() {
            SearchView.this.d0();
        }
    }

    /* loaded from: classes.dex */
    class c implements Runnable {
        c() {
        }

        @Override // java.lang.Runnable
        public void run() {
            a0.a aVar = SearchView.this.f1369a0;
            if (aVar instanceof f2) {
                aVar.a(null);
            }
        }
    }

    /* loaded from: classes.dex */
    class d implements View.OnFocusChangeListener {
        d() {
        }

        @Override // android.view.View.OnFocusChangeListener
        public void onFocusChange(View view, boolean z9) {
            SearchView searchView = SearchView.this;
            View.OnFocusChangeListener onFocusChangeListener = searchView.S;
            if (onFocusChangeListener != null) {
                onFocusChangeListener.onFocusChange(searchView, z9);
            }
        }
    }

    /* loaded from: classes.dex */
    class e implements View.OnLayoutChangeListener {
        e() {
        }

        @Override // android.view.View.OnLayoutChangeListener
        public void onLayoutChange(View view, int i10, int i11, int i12, int i13, int i14, int i15, int i16, int i17) {
            SearchView.this.z();
        }
    }

    /* loaded from: classes.dex */
    class f implements View.OnClickListener {
        f() {
        }

        @Override // android.view.View.OnClickListener
        public void onClick(View view) {
            SearchView searchView = SearchView.this;
            if (view == searchView.f1395z) {
                searchView.T();
            } else if (view == searchView.B) {
                searchView.P();
            } else if (view == searchView.A) {
                searchView.U();
            } else if (view == searchView.C) {
                searchView.Y();
            } else if (view == searchView.f1390v) {
                searchView.F();
            }
        }
    }

    /* loaded from: classes.dex */
    class g implements View.OnKeyListener {
        g() {
        }

        @Override // android.view.View.OnKeyListener
        public boolean onKey(View view, int i10, KeyEvent keyEvent) {
            SearchView searchView = SearchView.this;
            if (searchView.f1380l0 == null) {
                return false;
            }
            if (!searchView.f1390v.isPopupShowing() || SearchView.this.f1390v.getListSelection() == -1) {
                if (!SearchView.this.f1390v.c() && keyEvent.hasNoModifiers() && keyEvent.getAction() == 1 && i10 == 66) {
                    view.cancelLongPress();
                    SearchView searchView2 = SearchView.this;
                    searchView2.N(0, null, searchView2.f1390v.getText().toString());
                    return true;
                }
                return false;
            }
            return SearchView.this.V(view, i10, keyEvent);
        }
    }

    /* loaded from: classes.dex */
    class h implements TextView.OnEditorActionListener {
        h() {
        }

        @Override // android.widget.TextView.OnEditorActionListener
        public boolean onEditorAction(TextView textView, int i10, KeyEvent keyEvent) {
            SearchView.this.U();
            return true;
        }
    }

    /* loaded from: classes.dex */
    class i implements AdapterView.OnItemClickListener {
        i() {
        }

        @Override // android.widget.AdapterView.OnItemClickListener
        public void onItemClick(AdapterView adapterView, View view, int i10, long j10) {
            SearchView.this.Q(i10, 0, null);
        }
    }

    /* loaded from: classes.dex */
    class j implements AdapterView.OnItemSelectedListener {
        j() {
        }

        @Override // android.widget.AdapterView.OnItemSelectedListener
        public void onItemSelected(AdapterView adapterView, View view, int i10, long j10) {
            SearchView.this.R(i10);
        }

        @Override // android.widget.AdapterView.OnItemSelectedListener
        public void onNothingSelected(AdapterView adapterView) {
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class k {
        static void a(AutoCompleteTextView autoCompleteTextView) {
            autoCompleteTextView.refreshAutoCompleteResults();
        }

        static void b(SearchAutoComplete searchAutoComplete, int i10) {
            searchAutoComplete.setInputMethodMode(i10);
        }
    }

    /* loaded from: classes.dex */
    public interface l {
        boolean a();
    }

    /* loaded from: classes.dex */
    public interface m {
        boolean a(String str);

        boolean b(String str);
    }

    /* loaded from: classes.dex */
    public interface n {
        boolean a(int i10);

        boolean b(int i10);
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: classes.dex */
    public static class o {

        /* renamed from: a  reason: collision with root package name */
        private Method f1411a;

        /* renamed from: b  reason: collision with root package name */
        private Method f1412b;

        /* renamed from: c  reason: collision with root package name */
        private Method f1413c;

        o() {
            this.f1411a = null;
            this.f1412b = null;
            this.f1413c = null;
            d();
            try {
                Method declaredMethod = AutoCompleteTextView.class.getDeclaredMethod("doBeforeTextChanged", new Class[0]);
                this.f1411a = declaredMethod;
                declaredMethod.setAccessible(true);
            } catch (NoSuchMethodException unused) {
            }
            try {
                Method declaredMethod2 = AutoCompleteTextView.class.getDeclaredMethod("doAfterTextChanged", new Class[0]);
                this.f1412b = declaredMethod2;
                declaredMethod2.setAccessible(true);
            } catch (NoSuchMethodException unused2) {
            }
            try {
                Method method = AutoCompleteTextView.class.getMethod("ensureImeVisible", Boolean.TYPE);
                this.f1413c = method;
                method.setAccessible(true);
            } catch (NoSuchMethodException unused3) {
            }
        }

        private static void d() {
            if (Build.VERSION.SDK_INT >= 29) {
                throw new UnsupportedClassVersionError("This function can only be used for API Level < 29.");
            }
        }

        void a(AutoCompleteTextView autoCompleteTextView) {
            d();
            Method method = this.f1412b;
            if (method != null) {
                try {
                    method.invoke(autoCompleteTextView, new Object[0]);
                } catch (Exception unused) {
                }
            }
        }

        void b(AutoCompleteTextView autoCompleteTextView) {
            d();
            Method method = this.f1411a;
            if (method != null) {
                try {
                    method.invoke(autoCompleteTextView, new Object[0]);
                } catch (Exception unused) {
                }
            }
        }

        void c(AutoCompleteTextView autoCompleteTextView) {
            d();
            Method method = this.f1413c;
            if (method != null) {
                try {
                    method.invoke(autoCompleteTextView, Boolean.TRUE);
                } catch (Exception unused) {
                }
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: classes.dex */
    public static class p extends b0.a {
        public static final Parcelable.Creator<p> CREATOR = new a();

        /* renamed from: i  reason: collision with root package name */
        boolean f1414i;

        /* loaded from: classes.dex */
        class a implements Parcelable.ClassLoaderCreator {
            a() {
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: a */
            public p createFromParcel(Parcel parcel) {
                return new p(parcel, null);
            }

            @Override // android.os.Parcelable.ClassLoaderCreator
            /* renamed from: b */
            public p createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new p(parcel, classLoader);
            }

            @Override // android.os.Parcelable.Creator
            /* renamed from: c */
            public p[] newArray(int i10) {
                return new p[i10];
            }
        }

        public p(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            this.f1414i = ((Boolean) parcel.readValue(null)).booleanValue();
        }

        p(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            return "SearchView.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " isIconified=" + this.f1414i + "}";
        }

        @Override // b0.a, android.os.Parcelable
        public void writeToParcel(Parcel parcel, int i10) {
            super.writeToParcel(parcel, i10);
            parcel.writeValue(Boolean.valueOf(this.f1414i));
        }
    }

    /* loaded from: classes.dex */
    private static class q extends TouchDelegate {

        /* renamed from: a  reason: collision with root package name */
        private final View f1415a;

        /* renamed from: b  reason: collision with root package name */
        private final Rect f1416b;

        /* renamed from: c  reason: collision with root package name */
        private final Rect f1417c;

        /* renamed from: d  reason: collision with root package name */
        private final Rect f1418d;

        /* renamed from: e  reason: collision with root package name */
        private final int f1419e;

        /* renamed from: f  reason: collision with root package name */
        private boolean f1420f;

        public q(Rect rect, Rect rect2, View view) {
            super(rect, view);
            this.f1419e = ViewConfiguration.get(view.getContext()).getScaledTouchSlop();
            this.f1416b = new Rect();
            this.f1418d = new Rect();
            this.f1417c = new Rect();
            a(rect, rect2);
            this.f1415a = view;
        }

        public void a(Rect rect, Rect rect2) {
            this.f1416b.set(rect);
            this.f1418d.set(rect);
            Rect rect3 = this.f1418d;
            int i10 = this.f1419e;
            rect3.inset(-i10, -i10);
            this.f1417c.set(rect2);
        }

        @Override // android.view.TouchDelegate
        public boolean onTouchEvent(MotionEvent motionEvent) {
            boolean z9;
            float f10;
            int i10;
            boolean z10;
            int x9 = (int) motionEvent.getX();
            int y9 = (int) motionEvent.getY();
            int action = motionEvent.getAction();
            boolean z11 = true;
            if (action != 0) {
                if (action == 1 || action == 2) {
                    z10 = this.f1420f;
                    if (z10 && !this.f1418d.contains(x9, y9)) {
                        z11 = z10;
                        z9 = false;
                    }
                } else {
                    if (action == 3) {
                        z10 = this.f1420f;
                        this.f1420f = false;
                    }
                    z9 = true;
                    z11 = false;
                }
                z11 = z10;
                z9 = true;
            } else {
                if (this.f1416b.contains(x9, y9)) {
                    this.f1420f = true;
                    z9 = true;
                }
                z9 = true;
                z11 = false;
            }
            if (z11) {
                if (!z9 || this.f1417c.contains(x9, y9)) {
                    Rect rect = this.f1417c;
                    f10 = x9 - rect.left;
                    i10 = y9 - rect.top;
                } else {
                    f10 = this.f1415a.getWidth() / 2;
                    i10 = this.f1415a.getHeight() / 2;
                }
                motionEvent.setLocation(f10, i10);
                return this.f1415a.dispatchTouchEvent(motionEvent);
            }
            return false;
        }
    }

    static {
        f1368w0 = Build.VERSION.SDK_INT < 29 ? new o() : null;
    }

    public SearchView(Context context) {
        this(context, null);
    }

    public SearchView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, g.a.searchViewStyle);
    }

    public SearchView(Context context, AttributeSet attributeSet, int i10) {
        super(context, attributeSet, i10);
        this.F = new Rect();
        this.G = new Rect();
        this.H = new int[2];
        this.I = new int[2];
        this.f1382n0 = new b();
        this.f1383o0 = new c();
        this.f1384p0 = new WeakHashMap();
        f fVar = new f();
        this.f1385q0 = fVar;
        this.f1386r0 = new g();
        h hVar = new h();
        this.f1387s0 = hVar;
        i iVar = new i();
        this.f1388t0 = iVar;
        j jVar = new j();
        this.f1389u0 = jVar;
        this.f1391v0 = new a();
        int[] iArr = g.j.f7799f2;
        k2 v9 = k2.v(context, attributeSet, iArr, i10, 0);
        androidx.core.view.r0.l0(this, context, iArr, attributeSet, v9.r(), i10, 0);
        LayoutInflater.from(context).inflate(v9.n(g.j.f7849p2, g.g.abc_search_view), (ViewGroup) this, true);
        SearchAutoComplete searchAutoComplete = (SearchAutoComplete) findViewById(g.f.search_src_text);
        this.f1390v = searchAutoComplete;
        searchAutoComplete.setSearchView(this);
        this.f1392w = findViewById(g.f.search_edit_frame);
        View findViewById = findViewById(g.f.search_plate);
        this.f1393x = findViewById;
        View findViewById2 = findViewById(g.f.submit_area);
        this.f1394y = findViewById2;
        ImageView imageView = (ImageView) findViewById(g.f.search_button);
        this.f1395z = imageView;
        ImageView imageView2 = (ImageView) findViewById(g.f.search_go_btn);
        this.A = imageView2;
        ImageView imageView3 = (ImageView) findViewById(g.f.search_close_btn);
        this.B = imageView3;
        ImageView imageView4 = (ImageView) findViewById(g.f.search_voice_btn);
        this.C = imageView4;
        ImageView imageView5 = (ImageView) findViewById(g.f.search_mag_icon);
        this.J = imageView5;
        androidx.core.view.r0.r0(findViewById, v9.g(g.j.f7854q2));
        androidx.core.view.r0.r0(findViewById2, v9.g(g.j.f7874u2));
        int i11 = g.j.f7869t2;
        imageView.setImageDrawable(v9.g(i11));
        imageView2.setImageDrawable(v9.g(g.j.f7839n2));
        imageView3.setImageDrawable(v9.g(g.j.f7824k2));
        imageView4.setImageDrawable(v9.g(g.j.f7884w2));
        imageView5.setImageDrawable(v9.g(i11));
        this.K = v9.g(g.j.f7864s2);
        q2.a(imageView, getResources().getString(g.h.abc_searchview_description_search));
        this.L = v9.n(g.j.f7879v2, g.g.abc_search_dropdown_item_icons_2line);
        this.M = v9.n(g.j.f7829l2, 0);
        imageView.setOnClickListener(fVar);
        imageView3.setOnClickListener(fVar);
        imageView2.setOnClickListener(fVar);
        imageView4.setOnClickListener(fVar);
        searchAutoComplete.setOnClickListener(fVar);
        searchAutoComplete.addTextChangedListener(this.f1391v0);
        searchAutoComplete.setOnEditorActionListener(hVar);
        searchAutoComplete.setOnItemClickListener(iVar);
        searchAutoComplete.setOnItemSelectedListener(jVar);
        searchAutoComplete.setOnKeyListener(this.f1386r0);
        searchAutoComplete.setOnFocusChangeListener(new d());
        setIconifiedByDefault(v9.a(g.j.f7844o2, true));
        int f10 = v9.f(g.j.f7809h2, -1);
        if (f10 != -1) {
            setMaxWidth(f10);
        }
        this.P = v9.p(g.j.f7834m2);
        this.f1371c0 = v9.p(g.j.f7859r2);
        int k10 = v9.k(g.j.f7819j2, -1);
        if (k10 != -1) {
            setImeOptions(k10);
        }
        int k11 = v9.k(g.j.f7814i2, -1);
        if (k11 != -1) {
            setInputType(k11);
        }
        setFocusable(v9.a(g.j.f7804g2, true));
        v9.w();
        Intent intent = new Intent("android.speech.action.WEB_SEARCH");
        this.N = intent;
        intent.addFlags(268435456);
        intent.putExtra("android.speech.extra.LANGUAGE_MODEL", "web_search");
        Intent intent2 = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        this.O = intent2;
        intent2.addFlags(268435456);
        View findViewById3 = findViewById(searchAutoComplete.getDropDownAnchor());
        this.D = findViewById3;
        if (findViewById3 != null) {
            findViewById3.addOnLayoutChangeListener(new e());
        }
        i0(this.V);
        e0();
    }

    private Intent A(String str, Uri uri, String str2, String str3, int i10, String str4) {
        Intent intent = new Intent(str);
        intent.addFlags(268435456);
        if (uri != null) {
            intent.setData(uri);
        }
        intent.putExtra("user_query", this.f1377i0);
        if (str3 != null) {
            intent.putExtra("query", str3);
        }
        if (str2 != null) {
            intent.putExtra("intent_extra_data_key", str2);
        }
        Bundle bundle = this.f1381m0;
        if (bundle != null) {
            intent.putExtra("app_data", bundle);
        }
        if (i10 != 0) {
            intent.putExtra("action_key", i10);
            intent.putExtra("action_msg", str4);
        }
        intent.setComponent(this.f1380l0.getSearchActivity());
        return intent;
    }

    private Intent B(Cursor cursor, int i10, String str) {
        int i11;
        String n10;
        try {
            String n11 = f2.n(cursor, "suggest_intent_action");
            if (n11 == null) {
                n11 = this.f1380l0.getSuggestIntentAction();
            }
            if (n11 == null) {
                n11 = "android.intent.action.SEARCH";
            }
            String str2 = n11;
            String n12 = f2.n(cursor, "suggest_intent_data");
            if (n12 == null) {
                n12 = this.f1380l0.getSuggestIntentData();
            }
            if (n12 != null && (n10 = f2.n(cursor, "suggest_intent_data_id")) != null) {
                n12 = n12 + "/" + Uri.encode(n10);
            }
            return A(str2, n12 == null ? null : Uri.parse(n12), f2.n(cursor, "suggest_intent_extra_data"), f2.n(cursor, "suggest_intent_query"), i10, str);
        } catch (RuntimeException e10) {
            try {
                i11 = cursor.getPosition();
            } catch (RuntimeException unused) {
                i11 = -1;
            }
            Log.w("SearchView", "Search suggestions cursor at row " + i11 + " returned exception.", e10);
            return null;
        }
    }

    private Intent C(Intent intent, SearchableInfo searchableInfo) {
        ComponentName searchActivity = searchableInfo.getSearchActivity();
        Intent intent2 = new Intent("android.intent.action.SEARCH");
        intent2.setComponent(searchActivity);
        PendingIntent activity = PendingIntent.getActivity(getContext(), 0, intent2, 1107296256);
        Bundle bundle = new Bundle();
        Bundle bundle2 = this.f1381m0;
        if (bundle2 != null) {
            bundle.putParcelable("app_data", bundle2);
        }
        Intent intent3 = new Intent(intent);
        Resources resources = getResources();
        String string = searchableInfo.getVoiceLanguageModeId() != 0 ? resources.getString(searchableInfo.getVoiceLanguageModeId()) : "free_form";
        String string2 = searchableInfo.getVoicePromptTextId() != 0 ? resources.getString(searchableInfo.getVoicePromptTextId()) : null;
        String string3 = searchableInfo.getVoiceLanguageId() != 0 ? resources.getString(searchableInfo.getVoiceLanguageId()) : null;
        int voiceMaxResults = searchableInfo.getVoiceMaxResults() != 0 ? searchableInfo.getVoiceMaxResults() : 1;
        intent3.putExtra("android.speech.extra.LANGUAGE_MODEL", string);
        intent3.putExtra("android.speech.extra.PROMPT", string2);
        intent3.putExtra("android.speech.extra.LANGUAGE", string3);
        intent3.putExtra("android.speech.extra.MAX_RESULTS", voiceMaxResults);
        intent3.putExtra("calling_package", searchActivity != null ? searchActivity.flattenToShortString() : null);
        intent3.putExtra("android.speech.extra.RESULTS_PENDINGINTENT", activity);
        intent3.putExtra("android.speech.extra.RESULTS_PENDINGINTENT_BUNDLE", bundle);
        return intent3;
    }

    private Intent D(Intent intent, SearchableInfo searchableInfo) {
        Intent intent2 = new Intent(intent);
        ComponentName searchActivity = searchableInfo.getSearchActivity();
        intent2.putExtra("calling_package", searchActivity == null ? null : searchActivity.flattenToShortString());
        return intent2;
    }

    private void E() {
        this.f1390v.dismissDropDown();
    }

    private void G(View view, Rect rect) {
        view.getLocationInWindow(this.H);
        getLocationInWindow(this.I);
        int[] iArr = this.H;
        int i10 = iArr[1];
        int[] iArr2 = this.I;
        int i11 = i10 - iArr2[1];
        int i12 = iArr[0] - iArr2[0];
        rect.set(i12, i11, view.getWidth() + i12, view.getHeight() + i11);
    }

    private CharSequence H(CharSequence charSequence) {
        if (!this.V || this.K == null) {
            return charSequence;
        }
        int textSize = (int) (this.f1390v.getTextSize() * 1.25d);
        this.K.setBounds(0, 0, textSize, textSize);
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder("   ");
        spannableStringBuilder.setSpan(new ImageSpan(this.K), 1, 2, 33);
        spannableStringBuilder.append(charSequence);
        return spannableStringBuilder;
    }

    private boolean I() {
        SearchableInfo searchableInfo = this.f1380l0;
        if (searchableInfo == null || !searchableInfo.getVoiceSearchEnabled()) {
            return false;
        }
        Intent intent = null;
        if (this.f1380l0.getVoiceSearchLaunchWebSearch()) {
            intent = this.N;
        } else if (this.f1380l0.getVoiceSearchLaunchRecognizer()) {
            intent = this.O;
        }
        return (intent == null || getContext().getPackageManager().resolveActivity(intent, 65536) == null) ? false : true;
    }

    static boolean K(Context context) {
        return context.getResources().getConfiguration().orientation == 2;
    }

    private boolean L() {
        return (this.f1370b0 || this.f1375g0) && !J();
    }

    private void M(Intent intent) {
        if (intent == null) {
            return;
        }
        try {
            getContext().startActivity(intent);
        } catch (RuntimeException e10) {
            Log.e("SearchView", "Failed launch activity: " + intent, e10);
        }
    }

    private boolean O(int i10, int i11, String str) {
        Cursor b10 = this.f1369a0.b();
        if (b10 == null || !b10.moveToPosition(i10)) {
            return false;
        }
        M(B(b10, i11, str));
        return true;
    }

    private void Z() {
        post(this.f1382n0);
    }

    private void a0(int i10) {
        CharSequence convertToString;
        Editable text = this.f1390v.getText();
        Cursor b10 = this.f1369a0.b();
        if (b10 == null) {
            return;
        }
        if (!b10.moveToPosition(i10) || (convertToString = this.f1369a0.convertToString(b10)) == null) {
            setQuery(text);
        } else {
            setQuery(convertToString);
        }
    }

    private void c0() {
        boolean z9 = true;
        boolean z10 = !TextUtils.isEmpty(this.f1390v.getText());
        if (!z10 && (!this.V || this.f1378j0)) {
            z9 = false;
        }
        this.B.setVisibility(z9 ? 0 : 8);
        Drawable drawable = this.B.getDrawable();
        if (drawable != null) {
            drawable.setState(z10 ? ViewGroup.ENABLED_STATE_SET : ViewGroup.EMPTY_STATE_SET);
        }
    }

    private void e0() {
        CharSequence queryHint = getQueryHint();
        SearchAutoComplete searchAutoComplete = this.f1390v;
        if (queryHint == null) {
            queryHint = "";
        }
        searchAutoComplete.setHint(H(queryHint));
    }

    private void f0() {
        this.f1390v.setThreshold(this.f1380l0.getSuggestThreshold());
        this.f1390v.setImeOptions(this.f1380l0.getImeOptions());
        int inputType = this.f1380l0.getInputType();
        if ((inputType & 15) == 1) {
            inputType &= -65537;
            if (this.f1380l0.getSuggestAuthority() != null) {
                inputType = inputType | 65536 | 524288;
            }
        }
        this.f1390v.setInputType(inputType);
        a0.a aVar = this.f1369a0;
        if (aVar != null) {
            aVar.a(null);
        }
        if (this.f1380l0.getSuggestAuthority() != null) {
            f2 f2Var = new f2(getContext(), this, this.f1380l0, this.f1384p0);
            this.f1369a0 = f2Var;
            this.f1390v.setAdapter(f2Var);
            ((f2) this.f1369a0).w(this.f1372d0 ? 2 : 1);
        }
    }

    private void g0() {
        this.f1394y.setVisibility((L() && (this.A.getVisibility() == 0 || this.C.getVisibility() == 0)) ? 0 : 8);
    }

    private int getPreferredHeight() {
        return getContext().getResources().getDimensionPixelSize(g.d.abc_search_view_preferred_height);
    }

    private int getPreferredWidth() {
        return getContext().getResources().getDimensionPixelSize(g.d.abc_search_view_preferred_width);
    }

    private void h0(boolean z9) {
        this.A.setVisibility((this.f1370b0 && L() && hasFocus() && (z9 || !this.f1375g0)) ? 0 : 8);
    }

    private void i0(boolean z9) {
        this.W = z9;
        int i10 = 0;
        int i11 = z9 ? 0 : 8;
        boolean z10 = !TextUtils.isEmpty(this.f1390v.getText());
        this.f1395z.setVisibility(i11);
        h0(z10);
        this.f1392w.setVisibility(z9 ? 8 : 0);
        this.J.setVisibility((this.J.getDrawable() == null || this.V) ? 8 : 8);
        c0();
        j0(!z10);
        g0();
    }

    private void j0(boolean z9) {
        int i10 = 8;
        if (this.f1375g0 && !J() && z9) {
            this.A.setVisibility(8);
            i10 = 0;
        }
        this.C.setVisibility(i10);
    }

    private void setQuery(CharSequence charSequence) {
        this.f1390v.setText(charSequence);
        this.f1390v.setSelection(TextUtils.isEmpty(charSequence) ? 0 : charSequence.length());
    }

    void F() {
        if (Build.VERSION.SDK_INT >= 29) {
            k.a(this.f1390v);
            return;
        }
        o oVar = f1368w0;
        oVar.b(this.f1390v);
        oVar.a(this.f1390v);
    }

    public boolean J() {
        return this.W;
    }

    void N(int i10, String str, String str2) {
        getContext().startActivity(A("android.intent.action.SEARCH", null, null, str2, i10, str));
    }

    void P() {
        if (!TextUtils.isEmpty(this.f1390v.getText())) {
            this.f1390v.setText("");
            this.f1390v.requestFocus();
            this.f1390v.setImeVisibility(true);
        } else if (this.V) {
            l lVar = this.R;
            if (lVar == null || !lVar.a()) {
                clearFocus();
                i0(true);
            }
        }
    }

    boolean Q(int i10, int i11, String str) {
        n nVar = this.T;
        if (nVar == null || !nVar.b(i10)) {
            O(i10, 0, null);
            this.f1390v.setImeVisibility(false);
            E();
            return true;
        }
        return false;
    }

    boolean R(int i10) {
        n nVar = this.T;
        if (nVar == null || !nVar.a(i10)) {
            a0(i10);
            return true;
        }
        return false;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public void S(CharSequence charSequence) {
        setQuery(charSequence);
    }

    void T() {
        i0(false);
        this.f1390v.requestFocus();
        this.f1390v.setImeVisibility(true);
        View.OnClickListener onClickListener = this.U;
        if (onClickListener != null) {
            onClickListener.onClick(this);
        }
    }

    void U() {
        Editable text = this.f1390v.getText();
        if (text == null || TextUtils.getTrimmedLength(text) <= 0) {
            return;
        }
        m mVar = this.Q;
        if (mVar == null || !mVar.b(text.toString())) {
            if (this.f1380l0 != null) {
                N(0, null, text.toString());
            }
            this.f1390v.setImeVisibility(false);
            E();
        }
    }

    boolean V(View view, int i10, KeyEvent keyEvent) {
        if (this.f1380l0 != null && this.f1369a0 != null && keyEvent.getAction() == 0 && keyEvent.hasNoModifiers()) {
            if (i10 == 66 || i10 == 84 || i10 == 61) {
                return Q(this.f1390v.getListSelection(), 0, null);
            }
            if (i10 == 21 || i10 == 22) {
                this.f1390v.setSelection(i10 == 21 ? 0 : this.f1390v.length());
                this.f1390v.setListSelection(0);
                this.f1390v.clearListSelection();
                this.f1390v.b();
                return true;
            } else if (i10 == 19) {
                this.f1390v.getListSelection();
                return false;
            }
        }
        return false;
    }

    void W(CharSequence charSequence) {
        Editable text = this.f1390v.getText();
        this.f1377i0 = text;
        boolean z9 = !TextUtils.isEmpty(text);
        h0(z9);
        j0(!z9);
        c0();
        g0();
        if (this.Q != null && !TextUtils.equals(charSequence, this.f1376h0)) {
            this.Q.a(charSequence.toString());
        }
        this.f1376h0 = charSequence.toString();
    }

    void X() {
        i0(J());
        Z();
        if (this.f1390v.hasFocus()) {
            F();
        }
    }

    void Y() {
        Intent C;
        SearchableInfo searchableInfo = this.f1380l0;
        if (searchableInfo == null) {
            return;
        }
        try {
            if (searchableInfo.getVoiceSearchLaunchWebSearch()) {
                C = D(this.N, searchableInfo);
            } else if (!searchableInfo.getVoiceSearchLaunchRecognizer()) {
                return;
            } else {
                C = C(this.O, searchableInfo);
            }
            getContext().startActivity(C);
        } catch (ActivityNotFoundException unused) {
            Log.w("SearchView", "Could not find voice search activity");
        }
    }

    public void b0(CharSequence charSequence, boolean z9) {
        this.f1390v.setText(charSequence);
        if (charSequence != null) {
            SearchAutoComplete searchAutoComplete = this.f1390v;
            searchAutoComplete.setSelection(searchAutoComplete.length());
            this.f1377i0 = charSequence;
        }
        if (!z9 || TextUtils.isEmpty(charSequence)) {
            return;
        }
        U();
    }

    @Override // android.view.ViewGroup, android.view.View
    public void clearFocus() {
        this.f1373e0 = true;
        super.clearFocus();
        this.f1390v.clearFocus();
        this.f1390v.setImeVisibility(false);
        this.f1373e0 = false;
    }

    void d0() {
        int[] iArr = this.f1390v.hasFocus() ? ViewGroup.FOCUSED_STATE_SET : ViewGroup.EMPTY_STATE_SET;
        Drawable background = this.f1393x.getBackground();
        if (background != null) {
            background.setState(iArr);
        }
        Drawable background2 = this.f1394y.getBackground();
        if (background2 != null) {
            background2.setState(iArr);
        }
        invalidate();
    }

    public int getImeOptions() {
        return this.f1390v.getImeOptions();
    }

    public int getInputType() {
        return this.f1390v.getInputType();
    }

    public int getMaxWidth() {
        return this.f1374f0;
    }

    public CharSequence getQuery() {
        return this.f1390v.getText();
    }

    public CharSequence getQueryHint() {
        CharSequence charSequence = this.f1371c0;
        if (charSequence != null) {
            return charSequence;
        }
        SearchableInfo searchableInfo = this.f1380l0;
        return (searchableInfo == null || searchableInfo.getHintId() == 0) ? this.P : getContext().getText(this.f1380l0.getHintId());
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public int getSuggestionCommitIconResId() {
        return this.M;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public int getSuggestionRowLayout() {
        return this.L;
    }

    public a0.a getSuggestionsAdapter() {
        return this.f1369a0;
    }

    @Override // androidx.appcompat.view.c
    public void onActionViewCollapsed() {
        b0("", false);
        clearFocus();
        i0(true);
        this.f1390v.setImeOptions(this.f1379k0);
        this.f1378j0 = false;
    }

    @Override // androidx.appcompat.view.c
    public void onActionViewExpanded() {
        if (this.f1378j0) {
            return;
        }
        this.f1378j0 = true;
        int imeOptions = this.f1390v.getImeOptions();
        this.f1379k0 = imeOptions;
        this.f1390v.setImeOptions(imeOptions | 33554432);
        this.f1390v.setText("");
        setIconified(false);
    }

    @Override // android.view.ViewGroup, android.view.View
    protected void onDetachedFromWindow() {
        removeCallbacks(this.f1382n0);
        post(this.f1383o0);
        super.onDetachedFromWindow();
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // androidx.appcompat.widget.q1, android.view.ViewGroup, android.view.View
    public void onLayout(boolean z9, int i10, int i11, int i12, int i13) {
        super.onLayout(z9, i10, i11, i12, i13);
        if (z9) {
            G(this.f1390v, this.F);
            Rect rect = this.G;
            Rect rect2 = this.F;
            rect.set(rect2.left, 0, rect2.right, i13 - i11);
            q qVar = this.E;
            if (qVar != null) {
                qVar.a(this.G, this.F);
                return;
            }
            q qVar2 = new q(this.G, this.F, this.f1390v);
            this.E = qVar2;
            setTouchDelegate(qVar2);
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    /* JADX WARN: Code restructure failed: missing block: B:12:0x001f, code lost:
        if (r0 <= 0) goto L13;
     */
    /* JADX WARN: Removed duplicated region for block: B:25:0x0043  */
    /* JADX WARN: Removed duplicated region for block: B:28:0x004b  */
    @Override // androidx.appcompat.widget.q1, android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public void onMeasure(int i10, int i11) {
        int i12;
        int mode;
        if (J()) {
            super.onMeasure(i10, i11);
            return;
        }
        int mode2 = View.MeasureSpec.getMode(i10);
        int size = View.MeasureSpec.getSize(i10);
        if (mode2 != Integer.MIN_VALUE) {
            if (mode2 == 0) {
                size = this.f1374f0;
                if (size <= 0) {
                    size = getPreferredWidth();
                }
            } else if (mode2 == 1073741824) {
                i12 = this.f1374f0;
            }
            mode = View.MeasureSpec.getMode(i11);
            int size2 = View.MeasureSpec.getSize(i11);
            if (mode != Integer.MIN_VALUE) {
                size2 = Math.min(getPreferredHeight(), size2);
            } else if (mode == 0) {
                size2 = getPreferredHeight();
            }
            super.onMeasure(View.MeasureSpec.makeMeasureSpec(size, 1073741824), View.MeasureSpec.makeMeasureSpec(size2, 1073741824));
        }
        i12 = this.f1374f0;
        if (i12 <= 0) {
            i12 = getPreferredWidth();
        }
        size = Math.min(i12, size);
        mode = View.MeasureSpec.getMode(i11);
        int size22 = View.MeasureSpec.getSize(i11);
        if (mode != Integer.MIN_VALUE) {
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec(size, 1073741824), View.MeasureSpec.makeMeasureSpec(size22, 1073741824));
    }

    @Override // android.view.View
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof p)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        p pVar = (p) parcelable;
        super.onRestoreInstanceState(pVar.a());
        i0(pVar.f1414i);
        requestLayout();
    }

    @Override // android.view.View
    protected Parcelable onSaveInstanceState() {
        p pVar = new p(super.onSaveInstanceState());
        pVar.f1414i = J();
        return pVar;
    }

    @Override // android.view.View
    public void onWindowFocusChanged(boolean z9) {
        super.onWindowFocusChanged(z9);
        Z();
    }

    @Override // android.view.ViewGroup, android.view.View
    public boolean requestFocus(int i10, Rect rect) {
        if (!this.f1373e0 && isFocusable()) {
            if (J()) {
                return super.requestFocus(i10, rect);
            }
            boolean requestFocus = this.f1390v.requestFocus(i10, rect);
            if (requestFocus) {
                i0(false);
            }
            return requestFocus;
        }
        return false;
    }

    public void setAppSearchData(Bundle bundle) {
        this.f1381m0 = bundle;
    }

    public void setIconified(boolean z9) {
        if (z9) {
            P();
        } else {
            T();
        }
    }

    public void setIconifiedByDefault(boolean z9) {
        if (this.V == z9) {
            return;
        }
        this.V = z9;
        i0(z9);
        e0();
    }

    public void setImeOptions(int i10) {
        this.f1390v.setImeOptions(i10);
    }

    public void setInputType(int i10) {
        this.f1390v.setInputType(i10);
    }

    public void setMaxWidth(int i10) {
        this.f1374f0 = i10;
        requestLayout();
    }

    public void setOnCloseListener(l lVar) {
        this.R = lVar;
    }

    public void setOnQueryTextFocusChangeListener(View.OnFocusChangeListener onFocusChangeListener) {
        this.S = onFocusChangeListener;
    }

    public void setOnQueryTextListener(m mVar) {
        this.Q = mVar;
    }

    public void setOnSearchClickListener(View.OnClickListener onClickListener) {
        this.U = onClickListener;
    }

    public void setOnSuggestionListener(n nVar) {
        this.T = nVar;
    }

    public void setQueryHint(CharSequence charSequence) {
        this.f1371c0 = charSequence;
        e0();
    }

    public void setQueryRefinementEnabled(boolean z9) {
        this.f1372d0 = z9;
        a0.a aVar = this.f1369a0;
        if (aVar instanceof f2) {
            ((f2) aVar).w(z9 ? 2 : 1);
        }
    }

    public void setSearchableInfo(SearchableInfo searchableInfo) {
        this.f1380l0 = searchableInfo;
        if (searchableInfo != null) {
            f0();
            e0();
        }
        boolean I = I();
        this.f1375g0 = I;
        if (I) {
            this.f1390v.setPrivateImeOptions("nm");
        }
        i0(J());
    }

    public void setSubmitButtonEnabled(boolean z9) {
        this.f1370b0 = z9;
        i0(J());
    }

    public void setSuggestionsAdapter(a0.a aVar) {
        this.f1369a0 = aVar;
        this.f1390v.setAdapter(aVar);
    }

    void z() {
        if (this.D.getWidth() > 1) {
            Resources resources = getContext().getResources();
            int paddingLeft = this.f1393x.getPaddingLeft();
            Rect rect = new Rect();
            boolean b10 = w2.b(this);
            int dimensionPixelSize = this.V ? resources.getDimensionPixelSize(g.d.abc_dropdownitem_icon_width) + resources.getDimensionPixelSize(g.d.abc_dropdownitem_text_padding_left) : 0;
            this.f1390v.getDropDownBackground().getPadding(rect);
            int i10 = rect.left;
            this.f1390v.setDropDownHorizontalOffset(b10 ? -i10 : paddingLeft - (i10 + dimensionPixelSize));
            this.f1390v.setDropDownWidth((((this.D.getWidth() + rect.left) + rect.right) + dimensionPixelSize) - paddingLeft);
        }
    }
}
