package androidx.appcompat.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import android.view.Window;
import android.view.WindowInsets;
import android.widget.OverScroller;
import androidx.appcompat.view.menu.m;
import androidx.core.view.y2;
import androidx.recyclerview.widget.RecyclerView;
@SuppressLint({"UnknownNullness"})
/* loaded from: classes.dex */
public class ActionBarOverlayLayout extends ViewGroup implements k1, androidx.core.view.g0, androidx.core.view.h0 {
    static final int[] L = {g.a.actionBarSize, 16842841};
    private y2 A;
    private y2 B;
    private y2 C;
    private y2 D;
    private d E;
    private OverScroller F;
    ViewPropertyAnimator G;
    final AnimatorListenerAdapter H;
    private final Runnable I;
    private final Runnable J;
    private final androidx.core.view.i0 K;

    /* renamed from: g  reason: collision with root package name */
    private int f1319g;

    /* renamed from: h  reason: collision with root package name */
    private int f1320h;

    /* renamed from: i  reason: collision with root package name */
    private ContentFrameLayout f1321i;

    /* renamed from: j  reason: collision with root package name */
    ActionBarContainer f1322j;

    /* renamed from: k  reason: collision with root package name */
    private l1 f1323k;

    /* renamed from: l  reason: collision with root package name */
    private Drawable f1324l;

    /* renamed from: m  reason: collision with root package name */
    private boolean f1325m;

    /* renamed from: n  reason: collision with root package name */
    private boolean f1326n;

    /* renamed from: o  reason: collision with root package name */
    private boolean f1327o;

    /* renamed from: p  reason: collision with root package name */
    private boolean f1328p;

    /* renamed from: q  reason: collision with root package name */
    boolean f1329q;

    /* renamed from: r  reason: collision with root package name */
    private int f1330r;

    /* renamed from: s  reason: collision with root package name */
    private int f1331s;

    /* renamed from: t  reason: collision with root package name */
    private final Rect f1332t;

    /* renamed from: u  reason: collision with root package name */
    private final Rect f1333u;

    /* renamed from: v  reason: collision with root package name */
    private final Rect f1334v;

    /* renamed from: w  reason: collision with root package name */
    private final Rect f1335w;

    /* renamed from: x  reason: collision with root package name */
    private final Rect f1336x;

    /* renamed from: y  reason: collision with root package name */
    private final Rect f1337y;

    /* renamed from: z  reason: collision with root package name */
    private final Rect f1338z;

    /* loaded from: classes.dex */
    class a extends AnimatorListenerAdapter {
        a() {
        }

        @Override // android.animation.AnimatorListenerAdapter, android.animation.Animator.AnimatorListener
        public void onAnimationCancel(Animator animator) {
            ActionBarOverlayLayout actionBarOverlayLayout = ActionBarOverlayLayout.this;
            actionBarOverlayLayout.G = null;
            actionBarOverlayLayout.f1329q = false;
        }

        @Override // android.animation.AnimatorListenerAdapter, android.animation.Animator.AnimatorListener
        public void onAnimationEnd(Animator animator) {
            ActionBarOverlayLayout actionBarOverlayLayout = ActionBarOverlayLayout.this;
            actionBarOverlayLayout.G = null;
            actionBarOverlayLayout.f1329q = false;
        }
    }

    /* loaded from: classes.dex */
    class b implements Runnable {
        b() {
        }

        @Override // java.lang.Runnable
        public void run() {
            ActionBarOverlayLayout.this.u();
            ActionBarOverlayLayout actionBarOverlayLayout = ActionBarOverlayLayout.this;
            actionBarOverlayLayout.G = actionBarOverlayLayout.f1322j.animate().translationY(0.0f).setListener(ActionBarOverlayLayout.this.H);
        }
    }

    /* loaded from: classes.dex */
    class c implements Runnable {
        c() {
        }

        @Override // java.lang.Runnable
        public void run() {
            ActionBarOverlayLayout.this.u();
            ActionBarOverlayLayout actionBarOverlayLayout = ActionBarOverlayLayout.this;
            actionBarOverlayLayout.G = actionBarOverlayLayout.f1322j.animate().translationY(-ActionBarOverlayLayout.this.f1322j.getHeight()).setListener(ActionBarOverlayLayout.this.H);
        }
    }

    /* loaded from: classes.dex */
    public interface d {
        void a();

        void b();

        void c(boolean z9);

        void d();

        void e();

        void onWindowVisibilityChanged(int i10);
    }

    /* loaded from: classes.dex */
    public static class e extends ViewGroup.MarginLayoutParams {
        public e(int i10, int i11) {
            super(i10, i11);
        }

        public e(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public e(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }
    }

    public ActionBarOverlayLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.f1320h = 0;
        this.f1332t = new Rect();
        this.f1333u = new Rect();
        this.f1334v = new Rect();
        this.f1335w = new Rect();
        this.f1336x = new Rect();
        this.f1337y = new Rect();
        this.f1338z = new Rect();
        y2 y2Var = y2.f2305b;
        this.A = y2Var;
        this.B = y2Var;
        this.C = y2Var;
        this.D = y2Var;
        this.H = new a();
        this.I = new b();
        this.J = new c();
        v(context);
        this.K = new androidx.core.view.i0(this);
    }

    private void A() {
        u();
        this.I.run();
    }

    private boolean B(float f10) {
        this.F.fling(0, 0, 0, (int) f10, 0, 0, RecyclerView.UNDEFINED_DURATION, Integer.MAX_VALUE);
        return this.F.getFinalY() > this.f1322j.getHeight();
    }

    private void p() {
        u();
        this.J.run();
    }

    /* JADX WARN: Removed duplicated region for block: B:13:0x0021  */
    /* JADX WARN: Removed duplicated region for block: B:17:0x002c  */
    /* JADX WARN: Removed duplicated region for block: B:9:0x0016  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    private boolean q(View view, Rect rect, boolean z9, boolean z10, boolean z11, boolean z12) {
        boolean z13;
        e eVar = (e) view.getLayoutParams();
        if (z9) {
            int i10 = ((ViewGroup.MarginLayoutParams) eVar).leftMargin;
            int i11 = rect.left;
            if (i10 != i11) {
                ((ViewGroup.MarginLayoutParams) eVar).leftMargin = i11;
                z13 = true;
                if (z10) {
                    int i12 = ((ViewGroup.MarginLayoutParams) eVar).topMargin;
                    int i13 = rect.top;
                    if (i12 != i13) {
                        ((ViewGroup.MarginLayoutParams) eVar).topMargin = i13;
                        z13 = true;
                    }
                }
                if (z12) {
                    int i14 = ((ViewGroup.MarginLayoutParams) eVar).rightMargin;
                    int i15 = rect.right;
                    if (i14 != i15) {
                        ((ViewGroup.MarginLayoutParams) eVar).rightMargin = i15;
                        z13 = true;
                    }
                }
                if (z11) {
                    int i16 = ((ViewGroup.MarginLayoutParams) eVar).bottomMargin;
                    int i17 = rect.bottom;
                    if (i16 != i17) {
                        ((ViewGroup.MarginLayoutParams) eVar).bottomMargin = i17;
                        return true;
                    }
                }
                return z13;
            }
        }
        z13 = false;
        if (z10) {
        }
        if (z12) {
        }
        if (z11) {
        }
        return z13;
    }

    private l1 t(View view) {
        if (view instanceof l1) {
            return (l1) view;
        }
        if (view instanceof Toolbar) {
            return ((Toolbar) view).getWrapper();
        }
        throw new IllegalStateException("Can't make a decor toolbar out of " + view.getClass().getSimpleName());
    }

    private void v(Context context) {
        TypedArray obtainStyledAttributes = getContext().getTheme().obtainStyledAttributes(L);
        this.f1319g = obtainStyledAttributes.getDimensionPixelSize(0, 0);
        Drawable drawable = obtainStyledAttributes.getDrawable(1);
        this.f1324l = drawable;
        setWillNotDraw(drawable == null);
        obtainStyledAttributes.recycle();
        this.f1325m = context.getApplicationInfo().targetSdkVersion < 19;
        this.F = new OverScroller(context);
    }

    private void x() {
        u();
        postDelayed(this.J, 600L);
    }

    private void y() {
        u();
        postDelayed(this.I, 600L);
    }

    @Override // androidx.appcompat.widget.k1
    public void a(Menu menu, m.a aVar) {
        z();
        this.f1323k.a(menu, aVar);
    }

    @Override // androidx.appcompat.widget.k1
    public boolean b() {
        z();
        return this.f1323k.b();
    }

    @Override // androidx.appcompat.widget.k1
    public void c() {
        z();
        this.f1323k.c();
    }

    @Override // android.view.ViewGroup
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof e;
    }

    @Override // androidx.appcompat.widget.k1
    public boolean d() {
        z();
        return this.f1323k.d();
    }

    @Override // android.view.View
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.f1324l == null || this.f1325m) {
            return;
        }
        int bottom = this.f1322j.getVisibility() == 0 ? (int) (this.f1322j.getBottom() + this.f1322j.getTranslationY() + 0.5f) : 0;
        this.f1324l.setBounds(0, bottom, getWidth(), this.f1324l.getIntrinsicHeight() + bottom);
        this.f1324l.draw(canvas);
    }

    @Override // androidx.appcompat.widget.k1
    public boolean e() {
        z();
        return this.f1323k.e();
    }

    @Override // androidx.appcompat.widget.k1
    public boolean f() {
        z();
        return this.f1323k.f();
    }

    @Override // android.view.View
    protected boolean fitSystemWindows(Rect rect) {
        return super.fitSystemWindows(rect);
    }

    @Override // androidx.appcompat.widget.k1
    public boolean g() {
        z();
        return this.f1323k.g();
    }

    @Override // android.view.ViewGroup
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new e(layoutParams);
    }

    public int getActionBarHideOffset() {
        ActionBarContainer actionBarContainer = this.f1322j;
        if (actionBarContainer != null) {
            return -((int) actionBarContainer.getTranslationY());
        }
        return 0;
    }

    @Override // android.view.ViewGroup
    public int getNestedScrollAxes() {
        return this.K.a();
    }

    public CharSequence getTitle() {
        z();
        return this.f1323k.getTitle();
    }

    @Override // androidx.appcompat.widget.k1
    public void h(int i10) {
        z();
        if (i10 == 2) {
            this.f1323k.r();
        } else if (i10 == 5) {
            this.f1323k.s();
        } else if (i10 != 109) {
        } else {
            setOverlayMode(true);
        }
    }

    @Override // androidx.appcompat.widget.k1
    public void i() {
        z();
        this.f1323k.h();
    }

    @Override // androidx.core.view.h0
    public void j(View view, int i10, int i11, int i12, int i13, int i14, int[] iArr) {
        k(view, i10, i11, i12, i13, i14);
    }

    @Override // androidx.core.view.g0
    public void k(View view, int i10, int i11, int i12, int i13, int i14) {
        if (i14 == 0) {
            onNestedScroll(view, i10, i11, i12, i13);
        }
    }

    @Override // androidx.core.view.g0
    public boolean l(View view, View view2, int i10, int i11) {
        return i11 == 0 && onStartNestedScroll(view, view2, i10);
    }

    @Override // androidx.core.view.g0
    public void m(View view, View view2, int i10, int i11) {
        if (i11 == 0) {
            onNestedScrollAccepted(view, view2, i10);
        }
    }

    @Override // androidx.core.view.g0
    public void n(View view, int i10) {
        if (i10 == 0) {
            onStopNestedScroll(view);
        }
    }

    @Override // androidx.core.view.g0
    public void o(View view, int i10, int i11, int[] iArr, int i12) {
        if (i12 == 0) {
            onNestedPreScroll(view, i10, i11, iArr);
        }
    }

    @Override // android.view.View
    public WindowInsets onApplyWindowInsets(WindowInsets windowInsets) {
        z();
        y2 v9 = y2.v(windowInsets, this);
        boolean q10 = q(this.f1322j, new Rect(v9.i(), v9.k(), v9.j(), v9.h()), true, true, false, true);
        androidx.core.view.r0.g(this, v9, this.f1332t);
        Rect rect = this.f1332t;
        y2 l10 = v9.l(rect.left, rect.top, rect.right, rect.bottom);
        this.A = l10;
        boolean z9 = true;
        if (!this.B.equals(l10)) {
            this.B = this.A;
            q10 = true;
        }
        if (this.f1333u.equals(this.f1332t)) {
            z9 = q10;
        } else {
            this.f1333u.set(this.f1332t);
        }
        if (z9) {
            requestLayout();
        }
        return v9.a().c().b().t();
    }

    @Override // android.view.View
    protected void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        v(getContext());
        androidx.core.view.r0.k0(this);
    }

    @Override // android.view.ViewGroup, android.view.View
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        u();
    }

    @Override // android.view.ViewGroup, android.view.View
    protected void onLayout(boolean z9, int i10, int i11, int i12, int i13) {
        int childCount = getChildCount();
        int paddingLeft = getPaddingLeft();
        int paddingTop = getPaddingTop();
        for (int i14 = 0; i14 < childCount; i14++) {
            View childAt = getChildAt(i14);
            if (childAt.getVisibility() != 8) {
                e eVar = (e) childAt.getLayoutParams();
                int measuredWidth = childAt.getMeasuredWidth();
                int measuredHeight = childAt.getMeasuredHeight();
                int i15 = ((ViewGroup.MarginLayoutParams) eVar).leftMargin + paddingLeft;
                int i16 = ((ViewGroup.MarginLayoutParams) eVar).topMargin + paddingTop;
                childAt.layout(i15, i16, measuredWidth + i15, measuredHeight + i16);
            }
        }
    }

    @Override // android.view.View
    protected void onMeasure(int i10, int i11) {
        int measuredHeight;
        y2 a10;
        z();
        measureChildWithMargins(this.f1322j, i10, 0, i11, 0);
        e eVar = (e) this.f1322j.getLayoutParams();
        int max = Math.max(0, this.f1322j.getMeasuredWidth() + ((ViewGroup.MarginLayoutParams) eVar).leftMargin + ((ViewGroup.MarginLayoutParams) eVar).rightMargin);
        int max2 = Math.max(0, this.f1322j.getMeasuredHeight() + ((ViewGroup.MarginLayoutParams) eVar).topMargin + ((ViewGroup.MarginLayoutParams) eVar).bottomMargin);
        int combineMeasuredStates = View.combineMeasuredStates(0, this.f1322j.getMeasuredState());
        boolean z9 = (androidx.core.view.r0.K(this) & 256) != 0;
        if (z9) {
            measuredHeight = this.f1319g;
            if (this.f1327o && this.f1322j.getTabContainer() != null) {
                measuredHeight += this.f1319g;
            }
        } else {
            measuredHeight = this.f1322j.getVisibility() != 8 ? this.f1322j.getMeasuredHeight() : 0;
        }
        this.f1334v.set(this.f1332t);
        y2 y2Var = this.A;
        this.C = y2Var;
        if (this.f1326n || z9) {
            a10 = new y2.b(this.C).c(androidx.core.graphics.b.b(y2Var.i(), this.C.k() + measuredHeight, this.C.j(), this.C.h() + 0)).a();
        } else {
            Rect rect = this.f1334v;
            rect.top += measuredHeight;
            rect.bottom += 0;
            a10 = y2Var.l(0, measuredHeight, 0, 0);
        }
        this.C = a10;
        q(this.f1321i, this.f1334v, true, true, true, true);
        if (!this.D.equals(this.C)) {
            y2 y2Var2 = this.C;
            this.D = y2Var2;
            androidx.core.view.r0.h(this.f1321i, y2Var2);
        }
        measureChildWithMargins(this.f1321i, i10, 0, i11, 0);
        e eVar2 = (e) this.f1321i.getLayoutParams();
        int max3 = Math.max(max, this.f1321i.getMeasuredWidth() + ((ViewGroup.MarginLayoutParams) eVar2).leftMargin + ((ViewGroup.MarginLayoutParams) eVar2).rightMargin);
        int max4 = Math.max(max2, this.f1321i.getMeasuredHeight() + ((ViewGroup.MarginLayoutParams) eVar2).topMargin + ((ViewGroup.MarginLayoutParams) eVar2).bottomMargin);
        int combineMeasuredStates2 = View.combineMeasuredStates(combineMeasuredStates, this.f1321i.getMeasuredState());
        setMeasuredDimension(View.resolveSizeAndState(Math.max(max3 + getPaddingLeft() + getPaddingRight(), getSuggestedMinimumWidth()), i10, combineMeasuredStates2), View.resolveSizeAndState(Math.max(max4 + getPaddingTop() + getPaddingBottom(), getSuggestedMinimumHeight()), i11, combineMeasuredStates2 << 16));
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public boolean onNestedFling(View view, float f10, float f11, boolean z9) {
        if (this.f1328p && z9) {
            if (B(f11)) {
                p();
            } else {
                A();
            }
            this.f1329q = true;
            return true;
        }
        return false;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public boolean onNestedPreFling(View view, float f10, float f11) {
        return false;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public void onNestedPreScroll(View view, int i10, int i11, int[] iArr) {
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public void onNestedScroll(View view, int i10, int i11, int i12, int i13) {
        int i14 = this.f1330r + i11;
        this.f1330r = i14;
        setActionBarHideOffset(i14);
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public void onNestedScrollAccepted(View view, View view2, int i10) {
        this.K.b(view, view2, i10);
        this.f1330r = getActionBarHideOffset();
        u();
        d dVar = this.E;
        if (dVar != null) {
            dVar.e();
        }
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public boolean onStartNestedScroll(View view, View view2, int i10) {
        if ((i10 & 2) == 0 || this.f1322j.getVisibility() != 0) {
            return false;
        }
        return this.f1328p;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public void onStopNestedScroll(View view) {
        if (this.f1328p && !this.f1329q) {
            if (this.f1330r <= this.f1322j.getHeight()) {
                y();
            } else {
                x();
            }
        }
        d dVar = this.E;
        if (dVar != null) {
            dVar.b();
        }
    }

    @Override // android.view.View
    public void onWindowSystemUiVisibilityChanged(int i10) {
        super.onWindowSystemUiVisibilityChanged(i10);
        z();
        int i11 = this.f1331s ^ i10;
        this.f1331s = i10;
        boolean z9 = (i10 & 4) == 0;
        boolean z10 = (i10 & 256) != 0;
        d dVar = this.E;
        if (dVar != null) {
            dVar.c(!z10);
            if (z9 || !z10) {
                this.E.a();
            } else {
                this.E.d();
            }
        }
        if ((i11 & 256) == 0 || this.E == null) {
            return;
        }
        androidx.core.view.r0.k0(this);
    }

    @Override // android.view.View
    protected void onWindowVisibilityChanged(int i10) {
        super.onWindowVisibilityChanged(i10);
        this.f1320h = i10;
        d dVar = this.E;
        if (dVar != null) {
            dVar.onWindowVisibilityChanged(i10);
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // android.view.ViewGroup
    /* renamed from: r */
    public e generateDefaultLayoutParams() {
        return new e(-1, -1);
    }

    @Override // android.view.ViewGroup
    /* renamed from: s */
    public e generateLayoutParams(AttributeSet attributeSet) {
        return new e(getContext(), attributeSet);
    }

    public void setActionBarHideOffset(int i10) {
        u();
        this.f1322j.setTranslationY(-Math.max(0, Math.min(i10, this.f1322j.getHeight())));
    }

    public void setActionBarVisibilityCallback(d dVar) {
        this.E = dVar;
        if (getWindowToken() != null) {
            this.E.onWindowVisibilityChanged(this.f1320h);
            int i10 = this.f1331s;
            if (i10 != 0) {
                onWindowSystemUiVisibilityChanged(i10);
                androidx.core.view.r0.k0(this);
            }
        }
    }

    public void setHasNonEmbeddedTabs(boolean z9) {
        this.f1327o = z9;
    }

    public void setHideOnContentScrollEnabled(boolean z9) {
        if (z9 != this.f1328p) {
            this.f1328p = z9;
            if (z9) {
                return;
            }
            u();
            setActionBarHideOffset(0);
        }
    }

    public void setIcon(int i10) {
        z();
        this.f1323k.setIcon(i10);
    }

    public void setIcon(Drawable drawable) {
        z();
        this.f1323k.setIcon(drawable);
    }

    public void setLogo(int i10) {
        z();
        this.f1323k.l(i10);
    }

    public void setOverlayMode(boolean z9) {
        this.f1326n = z9;
        this.f1325m = z9 && getContext().getApplicationInfo().targetSdkVersion < 19;
    }

    public void setShowingForActionMode(boolean z9) {
    }

    public void setUiOptions(int i10) {
    }

    @Override // androidx.appcompat.widget.k1
    public void setWindowCallback(Window.Callback callback) {
        z();
        this.f1323k.setWindowCallback(callback);
    }

    @Override // androidx.appcompat.widget.k1
    public void setWindowTitle(CharSequence charSequence) {
        z();
        this.f1323k.setWindowTitle(charSequence);
    }

    @Override // android.view.ViewGroup
    public boolean shouldDelayChildPressedState() {
        return false;
    }

    void u() {
        removeCallbacks(this.I);
        removeCallbacks(this.J);
        ViewPropertyAnimator viewPropertyAnimator = this.G;
        if (viewPropertyAnimator != null) {
            viewPropertyAnimator.cancel();
        }
    }

    public boolean w() {
        return this.f1326n;
    }

    void z() {
        if (this.f1321i == null) {
            this.f1321i = (ContentFrameLayout) findViewById(g.f.action_bar_activity_content);
            this.f1322j = (ActionBarContainer) findViewById(g.f.action_bar_container);
            this.f1323k = t(findViewById(g.f.action_bar));
        }
    }
}
