package androidx.appcompat.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
/* loaded from: classes.dex */
public class ActionBarContextView extends androidx.appcompat.widget.a {

    /* renamed from: o  reason: collision with root package name */
    private CharSequence f1305o;

    /* renamed from: p  reason: collision with root package name */
    private CharSequence f1306p;

    /* renamed from: q  reason: collision with root package name */
    private View f1307q;

    /* renamed from: r  reason: collision with root package name */
    private View f1308r;

    /* renamed from: s  reason: collision with root package name */
    private View f1309s;

    /* renamed from: t  reason: collision with root package name */
    private LinearLayout f1310t;

    /* renamed from: u  reason: collision with root package name */
    private TextView f1311u;

    /* renamed from: v  reason: collision with root package name */
    private TextView f1312v;

    /* renamed from: w  reason: collision with root package name */
    private int f1313w;

    /* renamed from: x  reason: collision with root package name */
    private int f1314x;

    /* renamed from: y  reason: collision with root package name */
    private boolean f1315y;

    /* renamed from: z  reason: collision with root package name */
    private int f1316z;

    /* loaded from: classes.dex */
    class a implements View.OnClickListener {

        /* renamed from: g  reason: collision with root package name */
        final /* synthetic */ androidx.appcompat.view.b f1317g;

        a(androidx.appcompat.view.b bVar) {
            this.f1317g = bVar;
        }

        @Override // android.view.View.OnClickListener
        public void onClick(View view) {
            this.f1317g.c();
        }
    }

    public ActionBarContextView(Context context) {
        this(context, null);
    }

    public ActionBarContextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, g.a.actionModeStyle);
    }

    public ActionBarContextView(Context context, AttributeSet attributeSet, int i10) {
        super(context, attributeSet, i10);
        k2 v9 = k2.v(context, attributeSet, g.j.f7891y, i10, 0);
        androidx.core.view.r0.r0(this, v9.g(g.j.f7896z));
        this.f1313w = v9.n(g.j.D, 0);
        this.f1314x = v9.n(g.j.C, 0);
        this.f1463k = v9.m(g.j.B, 0);
        this.f1316z = v9.n(g.j.A, g.g.abc_action_mode_close_item_material);
        v9.w();
    }

    private void i() {
        if (this.f1310t == null) {
            LayoutInflater.from(getContext()).inflate(g.g.abc_action_bar_title_item, this);
            LinearLayout linearLayout = (LinearLayout) getChildAt(getChildCount() - 1);
            this.f1310t = linearLayout;
            this.f1311u = (TextView) linearLayout.findViewById(g.f.action_bar_title);
            this.f1312v = (TextView) this.f1310t.findViewById(g.f.action_bar_subtitle);
            if (this.f1313w != 0) {
                this.f1311u.setTextAppearance(getContext(), this.f1313w);
            }
            if (this.f1314x != 0) {
                this.f1312v.setTextAppearance(getContext(), this.f1314x);
            }
        }
        this.f1311u.setText(this.f1305o);
        this.f1312v.setText(this.f1306p);
        boolean z9 = !TextUtils.isEmpty(this.f1305o);
        boolean z10 = !TextUtils.isEmpty(this.f1306p);
        int i10 = 0;
        this.f1312v.setVisibility(z10 ? 0 : 8);
        LinearLayout linearLayout2 = this.f1310t;
        if (!z9 && !z10) {
            i10 = 8;
        }
        linearLayout2.setVisibility(i10);
        if (this.f1310t.getParent() == null) {
            addView(this.f1310t);
        }
    }

    @Override // androidx.appcompat.widget.a
    public /* bridge */ /* synthetic */ androidx.core.view.u2 f(int i10, long j10) {
        return super.f(i10, j10);
    }

    public void g() {
        if (this.f1307q == null) {
            k();
        }
    }

    @Override // android.view.ViewGroup
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-1, -2);
    }

    @Override // android.view.ViewGroup
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new ViewGroup.MarginLayoutParams(getContext(), attributeSet);
    }

    @Override // androidx.appcompat.widget.a
    public /* bridge */ /* synthetic */ int getAnimatedVisibility() {
        return super.getAnimatedVisibility();
    }

    @Override // androidx.appcompat.widget.a
    public /* bridge */ /* synthetic */ int getContentHeight() {
        return super.getContentHeight();
    }

    public CharSequence getSubtitle() {
        return this.f1306p;
    }

    public CharSequence getTitle() {
        return this.f1305o;
    }

    /* JADX WARN: Removed duplicated region for block: B:11:0x003e  */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public void h(androidx.appcompat.view.b bVar) {
        View view;
        c cVar;
        View view2 = this.f1307q;
        if (view2 != null) {
            if (view2.getParent() == null) {
                view = this.f1307q;
            }
            View findViewById = this.f1307q.findViewById(g.f.action_mode_close_button);
            this.f1308r = findViewById;
            findViewById.setOnClickListener(new a(bVar));
            androidx.appcompat.view.menu.g gVar = (androidx.appcompat.view.menu.g) bVar.e();
            cVar = this.f1462j;
            if (cVar != null) {
                cVar.y();
            }
            c cVar2 = new c(getContext());
            this.f1462j = cVar2;
            cVar2.J(true);
            ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -1);
            gVar.c(this.f1462j, this.f1460h);
            ActionMenuView actionMenuView = (ActionMenuView) this.f1462j.o(this);
            this.f1461i = actionMenuView;
            androidx.core.view.r0.r0(actionMenuView, null);
            addView(this.f1461i, layoutParams);
        }
        view = LayoutInflater.from(getContext()).inflate(this.f1316z, (ViewGroup) this, false);
        this.f1307q = view;
        addView(view);
        View findViewById2 = this.f1307q.findViewById(g.f.action_mode_close_button);
        this.f1308r = findViewById2;
        findViewById2.setOnClickListener(new a(bVar));
        androidx.appcompat.view.menu.g gVar2 = (androidx.appcompat.view.menu.g) bVar.e();
        cVar = this.f1462j;
        if (cVar != null) {
        }
        c cVar22 = new c(getContext());
        this.f1462j = cVar22;
        cVar22.J(true);
        ViewGroup.LayoutParams layoutParams2 = new ViewGroup.LayoutParams(-2, -1);
        gVar2.c(this.f1462j, this.f1460h);
        ActionMenuView actionMenuView2 = (ActionMenuView) this.f1462j.o(this);
        this.f1461i = actionMenuView2;
        androidx.core.view.r0.r0(actionMenuView2, null);
        addView(this.f1461i, layoutParams2);
    }

    public boolean j() {
        return this.f1315y;
    }

    public void k() {
        removeAllViews();
        this.f1309s = null;
        this.f1461i = null;
        this.f1462j = null;
        View view = this.f1308r;
        if (view != null) {
            view.setOnClickListener(null);
        }
    }

    public boolean l() {
        c cVar = this.f1462j;
        if (cVar != null) {
            return cVar.K();
        }
        return false;
    }

    @Override // android.view.ViewGroup, android.view.View
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        c cVar = this.f1462j;
        if (cVar != null) {
            cVar.B();
            this.f1462j.C();
        }
    }

    @Override // androidx.appcompat.widget.a, android.view.View
    public /* bridge */ /* synthetic */ boolean onHoverEvent(MotionEvent motionEvent) {
        return super.onHoverEvent(motionEvent);
    }

    @Override // android.view.ViewGroup, android.view.View
    protected void onLayout(boolean z9, int i10, int i11, int i12, int i13) {
        boolean b10 = w2.b(this);
        int paddingRight = b10 ? (i12 - i10) - getPaddingRight() : getPaddingLeft();
        int paddingTop = getPaddingTop();
        int paddingTop2 = ((i13 - i11) - getPaddingTop()) - getPaddingBottom();
        View view = this.f1307q;
        if (view != null && view.getVisibility() != 8) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) this.f1307q.getLayoutParams();
            int i14 = b10 ? marginLayoutParams.rightMargin : marginLayoutParams.leftMargin;
            int i15 = b10 ? marginLayoutParams.leftMargin : marginLayoutParams.rightMargin;
            int d10 = androidx.appcompat.widget.a.d(paddingRight, i14, b10);
            paddingRight = androidx.appcompat.widget.a.d(d10 + e(this.f1307q, d10, paddingTop, paddingTop2, b10), i15, b10);
        }
        int i16 = paddingRight;
        LinearLayout linearLayout = this.f1310t;
        if (linearLayout != null && this.f1309s == null && linearLayout.getVisibility() != 8) {
            i16 += e(this.f1310t, i16, paddingTop, paddingTop2, b10);
        }
        int i17 = i16;
        View view2 = this.f1309s;
        if (view2 != null) {
            e(view2, i17, paddingTop, paddingTop2, b10);
        }
        int paddingLeft = b10 ? getPaddingLeft() : (i12 - i10) - getPaddingRight();
        ActionMenuView actionMenuView = this.f1461i;
        if (actionMenuView != null) {
            e(actionMenuView, paddingLeft, paddingTop, paddingTop2, !b10);
        }
    }

    @Override // android.view.View
    protected void onMeasure(int i10, int i11) {
        if (View.MeasureSpec.getMode(i10) != 1073741824) {
            throw new IllegalStateException(getClass().getSimpleName() + " can only be used with android:layout_width=\"match_parent\" (or fill_parent)");
        } else if (View.MeasureSpec.getMode(i11) == 0) {
            throw new IllegalStateException(getClass().getSimpleName() + " can only be used with android:layout_height=\"wrap_content\"");
        } else {
            int size = View.MeasureSpec.getSize(i10);
            int i12 = this.f1463k;
            if (i12 <= 0) {
                i12 = View.MeasureSpec.getSize(i11);
            }
            int paddingTop = getPaddingTop() + getPaddingBottom();
            int paddingLeft = (size - getPaddingLeft()) - getPaddingRight();
            int i13 = i12 - paddingTop;
            int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(i13, RecyclerView.UNDEFINED_DURATION);
            View view = this.f1307q;
            if (view != null) {
                int c10 = c(view, paddingLeft, makeMeasureSpec, 0);
                ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) this.f1307q.getLayoutParams();
                paddingLeft = c10 - (marginLayoutParams.leftMargin + marginLayoutParams.rightMargin);
            }
            ActionMenuView actionMenuView = this.f1461i;
            if (actionMenuView != null && actionMenuView.getParent() == this) {
                paddingLeft = c(this.f1461i, paddingLeft, makeMeasureSpec, 0);
            }
            LinearLayout linearLayout = this.f1310t;
            if (linearLayout != null && this.f1309s == null) {
                if (this.f1315y) {
                    this.f1310t.measure(View.MeasureSpec.makeMeasureSpec(0, 0), makeMeasureSpec);
                    int measuredWidth = this.f1310t.getMeasuredWidth();
                    boolean z9 = measuredWidth <= paddingLeft;
                    if (z9) {
                        paddingLeft -= measuredWidth;
                    }
                    this.f1310t.setVisibility(z9 ? 0 : 8);
                } else {
                    paddingLeft = c(linearLayout, paddingLeft, makeMeasureSpec, 0);
                }
            }
            View view2 = this.f1309s;
            if (view2 != null) {
                ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
                int i14 = layoutParams.width;
                int i15 = i14 != -2 ? 1073741824 : RecyclerView.UNDEFINED_DURATION;
                if (i14 >= 0) {
                    paddingLeft = Math.min(i14, paddingLeft);
                }
                int i16 = layoutParams.height;
                int i17 = i16 == -2 ? RecyclerView.UNDEFINED_DURATION : 1073741824;
                if (i16 >= 0) {
                    i13 = Math.min(i16, i13);
                }
                this.f1309s.measure(View.MeasureSpec.makeMeasureSpec(paddingLeft, i15), View.MeasureSpec.makeMeasureSpec(i13, i17));
            }
            if (this.f1463k > 0) {
                setMeasuredDimension(size, i12);
                return;
            }
            int childCount = getChildCount();
            int i18 = 0;
            for (int i19 = 0; i19 < childCount; i19++) {
                int measuredHeight = getChildAt(i19).getMeasuredHeight() + paddingTop;
                if (measuredHeight > i18) {
                    i18 = measuredHeight;
                }
            }
            setMeasuredDimension(size, i18);
        }
    }

    @Override // androidx.appcompat.widget.a, android.view.View
    public /* bridge */ /* synthetic */ boolean onTouchEvent(MotionEvent motionEvent) {
        return super.onTouchEvent(motionEvent);
    }

    @Override // androidx.appcompat.widget.a
    public void setContentHeight(int i10) {
        this.f1463k = i10;
    }

    public void setCustomView(View view) {
        LinearLayout linearLayout;
        View view2 = this.f1309s;
        if (view2 != null) {
            removeView(view2);
        }
        this.f1309s = view;
        if (view != null && (linearLayout = this.f1310t) != null) {
            removeView(linearLayout);
            this.f1310t = null;
        }
        if (view != null) {
            addView(view);
        }
        requestLayout();
    }

    public void setSubtitle(CharSequence charSequence) {
        this.f1306p = charSequence;
        i();
    }

    public void setTitle(CharSequence charSequence) {
        this.f1305o = charSequence;
        i();
        androidx.core.view.r0.q0(this, charSequence);
    }

    public void setTitleOptional(boolean z9) {
        if (z9 != this.f1315y) {
            requestLayout();
        }
        this.f1315y = z9;
    }

    @Override // androidx.appcompat.widget.a, android.view.View
    public /* bridge */ /* synthetic */ void setVisibility(int i10) {
        super.setVisibility(i10);
    }

    @Override // android.view.ViewGroup
    public boolean shouldDelayChildPressedState() {
        return false;
    }
}
