package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ActionMode;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import androidx.recyclerview.widget.RecyclerView;
/* loaded from: classes.dex */
public class ActionBarContainer extends FrameLayout {

    /* renamed from: g  reason: collision with root package name */
    private boolean f1295g;

    /* renamed from: h  reason: collision with root package name */
    private View f1296h;

    /* renamed from: i  reason: collision with root package name */
    private View f1297i;

    /* renamed from: j  reason: collision with root package name */
    private View f1298j;

    /* renamed from: k  reason: collision with root package name */
    Drawable f1299k;

    /* renamed from: l  reason: collision with root package name */
    Drawable f1300l;

    /* renamed from: m  reason: collision with root package name */
    Drawable f1301m;

    /* renamed from: n  reason: collision with root package name */
    boolean f1302n;

    /* renamed from: o  reason: collision with root package name */
    boolean f1303o;

    /* renamed from: p  reason: collision with root package name */
    private int f1304p;

    /* loaded from: classes.dex */
    private static class a {
        public static void a(ActionBarContainer actionBarContainer) {
            actionBarContainer.invalidateOutline();
        }
    }

    public ActionBarContainer(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        androidx.core.view.r0.r0(this, new b(this));
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, g.j.f7771a);
        this.f1299k = obtainStyledAttributes.getDrawable(g.j.f7776b);
        this.f1300l = obtainStyledAttributes.getDrawable(g.j.f7786d);
        this.f1304p = obtainStyledAttributes.getDimensionPixelSize(g.j.f7816j, -1);
        boolean z9 = true;
        if (getId() == g.f.split_action_bar) {
            this.f1302n = true;
            this.f1301m = obtainStyledAttributes.getDrawable(g.j.f7781c);
        }
        obtainStyledAttributes.recycle();
        if (!this.f1302n ? this.f1299k != null || this.f1300l != null : this.f1301m != null) {
            z9 = false;
        }
        setWillNotDraw(z9);
    }

    private int a(View view) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) view.getLayoutParams();
        return view.getMeasuredHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
    }

    private boolean b(View view) {
        return view == null || view.getVisibility() == 8 || view.getMeasuredHeight() == 0;
    }

    @Override // android.view.ViewGroup, android.view.View
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable drawable = this.f1299k;
        if (drawable != null && drawable.isStateful()) {
            this.f1299k.setState(getDrawableState());
        }
        Drawable drawable2 = this.f1300l;
        if (drawable2 != null && drawable2.isStateful()) {
            this.f1300l.setState(getDrawableState());
        }
        Drawable drawable3 = this.f1301m;
        if (drawable3 == null || !drawable3.isStateful()) {
            return;
        }
        this.f1301m.setState(getDrawableState());
    }

    public View getTabContainer() {
        return this.f1296h;
    }

    @Override // android.view.ViewGroup, android.view.View
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        Drawable drawable = this.f1299k;
        if (drawable != null) {
            drawable.jumpToCurrentState();
        }
        Drawable drawable2 = this.f1300l;
        if (drawable2 != null) {
            drawable2.jumpToCurrentState();
        }
        Drawable drawable3 = this.f1301m;
        if (drawable3 != null) {
            drawable3.jumpToCurrentState();
        }
    }

    @Override // android.view.View
    public void onFinishInflate() {
        super.onFinishInflate();
        this.f1297i = findViewById(g.f.action_bar);
        this.f1298j = findViewById(g.f.action_context_bar);
    }

    @Override // android.view.View
    public boolean onHoverEvent(MotionEvent motionEvent) {
        super.onHoverEvent(motionEvent);
        return true;
    }

    @Override // android.view.ViewGroup
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return this.f1295g || super.onInterceptTouchEvent(motionEvent);
    }

    @Override // android.widget.FrameLayout, android.view.ViewGroup, android.view.View
    public void onLayout(boolean z9, int i10, int i11, int i12, int i13) {
        Drawable drawable;
        Drawable drawable2;
        int left;
        int top;
        int right;
        View view;
        super.onLayout(z9, i10, i11, i12, i13);
        View view2 = this.f1296h;
        boolean z10 = true;
        boolean z11 = false;
        boolean z12 = (view2 == null || view2.getVisibility() == 8) ? false : true;
        if (view2 != null && view2.getVisibility() != 8) {
            int measuredHeight = getMeasuredHeight();
            int i14 = ((FrameLayout.LayoutParams) view2.getLayoutParams()).bottomMargin;
            view2.layout(i10, (measuredHeight - view2.getMeasuredHeight()) - i14, i12, measuredHeight - i14);
        }
        if (this.f1302n) {
            Drawable drawable3 = this.f1301m;
            if (drawable3 != null) {
                drawable3.setBounds(0, 0, getMeasuredWidth(), getMeasuredHeight());
            } else {
                z10 = false;
            }
        } else {
            if (this.f1299k != null) {
                if (this.f1297i.getVisibility() == 0) {
                    drawable2 = this.f1299k;
                    left = this.f1297i.getLeft();
                    top = this.f1297i.getTop();
                    right = this.f1297i.getRight();
                    view = this.f1297i;
                } else {
                    View view3 = this.f1298j;
                    if (view3 == null || view3.getVisibility() != 0) {
                        this.f1299k.setBounds(0, 0, 0, 0);
                        z11 = true;
                    } else {
                        drawable2 = this.f1299k;
                        left = this.f1298j.getLeft();
                        top = this.f1298j.getTop();
                        right = this.f1298j.getRight();
                        view = this.f1298j;
                    }
                }
                drawable2.setBounds(left, top, right, view.getBottom());
                z11 = true;
            }
            this.f1303o = z12;
            if (!z12 || (drawable = this.f1300l) == null) {
                z10 = z11;
            } else {
                drawable.setBounds(view2.getLeft(), view2.getTop(), view2.getRight(), view2.getBottom());
            }
        }
        if (z10) {
            invalidate();
        }
    }

    /* JADX WARN: Removed duplicated region for block: B:27:0x0055  */
    /* JADX WARN: Removed duplicated region for block: B:28:0x005a  */
    @Override // android.widget.FrameLayout, android.view.View
    /*
        Code decompiled incorrectly, please refer to instructions dump.
    */
    public void onMeasure(int i10, int i11) {
        int i12;
        View view;
        int i13;
        if (this.f1297i == null && View.MeasureSpec.getMode(i11) == Integer.MIN_VALUE && (i13 = this.f1304p) >= 0) {
            i11 = View.MeasureSpec.makeMeasureSpec(Math.min(i13, View.MeasureSpec.getSize(i11)), RecyclerView.UNDEFINED_DURATION);
        }
        super.onMeasure(i10, i11);
        if (this.f1297i == null) {
            return;
        }
        int mode = View.MeasureSpec.getMode(i11);
        View view2 = this.f1296h;
        if (view2 == null || view2.getVisibility() == 8 || mode == 1073741824) {
            return;
        }
        if (!b(this.f1297i)) {
            view = this.f1297i;
        } else if (b(this.f1298j)) {
            i12 = 0;
            setMeasuredDimension(getMeasuredWidth(), Math.min(i12 + a(this.f1296h), mode != Integer.MIN_VALUE ? View.MeasureSpec.getSize(i11) : Integer.MAX_VALUE));
        } else {
            view = this.f1298j;
        }
        i12 = a(view);
        setMeasuredDimension(getMeasuredWidth(), Math.min(i12 + a(this.f1296h), mode != Integer.MIN_VALUE ? View.MeasureSpec.getSize(i11) : Integer.MAX_VALUE));
    }

    @Override // android.view.View
    public boolean onTouchEvent(MotionEvent motionEvent) {
        super.onTouchEvent(motionEvent);
        return true;
    }

    public void setPrimaryBackground(Drawable drawable) {
        Drawable drawable2 = this.f1299k;
        if (drawable2 != null) {
            drawable2.setCallback(null);
            unscheduleDrawable(this.f1299k);
        }
        this.f1299k = drawable;
        if (drawable != null) {
            drawable.setCallback(this);
            View view = this.f1297i;
            if (view != null) {
                this.f1299k.setBounds(view.getLeft(), this.f1297i.getTop(), this.f1297i.getRight(), this.f1297i.getBottom());
            }
        }
        boolean z9 = true;
        if (!this.f1302n ? this.f1299k != null || this.f1300l != null : this.f1301m != null) {
            z9 = false;
        }
        setWillNotDraw(z9);
        invalidate();
        a.a(this);
    }

    public void setSplitBackground(Drawable drawable) {
        Drawable drawable2;
        Drawable drawable3 = this.f1301m;
        if (drawable3 != null) {
            drawable3.setCallback(null);
            unscheduleDrawable(this.f1301m);
        }
        this.f1301m = drawable;
        boolean z9 = false;
        if (drawable != null) {
            drawable.setCallback(this);
            if (this.f1302n && (drawable2 = this.f1301m) != null) {
                drawable2.setBounds(0, 0, getMeasuredWidth(), getMeasuredHeight());
            }
        }
        if (!this.f1302n ? !(this.f1299k != null || this.f1300l != null) : this.f1301m == null) {
            z9 = true;
        }
        setWillNotDraw(z9);
        invalidate();
        a.a(this);
    }

    public void setStackedBackground(Drawable drawable) {
        Drawable drawable2;
        Drawable drawable3 = this.f1300l;
        if (drawable3 != null) {
            drawable3.setCallback(null);
            unscheduleDrawable(this.f1300l);
        }
        this.f1300l = drawable;
        if (drawable != null) {
            drawable.setCallback(this);
            if (this.f1303o && (drawable2 = this.f1300l) != null) {
                drawable2.setBounds(this.f1296h.getLeft(), this.f1296h.getTop(), this.f1296h.getRight(), this.f1296h.getBottom());
            }
        }
        boolean z9 = true;
        if (!this.f1302n ? this.f1299k != null || this.f1300l != null : this.f1301m != null) {
            z9 = false;
        }
        setWillNotDraw(z9);
        invalidate();
        a.a(this);
    }

    public void setTabContainer(d2 d2Var) {
        View view = this.f1296h;
        if (view != null) {
            removeView(view);
        }
        this.f1296h = d2Var;
    }

    public void setTransitioning(boolean z9) {
        this.f1295g = z9;
        setDescendantFocusability(z9 ? 393216 : 262144);
    }

    @Override // android.view.View
    public void setVisibility(int i10) {
        super.setVisibility(i10);
        boolean z9 = i10 == 0;
        Drawable drawable = this.f1299k;
        if (drawable != null) {
            drawable.setVisible(z9, false);
        }
        Drawable drawable2 = this.f1300l;
        if (drawable2 != null) {
            drawable2.setVisible(z9, false);
        }
        Drawable drawable3 = this.f1301m;
        if (drawable3 != null) {
            drawable3.setVisible(z9, false);
        }
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public ActionMode startActionModeForChild(View view, ActionMode.Callback callback) {
        return null;
    }

    @Override // android.view.ViewGroup, android.view.ViewParent
    public ActionMode startActionModeForChild(View view, ActionMode.Callback callback, int i10) {
        if (i10 != 0) {
            return super.startActionModeForChild(view, callback, i10);
        }
        return null;
    }

    @Override // android.view.View
    protected boolean verifyDrawable(Drawable drawable) {
        return (drawable == this.f1299k && !this.f1302n) || (drawable == this.f1300l && this.f1303o) || ((drawable == this.f1301m && this.f1302n) || super.verifyDrawable(drawable));
    }
}
